/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.writers;

import java.io.File;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.LeveledManifest;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MajorLeveledCompactionWriter
extends CompactionAwareWriter {
    private static final Logger logger = LoggerFactory.getLogger(MajorLeveledCompactionWriter.class);
    private final long maxSSTableSize;
    private final long expectedWriteSize;
    private final Set<SSTableReader> allSSTables;
    private int currentLevel = 1;
    private long averageEstimatedKeysPerSSTable;
    private long partitionsWritten = 0L;
    private long totalWrittenInLevel = 0L;
    private int sstablesWritten = 0;

    public MajorLeveledCompactionWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, long maxSSTableSize) {
        this(cfs, directories, txn, nonExpiredSSTables, maxSSTableSize, false, false);
    }

    public MajorLeveledCompactionWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, long maxSSTableSize, boolean offline, boolean keepOriginals) {
        super(cfs, directories, txn, nonExpiredSSTables, offline, keepOriginals);
        this.maxSSTableSize = maxSSTableSize;
        this.allSSTables = txn.originals();
        this.expectedWriteSize = Math.min(maxSSTableSize, cfs.getExpectedCompactedFileSize(nonExpiredSSTables, txn.opType()));
    }

    @Override
    public boolean realAppend(UnfilteredRowIterator partition) {
        long posBefore = this.sstableWriter.currentWriter().getOnDiskFilePointer();
        RowIndexEntry rie = this.sstableWriter.append(partition);
        this.totalWrittenInLevel += this.sstableWriter.currentWriter().getOnDiskFilePointer() - posBefore;
        ++this.partitionsWritten;
        if (this.sstableWriter.currentWriter().getOnDiskFilePointer() > this.maxSSTableSize) {
            if (this.totalWrittenInLevel > LeveledManifest.maxBytesForLevel(this.currentLevel, this.maxSSTableSize)) {
                this.totalWrittenInLevel = 0L;
                ++this.currentLevel;
            }
            this.averageEstimatedKeysPerSSTable = Math.round(((double)this.averageEstimatedKeysPerSSTable * (double)this.sstablesWritten + (double)this.partitionsWritten) / (double)(this.sstablesWritten + 1));
            this.switchCompactionLocation(this.getWriteDirectory(this.expectedWriteSize));
            this.partitionsWritten = 0L;
            ++this.sstablesWritten;
        }
        return rie != null;
    }

    @Override
    public void switchCompactionLocation(Directories.DataDirectory directory) {
        File sstableDirectory = this.getDirectories().getLocationForDisk(directory);
        SSTableWriter writer = SSTableWriter.create(Descriptor.fromFilename(this.cfs.getSSTablePath(sstableDirectory)), this.averageEstimatedKeysPerSSTable, (Long)this.minRepairedAt, this.cfs.metadata, new MetadataCollector(this.allSSTables, this.cfs.metadata.comparator, this.currentLevel), SerializationHeader.make(this.cfs.metadata, this.nonExpiredSSTables), (LifecycleNewTracker)this.txn);
        this.sstableWriter.switchWriter(writer);
    }
}

