/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.tables;

import java.io.EOFException;
import java.io.IOException;
import org.caffinitas.ohc.tables.AbstractDataOutput;
import org.caffinitas.ohc.tables.Uns;

abstract class AbstractOffHeapDataOutput
extends AbstractDataOutput {
    long blkAdr;
    protected long blkOff;
    protected final long blkEnd;

    AbstractOffHeapDataOutput(long hashEntryAdr, long offset, long len) {
        if (hashEntryAdr == 0L || offset < 0L || len < 0L) {
            throw new IllegalArgumentException();
        }
        this.blkAdr = hashEntryAdr;
        this.blkOff = offset;
        this.blkEnd = this.blkOff + len;
    }

    protected void assertAvail(int req) throws IOException {
        if (this.avail() < (long)req || req < 0) {
            throw new EOFException();
        }
    }

    long avail() {
        return this.blkEnd - this.blkOff;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null || off < 0 || off + len > b.length || len < 0) {
            throw new IllegalArgumentException();
        }
        this.assertAvail(len);
        Uns.copyMemory(b, off, this.blkAdr, this.blkOff, (long)len);
        this.blkOff += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        this.assertAvail(1);
        Uns.putByte(this.blkAdr, this.blkOff++, (byte)b);
    }
}

