/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.elasticsearch.rest.client.it;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path("/elasticsearch-rest-client")
@ApplicationScoped
public class ElasticsearchRestClientResource {

    private static final Logger LOG = Logger.getLogger(ElasticsearchRestClientResource.class);

    private static final String COMPONENT_ELASTICSEARCH_REST_CLIENT = "elasticsearch-rest-client";
    @Inject
    CamelContext context;

    @Inject
    ProducerTemplate producerTemplate;

    @Path("/load/component/elasticsearch-rest-client")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentElasticsearchRestClient() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_ELASTICSEARCH_REST_CLIENT) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_ELASTICSEARCH_REST_CLIENT);
        return Response.status(500, COMPONENT_ELASTICSEARCH_REST_CLIENT + " could not be loaded from the Camel context")
                .build();
    }

    @Path("/index/{indexName}")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response createIndex(@PathParam("indexName") String indexName) throws ExecutionException, InterruptedException {
        String endpointUri = String.format(
                "elasticsearch-rest-client:my-cluster?operation=CREATE_INDEX&indexName=%s", indexName);
        CompletableFuture<Boolean> ack = producerTemplate.asyncRequestBody(endpointUri, null, Boolean.class);
        Boolean response = ack.get();

        if (response) {
            return Response.ok().build();
        }
        return Response.status(500, "Could not create index")
                .build();
    }
}
