/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.iec60870.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.apache.camel.CamelContext;
import org.jboss.logging.Logger;

@Path("/iec60870")
@ApplicationScoped
public class Iec60870Resource {

    private static final Logger LOG = Logger.getLogger(Iec60870Resource.class);

    private static final String COMPONENT_IEC60870_CLIENT = "iec60870-client";
    private static final String COMPONENT_IEC60870_SERVER = "iec60870-server";
    @Inject
    CamelContext context;

    @Path("/load/component/iec60870-client")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentIec60870Client() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_IEC60870_CLIENT) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_IEC60870_CLIENT);
        return Response.status(500, COMPONENT_IEC60870_CLIENT + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/iec60870-server")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentIec60870Server() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_IEC60870_SERVER) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_IEC60870_SERVER);
        return Response.status(500, COMPONENT_IEC60870_SERVER + " could not be loaded from the Camel context").build();
    }
}
