/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.cxf.soap.server.it;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

@WebService(targetNamespace = CodeFirstService.TARGET_NS, name = "CodeFirstService", serviceName = "CodeFirstService")
@SOAPBinding(parameterStyle = ParameterStyle.BARE)
public interface CodeFirstService {
    public static final String TARGET_NS = "http://www.helloworld.com/CodeFirstService/";

    @WebMethod(operationName = "Hello", action = "https://www.helloworld.com/CodeFirstService/Hello")
    @WebResult(name = "HelloResponse", targetNamespace = TARGET_NS)
    String hello(
            @WebParam(name = "HelloRequest", targetNamespace = TARGET_NS) String var1);

    @WebMethod(operationName = "GoodBye", action = "https://www.helloworld.com/CodeFirstService/GoodBye")
    @WebResult(name = "GoodByeResponse", targetNamespace = TARGET_NS)
    String goodBye(
            @WebParam(name = "GoodByeRequest", targetNamespace = TARGET_NS) String var1);
}
