/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';

export function SmooksIcon() {
    return (
        <svg xmlns="http://www.w3.org/2000/svg"
             viewBox="0 0 90 79"
             className="icon" width="32px" height="32px">
            <path fill="#FDFEFE" d="M0 0h90v79H0V0Z" />
            <path
                fill="#795EAA"
                d="M28 9c3.944.589 6.824 1.786 10.25 3.813.871.5 1.743 1.002 2.64 1.519C43.279 16.22 43.595 17.062 44 20l1 1.938c1.13 2.332 1.575 4.515 2 7.062l3.875-.125c2.18-.07 2.18-.07 4.125.125 2 2 2 2 2.195 4.82l-.07 3.305-.055 3.32L57 43c-5.573-.76-5.573-.76-8-2.125-2.895-1.267-4.892-.44-8 .125-3.668.096-7.331.059-11 0l.063 2.875C30 47 30 47 29 49c-3.911-.674-6.871-2.543-10.25-4.563l-3.266-1.94L13 41l.95-1.875C15.01 36.979 15.775 35.388 16 33c-1.392-2.133-1.392-2.133-3-4v-2c-.957-.09-.957-.09-1.934-.184l-2.504-.253-2.496-.247C4 26 4 26 3 25a167.62 167.62 0 0 1-.563-6.563l-.253-3.628L2 12c4.758.86 4.758.86 6.938 2.125 2.94 1.248 5.012.604 8.062-.125l2-1c1.54-.07 3.083-.085 4.625-.063l2.477.028L28 13V9Z"
            />
            <path
                fill="#136C2B"
                d="M47 42v3c6.26 1.163 6.26 1.163 12-1 3.253.105 4.262 1.232 6.75 3.438C68 50 68 50 68 52l-2.082.48c-5.657 1.283-5.657 1.283-9.793 5.02L55 60c-2.188 1.813-2.188 1.813-4 3l1 2.313C53 68 53 68 53 71l-15 2v-7c-5.472-1.243-5.472-1.243-10.5.438L26 68c-3.82-1.556-6.26-3.956-9-7v-2c3.62-1.316 6.096-2 10-2l.25-2.25C28 52 28 52 30.063 50c2.215-1.868 2.215-1.868 2.187-4.75L32 43c5.07-.712 9.882-1.107 15-1Z"
            />
            <path
                fill="#5D76B5"
                d="M60 10c1.437-.027 2.875-.046 4.313-.063l2.425-.035C69 10 69 10 72 11v3c3.292 1.254 5.64 2.021 9.188 1.813L84 16c2.311 2.85 3 4.314 3 8l-1.758.078c-5.37.39-9.18 1.069-13.242 4.922v6H60c-1-3-1-3 0-6-2.802-1.793-4.083-1.996-7.5-1.813C49 27 49 27 46.562 24.625 45 22 45 22 45 20l3.813-.25c3.465-.378 3.465-.378 6-2.75L56 15l3-1c.733-2.015.733-2.015 1-4Z"
            />
            <path
                fill="#E4EAE9"
                d="M57 38h1l1 7c-3.67 1.573-5.443 2.144-9.375 1.125L47 45v-3l-13 1v-2c8.909-2.395 14.505-1.369 23 2v-5Z"
            />
            <path
                fill="#D1D4E8"
                d="m44 17 1 2h8v1h-8c2.88 4.577 2.88 4.577 7 8l-5 1c-1.524-2.983-2.94-5.818-4-9l1-3Z"
            />
            <path fill="#F6F6F9" d="M30 41h4v2h-2l1 5-4 3-2-2h2l1-8Z" />
        </svg>
    )
}
export function DHIS2Icon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            id="Layer_1"
            viewBox="0 0 195 175"
            className="icon" width="32px" height="32px"
            data-name="Layer 1"
        >
            <defs id="defs1">
                <style id="style1">{".cls-1{fill:#0080d4}"}</style>
            </defs>
            <title id="title1">{"dhis2-logo-rgb-positive"}</title>
            <path
                id="path1"
                d="m189.415 56.477-82.74-53.66a19.75 19.75 0 0 0-20.33 0l-80.35 52.09a12 12 0 0 0-.25 20.63l80.54 54.94a19.39 19.39 0 0 0 20.38.25l82.75-53.65a11.87 11.87 0 0 0 0-20.59zm-91 61.45a4.29 4.29 0 0 1-3.49-.05l-77-52.49 76.71-49.78a4.76 4.76 0 0 1 3.74 0l78.91 51.15z"
                className="cls-1"
            />
            <path
                id="path2"
                d="m86.345 44.297-43.56 28.24 13.62 9.33 38.23-24.78a4.76 4.76 0 0 1 3.74 0l39.37 25.52 14-9.06-45.07-29.25a19.78 19.78 0 0 0-20.33 0z"
                className="cls-1"
            />
            <path
                id="path3"
                d="m189.415 97.937-8.62-5.59-14 9.06 10.52 6.83-78.91 51.15a4.37 4.37 0 0 1-3.49 0l-77-52.5 10-6.47-13.67-9.37-8.25 5.34a12 12 0 0 0-.25 20.63l80.54 54.92a19.36 19.36 0 0 0 20.38.24l82.74-53.65a11.87 11.87 0 0 0 0-20.59z"
                className="cls-1"
            />
        </svg>
    );
}

export function DirectIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px"
        >
            <path
                d="M25 11a5.008 5.008 0 0 0-4.899 4H11.9a5 5 0 1 0 0 2H20.1A5 5 0 1 0 25 11Zm0 8a3 3 0 1 1 3-3 3.003 3.003 0 0 1-3 3Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function SpringIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <g fill="none" fillRule="evenodd">
                <path d="M0 0h32v32H0z"></path>
                <path
                    fill="#70AD51"
                    d="M5.466 27.993a1.364 1.364 0 10-.087-.076l-.266-.234C1.972 24.762 0 20.597 0 15.978 0 7.168 7.168 0 15.98 0c4.48 0 8.53 1.857 11.435 4.836a14.681 14.681 0 001.7-3.015c2.036 6.118 3.233 11.26 2.795 15.31-.592 8.274-7.508 14.83-15.93 14.83a15.903 15.903 0 01-10.276-3.757l-.238-.21zm23.58-4.982c4.01-5.336 1.775-13.965-.085-19.48-1.657 3.453-5.738 6.094-9.262 6.93-3.303.788-6.226.142-9.283 1.318-6.97 2.68-6.86 10.992-3.02 12.86.002 0 .23.124.227.12 0-.002 5.644-1.122 8.764-2.274 4.56-1.684 9.566-5.835 11.213-10.657-.877 5.015-5.182 9.84-9.507 12.056-2.302 1.182-4.092 1.445-7.88 2.756-.464.158-.828.314-.828.314.96-.16 1.917-.212 1.917-.212 5.393-.255 13.807 1.516 17.745-3.73z"
                ></path>
            </g>
        </svg>
    );
}

export function QuarkusIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            preserveAspectRatio="xMidYMid"
            viewBox="-0.5 0 257 257"
            className="icon" width="32px" height="32px">
            <path
                fill="#4695EB"
                d="M213.554 0c23.418.08 42.377 19.052 42.443 42.47v171.084c-.066 23.428-19.042 42.404-42.47 42.47h-25.439l-11.661-28.318h37.127c7.774-.1 14.051-6.378 14.152-14.152V42.47c-.1-7.774-6.378-14.051-14.152-14.152H42.47c-7.774.1-14.051 6.378-14.152 14.152v171.084c.1 7.774 6.378 14.051 14.152 14.152h62.607l22.935-48.494 31.625 76.812H42.47C19.042 255.958.066 236.982 0 213.554V42.47C.066 19.042 19.042.066 42.47 0h171.084zm-43.983 139.727v45.51l-39.417-22.748 39.417-22.762zM86.453 94.218v45.51l-39.418-22.762 39.418-22.748zm80.976-49.231v45.51l-39.417-22.762 39.417-22.748z"
            ></path>
            <path
                fill="#FF004A"
                d="M86.453 139.727l39.417 22.762-39.417 22.748v-45.51zm83.118-45.509l39.418 22.748-39.418 22.761V94.218zM88.595 44.987l39.417 22.748-39.417 22.761V44.987z"
            ></path>
            <path
                fill="#091313"
                d="M86.453 94.218l39.417 22.748v45.523l-39.417-22.762V94.218zm83.118 0v45.51l-39.417 22.76v-45.522l39.417-22.748zm-41.559-26.483l39.417 22.761-39.417 22.761-39.417-22.76 39.417-22.762z"
            ></path>
        </svg>
    );
}

export function DatabaseIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 24 24"
            className="icon" width="32px" height="32px">
            <path
                fillRule="evenodd"
                d="M12 1.25c-2.487 0-4.774.402-6.466 1.079-.844.337-1.577.758-2.112 1.264C2.886 4.1 2.5 4.744 2.5 5.5v12.987l.026.013H2.5c0 .756.386 1.4.922 1.907.535.506 1.268.927 2.112 1.264 1.692.677 3.979 1.079 6.466 1.079s4.773-.402 6.466-1.079c.844-.337 1.577-.758 2.112-1.264.536-.507.922-1.151.922-1.907h-.026l.026-.013V5.5c0-.756-.386-1.4-.922-1.907-.535-.506-1.268-.927-2.112-1.264C16.773 1.652 14.487 1.25 12 1.25zM4 5.5c0-.21.104-.487.453-.817.35-.332.899-.666 1.638-.962C7.566 3.131 9.655 2.75 12 2.75c2.345 0 4.434.382 5.909.971.74.296 1.287.63 1.638.962.35.33.453.606.453.817 0 .21-.104.487-.453.817-.35.332-.899.666-1.638.962-1.475.59-3.564.971-5.909.971-2.345 0-4.434-.382-5.909-.971-.74-.296-1.287-.63-1.638-.962C4.103 5.987 4 5.711 4 5.5zM20 12V7.871a7.842 7.842 0 01-1.534.8C16.773 9.348 14.487 9.75 12 9.75s-4.774-.402-6.466-1.079A7.843 7.843 0 014 7.871V12c0 .21.104.487.453.817.35.332.899.666 1.638.961 1.475.59 3.564.972 5.909.972 2.345 0 4.434-.382 5.909-.972.74-.295 1.287-.629 1.638-.96.35-.33.453-.607.453-.818zM4 14.371c.443.305.963.572 1.534.8 1.692.677 3.979 1.079 6.466 1.079s4.773-.402 6.466-1.079a7.842 7.842 0 001.534-.8v4.116l.013.013H20c0 .21-.104.487-.453.817-.35.332-.899.666-1.638.962-1.475.59-3.564.971-5.909.971-2.345 0-4.434-.382-5.909-.971-.74-.296-1.287-.63-1.638-.962-.35-.33-.453-.606-.453-.817h-.013L4 18.487V14.37z"
            ></path>
        </svg>
    );
}

export function CloudIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <path
                d="M16 7a7.66 7.66 0 0 1 1.51.15 8 8 0 0 1 6.35 6.34l.26 1.35 1.35.24a5.5 5.5 0 0 1-1 10.92H7.5a5.5 5.5 0 0 1-1-10.92l1.34-.24.26-1.35A8 8 0 0 1 16 7m0-2a10 10 0 0 0-9.83 8.12A7.5 7.5 0 0 0 7.49 28h17a7.5 7.5 0 0 0 1.32-14.88 10 10 0 0 0-7.94-7.94A10.27 10.27 0 0 0 16 5Z"/>
            <path
                d="M0 0h32v32H0z"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function FileIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            xmlSpace="preserve"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <title>{"document"}</title>
            <path
                d="m25.7 9.3-7-7c-.2-.2-.4-.3-.7-.3H8c-1.1 0-2 .9-2 2v24c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V10c0-.3-.1-.5-.3-.7zM18 4.4l5.6 5.6H18V4.4zM24 28H8V4h8v6c0 1.1.9 2 2 2h6v16z"/>
            <path d="M10 22h12v2H10zM10 16h12v2H10z"/>
            <path
                d="M0 0h32v32H0z"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function MessagingIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <path d="M28 28H4a2.002 2.002 0 0 1-2-2v-5h2v5h24v-5h2v5a2.002 2.002 0 0 1-2 2Z"/>
            <path d="M7 21h18v2H7zM7 16h18v2H7zM7 11h18v2H7zM7 6h18v2H7z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function SchedulingIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <path d="M16 30a14 14 0 1 1 14-14 14 14 0 0 1-14 14Zm0-26a12 12 0 1 0 12 12A12 12 0 0 0 16 4Z"/>
            <path d="M20.59 22 15 16.41V7h2v8.58l5 5.01L20.59 22z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function HttpIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <path
                d="M30 11h-5v10h2v-3h3a2.003 2.003 0 0 0 2-2v-3a2.002 2.002 0 0 0-2-2Zm-3 5v-3h3l.001 3ZM10 13h2v8h2v-8h2v-2h-6v2zM23 11h-6v2h2v8h2v-8h2v-2zM6 11v4H3v-4H1v10h2v-4h3v4h2V11H6z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function GoogleCloudIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            preserveAspectRatio="xMidYMid"
            viewBox="0 -25 256 256"
            className="icon" width="32px" height="32px">
            <path
                fill="#EA4335"
                d="m170.252 56.819 22.253-22.253 1.483-9.37C153.437-11.677 88.976-7.496 52.42 33.92 42.267 45.423 34.734 59.764 30.717 74.573l7.97-1.123 44.505-7.34 3.436-3.513c19.797-21.742 53.27-24.667 76.128-6.168l7.496.39Z"
            />
            <path
                fill="#4285F4"
                d="M224.205 73.918a100.249 100.249 0 0 0-30.217-48.722l-31.232 31.232a55.515 55.515 0 0 1 20.379 44.037v5.544c15.35 0 27.797 12.445 27.797 27.796 0 15.352-12.446 27.485-27.797 27.485h-55.671l-5.466 5.934v33.34l5.466 5.231h55.67c39.93.311 72.553-31.494 72.864-71.424a72.303 72.303 0 0 0-31.793-60.453"
            />
            <path
                fill="#34A853"
                d="M71.87 205.796h55.593V161.29H71.87a27.275 27.275 0 0 1-11.399-2.498l-7.887 2.42-22.409 22.253-1.952 7.574c12.567 9.489 27.9 14.825 43.647 14.757"
            />
            <path
                fill="#FBBC05"
                d="M71.87 61.425C31.94 61.664-.237 94.228.001 134.159a72.301 72.301 0 0 0 28.222 56.88l32.248-32.246c-13.99-6.322-20.208-22.786-13.887-36.776 6.32-13.99 22.786-20.208 36.775-13.888a27.796 27.796 0 0 1 13.887 13.888l32.248-32.248A72.224 72.224 0 0 0 71.87 61.425"
            />
        </svg>
    );
}

export function AwsIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            fill="none"
            viewBox="0 0 16 16"
            className="icon" width="32px" height="32px">
            <path
                fill="#252F3E"
                d="M4.51 7.687c0 .197.02.357.058.475.042.117.096.245.17.384a.233.233 0 0 1 .037.123c0 .053-.032.107-.1.16l-.336.224a.255.255 0 0 1-.138.048c-.054 0-.107-.026-.16-.074a1.652 1.652 0 0 1-.192-.251 4.137 4.137 0 0 1-.165-.315c-.415.491-.936.737-1.564.737-.447 0-.804-.129-1.064-.385-.261-.256-.394-.598-.394-1.025 0-.454.16-.822.484-1.1.325-.278.756-.416 1.304-.416.18 0 .367.016.564.042.197.027.4.07.612.118v-.39c0-.406-.085-.689-.25-.854-.17-.166-.458-.246-.868-.246-.186 0-.377.022-.574.07a4.23 4.23 0 0 0-.575.181 1.525 1.525 0 0 1-.186.07.326.326 0 0 1-.085.016c-.075 0-.112-.054-.112-.166v-.262c0-.085.01-.15.037-.186a.399.399 0 0 1 .15-.113c.185-.096.409-.176.67-.24.26-.07.537-.101.83-.101.633 0 1.096.144 1.394.432.293.288.442.726.442 1.314v1.73h.01zm-2.161.811c.175 0 .356-.032.548-.096.191-.064.362-.182.505-.342a.848.848 0 0 0 .181-.341c.032-.129.054-.283.054-.465V7.03a4.43 4.43 0 0 0-.49-.09 3.996 3.996 0 0 0-.5-.033c-.357 0-.618.07-.793.214-.176.144-.26.347-.26.614 0 .25.063.437.196.566.128.133.314.197.559.197zm4.273.577c-.096 0-.16-.016-.202-.054-.043-.032-.08-.106-.112-.208l-1.25-4.127a.938.938 0 0 1-.049-.214c0-.085.043-.133.128-.133h.522c.1 0 .17.016.207.053.043.032.075.107.107.208l.894 3.535.83-3.535c.026-.106.058-.176.1-.208a.365.365 0 0 1 .214-.053h.425c.102 0 .17.016.213.053.043.032.08.107.101.208l.841 3.578.92-3.578a.458.458 0 0 1 .107-.208.346.346 0 0 1 .208-.053h.495c.085 0 .133.043.133.133 0 .027-.006.054-.01.086a.76.76 0 0 1-.038.133l-1.283 4.127c-.032.107-.069.177-.111.209a.34.34 0 0 1-.203.053h-.457c-.101 0-.17-.016-.213-.053-.043-.038-.08-.107-.101-.214L8.213 5.37l-.82 3.439c-.026.107-.058.176-.1.213-.043.038-.118.054-.213.054h-.458zm6.838.144a3.51 3.51 0 0 1-.82-.096c-.266-.064-.473-.134-.612-.214-.085-.048-.143-.101-.165-.15a.378.378 0 0 1-.031-.149v-.272c0-.112.042-.166.122-.166a.3.3 0 0 1 .096.016c.032.011.08.032.133.054.18.08.378.144.585.187.213.042.42.064.633.064.336 0 .596-.059.777-.176a.575.575 0 0 0 .277-.508.52.52 0 0 0-.144-.373c-.095-.102-.276-.193-.537-.278l-.772-.24c-.388-.123-.676-.305-.851-.545a1.275 1.275 0 0 1-.266-.774c0-.224.048-.422.143-.593.096-.17.224-.32.384-.438a1.7 1.7 0 0 1 .553-.277c.213-.064.436-.091.67-.091.118 0 .24.005.357.021a3.4 3.4 0 0 1 .649.145c.096.032.17.064.224.096a.46.46 0 0 1 .16.133.289.289 0 0 1 .047.176v.251c0 .112-.042.171-.122.171a.552.552 0 0 1-.202-.064 2.427 2.427 0 0 0-1.022-.208c-.303 0-.543.048-.708.15-.165.1-.25.256-.25.475 0 .149.053.277.16.379.106.101.303.202.585.293l.756.24c.383.123.66.294.825.513.165.219.244.47.244.748 0 .23-.047.437-.138.619a1.436 1.436 0 0 1-.388.47c-.165.133-.362.23-.591.299a2.52 2.52 0 0 1-.761.112z"
            />
            <g fill="#F90" fillRule="evenodd" clipRule="evenodd">
                <path
                    d="M14.465 11.813c-1.75 1.297-4.294 1.986-6.481 1.986-3.065 0-5.827-1.137-7.913-3.027-.165-.15-.016-.353.18-.235 2.257 1.313 5.04 2.109 7.92 2.109 1.941 0 4.075-.406 6.039-1.239.293-.133.543.192.255.406z"/>
                <path
                    d="M15.194 10.98c-.223-.287-1.479-.138-2.048-.069-.17.022-.197-.128-.043-.24 1-.705 2.645-.502 2.836-.267.192.24-.053 1.89-.99 2.68-.143.123-.281.06-.218-.1.213-.53.687-1.72.463-2.003z"/>
            </g>
        </svg>
    );
}

export function MailIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <title>{"email"}</title>
            <path
                d="M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2Zm-2.2 2L16 14.78 6.2 8ZM4 24V8.91l11.43 7.91a1 1 0 0 0 1.14 0L28 8.91V24Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function IotIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <title>{"iot--platform"}</title>
            <path
                d="M30 19h-4v-4h-2v9H8V8h9V6h-4V2h-2v4H8a2.002 2.002 0 0 0-2 2v3H2v2h4v6H2v2h4v3a2.002 2.002 0 0 0 2 2h3v4h2v-4h6v4h2v-4h3a2.003 2.003 0 0 0 2-2v-3h4Z"/>
            <path d="M21 21H11V11h10Zm-8-2h6v-6h-6ZM31 13h-2A10.012 10.012 0 0 0 19 3V1a12.013 12.013 0 0 1 12 12Z"/>
            <path d="M26 13h-2a5.006 5.006 0 0 0-5-5V6a7.008 7.008 0 0 1 7 7Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function GithubIcon() {
    return (
        <svg
            aria-hidden="true"
            data-view-component="true"
            viewBox="0 0 16 16"
            className="icon" width="32px" height="32px">
            <path
                d="M8 0c4.42 0 8 3.58 8 8a8.013 8.013 0 0 1-5.45 7.59c-.4.08-.55-.17-.55-.38 0-.27.01-1.13.01-2.2 0-.75-.25-1.23-.54-1.48 1.78-.2 3.65-.88 3.65-3.95 0-.88-.31-1.59-.82-2.15.08-.2.36-1.02-.08-2.12 0 0-.67-.22-2.2.82-.64-.18-1.32-.27-2-.27-.68 0-1.36.09-2 .27-1.53-1.03-2.2-.82-2.2-.82-.44 1.1-.16 1.92-.08 2.12-.51.56-.82 1.28-.82 2.15 0 3.06 1.86 3.75 3.64 3.95-.23.2-.44.55-.51 1.07-.46.21-1.61.55-2.33-.66-.15-.24-.6-.83-1.23-.82-.67.01-.27.38.01.53.34.19.73.9.82 1.13.16.45.68 1.31 2.69.94 0 .67.01 1.3.01 1.49 0 .21-.15.45-.55.38A7.995 7.995 0 0 1 0 8c0-4.42 3.58-8 8-8Z"/>
        </svg>
    );
}

export function CassandraIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
            viewBox="0 0 113.63554 58.899029"
            className="icon" width="32px" height="32px">
            <defs>
                <path id="a" d="M24.216.082v24.141H.053V.082z"/>
            </defs>
            <g
                style={{
                    fill: "none",
                    fillRule: "evenodd",
                    stroke: "none",
                    strokeWidth: 1,
                }}
            >
                <path
                    fill="#bbe6fb"
                    d="M90.565 20.787C91.4 30.202 76.112 39.163 56.422 40.8c-19.69 1.638-36.329-4.669-37.162-14.083C18.426 17.3 33.713 8.34 53.404 6.702c19.69-1.636 36.329 4.669 37.161 14.085"
                />
                <path
                    fill="#fff"
                    d="M53.334 6.75c-4.16-.255-11.326 1.915-17.302 4.08a17.762 17.762 0 0 0-1.413 6.948c0 10.096 9.154 18.28 18.837 18.28 9.62 0 18.13-8.197 18.836-18.28.23-3.283-.9-6.377-2.47-9.044-6.196-1.091-12.771-1.758-16.488-1.984"
                />
                <image
                    xlinkHref="data:image/png;base64,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"
                    width={43.164}
                    height={31.532}
                    x={31.672}
                    y={6.587}
                    opacity={0.596}
                />
                <path
                    fill="#373535"
                    d="M42.663 16.453c.51-1.13 1.282-1.683 2.031-2.63-.083-.224-.265-.958-.265-1.212 0-1.128.928-2.056 2.056-2.056.26 0 .517.05.758.146a14.985 14.985 0 0 1 13.597-2.39c-4.45-.617-9.466.96-12.878 3.713.104.246.393.949.393 1.232 0 1.135-.735 1.411-1.87 1.411-.258 0-.504-.05-.732-.136-.771 1.035-1.715 3.006-2.178 4.239 1.887 1.687 3.592 2.299 5.813 3.13-.006-.106.076-.205.076-.312 0-3.424 3.014-6.206 6.438-6.206a6.195 6.195 0 0 1 6.105 5.158c1.53-.974 3.01-1.72 4.139-3.164-.263-.32-.548-1.23-.548-1.678 0-1.023.843-1.865 1.866-1.865h.001c.146 0 .286.02.422.052a16.322 16.322 0 0 0 1.282-3.71C63.815 6.21 53.456 6.75 53.456 6.75s-8.242-.43-13.823 2.29c.373 2.69 1.446 5.249 3.03 7.412"
                />
                <path
                    fill="#373535"
                    d="M68.25 14.909c.303.265.555.58.748.932.502.9-.503 1.724-1.533 1.724a1.846 1.846 0 0 1-.306-.031c-1.161 1.814-3.194 4.14-5 5.311 2.769.454 5.38 1.563 7.46 3.277 1.513-2.711 2.673-6.627 2.673-9.953 0-2.532-1.117-4.387-2.804-5.748-.089 1.356-.813 3.252-1.236 4.488M45.77 32.084c.922-2.549 3.192-4.524 5.34-6.26-.315-.43-.786-1.496-.982-2a15.027 15.027 0 0 1-6.733-4.261l-.044.17a13.62 13.62 0 0 0-.232 4.52 2.709 2.709 0 0 1 2.203 2.654c0 .783-.687 1.92-1.22 2.414.58 1.25.975 1.854 1.668 2.763"
                />
                <path
                    fill="#373535"
                    d="M45.607 34.222c-1.1-1.094-1.862-3.277-2.576-4.648a2.707 2.707 0 0 1-.41.035c-1.494 0-3.058-1.253-2.704-2.702.196-.803.75-1.327 1.652-1.765-.206-1.662-.261-4.051.124-5.78.111-.494.345-.726.5-1.196-1.647-2.41-2.711-5.574-2.711-8.713 0-.115.005-.228.008-.342-2.783 1.396-4.87 3.595-4.87 7.058 0 7.659 4.41 15.171 10.973 18.116l.014-.062m16.138-10.588a6.196 6.196 0 0 1-5.843 4.145 6.167 6.167 0 0 1-3.826-1.327c-2.173 1.692-4.143 4.664-5.145 7.242.45.484.763.882 1.267 1.311 1.52.396 3.613 0 5.258 0 6.617 0 12.478-2.944 15.838-8.106-2.234-1.547-4.87-3.02-7.549-3.265"
                />
                <path
                    fill="#1287b1"
                    d="M42.493 17.348a14.975 14.975 0 0 1 1.898-3.122 2.057 2.057 0 0 1-.132-.72c0-1.127.929-2.056 2.056-2.056.26 0 .517.05.758.147A14.985 14.985 0 0 1 59.46 8.879c.407.093.811.202 1.21.328-4.45-.617-9.048.747-12.46 3.5.107.253.162.525.162.799a2.066 2.066 0 0 1-2.056 2.056 2.05 2.05 0 0 1-.733-.136 13.841 13.841 0 0 0-1.863 3.412c1.62 1.746 3.61 3.127 5.83 3.957-.005-.106-.016-.21-.016-.319a6.195 6.195 0 0 1 12.303-1.04 16.065 16.065 0 0 0 4.019-3.669 1.843 1.843 0 0 1-.427-1.174c.001-1.023.843-1.865 1.867-1.865.145 0 .285.021.422.053a16.326 16.326 0 0 0 1.281-3.711c-5.354-3.964-15.712-3.423-15.712-3.423s-8.243-.43-13.823 2.29c.372 2.69 1.446 5.248 3.029 7.411"
                />
                <path
                    fill="#1287b1"
                    d="M68.54 15.214c.394.35.62.852.622 1.38a1.876 1.876 0 0 1-1.866 1.866 1.85 1.85 0 0 1-.307-.032 15.102 15.102 0 0 1-4.506 4.533 15.09 15.09 0 0 1 7.261 3.263 18.739 18.739 0 0 0 2.379-9.16c0-2.532-1.118-4.387-2.805-5.748a15.01 15.01 0 0 1-.778 3.898M46.054 32.696a15.04 15.04 0 0 1 4.674-6.572 6.186 6.186 0 0 1-.77-1.406 15.025 15.025 0 0 1-6.733-4.26c-.013.057-.03.113-.043.17a13.593 13.593 0 0 0-.232 4.52 2.71 2.71 0 0 1 2.203 2.653c0 .754-.316 1.473-.87 1.984a16.22 16.22 0 0 0 1.771 2.91"
                />
                <path
                    fill="#1287b1"
                    d="M45.6 34.192a15.07 15.07 0 0 1-2.739-3.722 2.704 2.704 0 0 1-.41.034h-.004c-1.482 0-2.7-1.219-2.7-2.7 0-1.035.594-1.983 1.526-2.432-.273-2.209-.05-4.45.651-6.561a14.95 14.95 0 0 1-2.612-8.463c0-.115.006-.228.008-.341-2.783 1.395-4.87 3.595-4.87 7.057 0 7.659 4.573 14.245 11.136 17.19l.014-.062m15.976-9.661a6.198 6.198 0 0 1-5.843 4.144 6.17 6.17 0 0 1-3.826-1.327c-2.173 1.692-3.813 3.998-4.814 6.577.45.484.929.941 1.433 1.369 1.555.404 3.154.608 4.76.607 6.617 0 12.435-3.416 15.795-8.578-2.234-1.548-4.826-2.547-7.506-2.793"
                />
                <g transform="translate(43.304 10.642)">
                    <mask id="b" fill="#fff">
                        <use xlinkHref="#a"/>
                    </mask>
                    <path
                        fill="#fff"
                        d="M14.783 6.242 14.704.147l-2.251 5.43L10.576.081l.101 6.472L7.433.753l1.755 6.16-5.262-3.827 4.122 5.18-6.533-2.403 5.156 3.815-6.612.203 6.76 1.745L.053 13.09l6.68.484L1.1 17.18l5.8-2.103-4.024 5.097 5.085-4.101-1.832 6.838 3.926-5.565-.55 6.573 2.228-5.958 1.897 6.262.461-6.281 2.815 5.36-1.663-6.131 5.155 3.993-3.328-5.091 5.656 2.203-4.325-4.25 5.8.456-5.712-2.192 5.727-1.366-5.748-.293 4.678-3.575-5.309 1.903 3.608-5-4.983 3.312 1.743-5.852z"
                        mask="url(#b)"
                    />
                </g>
                <image
                    xlinkHref="data:image/png;base64,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"
                    width={111.814}
                    height={32.542}
                    x={1.822}
                    y={1.682}
                    opacity={0.487}
                />
                <path
                    fill="#373535"
                    d="M46.372 6.794c1.704-.331 2.026-4.053 2.026-4.053s.238 2.743 1.43 3.1c1.193.357 2.742-4.291 2.742-4.291s-1.43 4.172 0 4.41c1.43.238 4.053-4.053 4.053-4.053s-1.072 3.695-.358 3.933c.715.239 4.291-5.364 4.291-5.364s-2.145 3.695-.119 4.053c2.027.358 4.984-2.521 4.984-2.521s-2.325 2.634-1.289 2.998c4.412 1.55 7.98-4.183 7.98-4.183s-.827 2.514-2.972 5.256C73.788 7.27 77.24.267 77.24.267L73.788 7.27C75.576 8.224 82.728 0 82.728 0s-3.694 6.436-5.84 7.747c1.192.954 5.483-2.86 5.483-2.86s-3.457 4.291-2.145 4.53c1.907 1.55 8.94-7.987 8.94-7.987s-1.556 4.883-5.608 9.294c3.387 1.695 10.615-8.46 10.615-8.46s-.239 3.458-6.318 8.941c4.53-.596 10.37-9.18 10.37-9.18s-2.145 6.438-7.271 10.968c4.448-.463 11.562-11.444 11.562-11.444s-2.741 7.63-8.343 12.04c6.198 1.37 15.139-7.867 15.139-7.867s-3.517 6.555-8.107 9.237c5.127 1.967 12.16-6.139 12.16-6.139s-7.033 10.848-18.24 10.371C91.45 19.034 80.33 8.037 56.504 8.94 25.034 10.132 18.36 23.482 1.551 32.542 19.312 14.78 33.497 9.298 46.37 6.794Z"
                />
                <path
                    fill="#373535"
                    d="M0 34.76c9.388 4.71 17.97-.714 28.788 2.334 8.224 2.318 18.239 5.176 31.828 3.209 13.589-1.967 25.21-7.867 30.755-18.416 1.728-4.709 8.76 1.072 8.76 1.072s-5.125-2.145-5.006-1.132c.12 1.013 7.689 4.53 7.689 4.53s-6.855-2.146-6.437-.536c.417 1.608 8.583 8.045 8.583 8.045s-9.239-7.033-10.013-6.079c-.775.953 3.933 4.828 3.933 4.828s-7.808-4.828-10.55-3.405c-1.972 1.024 8.106 7.637 8.106 7.637S89.88 31.84 88.33 33.15c-1.55 1.312 7.391 12.04 7.391 12.04S85.588 34.223 84.575 34.76c-1.012.536 2.802 5.78 2.802 5.78s-5.007-5.483-6.378-4.529c-1.37.953 7.152 15.198 7.152 15.198S78.913 36.608 75.1 39.052c5.99 13.142 3.755 15.02 3.755 15.02s-.765-13.408-8.226-13.053c-3.755.179 1.788 10.013 1.788 10.013s-5.101-8.983-8.499-8.804C70.18 54.08 67.947 58.9 67.947 58.9s1.035-10.122-7.458-15.754C63.707 46.005 58.47 58.9 58.47 58.9s4.608-19-3.397-15.377c-1.265.572-.09 9.477-.09 9.477s-1.61-10.192-4.022-9.656c-1.408.312-8.942 14.126-8.942 14.126s6.17-14.93 4.292-14.304c-1.367.455-3.934 6.615-3.934 6.615s1.252-6.08 0-6.437c-1.251-.358-8.225 6.437-8.225 6.437s5.186-6.08 4.29-7.331c-1.354-1.897-2.942-1.985-4.827-1.251-2.742 1.068-6.436 6.079-6.436 6.079s3.683-5.074 3.04-6.974c-1.034-3.053-11.623 5.9-11.623 5.9s6.259-5.9 4.828-7.151c-1.43-1.252-9.197-.865-11.623-.872-7.152-.023-9.63-1.7-11.801-3.42"
                />
            </g>
        </svg>
    );
}

export function ActivemqIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 30.803 44.324"
            className="icon" width="32px" height="32px">
            <defs>
                <filter
                    id="a"
                    width={1.068}
                    height={1.046}
                    x={-0.017}
                    y={-0.011}
                >
                    <feFlood floodColor="#000" floodOpacity={0.498} result="flood"/>
                    <feComposite
                        in="flood"
                        in2="SourceGraphic"
                        operator="in"
                        result="composite1"
                    />
                    <feGaussianBlur in="composite1" result="blur" stdDeviation={0.2}/>
                    <feOffset dx={1} dy={1} result="offset"/>
                    <feComposite in="SourceGraphic" in2="offset" result="composite2"/>
                </filter>
            </defs>
            <g
                style={{
                    display: "inline",
                }}
            >
                <g
                    style={{
                        filter: "url(#a)",
                    }}
                    transform="translate(-39.667 -110.707)"
                >
                    <path
                        d="m64.697 153.552-8.352-.05-4.133-7.257 4.218-7.208 8.352.049 4.134 7.257z"
                        style={{
                            fill: "#fff",
                            strokeWidth: 0.394699,
                            strokeMiterlimit: 4,
                            strokeDasharray: "none",
                        }}
                    />
                    <path
                        d="m52.632 146.553-8.352-.049-4.133-7.257 4.218-7.209 8.352.05 4.134 7.257z"
                        style={{
                            display: "inline",
                            fill: "#fff",
                            strokeWidth: 0.394699,
                            strokeMiterlimit: 4,
                            strokeDasharray: "none",
                        }}
                    />
                    <path
                        d="m64.771 139.589-8.352-.05-4.133-7.257 4.218-7.208 8.352.05 4.134 7.257z"
                        style={{
                            display: "inline",
                            fill: "#fff",
                            strokeWidth: 0.394699,
                            strokeMiterlimit: 4,
                            strokeDasharray: "none",
                        }}
                    />
                    <path
                        d="m64.765 125.702-8.351-.049-4.134-7.257 4.219-7.209 8.352.05 4.133 7.257z"
                        style={{
                            display: "inline",
                            fill: "#fff",
                            strokeWidth: 0.394699,
                            strokeMiterlimit: 4,
                            strokeDasharray: "none",
                        }}
                    />
                    <path
                        d="m52.696 132.676-8.352-.049-4.133-7.257 4.218-7.209 8.352.05 4.133 7.257z"
                        style={{
                            display: "inline",
                            fill: "#fff",
                            strokeWidth: 0.394699,
                            strokeMiterlimit: 4,
                            strokeDasharray: "none",
                        }}
                    />
                </g>
            </g>
            <g
                style={{
                    display: "inline",
                }}
                transform="translate(-39.667 -110.707)"
            >
                <path
                    d="m1849.139 640.353-96.824 20.558-66.216-73.574 30.608-94.13 96.824-20.559 66.216 73.573z"
                    style={{
                        opacity: 1,
                        fill: "#c12766",
                        fillOpacity: 1,
                        stroke: "none",
                        strokeWidth: 3,
                        strokeMiterlimit: 4,
                        strokeDasharray: "none",
                        strokeOpacity: 1,
                    }}
                    transform="matrix(.07206 .01553 -.01553 .07206 -59.031 63.796)"
                />
                <path
                    d="m1849.139 640.353-96.824 20.558-66.216-73.574 30.608-94.13 96.824-20.559 66.216 73.573z"
                    style={{
                        opacity: 1,
                        fill: "#3e489f",
                        fillOpacity: 1,
                        stroke: "none",
                        strokeWidth: 15,
                        strokeMiterlimit: 4,
                        strokeDasharray: "none",
                        strokeOpacity: 1,
                    }}
                    transform="matrix(.07206 .01553 -.01553 .07206 -71.17 70.76)"
                />
                <path
                    d="m1849.139 640.353-96.824 20.558-66.216-73.574 30.608-94.13 96.824-20.559 66.216 73.573z"
                    style={{
                        opacity: 1,
                        fill: "#714099",
                        fillOpacity: 1,
                        stroke: "none",
                        strokeWidth: 3,
                        strokeMiterlimit: 4,
                        strokeDasharray: "none",
                        strokeOpacity: 1,
                    }}
                    transform="matrix(.07206 .01553 -.01553 .07206 -59.106 77.758)"
                />
                <path
                    d="m1849.139 640.353-96.824 20.558-66.216-73.574 30.608-94.13 96.824-20.559 66.216 73.573z"
                    style={{
                        opacity: 1,
                        fill: "#78932c",
                        fillOpacity: 1,
                        stroke: "none",
                        strokeWidth: 3,
                        strokeMiterlimit: 4,
                        strokeDasharray: "none",
                        strokeOpacity: 1,
                    }}
                    transform="matrix(.07206 .01553 -.01553 .07206 -71.106 56.883)"
                />
                <path
                    d="m1849.139 640.353-96.824 20.558-66.216-73.574 30.608-94.13 96.824-20.559 66.216 73.573z"
                    style={{
                        opacity: 1,
                        fill: "#cf242a",
                        fillOpacity: 1,
                        stroke: "none",
                        strokeWidth: 3,
                        strokeMiterlimit: 4,
                        strokeDasharray: "none",
                        strokeOpacity: 1,
                    }}
                    transform="matrix(.07206 .01553 -.01553 .07206 -59.037 49.91)"
                />
                <circle
                    cx={60.564}
                    cy={146.294}
                    r={1.6}
                    style={{
                        opacity: 1,
                        fill: "#fff",
                        fillOpacity: 1,
                        stroke: "none",
                        strokeWidth: 0.320071,
                        strokeMiterlimit: 4,
                        strokeDasharray: "none",
                        strokeOpacity: 1,
                    }}
                />
                <path
                    d="m61.748 117.71-14.267 8.174M48.514 124.197l.048 16.442M47.525 138.715l14.136 8.397M60.59 117.133l.048 16.442"
                    style={{
                        fill: "none",
                        fillRule: "evenodd",
                        stroke: "#fff",
                        strokeWidth: 0.523753,
                        strokeLinecap: "butt",
                        strokeLinejoin: "miter",
                        strokeMiterlimit: 4,
                        strokeDasharray: "none",
                        strokeOpacity: 1,
                    }}
                />
                <path
                    d="m60.657 131.093.048 16.442"
                    style={{
                        fill: "none",
                        fillRule: "evenodd",
                        stroke: "#fff",
                        strokeWidth: 0.5238,
                        strokeLinecap: "butt",
                        strokeLinejoin: "miter",
                        strokeMiterlimit: 4,
                        strokeDasharray: "none",
                        strokeOpacity: 1,
                    }}
                />
                <path
                    d="m61.766 131.708-14.267 8.174M47.564 124.84l14.136 8.398"
                    style={{
                        fill: "none",
                        fillRule: "evenodd",
                        stroke: "#fff",
                        strokeWidth: 0.523753,
                        strokeLinecap: "butt",
                        strokeLinejoin: "miter",
                        strokeMiterlimit: 4,
                        strokeDasharray: "none",
                        strokeOpacity: 1,
                    }}
                />
                <circle
                    cx={48.334}
                    cy={139.242}
                    r={1.6}
                    style={{
                        opacity: 1,
                        fill: "#fff",
                        fillOpacity: 1,
                        stroke: "none",
                        strokeWidth: 0.320071,
                        strokeMiterlimit: 4,
                        strokeDasharray: "none",
                        strokeOpacity: 1,
                    }}
                />
                <circle
                    cx={60.901}
                    cy={132.486}
                    r={1.6}
                    style={{
                        opacity: 1,
                        fill: "#fff",
                        fillOpacity: 1,
                        stroke: "none",
                        strokeWidth: 0.320071,
                        strokeMiterlimit: 4,
                        strokeDasharray: "none",
                        strokeOpacity: 1,
                    }}
                />
                <circle
                    cx={48.563}
                    cy={125.419}
                    r={1.6}
                    style={{
                        opacity: 1,
                        fill: "#fff",
                        fillOpacity: 1,
                        stroke: "none",
                        strokeWidth: 0.320071,
                        strokeMiterlimit: 4,
                        strokeDasharray: "none",
                        strokeOpacity: 1,
                    }}
                />
                <circle
                    cx={60.632}
                    cy={118.445}
                    r={1.6}
                    style={{
                        opacity: 1,
                        fill: "#fff",
                        fillOpacity: 1,
                        stroke: "none",
                        strokeWidth: 0.320071,
                        strokeMiterlimit: 4,
                        strokeDasharray: "none",
                        strokeOpacity: 1,
                    }}
                />
            </g>
        </svg>
    );
}

export function KafkaIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            preserveAspectRatio="xMidYMid"
            viewBox="-78.5 0 413 413"
            className="icon" width="32px" height="32px">
            <path
                fill="#1A1919"
                d="M87.932 36.714c-4.55-4.571-10.896-7.394-17.951-7.394-7.029 0-13.326 2.823-17.822 7.394h-.13c-4.535 4.55-7.358 10.9-7.358 17.93 0 7.055 2.823 13.352 7.359 17.875l.129.102c4.496 4.55 10.793 7.346 17.822 7.346 7.055 0 13.402-2.797 17.951-7.346L88 72.52c4.558-4.523 7.354-10.82 7.354-17.876 0-7.029-2.796-13.38-7.354-17.929h-.067Zm-17.951 346.64a25.504 25.504 0 0 0 17.951-7.368l.067-.134c4.558-4.487 7.354-10.838 7.354-17.817 0-7.056-2.796-13.38-7.354-17.952h-.067c-4.55-4.625-10.896-7.42-17.951-7.42-7.029 0-13.326 2.795-17.822 7.42h-.13c-4.535 4.572-7.358 10.896-7.358 17.952 0 6.98 2.823 13.33 7.359 17.817l.129.134a25.148 25.148 0 0 0 17.822 7.368Zm137.972-76.72c6.275-1.646 11.957-5.673 15.423-11.761l.468-.887c3.082-5.776 3.644-12.44 1.998-18.344-1.659-6.324-5.735-11.917-11.81-15.418l-.352-.237c-5.918-3.242-12.662-3.947-18.857-2.274-6.297 1.57-11.952 5.775-15.4 11.814-3.492 5.981-4.223 12.88-2.55 19.231 1.725 6.244 5.761 11.89 11.796 15.418h.04c6.047 3.475 12.898 4.104 19.244 2.458ZM95.97 180.387c-6.654-6.637-15.824-10.794-25.988-10.794-10.124 0-19.272 4.157-25.912 10.794-6.61 6.614-10.686 15.76-10.686 25.898 0 10.165 4.076 19.339 10.686 26.029 6.64 6.582 15.788 10.712 25.912 10.712 10.164 0 19.334-4.13 25.988-10.712 6.623-6.69 10.7-15.864 10.7-26.029 0-10.137-4.077-19.284-10.7-25.898Zm-14.61-43.164c14.726 2.426 27.976 9.482 38.087 19.673h.08a72.44 72.44 0 0 1 4.625 5.147l25.284-14.629c-3.399-10.271-3.555-21.01-.826-31.072 3.609-13.487 12.35-25.56 25.453-33.137l.433-.26c12.96-7.345 27.696-8.861 41-5.253a54.523 54.523 0 0 1 33.186 25.48v.026c7.529 13.015 9.059 27.96 5.464 41.393-3.581 13.478-12.363 25.631-25.453 33.155l-3.452 2.043h-.352c-12.109 5.771-25.426 6.663-37.655 3.447-10.044-2.667-19.258-8.26-26.47-16.23l-25.243 14.585a69.649 69.649 0 0 1 4.509 24.694c0 8.702-1.61 17.09-4.51 24.824l25.244 14.53c7.212-8.072 16.426-13.562 26.47-16.229 13.469-3.684 28.405-2.114 41.46 5.49l.833.393v.053c12.613 7.627 21.078 19.441 24.619 32.767a54.432 54.432 0 0 1-5.464 41.344l-.454.914-.054-.08c-7.564 12.573-19.48 21.091-32.638 24.695-13.5 3.554-28.432 2.038-41.473-5.46v-.106c-13.103-7.578-21.844-19.678-25.453-33.133-2.729-10.035-2.573-20.779.826-31.046l-25.284-14.584c-1.45 1.78-3.02 3.452-4.625 5.071l-.08.076c-10.11 10.142-23.361 17.198-38.088 19.548v29.217c10.494 2.194 19.9 7.448 27.273 14.816l.035.08c9.88 9.825 15.994 23.517 15.994 38.57 0 15.003-6.115 28.61-15.994 38.489l-.035.156c-9.946 9.879-23.598 15.993-38.65 15.993-14.972 0-28.642-6.114-38.56-15.993h-.036v-.156c-9.893-9.879-16.02-23.486-16.02-38.49a54.262 54.262 0 0 1 16.02-38.569v-.08h.035c7.36-7.368 16.779-12.622 27.246-14.816v-29.217c-14.74-2.35-27.95-9.406-38.048-19.548l-.107-.076C7.89 243.053 0 225.624 0 206.285c0-19.284 7.89-36.714 20.511-49.389h.107c10.098-10.19 23.308-17.247 38.048-19.673v-29.087A55.34 55.34 0 0 1 31.42 93.293h-.035v-.08c-9.893-9.928-16.02-23.518-16.02-38.57 0-14.976 6.127-28.695 16.02-38.574l.035-.049C41.34 6.115 55.01 0 69.98 0c15.053 0 28.705 6.115 38.65 16.02v.05h.036c9.88 9.878 15.994 23.597 15.994 38.573 0 15.052-6.115 28.642-15.994 38.57l-.035.08c-7.373 7.319-16.779 12.568-27.273 14.843v29.087Zm142.017-19.392-.21-.312c-3.492-5.882-9.058-9.803-15.213-11.502-6.346-1.672-13.197-.963-19.284 2.511h.04c-6.075 3.448-10.138 9.094-11.837 15.418a25.314 25.314 0 0 0 2.551 19.231l.116.16a24.985 24.985 0 0 0 15.284 11.57 24.829 24.829 0 0 0 19.21-2.48l.325-.156c5.905-3.528 9.838-9.094 11.484-15.208 1.673-6.298 1.008-13.197-2.466-19.232Z"
            />
        </svg>
    );
}

export function GrapeIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            xmlSpace="preserve"
            viewBox="0 0 512 512"
            className="icon" width="32px" height="32px">
            <path
                d="M438.557 512H19.785c-8.216 0-14.876-6.66-14.876-14.876V256.916c0-8.216 6.66-14.876 14.876-14.876s14.876 6.66 14.876 14.876v225.332h389.021v-32.833c0-8.216 6.661-14.876 14.876-14.876s14.876 6.66 14.876 14.876v47.709c-.001 8.216-6.662 14.876-14.877 14.876z"
                style={{
                    fill: "#2d527c",
                }}
            />
            <path
                d="M19.785 177.122v-4.79L175.581 14.876v162.246zM196.154 219.435h296.061v163.65H196.154z"
                style={{
                    fill: "#cee8fa",
                }}
            />
            <path
                d="M492.215 204.559h-38.782V14.876C453.433 6.66 446.772 0 438.557 0H175.581c-.182 0-.361.021-.543.027a14.949 14.949 0 0 0-2.41.269c-.018.003-.036.01-.054.013-.613.126-1.211.302-1.8.504-.158.054-.315.11-.472.171-.58.22-1.148.466-1.697.756-.024.012-.048.021-.071.034-.567.305-1.105.66-1.63 1.037a10.84 10.84 0 0 0-.403.302c-.521.402-1.026.827-1.495 1.3L9.21 161.868c-.35.353-.678.721-.988 1.104-.207.254-.388.521-.576.784-.092.131-.195.256-.283.388a15.3 15.3 0 0 0-.592.998c-.046.083-.1.162-.143.245-.183.345-.342.701-.495 1.056-.037.086-.082.168-.116.256-.14.341-.256.689-.369 1.038-.036.112-.08.219-.113.33-.095.321-.17.646-.242.971-.033.147-.076.293-.106.442-.058.3-.095.604-.134.907-.024.177-.057.353-.074.53-.028.303-.034.607-.045.912-.006.167-.024.332-.024.498v4.792c0 8.216 6.66 14.876 14.876 14.876h155.796c8.216 0 14.876-6.66 14.876-14.876V29.752h233.225v174.807H196.156c-8.216 0-14.876 6.66-14.876 14.876v163.644c0 8.216 6.66 14.876 14.876 14.876h296.059c8.215 0 14.876-6.66 14.876-14.876V219.435c0-8.216-6.661-14.876-14.876-14.876zM50.691 162.246 160.705 51.06v111.186H50.691zm426.648 205.957H211.032V234.311H477.34v133.892z"
                style={{
                    fill: "#2d527c",
                }}
            />
            <path
                d="M265.4 270.343c-3.927 0-6.153-4.188-6.153-9.031 0-4.189 1.831-8.771 6.153-8.771h22.907c4.451 0 8.902 2.095 8.902 6.285v59.298c0 22.516-14.269 30.894-31.418 30.894-18.718 0-32.857-9.949-32.857-27.36 0-7.854 3.273-9.687 10.342-9.687 5.236 0 9.687 1.309 10.078 6.153.393 5.105 1.047 13.091 11.521 13.091 7.593 0 11.913-4.188 11.913-13.091v-47.78H265.4v-.001zM304.411 339.854c0-.393.131-.916.262-1.44l24.349-79.853c1.44-4.58 7.331-6.806 13.353-6.806s11.913 2.225 13.353 6.806l24.48 79.853c.131.524.262 1.047.262 1.44 0 4.844-7.463 8.378-13.091 8.378-3.273 0-5.891-1.047-6.676-3.796l-4.451-16.364h-27.62l-4.449 16.364c-.785 2.749-3.404 3.796-6.676 3.796-5.636 0-13.096-3.534-13.096-8.378zm47.518-27.491-9.556-35.082-9.556 35.082h19.112zM388.06 258.693c0-3.271 2.487-6.153 6.284-6.153h27.098c17.934 0 32.2 6.676 32.2 28.014 0 14.66-6.675 23.038-15.838 26.573l15.971 28.929c.524.785.653 1.703.653 2.356 0 5.105-6.807 10.604-12.829 10.604-2.618 0-5.105-1.047-6.544-3.796L417.12 310.4h-8.64v31.547c0 4.189-5.107 6.284-10.211 6.284s-10.209-2.093-10.209-6.284v-83.254zm20.421 11.65v24.349h12.96c7.331 0 11.78-3.011 11.78-12.176 0-9.162-4.449-12.174-11.78-12.174h-12.96v.001z"
                style={{
                    fill: "#2d527c",
                }}
            />
        </svg>
    );
}

export function MachineLearningIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <path
                d="M27 24a2.96 2.96 0 0 0-1.285.3l-4.3-4.3H18v2h2.586l3.715 3.715A2.966 2.966 0 0 0 24 27a3 3 0 1 0 3-3Zm0 4a1 1 0 1 1 1-1 1 1 0 0 1-1 1ZM27 13a2.995 2.995 0 0 0-2.816 2H18v2h6.184A2.995 2.995 0 1 0 27 13Zm0 4a1 1 0 1 1 1-1 1 1 0 0 1-1 1ZM27 2a3.003 3.003 0 0 0-3 3 2.966 2.966 0 0 0 .348 1.373L20.596 10H18v2h3.404l4.4-4.252A2.999 2.999 0 1 0 27 2Zm0 4a1 1 0 1 1 1-1 1 1 0 0 1-1 1Z"/>
            <path
                d="M18 6h2V4h-2a3.976 3.976 0 0 0-3 1.382A3.976 3.976 0 0 0 12 4h-1a9.01 9.01 0 0 0-9 9v6a9.01 9.01 0 0 0 9 9h1a3.976 3.976 0 0 0 3-1.382A3.976 3.976 0 0 0 18 28h2v-2h-2a2.002 2.002 0 0 1-2-2V8a2.002 2.002 0 0 1 2-2Zm-6 20h-1a7.005 7.005 0 0 1-6.92-6H6v-2H4v-4h3a3.003 3.003 0 0 0 3-3V9H8v2a1 1 0 0 1-1 1H4.08A7.005 7.005 0 0 1 11 6h1a2.002 2.002 0 0 1 2 2v4h-2v2h2v4h-2a3.003 3.003 0 0 0-3 3v2h2v-2a1 1 0 0 1 1-1h2v4a2.002 2.002 0 0 1-2 2Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function TerminalIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <title>{"terminal"}</title>
            <path
                d="M26 4.01H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-20a2 2 0 0 0-2-2Zm0 2v4H6v-4Zm-20 20v-14h20v14Z"/>
            <path d="m10.76 16.18 2.82 2.83-2.82 2.83 1.41 1.41 4.24-4.24-4.24-4.24-1.41 1.41z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function SapIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 1024 1024"
            className="icon" width="32px" height="32px">
            <circle
                cx={512}
                cy={512}
                r={512}
                style={{
                    fill: "#007cc5",
                }}
            />
            <path
                d="M256 359.88v304.24h310.82L871 359.88zm83.62 56.58h.14c22.11 0 49.06 6.29 68.56 16.22l-21 36.64C365.92 459 355.17 458 343 457.36c-18.14-1-27.26 5.51-27.4 12.5-.18 8.52 17.13 16.23 33.45 21.47 24.7 7.85 56.1 18.33 60.9 48.7l45.15-119.36h52.45l52.88 142.91-.2-142.86H621c57.84 0 85 19.58 85 64.53 0 40.36-28 64.42-75.25 64.42h-19.56l-.19 53.69-92-.09-6.38-23.27a101.65 101.65 0 0 1-31.56 4.83 100.52 100.52 0 0 1-32.32-5.12l-9.19 23.54-51.25.16 2.3-11.84c-.73.64-1.43 1.29-2.22 1.91-13.7 11-30.94 16.11-52.18 16.49h-5.48c-24.41 0-45.89-5.78-66.13-17.28l18.71-37.12c20.26 12 33 14.68 50.11 14.31 8.89-.18 15.32-1.8 19.52-6.13a14.29 14.29 0 0 0 4-9.45c.17-9.64-13.56-14.17-30.36-19.37-13.62-4.22-29.08-10-41.17-18.83-14.31-10.53-21.12-23.69-20.78-42.27a51 51 0 0 1 14.49-35.31c13.31-13.76 34.76-22.12 60.54-22.12zm271.55 42.8v48.8h13.35c17.78 0 32-5.92 32-24.72 0-18.16-14.19-24.09-32-24.09zm-130.32 19.65-19.17 60.54a54.92 54.92 0 0 0 19.38 3.39 56.79 56.79 0 0 0 19-3.22l-18.87-60.71z"
                style={{
                    fill: "#fff",
                }}
            />
        </svg>
    );
}

export function ScriptIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <title>{"script"}</title>
            <path
                d="m18.83 26 2.58-2.58L20 22l-4 4 4 4 1.42-1.41L18.83 26zM27.17 26l-2.58 2.58L26 30l4-4-4-4-1.42 1.41L27.17 26z"/>
            <path
                d="M14 28H8V4h8v6a2.006 2.006 0 0 0 2 2h6v6h2v-8a.91.91 0 0 0-.3-.7l-7-7A.909.909 0 0 0 18 2H8a2.006 2.006 0 0 0-2 2v24a2.006 2.006 0 0 0 2 2h6Zm4-23.6 5.6 5.6H18Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function ValidationIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <path d="m22 27.18-2.59-2.59L18 26l4 4 8-8-1.41-1.41L22 27.18z"/>
            <path
                d="M15 28H8V4h8v6a2.006 2.006 0 0 0 2 2h6v6h2v-8a.91.91 0 0 0-.3-.7l-7-7A.909.909 0 0 0 18 2H8a2.006 2.006 0 0 0-2 2v24a2.006 2.006 0 0 0 2 2h7Zm3-23.6 5.6 5.6H18Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function OpenstackIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            preserveAspectRatio="xMidYMid"
            viewBox="0 -2.5 256 256"
            className="icon" width="32px" height="32px">
            <path
                fill="#DA1A32"
                d="M57.82 170.723v9.156c0 7.104 5.756 12.86 12.86 12.86h114.65c7.104 0 12.86-5.756 12.86-12.86v-9.156H256v56.051c0 13.082-10.703 23.785-23.785 23.785H23.785C10.703 250.559 0 239.856 0 226.774v-56.051h57.82Zm-.01-74.353v57.809H0v-57.81h57.81Zm198.19 0v57.809h-57.81v-57.81H256ZM232.215 0C245.297 0 256 10.703 256 23.795v56.041h-57.81V70.68c0-7.104-5.756-12.86-12.86-12.86H70.67c-7.104 0-12.86 5.756-12.86 12.86v9.156H0V23.785C0 10.703 10.703 0 23.785 0Z"
            />
        </svg>
    );
}

export function OpenshiftIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            preserveAspectRatio="xMidYMid"
            viewBox="0 -9.5 256 256"
            className="icon" width="32px" height="32px">
            <path
                fill="#DA2430"
                d="m74.84 106.893-40.869 14.87c.525 6.552 1.652 13.024 3.24 19.366l38.818-14.137c-1.244-6.552-1.689-13.32-1.18-20.1M255.444 61.702c-2.85-5.879-6.147-11.561-9.966-16.916l-40.857 14.87c4.755 4.864 8.743 10.33 12.007 16.176L255.445 61.7v.002Z"
            />
            <path
                fill="#DA2430"
                d="M182.95 61.461c-5.14-4.46-10.946-8.31-17.408-11.324h-.003C127.6 32.449 82.33 48.905 64.642 86.859a73.976 73.976 0 0 0-2.653 6.487c-2.208 6.423-3.498 12.99-3.991 19.546l-.144.054-.011.144-24.596 8.95-15.826 5.849-.007-.088-.434.158c-1.536-19.435 1.74-39.512 10.553-58.411a117.952 117.952 0 0 1 3.687-7.246c29.054-54.116 95.164-76.736 150.918-50.33a115.314 115.314 0 0 1 30.557 21.074 116.597 116.597 0 0 1 15.78 17.94L187.618 65.86a79.69 79.69 0 0 0-.635-.641l-.113.041a78.61 78.61 0 0 0-3.919-3.798Z"
            />
            <path
                fill="#E82429"
                d="m19.261 193.896-.064.024A118.404 118.404 0 0 1 .939 154.347l38.825-14.14.002.003.024.125.252-.093.006.015c1.994 10.56 6.145 20.635 12.198 29.494a75.287 75.287 0 0 0 7.722 9.326l-.154.057.294.308-40.488 14.97c-.12-.171-.24-.343-.359-.516Z"
            />
            <path
                fill="#DA2430"
                d="M173.465 183.447c-21.051 13.017-48.053 15.532-72.113 4.312a75.139 75.139 0 0 1-22.118-15.695l-40.772 14.844.313.437-.02.008c11.21 16.016 26.502 29.404 45.266 38.298 40.47 19.163 86.387 12.501 119.634-13.284 14.888-11.152 27.317-26.016 35.713-44.02 8.819-18.895 12.076-38.964 10.515-58.384l-1.136.414c-.015-.208-.03-.416-.047-.624l-40.49 14.957.002.004a76.457 76.457 0 0 1-6.806 26.46c-6.315 13.753-16.164 24.708-27.94 32.273Z"
            />
            <path
                fill="#E82429"
                d="m218.552 75.13.607-.222v-.001a117.732 117.732 0 0 1 11.454 42.055l-40.773 14.834.022-.304-.77.285c1.11-15.088-2.275-30.093-9.435-43.123l38.548-14.25.002-.004c.116.243.231.486.345.73Z"
            />
            <path
                fill="#C22035"
                d="M74.89 106.654 34.31 121.65c.52 6.61 1.64 13.136 3.219 19.532l38.546-14.258c-1.247-6.622-1.695-13.438-1.169-20.274M254.227 61.083c-2.83-5.929-6.106-11.658-9.898-17.059L203.76 59.02c4.72 4.906 8.68 10.418 11.92 16.315l38.542-14.256.006.004Z"
            />
            <path
                fill="#AC223B"
                d="m34.308 121.653 40.482-14.829-.165 8.133-39.056 14.749-1.266-8.063.005.01ZM203.766 58.897l41.113-14.108 4.273 6.449-39.946 14.121-5.434-6.465-.006.003Z"
            />
            <path
                fill="#B92135"
                d="m38.764 187.201 40.53-14.749 12.258 11.565-42.503 15.956-10.283-12.776-.002.004ZM249.38 109.862l-41.165 14.844-3.032 16.478 43.892-15.643.311-15.677-.005-.002Z"
            />
        </svg>
    );
}

export function RefIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <path
                d="M4 20v2h4.586L2 28.586 3.414 30 10 23.414V28h2v-8H4zM30 30h-8v-8h8Zm-6-2h4v-4h-4ZM20 20h-8v-8h8Zm-6-2h4v-4h-4Z"/>
            <path d="M24 17h-2v-2h2a4 4 0 0 0 0-8H12V5h12a6 6 0 0 1 0 12ZM10 10H2V2h8ZM4 8h4V4H4Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function RedisIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            preserveAspectRatio="xMidYMid"
            viewBox="0 -18 256 256"
            className="icon" width="32px" height="32px">
            <path
                fill="#912626"
                d="M245.97 168.943c-13.662 7.121-84.434 36.22-99.501 44.075-15.067 7.856-23.437 7.78-35.34 2.09-11.902-5.69-87.216-36.112-100.783-42.597C3.566 169.271 0 166.535 0 163.951v-25.876s98.05-21.345 113.879-27.024c15.828-5.679 21.32-5.884 34.79-.95 13.472 4.936 94.018 19.468 107.331 24.344l-.006 25.51c.002 2.558-3.07 5.364-10.024 8.988"
            />
            <path
                fill="#C6302B"
                d="M245.965 143.22c-13.661 7.118-84.431 36.218-99.498 44.072-15.066 7.857-23.436 7.78-35.338 2.09-11.903-5.686-87.214-36.113-100.78-42.594-13.566-6.485-13.85-10.948-.524-16.166 13.326-5.22 88.224-34.605 104.055-40.284 15.828-5.677 21.319-5.884 34.789-.948 13.471 4.934 83.819 32.935 97.13 37.81 13.316 4.881 13.827 8.9.166 16.02"
            />
            <path
                fill="#912626"
                d="M245.97 127.074c-13.662 7.122-84.434 36.22-99.501 44.078-15.067 7.853-23.437 7.777-35.34 2.087-11.903-5.687-87.216-36.112-100.783-42.597C3.566 127.402 0 124.67 0 122.085V96.206s98.05-21.344 113.879-27.023c15.828-5.679 21.32-5.885 34.79-.95C162.142 73.168 242.688 87.697 256 92.574l-.006 25.513c.002 2.557-3.07 5.363-10.024 8.987"
            />
            <path
                fill="#C6302B"
                d="M245.965 101.351c-13.661 7.12-84.431 36.218-99.498 44.075-15.066 7.854-23.436 7.777-35.338 2.087-11.903-5.686-87.214-36.112-100.78-42.594-13.566-6.483-13.85-10.947-.524-16.167C23.151 83.535 98.05 54.148 113.88 48.47c15.828-5.678 21.319-5.884 34.789-.949 13.471 4.934 83.819 32.933 97.13 37.81 13.316 4.88 13.827 8.9.166 16.02"
            />
            <path
                fill="#912626"
                d="M245.97 83.653c-13.662 7.12-84.434 36.22-99.501 44.078-15.067 7.854-23.437 7.777-35.34 2.087-11.903-5.687-87.216-36.113-100.783-42.595C3.566 83.98 0 81.247 0 78.665v-25.88s98.05-21.343 113.879-27.021c15.828-5.68 21.32-5.884 34.79-.95C162.142 29.749 242.688 44.278 256 49.155l-.006 25.512c.002 2.555-3.07 5.361-10.024 8.986"
            />
            <path
                fill="#C6302B"
                d="M245.965 57.93c-13.661 7.12-84.431 36.22-99.498 44.074-15.066 7.854-23.436 7.777-35.338 2.09C99.227 98.404 23.915 67.98 10.35 61.497-3.217 55.015-3.5 50.55 9.825 45.331 23.151 40.113 98.05 10.73 113.88 5.05c15.828-5.679 21.319-5.883 34.789-.948 13.471 4.935 83.819 32.934 97.13 37.811 13.316 4.876 13.827 8.897.166 16.017"
            />
            <path
                fill="#FFF"
                d="m159.283 32.757-22.01 2.285-4.927 11.856-7.958-13.23-25.415-2.284 18.964-6.839-5.69-10.498 17.755 6.944 16.738-5.48-4.524 10.855 17.067 6.391M131.032 90.275 89.955 73.238l58.86-9.035-17.783 26.072M74.082 39.347c17.375 0 31.46 5.46 31.46 12.194 0 6.736-14.085 12.195-31.46 12.195s-31.46-5.46-31.46-12.195c0-6.734 14.085-12.194 31.46-12.194"
            />
            <path
                fill="#621B1C"
                d="m185.295 35.998 34.836 13.766-34.806 13.753-.03-27.52"
            />
            <path
                fill="#9A2928"
                d="m146.755 51.243 38.54-15.245.03 27.519-3.779 1.478-34.791-13.752"
            />
        </svg>
    );
}

export function SearchIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <path
                d="m29 27.586-7.552-7.552a11.018 11.018 0 1 0-1.414 1.414L27.586 29ZM4 13a9 9 0 1 1 9 9 9.01 9.01 0 0 1-9-9Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function BlockchainIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <title>{"blockchain"}</title>
            <path d="M6 24H4V8h2ZM28 8h-2v16h2Zm-4-2V4H8v2Zm0 22v-2H8v2Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function ChatIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <title>{"chat"}</title>
            <path
                d="M17.74 30 16 29l4-7h6a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h9v2H6a4 4 0 0 1-4-4V8a4 4 0 0 1 4-4h20a4 4 0 0 1 4 4v12a4 4 0 0 1-4 4h-4.84Z"/>
            <path d="M8 10h16v2H8zM8 16h10v2H8z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function WorkflowIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            xmlSpace="preserve"
            viewBox="0 0 512 512"
            className="icon" width="32px" height="32px">
            <path
                d="M445.66 49.341H340.206L294.008 3.143c-4.192-4.191-10.99-4.191-15.183 0l-49.341 49.342c-4.192 4.192-4.192 10.99 0 15.183l46.198 46.198v38.494h-80.516c-5.929 0-10.736 4.806-10.736 10.735v21.471h-42.942v-21.471c0-5.929-4.806-10.735-10.736-10.735H66.34c-5.929 0-10.735 4.806-10.735 10.735v64.413c0 5.929 4.806 10.735 10.735 10.735h20.755v93.798c0 5.929 4.806 10.736 10.735 10.736h95.437l-10.346 10.346c-4.192 4.192-4.193 10.99 0 15.182a10.7 10.7 0 0 0 7.591 3.144c2.747 0 5.495-1.049 7.591-3.144l15.061-15.061c3.994 8.83 10.521 16.859 19.311 23.54 11.932 9.068 26.987 14.783 43.205 16.539v32.792h-42.942c-5.929 0-10.735 4.806-10.735 10.736v64.413c0 5.929 4.806 10.735 10.735 10.735h107.355c5.929 0 10.735-4.806 10.735-10.735v-64.413c0-5.929-4.806-10.736-10.735-10.736h-42.942v-32.792c16.218-1.756 31.272-7.471 43.205-16.539 8.801-6.689 15.332-14.73 19.325-23.572l15.092 15.092c2.097 2.097 4.844 3.144 7.591 3.144s5.495-1.049 7.591-3.144c4.192-4.192 4.192-10.99 0-15.182l-10.346-10.346h66.05c5.929 0 10.736-4.806 10.736-10.736V60.077c.001-5.929-4.806-10.736-10.735-10.736zM252.257 60.078l34.16-34.16 34.16 34.16-34.16 34.16-34.16-34.16zm-46.356 113.754h161.032v42.942H205.901v-42.942zM77.075 216.774v-42.942h42.942v42.942H77.075zm136.174 94.148-15.143-15.143c-4.192-4.192-10.99-4.192-15.183 0-4.192 4.192-4.192 10.99 0 15.183l10.346 10.346h-84.702v-83.063h22.187c5.929 0 10.735-4.806 10.735-10.735v-21.471h42.942v21.471c0 5.929 4.806 10.735 10.735 10.735h80.516v32.792c-16.218 1.756-31.272 7.471-43.205 16.539-8.727 6.632-15.227 14.592-19.228 23.346zm116.11 136.665v42.942h-85.884v-42.942h85.884zm-42.942-75.148c-31.078 0-56.361-18.059-56.361-40.258s25.283-40.258 56.361-40.258c31.078 0 56.361 18.059 56.361 40.258s-25.282 40.258-56.361 40.258zm93.193-51.131 10.347-10.346c4.192-4.192 4.192-10.99 0-15.183-4.192-4.191-10.99-4.191-15.183 0l-15.175 15.175c-4-8.766-10.505-16.738-19.242-23.378-11.932-9.068-26.987-14.783-43.205-16.539v-32.792h80.516c5.929 0 10.735-4.806 10.735-10.735v-64.413c0-5.929-4.806-10.735-10.735-10.735h-80.516v-38.494l43.054-43.054h94.718v250.494H379.61z"/>
        </svg>
    );
}

export function WebserviceIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <title>{"fog"}</title>
            <path
                d="M25.829 13.116A10.02 10.02 0 0 0 16 5v2a8.023 8.023 0 0 1 7.865 6.493l.259 1.346 1.349.245A5.502 5.502 0 0 1 24.508 26H16v2h8.508a7.502 7.502 0 0 0 1.32-14.884ZM8 24h6v2H8zM4 24h2v2H4zM6 20h8v2H6zM2 20h2v2H2zM8 16h6v2H8zM4 16h2v2H4zM10 12h4v2h-4zM6 12h2v2H6zM12 8h2v2h-2z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function MobileIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <path d="M23 7h4v4h-4zM23 13h4v4h-4zM17 7h4v4h-4zM17 13h4v4h-4z"/>
            <circle cx={14.5} cy={24.5} r={1.5}/>
            <path
                d="M21 30H8a2.002 2.002 0 0 1-2-2V4a2.002 2.002 0 0 1 2-2h13v2H8v24h13v-8h2v8a2.002 2.002 0 0 1-2 2Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function ClusterIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <path
                d="M16 7a3 3 0 1 1 3-3 3.003 3.003 0 0 1-3 3Zm0-4a1 1 0 1 0 1 1 1.001 1.001 0 0 0-1-1ZM11 30a3 3 0 1 1 3-3 3.003 3.003 0 0 1-3 3Zm0-4a1 1 0 1 0 1 1 1.001 1.001 0 0 0-1-1ZM7 11a3 3 0 1 1 3-3 3.003 3.003 0 0 1-3 3Zm0-4a1 1 0 1 0 1 1 1.001 1.001 0 0 0-1-1ZM21 30a3 3 0 1 1 3-3 3.003 3.003 0 0 1-3 3Zm0-4a1 1 0 1 0 1 1 1.001 1.001 0 0 0-1-1ZM25 11a3 3 0 1 1 3-3 3.003 3.003 0 0 1-3 3Zm0-4a1 1 0 1 0 1 1 1.001 1.001 0 0 0-1-1ZM4 21a3 3 0 1 1 3-3 3.003 3.003 0 0 1-3 3Zm0-4a1 1 0 1 0 1 1 1.001 1.001 0 0 0-1-1ZM28 21a3 3 0 1 1 3-3 3.003 3.003 0 0 1-3 3Zm0-4a1 1 0 1 0 1 1 1.001 1.001 0 0 0-1-1ZM16 22a6 6 0 1 1 6-6 6.007 6.007 0 0 1-6 6Zm0-10a4 4 0 1 0 4 4 4.005 4.005 0 0 0-4-4Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function RpcIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <path d="m14 26 1.41-1.41L7.83 17H28v-2H7.83l7.58-7.59L14 6 4 16l10 10z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function InfinispanIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            id="artwork"
            viewBox="0 0 1024 1024"
            className="icon" width="32px" height="32px">
            <defs>
                <style>{".cls-2{fill:#fff}"}</style>
            </defs>
            <path
                d="M1 1h1022v1022H1z"
                style={{
                    fill: "#599fc6",
                }}
            />
            <path
                d="M566.84 512c0-221.39-179.47-400.86-400.86-400.86v109.68c160.56 0 291.18 130.62 291.18 291.18 0 221.39 179.47 400.86 400.86 400.86V803.18c-160.56 0-291.18-130.62-291.18-291.18Z"
                className="cls-2"
            />
            <path
                d="M436.76 618.86C394.05 726.69 288.82 803.18 166 803.18v109.68c134.26 0 253-66.07 325.76-167.4a432.16 432.16 0 0 1-55-126.6ZM587.24 405.14C630 297.31 735.19 220.82 858 220.82V111.14c-134.26 0-253 66.07-325.77 167.4a431.92 431.92 0 0 1 55.01 126.6Z"
                className="cls-2"
            />
        </svg>
    );
}

export function TransformationIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <title>{"data-share"}</title>
            <path
                d="M5 25v-9.172l-3.586 3.586L0 18l6-6 6 6-1.414 1.414L7 15.828V25h12v2H7a2.002 2.002 0 0 1-2-2ZM24 22h4a2.002 2.002 0 0 1 2 2v4a2.002 2.002 0 0 1-2 2h-4a2.002 2.002 0 0 1-2-2v-4a2.002 2.002 0 0 1 2-2Zm4 6v-4h-4.002L24 28ZM27 6v9.172l3.586-3.586L32 13l-6 6-6-6 1.414-1.414L25 15.172V6H13V4h12a2.002 2.002 0 0 1 2 2ZM2 6h6v2H2zM2 2h8v2H2z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function TestingIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <path
                d="M28 17v5H4V6h10V4H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h8v4H8v2h16v-2h-4v-4h8a2 2 0 0 0 2-2v-5ZM18 28h-4v-4h4Z"/>
            <path
                d="M30 10V8h-2.101a4.968 4.968 0 0 0-.732-1.753l1.49-1.49-1.414-1.414-1.49 1.49A4.968 4.968 0 0 0 24 4.101V2h-2v2.101a4.968 4.968 0 0 0-1.753.732l-1.49-1.49-1.414 1.414 1.49 1.49A4.968 4.968 0 0 0 18.101 8H16v2h2.101a4.968 4.968 0 0 0 .732 1.753l-1.49 1.49 1.414 1.414 1.49-1.49a4.968 4.968 0 0 0 1.753.732V16h2v-2.101a4.968 4.968 0 0 0 1.753-.732l1.49 1.49 1.414-1.414-1.49-1.49A4.968 4.968 0 0 0 27.899 10Zm-7 2a3 3 0 1 1 3-3 3.003 3.003 0 0 1-3 3Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function ApiIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <title>{"api"}</title>
            <path
                d="M26 22a3.86 3.86 0 0 0-2 .57l-3.09-3.1a6 6 0 0 0 0-6.94L24 9.43a3.86 3.86 0 0 0 2 .57 4 4 0 1 0-4-4 3.86 3.86 0 0 0 .57 2l-3.1 3.09a6 6 0 0 0-6.94 0L9.43 8A3.86 3.86 0 0 0 10 6a4 4 0 1 0-4 4 3.86 3.86 0 0 0 2-.57l3.09 3.1a6 6 0 0 0 0 6.94L8 22.57A3.86 3.86 0 0 0 6 22a4 4 0 1 0 4 4 3.86 3.86 0 0 0-.57-2l3.1-3.09a6 6 0 0 0 6.94 0l3.1 3.09a3.86 3.86 0 0 0-.57 2 4 4 0 1 0 4-4Zm0-18a2 2 0 1 1-2 2 2 2 0 0 1 2-2ZM4 6a2 2 0 1 1 2 2 2 2 0 0 1-2-2Zm2 22a2 2 0 1 1 2-2 2 2 0 0 1-2 2Zm10-8a4 4 0 1 1 4-4 4 4 0 0 1-4 4Zm10 8a2 2 0 1 1 2-2 2 2 0 0 1-2 2Z"/>
            <path
                d="M0 0h32v32H0z"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function KameletIcon() {
    return (
        <svg
            className="icon" id="icon"
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
        >
            <title>{"application"}</title>
            <path d="M16 18H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2ZM6 6v10h10V6ZM26 12v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2ZM26 22v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2ZM16 22v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2Z" />
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    )
}


    export function MonitoringIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <path
                d="M28 16v6H4V6h7V4H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h8v4H8v2h16v-2h-4v-4h8a2 2 0 0 0 2-2v-6ZM18 28h-4v-4h4Z"/>
            <path
                d="M18 18h-.01a1 1 0 0 1-.951-.725L15.246 11H11V9h5a1 1 0 0 1 .962.725l1.074 3.76 3.009-9.78A1.014 1.014 0 0 1 22 3a.98.98 0 0 1 .949.684L24.72 9H30v2h-6a1 1 0 0 1-.949-.684l-1.013-3.04-3.082 10.018A1 1 0 0 1 18 18Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function NetworkingIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            xmlSpace="preserve"
            viewBox="0 0 511.984 511.984"
            className="icon" width="32px" height="32px">
            <path
                d="M207.29 287.991H48.735C30.687 287.991 16 302.375 16 320.054v111.868c0 17.679 14.688 32.063 32.735 32.063H207.29c18.031 0 32.703-14.384 32.703-32.063V320.054c0-17.679-14.672-32.063-32.703-32.063zm0 143.996-159.291-.064.736-111.932 159.259.064.048 111.645c0 .015-.192.287-.752.287z"/>
            <path
                d="M383.988 239.992H127.996c-8.832 0-16 7.168-16 16v47.998c0 8.832 7.168 16 16 16s15.999-7.168 15.999-16v-31.999h223.993v31.999c0 8.832 7.168 16 16 16s15.999-7.168 15.999-16v-47.998c0-8.832-7.167-16-15.999-16z"/>
            <path
                d="M463.25 287.991H304.727c-18.047 0-32.735 14.384-32.735 32.063v111.868c0 17.679 14.688 32.063 32.735 32.063H463.25c18.047 0 32.735-14.384 32.735-32.063V320.054c-.001-17.679-14.688-32.063-32.735-32.063zm0 143.996-159.259-.064.736-111.932 159.259.064.064 111.645c-.016-.001-.208.287-.8.287zM415.987 479.985h-63.998c-8.832 0-16 7.168-16 16s7.168 16 16 16h63.998c8.832 0 16-7.168 16-16s-7.168-16-16-16zM335.253 0H176.73c-18.047 0-32.735 14.384-32.735 32.063v111.869c0 17.679 14.688 32.063 32.735 32.063h158.523c18.047 0 32.735-14.384 32.735-32.063V32.063C367.989 14.384 353.301 0 335.253 0zm.001 143.995-159.259-.064.736-111.932 159.259.064.064 111.645c-.016 0-.208.287-.8.287zM287.991 191.994h-63.998c-8.832 0-15.999 7.168-15.999 16s7.168 15.999 15.999 15.999h63.998c8.832 0 15.999-7.168 15.999-15.999s-7.167-16-15.999-16zM159.995 479.985H95.997c-8.832 0-16 7.168-16 16s7.168 16 16 16h63.998c8.832 0 16-7.168 16-16s-7.168-16-16-16z"/>
            <path
                d="M255.992 191.994c-8.832 0-16 7.168-16 16v47.998c0 8.832 7.168 16 16 16s15.999-7.168 15.999-16v-47.998c.001-8.832-7.167-16-15.999-16z"/>
        </svg>
    );
}

export function HealthIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            xmlSpace="preserve"
            id="Icons"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <style>
                {
                    ".st0{fill:none;stroke:#000;stroke-width:2;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:10}"
                }
            </style>
            <path
                d="M27 7h0c-2.6-2.7-6.9-2.7-9.5 0l-1.3 1.4c-.1.1-.4.1-.5 0L14.4 7C11.8 4.3 7.6 4.3 5 7h0c-2.6 2.7-2.6 7.1 0 9.8l1.6 1.6 9.2 9.5c.1.1.4.1.5 0l9.2-9.5 1.6-1.6c2.6-2.7 2.6-7.1-.1-9.8z"
                className="st0"
            />
            <path d="M9 15h3l2-2 2 4 2-5 2 3h3" className="st0"/>
        </svg>
    );
}

export function KubernetesIcon(className?: string) {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 -10.44 722.846 722.846"
            className={className ? className  + " icon" : "icon"}
            width="32px" height="32px">
            <path
                fill="#326ce5"
                d="M358.986 10.06a46.725 46.342 0 0 0-17.906 4.531L96.736 131.341a46.725 46.342 0 0 0-25.28 31.438l-60.282 262.25a46.725 46.342 0 0 0 6.344 35.531 46.725 46.342 0 0 0 2.656 3.688l169.125 210.28a46.725 46.342 0 0 0 36.531 17.438l271.219-.062a46.725 46.342 0 0 0 36.531-17.406l169.063-210.313a46.725 46.342 0 0 0 9.03-39.219L651.3 162.716a46.725 46.342 0 0 0-25.281-31.437L381.643 14.59a46.725 46.342 0 0 0-22.657-4.53z"
            />
            <path
                fill="#fff"
                stroke="#fff"
                strokeWidth={0.25}
                d="M361.408 99.307c-8.077.001-14.626 7.276-14.625 16.25 0 .138.028.27.03.406-.011 1.22-.07 2.689-.03 3.75.192 5.176 1.32 9.138 2 13.907 1.23 10.206 2.26 18.667 1.625 26.531-.62 2.965-2.803 5.677-4.75 7.562l-.344 6.188a190.337 190.337 0 0 0-26.438 4.062c-37.974 8.623-70.67 28.184-95.562 54.594a245.167 245.167 0 0 1-5.281-3.75c-2.612.353-5.25 1.159-8.688-.844-6.545-4.405-12.506-10.486-19.719-17.812-3.305-3.504-5.698-6.841-9.625-10.219-.891-.767-2.252-1.804-3.25-2.594-3.07-2.447-6.69-3.724-10.187-3.843-4.496-.154-8.824 1.604-11.656 5.156-5.036 6.315-3.424 15.968 3.593 21.562.071.057.147.101.219.157.964.781 2.145 1.783 3.031 2.437 4.167 3.077 7.973 4.652 12.125 7.094 8.747 5.402 15.999 9.88 21.75 15.281 2.246 2.394 2.639 6.613 2.938 8.438l4.687 4.187c-25.093 37.764-36.707 84.41-29.843 131.938l-6.125 1.781c-1.615 2.085-3.896 5.365-6.282 6.344-7.525 2.37-15.994 3.24-26.218 4.312-4.8.4-8.943.161-14.032 1.125-1.12.212-2.68.619-3.906.906l-.125.032c-.067.015-.155.048-.219.062-8.62 2.083-14.157 10.006-12.375 17.813 1.783 7.808 10.203 12.556 18.875 10.687.063-.014.154-.017.219-.031.098-.022.184-.07.281-.094 1.21-.265 2.724-.56 3.782-.843 5.003-1.34 8.626-3.308 13.125-5.032 9.676-3.47 17.691-6.37 25.5-7.5 3.26-.255 6.697 2.012 8.406 2.969l6.375-1.094c14.67 45.483 45.414 82.245 84.344 105.313l-2.657 6.375c.958 2.475 2.014 5.824 1.3 8.27-2.838 7.36-7.7 15.13-13.237 23.792-2.681 4.002-5.425 7.108-7.844 11.688-.579 1.096-1.316 2.78-1.875 3.937-3.759 8.043-1.002 17.305 6.219 20.782 7.266 3.497 16.284-.192 20.187-8.25.006-.012.026-.02.031-.032.004-.009-.004-.022 0-.03.556-1.143 1.344-2.645 1.813-3.72 2.072-4.747 2.762-8.815 4.219-13.406 3.87-9.72 5.995-19.919 11.322-26.274 1.459-1.74 3.837-2.41 6.303-3.07l3.312-6c33.938 13.027 71.927 16.523 109.875 7.907a189.77 189.77 0 0 0 25.094-7.563c.93 1.651 2.661 4.826 3.125 5.625 2.506.815 5.24 1.236 7.469 4.531 3.985 6.81 6.71 14.865 10.031 24.594 1.457 4.591 2.178 8.66 4.25 13.406.472 1.082 1.256 2.605 1.812 3.75 3.895 8.085 12.943 11.787 20.22 8.282 7.219-3.478 9.979-12.74 6.218-20.782-.559-1.158-1.327-2.841-1.906-3.937-2.42-4.58-5.163-7.655-7.844-11.656-5.537-8.662-10.13-15.858-12.969-23.22-1.187-3.796.2-6.157 1.125-8.624-.554-.635-1.739-4.22-2.437-5.906 40.457-23.889 70.298-62.022 84.312-106.063 1.893.298 5.182.88 6.25 1.094 2.2-1.45 4.222-3.344 8.188-3.031 7.808 1.129 15.823 4.03 25.5 7.5 4.498 1.723 8.121 3.723 13.125 5.062 1.057.283 2.572.547 3.781.813.097.023.183.071.281.093.066.015.156.017.219.032 8.672 1.866 17.094-2.88 18.875-10.688 1.78-7.807-3.754-15.732-12.375-17.812-1.254-.286-3.032-.77-4.25-1-5.09-.964-9.231-.727-14.031-1.125-10.225-1.072-18.694-1.943-26.219-4.313-3.068-1.19-5.251-4.841-6.313-6.344l-5.906-1.718c3.062-22.155 2.237-45.212-3.062-68.282-5.349-23.284-14.8-44.58-27.407-63.343 1.515-1.378 4.377-3.911 5.188-4.657.237-2.624.033-5.375 2.75-8.281 5.751-5.4 13.003-9.879 21.75-15.281 4.152-2.443 7.99-4.017 12.156-7.094.942-.696 2.23-1.798 3.219-2.594 7.015-5.596 8.63-15.248 3.594-21.562-5.037-6.314-14.797-6.91-21.813-1.313-.998.791-2.353 1.823-3.25 2.594-3.926 3.378-6.351 6.714-9.656 10.219-7.213 7.326-13.174 13.438-19.719 17.844-2.836 1.65-6.99 1.08-8.875.968l-5.562 3.969c-31.72-33.26-74.905-54.525-121.406-58.656-.13-1.949-.3-5.471-.344-6.532-1.904-1.821-4.204-3.376-4.781-7.312-.637-7.864.426-16.325 1.656-26.531.679-4.769 1.807-8.73 2-13.907.044-1.176-.027-2.884-.031-4.156-.001-8.974-6.548-16.25-14.625-16.25zm-18.313 113.438-4.344 76.718-.312.157c-.292 6.863-5.94 12.343-12.875 12.343-2.841 0-5.463-.912-7.594-2.468l-.125.062-62.906-44.594c19.333-19.01 44.063-33.06 72.562-39.53a154.125 154.125 0 0 1 15.594-2.688zm36.656 0c33.274 4.092 64.045 19.159 87.625 42.25l-62.5 44.312-.218-.093c-5.548 4.051-13.364 3.046-17.688-2.375a12.807 12.807 0 0 1-2.812-7.47l-.063-.03zM232.126 283.62l57.438 51.375-.063.312c5.185 4.507 5.95 12.328 1.625 17.75a12.892 12.892 0 0 1-6.687 4.406l-.063.25-73.625 21.25c-3.747-34.265 4.329-67.573 21.375-95.343zm258.157.03c8.534 13.833 14.996 29.283 18.843 46.032 3.801 16.548 4.755 33.067 3.188 49.031l-74-21.312-.063-.313c-6.626-1.81-10.699-8.551-9.156-15.312a12.786 12.786 0 0 1 4.094-6.844l-.031-.156 57.125-51.125zm-140.657 55.313h23.532l14.625 18.282-5.25 22.812-21.125 10.156-21.188-10.187-5.25-22.813zm75.438 62.563c1-.05 1.995.04 2.969.219l.125-.157 76.156 12.875c-11.146 31.314-32.473 58.44-60.969 76.594l-29.562-71.406.093-.125c-2.715-6.31.002-13.71 6.25-16.719 1.6-.77 3.271-1.197 4.938-1.281zm-127.906.312c5.811.082 11.024 4.116 12.375 10.032.632 2.77.324 5.513-.72 7.937l.22.281-29.25 70.688c-27.348-17.549-49.13-43.824-60.782-76.063l75.5-12.812.125.156c.845-.155 1.701-.23 2.532-.219zm63.78 30.97a12.764 12.764 0 0 1 6.032 1.28c2.56 1.233 4.537 3.174 5.781 5.5h.282l37.218 67.25a154.256 154.256 0 0 1-14.875 4.157c-28.464 6.463-56.838 4.504-82.53-4.25l37.124-67.125h.063a12.91 12.91 0 0 1 10.906-6.813z"
                color="#000"
                fontFamily="Sans"
                fontWeight={400}
                overflow="visible"
                style={{
                    textIndent: 0,
                    textAlign: "start",
                    lineHeight: "normal",
                    textTransform: "none",
                    marker: "none",
                }}
            />
        </svg>
    );
}

export function DocumentIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            className="icon" width="32px" height="32px">
            <title>{"document--blank"}</title>
            <path
                d="m25.7 9.3-7-7A.908.908 0 0 0 18 2H8a2.006 2.006 0 0 0-2 2v24a2.006 2.006 0 0 0 2 2h16a2.006 2.006 0 0 0 2-2V10a.908.908 0 0 0-.3-.7ZM18 4.4l5.6 5.6H18ZM24 28H8V4h8v6a2.006 2.006 0 0 0 2 2h6Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    );
}

export function GitIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            fill="none"
            viewBox="0 0 24 24"
            className="icon" width="32px" height="32px">
            <path
                fill="#000"
                fillRule="evenodd"
                d="M13.414 3.828a2 2 0 0 0-2.828 0l-.672.672 1.568 1.568a2.002 2.002 0 0 1 2.45 2.45l2.05 2.05a2 2 0 1 1-1.414 1.414L13 10.414v4.854A2 2 0 0 1 12 19a2 2 0 0 1-1-3.732V9.732a2 2 0 0 1-.932-2.25L8.5 5.914l-4.672 4.672a2 2 0 0 0 0 2.828l6.758 6.758a2 2 0 0 0 2.828 0l6.758-6.758a2 2 0 0 0 0-2.828l-6.758-6.758ZM9.172 2.414a4 4 0 0 1 5.656 0l6.758 6.758a4 4 0 0 1 0 5.656l-6.758 6.758a4 4 0 0 1-5.656 0l-6.758-6.758a4 4 0 0 1 0-5.656l6.758-6.758Z"
                clipRule="evenodd"
            />
        </svg>
    );
}

export function SocialIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 1024 1024"
            className="icon" width="32px" height="32px">
            <path
                fill="#FFB89A"
                d="M570.2 842c-50.6 0-278.7-180-278.7-401.9 0-58.8-2.9-133.1-1-183.9-50.8 3.2-91.4 45.7-91.4 97.3v272.1c37.4 194.7 137.5 334 255.2 334 69.5 0 132.9-48.6 180.9-128.5-20.8 7.1-42.6 10.9-65 10.9z"
            />
            <path
                fill="#4E5155"
                d="M926.1 191.8C900.5 74.1 817.9 62.1 704.9 62.1c-29.1 0-60.3.8-93 .8-36 0-70.5-1.1-102.5-1.1-109.7 0-189.8 12.5-201.3 123.7-20.4 198.3 30 617.1 306.1 617.1S939 414.3 926.1 191.8zm-76.9 268.5c-9.5 47.9-22.3 90.8-38.1 127.7-16.8 39.2-37 71.4-60 95.8-37.3 39.5-82.1 58.7-137 58.7-53.4 0-97.6-20.1-134.9-61.6-45.5-50.5-79.8-131.5-99-234.2-15.6-83.5-20.3-178.9-12.4-255.2 1.8-17.3 5.7-30.7 11.6-39.8 4.4-6.8 10.1-11.7 18.7-15.8 25.8-12.5 70.8-14.2 111.4-14.2 15 0 30.7.2 47.3.5 17.8.3 36.2.6 55.2.6 17.2 0 33.9-.2 50-.4 15.1-.2 29.3-.4 43.1-.4 44.5 0 89.5 1.8 118 15.1 15.9 7.4 33.4 20.8 43.6 63 2.6 53.3 3.6 153.5-17.5 260.2z"
            />
            <path
                fill="#4E5155"
                d="M532 841.7c-32.5 22.3-70.6 33.7-113.2 33.7-29.7 0-57.3-6-82.1-17.7-23.2-11-44.7-27.4-63.9-48.7-46-50.9-80.3-131.3-99.2-232.4-15.1-80.6-19.6-172.9-12-246.8 3-29.5 12-50.2 27.5-63.2 14.2-12 35.1-19.2 65.8-22.9 16.5-2 28.2-16.9 26.3-33.3-2-16.5-16.9-28.2-33.3-26.3-42.9 5.1-73.8 16.7-97.4 36.5-27.9 23.5-43.8 57.2-48.5 103-8.2 79.3-3.4 178.1 12.7 264 9.7 51.9 23.4 99.4 40.6 141.2 19.8 48.1 44.4 88.6 73 120.4 51.6 57.2 115.7 86.2 190.6 86.2 55 0 104.5-14.9 147.2-44.2 13.7-9.4 17.1-28.1 7.7-41.7-9.4-13.7-28.1-17.2-41.8-7.8z"
            />
            <path
                fill="#3C9"
                d="M519.7 248.5c-16.6 0-30 13.4-30 30v91.3c0 16.6 13.4 30 30 30s30-13.4 30-30v-91.3c0-16.6-13.5-30-30-30zm-220.2 137c0-16.6-13.4-30-30-30s-30 13.4-30 30v91.3c0 16.6 13.4 30 30 30s30-13.4 30-30v-91.3zm455.1-137c-16.6 0-30 13.4-30 30v91.3c0 16.6 13.4 30 30 30s30-13.4 30-30v-91.3c0-16.6-13.4-30-30-30zm-37.9 306c0-16.6-13.4-30-30-30H551v30c0 58.5 38.1 123.7 92.8 123.7 22.9 0 45-11.9 62.2-33.6 10.3-13 8.1-31.9-4.9-42.1-13-10.3-31.9-8.1-42.1 4.9-5.3 6.7-11.1 10.9-15.1 10.9-4.3 0-11.9-5.1-19.1-16.4-3.3-5.3-6.2-11.2-8.4-17.4h70.4c16.4 0 29.9-13.4 29.9-30zM401.6 704c-25.4 0-46.1-24.2-46.1-53.9 0-16.6-13.4-30-30-30s-30 13.4-30 30c0 62.8 47.6 113.9 106.1 113.9 16.6 0 30-13.4 30-30s-13.5-30-30-30z"
            />
        </svg>
    );
}

export function DebeziumIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
            viewBox="0 0 130.93 130.93"
            className="icon" width="32px" height="32px">
            <defs>
                <linearGradient
                    id="linear-gradient"
                    x1={19.74}
                    x2={114.03}
                    y1={19.73}
                    y2={114.02}
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset={0} stopColor="#91d443"/>
                    <stop offset={1} stopColor="#48bfe0"/>
                </linearGradient>
                <linearGradient
                    xlinkHref="#linear-gradient"
                    id="linear-gradient-2"
                    x1={43.19}
                    x2={137.48}
                    y1={-3.72}
                    y2={90.57}
                />
                <linearGradient
                    xlinkHref="#linear-gradient"
                    id="linear-gradient-3"
                    x1={66.56}
                    x2={160.85}
                    y1={-27.09}
                    y2={67.2}
                />
                <linearGradient
                    xlinkHref="#linear-gradient"
                    id="linear-gradient-4"
                    x1={-3.72}
                    x2={90.57}
                    y1={43.18}
                    y2={137.47}
                />
                <linearGradient
                    xlinkHref="#linear-gradient"
                    id="linear-gradient-5"
                    x1={-27.09}
                    x2={67.2}
                    y1={66.55}
                    y2={160.84}
                />
                <style>{".cls-1{fill:#fff}"}</style>
            </defs>
            <g id="Layer_1" data-name="Layer 1">
                <path
                    d="M93.79 114.29a16.65 16.65 0 0 0 16.63 16.63h20.53v-20.53a16.65 16.65 0 0 0-16.63-16.63h-3.91A26.39 26.39 0 0 1 84 67.4v-3.89a16.65 16.65 0 0 0-16.59-16.62h-3.9a26.39 26.39 0 0 1-26.35-26.37v-3.9A16.65 16.65 0 0 0 20.53 0H0v20.52a16.65 16.65 0 0 0 16.63 16.63h3.91A26.39 26.39 0 0 1 46.9 63.51v3.89A16.65 16.65 0 0 0 63.53 84h3.9a26.39 26.39 0 0 1 26.36 26.36Z"
                    style={{
                        fill: "url(#linear-gradient)",
                    }}
                />
                <path
                    d="M130.94 63.51a16.65 16.65 0 0 0-16.63-16.63h-3.91A26.39 26.39 0 0 1 84 20.52v-3.9A16.65 16.65 0 0 0 67.41 0H46.9v20.75a16.64 16.64 0 0 0 16.62 16.4h3.91a26.39 26.39 0 0 1 26.36 26.36v3.89A16.65 16.65 0 0 0 110.36 84h20.58Z"
                    style={{
                        fill: "url(#linear-gradient-2)",
                    }}
                />
                <path
                    d="M130.94 16.49A16.63 16.63 0 0 0 115 0H93.47v20.7a16.64 16.64 0 0 0 16.62 16.44h20.85Z"
                    style={{
                        fill: "url(#linear-gradient-3)",
                    }}
                />
                <path
                    d="M0 67.44a16.65 16.65 0 0 0 16.64 16.62h3.91a26.39 26.39 0 0 1 26.36 26.36v3.89a16.65 16.65 0 0 0 16.63 16.63H84v-20.75A16.64 16.64 0 0 0 67.43 93.8h-3.9a26.39 26.39 0 0 1-26.37-26.36v-3.9a16.65 16.65 0 0 0-16.57-16.63H0Z"
                    style={{
                        fill: "url(#linear-gradient-4)",
                    }}
                />
                <path
                    d="M0 114.45a16.63 16.63 0 0 0 16 16.5h21.48v-20.71A16.64 16.64 0 0 0 20.86 93.8H0Z"
                    style={{
                        fill: "url(#linear-gradient-5)",
                    }}
                />
            </g>
        </svg>
    );
}

export function IgniteIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            fill="none"
            viewBox="0 0 48 48"
            className="icon" width="32px" height="32px">
            <path
                fill="#ED1C24"
                d="M7.686 8.136S-8.95 18.28 6.73 28.355c3.016 1.962 13.956 7.418 13.644 12.466 0 0 6.631-9.81-3.064-15.983C7.351 18.52 4.862 11.772 7.686 8.135Z"
            />
            <path
                fill="#ED1C24"
                d="M1.893 27.517s-5.936 8.997 5.745 10.84c1.15.144 9.6 1.029 11.802 3.804 0 0-.192-4.785-7.086-7.609-6.87-2.823-9.695-3.517-10.46-7.035Zm22.981-9.451C17.74 10.6 15.754 5.982 18.818 0c0 0-21.281 8.183-.264 22.708 7.517 5.192 6.272 10.504 6.272 10.696 1.173-1.22 7.181-7.873.048-15.338Z"
            />
        </svg>
    );
}

export function HazelcastIcon() {
    return (
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 133.3 133.3" className="icon" width="32px" height="32px">
            <defs>
                <style>{".a{fill:#00e1e1}"}</style>
            </defs>
            <path
                d="M133.3 92.85h-.38c-6.07 0-12.48-6.42-12.48-12.49V80h-.93v.38c0 6.07-6.42 12.49-12.49 12.49h-.38v.93h.36c6.07 0 12.49 6.41 12.49 12.48v.38h.93v-.38c0-6.07 6.41-12.48 12.48-12.48h.38v-.93ZM26.66 12.86h-.38C20.21 12.86 13.8 6.45 13.8.38V0h-.94v.38c0 6.07-6.41 12.48-12.48 12.48H0v.94h.38c6.07 0 12.48 6.41 12.48 12.48v.38h.94v-.38c0-6.07 6.41-12.48 12.48-12.48h.38v-.94Z"
                className="a"
            />
            <path
                d="M26.66 39.53h-.38c-6.07 0-12.48-6.42-12.48-12.53v-.38h-.94V27c0 6.07-6.41 12.49-12.48 12.49H0v.93h.38c6.07 0 12.48 6.41 12.48 12.48v.38h.94v-.38c0-6.07 6.41-12.48 12.48-12.48h.38v-.93Z"
                className="a"
            />
            <path
                d="M53.32 39.53h-.38c-6.07 0-12.48-6.42-12.48-12.49v-.38h-.94V27c0 6.07-6.41 12.49-12.48 12.49h-.38v.93H27c6.07 0 12.48 6.41 12.48 12.48v.38h.94v-.38c0-6.07 6.41-12.48 12.48-12.48h.38v-.93ZM26.66 66.19h-.38c-6.07 0-12.48-6.42-12.48-12.49v-.38h-.94v.38c0 6.07-6.41 12.49-12.48 12.49H0v.93h.38c6.07 0 12.48 6.41 12.48 12.48v.4h.94v-.4c0-6.07 6.41-12.48 12.48-12.48h.38v-.93Z"
                className="a"
            />
            <path
                d="M53.32 66.19h-.38c-6.07 0-12.48-6.42-12.48-12.49v-.38h-.94v.38c0 6.07-6.41 12.49-12.48 12.49h-.38v.93H27c6.07 0 12.48 6.41 12.48 12.48v.4h.94v-.4c0-6.07 6.41-12.48 12.48-12.48h.38v-.93Z"
                className="a"
            />
            <path
                d="M80 66.19h-.4c-6.07 0-12.48-6.42-12.48-12.49v-.38h-.94v.38c0 6.07-6.41 12.49-12.48 12.49h-.38v.93h.38c6.07 0 12.48 6.41 12.48 12.48v.4h.94v-.4c0-6.07 6.41-12.48 12.48-12.48h.4v-.93ZM26.66 92.85h-.38c-6.07 0-12.48-6.42-12.48-12.49V80h-.94v.38c0 6.07-6.41 12.49-12.48 12.49H0v.93h.38c6.07 0 12.48 6.41 12.48 12.48v.38h.94v-.38c0-6.07 6.41-12.48 12.48-12.48h.38v-.93Z"
                className="a"
            />
            <path
                d="M53.32 92.85h-.38c-6.07 0-12.48-6.42-12.48-12.49V80h-.94v.38c0 6.07-6.41 12.49-12.48 12.49h-.38v.93H27c6.07 0 12.48 6.41 12.48 12.48v.38h.94v-.38c0-6.07 6.41-12.48 12.48-12.48h.38v-.93ZM106.64 39.53h-.38c-6.07 0-12.48-6.42-12.48-12.49v-.38h-.93V27c0 6.07-6.42 12.49-12.49 12.49H80v.93h.38c6.07 0 12.49 6.41 12.49 12.48v.38h.93v-.38c0-6.07 6.41-12.48 12.48-12.48h.38v-.93ZM106.64 66.19h-.38c-6.07 0-12.48-6.42-12.48-12.49v-.38h-.93v.38c0 6.07-6.42 12.49-12.49 12.49H80v.93h.38c6.07 0 12.49 6.41 12.49 12.48v.4h.93v-.4c0-6.07 6.41-12.48 12.48-12.48h.38v-.93Z"
                className="a"
            />
            <path
                d="M106.64 92.85h-.38c-6.07 0-12.48-6.42-12.48-12.49V80h-.93v.38c0 6.07-6.42 12.49-12.49 12.49H80v.93h.38c6.07 0 12.49 6.41 12.49 12.48v.38h.93v-.38c0-6.07 6.41-12.48 12.48-12.48h.38v-.93ZM133.3 39.53h-.38c-6.07 0-12.48-6.42-12.48-12.49v-.38h-.93V27c0 6.07-6.42 12.49-12.49 12.49h-.38v.93h.36c6.07 0 12.49 6.41 12.49 12.48v.38h.93v-.38c0-6.07 6.41-12.48 12.48-12.48h.38v-.93ZM133.3 12.86h-.38c-6.07 0-12.48-6.41-12.48-12.48V0h-.93v.38c0 6.07-6.42 12.48-12.49 12.48h-.38v.94h.36c6.07 0 12.49 6.41 12.49 12.48v.38h.93v-.38c0-6.07 6.41-12.48 12.48-12.48h.38v-.94ZM133.3 66.19h-.38c-6.07 0-12.48-6.42-12.48-12.49v-.38h-.93v.38c0 6.07-6.42 12.49-12.49 12.49h-.38v.93h.36c6.07 0 12.49 6.41 12.49 12.48v.4h.93v-.4c0-6.07 6.41-12.48 12.48-12.48h.38v-.93ZM133.3 119.51h-.38c-6.07 0-12.48-6.42-12.48-12.49v-.38h-.93v.36c0 6.07-6.42 12.49-12.49 12.49h-.38v.93h.36c6.07 0 12.49 6.41 12.49 12.48v.38h.93v-.38c0-6.07 6.41-12.48 12.48-12.48h.38v-.93ZM26.66 119.51h-.38c-6.07 0-12.48-6.42-12.48-12.49v-.38h-.94v.36c0 6.07-6.41 12.49-12.48 12.49H0v.93h.38c6.07 0 12.48 6.41 12.48 12.48v.38h.94v-.38c0-6.07 6.41-12.48 12.48-12.48h.38v-.93Z"
                className="a"
            />
        </svg>
    );
}

export function AzureIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 96 96"
            className="icon" width="32px" height="32px">
            <defs>
                <linearGradient
                    id="a"
                    x1={-1032.172}
                    x2={-1059.213}
                    y1={145.312}
                    y2={65.426}
                    gradientTransform="matrix(1 0 0 -1 1075 158)"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset={0} stopColor="#114a8b"/>
                    <stop offset={1} stopColor="#0669bc"/>
                </linearGradient>
                <linearGradient
                    id="b"
                    x1={-1023.725}
                    x2={-1029.98}
                    y1={108.083}
                    y2={105.968}
                    gradientTransform="matrix(1 0 0 -1 1075 158)"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset={0} stopOpacity={0.3}/>
                    <stop offset={0.071} stopOpacity={0.2}/>
                    <stop offset={0.321} stopOpacity={0.1}/>
                    <stop offset={0.623} stopOpacity={0.05}/>
                    <stop offset={1} stopOpacity={0}/>
                </linearGradient>
                <linearGradient
                    id="c"
                    x1={-1027.165}
                    x2={-997.482}
                    y1={147.642}
                    y2={68.561}
                    gradientTransform="matrix(1 0 0 -1 1075 158)"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset={0} stopColor="#3ccbf4"/>
                    <stop offset={1} stopColor="#2892df"/>
                </linearGradient>
            </defs>
            <path
                fill="url(#a)"
                d="M33.338 6.544h26.038l-27.03 80.087a4.152 4.152 0 0 1-3.933 2.824H8.149a4.145 4.145 0 0 1-3.928-5.47L29.404 9.368a4.152 4.152 0 0 1 3.934-2.825z"
            />
            <path
                fill="#0078d4"
                d="M71.175 60.261h-41.29a1.911 1.911 0 0 0-1.305 3.309l26.532 24.764a4.171 4.171 0 0 0 2.846 1.121h23.38z"
            />
            <path
                fill="url(#b)"
                d="M33.338 6.544a4.118 4.118 0 0 0-3.943 2.879L4.252 83.917a4.14 4.14 0 0 0 3.908 5.538h20.787a4.443 4.443 0 0 0 3.41-2.9l5.014-14.777 17.91 16.705a4.237 4.237 0 0 0 2.666.972H81.24L71.024 60.261l-29.781.007L59.47 6.544z"
            />
            <path
                fill="url(#c)"
                d="M66.595 9.364a4.145 4.145 0 0 0-3.928-2.82H33.648a4.146 4.146 0 0 1 3.928 2.82l25.184 74.62a4.146 4.146 0 0 1-3.928 5.472h29.02a4.146 4.146 0 0 0 3.927-5.472z"
            />
        </svg>
    );
}


