/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Generated by karavan build tools - do NOT edit this file!
 */
export class ElementMeta {
    name: string = ''
    className: string = ''
    title: string = ''
    description: string = ''
    labels: string = ''
    properties: PropertyMeta[] = []
    exchangeProperties: ExchangePropertyMeta[] = []

    constructor(name: string, className: string, title: string, description: string, labels: string, properties: PropertyMeta[], exchangeProperties: ExchangePropertyMeta[]) {
        this.name = name;
        this.className = className;
        this.title = title;
        this.description = description;
        this.labels = labels;
        this.properties = properties;
        this.exchangeProperties = exchangeProperties;
    }
}

export class PropertyMeta {
    name: string = ''
    displayName: string = ''
    description: string = ''
    type: string = ''
    enumVals: string = ''
    defaultValue: string = ''
    required: boolean = false
    secret: boolean = false
    isArray: boolean = false
    isObject: boolean = false
    label: string = ''
    javaType: string = ''

    constructor(name: string, displayName: string, description: string, type: string, enumVals: string,
                defaultValue: string, required: boolean, secret: boolean, isArray: boolean, isObject: boolean,
                label: string, javaType: string) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.type = type;
        this.enumVals = enumVals;
        this.defaultValue = defaultValue;
        this.required = required;
        this.secret = secret;
        this.isArray = isArray;
        this.isObject = isObject;
        this.label = label;
        this.javaType = javaType;
    }
}

export class ExchangePropertyMeta {
    name: string = ''
    displayName: string = ''
    label: string = ''
    javaType: string = ''
    description: string = ''

    constructor(name: string, displayName: string, label: string, javaType: string, description: string) {
        this.name = name;
        this.displayName = displayName;
        this.label = label;
        this.javaType = javaType;
        this.description = description;
    }
}

export class CamelMetadataApi {

    static getCamelModelMetadataByName = (name: string): ElementMeta | undefined => {
       return CamelModelMetadata.find(value => value.name === name);
    }

    static getCamelModelMetadataByClassName = (className: string): ElementMeta | undefined => {
        return CamelModelMetadata.find(value => value.className === className);
    }

    static getCamelDataFormatMetadataByName = (name: string): ElementMeta | undefined => {
        return CamelDataFormatMetadata.find(value => value.name === name);
    }

    static getCamelDataFormatMetadataByClassName = (className: string): ElementMeta | undefined => {
        return CamelDataFormatMetadata.find(value => value.className === className);
    }

    static getCamelLanguageMetadataByClassName = (className: string): ElementMeta | undefined => {
        return CamelLanguageMetadata.find(value => value.className === className);
    }

    static getCamelLanguageMetadataByName = (name: string): ElementMeta | undefined => {
        return CamelLanguageMetadata.find(value => value.name === name);
    }

    static getLanguage = (name: string): [string, string, string] | undefined => {
        return Languages.find(value => value[0] === name);
    }

    static hasLanguage = (name: string): boolean | undefined => {
        return Languages.filter(value => value[0] === name).length > 0;
    }

    static getExchangeProperties = (className: string): ExchangePropertyMeta [] => {
        return CamelModelMetadata.find(e => e.className === className)?.exchangeProperties || [];
    }
}

export const DataFormats: [string, string, string][] = [
    ['asn1','ASN.1 File',"Encode and decode data structures using Abstract Syntax Notation One (ASN.1)."],
    ['avro','Avro',"Serialize and deserialize messages using Apache Avro binary data format."],
    ['barcode','Barcode',"Transform strings to various 1D/2D barcode bitmap formats and back."],
    ['base64','Base64',"Encode and decode data using Base64."],
    ['beanio','BeanIO',"Marshal and unmarshal Java beans to and from flat files (such as CSV, delimited, or fixed length formats)."],
    ['bindy','Bindy',"Marshal and unmarshal Java beans from and to flat payloads (such as CSV, delimited, fixed length formats, or FIX messages)."],
    ['cbor','CBOR',"Unmarshal a CBOR payload to POJO and back."],
    ['crypto','Crypto (Java Cryptographic Extension)',"Encrypt and decrypt messages using Java Cryptography Extension (JCE)."],
    ['csv','CSV',"Handle CSV (Comma Separated Values) payloads."],
    ['custom','Custom',"Delegate to a custom org.apache.camel.spi.DataFormat implementation via Camel registry."],
    ['fhirJson','FHIR JSon',"Marshall and unmarshall FHIR objects to/from JSON."],
    ['fhirXml','FHIR XML',"Marshall and unmarshall FHIR objects to/from XML."],
    ['flatpack','Flatpack',"Marshal and unmarshal Java lists and maps to/from flat files (such as CSV, delimited, or fixed length formats) using Flatpack library."],
    ['grok','Grok',"Unmarshal unstructured data to objects using Logstash based Grok patterns."],
    ['gzipDeflater','GZip Deflater',"Compress and decompress messages using java.util.zip.GZIPStream."],
    ['hl7','HL7',"Marshal and unmarshal HL7 (Health Care) model objects using the HL7 MLLP codec."],
    ['ical','iCal',"Marshal and unmarshal iCal (.ics) documents to/from model objects."],
    ['jacksonXml','Jackson XML',"Unmarshal an XML payloads to POJOs and back using XMLMapper extension of Jackson."],
    ['jaxb','JAXB',"Unmarshal XML payloads to POJOs and back using JAXB2 XML marshalling standard."],
    ['json','JSon',"Marshal POJOs to JSON and back."],
    ['jsonApi','JSonApi',"Marshal and unmarshal JSON:API resources using JSONAPI-Converter library."],
    ['lzf','LZF Deflate Compression',"Compress and decompress streams using LZF deflate algorithm."],
    ['mimeMultipart','MIME Multipart',"Marshal Camel messages with attachments into MIME-Multipart messages and back."],
    ['parquetAvro','Parquet File',"Parquet Avro serialization and de-serialization."],
    ['pgp','PGP',"Encrypt and decrypt messages using Java Cryptographic Extension (JCE) and PGP."],
    ['protobuf','Protobuf',"Serialize and deserialize Java objects using Google's Protocol buffers."],
    ['rss','RSS',"Transform from ROME SyndFeed Java Objects to XML and vice-versa."],
    ['soap','SOAP',"Marshal Java objects to SOAP messages and back."],
    ['swiftMt','SWIFT MT',"Encode and decode SWIFT MT messages."],
    ['swiftMx','SWIFT MX',"Encode and decode SWIFT MX messages."],
    ['syslog','Syslog',"Marshall SyslogMessages to RFC3164 and RFC5424 messages and back."],
    ['tarFile','Tar File',"Archive files into tarballs or extract files from tarballs."],
    ['thrift','Thrift',"Serialize and deserialize messages using Apache Thrift binary data format."],
    ['tidyMarkup','TidyMarkup',"Parse (potentially invalid) HTML into valid HTML or DOM."],
    ['univocityCsv','uniVocity CSV',"Marshal and unmarshal Java objects from and to CSV (Comma Separated Values) using UniVocity Parsers."],
    ['univocityFixed','uniVocity Fixed Length',"Marshal and unmarshal Java objects from and to fixed length records using UniVocity Parsers."],
    ['univocityTsv','uniVocity TSV',"Marshal and unmarshal Java objects from and to TSV (Tab-Separated Values) records using UniVocity Parsers."],
    ['xmlSecurity','XML Security',"Encrypt and decrypt XML payloads using Apache Santuario."],
    ['yaml','YAML',"Marshal and unmarshal Java objects to and from YAML."],
    ['zipDeflater','Zip Deflater',"Compress and decompress streams using java.util.zip.Deflater and java.util.zip.Inflater."],
    ['zipFile','Zip File',"Compression and decompress streams using java.util.zip.ZipStream."],
]

export const CamelDataFormatMetadata: ElementMeta[] = [
    new ElementMeta('asn1', 'ASN1DataFormat', 'ASN.1 File', "Encode and decode data structures using Abstract Syntax Notation One (ASN.1).", 'dataformat,transformation,file', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('unmarshalType', 'Unmarshal Type', "Class to use when unmarshalling.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('usingIterator', 'Using Iterator', "If the asn1 file has more than one entry, the setting this option to true, allows working with the splitter EIP, to split the data using an iterator in a streaming mode.", 'boolean', '', 'false', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('avro', 'AvroDataFormat', 'Avro', "Serialize and deserialize messages using Apache Avro binary data format.", 'dataformat,transformation', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('instanceClassName', 'Instance Class Name', "Class name to use for marshal and unmarshalling", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('library', 'Library', "Which Avro library to use.", 'string', 'ApacheAvro, Jackson', 'avroJackson', false, false, false, false, '', ''),
        new PropertyMeta('objectMapper', 'Object Mapper', "Lookup and use the existing ObjectMapper with the given id when using Jackson.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('useDefaultObjectMapper', 'Use Default Object Mapper', "Whether to lookup and use default Jackson ObjectMapper from the registry.", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('unmarshalType', 'Unmarshal Type', "Class name of the java type to use when unmarshalling", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('jsonView', 'Json View', "When marshalling a POJO to JSON you might want to exclude certain fields from the JSON output. With Jackson you can use JSON views to accomplish this. This option is to refer to the class which has JsonView annotations", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('include', 'Include', "If you want to marshal a pojo to JSON, and the pojo has some fields with null values. And you want to skip these null values, you can set this option to NON_NULL", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('allowJmsType', 'Allow Jms Type', "Used for JMS users to allow the JMSType header from the JMS spec to specify a FQN classname to use to unmarshal to.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('collectionType', 'Collection Type', "Refers to a custom collection type to lookup in the registry to use. This option should rarely be used, but allows to use different collection types than java.util.Collection based as default.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('useList', 'Use List', "To unmarshal to a List of Map or a List of Pojo.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('moduleClassNames', 'Module Class Names', "To use custom Jackson modules com.fasterxml.jackson.databind.Module specified as a String with FQN class names. Multiple classes can be separated by comma.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('moduleRefs', 'Module Refs', "To use custom Jackson modules referred from the Camel registry. Multiple modules can be separated by comma.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableFeatures', 'Enable Features', "Set of features to enable on the Jackson com.fasterxml.jackson.databind.ObjectMapper. The features should be a name that matches a enum from com.fasterxml.jackson.databind.SerializationFeature, com.fasterxml.jackson.databind.DeserializationFeature, or com.fasterxml.jackson.databind.MapperFeature Multiple features can be separated by comma", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disableFeatures', 'Disable Features', "Set of features to disable on the Jackson com.fasterxml.jackson.databind.ObjectMapper. The features should be a name that matches a enum from com.fasterxml.jackson.databind.SerializationFeature, com.fasterxml.jackson.databind.DeserializationFeature, or com.fasterxml.jackson.databind.MapperFeature Multiple features can be separated by comma", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('allowUnmarshallType', 'Allow Unmarshall Type', "If enabled then Jackson is allowed to attempt to use the CamelJacksonUnmarshalType header during the unmarshalling. This should only be enabled when desired to be used.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('timezone', 'Timezone', "If set then Jackson will use the Timezone when marshalling/unmarshalling.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('autoDiscoverObjectMapper', 'Auto Discover Object Mapper', "If set to true then Jackson will lookup for an objectMapper into the registry", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('contentTypeHeader', 'Content Type Header', "Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('schemaResolver', 'Schema Resolver', "Optional schema resolver used to lookup schemas for the data in transit.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('autoDiscoverSchemaResolver', 'Auto Discover Schema Resolver', "When not disabled, the SchemaResolver will be looked up into the registry", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('barcode', 'BarcodeDataFormat', 'Barcode', "Transform strings to various 1D/2D barcode bitmap formats and back.", 'dataformat,transformation', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('barcodeFormat', 'Barcode Format', "Barcode format such as QR-Code", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('imageType', 'Image Type', "Image type of the barcode such as png", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('width', 'Width', "Width of the barcode", 'number', '', '', false, false, false, false, '', ''),
        new PropertyMeta('height', 'Height', "Height of the barcode", 'number', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('base64', 'Base64DataFormat', 'Base64', "Encode and decode data using Base64.", 'dataformat,transformation', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('lineLength', 'Line Length', "To specific a maximum line length for the encoded data. By default 76 is used.", 'number', '', '76', false, false, false, false, '', ''),
        new PropertyMeta('lineSeparator', 'Line Separator', "The line separators to use. Uses new line characters (CRLF) by default.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('urlSafe', 'Url Safe', "Instead of emitting '' and '/' we emit '-' and '_' respectively. urlSafe is only applied to encode operations. Decoding seamlessly handles both modes. Is by default false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('beanio', 'BeanioDataFormat', 'BeanIO', "Marshal and unmarshal Java beans to and from flat files (such as CSV, delimited, or fixed length formats).", 'dataformat,transformation,csv', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('mapping', 'Mapping', "The BeanIO mapping file. Is by default loaded from the classpath. You can prefix with file:, http:, or classpath: to denote from where to load the mapping file.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('streamName', 'Stream Name', "The name of the stream to use.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('ignoreUnidentifiedRecords', 'Ignore Unidentified Records', "Whether to ignore unidentified records.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('ignoreUnexpectedRecords', 'Ignore Unexpected Records', "Whether to ignore unexpected records.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('ignoreInvalidRecords', 'Ignore Invalid Records', "Whether to ignore invalid records.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('encoding', 'Encoding', "The charset to use. Is by default the JVM platform default charset.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('beanReaderErrorHandlerType', 'Bean Reader Error Handler Type', "To use a custom org.apache.camel.dataformat.beanio.BeanIOErrorHandler as error handler while parsing. Configure the fully qualified class name of the error handler. Notice the options ignoreUnidentifiedRecords, ignoreUnexpectedRecords, and ignoreInvalidRecords may not be in use when you use a custom error handler.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('unmarshalSingleObject', 'Unmarshal Single Object', "This options controls whether to unmarshal as a list of objects or as a single object only. The former is the default mode, and the latter is only intended in special use-cases where beanio maps the Camel message to a single POJO bean.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('bindy', 'BindyDataFormat', 'Bindy', "Marshal and unmarshal Java beans from and to flat payloads (such as CSV, delimited, fixed length formats, or FIX messages).", 'dataformat,transformation,csv', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('type', 'Type', "Whether to use Csv, Fixed, or KeyValue.", 'string', 'Csv, Fixed, KeyValue', '', true, false, false, false, '', ''),
        new PropertyMeta('classType', 'Class Type', "Name of model class to use.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('allowEmptyStream', 'Allow Empty Stream', "Whether to allow empty streams in the unmarshal process. If true, no exception will be thrown when a body without records is provided.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('unwrapSingleInstance', 'Unwrap Single Instance', "When unmarshalling should a single instance be unwrapped and returned instead of wrapped in a java.util.List.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('locale', 'Locale', "To configure a default locale to use, such as us for united states. To use the JVM platform default locale then use the name default", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('cbor', 'CBORDataFormat', 'CBOR', "Unmarshal a CBOR payload to POJO and back.", 'dataformat,transformation,json', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('objectMapper', 'Object Mapper', "Lookup and use the existing CBOR ObjectMapper with the given id when using Jackson.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('useDefaultObjectMapper', 'Use Default Object Mapper', "Whether to lookup and use default Jackson CBOR ObjectMapper from the registry.", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('unmarshalType', 'Unmarshal Type', "Class name of the java type to use when unmarshalling", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('collectionType', 'Collection Type', "Refers to a custom collection type to lookup in the registry to use. This option should rarely be used, but allows to use different collection types than java.util.Collection based as default.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('useList', 'Use List', "To unmarshal to a List of Map or a List of Pojo.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('allowUnmarshallType', 'Allow Unmarshall Type', "If enabled then Jackson CBOR is allowed to attempt to use the CamelCBORUnmarshalType header during the unmarshalling. This should only be enabled when desired to be used.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('prettyPrint', 'Pretty Print', "To enable pretty printing output nicely formatted. Is by default false.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('allowJmsType', 'Allow Jms Type', "Used for JMS users to allow the JMSType header from the JMS spec to specify a FQN classname to use to unmarshal to.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableFeatures', 'Enable Features', "Set of features to enable on the Jackson com.fasterxml.jackson.databind.ObjectMapper. The features should be a name that matches a enum from com.fasterxml.jackson.databind.SerializationFeature, com.fasterxml.jackson.databind.DeserializationFeature, or com.fasterxml.jackson.databind.MapperFeature Multiple features can be separated by comma", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disableFeatures', 'Disable Features', "Set of features to disable on the Jackson com.fasterxml.jackson.databind.ObjectMapper. The features should be a name that matches a enum from com.fasterxml.jackson.databind.SerializationFeature, com.fasterxml.jackson.databind.DeserializationFeature, or com.fasterxml.jackson.databind.MapperFeature Multiple features can be separated by comma", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('crypto', 'CryptoDataFormat', 'Crypto (Java Cryptographic Extension)', "Encrypt and decrypt messages using Java Cryptography Extension (JCE).", 'dataformat,transformation,security', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('algorithm', 'Algorithm', "The JCE algorithm name indicating the cryptographic algorithm that will be used.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('keyRef', 'Key Ref', "Refers to the secret key to lookup from the register to use.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('cryptoProvider', 'Crypto Provider', "The name of the JCE Security Provider that should be used.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('initVectorRef', 'Init Vector Ref', "Refers to a byte array containing the Initialization Vector that will be used to initialize the Cipher.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('algorithmParameterRef', 'Algorithm Parameter Ref', "A JCE AlgorithmParameterSpec used to initialize the Cipher. Will lookup the type using the given name as a java.security.spec.AlgorithmParameterSpec type.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('bufferSize', 'Buffer Size', "The size of the buffer used in the signature process.", 'number', '', '4096', false, false, false, false, '', ''),
        new PropertyMeta('macAlgorithm', 'Mac Algorithm', "The JCE algorithm name indicating the Message Authentication algorithm.", 'string', '', 'HmacSHA1', false, false, false, false, '', ''),
        new PropertyMeta('shouldAppendHMAC', 'Should Append HMAC', "Flag indicating that a Message Authentication Code should be calculated and appended to the encrypted data.", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('inline', 'Inline', "Flag indicating that the configured IV should be inlined into the encrypted data stream. Is by default false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('csv', 'CsvDataFormat', 'CSV', "Handle CSV (Comma Separated Values) payloads.", 'dataformat,transformation,csv', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('formatRef', 'Format Ref', "The reference format to use, it will be updated with the other format options, the default value is CSVFormat.DEFAULT", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('formatName', 'Format Name', "The name of the format to use, the default value is CSVFormat.DEFAULT", 'string', 'DEFAULT, EXCEL, INFORMIX_UNLOAD, INFORMIX_UNLOAD_CSV, MYSQL, RFC4180', 'DEFAULT', false, false, false, false, 'advanced', ''),
        new PropertyMeta('commentMarkerDisabled', 'Comment Marker Disabled', "Disables the comment marker of the reference format.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('commentMarker', 'Comment Marker', "Sets the comment marker of the reference format.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('delimiter', 'Delimiter', "Sets the delimiter to use. The default value is , (comma)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('escapeDisabled', 'Escape Disabled', "Use for disabling using escape character", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('escape', 'Escape', "Sets the escape character to use", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('headerDisabled', 'Header Disabled', "Use for disabling headers", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('header', 'Header', "To configure the CSV headers", 'string', '', '', false, false, true, true, '', ''),
        new PropertyMeta('allowMissingColumnNames', 'Allow Missing Column Names', "Whether to allow missing column names.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('ignoreEmptyLines', 'Ignore Empty Lines', "Whether to ignore empty lines.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('ignoreSurroundingSpaces', 'Ignore Surrounding Spaces', "Whether to ignore surrounding spaces", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('nullStringDisabled', 'Null String Disabled', "Used to disable null strings", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('nullString', 'Null String', "Sets the null string", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('quoteDisabled', 'Quote Disabled', "Used to disable quotes", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('quote', 'Quote', "Sets the quote which by default is", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('recordSeparatorDisabled', 'Record Separator Disabled', "Used for disabling record separator", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('recordSeparator', 'Record Separator', "Sets the record separator (aka new line) which by default is new line characters (CRLF)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('skipHeaderRecord', 'Skip Header Record', "Whether to skip the header record in the output", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('quoteMode', 'Quote Mode', "Sets the quote mode", 'string', 'ALL, ALL_NON_NULL, MINIMAL, NON_NUMERIC, NONE', '', false, false, false, false, '', ''),
        new PropertyMeta('ignoreHeaderCase', 'Ignore Header Case', "Sets whether or not to ignore case when accessing header names.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Sets whether or not to trim leading and trailing blanks.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('trailingDelimiter', 'Trailing Delimiter', "Sets whether or not to add a trailing delimiter.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('marshallerFactoryRef', 'Marshaller Factory Ref', "Sets the implementation of the CsvMarshallerFactory interface which is able to customize marshalling/unmarshalling behavior by extending CsvMarshaller or creating it from scratch.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('lazyLoad', 'Lazy Load', "Whether the unmarshalling should produce an iterator that reads the lines on the fly or if all the lines must be read at one.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('useMaps', 'Use Maps', "Whether the unmarshalling should produce maps (HashMap)for the lines values instead of lists. It requires to have header (either defined or collected).", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('useOrderedMaps', 'Use Ordered Maps', "Whether the unmarshalling should produce ordered maps (LinkedHashMap) for the lines values instead of lists. It requires to have header (either defined or collected).", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('recordConverterRef', 'Record Converter Ref', "Refers to a custom CsvRecordConverter to lookup from the registry to use.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('captureHeaderRecord', 'Capture Header Record', "Whether the unmarshalling should capture the header record and store it in the message header", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('custom', 'CustomDataFormat', 'Custom', "Delegate to a custom org.apache.camel.spi.DataFormat implementation via Camel registry.", 'dataformat,transformation', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('ref', 'Ref', "Reference to the custom org.apache.camel.spi.DataFormat to lookup from the Camel registry.", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('dataFormats', 'DataFormatsDefinition', 'Data formats', "Configure data formats.", 'dataformat,transformation', [
        new PropertyMeta('asn1', 'asn1', "asn1", 'ASN1DataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('avro', 'avro', "avro", 'AvroDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('barcode', 'barcode', "barcode", 'BarcodeDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('base64', 'base64', "base64", 'Base64DataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('beanio', 'beanio', "beanio", 'BeanioDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('bindy', 'bindy', "bindy", 'BindyDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('cbor', 'cbor', "cbor", 'CBORDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('crypto', 'crypto', "crypto", 'CryptoDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('csv', 'csv', "csv", 'CsvDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('custom', 'custom', "custom", 'CustomDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('fhirJson', 'fhirJson', "fhirJson", 'FhirJsonDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('fhirXml', 'fhirXml', "fhirXml", 'FhirXmlDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('flatpack', 'flatpack', "flatpack", 'FlatpackDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('grok', 'grok', "grok", 'GrokDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('gzipDeflater', 'gzipDeflater', "gzipDeflater", 'GzipDeflaterDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('hl7', 'hl7', "hl7", 'HL7DataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('ical', 'ical', "ical", 'IcalDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('jacksonXml', 'jacksonXml', "jacksonXml", 'JacksonXMLDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('jaxb', 'jaxb', "jaxb", 'JaxbDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('json', 'json', "json", 'JsonDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('jsonApi', 'jsonApi', "jsonApi", 'JsonApiDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('lzf', 'lzf', "lzf", 'LZFDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('mimeMultipart', 'mimeMultipart', "mimeMultipart", 'MimeMultipartDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('parquetAvro', 'parquetAvro', "parquetAvro", 'ParquetAvroDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('pgp', 'pgp', "pgp", 'PGPDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('protobuf', 'protobuf', "protobuf", 'ProtobufDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('rss', 'rss', "rss", 'RssDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('soap', 'soap', "soap", 'SoapDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('swiftMt', 'swiftMt', "swiftMt", 'SwiftMtDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('swiftMx', 'swiftMx', "swiftMx", 'SwiftMxDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('syslog', 'syslog', "syslog", 'SyslogDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('tarFile', 'tarFile', "tarFile", 'TarFileDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('thrift', 'thrift', "thrift", 'ThriftDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('tidyMarkup', 'tidyMarkup', "tidyMarkup", 'TidyMarkupDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('univocityCsv', 'univocityCsv', "univocityCsv", 'UniVocityCsvDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('univocityFixed', 'univocityFixed', "univocityFixed", 'UniVocityFixedDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('univocityTsv', 'univocityTsv', "univocityTsv", 'UniVocityTsvDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('xmlSecurity', 'xmlSecurity', "xmlSecurity", 'XMLSecurityDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('yaml', 'yaml', "yaml", 'YAMLDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('zipDeflater', 'zipDeflater', "zipDeflater", 'ZipDeflaterDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('zipFile', 'zipFile', "zipFile", 'ZipFileDataFormat', '', '', false, false, false, true, '', ''),
    ], [
    ]),
    new ElementMeta('fhirJson', 'FhirJsonDataFormat', 'FHIR JSon', "Marshall and unmarshall FHIR objects to/from JSON.", 'dataformat,transformation,hl7,json', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('fhirVersion', 'Fhir Version', "The version of FHIR to use. Possible values are: DSTU2,DSTU2_HL7ORG,DSTU2_1,DSTU3,R4,R5", 'string', 'DSTU2, DSTU2_HL7ORG, DSTU2_1, DSTU3, R4, R5', 'R4', false, false, false, false, '', ''),
        new PropertyMeta('fhirContext', 'Fhir Context', "To use a custom fhir context. Reference to object of type ca.uhn.fhir.context.FhirContext", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('prettyPrint', 'Pretty Print', "Sets the pretty print flag, meaning that the parser will encode resources with human-readable spacing and newlines between elements instead of condensing output as much as possible.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('parserErrorHandler', 'Parser Error Handler', "Registers an error handler which will be invoked when any parse errors are found. Reference to object of type ca.uhn.fhir.parser.IParserErrorHandler", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('parserOptions', 'Parser Options', "Sets the parser options object which will be used to supply default options to newly created parsers. Reference to object of type ca.uhn.fhir.context.ParserOptions.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('preferTypes', 'Prefer Types', "If set (FQN class names), when parsing resources the parser will try to use the given types when possible, in the order that they are provided (from highest to lowest priority). For example, if a custom type which declares to implement the Patient resource is passed in here, and the parser is parsing a Bundle containing a Patient resource, the parser will use the given custom type. Multiple class names can be separated by comma.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('forceResourceId', 'Force Resource Id', "When encoding, force this resource ID to be encoded as the resource ID. Reference to object of type org.hl7.fhir.instance.model.api.IIdType", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('serverBaseUrl', 'Server Base Url', "Sets the server's base URL used by this parser. If a value is set, resource references will be turned into relative references if they are provided as absolute URLs but have a base matching the given base.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('omitResourceId', 'Omit Resource Id', "If set to true (default is false) the ID of any resources being encoded will not be included in the output. Note that this does not apply to contained resources, only to root resources. In other words, if this is set to true, contained resources will still have local IDs but the outer/containing ID will not have an ID.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('encodeElementsAppliesToChildResourcesOnly', 'Encode Elements Applies To Child Resources Only', "If set to true (default is false), the values supplied to setEncodeElements(Set) will not be applied to the root resource (typically a Bundle), but will be applied to any sub-resources contained within it (i.e. search result resources in that bundle)", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('encodeElements', 'Encode Elements', "If provided, specifies the elements which should be encoded, to the exclusion of all others. Multiple elements can be separated by comma when using String parameter. Valid values for this field would include: Patient - Encode patient and all its children Patient.name - Encode only the patient's name Patient.name.family - Encode only the patient's family name .text - Encode the text element on any resource (only the very first position may contain a wildcard) .(mandatory) - This is a special case which causes any mandatory fields (min 0) to be encoded", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('dontEncodeElements', 'Dont Encode Elements', "If provided, specifies the elements which should NOT be encoded. Multiple elements can be separated by comma when using String parameter. Valid values for this field would include: Patient - Don't encode patient and all its children Patient.name - Don't encode the patient's name Patient.name.family - Don't encode the patient's family name .text - Don't encode the text element on any resource (only the very first position may contain a wildcard) DSTU2 note: Note that values including meta, such as Patient.meta will work for DSTU2 parsers, but values with subelements on meta such as Patient.meta.lastUpdated will only work in DSTU3 mode.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('stripVersionsFromReferences', 'Strip Versions From References', "If set to true (which is the default), resource references containing a version will have the version removed when the resource is encoded. This is generally good behaviour because in most situations, references from one resource to another should be to the resource by ID, not by ID and version. In some cases though, it may be desirable to preserve the version in resource links. In that case, this value should be set to false. This method provides the ability to globally disable reference encoding. If finer-grained control is needed, use setDontStripVersionsFromReferencesAtPaths(List)", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('overrideResourceIdWithBundleEntryFullUrl', 'Override Resource Id With Bundle Entry Full Url', "If set to true (which is the default), the Bundle.entry.fullUrl will override the Bundle.entry.resource's resource id if the fullUrl is defined. This behavior happens when parsing the source data into a Bundle object. Set this to false if this is not the desired behavior (e.g. the client code wishes to perform additional validation checks between the fullUrl and the resource id).", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('summaryMode', 'Summary Mode', "If set to true (default is false) only elements marked by the FHIR specification as being summary elements will be included.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('suppressNarratives', 'Suppress Narratives', "If set to true (default is false), narratives will not be included in the encoded values.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('dontStripVersionsFromReferencesAtPaths', 'Dont Strip Versions From References At Paths', "If supplied value(s), any resource references at the specified paths will have their resource versions encoded instead of being automatically stripped during the encoding process. This setting has no effect on the parsing process. Multiple elements can be separated by comma when using String parameter. This method provides a finer-grained level of control than setStripVersionsFromReferences(String) and any paths specified by this method will be encoded even if setStripVersionsFromReferences(String) has been set to true (which is the default)", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('contentTypeHeader', 'Content Type Header', "Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON", 'boolean', '', 'true', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('fhirXml', 'FhirXmlDataFormat', 'FHIR XML', "Marshall and unmarshall FHIR objects to/from XML.", 'dataformat,transformation,hl7,xml', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('fhirVersion', 'Fhir Version', "The version of FHIR to use. Possible values are: DSTU2,DSTU2_HL7ORG,DSTU2_1,DSTU3,R4,R5", 'string', 'DSTU2, DSTU2_HL7ORG, DSTU2_1, DSTU3, R4, R5', 'R4', false, false, false, false, '', ''),
        new PropertyMeta('fhirContext', 'Fhir Context', "To use a custom fhir context. Reference to object of type ca.uhn.fhir.context.FhirContext", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('prettyPrint', 'Pretty Print', "Sets the pretty print flag, meaning that the parser will encode resources with human-readable spacing and newlines between elements instead of condensing output as much as possible.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('parserErrorHandler', 'Parser Error Handler', "Registers an error handler which will be invoked when any parse errors are found. Reference to object of type ca.uhn.fhir.parser.IParserErrorHandler", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('parserOptions', 'Parser Options', "Sets the parser options object which will be used to supply default options to newly created parsers. Reference to object of type ca.uhn.fhir.context.ParserOptions.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('preferTypes', 'Prefer Types', "If set (FQN class names), when parsing resources the parser will try to use the given types when possible, in the order that they are provided (from highest to lowest priority). For example, if a custom type which declares to implement the Patient resource is passed in here, and the parser is parsing a Bundle containing a Patient resource, the parser will use the given custom type. Multiple class names can be separated by comma.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('forceResourceId', 'Force Resource Id', "When encoding, force this resource ID to be encoded as the resource ID. Reference to object of type org.hl7.fhir.instance.model.api.IIdType", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('serverBaseUrl', 'Server Base Url', "Sets the server's base URL used by this parser. If a value is set, resource references will be turned into relative references if they are provided as absolute URLs but have a base matching the given base.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('omitResourceId', 'Omit Resource Id', "If set to true (default is false) the ID of any resources being encoded will not be included in the output. Note that this does not apply to contained resources, only to root resources. In other words, if this is set to true, contained resources will still have local IDs but the outer/containing ID will not have an ID.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('encodeElementsAppliesToChildResourcesOnly', 'Encode Elements Applies To Child Resources Only', "If set to true (default is false), the values supplied to setEncodeElements(Set) will not be applied to the root resource (typically a Bundle), but will be applied to any sub-resources contained within it (i.e. search result resources in that bundle)", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('encodeElements', 'Encode Elements', "If provided, specifies the elements which should be encoded, to the exclusion of all others. Multiple elements can be separated by comma when using String parameter. Valid values for this field would include: Patient - Encode patient and all its children Patient.name - Encode only the patient's name Patient.name.family - Encode only the patient's family name .text - Encode the text element on any resource (only the very first position may contain a wildcard) .(mandatory) - This is a special case which causes any mandatory fields (min 0) to be encoded", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('dontEncodeElements', 'Dont Encode Elements', "If provided, specifies the elements which should NOT be encoded. Multiple elements can be separated by comma when using String parameter. Valid values for this field would include: Patient - Don't encode patient and all its children Patient.name - Don't encode the patient's name Patient.name.family - Don't encode the patient's family name .text - Don't encode the text element on any resource (only the very first position may contain a wildcard) DSTU2 note: Note that values including meta, such as Patient.meta will work for DSTU2 parsers, but values with subelements on meta such as Patient.meta.lastUpdated will only work in DSTU3 mode.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('stripVersionsFromReferences', 'Strip Versions From References', "If set to true (which is the default), resource references containing a version will have the version removed when the resource is encoded. This is generally good behaviour because in most situations, references from one resource to another should be to the resource by ID, not by ID and version. In some cases though, it may be desirable to preserve the version in resource links. In that case, this value should be set to false. This method provides the ability to globally disable reference encoding. If finer-grained control is needed, use setDontStripVersionsFromReferencesAtPaths(List)", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('overrideResourceIdWithBundleEntryFullUrl', 'Override Resource Id With Bundle Entry Full Url', "If set to true (which is the default), the Bundle.entry.fullUrl will override the Bundle.entry.resource's resource id if the fullUrl is defined. This behavior happens when parsing the source data into a Bundle object. Set this to false if this is not the desired behavior (e.g. the client code wishes to perform additional validation checks between the fullUrl and the resource id).", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('summaryMode', 'Summary Mode', "If set to true (default is false) only elements marked by the FHIR specification as being summary elements will be included.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('suppressNarratives', 'Suppress Narratives', "If set to true (default is false), narratives will not be included in the encoded values.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('dontStripVersionsFromReferencesAtPaths', 'Dont Strip Versions From References At Paths', "If supplied value(s), any resource references at the specified paths will have their resource versions encoded instead of being automatically stripped during the encoding process. This setting has no effect on the parsing process. Multiple elements can be separated by comma when using String parameter. This method provides a finer-grained level of control than setStripVersionsFromReferences(String) and any paths specified by this method will be encoded even if setStripVersionsFromReferences(String) has been set to true (which is the default)", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('contentTypeHeader', 'Content Type Header', "Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON", 'boolean', '', 'true', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('flatpack', 'FlatpackDataFormat', 'Flatpack', "Marshal and unmarshal Java lists and maps to/from flat files (such as CSV, delimited, or fixed length formats) using Flatpack library.", 'dataformat,transformation,csv', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('definition', 'Definition', "The flatpack pzmap configuration file. Can be omitted in simpler situations, but its preferred to use the pzmap.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('fixed', 'Fixed', "Delimited or fixed. Is by default false = delimited", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('delimiter', 'Delimiter', "The delimiter char (could be ; , or similar)", 'string', '', ',', false, false, false, false, '', ''),
        new PropertyMeta('ignoreFirstRecord', 'Ignore First Record', "Whether the first line is ignored for delimited files (for the column headers). Is by default true.", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('allowShortLines', 'Allow Short Lines', "Allows for lines to be shorter than expected and ignores the extra characters", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('ignoreExtraColumns', 'Ignore Extra Columns', "Allows for lines to be longer than expected and ignores the extra characters.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('textQualifier', 'Text Qualifier', "If the text is qualified with a character. Uses quote character by default.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('parserFactoryRef', 'Parser Factory Ref', "References to a custom parser factory to lookup in the registry", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('grok', 'GrokDataFormat', 'Grok', "Unmarshal unstructured data to objects using Logstash based Grok patterns.", 'dataformat,transformation', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('pattern', 'Pattern', "The grok pattern to match lines of input", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('flattened', 'Flattened', "Turns on flattened mode. In flattened mode the exception is thrown when there are multiple pattern matches with same key.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('allowMultipleMatchesPerLine', 'Allow Multiple Matches Per Line', "If false, every line of input is matched for pattern only once. Otherwise the line can be scanned multiple times when non-terminal pattern is used.", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('namedOnly', 'Named Only', "Whether to capture named expressions only or not (i.e. %{IP:ip} but not ${IP})", 'boolean', '', 'false', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('gzipDeflater', 'GzipDeflaterDataFormat', 'GZip Deflater', "Compress and decompress messages using java.util.zip.GZIPStream.", 'dataformat,transformation', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('hl7', 'HL7DataFormat', 'HL7', "Marshal and unmarshal HL7 (Health Care) model objects using the HL7 MLLP codec.", 'dataformat,transformation,hl7', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('validate', 'Validate', "Whether to validate the HL7 message Is by default true.", 'boolean', '', 'true', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('ical', 'IcalDataFormat', 'iCal', "Marshal and unmarshal iCal (.ics) documents to/from model objects.", 'dataformat,transformation', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('validating', 'Validating', "Whether to validate.", 'boolean', '', 'false', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('jacksonXml', 'JacksonXMLDataFormat', 'Jackson XML', "Unmarshal an XML payloads to POJOs and back using XMLMapper extension of Jackson.", 'dataformat,transformation,xml', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('xmlMapper', 'Xml Mapper', "Lookup and use the existing XmlMapper with the given id.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('prettyPrint', 'Pretty Print', "To enable pretty printing output nicely formatted. Is by default false.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('unmarshalType', 'Unmarshal Type', "Class name of the java type to use when unmarshalling", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('allowUnmarshallType', 'Allow Unmarshall Type', "If enabled then Jackson is allowed to attempt to use the CamelJacksonUnmarshalType header during the unmarshalling. This should only be enabled when desired to be used.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('jsonView', 'Json View', "When marshalling a POJO to JSON you might want to exclude certain fields from the JSON output. With Jackson you can use JSON views to accomplish this. This option is to refer to the class which has JsonView annotations", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('include', 'Include', "If you want to marshal a pojo to JSON, and the pojo has some fields with null values. And you want to skip these null values, you can set this option to NON_NULL", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('allowJmsType', 'Allow Jms Type', "Used for JMS users to allow the JMSType header from the JMS spec to specify a FQN classname to use to unmarshal to.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('collectionType', 'Collection Type', "Refers to a custom collection type to lookup in the registry to use. This option should rarely be used, but allows to use different collection types than java.util.Collection based as default.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('useList', 'Use List', "To unmarshal to a List of Map or a List of Pojo.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('timezone', 'Timezone', "If set then Jackson will use the Timezone when marshalling/unmarshalling.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableJaxbAnnotationModule', 'Enable Jaxb Annotation Module', "Whether to enable the JAXB annotations module when using jackson. When enabled then JAXB annotations can be used by Jackson.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('moduleClassNames', 'Module Class Names', "To use custom Jackson modules com.fasterxml.jackson.databind.Module specified as a String with FQN class names. Multiple classes can be separated by comma.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('moduleRefs', 'Module Refs', "To use custom Jackson modules referred from the Camel registry. Multiple modules can be separated by comma.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableFeatures', 'Enable Features', "Set of features to enable on the Jackson com.fasterxml.jackson.databind.ObjectMapper. The features should be a name that matches a enum from com.fasterxml.jackson.databind.SerializationFeature, com.fasterxml.jackson.databind.DeserializationFeature, or com.fasterxml.jackson.databind.MapperFeature Multiple features can be separated by comma", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disableFeatures', 'Disable Features', "Set of features to disable on the Jackson com.fasterxml.jackson.databind.ObjectMapper. The features should be a name that matches a enum from com.fasterxml.jackson.databind.SerializationFeature, com.fasterxml.jackson.databind.DeserializationFeature, or com.fasterxml.jackson.databind.MapperFeature Multiple features can be separated by comma", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('contentTypeHeader', 'Content Type Header', "Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON", 'boolean', '', 'true', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('jaxb', 'JaxbDataFormat', 'JAXB', "Unmarshal XML payloads to POJOs and back using JAXB2 XML marshalling standard.", 'dataformat,transformation,xml', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('contextPath', 'Context Path', "Package name where your JAXB classes are located.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('contextPathIsClassName', 'Context Path Is Class Name', "This can be set to true to mark that the contextPath is referring to a classname and not a package name.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('schema', 'Schema', "To validate against an existing schema. Your can use the prefix classpath:, file: or http: to specify how the resource should be resolved. You can separate multiple schema files by using the ',' character.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('schemaSeverityLevel', 'Schema Severity Level', "Sets the schema severity level to use when validating against a schema. This level determines the minimum severity error that triggers JAXB to stop continue parsing. The default value of 0 (warning) means that any error (warning, error or fatal error) will trigger JAXB to stop. There are the following three levels: 0=warning, 1=error, 2=fatal error.", 'string', '0, 1, 2', '0', false, false, false, false, '', ''),
        new PropertyMeta('prettyPrint', 'Pretty Print', "To enable pretty printing output nicely formatted. Is by default false.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('objectFactory', 'Object Factory', "Whether to allow using ObjectFactory classes to create the POJO classes during marshalling. This only applies to POJO classes that has not been annotated with JAXB and providing jaxb.index descriptor files.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('ignoreJAXBElement', 'Ignore JAXBElement', "Whether to ignore JAXBElement elements - only needed to be set to false in very special use-cases.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('mustBeJAXBElement', 'Must Be JAXBElement', "Whether marhsalling must be java objects with JAXB annotations. And if not then it fails. This option can be set to false to relax that, such as when the data is already in XML format.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('filterNonXmlChars', 'Filter Non Xml Chars', "To ignore non xml characheters and replace them with an empty space.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('encoding', 'Encoding', "To overrule and use a specific encoding", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('fragment', 'Fragment', "To turn on marshalling XML fragment trees. By default JAXB looks for XmlRootElement annotation on given class to operate on whole XML tree. This is useful but not always - sometimes generated code does not have XmlRootElement annotation, sometimes you need unmarshall only part of tree. In that case you can use partial unmarshalling. To enable this behaviours you need set property partClass. Camel will pass this class to JAXB's unmarshaler.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('partClass', 'Part Class', "Name of class used for fragment parsing. See more details at the fragment option.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('partNamespace', 'Part Namespace', "XML namespace to use for fragment parsing. See more details at the fragment option.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('namespacePrefixRef', 'Namespace Prefix Ref', "When marshalling using JAXB or SOAP then the JAXB implementation will automatic assign namespace prefixes, such as ns2, ns3, ns4 etc. To control this mapping, Camel allows you to refer to a map which contains the desired mapping.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('xmlStreamWriterWrapper', 'Xml Stream Writer Wrapper', "To use a custom xml stream writer.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('schemaLocation', 'Schema Location', "To define the location of the schema", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('noNamespaceSchemaLocation', 'No Namespace Schema Location', "To define the location of the namespaceless schema", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('jaxbProviderProperties', 'Jaxb Provider Properties', "Refers to a custom java.util.Map to lookup in the registry containing custom JAXB provider properties to be used with the JAXB marshaller.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('contentTypeHeader', 'Content Type Header', "Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('accessExternalSchemaProtocols', 'Access External Schema Protocols', "Only in use if schema validation has been enabled. Restrict access to the protocols specified for external reference set by the schemaLocation attribute, Import and Include element. Examples of protocols are file, http, jar:file. false or none to deny all access to external references; a specific protocol, such as file, to give permission to only the protocol; the keyword all to grant permission to all protocols.", 'string', '', 'false', false, false, false, false, 'security', ''),
    ], [
    ]),
    new ElementMeta('jsonApi', 'JsonApiDataFormat', 'JSonApi', "Marshal and unmarshal JSON:API resources using JSONAPI-Converter library.", 'dataformat,transformation', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('dataFormatTypes', 'Data Format Types', "The classes to take into account for the marshalling. Multiple classes can be separated by comma.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('mainFormatType', 'Main Format Type', "The class to take into account while unmarshalling.", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('json', 'JsonDataFormat', 'JSon', "Marshal POJOs to JSON and back.", 'dataformat,transformation,json', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('objectMapper', 'Object Mapper', "Lookup and use the existing ObjectMapper with the given id when using Jackson.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('useDefaultObjectMapper', 'Use Default Object Mapper', "Whether to lookup and use default Jackson ObjectMapper from the registry.", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('autoDiscoverObjectMapper', 'Auto Discover Object Mapper', "If set to true then Jackson will look for an objectMapper to use from the registry", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('prettyPrint', 'Pretty Print', "To enable pretty printing output nicely formatted. Is by default false.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('library', 'Library', "Which json library to use.", 'string', 'Fastjson, Gson, Jackson, Johnzon, Jsonb', 'Jackson', false, false, false, false, '', ''),
        new PropertyMeta('unmarshalType', 'Unmarshal Type', "Class name of the java type to use when unmarshalling", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('jsonView', 'Json View', "When marshalling a POJO to JSON you might want to exclude certain fields from the JSON output. With Jackson you can use JSON views to accomplish this. This option is to refer to the class which has JsonView annotations", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('include', 'Include', "If you want to marshal a pojo to JSON, and the pojo has some fields with null values. And you want to skip these null values, you can set this option to NON_NULL", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('allowJmsType', 'Allow Jms Type', "Used for JMS users to allow the JMSType header from the JMS spec to specify a FQN classname to use to unmarshal to.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('collectionType', 'Collection Type', "Refers to a custom collection type to lookup in the registry to use. This option should rarely be used, but allows using different collection types than java.util.Collection based as default.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('useList', 'Use List', "To unmarshal to a List of Map or a List of Pojo.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('moduleClassNames', 'Module Class Names', "To use custom Jackson modules com.fasterxml.jackson.databind.Module specified as a String with FQN class names. Multiple classes can be separated by comma.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('moduleRefs', 'Module Refs', "To use custom Jackson modules referred from the Camel registry. Multiple modules can be separated by comma.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableFeatures', 'Enable Features', "Set of features to enable on the Jackson com.fasterxml.jackson.databind.ObjectMapper. The features should be a name that matches a enum from com.fasterxml.jackson.databind.SerializationFeature, com.fasterxml.jackson.databind.DeserializationFeature, or com.fasterxml.jackson.databind.MapperFeature Multiple features can be separated by comma", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('disableFeatures', 'Disable Features', "Set of features to disable on the Jackson com.fasterxml.jackson.databind.ObjectMapper. The features should be a name that matches a enum from com.fasterxml.jackson.databind.SerializationFeature, com.fasterxml.jackson.databind.DeserializationFeature, or com.fasterxml.jackson.databind.MapperFeature Multiple features can be separated by comma", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('allowUnmarshallType', 'Allow Unmarshall Type', "If enabled then Jackson is allowed to attempt to use the CamelJacksonUnmarshalType header during the unmarshalling. This should only be enabled when desired to be used.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('timezone', 'Timezone', "If set then Jackson will use the Timezone when marshalling/unmarshalling. This option will have no effect on the others Json DataFormat, like gson and fastjson.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('schemaResolver', 'Schema Resolver', "Optional schema resolver used to lookup schemas for the data in transit.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('autoDiscoverSchemaResolver', 'Auto Discover Schema Resolver', "When not disabled, the SchemaResolver will be looked up into the registry", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('namingStrategy', 'Naming Strategy', "If set then Jackson will use the the defined Property Naming Strategy.Possible values are: LOWER_CAMEL_CASE, LOWER_DOT_CASE, LOWER_CASE, KEBAB_CASE, SNAKE_CASE and UPPER_CAMEL_CASE", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('contentTypeHeader', 'Content Type Header', "Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('dateFormatPattern', 'Date Format Pattern', "To configure the date format while marshall or unmarshall Date fields in JSON using Gson", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('lzf', 'LZFDataFormat', 'LZF Deflate Compression', "Compress and decompress streams using LZF deflate algorithm.", 'dataformat,transformation', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('usingParallelCompression', 'Using Parallel Compression', "Enable encoding (compress) using multiple processing cores.", 'boolean', '', 'false', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('mimeMultipart', 'MimeMultipartDataFormat', 'MIME Multipart', "Marshal Camel messages with attachments into MIME-Multipart messages and back.", 'dataformat,transformation', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('multipartSubType', 'Multipart Sub Type', "Specify the subtype of the MIME Multipart. Default is mixed.", 'string', '', 'mixed', false, false, false, false, '', ''),
        new PropertyMeta('multipartWithoutAttachment', 'Multipart Without Attachment', "Defines whether a message without attachment is also marshaled into a MIME Multipart (with only one body part). Default is false.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('headersInline', 'Headers Inline', "Defines whether the MIME-Multipart headers are part of the message body (true) or are set as Camel headers (false). Default is false.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('includeHeaders', 'Include Headers', "A regex that defines which Camel headers are also included as MIME headers into the MIME multipart. This will only work if headersInline is set to true. Default is to include no headers", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('binaryContent', 'Binary Content', "Defines whether the content of binary parts in the MIME multipart is binary (true) or Base-64 encoded (false) Default is false.", 'boolean', '', 'false', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('pgp', 'PGPDataFormat', 'PGP', "Encrypt and decrypt messages using Java Cryptographic Extension (JCE) and PGP.", 'dataformat,transformation,security', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('keyUserid', 'Key Userid', "The user ID of the key in the PGP keyring used during encryption. Can also be only a part of a user ID. For example, if the user ID is Test User then you can use the part Test User or to address the user ID.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('signatureKeyUserid', 'Signature Key Userid', "User ID of the key in the PGP keyring used for signing (during encryption) or signature verification (during decryption). During the signature verification process the specified User ID restricts the public keys from the public keyring which can be used for the verification. If no User ID is specified for the signature verficiation then any public key in the public keyring can be used for the verification. Can also be only a part of a user ID. For example, if the user ID is Test User then you can use the part Test User or to address the User ID.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('password', 'Password', "Password used when opening the private key (not used for encryption).", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('signaturePassword', 'Signature Password', "Password used when opening the private key used for signing (during encryption).", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('keyFileName', 'Key File Name', "Filename of the keyring; must be accessible as a classpath resource (but you can specify a location in the file system by using the file: prefix).", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('signatureKeyFileName', 'Signature Key File Name', "Filename of the keyring to use for signing (during encryption) or for signature verification (during decryption); must be accessible as a classpath resource (but you can specify a location in the file system by using the file: prefix).", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('signatureKeyRing', 'Signature Key Ring', "Keyring used for signing/verifying as byte array. You can not set the signatureKeyFileName and signatureKeyRing at the same time.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('armored', 'Armored', "This option will cause PGP to base64 encode the encrypted text, making it available for copy/paste, etc.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('integrity', 'Integrity', "Adds an integrity check/sign into the encryption file. The default value is true.", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('provider', 'Provider', "Java Cryptography Extension (JCE) provider, default is Bouncy Castle (BC). Alternatively you can use, for example, the IAIK JCE provider; in this case the provider must be registered beforehand and the Bouncy Castle provider must not be registered beforehand. The Sun JCE provider does not work.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('algorithm', 'Algorithm', "Symmetric key encryption algorithm; possible values are defined in org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags; for example 2 (= TRIPLE DES), 3 (= CAST5), 4 (= BLOWFISH), 6 (= DES), 7 (= AES_128). Only relevant for encrypting.", 'number', '', '', false, false, false, false, '', ''),
        new PropertyMeta('compressionAlgorithm', 'Compression Algorithm', "Compression algorithm; possible values are defined in org.bouncycastle.bcpg.CompressionAlgorithmTags; for example 0 (= UNCOMPRESSED), 1 (= ZIP), 2 (= ZLIB), 3 (= BZIP2). Only relevant for encrypting.", 'number', '', '', false, false, false, false, '', ''),
        new PropertyMeta('hashAlgorithm', 'Hash Algorithm', "Signature hash algorithm; possible values are defined in org.bouncycastle.bcpg.HashAlgorithmTags; for example 2 (= SHA1), 8 (= SHA256), 9 (= SHA384), 10 (= SHA512), 11 (=SHA224). Only relevant for signing.", 'number', '', '', false, false, false, false, '', ''),
        new PropertyMeta('signatureVerificationOption', 'Signature Verification Option', "Controls the behavior for verifying the signature during unmarshaling. There are 4 values possible: optional: The PGP message may or may not contain signatures; if it does contain signatures, then a signature verification is executed. required: The PGP message must contain at least one signature; if this is not the case an exception (PGPException) is thrown. A signature verification is executed. ignore: Contained signatures in the PGP message are ignored; no signature verification is executed. no_signature_allowed: The PGP message must not contain a signature; otherwise an exception (PGPException) is thrown.", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('parquetAvro', 'ParquetAvroDataFormat', 'Parquet File', "Parquet Avro serialization and de-serialization.", 'dataformat,transformation,file', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('compressionCodecName', 'Compression Codec Name', "Compression codec to use when marshalling.", 'string', 'UNCOMPRESSED, SNAPPY, GZIP, LZO, BROTLI, LZ4, ZSTD, LZ4_RAW', 'GZIP', false, false, false, false, '', ''),
        new PropertyMeta('unmarshalType', 'Unmarshal Type', "Class to use when (un)marshalling. If omitted, parquet files are converted into Avro's GenericRecords for unmarshalling and input objects are assumed as GenericRecords for marshalling.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('lazyLoad', 'Lazy Load', "Whether the unmarshalling should produce an iterator of records or read all the records at once.", 'boolean', '', 'false', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('protobuf', 'ProtobufDataFormat', 'Protobuf', "Serialize and deserialize Java objects using Google's Protocol buffers.", 'dataformat,transformation', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('instanceClass', 'Instance Class', "Name of class to use when unmarshalling", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('objectMapper', 'Object Mapper', "Lookup and use the existing ObjectMapper with the given id when using Jackson.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('useDefaultObjectMapper', 'Use Default Object Mapper', "Whether to lookup and use default Jackson ObjectMapper from the registry.", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('autoDiscoverObjectMapper', 'Auto Discover Object Mapper', "If set to true then Jackson will lookup for an objectMapper into the registry", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('library', 'Library', "Which Protobuf library to use.", 'string', 'GoogleProtobuf, Jackson', 'GoogleProtobuf', false, false, false, false, '', ''),
        new PropertyMeta('unmarshalType', 'Unmarshal Type', "Class name of the java type to use when unmarshalling", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('jsonView', 'Json View', "When marshalling a POJO to JSON you might want to exclude certain fields from the JSON output. With Jackson you can use JSON views to accomplish this. This option is to refer to the class which has JsonView annotations", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('include', 'Include', "If you want to marshal a pojo to JSON, and the pojo has some fields with null values. And you want to skip these null values, you can set this option to NON_NULL", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('allowJmsType', 'Allow Jms Type', "Used for JMS users to allow the JMSType header from the JMS spec to specify a FQN classname to use to unmarshal to.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('collectionType', 'Collection Type', "Refers to a custom collection type to lookup in the registry to use. This option should rarely be used, but allows to use different collection types than java.util.Collection based as default.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('useList', 'Use List', "To unmarshal to a List of Map or a List of Pojo.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('moduleClassNames', 'Module Class Names', "To use custom Jackson modules com.fasterxml.jackson.databind.Module specified as a String with FQN class names. Multiple classes can be separated by comma.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('moduleRefs', 'Module Refs', "To use custom Jackson modules referred from the Camel registry. Multiple modules can be separated by comma.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableFeatures', 'Enable Features', "Set of features to enable on the Jackson com.fasterxml.jackson.databind.ObjectMapper. The features should be a name that matches a enum from com.fasterxml.jackson.databind.SerializationFeature, com.fasterxml.jackson.databind.DeserializationFeature, or com.fasterxml.jackson.databind.MapperFeature Multiple features can be separated by comma", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disableFeatures', 'Disable Features', "Set of features to disable on the Jackson com.fasterxml.jackson.databind.ObjectMapper. The features should be a name that matches a enum from com.fasterxml.jackson.databind.SerializationFeature, com.fasterxml.jackson.databind.DeserializationFeature, or com.fasterxml.jackson.databind.MapperFeature Multiple features can be separated by comma", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('allowUnmarshallType', 'Allow Unmarshall Type', "If enabled then Jackson is allowed to attempt to use the CamelJacksonUnmarshalType header during the unmarshalling. This should only be enabled when desired to be used.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('timezone', 'Timezone', "If set then Jackson will use the Timezone when marshalling/unmarshalling.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('schemaResolver', 'Schema Resolver', "Optional schema resolver used to lookup schemas for the data in transit.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('autoDiscoverSchemaResolver', 'Auto Discover Schema Resolver', "When not disabled, the SchemaResolver will be looked up into the registry", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('contentTypeFormat', 'Content Type Format', "Defines a content type format in which protobuf message will be serialized/deserialized from(to) the Java been. The format can either be native or json for either native protobuf or json fields representation. The default value is native.", 'string', 'native, json', 'native', false, false, false, false, '', ''),
        new PropertyMeta('contentTypeHeader', 'Content Type Header', "Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON", 'boolean', '', 'true', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('rss', 'RssDataFormat', 'RSS', "Transform from ROME SyndFeed Java Objects to XML and vice-versa.", 'dataformat,transformation', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('soap', 'SoapDataFormat', 'SOAP', "Marshal Java objects to SOAP messages and back.", 'dataformat,transformation,xml', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('contextPath', 'Context Path', "Package name where your JAXB classes are located.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('encoding', 'Encoding', "To overrule and use a specific encoding", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('elementNameStrategyRef', 'Element Name Strategy Ref', "Refers to an element strategy to lookup from the registry. An element name strategy is used for two purposes. The first is to find a xml element name for a given object and soap action when marshaling the object into a SOAP message. The second is to find an Exception class for a given soap fault name. The following three element strategy class name is provided out of the box. QNameStrategy - Uses a fixed qName that is configured on instantiation. Exception lookup is not supported TypeNameStrategy - Uses the name and namespace from the XMLType annotation of the given type. If no namespace is set then package-info is used. Exception lookup is not supported ServiceInterfaceStrategy - Uses information from a webservice interface to determine the type name and to find the exception class for a SOAP fault All three classes is located in the package name org.apache.camel.dataformat.soap.name If you have generated the web service stub code with cxf-codegen or a similar tool then you probably will want to use the ServiceInterfaceStrategy. In the case you have no annotated service interface you should use QNameStrategy or TypeNameStrategy.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('version', 'Version', "SOAP version should either be 1.1 or 1.2. Is by default 1.1", 'string', '1.1, 1.2', '1.1', false, false, false, false, '', ''),
        new PropertyMeta('namespacePrefixRef', 'Namespace Prefix Ref', "When marshalling using JAXB or SOAP then the JAXB implementation will automatic assign namespace prefixes, such as ns2, ns3, ns4 etc. To control this mapping, Camel allows you to refer to a map which contains the desired mapping.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('schema', 'Schema', "To validate against an existing schema. Your can use the prefix classpath:, file: or http: to specify how the resource should be resolved. You can separate multiple schema files by using the ',' character.", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('swiftMt', 'SwiftMtDataFormat', 'SWIFT MT', "Encode and decode SWIFT MT messages.", 'dataformat,transformation,swift', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('writeInJson', 'Write In Json', "The flag indicating that messages must be marshalled in a JSON format.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('swiftMx', 'SwiftMxDataFormat', 'SWIFT MX', "Encode and decode SWIFT MX messages.", 'dataformat,transformation,swift', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('writeConfigRef', 'Write Config Ref', "Refers to a specific configuration to use when marshalling a message to lookup from the registry.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('writeInJson', 'Write In Json', "The flag indicating that messages must be marshalled in a JSON format.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('readMessageId', 'Read Message Id', "The type of MX message to produce when unmarshalling an input stream. If not set, it will be automatically detected from the namespace used.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('readConfigRef', 'Read Config Ref', "Refers to a specific configuration to use when unmarshalling an input stream to lookup from the registry.", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('syslog', 'SyslogDataFormat', 'Syslog', "Marshall SyslogMessages to RFC3164 and RFC5424 messages and back.", 'dataformat,transformation,monitoring', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('tarFile', 'TarFileDataFormat', 'Tar File', "Archive files into tarballs or extract files from tarballs.", 'dataformat,transformation,file', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('usingIterator', 'Using Iterator', "If the tar file has more than one entry, the setting this option to true, allows working with the splitter EIP, to split the data using an iterator in a streaming mode.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('allowEmptyDirectory', 'Allow Empty Directory', "If the tar file has more than one entry, setting this option to true, allows to get the iterator even if the directory is empty", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('preservePathElements', 'Preserve Path Elements', "If the file name contains path elements, setting this option to true, allows the path to be maintained in the tar file.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('maxDecompressedSize', 'Max Decompressed Size', "Set the maximum decompressed size of a tar file (in bytes). The default value if not specified corresponds to 1 gigabyte. An IOException will be thrown if the decompressed size exceeds this amount. Set to -1 to disable setting a maximum decompressed size.", 'number', '', '1073741824', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('thrift', 'ThriftDataFormat', 'Thrift', "Serialize and deserialize messages using Apache Thrift binary data format.", 'dataformat,transformation', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('instanceClass', 'Instance Class', "Name of class to use when unmarshalling", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('contentTypeFormat', 'Content Type Format', "Defines a content type format in which thrift message will be serialized/deserialized from(to) the Java been. The format can either be native or json for either native binary thrift, json or simple json fields representation. The default value is binary.", 'string', 'binary, json, sjson', 'binary', false, false, false, false, '', ''),
        new PropertyMeta('contentTypeHeader', 'Content Type Header', "Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON", 'boolean', '', 'true', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('tidyMarkup', 'TidyMarkupDataFormat', 'TidyMarkup', "Parse (potentially invalid) HTML into valid HTML or DOM.", 'dataformat,transformation', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('dataObjectType', 'Data Object Type', "What data type to unmarshal as, can either be org.w3c.dom.Node or java.lang.String. Is by default org.w3c.dom.Node", 'string', 'org.w3c.dom.Node, java.lang.String', 'org.w3c.dom.Node', false, false, false, false, '', ''),
        new PropertyMeta('omitXmlDeclaration', 'Omit Xml Declaration', "When returning a String, do we omit the XML declaration in the top.", 'boolean', '', 'false', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('univocityCsv', 'UniVocityCsvDataFormat', 'uniVocity CSV', "Marshal and unmarshal Java objects from and to CSV (Comma Separated Values) using UniVocity Parsers.", 'dataformat,transformation,csv', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('delimiter', 'Delimiter', "The delimiter of values", 'string', '', ',', false, false, false, false, '', ''),
        new PropertyMeta('quoteAllFields', 'Quote All Fields', "Whether or not all values must be quoted when writing them.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('quote', 'Quote', "The quote symbol.", 'string', '', '"', false, false, false, false, 'advanced', ''),
        new PropertyMeta('quoteEscape', 'Quote Escape', "The quote escape symbol", 'string', '', '"', false, false, false, false, 'advanced', ''),
        new PropertyMeta('nullValue', 'Null Value', "The string representation of a null value. The default value is null", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('skipEmptyLines', 'Skip Empty Lines', "Whether or not the empty lines must be ignored. The default value is true", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('ignoreTrailingWhitespaces', 'Ignore Trailing Whitespaces', "Whether or not the trailing white spaces must be ignored. The default value is true", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('ignoreLeadingWhitespaces', 'Ignore Leading Whitespaces', "Whether or not the leading white spaces must be ignored. The default value is true", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('headersDisabled', 'Headers Disabled', "Whether or not the headers are disabled. When defined, this option explicitly sets the headers as null which indicates that there is no header. The default value is false", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('headerExtractionEnabled', 'Header Extraction Enabled', "Whether or not the header must be read in the first line of the test document. The default value is false", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('numberOfRecordsToRead', 'Number Of Records To Read', "The maximum number of record to read.", 'number', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('emptyValue', 'Empty Value', "The String representation of an empty value.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('lineSeparator', 'Line Separator', "The line separator of the files. The default value is to use the JVM platform line separator", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('normalizedLineSeparator', 'Normalized Line Separator', "The normalized line separator of the files. The default value is a new line character.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('comment', 'Comment', "The comment symbol. The default value is #", 'string', '', '#', false, false, false, false, 'advanced', ''),
        new PropertyMeta('lazyLoad', 'Lazy Load', "Whether the unmarshalling should produce an iterator that reads the lines on the fly or if all the lines must be read at once. The default value is false", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('asMap', 'As Map', "Whether the unmarshalling should produce maps for the lines values instead of lists. It requires to have header (either defined or collected). The default value is false", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('univocityHeader', 'univocityHeader', "univocityHeader", 'UniVocityHeader', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('univocityFixed', 'UniVocityFixedDataFormat', 'uniVocity Fixed Length', "Marshal and unmarshal Java objects from and to fixed length records using UniVocity Parsers.", 'dataformat,transformation,csv', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('padding', 'Padding', "The padding character. The default value is a space", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('skipTrailingCharsUntilNewline', 'Skip Trailing Chars Until Newline', "Whether or not the trailing characters until new line must be ignored. The default value is false", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('recordEndsOnNewline', 'Record Ends On Newline', "Whether or not the record ends on new line. The default value is false", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('nullValue', 'Null Value', "The string representation of a null value. The default value is null", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('skipEmptyLines', 'Skip Empty Lines', "Whether or not the empty lines must be ignored. The default value is true", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('ignoreTrailingWhitespaces', 'Ignore Trailing Whitespaces', "Whether or not the trailing white spaces must be ignored. The default value is true", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('ignoreLeadingWhitespaces', 'Ignore Leading Whitespaces', "Whether or not the leading white spaces must be ignored. The default value is true", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('headersDisabled', 'Headers Disabled', "Whether or not the headers are disabled. When defined, this option explicitly sets the headers as null which indicates that there is no header. The default value is false", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('headerExtractionEnabled', 'Header Extraction Enabled', "Whether or not the header must be read in the first line of the test document. The default value is false", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('numberOfRecordsToRead', 'Number Of Records To Read', "The maximum number of record to read.", 'number', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('emptyValue', 'Empty Value', "The String representation of an empty value.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('lineSeparator', 'Line Separator', "The line separator of the files. The default value is to use the JVM platform line separator", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('normalizedLineSeparator', 'Normalized Line Separator', "The normalized line separator of the files. The default value is a new line character.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('comment', 'Comment', "The comment symbol. The default value is #", 'string', '', '#', false, false, false, false, 'advanced', ''),
        new PropertyMeta('lazyLoad', 'Lazy Load', "Whether the unmarshalling should produce an iterator that reads the lines on the fly or if all the lines must be read at once. The default value is false", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('asMap', 'As Map', "Whether the unmarshalling should produce maps for the lines values instead of lists. It requires to have header (either defined or collected). The default value is false", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('univocityHeader', 'univocityHeader', "univocityHeader", 'UniVocityHeader', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('univocityTsv', 'UniVocityTsvDataFormat', 'uniVocity TSV', "Marshal and unmarshal Java objects from and to TSV (Tab-Separated Values) records using UniVocity Parsers.", 'dataformat,transformation,csv', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('escapeChar', 'Escape Char', "The escape character.", 'string', '', '\\', false, false, false, false, 'advanced', ''),
        new PropertyMeta('nullValue', 'Null Value', "The string representation of a null value. The default value is null", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('skipEmptyLines', 'Skip Empty Lines', "Whether or not the empty lines must be ignored. The default value is true", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('ignoreTrailingWhitespaces', 'Ignore Trailing Whitespaces', "Whether or not the trailing white spaces must be ignored. The default value is true", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('ignoreLeadingWhitespaces', 'Ignore Leading Whitespaces', "Whether or not the leading white spaces must be ignored. The default value is true", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('headersDisabled', 'Headers Disabled', "Whether or not the headers are disabled. When defined, this option explicitly sets the headers as null which indicates that there is no header. The default value is false", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('headerExtractionEnabled', 'Header Extraction Enabled', "Whether or not the header must be read in the first line of the test document. The default value is false", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('numberOfRecordsToRead', 'Number Of Records To Read', "The maximum number of record to read.", 'number', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('emptyValue', 'Empty Value', "The String representation of an empty value.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('lineSeparator', 'Line Separator', "The line separator of the files. The default value is to use the JVM platform line separator", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('normalizedLineSeparator', 'Normalized Line Separator', "The normalized line separator of the files. The default value is a new line character.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('comment', 'Comment', "The comment symbol. The default value is #", 'string', '', '#', false, false, false, false, 'advanced', ''),
        new PropertyMeta('lazyLoad', 'Lazy Load', "Whether the unmarshalling should produce an iterator that reads the lines on the fly or if all the lines must be read at once. The default value is false", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('asMap', 'As Map', "Whether the unmarshalling should produce maps for the lines values instead of lists. It requires to have header (either defined or collected). The default value is false", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('univocityHeader', 'univocityHeader', "univocityHeader", 'UniVocityHeader', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('xmlSecurity', 'XMLSecurityDataFormat', 'XML Security', "Encrypt and decrypt XML payloads using Apache Santuario.", 'dataformat,transformation,xml', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('xmlCipherAlgorithm', 'Xml Cipher Algorithm', "The cipher algorithm to be used for encryption/decryption of the XML message content. The available choices are: XMLCipher.TRIPLEDES XMLCipher.AES_128 XMLCipher.AES_128_GCM XMLCipher.AES_192 XMLCipher.AES_192_GCM XMLCipher.AES_256 XMLCipher.AES_256_GCM XMLCipher.SEED_128 XMLCipher.CAMELLIA_128 XMLCipher.CAMELLIA_192 XMLCipher.CAMELLIA_256 The default value is XMLCipher.AES_256_GCM", 'string', 'TRIPLEDES, AES_128, AES_128_GCM, AES_192, AES_192_GCM, AES_256, AES_256_GCM, SEED_128, CAMELLIA_128, CAMELLIA_192, CAMELLIA_256', 'AES-256-GCM', false, false, false, false, '', ''),
        new PropertyMeta('passPhrase', 'Pass Phrase', "A String used as passPhrase to encrypt/decrypt content. The passPhrase has to be provided. The passPhrase needs to be put together in conjunction with the appropriate encryption algorithm. For example using TRIPLEDES the passPhase can be a Only another 24 Byte key", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('passPhraseByte', 'Pass Phrase Byte', "A byte used as passPhrase to encrypt/decrypt content. The passPhrase has to be provided. The passPhrase needs to be put together in conjunction with the appropriate encryption algorithm. For example using TRIPLEDES the passPhase can be a Only another 24 Byte key", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('secureTag', 'Secure Tag', "The XPath reference to the XML Element selected for encryption/decryption. If no tag is specified, the entire payload is encrypted/decrypted.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('secureTagContents', 'Secure Tag Contents', "A boolean value to specify whether the XML Element is to be encrypted or the contents of the XML Element. false = Element Level. true = Element Content Level.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('keyCipherAlgorithm', 'Key Cipher Algorithm', "The cipher algorithm to be used for encryption/decryption of the asymmetric key. The available choices are: XMLCipher.RSA_v1dot5 XMLCipher.RSA_OAEP XMLCipher.RSA_OAEP_11 The default value is XMLCipher.RSA_OAEP", 'string', 'RSA_v1dot5, RSA_OAEP, RSA_OAEP_11', 'RSA_OAEP', false, false, false, false, '', ''),
        new PropertyMeta('recipientKeyAlias', 'Recipient Key Alias', "The key alias to be used when retrieving the recipient's public or private key from a KeyStore when performing asymmetric key encryption or decryption.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('keyOrTrustStoreParametersRef', 'Key Or Trust Store Parameters Ref', "Refers to a KeyStore instance to lookup in the registry, which is used for configuration options for creating and loading a KeyStore instance that represents the sender's trustStore or recipient's keyStore.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('keyPassword', 'Key Password', "The password to be used for retrieving the private key from the KeyStore. This key is used for asymmetric decryption.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('digestAlgorithm', 'Digest Algorithm', "The digest algorithm to use with the RSA OAEP algorithm. The available choices are: XMLCipher.SHA1 XMLCipher.SHA256 XMLCipher.SHA512 The default value is XMLCipher.SHA1", 'string', 'SHA1, SHA256, SHA512', 'SHA1', false, false, false, false, '', ''),
        new PropertyMeta('mgfAlgorithm', 'Mgf Algorithm', "The MGF Algorithm to use with the RSA OAEP algorithm. The available choices are: EncryptionConstants.MGF1_SHA1 EncryptionConstants.MGF1_SHA256 EncryptionConstants.MGF1_SHA512 The default value is EncryptionConstants.MGF1_SHA1", 'string', 'MGF1_SHA1, MGF1_SHA256, MGF1_SHA512', 'MGF1_SHA1', false, false, false, false, '', ''),
        new PropertyMeta('addKeyValueForEncryptedKey', 'Add Key Value For Encrypted Key', "Whether to add the public key used to encrypt the session key as a KeyValue in the EncryptedKey structure or not.", 'boolean', '', 'true', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('yaml', 'YAMLDataFormat', 'YAML', "Marshal and unmarshal Java objects to and from YAML.", 'dataformat,transformation,yaml', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('library', 'Library', "Which yaml library to use. By default it is SnakeYAML", 'string', 'SnakeYAML', 'SnakeYAML', false, false, false, false, '', ''),
        new PropertyMeta('unmarshalType', 'Unmarshal Type', "Class name of the java type to use when unmarshalling", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('constructor', 'Constructor', "BaseConstructor to construct incoming documents.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('representer', 'Representer', "Representer to emit outgoing objects.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('dumperOptions', 'Dumper Options', "DumperOptions to configure outgoing objects.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('resolver', 'Resolver', "Resolver to detect implicit type", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('useApplicationContextClassLoader', 'Use Application Context Class Loader', "Use ApplicationContextClassLoader as custom ClassLoader", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('prettyFlow', 'Pretty Flow', "Force the emitter to produce a pretty YAML document when using the flow style.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('allowAnyType', 'Allow Any Type', "Allow any class to be un-marshaled", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('typeFilter', 'Type Filter', "Set the types SnakeYAML is allowed to un-marshall", 'YAMLTypeFilterDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('maxAliasesForCollections', 'Max Aliases For Collections', "Set the maximum amount of aliases allowed for collections.", 'number', '', '50', false, false, false, false, 'advanced', ''),
        new PropertyMeta('allowRecursiveKeys', 'Allow Recursive Keys', "Set whether recursive keys are allowed.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('zipDeflater', 'ZipDeflaterDataFormat', 'Zip Deflater', "Compress and decompress streams using java.util.zip.Deflater and java.util.zip.Inflater.", 'dataformat,transformation', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('compressionLevel', 'Compression Level', "To specify a specific compression between 0-9. -1 is default compression, 0 is no compression, and 9 is the best compression.", 'string', '-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9', '-1', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('zipFile', 'ZipFileDataFormat', 'Zip File', "Compression and decompress streams using java.util.zip.ZipStream.", 'dataformat,transformation,file', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('usingIterator', 'Using Iterator', "If the zip file has more than one entry, the setting this option to true, allows working with the splitter EIP, to split the data using an iterator in a streaming mode.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('allowEmptyDirectory', 'Allow Empty Directory', "If the zip file has more than one entry, setting this option to true, allows to get the iterator even if the directory is empty", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('preservePathElements', 'Preserve Path Elements', "If the file name contains path elements, setting this option to true, allows the path to be maintained in the zip file.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('maxDecompressedSize', 'Max Decompressed Size', "Set the maximum decompressed size of a zip file (in bytes). The default value if not specified corresponds to 1 gigabyte. An IOException will be thrown if the decompressed size exceeds this amount. Set to -1 to disable setting a maximum decompressed size.", 'number', '', '1073741824', false, false, false, false, 'advanced', ''),
    ], [
    ]),
]

export const Languages: [string, string, string][] = [
    ['constant','Constant',"A fixed value set only once during the route startup."],
    ['csimple','CSimple',"Evaluate a compiled simple expression."],
    ['datasonnet','DataSonnet',"To use DataSonnet scripts for message transformations."],
    ['exchangeProperty','ExchangeProperty',"Gets a property from the Exchange."],
    ['groovy','Groovy',"Evaluates a Groovy script."],
    ['header','Header',"Gets a header from the Exchange."],
    ['hl7terser','HL7 Terser',"Get the value of a HL7 message field specified by terse location specification syntax."],
    ['java','Java',"Evaluates a Java (Java compiled once at runtime) expression."],
    ['jq','JQ',"Evaluates a JQ expression against a JSON message body."],
    ['js','JavaScript',"Evaluates a JavaScript expression."],
    ['jsonpath','JSONPath',"Evaluates a JSONPath expression against a JSON message body."],
    ['language','Language',"Evaluates a custom language."],
    ['method','Bean Method',"Calls a Java bean method."],
    ['mvel','MVEL',"Evaluates a MVEL template."],
    ['ognl','OGNL',"Evaluates an OGNL expression (Apache Commons OGNL)."],
    ['python','Python',"Evaluates a Python expression."],
    ['ref','Ref',"Uses an existing expression from the registry."],
    ['simple','Simple',"Evaluates a Camel simple expression."],
    ['spel','SpEL',"Evaluates a Spring expression (SpEL)."],
    ['tokenize','Tokenize',"Tokenize text payloads using delimiter patterns."],
    ['variable','Variable',"Gets a variable"],
    ['wasm','Wasm',"Call a wasm (web assembly) function."],
    ['xpath','XPath',"Evaluates an XPath expression against an XML payload."],
    ['xquery','XQuery',"Evaluates an XQuery expressions against an XML payload."],
    ['xtokenize','XML Tokenize',"Tokenize XML payloads."],
]

export const CamelLanguageMetadata: ElementMeta[] = [
    new ElementMeta('csimple', 'CSimpleExpression', 'CSimple', "Evaluate a compiled simple expression.", 'language,java', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('constant', 'ConstantExpression', 'Constant', "A fixed value set only once during the route startup.", 'language,core', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('datasonnet', 'DatasonnetExpression', 'DataSonnet', "To use DataSonnet scripts for message transformations.", 'language,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('bodyMediaType', 'Body Media Type', "The String representation of the message's body MediaType", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('outputMediaType', 'Output Media Type', "The String representation of the MediaType to output", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('source', 'Source', "Source to use, instead of message body. You can prefix with variable:, header:, or property: to specify kind of source. Otherwise, the source is assumed to be a variable. Use empty or null to use default source, which is the message body.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('exchangeProperty', 'ExchangePropertyExpression', 'ExchangeProperty', "Gets a property from the Exchange.", 'language,core', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('groovy', 'GroovyExpression', 'Groovy', "Evaluates a Groovy script.", 'language,script', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('header', 'HeaderExpression', 'Header', "Gets a header from the Exchange.", 'language,core', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('hl7terser', 'Hl7TerserExpression', 'HL7 Terser', "Get the value of a HL7 message field specified by terse location specification syntax.", 'language,hl7', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('source', 'Source', "Source to use, instead of message body. You can prefix with variable:, header:, or property: to specify kind of source. Otherwise, the source is assumed to be a variable. Use empty or null to use default source, which is the message body.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('java', 'JavaExpression', 'Java', "Evaluates a Java (Java compiled once at runtime) expression.", 'language', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('preCompile', 'Pre Compile', "Whether the expression should be pre compiled once during initialization phase. If this is turned off, then the expression is reloaded and compiled on each evaluation.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('singleQuotes', 'Single Quotes', "Whether single quotes can be used as replacement for double quotes. This is convenient when you need to work with strings inside strings.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('js', 'JavaScriptExpression', 'JavaScript', "Evaluates a JavaScript expression.", 'language,javascript', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('jq', 'JqExpression', 'JQ', "Evaluates a JQ expression against a JSON message body.", 'language,json', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('source', 'Source', "Source to use, instead of message body. You can prefix with variable:, header:, or property: to specify kind of source. Otherwise, the source is assumed to be a variable. Use empty or null to use default source, which is the message body.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('jsonpath', 'JsonPathExpression', 'JSONPath', "Evaluates a JSONPath expression against a JSON message body.", 'language,json', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('suppressExceptions', 'Suppress Exceptions', "Whether to suppress exceptions such as PathNotFoundException.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('allowSimple', 'Allow Simple', "Whether to allow in inlined Simple exceptions in the JSONPath expression", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('allowEasyPredicate', 'Allow Easy Predicate', "Whether to allow using the easy predicate parser to pre-parse predicates.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('writeAsString', 'Write As String', "Whether to write the output of each row/element as a JSON String value instead of a Map/POJO value.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('unpackArray', 'Unpack Array', "Whether to unpack a single element json-array into an object.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('option', 'Option', "To configure additional options on JSONPath. Multiple values can be separated by comma.", 'string', 'DEFAULT_PATH_LEAF_TO_NULL, ALWAYS_RETURN_LIST, AS_PATH_LIST, SUPPRESS_EXCEPTIONS, REQUIRE_PROPERTIES', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('source', 'Source', "Source to use, instead of message body. You can prefix with variable:, header:, or property: to specify kind of source. Otherwise, the source is assumed to be a variable. Use empty or null to use default source, which is the message body.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('language', 'LanguageExpression', 'Language', "Evaluates a custom language.", 'language,core', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('language', 'Language', "The name of the language to use", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('method', 'MethodCallExpression', 'Bean Method', "Calls a Java bean method.", 'language,core,java', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('ref', 'Ref', "Reference to an existing bean (bean id) to lookup in the registry", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('method', 'Method', "Name of method to call", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('beanType', 'Bean Type', "Class name (fully qualified) of the bean to use Will lookup in registry and if there is a single instance of the same type, then the existing bean is used, otherwise a new bean is created (requires a default no-arg constructor).", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('scope', 'Scope', "Scope of bean. When using singleton scope (default) the bean is created or looked up only once and reused for the lifetime of the endpoint. The bean should be thread-safe in case concurrent threads is calling the bean at the same time. When using request scope the bean is created or looked up once per request (exchange). This can be used if you want to store state on a bean while processing a request and you want to call the same bean instance multiple times while processing the request. The bean does not have to be thread-safe as the instance is only called from the same request. When using prototype scope, then the bean will be looked up or created per call. However in case of lookup then this is delegated to the bean registry such as Spring or CDI (if in use), which depends on their configuration can act as either singleton or prototype scope. So when using prototype scope then this depends on the bean registry implementation.", 'string', 'Singleton, Request, Prototype', 'Singleton', false, false, false, false, 'advanced', ''),
        new PropertyMeta('validate', 'Validate', "Whether to validate the bean has the configured method.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('mvel', 'MvelExpression', 'MVEL', "Evaluates a MVEL template.", 'language,java', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('ognl', 'OgnlExpression', 'OGNL', "Evaluates an OGNL expression (Apache Commons OGNL).", 'language,java', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('python', 'PythonExpression', 'Python', "Evaluates a Python expression.", 'language,python', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('ref', 'RefExpression', 'Ref', "Uses an existing expression from the registry.", 'language,core', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('simple', 'SimpleExpression', 'Simple', "Evaluates a Camel simple expression.", 'language,core,java', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('spel', 'SpELExpression', 'SpEL', "Evaluates a Spring expression (SpEL).", 'language,spring', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('tokenize', 'TokenizerExpression', 'Tokenize', "Tokenize text payloads using delimiter patterns.", 'language,core', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('token', 'Token', "The (start) token to use as tokenizer, for example you can use the new line token. You can use simple language as the token to support dynamic tokens.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('endToken', 'End Token', "The end token to use as tokenizer if using start/end token pairs. You can use simple language as the token to support dynamic tokens.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('inheritNamespaceTagName', 'Inherit Namespace Tag Name', "To inherit namespaces from a root/parent tag name when using XML You can use simple language as the tag name to support dynamic names.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('regex', 'Regex', "If the token is a regular expression pattern. The default value is false", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('xml', 'Xml', "Whether the input is XML messages. This option must be set to true if working with XML payloads.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('includeTokens', 'Include Tokens', "Whether to include the tokens in the parts when using pairs. When including tokens then the endToken property must also be configured (to use pair mode). The default value is false", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('group', 'Group', "To group N parts together, for example to split big files into chunks of 1000 lines. You can use simple language as the group to support dynamic group sizes.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('groupDelimiter', 'Group Delimiter', "Sets the delimiter to use when grouping. If this has not been set then token will be used as the delimiter.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('skipFirst', 'Skip First', "To skip the very first element", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('source', 'Source', "Source to use, instead of message body. You can prefix with variable:, header:, or property: to specify kind of source. Otherwise, the source is assumed to be a variable. Use empty or null to use default source, which is the message body.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('variable', 'VariableExpression', 'Variable', "Gets a variable", 'language,core', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('wasm', 'WasmExpression', 'Wasm', "Call a wasm (web assembly) function.", 'language', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('module', 'Module', "Set the module (the distributable, loadable, and executable unit of code in WebAssembly) resource that provides the expression function.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('xtokenize', 'XMLTokenizerExpression', 'XML Tokenize', "Tokenize XML payloads.", 'language,core,xml', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('mode', 'Mode', "The extraction mode. The available extraction modes are: i - injecting the contextual namespace bindings into the extracted token (default) w - wrapping the extracted token in its ancestor context u - unwrapping the extracted token to its child content t - extracting the text content of the specified element", 'string', 'i, w, u, t', 'i', false, false, false, false, '', ''),
        new PropertyMeta('group', 'Group', "To group N parts together", 'number', '', '', false, false, false, false, '', ''),
        new PropertyMeta('namespace', 'Namespace', "Injects the XML Namespaces of prefix - uri mappings", 'PropertyDefinition', '', '', false, false, true, true, 'common', ''),
        new PropertyMeta('source', 'Source', "Source to use, instead of message body. You can prefix with variable:, header:, or property: to specify kind of source. Otherwise, the source is assumed to be a variable. Use empty or null to use default source, which is the message body.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('xpath', 'XPathExpression', 'XPath', "Evaluates an XPath expression against an XML payload.", 'language,core,xml', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('documentType', 'Document Type', "Name of class for document type The default value is org.w3c.dom.Document", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('resultQName', 'Result QName', "Sets the output type supported by XPath.", 'string', 'NUMBER, STRING, BOOLEAN, NODESET, NODE', 'NODESET', false, false, false, false, '', ''),
        new PropertyMeta('saxon', 'Saxon', "Whether to use Saxon.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('factoryRef', 'Factory Ref', "References to a custom XPathFactory to lookup in the registry", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('objectModel', 'Object Model', "The XPath object model to use", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('logNamespaces', 'Log Namespaces', "Whether to log namespaces which can assist during troubleshooting", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('threadSafety', 'Thread Safety', "Whether to enable thread-safety for the returned result of the xpath expression. This applies to when using NODESET as the result type, and the returned set has multiple elements. In this situation there can be thread-safety issues if you process the NODESET concurrently such as from a Camel Splitter EIP in parallel processing mode. This option prevents concurrency issues by doing defensive copies of the nodes. It is recommended to turn this option on if you are using camel-saxon or Saxon in your application. Saxon has thread-safety issues which can be prevented by turning this option on.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('preCompile', 'Pre Compile', "Whether to enable pre-compiling the xpath expression during initialization phase. pre-compile is enabled by default. This can be used to turn off, for example in cases the compilation phase is desired at the starting phase, such as if the application is ahead of time compiled (for example with camel-quarkus) which would then load the xpath factory of the built operating system, and not a JVM runtime.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('namespace', 'Namespace', "Injects the XML Namespaces of prefix - uri mappings", 'PropertyDefinition', '', '', false, false, true, true, 'common', ''),
        new PropertyMeta('source', 'Source', "Source to use, instead of message body. You can prefix with variable:, header:, or property: to specify kind of source. Otherwise, the source is assumed to be a variable. Use empty or null to use default source, which is the message body.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('xquery', 'XQueryExpression', 'XQuery', "Evaluates an XQuery expressions against an XML payload.", 'language,xml', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "The expression value in your chosen language syntax", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('configurationRef', 'Configuration Ref', "Reference to a saxon configuration instance in the registry to use for xquery (requires camel-saxon). This may be needed to add custom functions to a saxon configuration, so these custom functions can be used in xquery expressions.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('namespace', 'Namespace', "Injects the XML Namespaces of prefix - uri mappings", 'PropertyDefinition', '', '', false, false, true, true, 'common', ''),
        new PropertyMeta('source', 'Source', "Source to use, instead of message body. You can prefix with variable:, header:, or property: to specify kind of source. Otherwise, the source is assumed to be a variable. Use empty or null to use default source, which is the message body.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('resultType', 'Result Type', "Sets the class of the result type (type from output)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trim', 'Trim', "Whether to trim the value to remove leading and trailing whitespaces and line breaks", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
]

export const CamelModelMetadata: ElementMeta[] = [
    new ElementMeta('aggregate', 'AggregateDefinition', 'Aggregate', "Aggregates many messages into a single message", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('correlationExpression', 'Correlation Expression', "The expression used to calculate the correlation key to use for aggregation. The Exchange which has the same correlation key is aggregated together. If the correlation key could not be evaluated an Exception is thrown. You can disable this by using the ignoreBadCorrelationKeys option.", 'ExpressionSubElementDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('completionPredicate', 'Completion Predicate', "A Predicate to indicate when an aggregated exchange is complete. If this is not specified and the AggregationStrategy object implements Predicate, the aggregationStrategy object will be used as the completionPredicate.", 'ExpressionSubElementDefinition', '', '', false, false, false, true, 'advanced', ''),
        new PropertyMeta('completionTimeoutExpression', 'Completion Timeout Expression', "Time in millis that an aggregated exchange should be inactive before its complete (timeout). This option can be set as either a fixed value or using an Expression which allows you to evaluate a timeout dynamically - will use Long as result. If both are set Camel will fallback to use the fixed value if the Expression result was null or 0. You cannot use this option together with completionInterval, only one of the two can be used. By default the timeout checker runs every second, you can use the completionTimeoutCheckerInterval option to configure how frequently to run the checker. The timeout is an approximation and there is no guarantee that the a timeout is triggered exactly after the timeout value. It is not recommended to use very low timeout values or checker intervals.", 'ExpressionSubElementDefinition', '', '', false, false, false, true, 'advanced', ''),
        new PropertyMeta('completionSizeExpression', 'Completion Size Expression', "Number of messages aggregated before the aggregation is complete. This option can be set as either a fixed value or using an Expression which allows you to evaluate a size dynamically - will use Integer as result. If both are set Camel will fallback to use the fixed value if the Expression result was null or 0.", 'ExpressionSubElementDefinition', '', '', false, false, false, true, 'advanced', ''),
        new PropertyMeta('optimisticLockRetryPolicy', 'Optimistic Lock Retry Policy', "Allows to configure retry settings when using optimistic locking.", 'OptimisticLockRetryPolicyDefinition', '', '', false, false, false, true, 'advanced', ''),
        new PropertyMeta('parallelProcessing', 'Parallel Processing', "When aggregated are completed they are being send out of the aggregator. This option indicates whether or not Camel should use a thread pool with multiple threads for concurrency. If no custom thread pool has been specified then Camel creates a default pool with 10 concurrent threads.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('optimisticLocking', 'Optimistic Locking', "Turns on using optimistic locking, which requires the aggregationRepository being used, is supporting this by implementing org.apache.camel.spi.OptimisticLockingAggregationRepository .", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('executorService', 'Executor Service', "If using parallelProcessing you can specify a custom thread pool to be used. In fact also if you are not using parallelProcessing this custom thread pool is used to send out aggregated exchanges as well.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('timeoutCheckerExecutorService', 'Timeout Checker Executor Service', "If using either of the completionTimeout, completionTimeoutExpression, or completionInterval options a background thread is created to check for the completion for every aggregator. Set this option to provide a custom thread pool to be used rather than creating a new thread for every aggregator.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('aggregateController', 'Aggregate Controller', "To use a org.apache.camel.processor.aggregate.AggregateController to allow external sources to control this aggregator.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('aggregationRepository', 'Aggregation Repository', "The AggregationRepository to use. Sets the custom aggregate repository to use. Will by default use org.apache.camel.processor.aggregate.MemoryAggregationRepository", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('aggregationStrategy', 'Aggregation Strategy', "The AggregationStrategy to use. For example to lookup a bean with the name foo, the value is simply just #bean:foo. Configuring an AggregationStrategy is required, and is used to merge the incoming Exchange with the existing already merged exchanges. At first call the oldExchange parameter is null. On subsequent invocations the oldExchange contains the merged exchanges and newExchange is of course the new incoming Exchange.", 'string', '', '', false, false, false, false, '', 'org.apache.camel.AggregationStrategy'),
        new PropertyMeta('aggregationStrategyMethodName', 'Aggregation Strategy Method Name', "This option can be used to explicit declare the method name to use, when using beans as the AggregationStrategy.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('aggregationStrategyMethodAllowNull', 'Aggregation Strategy Method Allow Null', "If this option is false then the aggregate method is not used for the very first aggregation. If this option is true then null values is used as the oldExchange (at the very first aggregation), when using beans as the AggregationStrategy.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('completionSize', 'Completion Size', "Number of messages aggregated before the aggregation is complete. This option can be set as either a fixed value or using an Expression which allows you to evaluate a size dynamically - will use Integer as result. If both are set Camel will fallback to use the fixed value if the Expression result was null or 0.", 'number', '', '', false, false, false, false, '', ''),
        new PropertyMeta('completionInterval', 'Completion Interval', "A repeating period in millis by which the aggregator will complete all current aggregated exchanges. Camel has a background task which is triggered every period. You cannot use this option together with completionTimeout, only one of them can be used.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('completionTimeout', 'Completion Timeout', "Time in millis that an aggregated exchange should be inactive before its complete (timeout). This option can be set as either a fixed value or using an Expression which allows you to evaluate a timeout dynamically - will use Long as result. If both are set Camel will fallback to use the fixed value if the Expression result was null or 0. You cannot use this option together with completionInterval, only one of the two can be used. By default the timeout checker runs every second, you can use the completionTimeoutCheckerInterval option to configure how frequently to run the checker. The timeout is an approximation and there is no guarantee that the a timeout is triggered exactly after the timeout value. It is not recommended to use very low timeout values or checker intervals.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('completionTimeoutCheckerInterval', 'Completion Timeout Checker Interval', "Interval in millis that is used by the background task that checks for timeouts ( org.apache.camel.TimeoutMap ). By default the timeout checker runs every second. The timeout is an approximation and there is no guarantee that the a timeout is triggered exactly after the timeout value. It is not recommended to use very low timeout values or checker intervals.", 'string', '', '1000', false, false, false, false, 'advanced', ''),
        new PropertyMeta('completionFromBatchConsumer', 'Completion From Batch Consumer', "Enables the batch completion mode where we aggregate from a org.apache.camel.BatchConsumer and aggregate the total number of exchanges the org.apache.camel.BatchConsumer has reported as total by checking the exchange property org.apache.camel.Exchange#BATCH_COMPLETE when its complete. This option cannot be used together with discardOnAggregationFailure.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('completionOnNewCorrelationGroup', 'Completion On New Correlation Group', "Enables completion on all previous groups when a new incoming correlation group. This can for example be used to complete groups with same correlation keys when they are in consecutive order. Notice when this is enabled then only 1 correlation group can be in progress as when a new correlation group starts, then the previous groups is forced completed.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('eagerCheckCompletion', 'Eager Check Completion', "Use eager completion checking which means that the completionPredicate will use the incoming Exchange. As opposed to without eager completion checking the completionPredicate will use the aggregated Exchange.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('ignoreInvalidCorrelationKeys', 'Ignore Invalid Correlation Keys', "If a correlation key cannot be successfully evaluated it will be ignored by logging a DEBUG and then just ignore the incoming Exchange.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('closeCorrelationKeyOnCompletion', 'Close Correlation Key On Completion', "Closes a correlation key when its complete. Any late received exchanges which has a correlation key that has been closed, it will be defined and a ClosedCorrelationKeyException is thrown.", 'number', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('discardOnCompletionTimeout', 'Discard On Completion Timeout', "Discards the aggregated message on completion timeout. This means on timeout the aggregated message is dropped and not sent out of the aggregator.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('discardOnAggregationFailure', 'Discard On Aggregation Failure', "Discards the aggregated message when aggregation failed (an exception was thrown from AggregationStrategy . This means the partly aggregated message is dropped and not sent out of the aggregator. This option cannot be used together with completionFromBatchConsumer.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('forceCompletionOnStop', 'Force Completion On Stop', "Indicates to complete all current aggregated exchanges when the context is stopped", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('completeAllOnStop', 'Complete All On Stop', "Indicates to wait to complete all current and partial (pending) aggregated exchanges when the context is stopped. This also means that we will wait for all pending exchanges which are stored in the aggregation repository to complete so the repository is empty before we can stop. You may want to enable this when using the memory based aggregation repository that is memory based only, and do not store data on disk. When this option is enabled, then the aggregator is waiting to complete all those exchanges before its stopped, when stopping CamelContext or the route using it.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
        new ExchangePropertyMeta('CamelAggregatedSize', 'Aggregated Size', 'producer', 'int', 'Number of exchanges that was grouped together.'),
        new ExchangePropertyMeta('CamelAggregatedTimeout', 'Aggregated Timeout', 'producer', 'long', 'The time in millis this group will timeout'),
        new ExchangePropertyMeta('CamelAggregatedCompletedBy', 'Aggregated Completed By', 'producer', 'String', 'Enum that tell how this group was completed'),
        new ExchangePropertyMeta('CamelAggregatedCorrelationKey', 'Aggregated Correlation Key', 'producer', 'String', 'The correlation key for this aggregation group'),
        new ExchangePropertyMeta('CamelAggregationCompleteCurrentGroup', 'Aggregation Complete Current Group', 'consumer', 'boolean', 'Input property. Set to true to force completing the current group. This allows to overrule any existing completion predicates, sizes, timeouts etc, and complete the group.'),
        new ExchangePropertyMeta('CamelAggregationCompleteAllGroups', 'Aggregation Complete All Groups', 'consumer', 'boolean', 'Input property. Set to true to force completing all the groups (excluding this message). This allows to overrule any existing completion predicates, sizes, timeouts etc, and complete the group. This message is considered a signal message only, the message headers/contents will not be processed otherwise. Instead use CamelAggregationCompleteAllGroupsInclusive if this message should be included in the aggregator.'),
        new ExchangePropertyMeta('CamelAggregationCompleteAllGroupsInclusive', 'Aggregation Complete All Groups Inclusive', 'consumer', 'boolean', 'Input property. Set to true to force completing all the groups (including this message). This allows to overrule any existing completion predicates, sizes, timeouts etc, and complete the group.'),
    ]),
    new ElementMeta('bean', 'BeanDefinition', 'Bean', "Calls a Java bean", 'eip,endpoint', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('ref', 'Ref', "Sets a reference to an existing bean to use, which is looked up from the registry", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('method', 'Method', "Sets the method name on the bean to use", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('beanType', 'Bean Type', "Sets the class name (fully qualified) of the bean to use", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('scope', 'Scope', "Scope of bean. When using singleton scope (default) the bean is created or looked up only once and reused for the lifetime of the endpoint. The bean should be thread-safe in case concurrent threads is calling the bean at the same time. When using request scope the bean is created or looked up once per request (exchange). This can be used if you want to store state on a bean while processing a request and you want to call the same bean instance multiple times while processing the request. The bean does not have to be thread-safe as the instance is only called from the same request. When using prototype scope, then the bean will be looked up or created per call. However in case of lookup then this is delegated to the bean registry such as Spring or CDI (if in use), which depends on their configuration can act as either singleton or prototype scope. So when using prototype scope then this depends on the bean registry implementation.", 'string', 'Singleton, Request, Prototype', 'Singleton', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('doCatch', 'CatchDefinition', 'Do Catch', "Catches exceptions as part of a try, catch, finally block", 'error', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('exception', 'Exception', "The exception(s) to catch.", 'string', '', '', false, false, true, true, '', ''),
        new PropertyMeta('onWhen', 'On When', "Sets an additional predicate that should be true before the onCatch is triggered. To be used for fine grained controlling whether a thrown exception should be intercepted by this exception type or not.", 'WhenDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
        new ExchangePropertyMeta('CamelExceptionCaught', 'Exception Caught', 'producer', 'java.lang.Exception', 'Stores the caught exception due to a processing error of the current Exchange'),
        new ExchangePropertyMeta('CamelFailureEndpoint', 'Failure Endpoint', 'producer', 'String', 'Endpoint URI where the Exchange failed during processing'),
        new ExchangePropertyMeta('CamelFailureRouteId', 'Failure Route Id', 'producer', 'String', 'Route ID where the Exchange failed during processing'),
    ]),
    new ElementMeta('choice', 'ChoiceDefinition', 'Choice', "Route messages based on a series of predicates", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('when', 'When', "Sets the when nodes", 'WhenDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('otherwise', 'Otherwise', "Sets the otherwise node", 'OtherwiseDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('precondition', 'Precondition', "Indicates whether this Choice EIP is in precondition mode or not. If so its branches (when/otherwise) are evaluated during startup to keep at runtime only the branch that matched.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('circuitBreaker', 'CircuitBreakerDefinition', 'Circuit Breaker', "Route messages in a fault tolerance way using Circuit Breaker", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('configuration', 'Configuration', "Refers to a circuit breaker configuration (such as resillience4j, or microprofile-fault-tolerance) to use for configuring the circuit breaker EIP.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('resilience4jConfiguration', 'Resilience4j Configuration', "Configures the circuit breaker to use Resilience4j with the given configuration.", 'Resilience4jConfigurationDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('faultToleranceConfiguration', 'Fault Tolerance Configuration', "Configures the circuit breaker to use MicroProfile Fault Tolerance with the given configuration.", 'FaultToleranceConfigurationDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('onFallback', 'On Fallback', "The fallback route path to execute that does not go over the network. This should be a static or cached result that can immediately be returned upon failure. If the fallback requires network connection then use onFallbackViaNetwork() .", 'OnFallbackDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
        new ExchangePropertyMeta('CamelResponseSuccessfulExecution', 'Response Successful Execution', 'producer', 'boolean', 'Whether the exchange was processed successfully by the circuit breaker'),
        new ExchangePropertyMeta('CamelResponseFromFallback', 'Response From Fallback', 'producer', 'boolean', 'Whether the exchange was processed by the onFallback by the circuit breaker'),
        new ExchangePropertyMeta('CamelResponseShortCircuited', 'Response Short Circuited', 'producer', 'boolean', 'Whether the exchange was short circuited by the breaker'),
        new ExchangePropertyMeta('CamelResponseTimedOut', 'Response Timed Out', 'producer', 'boolean', 'Whether the exchange timed out during processing by the circuit breaker'),
        new ExchangePropertyMeta('CamelResponseRejected', 'Response Rejected', 'producer', 'boolean', 'Whether the circuit breaker rejected processing the exchange'),
    ]),
    new ElementMeta('claimCheck', 'ClaimCheckDefinition', 'Claim Check', "The Claim Check EIP allows you to replace message content with a claim check (a unique key), which can be used to retrieve the message content at a later time.", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('operation', 'Operation', "The claim check operation to use. The following operations are supported: Get - Gets (does not remove) the claim check by the given key. GetAndRemove - Gets and removes the claim check by the given key. Set - Sets a new (will override if key already exists) claim check with the given key. Push - Sets a new claim check on the stack (does not use key). Pop - Gets the latest claim check from the stack (does not use key).", 'string', 'Get, GetAndRemove, Set, Push, Pop', '', false, false, false, false, '', ''),
        new PropertyMeta('key', 'Key', "To use a specific key for claim check id (for dynamic keys use simple language syntax as the key).", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('filter', 'Filter', "Specify a filter to control what data gets merged data back from the claim check repository. The following syntax is supported: body - to aggregate the message body attachments - to aggregate all the message attachments headers - to aggregate all the message headers header:pattern - to aggregate all the message headers that matches the pattern. The following pattern rules are applied in this order: exact match, returns true wildcard match (pattern ends with a and the name starts with the pattern), returns true regular expression match, returns true otherwise returns false You can specify multiple rules separated by comma. For example, the following includes the message body and all headers starting with foo: body,header:foo. The syntax supports the following prefixes which can be used to specify include,exclude, or remove - to include (which is the default mode) - - to exclude (exclude takes precedence over include) -- - to remove (remove takes precedence) For example to exclude a header name foo, and remove all headers starting with bar, -header:foo,--headers:bar Note you cannot have both include and exclude header:pattern at the same time.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('aggregationStrategy', 'Aggregation Strategy', "To use a custom AggregationStrategy instead of the default implementation. Notice you cannot use both custom aggregation strategy and configure data at the same time.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.AggregationStrategy'),
        new PropertyMeta('aggregationStrategyMethodName', 'Aggregation Strategy Method Name', "This option can be used to explicit declare the method name to use, when using POJOs as the AggregationStrategy.", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('convertBodyTo', 'ConvertBodyDefinition', 'Convert Body To', "Converts the message body to another type", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('type', 'Type', "The java type to convert to", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('mandatory', 'Mandatory', "When mandatory then the conversion must return a value (cannot be null), if this is not possible then NoTypeConversionAvailableException is thrown. Setting this to false could mean conversion is not possible and the value is null.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('charset', 'Charset', "To use a specific charset when converting", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('convertHeaderTo', 'ConvertHeaderDefinition', 'Convert Header To', "Converts the message header to another type", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('name', 'Name', "Name of message header to convert its value The simple language can be used to define a dynamic evaluated header name to be used. Otherwise a constant name will be used.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('type', 'Type', "The java type to convert to", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('toName', 'To Name', "To use another header to store the result. By default, the result is stored in the same header. This option allows to use another header. The simple language can be used to define a dynamic evaluated header name to be used. Otherwise a constant name will be used.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('mandatory', 'Mandatory', "When mandatory then the conversion must return a value (cannot be null), if this is not possible then NoTypeConversionAvailableException is thrown. Setting this to false could mean conversion is not possible and the value is null.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('charset', 'Charset', "To use a specific charset when converting", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('convertVariableTo', 'ConvertVariableDefinition', 'Convert Variable To', "Converts the variable to another type", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('name', 'Name', "Name of variable to convert its value The simple language can be used to define a dynamic evaluated header name to be used. Otherwise a constant name will be used.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('type', 'Type', "The java type to convert to", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('toName', 'To Name', "To use another variable to store the result. By default, the result is stored in the same variable. This option allows to use another variable. The simple language can be used to define a dynamic evaluated variable name to be used. Otherwise a constant name will be used.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('mandatory', 'Mandatory', "When mandatory then the conversion must return a value (cannot be null), if this is not possible then NoTypeConversionAvailableException is thrown. Setting this to false could mean conversion is not possible and the value is null.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('charset', 'Charset', "To use a specific charset when converting", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('delay', 'DelayDefinition', 'Delay', "Delays processing for a specified length of time", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression to define how long time to wait (in millis)", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('asyncDelayed', 'Async Delayed', "Enables asynchronous delay which means the thread will not block while delaying.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('callerRunsWhenRejected', 'Caller Runs When Rejected', "Whether or not the caller should run the task when it was rejected by the thread pool. Is by default true", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('executorService', 'Executor Service', "To use a custom Thread Pool if asyncDelay has been enabled.", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('dynamicRouter', 'DynamicRouterDefinition', 'Dynamic Router', "Route messages based on dynamic rules", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression to call that returns the endpoint(s) to route to in the dynamic routing. Important: The expression will be called in a while loop fashion, until the expression returns null which means the dynamic router is finished.", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('uriDelimiter', 'Uri Delimiter', "Sets the uri delimiter to use", 'string', '', ',', false, false, false, false, '', ''),
        new PropertyMeta('ignoreInvalidEndpoints', 'Ignore Invalid Endpoints', "Ignore the invalidate endpoint exception when try to create a producer with that endpoint", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('cacheSize', 'Cache Size', "Sets the maximum size used by the org.apache.camel.spi.ProducerCache which is used to cache and reuse producers when using this dynamic router, when uris are reused. Beware that when using dynamic endpoints then it affects how well the cache can be utilized. If each dynamic endpoint is unique then its best to turn off caching by setting this to -1, which allows Camel to not cache both the producers and endpoints; they are regarded as prototype scoped and will be stopped and discarded after use. This reduces memory usage as otherwise producers/endpoints are stored in memory in the caches. However if there are a high degree of dynamic endpoints that have been used before, then it can benefit to use the cache to reuse both producers and endpoints and therefore the cache size can be set accordingly or rely on the default size (1000). If there is a mix of unique and used before dynamic endpoints, then setting a reasonable cache size can help reduce memory usage to avoid storing too many non frequent used producers.", 'number', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('enrich', 'EnrichDefinition', 'Enrich', "Enriches a message with data from a secondary resource", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression that computes the endpoint uri to use as the resource endpoint to enrich from", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('variableSend', 'Variable Send', "To use a variable to store the received message body (only body, not headers). This is handy for easy access to the received message body via variables. Important: When using receive variable then the received body is stored only in this variable and not on the current org.apache.camel.Message .", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('variableReceive', 'Variable Receive', "To use a variable to store the received message body (only body, not headers). This is handy for easy access to the received message body via variables. Important: When using receive variable then the received body is stored only in this variable and not on the current org.apache.camel.Message .", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('aggregationStrategy', 'Aggregation Strategy', "Sets the AggregationStrategy to be used to merge the reply from the external service, into a single outgoing message. By default Camel will use the reply from the external service as outgoing message.", 'string', '', '', false, false, false, false, '', 'org.apache.camel.AggregationStrategy'),
        new PropertyMeta('aggregationStrategyMethodName', 'Aggregation Strategy Method Name', "This option can be used to explicit declare the method name to use, when using POJOs as the AggregationStrategy.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('aggregationStrategyMethodAllowNull', 'Aggregation Strategy Method Allow Null', "If this option is false then the aggregate method is not used if there was no data to enrich. If this option is true then null values is used as the oldExchange (when no data to enrich), when using POJOs as the AggregationStrategy.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('aggregateOnException', 'Aggregate On Exception', "If this option is false then the aggregate method is not used if there was an exception thrown while trying to retrieve the data to enrich from the resource. Setting this option to true allows end users to control what to do if there was an exception in the aggregate method. For example to suppress the exception or set a custom message body etc.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('shareUnitOfWork', 'Share Unit Of Work', "Shares the org.apache.camel.spi.UnitOfWork with the parent and the resource exchange. Enrich will by default not share unit of work between the parent exchange and the resource exchange. This means the resource exchange has its own individual unit of work.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('cacheSize', 'Cache Size', "Sets the maximum size used by the org.apache.camel.spi.ProducerCache which is used to cache and reuse producer when uris are reused. Beware that when using dynamic endpoints then it affects how well the cache can be utilized. If each dynamic endpoint is unique then its best to turn off caching by setting this to -1, which allows Camel to not cache both the producers and endpoints; they are regarded as prototype scoped and will be stopped and discarded after use. This reduces memory usage as otherwise producers/endpoints are stored in memory in the caches. However if there are a high degree of dynamic endpoints that have been used before, then it can benefit to use the cache to reuse both producers and endpoints and therefore the cache size can be set accordingly or rely on the default size (1000). If there is a mix of unique and used before dynamic endpoints, then setting a reasonable cache size can help reduce memory usage to avoid storing too many non frequent used producers.", 'number', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('ignoreInvalidEndpoint', 'Ignore Invalid Endpoint', "Ignore the invalidate endpoint exception when try to create a producer with that endpoint", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('allowOptimisedComponents', 'Allow Optimised Components', "Whether to allow components to optimise enricher if they are org.apache.camel.spi.SendDynamicAware .", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('autoStartComponents', 'Auto Start Components', "Whether to auto startup components when enricher is starting up.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
        new ExchangePropertyMeta('CamelToEndpoint', 'To Endpoint', 'producer', 'String', 'Endpoint URI where this Exchange is being sent to'),
    ]),
    new ElementMeta('filter', 'FilterDefinition', 'Filter', "Filter out messages based using a predicate", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression to determine if the message should be filtered or not. If the expression returns an empty value or false then the message is filtered (dropped), otherwise the message is continued being routed.", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('statusPropertyName', 'Status Property Name', "Name of exchange property to use for storing the status of the filtering. Setting this allows to know if the filter predicate evaluated as true or false.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('doFinally', 'FinallyDefinition', 'Do Finally', "Path traversed when a try, catch, finally block exits", 'error', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
        new ExchangePropertyMeta('CamelExceptionCaught', 'Exception Caught', 'producer', 'java.lang.Exception', 'Stores the caught exception due to a processing error of the current Exchange'),
        new ExchangePropertyMeta('CamelFailureEndpoint', 'Failure Endpoint', 'producer', 'String', 'Endpoint URI where the Exchange failed during processing'),
        new ExchangePropertyMeta('CamelFailureRouteId', 'Failure Route Id', 'producer', 'String', 'Route ID where the Exchange failed during processing'),
    ]),
    new ElementMeta('idempotentConsumer', 'IdempotentConsumerDefinition', 'Idempotent Consumer', "Filters out duplicate messages", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression used to calculate the correlation key to use for duplicate check. The Exchange which has the same correlation key is regarded as a duplicate and will be rejected.", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('idempotentRepository', 'Idempotent Repository', "Sets the reference name of the message id repository", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('eager', 'Eager', "Sets whether to eagerly add the key to the idempotent repository or wait until the exchange is complete. Eager is default enabled.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('completionEager', 'Completion Eager', "Sets whether to complete the idempotent consumer eager or when the exchange is done. If this option is true to complete eager, then the idempotent consumer will trigger its completion when the exchange reached the end of the block of the idempotent consumer pattern. So if the exchange is continued routed after the block ends, then whatever happens there does not affect the state. If this option is false (default) to not complete eager, then the idempotent consumer will complete when the exchange is done being routed. So if the exchange is continued routed after the block ends, then whatever happens there also affect the state. For example if the exchange failed due to an exception, then the state of the idempotent consumer will be a rollback.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('skipDuplicate', 'Skip Duplicate', "Sets whether to skip duplicates or not. The default behavior is to skip duplicates. A duplicate message would have the Exchange property org.apache.camel.Exchange#DUPLICATE_MESSAGE set to a Boolean#TRUE value. A none duplicate message will not have this property set.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('removeOnFailure', 'Remove On Failure', "Sets whether to remove or keep the key on failure. The default behavior is to remove the key on failure.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
        new ExchangePropertyMeta('CamelDuplicateMessage', 'Duplicate Message', 'producer', 'boolean', 'Whether this exchange is a duplicate detected by the Idempotent Consumer EIP'),
    ]),
    new ElementMeta('kamelet', 'KameletDefinition', 'Kamelet', "To call Kamelets in special situations", 'eip,routing', [
        new PropertyMeta('name', 'Name', "Name of the Kamelet (templateId/routeId) to call. Options for the kamelet can be specified using uri syntax, eg mynamecount=4&type=gold.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('parameters', 'parameters', "parameters", 'object', '', '', false, false, false, false, '', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('loadBalance', 'LoadBalanceDefinition', 'Load Balance', "Balances message processing among a number of nodes", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('inheritErrorHandler', 'Inherit Error Handler', "Sets whether or not to inherit the configured error handler. The default value is true. You can use this to disable using the inherited error handler for a given DSL such as a load balancer where you want to use a custom error handler strategy.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('customLoadBalancer', 'customLoadBalancer', "customLoadBalancer", 'CustomLoadBalancerDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('failover', 'failover', "failover", 'FailoverLoadBalancerDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('random', 'random', "random", 'RandomLoadBalancerDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('roundRobin', 'roundRobin', "roundRobin", 'RoundRobinLoadBalancerDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('sticky', 'sticky', "sticky", 'StickyLoadBalancerDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('topic', 'topic', "topic", 'TopicLoadBalancerDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('weighted', 'weighted', "weighted", 'WeightedLoadBalancerDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('log', 'LogDefinition', 'Logger', "Used for printing custom messages to the logger.", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('message', 'Message', "Sets the log message (uses simple language)", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('loggingLevel', 'Logging Level', "Sets the logging level. The default value is INFO", 'string', 'TRACE, DEBUG, INFO, WARN, ERROR, OFF', 'INFO', false, false, false, false, '', ''),
        new PropertyMeta('logName', 'Log Name', "Sets the name of the logger", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('marker', 'Marker', "To use slf4j marker", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('logger', 'Logger', "To refer to a custom logger instance to lookup from the registry.", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('loop', 'LoopDefinition', 'Loop', "Processes a message multiple times", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression to define how many times we should loop. Notice the expression is only evaluated once, and should return a number as how many times to loop. A value of zero or negative means no looping. The loop is like a for-loop fashion, if you want a while loop, then the dynamic router may be a better choice.", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('copy', 'Copy', "If the copy attribute is true, a copy of the input Exchange is used for each iteration. That means each iteration will start from a copy of the same message. By default loop will loop the same exchange all over, so each iteration may have different message content.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('doWhile', 'Do While', "Enables the while loop that loops until the predicate evaluates to false or null.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('breakOnShutdown', 'Break On Shutdown', "If the breakOnShutdown attribute is true, then the loop will not iterate until it reaches the end when Camel is shut down.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
        new ExchangePropertyMeta('CamelLoopIndex', 'Loop Index', 'producer', 'int', 'Index of the current iteration (0 based).'),
        new ExchangePropertyMeta('CamelLoopSize', 'Loop Size', 'producer', 'int', 'Total number of loops. This is not available if running the loop in while loop mode.'),
    ]),
    new ElementMeta('marshal', 'MarshalDefinition', 'Marshal', "Marshals data into a specified format for transmission over a transport or component", 'dataformat,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('variableSend', 'Variable Send', "To use a variable to store the received message body (only body, not headers). This is handy for easy access to the received message body via variables. Important: When using receive variable then the received body is stored only in this variable and not on the current org.apache.camel.Message .", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('variableReceive', 'Variable Receive', "To use a variable to store the received message body (only body, not headers). This is handy for easy access to the received message body via variables. Important: When using receive variable then the received body is stored only in this variable and not on the current org.apache.camel.Message .", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('asn1', 'asn1', "asn1", 'ASN1DataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('avro', 'avro', "avro", 'AvroDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('barcode', 'barcode', "barcode", 'BarcodeDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('base64', 'base64', "base64", 'Base64DataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('beanio', 'beanio', "beanio", 'BeanioDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('bindy', 'bindy', "bindy", 'BindyDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('cbor', 'cbor', "cbor", 'CBORDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('crypto', 'crypto', "crypto", 'CryptoDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('csv', 'csv', "csv", 'CsvDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('custom', 'custom', "custom", 'CustomDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('fhirJson', 'fhirJson', "fhirJson", 'FhirJsonDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('fhirXml', 'fhirXml', "fhirXml", 'FhirXmlDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('flatpack', 'flatpack', "flatpack", 'FlatpackDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('grok', 'grok', "grok", 'GrokDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('gzipDeflater', 'gzipDeflater', "gzipDeflater", 'GzipDeflaterDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('hl7', 'hl7', "hl7", 'HL7DataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('ical', 'ical', "ical", 'IcalDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('jacksonXml', 'jacksonXml', "jacksonXml", 'JacksonXMLDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('jaxb', 'jaxb', "jaxb", 'JaxbDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('json', 'json', "json", 'JsonDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('jsonApi', 'jsonApi', "jsonApi", 'JsonApiDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('lzf', 'lzf', "lzf", 'LZFDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('mimeMultipart', 'mimeMultipart', "mimeMultipart", 'MimeMultipartDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('parquetAvro', 'parquetAvro', "parquetAvro", 'ParquetAvroDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('pgp', 'pgp', "pgp", 'PGPDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('protobuf', 'protobuf', "protobuf", 'ProtobufDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('rss', 'rss', "rss", 'RssDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('soap', 'soap', "soap", 'SoapDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('swiftMt', 'swiftMt', "swiftMt", 'SwiftMtDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('swiftMx', 'swiftMx', "swiftMx", 'SwiftMxDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('syslog', 'syslog', "syslog", 'SyslogDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('tarFile', 'tarFile', "tarFile", 'TarFileDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('thrift', 'thrift', "thrift", 'ThriftDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('tidyMarkup', 'tidyMarkup', "tidyMarkup", 'TidyMarkupDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('univocityCsv', 'univocityCsv', "univocityCsv", 'UniVocityCsvDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('univocityFixed', 'univocityFixed', "univocityFixed", 'UniVocityFixedDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('univocityTsv', 'univocityTsv', "univocityTsv", 'UniVocityTsvDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('xmlSecurity', 'xmlSecurity', "xmlSecurity", 'XMLSecurityDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('yaml', 'yaml', "yaml", 'YAMLDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('zipDeflater', 'zipDeflater', "zipDeflater", 'ZipDeflaterDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('zipFile', 'zipFile', "zipFile", 'ZipFileDataFormat', '', '', false, false, false, true, '', ''),
    ], [
    ]),
    new ElementMeta('multicast', 'MulticastDefinition', 'Multicast', "Routes the same message to multiple paths either sequentially or in parallel.", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('aggregationStrategy', 'Aggregation Strategy', "Refers to an AggregationStrategy to be used to assemble the replies from the multicasts, into a single outgoing message from the Multicast. By default Camel will use the last reply as the outgoing message. You can also use a POJO as the AggregationStrategy", 'string', '', '', false, false, false, false, '', 'org.apache.camel.AggregationStrategy'),
        new PropertyMeta('aggregationStrategyMethodName', 'Aggregation Strategy Method Name', "This option can be used to explicit declare the method name to use, when using POJOs as the AggregationStrategy.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('aggregationStrategyMethodAllowNull', 'Aggregation Strategy Method Allow Null', "If this option is false then the aggregate method is not used if there was no data to enrich. If this option is true then null values is used as the oldExchange (when no data to enrich), when using POJOs as the AggregationStrategy", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('parallelAggregate', 'Parallel Aggregate', "If enabled then the aggregate method on AggregationStrategy can be called concurrently. Notice that this would require the implementation of AggregationStrategy to be implemented as thread-safe. By default this is false meaning that Camel synchronizes the call to the aggregate method. Though in some use-cases this can be used to archive higher performance when the AggregationStrategy is implemented as thread-safe.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('parallelProcessing', 'Parallel Processing', "If enabled then sending messages to the multicasts occurs concurrently. Note the caller thread will still wait until all messages has been fully processed, before it continues. Its only the sending and processing the replies from the multicasts which happens concurrently. When parallel processing is enabled, then the Camel routing engin will continue processing using last used thread from the parallel thread pool. However, if you want to use the original thread that called the multicast, then make sure to enable the synchronous option as well.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('synchronous', 'Synchronous', "Sets whether synchronous processing should be strictly used. When enabled then the same thread is used to continue routing after the multicast is complete, even if parallel processing is enabled.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('streaming', 'Streaming', "If enabled then Camel will process replies out-of-order, eg in the order they come back. If disabled, Camel will process replies in the same order as defined by the multicast.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('stopOnException', 'Stop On Exception', "Will now stop further processing if an exception or failure occurred during processing of an org.apache.camel.Exchange and the caused exception will be thrown. Will also stop if processing the exchange failed (has a fault message) or an exception was thrown and handled by the error handler (such as using onException). In all situations the multicast will stop further processing. This is the same behavior as in pipeline, which is used by the routing engine. The default behavior is to not stop but continue processing till the end", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('timeout', 'Timeout', "Sets a total timeout specified in millis, when using parallel processing. If the Multicast hasn't been able to send and process all replies within the given timeframe, then the timeout triggers and the Multicast breaks out and continues. Notice if you provide a TimeoutAwareAggregationStrategy then the timeout method is invoked before breaking out. If the timeout is reached with running tasks still remaining, certain tasks for which it is difficult for Camel to shut down in a graceful manner may continue to run. So use this option with a bit of care.", 'string', '', '0', false, false, false, false, 'advanced', ''),
        new PropertyMeta('executorService', 'Executor Service', "Refers to a custom Thread Pool to be used for parallel processing. Notice if you set this option, then parallel processing is automatic implied, and you do not have to enable that option as well.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('onPrepare', 'On Prepare', "Uses the Processor when preparing the org.apache.camel.Exchange to be send. This can be used to deep-clone messages that should be send, or any custom logic needed before the exchange is send.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('shareUnitOfWork', 'Share Unit Of Work', "Shares the org.apache.camel.spi.UnitOfWork with the parent and each of the sub messages. Multicast will by default not share unit of work between the parent exchange and each multicasted exchange. This means each sub exchange has its own individual unit of work.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
        new ExchangePropertyMeta('CamelMulticastIndex', 'Multicast Index', 'producer', 'int', 'An index counter that increases for each Exchange being multicasted. The counter starts from 0.'),
        new ExchangePropertyMeta('CamelMulticastComplete', 'Multicast Complete', 'producer', 'boolean', 'Whether this Exchange is the last.'),
        new ExchangePropertyMeta('CamelToEndpoint', 'To Endpoint', 'producer', 'String', 'Endpoint URI where this Exchange is being sent to'),
    ]),
    new ElementMeta('onFallback', 'OnFallbackDefinition', 'On Fallback', "Route to be executed when Circuit Breaker EIP executes fallback", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('fallbackViaNetwork', 'Fallback Via Network', "Whether the fallback goes over the network. If the fallback will go over the network it is another possible point of failure. It is important to execute the fallback command on a separate thread-pool, otherwise if the main command were to become latent and fill the thread-pool this would prevent the fallback from running if the two commands share the same pool.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('otherwise', 'OtherwiseDefinition', 'Otherwise', "Route to be executed when all other choices evaluate to false", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('pausable', 'PausableDefinition', 'Pausable', "Pausable EIP to support resuming processing from last known offset.", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('consumerListener', 'Consumer Listener', "Sets the consumer listener to use", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('untilCheck', 'Until Check', "References to a java.util.function.Predicate to use for until checks. The predicate is responsible for evaluating whether the processing can resume or not. Such predicate should return true if the consumption can resume, or false otherwise. The exact point of when the predicate is called is dependent on the component, and it may be called on either one of the available events. Implementations should not assume the predicate to be called at any specific point.", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('pipeline', 'PipelineDefinition', 'Pipeline', "Routes the message to a sequence of processors.", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('policy', 'PolicyDefinition', 'Policy', "Defines a policy the route will use", 'configuration', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('ref', 'Ref', "Sets a reference to use for lookup the policy in the registry.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('pollEnrich', 'PollEnrichDefinition', 'Poll Enrich', "Enriches messages with data polled from a secondary resource", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression that computes the endpoint uri to use as the resource endpoint to enrich from", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('variableReceive', 'Variable Receive', "To use a variable to store the received message body (only body, not headers). This is handy for easy access to the received message body via variables. Important: When using receive variable then the received body is stored only in this variable and not on the current org.apache.camel.Message .", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('aggregationStrategy', 'Aggregation Strategy', "Sets the AggregationStrategy to be used to merge the reply from the external service, into a single outgoing message. By default Camel will use the reply from the external service as outgoing message.", 'string', '', '', false, false, false, false, '', 'org.apache.camel.AggregationStrategy'),
        new PropertyMeta('aggregationStrategyMethodName', 'Aggregation Strategy Method Name', "This option can be used to explicit declare the method name to use, when using POJOs as the AggregationStrategy.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('aggregationStrategyMethodAllowNull', 'Aggregation Strategy Method Allow Null', "If this option is false then the aggregate method is not used if there was no data to enrich. If this option is true then null values is used as the oldExchange (when no data to enrich), when using POJOs as the AggregationStrategy.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('aggregateOnException', 'Aggregate On Exception', "If this option is false then the aggregate method is not used if there was an exception thrown while trying to retrieve the data to enrich from the resource. Setting this option to true allows end users to control what to do if there was an exception in the aggregate method. For example to suppress the exception or set a custom message body etc.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('timeout', 'Timeout', "Timeout in millis when polling from the external service. The timeout has influence about the poll enrich behavior. It basically operations in three different modes: negative value - Waits until a message is available and then returns it. Warning that this method could block indefinitely if no messages are available. 0 - Attempts to receive a message exchange immediately without waiting and returning null if a message exchange is not available yet. positive value - Attempts to receive a message exchange, waiting up to the given timeout to expire if a message is not yet available. Returns null if timed out The default value is -1 and therefore the method could block indefinitely, and therefore its recommended to use a timeout value", 'string', '', '-1', false, false, false, false, '', ''),
        new PropertyMeta('cacheSize', 'Cache Size', "Sets the maximum size used by the org.apache.camel.spi.ConsumerCache which is used to cache and reuse consumers when uris are reused. Beware that when using dynamic endpoints then it affects how well the cache can be utilized. If each dynamic endpoint is unique then its best to turn off caching by setting this to -1, which allows Camel to not cache both the producers and endpoints; they are regarded as prototype scoped and will be stopped and discarded after use. This reduces memory usage as otherwise producers/endpoints are stored in memory in the caches. However if there are a high degree of dynamic endpoints that have been used before, then it can benefit to use the cache to reuse both producers and endpoints and therefore the cache size can be set accordingly or rely on the default size (1000). If there is a mix of unique and used before dynamic endpoints, then setting a reasonable cache size can help reduce memory usage to avoid storing too many non frequent used producers.", 'number', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('ignoreInvalidEndpoint', 'Ignore Invalid Endpoint', "Ignore the invalidate endpoint exception when try to create a producer with that endpoint", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('autoStartComponents', 'Auto Start Components', "Whether to auto startup components when poll enricher is starting up.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
        new ExchangePropertyMeta('CamelToEndpoint', 'To Endpoint', 'producer', 'String', 'Endpoint URI where this Exchange is being sent to'),
    ]),
    new ElementMeta('process', 'ProcessDefinition', 'Process', "Calls a Camel processor", 'eip,endpoint', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('ref', 'Ref', "Reference to the Processor to lookup in the registry to use. Can also be used for creating new beans by their class name by prefixing with #class, eg #class:com.foo.MyClassType. And it is also possible to refer to singleton beans by their type in the registry by prefixing with #type: syntax, eg #type:com.foo.MyClassType", 'string', '', '', true, false, false, false, '', 'org.apache.camel.Processor'),
    ], [
    ]),
    new ElementMeta('recipientList', 'RecipientListDefinition', 'Recipient List', "Route messages to a number of dynamically specified recipients", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression that returns which endpoints (url) to send the message to (the recipients). If the expression return an empty value then the message is not sent to any recipients.", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('delimiter', 'Delimiter', "Delimiter used if the Expression returned multiple endpoints. Can be turned off using the value false. The default value is ,", 'string', '', ',', false, false, false, false, '', ''),
        new PropertyMeta('aggregationStrategy', 'Aggregation Strategy', "Sets the AggregationStrategy to be used to assemble the replies from the recipients, into a single outgoing message from the RecipientList. By default Camel will use the last reply as the outgoing message. You can also use a POJO as the AggregationStrategy", 'string', '', '', false, false, false, false, '', 'org.apache.camel.AggregationStrategy'),
        new PropertyMeta('aggregationStrategyMethodName', 'Aggregation Strategy Method Name', "This option can be used to explicit declare the method name to use, when using POJOs as the AggregationStrategy.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('aggregationStrategyMethodAllowNull', 'Aggregation Strategy Method Allow Null', "If this option is false then the aggregate method is not used if there was no data to enrich. If this option is true then null values is used as the oldExchange (when no data to enrich), when using POJOs as the AggregationStrategy", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('parallelAggregate', 'Parallel Aggregate', "If enabled then the aggregate method on AggregationStrategy can be called concurrently. Notice that this would require the implementation of AggregationStrategy to be implemented as thread-safe. By default this is false meaning that Camel synchronizes the call to the aggregate method. Though in some use-cases this can be used to archive higher performance when the AggregationStrategy is implemented as thread-safe.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('parallelProcessing', 'Parallel Processing', "If enabled then sending messages to the recipients occurs concurrently. Note the caller thread will still wait until all messages has been fully processed, before it continues. Its only the sending and processing the replies from the recipients which happens concurrently. When parallel processing is enabled, then the Camel routing engin will continue processing using last used thread from the parallel thread pool. However, if you want to use the original thread that called the recipient list, then make sure to enable the synchronous option as well.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('synchronous', 'Synchronous', "Sets whether synchronous processing should be strictly used. When enabled then the same thread is used to continue routing after the recipient list is complete, even if parallel processing is enabled.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('timeout', 'Timeout', "Sets a total timeout specified in millis, when using parallel processing. If the Recipient List hasn't been able to send and process all replies within the given timeframe, then the timeout triggers and the Recipient List breaks out and continues. Notice if you provide a TimeoutAwareAggregationStrategy then the timeout method is invoked before breaking out. If the timeout is reached with running tasks still remaining, certain tasks for which it is difficult for Camel to shut down in a graceful manner may continue to run. So use this option with a bit of care.", 'string', '', '0', false, false, false, false, '', ''),
        new PropertyMeta('executorService', 'Executor Service', "To use a custom Thread Pool to be used for parallel processing. Notice if you set this option, then parallel processing is automatic implied, and you do not have to enable that option as well.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('stopOnException', 'Stop On Exception', "Will now stop further processing if an exception or failure occurred during processing of an org.apache.camel.Exchange and the caused exception will be thrown. Will also stop if processing the exchange failed (has a fault message) or an exception was thrown and handled by the error handler (such as using onException). In all situations the recipient list will stop further processing. This is the same behavior as in pipeline, which is used by the routing engine. The default behavior is to not stop but continue processing till the end", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('ignoreInvalidEndpoints', 'Ignore Invalid Endpoints', "Ignore the invalidate endpoint exception when try to create a producer with that endpoint", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('streaming', 'Streaming', "If enabled then Camel will process replies out-of-order, eg in the order they come back. If disabled, Camel will process replies in the same order as defined by the recipient list.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('onPrepare', 'On Prepare', "Uses the Processor when preparing the org.apache.camel.Exchange to be used send. This can be used to deep-clone messages that should be send, or any custom logic needed before the exchange is send.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('cacheSize', 'Cache Size', "Sets the maximum size used by the org.apache.camel.spi.ProducerCache which is used to cache and reuse producers when using this recipient list, when uris are reused. Beware that when using dynamic endpoints then it affects how well the cache can be utilized. If each dynamic endpoint is unique then its best to turn off caching by setting this to -1, which allows Camel to not cache both the producers and endpoints; they are regarded as prototype scoped and will be stopped and discarded after use. This reduces memory usage as otherwise producers/endpoints are stored in memory in the caches. However if there are a high degree of dynamic endpoints that have been used before, then it can benefit to use the cache to reuse both producers and endpoints and therefore the cache size can be set accordingly or rely on the default size (1000). If there is a mix of unique and used before dynamic endpoints, then setting a reasonable cache size can help reduce memory usage to avoid storing too many non frequent used producers.", 'number', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('shareUnitOfWork', 'Share Unit Of Work', "Shares the org.apache.camel.spi.UnitOfWork with the parent and each of the sub messages. Recipient List will by default not share unit of work between the parent exchange and each recipient exchange. This means each sub exchange has its own individual unit of work.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
    ], [
        new ExchangePropertyMeta('CamelRecipientListEndpoint', 'Recipient List Endpoint', 'producer', 'String', 'The endpoint uri of this recipient list'),
        new ExchangePropertyMeta('CamelToEndpoint', 'To Endpoint', 'producer', 'String', 'Endpoint URI where this Exchange is being sent to'),
    ]),
    new ElementMeta('removeHeader', 'RemoveHeaderDefinition', 'Remove Header', "Removes a named header from the message", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('name', 'Name', "Name of header to remove", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('removeHeaders', 'RemoveHeadersDefinition', 'Remove Headers', "Removes message headers whose name matches a specified pattern", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('pattern', 'Pattern', "Name or pattern of headers to remove. The pattern is matched in the following order: 1 = exact match 2 = wildcard (pattern ends with a and the name starts with the pattern) 3 = regular expression (all of above is case in-sensitive).", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('excludePattern', 'Exclude Pattern', "Name or patter of headers to not remove. The pattern is matched in the following order: 1 = exact match 2 = wildcard (pattern ends with a and the name starts with the pattern) 3 = regular expression (all of above is case in-sensitive).", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('removeProperties', 'RemovePropertiesDefinition', 'Remove Properties', "Removes message exchange properties whose name matches a specified pattern", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('pattern', 'Pattern', "Name or pattern of properties to remove. The pattern is matched in the following order: 1 = exact match 2 = wildcard (pattern ends with a and the name starts with the pattern) 3 = regular expression (all of above is case in-sensitive).", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('excludePattern', 'Exclude Pattern', "Name or pattern of properties to not remove. The pattern is matched in the following order: 1 = exact match 2 = wildcard (pattern ends with a and the name starts with the pattern) 3 = regular expression (all of above is case in-sensitive).", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('removeProperty', 'RemovePropertyDefinition', 'Remove Property', "Removes a named property from the message exchange", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('name', 'Name', "Name of property to remove.", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('removeVariable', 'RemoveVariableDefinition', 'Remove Variable', "Removes a named variable", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('name', 'Name', "Name of variable to remove.", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('resequence', 'ResequenceDefinition', 'Resequence', "Resequences (re-order) messages based on an expression", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression to use for re-ordering the messages, such as a header with a sequence number", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('batchConfig', 'batchConfig', "batchConfig", 'BatchResequencerConfig', '', '', false, false, false, true, '', ''),
        new PropertyMeta('streamConfig', 'streamConfig', "streamConfig", 'StreamResequencerConfig', '', '', false, false, false, true, '', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('resumable', 'ResumableDefinition', 'Resumable', "Resume EIP to support resuming processing from last known offset.", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('resumeStrategy', 'Resume Strategy', "Sets the resume strategy to use", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('loggingLevel', 'Logging Level', "loggingLevel", 'string', 'TRACE, DEBUG, INFO, WARN, ERROR, OFF', 'ERROR', false, false, false, false, 'advanced', ''),
        new PropertyMeta('intermittent', 'Intermittent', "Sets whether the offsets will be intermittently present or whether they must be present in every exchange", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('rollback', 'RollbackDefinition', 'Rollback', "Forces a rollback by stopping routing the message", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('message', 'Message', "Message to use in rollback exception", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('markRollbackOnly', 'Mark Rollback Only', "Mark the transaction for rollback only (cannot be overruled to commit)", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('markRollbackOnlyLast', 'Mark Rollback Only Last', "Mark only last sub transaction for rollback only. When using sub transactions (if the transaction manager support this)", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('routingSlip', 'RoutingSlipDefinition', 'Routing Slip', "Routes a message through a series of steps that are pre-determined (the slip)", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression to define the routing slip, which defines which endpoints to route the message in a pipeline style. Notice the expression is evaluated once, if you want a more dynamic style, then the dynamic router eip is a better choice.", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('uriDelimiter', 'Uri Delimiter', "Sets the uri delimiter to use", 'string', '', ',', false, false, false, false, '', ''),
        new PropertyMeta('ignoreInvalidEndpoints', 'Ignore Invalid Endpoints', "Ignore the invalidate endpoint exception when try to create a producer with that endpoint", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('cacheSize', 'Cache Size', "Sets the maximum size used by the org.apache.camel.spi.ProducerCache which is used to cache and reuse producers when using this routing slip, when uris are reused. Beware that when using dynamic endpoints then it affects how well the cache can be utilized. If each dynamic endpoint is unique then its best to turn off caching by setting this to -1, which allows Camel to not cache both the producers and endpoints; they are regarded as prototype scoped and will be stopped and discarded after use. This reduces memory usage as otherwise producers/endpoints are stored in memory in the caches. However if there are a high degree of dynamic endpoints that have been used before, then it can benefit to use the cache to reuse both producers and endpoints and therefore the cache size can be set accordingly or rely on the default size (1000). If there is a mix of unique and used before dynamic endpoints, then setting a reasonable cache size can help reduce memory usage to avoid storing too many non frequent used producers.", 'number', '', '', false, false, false, false, 'advanced', ''),
    ], [
        new ExchangePropertyMeta('CamelSlipEndpoint', 'Slip Endpoint', 'producer', 'String', 'The endpoint uri of this routing slip'),
        new ExchangePropertyMeta('CamelToEndpoint', 'To Endpoint', 'producer', 'String', 'Endpoint URI where this Exchange is being sent to'),
    ]),
    new ElementMeta('saga', 'SagaDefinition', 'Saga', "Enables Sagas on the route", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('sagaService', 'Saga Service', "Refers to the id to lookup in the registry for the specific CamelSagaService to use.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('propagation', 'Propagation', "Set the Saga propagation mode (REQUIRED, REQUIRES_NEW, MANDATORY, SUPPORTS, NOT_SUPPORTED, NEVER).", 'string', 'REQUIRED, REQUIRES_NEW, MANDATORY, SUPPORTS, NOT_SUPPORTED, NEVER', 'REQUIRED', false, false, false, false, 'advanced', ''),
        new PropertyMeta('completionMode', 'Completion Mode', "Determine how the saga should be considered complete. When set to AUTO, the saga is completed when the exchange that initiates the saga is processed successfully, or compensated when it completes exceptionally. When set to MANUAL, the user must complete or compensate the saga using the saga:complete or saga:compensate endpoints.", 'string', 'AUTO, MANUAL', 'AUTO', false, false, false, false, 'advanced', ''),
        new PropertyMeta('timeout', 'Timeout', "Set the maximum amount of time for the Saga. After the timeout is expired, the saga will be compensated automatically (unless a different decision has been taken in the meantime).", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('compensation', 'Compensation', "The compensation endpoint URI that must be called to compensate all changes done in the route. The route corresponding to the compensation URI must perform compensation and complete without error. If errors occur during compensation, the saga service may call again the compensation URI to retry.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('completion', 'Completion', "The completion endpoint URI that will be called when the Saga is completed successfully. The route corresponding to the completion URI must perform completion tasks and terminate without error. If errors occur during completion, the saga service may call again the completion URI to retry.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('option', 'Option', "Allows to save properties of the current exchange in order to re-use them in a compensation/completion callback route. Options are usually helpful e.g. to store and retrieve identifiers of objects that should be deleted in compensating actions. Option values will be transformed into input headers of the compensation/completion exchange.", 'PropertyExpressionDefinition', '', '', false, false, true, true, 'advanced', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('sample', 'SamplingDefinition', 'Sample', "Extract a sample of the messages passing through a route", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('samplePeriod', 'Sample Period', "Sets the sample period during which only a single Exchange will pass through.", 'string', '', '1000', false, false, false, false, '', ''),
        new PropertyMeta('messageFrequency', 'Message Frequency', "Sets the sample message count which only a single Exchange will pass through after this many received.", 'number', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('script', 'ScriptDefinition', 'Script', "Executes a script from a language which does not change the message body.", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression to return the transformed message body (the new message body to use)", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
    ], [
    ]),
    new ElementMeta('setBody', 'SetBodyDefinition', 'Set Body', "Sets the contents of the message body", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression that returns the new body to use", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
    ], [
    ]),
    new ElementMeta('setExchangePattern', 'SetExchangePatternDefinition', 'Set Exchange Pattern', "Sets the exchange pattern on the message exchange", 'configuration', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('pattern', 'Pattern', "Sets the new exchange pattern of the Exchange to be used from this point forward", 'string', 'InOnly, InOut', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('setHeader', 'SetHeaderDefinition', 'Set Header', "Sets the value of a message header", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('name', 'Name', "Name of message header to set a new value The simple language can be used to define a dynamic evaluated header name to be used. Otherwise a constant name will be used.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "Expression to return the value of the header", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
    ], [
    ]),
    new ElementMeta('setHeaders', 'SetHeadersDefinition', 'Set Headers', "Allows setting multiple headers on the message at the same time.", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('headers', 'headers', "headers", 'SetHeaderDefinition', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('setProperty', 'SetPropertyDefinition', 'Set Property', "Sets a named property on the message exchange", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('name', 'Name', "Name of exchange property to set a new value. The simple language can be used to define a dynamic evaluated exchange property name to be used. Otherwise a constant name will be used.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "Expression to return the value of the message exchange property", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
    ], [
    ]),
    new ElementMeta('setVariable', 'SetVariableDefinition', 'Set Variable', "Sets the value of a variable", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('name', 'Name', "Name of variable to set a new value The simple language can be used to define a dynamic evaluated variable name to be used. Otherwise a constant name will be used.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "Expression to return the value of the variable", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
    ], [
    ]),
    new ElementMeta('setVariables', 'SetVariablesDefinition', 'Set Variables', "Allows setting multiple variables at the same time.", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('variables', 'variables', "variables", 'SetVariableDefinition', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('sort', 'SortDefinition', 'Sort', "Sorts the contents of the message", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Optional expression to sort by something else than the message body", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('comparator', 'Comparator', "Sets the comparator to use for sorting", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('split', 'SplitDefinition', 'Split', "Splits a single message into many sub-messages.", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression of how to split the message body, such as as-is, using a tokenizer, or using a xpath.", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('delimiter', 'Delimiter', "Delimiter used in splitting messages. Can be turned off using the value false. To force not splitting then the delimiter can be set to single to use the value as a single list, this can be needed in some special situations. The default value is comma.", 'string', '', ',', false, false, false, false, '', ''),
        new PropertyMeta('aggregationStrategy', 'Aggregation Strategy', "Sets a reference to the AggregationStrategy to be used to assemble the replies from the split messages, into a single outgoing message from the Splitter. By default Camel will use the original incoming message to the splitter (leave it unchanged). You can also use a POJO as the AggregationStrategy", 'string', '', '', false, false, false, false, '', 'org.apache.camel.AggregationStrategy'),
        new PropertyMeta('aggregationStrategyMethodName', 'Aggregation Strategy Method Name', "This option can be used to explicit declare the method name to use, when using POJOs as the AggregationStrategy.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('aggregationStrategyMethodAllowNull', 'Aggregation Strategy Method Allow Null', "If this option is false then the aggregate method is not used if there was no data to enrich. If this option is true then null values is used as the oldExchange (when no data to enrich), when using POJOs as the AggregationStrategy", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('parallelAggregate', 'Parallel Aggregate', "If enabled then the aggregate method on AggregationStrategy can be called concurrently. Notice that this would require the implementation of AggregationStrategy to be implemented as thread-safe. By default this is false meaning that Camel synchronizes the call to the aggregate method. Though in some use-cases this can be used to archive higher performance when the AggregationStrategy is implemented as thread-safe.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('parallelProcessing', 'Parallel Processing', "If enabled then processing each split messages occurs concurrently. Note the caller thread will still wait until all messages has been fully processed, before it continues. It's only processing the sub messages from the splitter which happens concurrently. When parallel processing is enabled, then the Camel routing engin will continue processing using last used thread from the parallel thread pool. However, if you want to use the original thread that called the splitter, then make sure to enable the synchronous option as well.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('synchronous', 'Synchronous', "Sets whether synchronous processing should be strictly used. When enabled then the same thread is used to continue routing after the split is complete, even if parallel processing is enabled.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('streaming', 'Streaming', "When in streaming mode, then the splitter splits the original message on-demand, and each split message is processed one by one. This reduces memory usage as the splitter do not split all the messages first, but then we do not know the total size, and therefore the org.apache.camel.Exchange#SPLIT_SIZE is empty. In non-streaming mode (default) the splitter will split each message first, to know the total size, and then process each message one by one. This requires to keep all the split messages in memory and therefore requires more memory. The total size is provided in the org.apache.camel.Exchange#SPLIT_SIZE header. The streaming mode also affects the aggregation behavior. If enabled then Camel will process replies out-of-order, e.g. in the order they come back. If disabled, Camel will process replies in the same order as the messages was split.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('stopOnException', 'Stop On Exception', "Will now stop further processing if an exception or failure occurred during processing of an org.apache.camel.Exchange and the caused exception will be thrown. Will also stop if processing the exchange failed (has a fault message) or an exception was thrown and handled by the error handler (such as using onException). In all situations the splitter will stop further processing. This is the same behavior as in pipeline, which is used by the routing engine. The default behavior is to not stop but continue processing till the end", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('timeout', 'Timeout', "Sets a total timeout specified in millis, when using parallel processing. If the Splitter hasn't been able to split and process all the sub messages within the given timeframe, then the timeout triggers and the Splitter breaks out and continues. Notice if you provide a TimeoutAwareAggregationStrategy then the timeout method is invoked before breaking out. If the timeout is reached with running tasks still remaining, certain tasks for which it is difficult for Camel to shut down in a graceful manner may continue to run. So use this option with a bit of care.", 'string', '', '0', false, false, false, false, 'advanced', ''),
        new PropertyMeta('executorService', 'Executor Service', "To use a custom Thread Pool to be used for parallel processing. Notice if you set this option, then parallel processing is automatically implied, and you do not have to enable that option as well.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('onPrepare', 'On Prepare', "Uses the Processor when preparing the org.apache.camel.Exchange to be sent. This can be used to deep-clone messages that should be sent, or any custom logic needed before the exchange is sent.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('shareUnitOfWork', 'Share Unit Of Work', "Shares the org.apache.camel.spi.UnitOfWork with the parent and each of the sub messages. Splitter will by default not share unit of work between the parent exchange and each split exchange. This means each split exchange has its own individual unit of work.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
        new ExchangePropertyMeta('CamelSplitIndex', 'Split Index', 'producer', 'int', 'A split counter that increases for each Exchange being split. The counter starts from 0.'),
        new ExchangePropertyMeta('CamelSplitComplete', 'Split Complete', 'producer', 'boolean', 'Whether this Exchange is the last.'),
        new ExchangePropertyMeta('CamelSplitSize', 'Split Size', 'producer', 'int', 'The total number of Exchanges that was split. This property is not applied for stream based splitting, except for the very last message because then Camel knows the total size.'),
    ]),
    new ElementMeta('step', 'StepDefinition', 'Step', "Routes the message to a sequence of processors which is grouped together as one logical name", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
        new ExchangePropertyMeta('CamelStepId', 'Step Id', 'producer', 'String', 'The id of the Step EIP'),
    ]),
    new ElementMeta('stop', 'StopDefinition', 'Stop', "Stops the processing of the current message", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('threads', 'ThreadsDefinition', 'Threads', "Specifies that all steps after this node are processed asynchronously", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('executorService', 'Executor Service', "To use a custom thread pool", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('poolSize', 'Pool Size', "Sets the core pool size", 'number', '', '', false, false, false, false, '', ''),
        new PropertyMeta('maxPoolSize', 'Max Pool Size', "Sets the maximum pool size", 'number', '', '', false, false, false, false, '', ''),
        new PropertyMeta('keepAliveTime', 'Keep Alive Time', "Sets the keep alive time for idle threads", 'number', '', '', false, false, false, false, '', ''),
        new PropertyMeta('timeUnit', 'Time Unit', "Sets the keep alive time unit. By default SECONDS is used.", 'string', 'NANOSECONDS, MICROSECONDS, MILLISECONDS, SECONDS, MINUTES, HOURS, DAYS', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('maxQueueSize', 'Max Queue Size', "Sets the maximum number of tasks in the work queue. Use -1 or Integer.MAX_VALUE for an unbounded queue", 'number', '', '', false, false, false, false, '', ''),
        new PropertyMeta('allowCoreThreadTimeOut', 'Allow Core Thread Time Out', "Whether idle core threads are allowed to timeout and therefore can shrink the pool size below the core pool size Is by default false", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('threadName', 'Thread Name', "Sets the thread name to use.", 'string', '', 'Threads', false, false, false, false, '', ''),
        new PropertyMeta('rejectedPolicy', 'Rejected Policy', "Sets the handler for tasks which cannot be executed by the thread pool.", 'string', 'Abort, CallerRuns', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('callerRunsWhenRejected', 'Caller Runs When Rejected', "Whether or not to use as caller runs as fallback when a task is rejected being added to the thread pool (when its full). This is only used as fallback if no rejectedPolicy has been configured, or the thread pool has no configured rejection handler. Is by default true", 'string', '', 'true', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('throttle', 'ThrottleDefinition', 'Throttle', "Controls the rate at which messages are passed to the next node in the route", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression to configure the maximum number of messages to throttle per request", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('mode', 'Mode', "Sets the throttling mode to one of the available modes enumerated in ThrottlingMode", 'string', 'TotalRequests, ConcurrentRequests', 'TotalRequests', false, false, false, false, '', ''),
        new PropertyMeta('correlationExpression', 'Correlation Expression', "The expression used to calculate the correlation key to use for throttle grouping. The Exchange which has the same correlation key is throttled together.", 'ExpressionSubElementDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('executorService', 'Executor Service', "To use a custom thread pool (ScheduledExecutorService) by the throttler.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('asyncDelayed', 'Async Delayed', "Enables asynchronous delay which means the thread will not block while delaying.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('callerRunsWhenRejected', 'Caller Runs When Rejected', "Whether or not the caller should run the task when it was rejected by the thread pool. Is by default true", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('rejectExecution', 'Reject Execution', "Whether or not throttler throws the ThrottlerRejectedExecutionException when the exchange exceeds the request limit Is by default false", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('timePeriodMillis', 'Time Period Millis', "Sets the time period during which the maximum request count is valid for", 'string', '', '1000', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('throwException', 'ThrowExceptionDefinition', 'Throw Exception', "Throws an exception", 'error', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('message', 'Message', "To create a new exception instance and use the given message as caused message (supports simple language)", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('exceptionType', 'Exception Type', "The class of the exception to create using the message.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('ref', 'Ref', "Reference to the exception instance to lookup from the registry to throw", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('to', 'ToDefinition', 'To', "Sends the message to a static endpoint", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('variableSend', 'Variable Send', "To use a variable as the source for the message body to send. This makes it handy to use variables for user data and to easily control what data to use for sending and receiving. Important: When using send variable then the message body is taken from this variable instead of the current Message , however the headers from the Message will still be used as well. In other words, the variable is used instead of the message body, but everything else is as usual.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('variableReceive', 'Variable Receive', "To use a variable to store the received message body (only body, not headers). This is handy for easy access to the received message body via variables. Important: When using receive variable then the received body is stored only in this variable and not on the current org.apache.camel.Message .", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('uri', 'Uri', "Sets the uri of the endpoint to send to.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('pattern', 'Pattern', "Sets the optional ExchangePattern used to invoke this endpoint", 'string', 'InOnly, InOut', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('parameters', 'parameters', "parameters", 'object', '', '', false, false, false, false, '', ''),
    ], [
        new ExchangePropertyMeta('CamelToEndpoint', 'To Endpoint', 'producer', 'String', 'Endpoint URI where this Exchange is being sent to'),
    ]),
    new ElementMeta('toD', 'ToDynamicDefinition', 'To D', "Sends the message to a dynamic endpoint", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('uri', 'Uri', "The uri of the endpoint to send to. The uri can be dynamic computed using the org.apache.camel.language.simple.SimpleLanguage expression.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('variableSend', 'Variable Send', "To use a variable to store the received message body (only body, not headers). This is handy for easy access to the received message body via variables. Important: When using receive variable then the received body is stored only in this variable and not on the current org.apache.camel.Message .", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('variableReceive', 'Variable Receive', "To use a variable as the source for the message body to send. This makes it handy to use variables for user data and to easily control what data to use for sending and receiving. Important: When using send variable then the message body is taken from this variable instead of the current Message , however the headers from the Message will still be used as well. In other words, the variable is used instead of the message body, but everything else is as usual.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('pattern', 'Pattern', "Sets the optional ExchangePattern used to invoke this endpoint", 'string', 'InOnly, InOut', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('cacheSize', 'Cache Size', "Sets the maximum size used by the org.apache.camel.spi.ProducerCache which is used to cache and reuse producers when using this recipient list, when uris are reused. Beware that when using dynamic endpoints then it affects how well the cache can be utilized. If each dynamic endpoint is unique then its best to turn off caching by setting this to -1, which allows Camel to not cache both the producers and endpoints; they are regarded as prototype scoped and will be stopped and discarded after use. This reduces memory usage as otherwise producers/endpoints are stored in memory in the caches. However if there are a high degree of dynamic endpoints that have been used before, then it can benefit to use the cache to reuse both producers and endpoints and therefore the cache size can be set accordingly or rely on the default size (1000). If there is a mix of unique and used before dynamic endpoints, then setting a reasonable cache size can help reduce memory usage to avoid storing too many non frequent used producers.", 'number', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('ignoreInvalidEndpoint', 'Ignore Invalid Endpoint', "Whether to ignore invalid endpoint URIs and skip sending the message.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('allowOptimisedComponents', 'Allow Optimised Components', "Whether to allow components to optimise toD if they are org.apache.camel.spi.SendDynamicAware .", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('autoStartComponents', 'Auto Start Components', "Whether to auto startup components when toD is starting up.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('parameters', 'parameters', "parameters", 'object', '', '', false, false, false, false, '', ''),
    ], [
        new ExchangePropertyMeta('CamelToEndpoint', 'To Endpoint', 'producer', 'String', 'Endpoint URI where this Exchange is being sent to'),
    ]),
    new ElementMeta('transacted', 'TransactedDefinition', 'Transacted', "Enables transaction on the route", 'configuration', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('ref', 'Ref', "Sets a reference to use for lookup the policy in the registry.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('transform', 'TransformDefinition', 'Transform', "Transforms the message body based on an expression", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression to return the transformed message body (the new message body to use)", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('fromType', 'From Type', "From type used in data type transformation.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('toType', 'To Type', "To type used as a target data type in the transformation.", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('doTry', 'TryDefinition', 'Do Try', "Marks the beginning of a try, catch, finally block", 'error', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('doCatch', 'doCatch', "doCatch", 'CatchDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('doFinally', 'doFinally', "doFinally", 'FinallyDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('unmarshal', 'UnmarshalDefinition', 'Unmarshal', "Converts the message data received from the wire into a format that Apache Camel processors can consume", 'dataformat,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('variableSend', 'Variable Send', "To use a variable to store the received message body (only body, not headers). This is handy for easy access to the received message body via variables. Important: When using receive variable then the received body is stored only in this variable and not on the current org.apache.camel.Message .", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('variableReceive', 'Variable Receive', "To use a variable to store the received message body (only body, not headers). This is handy for easy access to the received message body via variables. Important: When using receive variable then the received body is stored only in this variable and not on the current org.apache.camel.Message .", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('allowNullBody', 'Allow Null Body', "Indicates whether null is allowed as value of a body to unmarshall.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('asn1', 'asn1', "asn1", 'ASN1DataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('avro', 'avro', "avro", 'AvroDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('barcode', 'barcode', "barcode", 'BarcodeDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('base64', 'base64', "base64", 'Base64DataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('beanio', 'beanio', "beanio", 'BeanioDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('bindy', 'bindy', "bindy", 'BindyDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('cbor', 'cbor', "cbor", 'CBORDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('crypto', 'crypto', "crypto", 'CryptoDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('csv', 'csv', "csv", 'CsvDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('custom', 'custom', "custom", 'CustomDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('fhirJson', 'fhirJson', "fhirJson", 'FhirJsonDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('fhirXml', 'fhirXml', "fhirXml", 'FhirXmlDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('flatpack', 'flatpack', "flatpack", 'FlatpackDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('grok', 'grok', "grok", 'GrokDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('gzipDeflater', 'gzipDeflater', "gzipDeflater", 'GzipDeflaterDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('hl7', 'hl7', "hl7", 'HL7DataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('ical', 'ical', "ical", 'IcalDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('jacksonXml', 'jacksonXml', "jacksonXml", 'JacksonXMLDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('jaxb', 'jaxb', "jaxb", 'JaxbDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('json', 'json', "json", 'JsonDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('jsonApi', 'jsonApi', "jsonApi", 'JsonApiDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('lzf', 'lzf', "lzf", 'LZFDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('mimeMultipart', 'mimeMultipart', "mimeMultipart", 'MimeMultipartDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('parquetAvro', 'parquetAvro', "parquetAvro", 'ParquetAvroDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('pgp', 'pgp', "pgp", 'PGPDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('protobuf', 'protobuf', "protobuf", 'ProtobufDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('rss', 'rss', "rss", 'RssDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('soap', 'soap', "soap", 'SoapDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('swiftMt', 'swiftMt', "swiftMt", 'SwiftMtDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('swiftMx', 'swiftMx', "swiftMx", 'SwiftMxDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('syslog', 'syslog', "syslog", 'SyslogDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('tarFile', 'tarFile', "tarFile", 'TarFileDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('thrift', 'thrift', "thrift", 'ThriftDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('tidyMarkup', 'tidyMarkup', "tidyMarkup", 'TidyMarkupDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('univocityCsv', 'univocityCsv', "univocityCsv", 'UniVocityCsvDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('univocityFixed', 'univocityFixed', "univocityFixed", 'UniVocityFixedDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('univocityTsv', 'univocityTsv', "univocityTsv", 'UniVocityTsvDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('xmlSecurity', 'xmlSecurity', "xmlSecurity", 'XMLSecurityDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('yaml', 'yaml', "yaml", 'YAMLDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('zipDeflater', 'zipDeflater', "zipDeflater", 'ZipDeflaterDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('zipFile', 'zipFile', "zipFile", 'ZipFileDataFormat', '', '', false, false, false, true, '', ''),
    ], [
    ]),
    new ElementMeta('validate', 'ValidateDefinition', 'Validate', "Validates a message based on an expression", 'eip,transformation', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression to use for validation as a predicate. The expression should return either true or false. If returning false the message is invalid and an exception is thrown.", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('predicateExceptionFactory', 'Predicate Exception Factory', "The bean id of custom PredicateExceptionFactory to use for creating the exception when the validation fails. By default, Camel will throw PredicateValidationException. By using a custom factory you can control which exception to throw instead.", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('when', 'WhenDefinition', 'When', "Triggers a route when the expression evaluates to true", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression used as the predicate to evaluate whether this when should trigger and route the message or not.", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('whenSkipSendToEndpoint', 'WhenSkipSendToEndpointDefinition', 'When Skip Send To Endpoint', "Predicate to determine if the message should be sent or not to the endpoint, when using interceptSentToEndpoint.", 'configuration', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('expression', 'Expression', "Expression used as the predicate to evaluate whether the message should be sent or not to the endpoint", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('wireTap', 'WireTapDefinition', 'Wire Tap', "Routes a copy of a message (or creates a new message) to a secondary destination while continue routing the original message.", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('copy', 'Copy', "Uses a copy of the original exchange", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('dynamicUri', 'Dynamic Uri', "Whether the uri is dynamic or static. If the uri is dynamic then the simple language is used to evaluate a dynamic uri to use as the wire-tap destination, for each incoming message. This works similar to how the toD EIP pattern works. If static then the uri is used as-is as the wire-tap destination.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('onPrepare', 'On Prepare', "Uses the Processor when preparing the org.apache.camel.Exchange to be sent. This can be used to deep-clone messages that should be sent, or any custom logic needed before the exchange is sent.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('executorService', 'Executor Service', "Uses a custom thread pool", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('uri', 'Uri', "The uri of the endpoint to send to. The uri can be dynamic computed using the org.apache.camel.language.simple.SimpleLanguage expression.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('variableSend', 'Variable Send', "To use a variable to store the received message body (only body, not headers). This is handy for easy access to the received message body via variables. Important: When using receive variable then the received body is stored only in this variable and not on the current org.apache.camel.Message .", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('variableReceive', 'Variable Receive', "To use a variable as the source for the message body to send. This makes it handy to use variables for user data and to easily control what data to use for sending and receiving. Important: When using send variable then the message body is taken from this variable instead of the current Message , however the headers from the Message will still be used as well. In other words, the variable is used instead of the message body, but everything else is as usual.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('pattern', 'Pattern', "Sets the optional ExchangePattern used to invoke this endpoint", 'string', 'InOnly, InOut', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('cacheSize', 'Cache Size', "Sets the maximum size used by the org.apache.camel.spi.ProducerCache which is used to cache and reuse producers when using this recipient list, when uris are reused. Beware that when using dynamic endpoints then it affects how well the cache can be utilized. If each dynamic endpoint is unique then its best to turn off caching by setting this to -1, which allows Camel to not cache both the producers and endpoints; they are regarded as prototype scoped and will be stopped and discarded after use. This reduces memory usage as otherwise producers/endpoints are stored in memory in the caches. However if there are a high degree of dynamic endpoints that have been used before, then it can benefit to use the cache to reuse both producers and endpoints and therefore the cache size can be set accordingly or rely on the default size (1000). If there is a mix of unique and used before dynamic endpoints, then setting a reasonable cache size can help reduce memory usage to avoid storing too many non frequent used producers.", 'number', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('ignoreInvalidEndpoint', 'Ignore Invalid Endpoint', "Whether to ignore invalid endpoint URIs and skip sending the message.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('allowOptimisedComponents', 'Allow Optimised Components', "Whether to allow components to optimise toD if they are org.apache.camel.spi.SendDynamicAware .", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('autoStartComponents', 'Auto Start Components', "Whether to auto startup components when toD is starting up.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('parameters', 'parameters', "parameters", 'object', '', '', false, false, false, false, '', ''),
    ], [
        new ExchangePropertyMeta('CamelToEndpoint', 'To Endpoint', 'producer', 'String', 'Endpoint URI where this Exchange is being sent to'),
    ]),
    new ElementMeta('intercept', 'InterceptDefinition', 'Intercept', "Intercepts a message at each step in the route", 'configuration', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('interceptFrom', 'InterceptFromDefinition', 'Intercept From', "Intercepts incoming messages", 'configuration', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('uri', 'Uri', "Intercept incoming messages from the uri or uri pattern. If this option is not configured, then all incoming messages is intercepted.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
        new ExchangePropertyMeta('CamelInterceptedEndpoint', 'Intercepted Endpoint', 'producer', 'String', 'The endpoint URI that was intercepted'),
    ]),
    new ElementMeta('interceptSendToEndpoint', 'InterceptSendToEndpointDefinition', 'Intercept Send To Endpoint', "Intercepts messages being sent to an endpoint", 'configuration', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('uri', 'Uri', "Intercept sending to the uri or uri pattern.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('skipSendToOriginalEndpoint', 'Skip Send To Original Endpoint', "If set to true then the message is not sent to the original endpoint. By default (false) the message is both intercepted and then sent to the original endpoint.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('afterUri', 'After Uri', "After sending to the endpoint then send the message to this uri which allows to process its result.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
        new ExchangePropertyMeta('CamelInterceptedEndpoint', 'Intercepted Endpoint', 'producer', 'String', 'The endpoint URI that was intercepted'),
    ]),
    new ElementMeta('onCompletion', 'OnCompletionDefinition', 'On Completion', "Route to be executed when normal route processing completes", 'configuration', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('mode', 'Mode', "Sets the on completion mode. The default value is AfterConsumer", 'string', 'AfterConsumer, BeforeConsumer', 'AfterConsumer', false, false, false, false, 'advanced', ''),
        new PropertyMeta('onCompleteOnly', 'On Complete Only', "Will only synchronize when the org.apache.camel.Exchange completed successfully (no errors).", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('onFailureOnly', 'On Failure Only', "Will only synchronize when the org.apache.camel.Exchange ended with failure (exception or FAULT message).", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('parallelProcessing', 'Parallel Processing', "If enabled then the on completion process will run asynchronously by a separate thread from a thread pool. By default this is false, meaning the on completion process will run synchronously using the same caller thread as from the route.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('executorService', 'Executor Service', "To use a custom Thread Pool to be used for parallel processing. Notice if you set this option, then parallel processing is automatic implied, and you do not have to enable that option as well.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('useOriginalMessage', 'Use Original Message', "Will use the original input message body when an org.apache.camel.Exchange for this on completion. The original input message is defensively copied, and the copied message body is converted to org.apache.camel.StreamCache if possible (stream caching is enabled, can be disabled globally or on the original route), to ensure the body can be read when the original message is being used later. If the body is converted to org.apache.camel.StreamCache then the message body on the current org.apache.camel.Exchange is replaced with the org.apache.camel.StreamCache body. If the body is not converted to org.apache.camel.StreamCache then the body will not be able to re-read when accessed later. Important: The original input means the input message that are bounded by the current org.apache.camel.spi.UnitOfWork . An unit of work typically spans one route, or multiple routes if they are connected using internal endpoints such as direct or seda. When messages is passed via external endpoints such as JMS or HTTP then the consumer will create a new unit of work, with the message it received as input as the original input. Also some EIP patterns such as splitter, multicast, will create a new unit of work boundary for the messages in their sub-route (eg the split message); however these EIPs have an option named shareUnitOfWork which allows to combine with the parent unit of work in regard to error handling and therefore use the parent original message. By default this feature is off.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('onWhen', 'On When', "Sets an additional predicate that should be true before the onCompletion is triggered. To be used for fine grained controlling whether a completion callback should be invoked or not", 'WhenDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
        new ExchangePropertyMeta('CamelOnCompletion', 'On Completion', 'producer', 'boolean', 'Flag to mark that this exchange is currently being executed as onCompletion'),
    ]),
    new ElementMeta('onException', 'OnExceptionDefinition', 'On Exception', "Route to be executed when an exception is thrown", 'error', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('exception', 'Exception', "A set of exceptions to react upon.", 'string', '', '', true, false, true, true, '', ''),
        new PropertyMeta('onWhen', 'On When', "Sets an additional predicate that should be true before the onException is triggered. To be used for fine grained controlling whether a thrown exception should be intercepted by this exception type or not.", 'WhenDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('retryWhile', 'Retry While', "Sets the retry while predicate. Will continue retrying until predicate returns false.", 'ExpressionSubElementDefinition', '', '', false, false, false, true, 'advanced', ''),
        new PropertyMeta('redeliveryPolicy', 'Redelivery Policy', "Used for configuring redelivery options", 'RedeliveryPolicyDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('redeliveryPolicyRef', 'Redelivery Policy Ref', "Sets a reference to a redelivery policy to lookup in the org.apache.camel.spi.Registry to be used.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('handled', 'Handled', "Sets whether the exchange should be marked as handled or not.", 'ExpressionSubElementDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('continued', 'Continued', "Sets whether the exchange should handle and continue routing from the point of failure. If this option is enabled then its considered handled as well.", 'ExpressionSubElementDefinition', '', '', false, false, false, true, 'advanced', ''),
        new PropertyMeta('onRedeliveryRef', 'On Redelivery Ref', "Sets a reference to a processor that should be processed before a redelivery attempt. Can be used to change the org.apache.camel.Exchange before its being redelivered.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('onExceptionOccurredRef', 'On Exception Occurred Ref', "Sets a reference to a processor that should be processed just after an exception occurred. Can be used to perform custom logging about the occurred exception at the exact time it happened. Important: Any exception thrown from this processor will be ignored.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('useOriginalMessage', 'Use Original Message', "Will use the original input org.apache.camel.Message (original body and headers) when an org.apache.camel.Exchange is moved to the dead letter queue. Notice: this only applies when all redeliveries attempt have failed and the org.apache.camel.Exchange is doomed for failure. Instead of using the current inprogress org.apache.camel.Exchange IN message we use the original IN message instead. This allows you to store the original input in the dead letter queue instead of the inprogress snapshot of the IN message. For instance if you route transform the IN body during routing and then failed. With the original exchange store in the dead letter queue it might be easier to manually re submit the org.apache.camel.Exchange again as the IN message is the same as when Camel received it. So you should be able to send the org.apache.camel.Exchange to the same input. The difference between useOriginalMessage and useOriginalBody is that the former includes both the original body and headers, where as the latter only includes the original body. You can use the latter to enrich the message with custom headers and include the original message body. The former wont let you do this, as its using the original message body and headers as they are. You cannot enable both useOriginalMessage and useOriginalBody. The original input message is defensively copied, and the copied message body is converted to org.apache.camel.StreamCache if possible (stream caching is enabled, can be disabled globally or on the original route), to ensure the body can be read when the original message is being used later. If the body is converted to org.apache.camel.StreamCache then the message body on the current org.apache.camel.Exchange is replaced with the org.apache.camel.StreamCache body. If the body is not converted to org.apache.camel.StreamCache then the body will not be able to re-read when accessed later. Important: The original input means the input message that are bounded by the current org.apache.camel.spi.UnitOfWork . An unit of work typically spans one route, or multiple routes if they are connected using internal endpoints such as direct or seda. When messages is passed via external endpoints such as JMS or HTTP then the consumer will create a new unit of work, with the message it received as input as the original input. Also some EIP patterns such as splitter, multicast, will create a new unit of work boundary for the messages in their sub-route (eg the split message); however these EIPs have an option named shareUnitOfWork which allows to combine with the parent unit of work in regard to error handling and therefore use the parent original message. By default this feature is off.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('useOriginalBody', 'Use Original Body', "Will use the original input org.apache.camel.Message body (original body only) when an org.apache.camel.Exchange is moved to the dead letter queue. Notice: this only applies when all redeliveries attempt have failed and the org.apache.camel.Exchange is doomed for failure. Instead of using the current inprogress org.apache.camel.Exchange IN message we use the original IN message instead. This allows you to store the original input in the dead letter queue instead of the inprogress snapshot of the IN message. For instance if you route transform the IN body during routing and then failed. With the original exchange store in the dead letter queue it might be easier to manually re submit the org.apache.camel.Exchange again as the IN message is the same as when Camel received it. So you should be able to send the org.apache.camel.Exchange to the same input. The difference between useOriginalMessage and useOriginalBody is that the former includes both the original body and headers, where as the latter only includes the original body. You can use the latter to enrich the message with custom headers and include the original message body. The former wont let you do this, as its using the original message body and headers as they are. You cannot enable both useOriginalMessage and useOriginalBody. The original input message is defensively copied, and the copied message body is converted to org.apache.camel.StreamCache if possible (stream caching is enabled, can be disabled globally or on the original route), to ensure the body can be read when the original message is being used later. If the body is converted to org.apache.camel.StreamCache then the message body on the current org.apache.camel.Exchange is replaced with the org.apache.camel.StreamCache body. If the body is not converted to org.apache.camel.StreamCache then the body will not be able to re-read when accessed later. Important: The original input means the input message that are bounded by the current org.apache.camel.spi.UnitOfWork . An unit of work typically spans one route, or multiple routes if they are connected using internal endpoints such as direct or seda. When messages is passed via external endpoints such as JMS or HTTP then the consumer will create a new unit of work, with the message it received as input as the original input. Also some EIP patterns such as splitter, multicast, will create a new unit of work boundary for the messages in their sub-route (eg the split message); however these EIPs have an option named shareUnitOfWork which allows to combine with the parent unit of work in regard to error handling and therefore use the parent original message. By default this feature is off.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
        new ExchangePropertyMeta('CamelExceptionCaught', 'Exception Caught', 'producer', 'java.lang.Exception', 'Stores the caught exception due to a processing error of the current Exchange'),
        new ExchangePropertyMeta('CamelFailureEndpoint', 'Failure Endpoint', 'producer', 'String', 'Endpoint URI where the Exchange failed during processing'),
        new ExchangePropertyMeta('CamelFailureRouteId', 'Failure Route Id', 'producer', 'String', 'Route ID where the Exchange failed during processing'),
    ]),
    new ElementMeta('routeConfiguration', 'RouteConfigurationDefinition', 'Route Configuration', "Reusable configuration for Camel route(s).", 'configuration', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('errorHandler', 'Error Handler', "Sets the error handler to use, for routes that has not already been configured with an error handler.", 'ErrorHandlerDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('intercept', 'Intercept', "Adds a route for an interceptor that intercepts every processing step.", 'InterceptDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('interceptFrom', 'Intercept From', "Adds a route for an interceptor that intercepts incoming messages on the given endpoint.", 'InterceptFromDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('interceptSendToEndpoint', 'Intercept Send To Endpoint', "Applies a route for an interceptor if an exchange is send to the given endpoint", 'InterceptSendToEndpointDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('onException', 'On Exception', "Exception clause for catching certain exceptions and handling them.", 'OnExceptionDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('onCompletion', 'On Completion', "On completion callback for doing custom routing when the org.apache.camel.Exchange is complete.", 'OnCompletionDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('precondition', 'Precondition', "The predicate of the precondition in simple language to evaluate in order to determine if this route configuration should be included or not.", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('route', 'RouteDefinition', 'Route', "A Camel route", 'configuration', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('group', 'Group', "The group that this route belongs to; could be the name of the RouteBuilder class or be explicitly configured in the XML. May be null.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('nodePrefixId', 'Node Prefix Id', "Sets a prefix to use for all node ids (not route id).", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('routeConfigurationId', 'Route Configuration Id', "The route configuration id or pattern this route should use for configuration. Multiple id/pattern can be separated by comma.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('autoStartup', 'Auto Startup', "Whether to auto start this route", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('startupOrder', 'Startup Order', "To configure the ordering of the routes being started", 'number', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('streamCache', 'Stream Cache', "Whether stream caching is enabled on this route.", 'boolean', '', '', false, false, false, false, '', ''),
        new PropertyMeta('trace', 'Trace', "Whether tracing is enabled on this route.", 'boolean', '', '', false, false, false, false, '', ''),
        new PropertyMeta('messageHistory', 'Message History', "Whether message history is enabled on this route.", 'boolean', '', '', false, false, false, false, '', ''),
        new PropertyMeta('logMask', 'Log Mask', "Whether security mask for Logging is enabled on this route.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('errorHandlerRef', 'Error Handler', "Sets the bean ref name of the error handler builder to use on this route", 'string', '', '', false, false, false, false, 'error', ''),
        new PropertyMeta('shutdownRoute', 'Shutdown Route', "To control how to shutdown the route.", 'string', 'Default, Defer', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('shutdownRunningTask', 'Shutdown Running Task', "To control how to shut down the route.", 'string', 'CompleteCurrentTaskOnly, CompleteAllTasks', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('precondition', 'Precondition', "The predicate of the precondition in simple language to evaluate in order to determine if this route should be included or not.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('errorHandler', 'Error Handler', "Sets the error handler to use for this route", 'ErrorHandlerDefinition', '', '', false, false, false, true, 'error', ''),
        new PropertyMeta('inputType', 'Input Type', "Declare the expected data type of the input message. If the actual message type is different at runtime, camel look for a required org.apache.camel.spi.Transformer and apply if exists. The type name consists of two parts, 'scheme' and 'name' connected with ':'. For Java type 'name' is a fully qualified class name. For example {code java:java.lang.String} , {code json:ABCOrder} .", 'InputTypeDefinition', '', '', false, false, false, true, 'advanced', ''),
        new PropertyMeta('outputType', 'Output Type', "Declare the expected data type of the output message. If the actual message type is different at runtime, camel look for a required org.apache.camel.spi.Transformer and apply if exists. The type name consists of two parts, 'scheme' and 'name' connected with ':'. For Java type 'name' is a fully qualified class name. For example {code java:java.lang.String} , {code json:ABCOrder} .", 'OutputTypeDefinition', '', '', false, false, false, true, 'advanced', ''),
        new PropertyMeta('from', 'from', "from", 'FromDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('routePolicy', 'routePolicy', "routePolicy", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('routeTemplate', 'RouteTemplateDefinition', 'Route Template', "Defines a route template (parameterized routes)", 'configuration', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('route', 'Route', "To define the route in the template", 'RouteDefinition', '', '', true, false, false, true, '', ''),
        new PropertyMeta('beans', 'beans', "beans", 'BeanFactoryDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('from', 'from', "from", 'FromDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('parameters', 'parameters', "parameters", 'RouteTemplateParameterDefinition', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('templatedRoute', 'TemplatedRouteDefinition', 'Templated Route', "Defines a templated route (a route built from a route template)", 'configuration', [
        new PropertyMeta('routeTemplateRef', 'Route Template Ref', "Sets the id of the route template to use to build the route.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('routeId', 'Route Id', "Sets the id of the route built from the route template.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('prefixId', 'Prefix Id', "Sets a prefix to use for all node ids (not route id).", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('beans', 'beans', "beans", 'BeanFactoryDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('parameters', 'parameters', "parameters", 'TemplatedRouteParameterDefinition', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('restConfiguration', 'RestConfigurationDefinition', 'Rest Configuration', "To configure rest", 'rest', [
        new PropertyMeta('component', 'Component', "The Camel Rest component to use for the REST transport (consumer), such as netty-http, jetty, servlet, undertow. If no component has been explicit configured, then Camel will lookup if there is a Camel component that integrates with the Rest DSL, or if a org.apache.camel.spi.RestConsumerFactory is registered in the registry. If either one is found, then that is being used.", 'string', 'platform-http, servlet, jetty, undertow, netty-http, coap', '', false, false, false, false, '', ''),
        new PropertyMeta('apiComponent', 'Api Component', "The name of the Camel component to use as the REST API. If no API Component has been explicit configured, then Camel will lookup if there is a Camel component responsible for servicing and generating the REST API documentation, or if a org.apache.camel.spi.RestApiProcessorFactory is registered in the registry. If either one is found, then that is being used.", 'string', 'openapi, swagger', '', false, false, false, false, 'consumer,advanced', ''),
        new PropertyMeta('producerComponent', 'Producer Component', "Sets the name of the Camel component to use as the REST producer", 'string', 'vertx-http, http, undertow, netty-http', '', false, false, false, false, 'producer,advanced', ''),
        new PropertyMeta('scheme', 'Scheme', "The scheme to use for exposing the REST service. Usually http or https is supported. The default value is http", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('host', 'Host', "The hostname to use for exposing the REST service.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('port', 'Port', "The port number to use for exposing the REST service. Notice if you use servlet component then the port number configured here does not apply, as the port number in use is the actual port number the servlet component is using. eg if using Apache Tomcat its the tomcat http port, if using Apache Karaf its the HTTP service in Karaf that uses port 8181 by default etc. Though in those situations setting the port number here, allows tooling and JMX to know the port number, so its recommended to set the port number to the number that the servlet engine uses.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('apiHost', 'Api Host', "To use a specific hostname for the API documentation (such as swagger or openapi) This can be used to override the generated host with this configured hostname", 'string', '', '', false, false, false, false, 'consumer,advanced', ''),
        new PropertyMeta('useXForwardHeaders', 'Use XForward Headers', "Whether to use X-Forward headers to set host etc. for OpenApi. This may be needed in special cases involving reverse-proxy and networking going from HTTP to HTTPS etc. Then the proxy can send X-Forward headers (X-Forwarded-Proto) that influences the host names in the OpenAPI schema that camel-openapi-java generates from Rest DSL routes.", 'boolean', '', 'false', false, false, false, false, 'consumer,advanced', ''),
        new PropertyMeta('producerApiDoc', 'Producer Api Doc', "Sets the location of the api document the REST producer will use to validate the REST uri and query parameters are valid accordingly to the api document. The location of the api document is loaded from classpath by default, but you can use file: or http: to refer to resources to load from file or http url.", 'string', '', '', false, false, false, false, 'producer,advanced', ''),
        new PropertyMeta('contextPath', 'Context Path', "Sets a leading context-path the REST services will be using. This can be used when using components such as camel-servlet where the deployed web application is deployed using a context-path. Or for components such as camel-jetty or camel-netty-http that includes a HTTP server.", 'string', '', '', false, false, false, false, 'consumer', ''),
        new PropertyMeta('apiContextPath', 'Api Context Path', "Sets a leading context-path the REST API will be using. This can be used when using components such as camel-servlet where the deployed web application is deployed using a context-path.", 'string', '', '', false, false, false, false, 'consumer', ''),
        new PropertyMeta('apiContextRouteId', 'Api Context Route Id', "Sets the route id to use for the route that services the REST API. The route will by default use an auto assigned route id.", 'string', '', '', false, false, false, false, 'consumer,advanced', ''),
        new PropertyMeta('apiVendorExtension', 'Api Vendor Extension', "Whether vendor extension is enabled in the Rest APIs. If enabled then Camel will include additional information as vendor extension (eg keys starting with x-) such as route ids, class names etc. Not all 3rd party API gateways and tools supports vendor-extensions when importing your API docs.", 'boolean', '', 'false', false, false, false, false, 'consumer,advanced', ''),
        new PropertyMeta('hostNameResolver', 'Host Name Resolver', "If no hostname has been explicit configured, then this resolver is used to compute the hostname the REST service will be using.", 'string', 'allLocalIp, localHostName, localIp', 'allLocalIp', false, false, false, false, 'consumer,advanced', ''),
        new PropertyMeta('bindingMode', 'Binding Mode', "Sets the binding mode to use. The default value is off", 'string', 'off, auto, json, xml, json_xml', 'off', false, false, false, false, '', ''),
        new PropertyMeta('bindingPackageScan', 'Binding Package Scan', "Package name to use as base (offset) for classpath scanning of POJO classes are located when using binding mode is enabled for JSon or XML. Multiple package names can be separated by comma.", 'string', '', '', false, false, false, false, 'consumer,advanced', ''),
        new PropertyMeta('skipBindingOnErrorCode', 'Skip Binding On Error Code', "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('clientRequestValidation', 'Client Request Validation', "Whether to enable validation of the client request to check: 1) Content-Type header matches what the Rest DSL consumes; returns HTTP Status 415 if validation error. 2) Accept header matches what the Rest DSL produces; returns HTTP Status 406 if validation error. 3) Missing required data (query parameters, HTTP headers, body); returns HTTP Status 400 if validation error. 4) Parsing error of the message body (JSon, XML or Auto binding mode must be enabled); returns HTTP Status 400 if validation error.", 'boolean', '', 'false', false, false, false, false, 'consumer,advanced', ''),
        new PropertyMeta('enableCORS', 'Enable CORS', "Whether to enable CORS headers in the HTTP response. The default value is false.", 'boolean', '', 'false', false, false, false, false, 'consumer,advanced', ''),
        new PropertyMeta('enableNoContentResponse', 'Enable No Content Response', "Whether to return HTTP 204 with an empty body when a response contains an empty JSON object or XML root object. The default value is false.", 'boolean', '', 'false', false, false, false, false, 'consumer,advanced', ''),
        new PropertyMeta('inlineRoutes', 'Inline Routes', "Inline routes in rest-dsl which are linked using direct endpoints. Each service in Rest DSL is an individual route, meaning that you would have at least two routes per service (rest-dsl, and the route linked from rest-dsl). By inlining (default) allows Camel to optimize and inline this as a single route, however this requires to use direct endpoints, which must be unique per service. If a route is not using direct endpoint then the rest-dsl is not inlined, and will become an individual route. This option is default true.", 'boolean', '', 'true', false, false, false, false, 'consumer', ''),
        new PropertyMeta('jsonDataFormat', 'Json Data Format', "Name of specific json data format to use. By default jackson will be used. Important: This option is only for setting a custom name of the data format, not to refer to an existing data format instance.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('xmlDataFormat', 'Xml Data Format', "Name of specific XML data format to use. By default jaxb will be used. Important: This option is only for setting a custom name of the data format, not to refer to an existing data format instance.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('componentProperty', 'Component Property', "Allows to configure as many additional properties for the rest component in use.", 'RestPropertyDefinition', '', '', false, false, true, true, 'advanced', ''),
        new PropertyMeta('endpointProperty', 'Endpoint Property', "Allows to configure as many additional properties for the rest endpoint in use.", 'RestPropertyDefinition', '', '', false, false, true, true, 'advanced', ''),
        new PropertyMeta('consumerProperty', 'Consumer Property', "Allows to configure as many additional properties for the rest consumer in use.", 'RestPropertyDefinition', '', '', false, false, true, true, 'consumer,advanced', ''),
        new PropertyMeta('dataFormatProperty', 'Data Format Property', "Allows to configure as many additional properties for the data formats in use. For example set property prettyPrint to true to have json outputted in pretty mode. The properties can be prefixed to denote the option is only for either JSON or XML and for either the IN or the OUT. The prefixes are: json.in. json.out. xml.in. xml.out. For example a key with value xml.out.mustBeJAXBElement is only for the XML data format for the outgoing. A key without a prefix is a common key for all situations.", 'RestPropertyDefinition', '', '', false, false, true, true, 'advanced', ''),
        new PropertyMeta('apiProperty', 'Api Property', "Allows to configure as many additional properties for the api documentation. For example set property api.title to my cool stuff", 'RestPropertyDefinition', '', '', false, false, true, true, 'consumer,advanced', ''),
        new PropertyMeta('corsHeaders', 'Cors Headers', "Allows to configure custom CORS headers.", 'RestPropertyDefinition', '', '', false, false, true, true, 'consumer,advanced', ''),
    ], [
    ]),
    new ElementMeta('rest', 'RestDefinition', 'Rest', "Defines a rest service using the rest-dsl", 'rest', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this REST service from the route during build time. Once an REST service has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('path', 'Path', "Path of the rest service, such as /foo", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('consumes', 'Consumes', "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json. This option will override what may be configured on a parent level", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('produces', 'Produces', "To define the content type what the REST service produces (uses for output), such as application/xml or application/json This option will override what may be configured on a parent level", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('bindingMode', 'Binding Mode', "Sets the binding mode to use. This option will override what may be configured on a parent level The default value is auto", 'string', 'off, auto, json, xml, json_xml', 'off', false, false, false, false, '', ''),
        new PropertyMeta('skipBindingOnErrorCode', 'Skip Binding On Error Code', "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do. This option will override what may be configured on a parent level", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('clientRequestValidation', 'Client Request Validation', "Whether to enable validation of the client request to check: 1) Content-Type header matches what the Rest DSL consumes; returns HTTP Status 415 if validation error. 2) Accept header matches what the Rest DSL produces; returns HTTP Status 406 if validation error. 3) Missing required data (query parameters, HTTP headers, body); returns HTTP Status 400 if validation error. 4) Parsing error of the message body (JSon, XML or Auto binding mode must be enabled); returns HTTP Status 400 if validation error.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableCORS', 'Enable CORS', "Whether to enable CORS headers in the HTTP response. This option will override what may be configured on a parent level The default value is false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableNoContentResponse', 'Enable No Content Response', "Whether to return HTTP 204 with an empty body when a response contains an empty JSON object or XML root object. The default value is false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('apiDocs', 'Api Docs', "Whether to include or exclude this rest operation in API documentation. This option will override what may be configured on a parent level. The default value is true.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('tag', 'Tag', "To configure a special tag for the operations within this rest definition.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('openApi', 'Open Api', "To use an existing OpenAPI specification as contract-first for Camel Rest DSL.", 'OpenApiDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('securityDefinitions', 'Security Definitions', "Sets the security definitions such as Basic, OAuth2 etc.", 'RestSecuritiesDefinition', '', '', false, false, false, true, 'security', ''),
        new PropertyMeta('securityRequirements', 'Security Requirements', "Sets the security requirement(s) for all endpoints.", 'SecurityDefinition', '', '', false, false, true, true, 'security', ''),
        new PropertyMeta('delete', 'delete', "delete", 'DeleteDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('get', 'get', "get", 'GetDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('head', 'head', "head", 'HeadDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('patch', 'patch', "patch", 'PatchDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('post', 'post', "post", 'PostDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('put', 'put', "put", 'PutDefinition', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('beanFactory', 'BeanFactoryDefinition', 'Bean', "Define custom beans that can be used in your Camel routes and in general.", 'configuration', [
        new PropertyMeta('name', 'Name', "The name of the bean (bean id)", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('type', 'Type', "The class name (fully qualified) of the bean", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('initMethod', 'Init Method', "The name of the custom initialization method to invoke after setting bean properties. The method must have no arguments, but may throw any exception.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('destroyMethod', 'Destroy Method', "The name of the custom destroy method to invoke on bean shutdown, such as when Camel is shutting down. The method must have no arguments, but may throw any exception.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('factoryMethod', 'Factory Method', "Name of method to invoke when creating the bean via a factory bean.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('factoryBean', 'Factory Bean', "Name of factory bean (bean id) to use for creating the bean.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('builderClass', 'Builder Class', "Fully qualified class name of builder class to use for creating and configuring the bean. The builder will use the properties values to configure the bean.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('builderMethod', 'Builder Method', "Name of method when using builder class. This method is invoked after configuring to create the actual bean. This method is often named build (used by default).", 'string', '', 'build', false, false, false, false, '', ''),
        new PropertyMeta('scriptLanguage', 'Script Language', "The script language to use when using inlined script for creating the bean, such as groovy, java, javascript etc.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('constructors', 'Constructors', "Optional constructor arguments for creating the bean. Arguments correspond to specific index of the constructor argument list, starting from zero.", 'object', '', '', false, false, false, false, '', ''),
        new PropertyMeta('properties', 'Properties', "Optional properties to set on the created bean.", 'object', '', '', false, false, false, false, '', ''),
        new PropertyMeta('script', 'Script', "The script to execute that creates the bean when using scripting languages. If the script use the prefix resource: such as resource:classpath:com/foo/myscript.groovy, resource:file:/var/myscript.groovy, then its loaded from the external resource.", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('contextScan', 'ContextScanDefinition', 'Context Scan', "Scans for Java org.apache.camel.builder.RouteBuilder instances in the context org.apache.camel.spi.Registry .", 'configuration', [
        new PropertyMeta('includeNonSingletons', 'Include Non Singletons', "Whether to include non-singleton beans (prototypes) By default only singleton beans is included in the context scan", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('excludes', 'Excludes', "Exclude finding route builder from these java package names.", 'string', '', '', false, false, true, true, '', ''),
        new PropertyMeta('includes', 'Includes', "Include finding route builder from these java package names.", 'string', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('errorHandler', 'ErrorHandlerDefinition', 'Error Handler', "Camel error handling.", 'configuration,error', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('deadLetterChannel', 'deadLetterChannel', "deadLetterChannel", 'DeadLetterChannelDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('defaultErrorHandler', 'defaultErrorHandler', "defaultErrorHandler", 'DefaultErrorHandlerDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('jtaTransactionErrorHandler', 'jtaTransactionErrorHandler', "jtaTransactionErrorHandler", 'JtaTransactionErrorHandlerDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('noErrorHandler', 'noErrorHandler', "noErrorHandler", 'NoErrorHandlerDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('refErrorHandler', 'refErrorHandler', "refErrorHandler", 'RefErrorHandlerDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('springTransactionErrorHandler', 'springTransactionErrorHandler', "springTransactionErrorHandler", 'SpringTransactionErrorHandlerDefinition', '', '', false, false, false, true, '', ''),
    ], [
        new ExchangePropertyMeta('CamelExceptionCaught', 'Exception Caught', 'producer', 'java.lang.Exception', 'Stores the caught exception due to a processing error of the current Exchange'),
        new ExchangePropertyMeta('CamelFailureEndpoint', 'Failure Endpoint', 'producer', 'String', 'Endpoint URI where the Exchange failed during processing'),
        new ExchangePropertyMeta('CamelFailureRouteId', 'Failure Route Id', 'producer', 'String', 'Route ID where the Exchange failed during processing'),
    ]),
    new ElementMeta('faultToleranceConfiguration', 'FaultToleranceConfigurationDefinition', 'Fault Tolerance Configuration', "MicroProfile Fault Tolerance Circuit Breaker EIP configuration", 'configuration,eip', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('circuitBreaker', 'Circuit Breaker', "Refers to an existing io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker instance to lookup and use from the registry. When using this, then any other circuit breaker options are not in use.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('delay', 'Delay', "Control how long the circuit breaker stays open. The default is 5 seconds.", 'string', '', '5000', false, false, false, false, '', ''),
        new PropertyMeta('successThreshold', 'Success Threshold', "Controls the number of trial calls which are allowed when the circuit breaker is half-open", 'number', '', '1', false, false, false, false, '', ''),
        new PropertyMeta('requestVolumeThreshold', 'Request Volume Threshold', "Controls the size of the rolling window used when the circuit breaker is closed", 'number', '', '20', false, false, false, false, '', ''),
        new PropertyMeta('failureRatio', 'Failure Ratio', "Configures the failure rate threshold in percentage. If the failure rate is equal or greater than the threshold the CircuitBreaker transitions to open and starts short-circuiting calls. The threshold must be greater than 0 and not greater than 100. Default value is 50 percentage.", 'number', '', '50', false, false, false, false, '', ''),
        new PropertyMeta('timeoutEnabled', 'Timeout Enabled', "Whether timeout is enabled or not on the circuit breaker. Default is false.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('timeoutDuration', 'Timeout Duration', "Configures the thread execution timeout. Default value is 1 second.", 'string', '', '1000', false, false, false, false, '', ''),
        new PropertyMeta('timeoutPoolSize', 'Timeout Pool Size', "Configures the pool size of the thread pool when timeout is enabled. Default value is 10.", 'number', '', '10', false, false, false, false, 'advanced', ''),
        new PropertyMeta('timeoutScheduledExecutorService', 'Timeout Scheduled Executor Service', "References to a custom thread pool to use when timeout is enabled", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('bulkheadEnabled', 'Bulkhead Enabled', "Whether bulkhead is enabled or not on the circuit breaker. Default is false.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('bulkheadMaxConcurrentCalls', 'Bulkhead Max Concurrent Calls', "Configures the max amount of concurrent calls the bulkhead will support.", 'number', '', '10', false, false, false, false, 'advanced', ''),
        new PropertyMeta('bulkheadWaitingTaskQueue', 'Bulkhead Waiting Task Queue', "Configures the task queue size for holding waiting tasks to be processed by the bulkhead.", 'number', '', '10', false, false, false, false, 'advanced', ''),
        new PropertyMeta('bulkheadExecutorService', 'Bulkhead Executor Service', "References to a custom thread pool to use when bulkhead is enabled.", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('from', 'FromDefinition', 'From', "Act as a message source as input to a route", 'eip,routing', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('uri', 'Uri', "Sets the URI of the endpoint to use", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('variableReceive', 'Variable Receive', "To use a variable to store a copy of the received message body (only body, not headers). This is handy for easy access to the received message body via variables.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('parameters', 'parameters', "parameters", 'object', '', '', false, false, false, false, '', ''),
        new PropertyMeta('steps', 'steps', "steps", 'CamelElement', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('globalOption', 'GlobalOptionDefinition', 'Global Option', "Models a string key/value pair for configuring some global options on a Camel context such as max debug log length.", 'configuration', [
        new PropertyMeta('key', 'Key', "Global option key", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('value', 'Value', "Global option value", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('globalOptions', 'GlobalOptionsDefinition', 'Global Options', "Models a series of string key/value pairs for configuring some global options on a Camel context such as max debug log length.", 'configuration', [
        new PropertyMeta('globalOption', 'Global Option', "A series of global options as key value pairs", 'GlobalOptionDefinition', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('inputType', 'InputTypeDefinition', 'Input Type', "Set the expected data type of the input message. If the actual message type is different at runtime, camel look for a required Transformer and apply if exists. If validate attribute is true then camel applies Validator as well. Type name consists of two parts, 'scheme' and 'name' connected with ':'. For Java type 'name' is a fully qualified class name. For example {code java:java.lang.String} , {code json:ABCOrder} . It's also possible to specify only scheme part, so that it works like a wildcard. If only 'xml' is specified, all the XML message matches. It's handy to add only one transformer/validator for all the transformation from/to XML.", 'configuration', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('urn', 'Urn', "The input type URN.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('validate', 'Validate', "Whether if validation is required for this input type.", 'boolean', '', 'false', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('optimisticLockRetryPolicy', 'OptimisticLockRetryPolicyDefinition', 'Optimistic Lock Retry Policy', "To configure optimistic locking", 'configuration', [
        new PropertyMeta('maximumRetries', 'Maximum Retries', "Sets the maximum number of retries", 'number', '', '', false, false, false, false, '', ''),
        new PropertyMeta('retryDelay', 'Retry Delay', "Sets the delay in millis between retries", 'string', '', '50', false, false, false, false, '', ''),
        new PropertyMeta('maximumRetryDelay', 'Maximum Retry Delay', "Sets the upper value of retry in millis between retries, when using exponential or random backoff", 'string', '', '1000', false, false, false, false, '', ''),
        new PropertyMeta('exponentialBackOff', 'Exponential Back Off', "Enable exponential backoff", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('randomBackOff', 'Random Back Off', "Enables random backoff", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('outputType', 'OutputTypeDefinition', 'Output Type', "Set the expected data type of the output message. If the actual message type is different at runtime, camel look for a required Transformer and apply if exists. If validate attribute is true then camel applies Validator as well. Type name consists of two parts, 'scheme' and 'name' connected with ':'. For Java type 'name' is a fully qualified class name. For example {code java:java.lang.String} , {code json:ABCOrder} . It's also possible to specify only scheme part, so that it works like a wildcard. If only 'xml' is specified, all the XML message matches. It's handy to add only one transformer/validator for all the XML-Java transformation.", 'configuration', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('urn', 'Urn', "Set output type URN.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('validate', 'Validate', "Whether if validation is required for this output type.", 'boolean', '', 'false', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('packageScan', 'PackageScanDefinition', 'Package Scan', "Scans for Java org.apache.camel.builder.RouteBuilder classes in java packages", 'configuration', [
        new PropertyMeta('package', 'Package', "Sets the java package names to use for scanning for route builder classes", 'string', '', '', true, false, true, true, '', ''),
        new PropertyMeta('excludes', 'Excludes', "Exclude finding route builder from these java package names.", 'string', '', '', false, false, true, true, 'advanced', ''),
        new PropertyMeta('includes', 'Includes', "Include finding route builder from these java package names.", 'string', '', '', false, false, true, true, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('property', 'PropertyDefinition', 'Property', "A key value pair where the value is a literal value", 'configuration', [
        new PropertyMeta('key', 'Key', "The name of the property", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('value', 'Value', "The property value.", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('propertyExpression', 'PropertyExpressionDefinition', 'Property Expression', "A key value pair where the value is an expression.", 'configuration', [
        new PropertyMeta('key', 'Key', "Property key", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('expression', 'Expression', "Property values as an expression", 'ExpressionDefinition', '', '', true, false, false, true, '', ''),
    ], [
    ]),
    new ElementMeta('redeliveryPolicy', 'RedeliveryPolicyDefinition', 'Redelivery Policy', "To configure re-delivery for error handling", 'configuration', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('maximumRedeliveries', 'Maximum Redeliveries', "Sets the maximum redeliveries x = redeliver at most x times 0 = no redeliveries -1 = redeliver forever", 'number', '', '', false, false, false, false, '', ''),
        new PropertyMeta('redeliveryDelay', 'Redelivery Delay', "Sets the initial redelivery delay", 'string', '', '1000', false, false, false, false, '', ''),
        new PropertyMeta('asyncDelayedRedelivery', 'Async Delayed Redelivery', "Allow asynchronous delayed redelivery. The route, in particular the consumer's component, must support the Asynchronous Routing Engine (e.g. seda).", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('backOffMultiplier', 'Back Off Multiplier', "Sets the back off multiplier", 'number', '', '2.0', false, false, false, false, '', ''),
        new PropertyMeta('useExponentialBackOff', 'Use Exponential Back Off', "Turn on exponential back off", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('collisionAvoidanceFactor', 'Collision Avoidance Factor', "Sets the collision avoidance factor", 'number', '', '0.15', false, false, false, false, 'advanced', ''),
        new PropertyMeta('useCollisionAvoidance', 'Use Collision Avoidance', "Turn on collision avoidance.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('maximumRedeliveryDelay', 'Maximum Redelivery Delay', "Sets the maximum delay between redelivery", 'string', '', '60000', false, false, false, false, '', ''),
        new PropertyMeta('retriesExhaustedLogLevel', 'Retries Exhausted Log Level', "Sets the logging level to use when retries have been exhausted", 'string', 'TRACE, DEBUG, INFO, WARN, ERROR, OFF', 'ERROR', false, false, false, false, 'advanced', ''),
        new PropertyMeta('retryAttemptedLogLevel', 'Retry Attempted Log Level', "Sets the logging level to use for logging retry attempts", 'string', 'TRACE, DEBUG, INFO, WARN, ERROR, OFF', 'DEBUG', false, false, false, false, '', ''),
        new PropertyMeta('retryAttemptedLogInterval', 'Retry Attempted Log Interval', "Sets the interval to use for logging retry attempts", 'number', '', '1', false, false, false, false, 'advanced', ''),
        new PropertyMeta('logRetryAttempted', 'Log Retry Attempted', "Sets whether retry attempts should be logged or not. Can be used to include or reduce verbose.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('logStackTrace', 'Log Stack Trace', "Sets whether stack traces should be logged. Can be used to include or reduce verbose.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('logRetryStackTrace', 'Log Retry Stack Trace', "Sets whether stack traces should be logged when an retry attempt failed. Can be used to include or reduce verbose.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('logHandled', 'Log Handled', "Sets whether handled exceptions should be logged or not. Can be used to include or reduce verbose.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('logNewException', 'Log New Exception', "Sets whether new exceptions should be logged or not. Can be used to include or reduce verbose. A new exception is an exception that was thrown while handling a previous exception.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('logContinued', 'Log Continued', "Sets whether continued exceptions should be logged or not. Can be used to include or reduce verbose.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('logExhausted', 'Log Exhausted', "Sets whether exhausted exceptions should be logged or not. Can be used to include or reduce verbose.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('logExhaustedMessageHistory', 'Log Exhausted Message History', "Sets whether exhausted exceptions should be logged including message history or not (supports property placeholders). Can be used to include or reduce verbose.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('logExhaustedMessageBody', 'Log Exhausted Message Body', "Sets whether exhausted message body should be logged including message history or not (supports property placeholders). Can be used to include or reduce verbose. Requires logExhaustedMessageHistory to be enabled.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('disableRedelivery', 'Disable Redelivery', "Disables redelivery (same as setting maximum redeliveries to 0)", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('delayPattern', 'Delay Pattern', "Sets the delay pattern with delay intervals.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('allowRedeliveryWhileStopping', 'Allow Redelivery While Stopping', "Controls whether to allow redelivery while stopping/shutting down a route that uses error handling.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('exchangeFormatterRef', 'Exchange Formatter Ref', "Sets the reference of the instance of org.apache.camel.spi.ExchangeFormatter to generate the log message from exchange.", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('resilience4jConfiguration', 'Resilience4jConfigurationDefinition', 'Resilience4j Configuration', "Resilience4j Circuit Breaker EIP configuration", 'configuration,eip', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('circuitBreaker', 'Circuit Breaker', "Refers to an existing io.github.resilience4j.circuitbreaker.CircuitBreaker instance to lookup and use from the registry. When using this, then any other circuit breaker options are not in use.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('config', 'Config', "Refers to an existing io.github.resilience4j.circuitbreaker.CircuitBreakerConfig instance to lookup and use from the registry.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('failureRateThreshold', 'Failure Rate Threshold', "Configures the failure rate threshold in percentage. If the failure rate is equal or greater than the threshold the CircuitBreaker transitions to open and starts short-circuiting calls. The threshold must be greater than 0 and not greater than 100. Default value is 50 percentage.", 'number', '', '50', false, false, false, false, '', ''),
        new PropertyMeta('permittedNumberOfCallsInHalfOpenState', 'Permitted Number Of Calls In Half Open State', "Configures the number of permitted calls when the CircuitBreaker is half open. The size must be greater than 0. Default size is 10.", 'number', '', '10', false, false, false, false, 'advanced', ''),
        new PropertyMeta('throwExceptionWhenHalfOpenOrOpenState', 'Throw Exception When Half Open Or Open State', "Whether to throw io.github.resilience4j.circuitbreaker.CallNotPermittedException when the call is rejected due circuit breaker is half open or open.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('slidingWindowSize', 'Sliding Window Size', "Configures the size of the sliding window which is used to record the outcome of calls when the CircuitBreaker is closed. slidingWindowSize configures the size of the sliding window. Sliding window can either be count-based or time-based. If slidingWindowType is COUNT_BASED, the last slidingWindowSize calls are recorded and aggregated. If slidingWindowType is TIME_BASED, the calls of the last slidingWindowSize seconds are recorded and aggregated. The slidingWindowSize must be greater than 0. The minimumNumberOfCalls must be greater than 0. If the slidingWindowType is COUNT_BASED, the minimumNumberOfCalls cannot be greater than slidingWindowSize . If the slidingWindowType is TIME_BASED, you can pick whatever you want. Default slidingWindowSize is 100.", 'number', '', '100', false, false, false, false, '', ''),
        new PropertyMeta('slidingWindowType', 'Sliding Window Type', "Configures the type of the sliding window which is used to record the outcome of calls when the CircuitBreaker is closed. Sliding window can either be count-based or time-based. If slidingWindowType is COUNT_BASED, the last slidingWindowSize calls are recorded and aggregated. If slidingWindowType is TIME_BASED, the calls of the last slidingWindowSize seconds are recorded and aggregated. Default slidingWindowType is COUNT_BASED.", 'string', 'TIME_BASED, COUNT_BASED', 'COUNT_BASED', false, false, false, false, 'advanced', ''),
        new PropertyMeta('minimumNumberOfCalls', 'Minimum Number Of Calls', "Configures the minimum number of calls which are required (per sliding window period) before the CircuitBreaker can calculate the error rate. For example, if minimumNumberOfCalls is 10, then at least 10 calls must be recorded, before the failure rate can be calculated. If only 9 calls have been recorded the CircuitBreaker will not transition to open even if all 9 calls have failed. Default minimumNumberOfCalls is 100", 'number', '', '100', false, false, false, false, '', ''),
        new PropertyMeta('writableStackTraceEnabled', 'Writable Stack Trace Enabled', "Enables writable stack traces. When set to false, Exception.getStackTrace returns a zero length array. This may be used to reduce log spam when the circuit breaker is open as the cause of the exceptions is already known (the circuit breaker is short-circuiting calls).", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('waitDurationInOpenState', 'Wait Duration In Open State', "Configures the wait duration (in seconds) which specifies how long the CircuitBreaker should stay open, before it switches to half open. Default value is 60 seconds.", 'number', '', '60', false, false, false, false, 'advanced', ''),
        new PropertyMeta('automaticTransitionFromOpenToHalfOpenEnabled', 'Automatic Transition From Open To Half Open Enabled', "Enables automatic transition from OPEN to HALF_OPEN state once the waitDurationInOpenState has passed.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('slowCallRateThreshold', 'Slow Call Rate Threshold', "Configures a threshold in percentage. The CircuitBreaker considers a call as slow when the call duration is greater than slowCallDurationThreshold Duration. When the percentage of slow calls is equal or greater the threshold, the CircuitBreaker transitions to open and starts short-circuiting calls. The threshold must be greater than 0 and not greater than 100. Default value is 100 percentage which means that all recorded calls must be slower than slowCallDurationThreshold.", 'number', '', '100', false, false, false, false, 'advanced', ''),
        new PropertyMeta('slowCallDurationThreshold', 'Slow Call Duration Threshold', "Configures the duration threshold (seconds) above which calls are considered as slow and increase the slow calls percentage. Default value is 60 seconds.", 'number', '', '60', false, false, false, false, 'advanced', ''),
        new PropertyMeta('bulkheadEnabled', 'Bulkhead Enabled', "Whether bulkhead is enabled or not on the circuit breaker. Default is false.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('bulkheadMaxConcurrentCalls', 'Bulkhead Max Concurrent Calls', "Configures the max amount of concurrent calls the bulkhead will support.", 'number', '', '25', false, false, false, false, '', ''),
        new PropertyMeta('bulkheadMaxWaitDuration', 'Bulkhead Max Wait Duration', "Configures a maximum amount of time which the calling thread will wait to enter the bulkhead. If bulkhead has space available, entry is guaranteed and immediate. If bulkhead is full, calling threads will contest for space, if it becomes available. maxWaitDuration can be set to 0. Note: for threads running on an event-loop or equivalent (rx computation pool, etc), setting maxWaitDuration to 0 is highly recommended. Blocking an event-loop thread will most likely have a negative effect on application throughput.", 'number', '', '0', false, false, false, false, 'advanced', ''),
        new PropertyMeta('timeoutEnabled', 'Timeout Enabled', "Whether timeout is enabled or not on the circuit breaker. Default is false.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('timeoutExecutorService', 'Timeout Executor Service', "References to a custom thread pool to use when timeout is enabled (uses ForkJoinPool#commonPool() by default)", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('timeoutDuration', 'Timeout Duration', "Configures the thread execution timeout. Default value is 1 second.", 'number', '', '1000', false, false, false, false, '', ''),
        new PropertyMeta('timeoutCancelRunningFuture', 'Timeout Cancel Running Future', "Configures whether cancel is called on the running future. Defaults to true.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('recordException', 'Record Exception', "Configure a list of exceptions that are recorded as a failure and thus increase the failure rate. Any exception matching or inheriting from one of the list counts as a failure, unless explicitly ignored via ignoreExceptions.", 'string', '', '', false, false, true, true, 'advanced', ''),
        new PropertyMeta('ignoreException', 'Ignore Exception', "Configure a list of exceptions that are ignored and neither count as a failure nor success. Any exception matching or inheriting from one of the list will not count as a failure nor success, even if the exceptions is part of recordExceptions.", 'string', '', '', false, false, true, true, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('restContextRef', 'RestContextRefDefinition', 'Rest Context Ref', "To refer to an XML file with rest services defined using the rest-dsl", 'configuration,rest', [
        new PropertyMeta('ref', 'Ref', "Reference to the rest-dsl", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('routeBuilder', 'RouteBuilderDefinition', 'Route Builder', "To refer to a Java org.apache.camel.builder.RouteBuilder instance to use.", 'configuration', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('ref', 'Ref', "Reference to the route builder instance", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('routeConfigurationContextRef', 'RouteConfigurationContextRefDefinition', 'Route Configuration Context Ref', "To refer to an XML file with route configuration defined using the xml-dsl", 'configuration', [
        new PropertyMeta('ref', 'Ref', "Reference to the route templates in the xml dsl", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('routeContextRef', 'RouteContextRefDefinition', 'Route Context Ref', "To refer to an XML file with routes defined using the xml-dsl", 'configuration', [
        new PropertyMeta('ref', 'Ref', "Reference to the routes in the xml dsl", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('templatedRouteParameter', 'TemplatedRouteParameterDefinition', 'Templated Route Parameter', "An input parameter of a route template.", 'configuration', [
        new PropertyMeta('name', 'Name', "The name of the parameter", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('value', 'Value', "The value of the parameter.", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('threadPoolProfile', 'ThreadPoolProfileDefinition', 'Thread Pool Profile', "To configure thread pools", 'configuration', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('defaultProfile', 'Default Profile', "Whether this profile is the default thread pool profile", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('poolSize', 'Pool Size', "Sets the core pool size", 'number', '', '', false, false, false, false, '', ''),
        new PropertyMeta('maxPoolSize', 'Max Pool Size', "Sets the maximum pool size", 'number', '', '', false, false, false, false, '', ''),
        new PropertyMeta('keepAliveTime', 'Keep Alive Time', "Sets the keep alive time for idle threads in the pool", 'number', '', '', false, false, false, false, '', ''),
        new PropertyMeta('timeUnit', 'Time Unit', "Sets the time unit to use for keep alive time By default SECONDS is used.", 'string', 'NANOSECONDS, MICROSECONDS, MILLISECONDS, SECONDS, MINUTES, HOURS, DAYS', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('maxQueueSize', 'Max Queue Size', "Sets the maximum number of tasks in the work queue. Use -1 or Integer.MAX_VALUE for an unbounded queue", 'number', '', '', false, false, false, false, '', ''),
        new PropertyMeta('allowCoreThreadTimeOut', 'Allow Core Thread Time Out', "Whether idle core threads is allowed to timeout and therefore can shrink the pool size below the core pool size Is by default true", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('rejectedPolicy', 'Rejected Policy', "Sets the handler for tasks which cannot be executed by the thread pool.", 'string', 'Abort, CallerRuns', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('value', 'ValueDefinition', 'Value', "A single value", 'configuration', [
        new PropertyMeta('value', 'Value', "Property value", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('batchConfig', 'BatchResequencerConfig', 'Batch Config', "Configures batch-processing resequence eip.", 'configuration,eip', [
        new PropertyMeta('batchSize', 'Batch Size', "Sets the size of the batch to be re-ordered. The default size is 100.", 'number', '', '100', false, false, false, false, '', ''),
        new PropertyMeta('batchTimeout', 'Batch Timeout', "Sets the timeout for collecting elements to be re-ordered. The default timeout is 1000 msec.", 'string', '', '1000', false, false, false, false, '', ''),
        new PropertyMeta('allowDuplicates', 'Allow Duplicates', "Whether to allow duplicates.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('reverse', 'Reverse', "Whether to reverse the ordering.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('ignoreInvalidExchanges', 'Ignore Invalid Exchanges', "Whether to ignore invalid exchanges", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('streamConfig', 'StreamResequencerConfig', 'Stream Config', "Configures stream-processing resequence eip.", 'configuration,eip', [
        new PropertyMeta('capacity', 'Capacity', "Sets the capacity of the resequencer inbound queue.", 'number', '', '1000', false, false, false, false, '', ''),
        new PropertyMeta('timeout', 'Timeout', "Sets minimum time (milliseconds) to wait for missing elements (messages).", 'string', '', '1000', false, false, false, false, '', ''),
        new PropertyMeta('deliveryAttemptInterval', 'Delivery Attempt Interval', "Sets the interval in milliseconds the stream resequencer will at most wait while waiting for condition of being able to deliver.", 'string', '', '1000', false, false, false, false, 'advanced', ''),
        new PropertyMeta('ignoreInvalidExchanges', 'Ignore Invalid Exchanges', "Whether to ignore invalid exchanges", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('rejectOld', 'Reject Old', "If true, throws an exception when messages older than the last delivered message are processed", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('comparator', 'Comparator', "To use a custom comparator as a org.apache.camel.processor.resequencer.ExpressionResultComparator type.", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('dataFormats', 'DataFormatsDefinition', 'Data formats', "Configure data formats.", 'dataformat,transformation', [
        new PropertyMeta('asn1', 'asn1', "asn1", 'ASN1DataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('avro', 'avro', "avro", 'AvroDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('barcode', 'barcode', "barcode", 'BarcodeDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('base64', 'base64', "base64", 'Base64DataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('beanio', 'beanio', "beanio", 'BeanioDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('bindy', 'bindy', "bindy", 'BindyDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('cbor', 'cbor', "cbor", 'CBORDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('crypto', 'crypto', "crypto", 'CryptoDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('csv', 'csv', "csv", 'CsvDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('custom', 'custom', "custom", 'CustomDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('fhirJson', 'fhirJson', "fhirJson", 'FhirJsonDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('fhirXml', 'fhirXml', "fhirXml", 'FhirXmlDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('flatpack', 'flatpack', "flatpack", 'FlatpackDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('grok', 'grok', "grok", 'GrokDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('gzipDeflater', 'gzipDeflater', "gzipDeflater", 'GzipDeflaterDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('hl7', 'hl7', "hl7", 'HL7DataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('ical', 'ical', "ical", 'IcalDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('jacksonXml', 'jacksonXml', "jacksonXml", 'JacksonXMLDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('jaxb', 'jaxb', "jaxb", 'JaxbDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('json', 'json', "json", 'JsonDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('jsonApi', 'jsonApi', "jsonApi", 'JsonApiDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('lzf', 'lzf', "lzf", 'LZFDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('mimeMultipart', 'mimeMultipart', "mimeMultipart", 'MimeMultipartDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('parquetAvro', 'parquetAvro', "parquetAvro", 'ParquetAvroDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('pgp', 'pgp', "pgp", 'PGPDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('protobuf', 'protobuf', "protobuf", 'ProtobufDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('rss', 'rss', "rss", 'RssDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('soap', 'soap', "soap", 'SoapDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('swiftMt', 'swiftMt', "swiftMt", 'SwiftMtDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('swiftMx', 'swiftMx', "swiftMx", 'SwiftMxDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('syslog', 'syslog', "syslog", 'SyslogDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('tarFile', 'tarFile', "tarFile", 'TarFileDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('thrift', 'thrift', "thrift", 'ThriftDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('tidyMarkup', 'tidyMarkup', "tidyMarkup", 'TidyMarkupDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('univocityCsv', 'univocityCsv', "univocityCsv", 'UniVocityCsvDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('univocityFixed', 'univocityFixed', "univocityFixed", 'UniVocityFixedDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('univocityTsv', 'univocityTsv', "univocityTsv", 'UniVocityTsvDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('xmlSecurity', 'xmlSecurity', "xmlSecurity", 'XMLSecurityDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('yaml', 'yaml', "yaml", 'YAMLDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('zipDeflater', 'zipDeflater', "zipDeflater", 'ZipDeflaterDataFormat', '', '', false, false, false, true, '', ''),
        new PropertyMeta('zipFile', 'zipFile', "zipFile", 'ZipFileDataFormat', '', '', false, false, false, true, '', ''),
    ], [
    ]),
    new ElementMeta('deadLetterChannel', 'DeadLetterChannelDefinition', 'Dead Letter Channel', "Error handler with dead letter queue.", 'configuration,error', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('deadLetterUri', 'Dead Letter Uri', "The dead letter endpoint uri for the Dead Letter error handler.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('deadLetterHandleNewException', 'Dead Letter Handle New Exception', "Whether the dead letter channel should handle (and ignore) any new exception that may been thrown during sending the message to the dead letter endpoint. The default value is true which means any such kind of exception is handled and ignored. Set this to false to let the exception be propagated back on the org.apache.camel.Exchange . This can be used in situations where you use transactions, and want to use Camel's dead letter channel to deal with exceptions during routing, but if the dead letter channel itself fails because of a new exception being thrown, then by setting this to false the new exceptions is propagated back and set on the org.apache.camel.Exchange , which allows the transaction to detect the exception, and rollback.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('redeliveryPolicy', 'Redelivery Policy', "Sets the redelivery settings", 'RedeliveryPolicyDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('useOriginalMessage', 'Use Original Message', "Will use the original input org.apache.camel.Message (original body and headers) when an org.apache.camel.Exchange is moved to the dead letter queue. Notice: this only applies when all redeliveries attempt have failed and the org.apache.camel.Exchange is doomed for failure. Instead of using the current inprogress org.apache.camel.Exchange IN message we use the original IN message instead. This allows you to store the original input in the dead letter queue instead of the inprogress snapshot of the IN message. For instance if you route transform the IN body during routing and then failed. With the original exchange store in the dead letter queue it might be easier to manually re submit the org.apache.camel.Exchange again as the IN message is the same as when Camel received it. So you should be able to send the org.apache.camel.Exchange to the same input. The difference between useOriginalMessage and useOriginalBody is that the former includes both the original body and headers, where as the latter only includes the original body. You can use the latter to enrich the message with custom headers and include the original message body. The former wont let you do this, as its using the original message body and headers as they are. You cannot enable both useOriginalMessage and useOriginalBody. The original input message is defensively copied, and the copied message body is converted to org.apache.camel.StreamCache if possible (stream caching is enabled, can be disabled globally or on the original route), to ensure the body can be read when the original message is being used later. If the body is converted to org.apache.camel.StreamCache then the message body on the current org.apache.camel.Exchange is replaced with the org.apache.camel.StreamCache body. If the body is not converted to org.apache.camel.StreamCache then the body will not be able to re-read when accessed later. Important: The original input means the input message that are bounded by the current org.apache.camel.spi.UnitOfWork . An unit of work typically spans one route, or multiple routes if they are connected using internal endpoints such as direct or seda. When messages is passed via external endpoints such as JMS or HTTP then the consumer will create a new unit of work, with the message it received as input as the original input. Also some EIP patterns such as splitter, multicast, will create a new unit of work boundary for the messages in their sub-route (eg the splitted message); however these EIPs have an option named shareUnitOfWork which allows to combine with the parent unit of work in regard to error handling and therefore use the parent original message. By default this feature is off.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('useOriginalBody', 'Use Original Body', "Will use the original input org.apache.camel.Message body (original body only) when an org.apache.camel.Exchange is moved to the dead letter queue. Notice: this only applies when all redeliveries attempt have failed and the org.apache.camel.Exchange is doomed for failure. Instead of using the current inprogress org.apache.camel.Exchange IN message we use the original IN message instead. This allows you to store the original input in the dead letter queue instead of the inprogress snapshot of the IN message. For instance if you route transform the IN body during routing and then failed. With the original exchange store in the dead letter queue it might be easier to manually re submit the org.apache.camel.Exchange again as the IN message is the same as when Camel received it. So you should be able to send the org.apache.camel.Exchange to the same input. The difference between useOriginalMessage and useOriginalBody is that the former includes both the original body and headers, where as the latter only includes the original body. You can use the latter to enrich the message with custom headers and include the original message body. The former wont let you do this, as its using the original message body and headers as they are. You cannot enable both useOriginalMessage and useOriginalBody. The original input message is defensively copied, and the copied message body is converted to org.apache.camel.StreamCache if possible (stream caching is enabled, can be disabled globally or on the original route), to ensure the body can be read when the original message is being used later. If the body is converted to org.apache.camel.StreamCache then the message body on the current org.apache.camel.Exchange is replaced with the org.apache.camel.StreamCache body. If the body is not converted to org.apache.camel.StreamCache then the body will not be able to re-read when accessed later. Important: The original input means the input message that are bounded by the current org.apache.camel.spi.UnitOfWork . An unit of work typically spans one route, or multiple routes if they are connected using internal endpoints such as direct or seda. When messages is passed via external endpoints such as JMS or HTTP then the consumer will create a new unit of work, with the message it received as input as the original input. Also some EIP patterns such as splitter, multicast, will create a new unit of work boundary for the messages in their sub-route (eg the splitted message); however these EIPs have an option named shareUnitOfWork which allows to combine with the parent unit of work in regard to error handling and therefore use the parent original message. By default this feature is off.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('redeliveryPolicyRef', 'Redelivery Policy Ref', "Sets a reference to a RedeliveryPolicy to be used for redelivery settings.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('loggerRef', 'Logger Ref', "References to a logger to use as logger for the error handler", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('level', 'Level', "Logging level to use by error handler", 'string', 'TRACE, DEBUG, INFO, WARN, ERROR, OFF', 'ERROR', false, false, false, false, 'advanced', ''),
        new PropertyMeta('logName', 'Log Name', "Name of the logger to use by the error handler", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('onRedeliveryRef', 'On Redelivery Ref', "Sets a reference to a processor that should be processed before a redelivery attempt. Can be used to change the org.apache.camel.Exchange before its being redelivered.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('onExceptionOccurredRef', 'On Exception Occurred Ref', "Sets a reference to a processor that should be processed just after an exception occurred. Can be used to perform custom logging about the occurred exception at the exact time it happened. Important: Any exception thrown from this processor will be ignored.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('onPrepareFailureRef', 'On Prepare Failure Ref', "Sets a reference to a processor to prepare the org.apache.camel.Exchange before handled by the failure processor / dead letter channel. This allows for example to enrich the message before sending to a dead letter queue.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('retryWhileRef', 'Retry While Ref', "Sets a retry while predicate. Will continue retrying until the predicate evaluates to false.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('executorServiceRef', 'Executor Service Ref', "Sets a reference to a thread pool to be used by the error handler", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('defaultErrorHandler', 'DefaultErrorHandlerDefinition', 'Default Error Handler', "The default error handler.", 'configuration,error', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('redeliveryPolicy', 'Redelivery Policy', "Sets the redelivery settings", 'RedeliveryPolicyDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('useOriginalMessage', 'Use Original Message', "Will use the original input org.apache.camel.Message (original body and headers) when an org.apache.camel.Exchange is moved to the dead letter queue. Notice: this only applies when all redeliveries attempt have failed and the org.apache.camel.Exchange is doomed for failure. Instead of using the current inprogress org.apache.camel.Exchange IN message we use the original IN message instead. This allows you to store the original input in the dead letter queue instead of the inprogress snapshot of the IN message. For instance if you route transform the IN body during routing and then failed. With the original exchange store in the dead letter queue it might be easier to manually re submit the org.apache.camel.Exchange again as the IN message is the same as when Camel received it. So you should be able to send the org.apache.camel.Exchange to the same input. The difference between useOriginalMessage and useOriginalBody is that the former includes both the original body and headers, where as the latter only includes the original body. You can use the latter to enrich the message with custom headers and include the original message body. The former wont let you do this, as its using the original message body and headers as they are. You cannot enable both useOriginalMessage and useOriginalBody. The original input message is defensively copied, and the copied message body is converted to org.apache.camel.StreamCache if possible (stream caching is enabled, can be disabled globally or on the original route), to ensure the body can be read when the original message is being used later. If the body is converted to org.apache.camel.StreamCache then the message body on the current org.apache.camel.Exchange is replaced with the org.apache.camel.StreamCache body. If the body is not converted to org.apache.camel.StreamCache then the body will not be able to re-read when accessed later. Important: The original input means the input message that are bounded by the current org.apache.camel.spi.UnitOfWork . An unit of work typically spans one route, or multiple routes if they are connected using internal endpoints such as direct or seda. When messages is passed via external endpoints such as JMS or HTTP then the consumer will create a new unit of work, with the message it received as input as the original input. Also some EIP patterns such as splitter, multicast, will create a new unit of work boundary for the messages in their sub-route (eg the splitted message); however these EIPs have an option named shareUnitOfWork which allows to combine with the parent unit of work in regard to error handling and therefore use the parent original message. By default this feature is off.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('useOriginalBody', 'Use Original Body', "Will use the original input org.apache.camel.Message body (original body only) when an org.apache.camel.Exchange is moved to the dead letter queue. Notice: this only applies when all redeliveries attempt have failed and the org.apache.camel.Exchange is doomed for failure. Instead of using the current inprogress org.apache.camel.Exchange IN message we use the original IN message instead. This allows you to store the original input in the dead letter queue instead of the inprogress snapshot of the IN message. For instance if you route transform the IN body during routing and then failed. With the original exchange store in the dead letter queue it might be easier to manually re submit the org.apache.camel.Exchange again as the IN message is the same as when Camel received it. So you should be able to send the org.apache.camel.Exchange to the same input. The difference between useOriginalMessage and useOriginalBody is that the former includes both the original body and headers, where as the latter only includes the original body. You can use the latter to enrich the message with custom headers and include the original message body. The former wont let you do this, as its using the original message body and headers as they are. You cannot enable both useOriginalMessage and useOriginalBody. The original input message is defensively copied, and the copied message body is converted to org.apache.camel.StreamCache if possible (stream caching is enabled, can be disabled globally or on the original route), to ensure the body can be read when the original message is being used later. If the body is converted to org.apache.camel.StreamCache then the message body on the current org.apache.camel.Exchange is replaced with the org.apache.camel.StreamCache body. If the body is not converted to org.apache.camel.StreamCache then the body will not be able to re-read when accessed later. Important: The original input means the input message that are bounded by the current org.apache.camel.spi.UnitOfWork . An unit of work typically spans one route, or multiple routes if they are connected using internal endpoints such as direct or seda. When messages is passed via external endpoints such as JMS or HTTP then the consumer will create a new unit of work, with the message it received as input as the original input. Also some EIP patterns such as splitter, multicast, will create a new unit of work boundary for the messages in their sub-route (eg the splitted message); however these EIPs have an option named shareUnitOfWork which allows to combine with the parent unit of work in regard to error handling and therefore use the parent original message. By default this feature is off.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('redeliveryPolicyRef', 'Redelivery Policy Ref', "Sets a reference to a RedeliveryPolicy to be used for redelivery settings.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('loggerRef', 'Logger Ref', "References to a logger to use as logger for the error handler", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('level', 'Level', "Logging level to use by error handler", 'string', 'TRACE, DEBUG, INFO, WARN, ERROR, OFF', 'ERROR', false, false, false, false, 'advanced', ''),
        new PropertyMeta('logName', 'Log Name', "Name of the logger to use by the error handler", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('onRedeliveryRef', 'On Redelivery Ref', "Sets a reference to a processor that should be processed before a redelivery attempt. Can be used to change the org.apache.camel.Exchange before its being redelivered.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('onExceptionOccurredRef', 'On Exception Occurred Ref', "Sets a reference to a processor that should be processed just after an exception occurred. Can be used to perform custom logging about the occurred exception at the exact time it happened. Important: Any exception thrown from this processor will be ignored.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('onPrepareFailureRef', 'On Prepare Failure Ref', "Sets a reference to a processor to prepare the org.apache.camel.Exchange before handled by the failure processor / dead letter channel. This allows for example to enrich the message before sending to a dead letter queue.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('retryWhileRef', 'Retry While Ref', "Sets a retry while predicate. Will continue retrying until the predicate evaluates to false.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('executorServiceRef', 'Executor Service Ref', "Sets a reference to a thread pool to be used by the error handler", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('jtaTransactionErrorHandler', 'JtaTransactionErrorHandlerDefinition', 'Jta Transaction Error Handler', "JTA based transactional error handler (requires camel-jta).", 'configuration,error', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('transactedPolicyRef', 'Transacted Policy Ref', "The transacted policy to use that is configured for either Spring or JTA based transactions. If no policy has been configured then Camel will attempt to auto-discover.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('rollbackLoggingLevel', 'Rollback Logging Level', "Sets the logging level to use for logging transactional rollback. This option is default WARN.", 'string', 'TRACE, DEBUG, INFO, WARN, ERROR, OFF', 'WARN', false, false, false, false, '', ''),
        new PropertyMeta('redeliveryPolicy', 'Redelivery Policy', "Sets the redelivery settings", 'RedeliveryPolicyDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('useOriginalMessage', 'Use Original Message', "Will use the original input org.apache.camel.Message (original body and headers) when an org.apache.camel.Exchange is moved to the dead letter queue. Notice: this only applies when all redeliveries attempt have failed and the org.apache.camel.Exchange is doomed for failure. Instead of using the current inprogress org.apache.camel.Exchange IN message we use the original IN message instead. This allows you to store the original input in the dead letter queue instead of the inprogress snapshot of the IN message. For instance if you route transform the IN body during routing and then failed. With the original exchange store in the dead letter queue it might be easier to manually re submit the org.apache.camel.Exchange again as the IN message is the same as when Camel received it. So you should be able to send the org.apache.camel.Exchange to the same input. The difference between useOriginalMessage and useOriginalBody is that the former includes both the original body and headers, where as the latter only includes the original body. You can use the latter to enrich the message with custom headers and include the original message body. The former wont let you do this, as its using the original message body and headers as they are. You cannot enable both useOriginalMessage and useOriginalBody. The original input message is defensively copied, and the copied message body is converted to org.apache.camel.StreamCache if possible (stream caching is enabled, can be disabled globally or on the original route), to ensure the body can be read when the original message is being used later. If the body is converted to org.apache.camel.StreamCache then the message body on the current org.apache.camel.Exchange is replaced with the org.apache.camel.StreamCache body. If the body is not converted to org.apache.camel.StreamCache then the body will not be able to re-read when accessed later. Important: The original input means the input message that are bounded by the current org.apache.camel.spi.UnitOfWork . An unit of work typically spans one route, or multiple routes if they are connected using internal endpoints such as direct or seda. When messages is passed via external endpoints such as JMS or HTTP then the consumer will create a new unit of work, with the message it received as input as the original input. Also some EIP patterns such as splitter, multicast, will create a new unit of work boundary for the messages in their sub-route (eg the splitted message); however these EIPs have an option named shareUnitOfWork which allows to combine with the parent unit of work in regard to error handling and therefore use the parent original message. By default this feature is off.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('useOriginalBody', 'Use Original Body', "Will use the original input org.apache.camel.Message body (original body only) when an org.apache.camel.Exchange is moved to the dead letter queue. Notice: this only applies when all redeliveries attempt have failed and the org.apache.camel.Exchange is doomed for failure. Instead of using the current inprogress org.apache.camel.Exchange IN message we use the original IN message instead. This allows you to store the original input in the dead letter queue instead of the inprogress snapshot of the IN message. For instance if you route transform the IN body during routing and then failed. With the original exchange store in the dead letter queue it might be easier to manually re submit the org.apache.camel.Exchange again as the IN message is the same as when Camel received it. So you should be able to send the org.apache.camel.Exchange to the same input. The difference between useOriginalMessage and useOriginalBody is that the former includes both the original body and headers, where as the latter only includes the original body. You can use the latter to enrich the message with custom headers and include the original message body. The former wont let you do this, as its using the original message body and headers as they are. You cannot enable both useOriginalMessage and useOriginalBody. The original input message is defensively copied, and the copied message body is converted to org.apache.camel.StreamCache if possible (stream caching is enabled, can be disabled globally or on the original route), to ensure the body can be read when the original message is being used later. If the body is converted to org.apache.camel.StreamCache then the message body on the current org.apache.camel.Exchange is replaced with the org.apache.camel.StreamCache body. If the body is not converted to org.apache.camel.StreamCache then the body will not be able to re-read when accessed later. Important: The original input means the input message that are bounded by the current org.apache.camel.spi.UnitOfWork . An unit of work typically spans one route, or multiple routes if they are connected using internal endpoints such as direct or seda. When messages is passed via external endpoints such as JMS or HTTP then the consumer will create a new unit of work, with the message it received as input as the original input. Also some EIP patterns such as splitter, multicast, will create a new unit of work boundary for the messages in their sub-route (eg the splitted message); however these EIPs have an option named shareUnitOfWork which allows to combine with the parent unit of work in regard to error handling and therefore use the parent original message. By default this feature is off.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('redeliveryPolicyRef', 'Redelivery Policy Ref', "Sets a reference to a RedeliveryPolicy to be used for redelivery settings.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('loggerRef', 'Logger Ref', "References to a logger to use as logger for the error handler", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('level', 'Level', "Logging level to use by error handler", 'string', 'TRACE, DEBUG, INFO, WARN, ERROR, OFF', 'ERROR', false, false, false, false, 'advanced', ''),
        new PropertyMeta('logName', 'Log Name', "Name of the logger to use by the error handler", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('onRedeliveryRef', 'On Redelivery Ref', "Sets a reference to a processor that should be processed before a redelivery attempt. Can be used to change the org.apache.camel.Exchange before its being redelivered.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('onExceptionOccurredRef', 'On Exception Occurred Ref', "Sets a reference to a processor that should be processed just after an exception occurred. Can be used to perform custom logging about the occurred exception at the exact time it happened. Important: Any exception thrown from this processor will be ignored.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('onPrepareFailureRef', 'On Prepare Failure Ref', "Sets a reference to a processor to prepare the org.apache.camel.Exchange before handled by the failure processor / dead letter channel. This allows for example to enrich the message before sending to a dead letter queue.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('retryWhileRef', 'Retry While Ref', "Sets a retry while predicate. Will continue retrying until the predicate evaluates to false.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('executorServiceRef', 'Executor Service Ref', "Sets a reference to a thread pool to be used by the error handler", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('noErrorHandler', 'NoErrorHandlerDefinition', 'No Error Handler', "To not use an error handler.", 'configuration,error', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('refErrorHandler', 'RefErrorHandlerDefinition', 'Ref Error Handler', "References to an existing or custom error handler.", 'configuration,error', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('ref', 'Ref', "References to an existing or custom error handler.", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('springTransactionErrorHandler', 'SpringTransactionErrorHandlerDefinition', 'Spring Transaction Error Handler', "Spring based transactional error handler (requires camel-spring).", 'configuration,error', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('transactedPolicyRef', 'Transacted Policy Ref', "The transacted policy to use that is configured for either Spring or JTA based transactions. If no policy has been configured then Camel will attempt to auto-discover.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('rollbackLoggingLevel', 'Rollback Logging Level', "Sets the logging level to use for logging transactional rollback. This option is default WARN.", 'string', 'TRACE, DEBUG, INFO, WARN, ERROR, OFF', 'WARN', false, false, false, false, '', ''),
        new PropertyMeta('redeliveryPolicy', 'Redelivery Policy', "Sets the redelivery settings", 'RedeliveryPolicyDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('useOriginalMessage', 'Use Original Message', "Will use the original input org.apache.camel.Message (original body and headers) when an org.apache.camel.Exchange is moved to the dead letter queue. Notice: this only applies when all redeliveries attempt have failed and the org.apache.camel.Exchange is doomed for failure. Instead of using the current inprogress org.apache.camel.Exchange IN message we use the original IN message instead. This allows you to store the original input in the dead letter queue instead of the inprogress snapshot of the IN message. For instance if you route transform the IN body during routing and then failed. With the original exchange store in the dead letter queue it might be easier to manually re submit the org.apache.camel.Exchange again as the IN message is the same as when Camel received it. So you should be able to send the org.apache.camel.Exchange to the same input. The difference between useOriginalMessage and useOriginalBody is that the former includes both the original body and headers, where as the latter only includes the original body. You can use the latter to enrich the message with custom headers and include the original message body. The former wont let you do this, as its using the original message body and headers as they are. You cannot enable both useOriginalMessage and useOriginalBody. The original input message is defensively copied, and the copied message body is converted to org.apache.camel.StreamCache if possible (stream caching is enabled, can be disabled globally or on the original route), to ensure the body can be read when the original message is being used later. If the body is converted to org.apache.camel.StreamCache then the message body on the current org.apache.camel.Exchange is replaced with the org.apache.camel.StreamCache body. If the body is not converted to org.apache.camel.StreamCache then the body will not be able to re-read when accessed later. Important: The original input means the input message that are bounded by the current org.apache.camel.spi.UnitOfWork . An unit of work typically spans one route, or multiple routes if they are connected using internal endpoints such as direct or seda. When messages is passed via external endpoints such as JMS or HTTP then the consumer will create a new unit of work, with the message it received as input as the original input. Also some EIP patterns such as splitter, multicast, will create a new unit of work boundary for the messages in their sub-route (eg the splitted message); however these EIPs have an option named shareUnitOfWork which allows to combine with the parent unit of work in regard to error handling and therefore use the parent original message. By default this feature is off.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('useOriginalBody', 'Use Original Body', "Will use the original input org.apache.camel.Message body (original body only) when an org.apache.camel.Exchange is moved to the dead letter queue. Notice: this only applies when all redeliveries attempt have failed and the org.apache.camel.Exchange is doomed for failure. Instead of using the current inprogress org.apache.camel.Exchange IN message we use the original IN message instead. This allows you to store the original input in the dead letter queue instead of the inprogress snapshot of the IN message. For instance if you route transform the IN body during routing and then failed. With the original exchange store in the dead letter queue it might be easier to manually re submit the org.apache.camel.Exchange again as the IN message is the same as when Camel received it. So you should be able to send the org.apache.camel.Exchange to the same input. The difference between useOriginalMessage and useOriginalBody is that the former includes both the original body and headers, where as the latter only includes the original body. You can use the latter to enrich the message with custom headers and include the original message body. The former wont let you do this, as its using the original message body and headers as they are. You cannot enable both useOriginalMessage and useOriginalBody. The original input message is defensively copied, and the copied message body is converted to org.apache.camel.StreamCache if possible (stream caching is enabled, can be disabled globally or on the original route), to ensure the body can be read when the original message is being used later. If the body is converted to org.apache.camel.StreamCache then the message body on the current org.apache.camel.Exchange is replaced with the org.apache.camel.StreamCache body. If the body is not converted to org.apache.camel.StreamCache then the body will not be able to re-read when accessed later. Important: The original input means the input message that are bounded by the current org.apache.camel.spi.UnitOfWork . An unit of work typically spans one route, or multiple routes if they are connected using internal endpoints such as direct or seda. When messages is passed via external endpoints such as JMS or HTTP then the consumer will create a new unit of work, with the message it received as input as the original input. Also some EIP patterns such as splitter, multicast, will create a new unit of work boundary for the messages in their sub-route (eg the splitted message); however these EIPs have an option named shareUnitOfWork which allows to combine with the parent unit of work in regard to error handling and therefore use the parent original message. By default this feature is off.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('redeliveryPolicyRef', 'Redelivery Policy Ref', "Sets a reference to a RedeliveryPolicy to be used for redelivery settings.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('loggerRef', 'Logger Ref', "References to a logger to use as logger for the error handler", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('level', 'Level', "Logging level to use by error handler", 'string', 'TRACE, DEBUG, INFO, WARN, ERROR, OFF', 'ERROR', false, false, false, false, 'advanced', ''),
        new PropertyMeta('logName', 'Log Name', "Name of the logger to use by the error handler", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('onRedeliveryRef', 'On Redelivery Ref', "Sets a reference to a processor that should be processed before a redelivery attempt. Can be used to change the org.apache.camel.Exchange before its being redelivered.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('onExceptionOccurredRef', 'On Exception Occurred Ref', "Sets a reference to a processor that should be processed just after an exception occurred. Can be used to perform custom logging about the occurred exception at the exact time it happened. Important: Any exception thrown from this processor will be ignored.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('onPrepareFailureRef', 'On Prepare Failure Ref', "Sets a reference to a processor to prepare the org.apache.camel.Exchange before handled by the failure processor / dead letter channel. This allows for example to enrich the message before sending to a dead letter queue.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('retryWhileRef', 'Retry While Ref', "Sets a retry while predicate. Will continue retrying until the predicate evaluates to false.", 'string', '', '', false, false, false, false, 'advanced', 'org.apache.camel.Processor'),
        new PropertyMeta('executorServiceRef', 'Executor Service Ref', "Sets a reference to a thread pool to be used by the error handler", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('expression', 'ExpressionDefinition', 'Expression', "A useful base class for an expression", 'language', [
        new PropertyMeta('constant', 'constant', "constant", 'ConstantExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('csimple', 'csimple', "csimple", 'CSimpleExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('datasonnet', 'datasonnet', "datasonnet", 'DatasonnetExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('exchangeProperty', 'exchangeProperty', "exchangeProperty", 'ExchangePropertyExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('groovy', 'groovy', "groovy", 'GroovyExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('header', 'header', "header", 'HeaderExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('hl7terser', 'hl7terser', "hl7terser", 'Hl7TerserExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('java', 'java', "java", 'JavaExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('jq', 'jq', "jq", 'JqExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('js', 'js', "js", 'JavaScriptExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('jsonpath', 'jsonpath', "jsonpath", 'JsonPathExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('language', 'language', "language", 'LanguageExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('method', 'method', "method", 'MethodCallExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('mvel', 'mvel', "mvel", 'MvelExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('ognl', 'ognl', "ognl", 'OgnlExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('python', 'python', "python", 'PythonExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('ref', 'ref', "ref", 'RefExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('simple', 'simple', "simple", 'SimpleExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('spel', 'spel', "spel", 'SpELExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('tokenize', 'tokenize', "tokenize", 'TokenizerExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('variable', 'variable', "variable", 'VariableExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('wasm', 'wasm', "wasm", 'WasmExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('xpath', 'xpath', "xpath", 'XPathExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('xquery', 'xquery', "xquery", 'XQueryExpression', '', '', false, false, false, true, '', ''),
        new PropertyMeta('xtokenize', 'xtokenize', "xtokenize", 'XMLTokenizerExpression', '', '', false, false, false, true, '', ''),
    ], [
    ]),
    new ElementMeta('customLoadBalancer', 'CustomLoadBalancerDefinition', 'Custom Load Balancer', "To use a custom load balancer implementation.", 'eip,routing', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('ref', 'Ref', "Refers to the custom load balancer to lookup from the registry", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('failover', 'FailoverLoadBalancerDefinition', 'Failover', "In case of failures the exchange will be tried on the next endpoint.", 'eip,routing', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('exception', 'Exception', "A list of class names for specific exceptions to monitor. If no exceptions are configured then all exceptions are monitored", 'string', '', '', false, false, true, true, '', ''),
        new PropertyMeta('roundRobin', 'Round Robin', "Whether or not the failover load balancer should operate in round robin mode or not. If not, then it will always start from the first endpoint when a new message is to be processed. In other words it restart from the top for every message. If round robin is enabled, then it keeps state and will continue with the next endpoint in a round robin fashion. You can also enable sticky mode together with round robin, if so then it will pick the last known good endpoint to use when starting the load balancing (instead of using the next when starting).", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('sticky', 'Sticky', "Whether or not the failover load balancer should operate in sticky mode or not. If not, then it will always start from the first endpoint when a new message is to be processed. In other words it restart from the top for every message. If sticky is enabled, then it keeps state and will continue with the last known good endpoint. You can also enable sticky mode together with round robin, if so then it will pick the last known good endpoint to use when starting the load balancing (instead of using the next when starting).", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('maximumFailoverAttempts', 'Maximum Failover Attempts', "A value to indicate after X failover attempts we should exhaust (give up). Use -1 to indicate never give up and continuously try to failover. Use 0 to never failover. And use e.g. 3 to failover at most 3 times before giving up. his option can be used whether or not roundRobin is enabled or not.", 'string', '', '-1', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('random', 'RandomLoadBalancerDefinition', 'Random', "The destination endpoints are selected randomly.", 'eip,routing', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('roundRobin', 'RoundRobinLoadBalancerDefinition', 'Round Robin', "The destination endpoints are selected in a round-robin fashion. This is a well-known and classic policy, which spreads the load evenly.", 'eip,routing', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('sticky', 'StickyLoadBalancerDefinition', 'Sticky', "Sticky load balancing using an expression to calculate a correlation key to perform the sticky load balancing.", 'eip,routing', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('correlationExpression', 'Correlation Expression', "The correlation expression to use to calculate the correlation key", 'ExpressionSubElementDefinition', '', '', true, false, false, true, '', ''),
    ], [
    ]),
    new ElementMeta('topic', 'TopicLoadBalancerDefinition', 'Topic', "Topic which sends to all destinations.", 'eip,routing', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('weighted', 'WeightedLoadBalancerDefinition', 'Weighted', "Uses a weighted load distribution ratio for each server with respect to others.", 'eip,routing', [
        new PropertyMeta('id', 'Id', "The id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('distributionRatio', 'Distribution Ratio', "The distribution ratio is a delimited String consisting on integer weights separated by delimiters for example 2,3,5. The distributionRatio must match the number of endpoints and/or processors specified in the load balancer list.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('distributionRatioDelimiter', 'Distribution Ratio Delimiter', "Delimiter used to specify the distribution ratio. The default value is , (comma)", 'string', '', ',', false, false, false, false, 'advanced', ''),
        new PropertyMeta('roundRobin', 'Round Robin', "To enable round robin mode. By default the weighted distribution mode is used. The default value is false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('apiKey', 'ApiKeyDefinition', 'Api Key', "Rest security basic auth definition", 'rest,security,configuration', [
        new PropertyMeta('description', 'Description', "A short description for security scheme.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('name', 'Name', "The name of the header or query parameter to be used.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('key', 'Key', "Key used to refer to this security definition", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('inHeader', 'In Header', "To use header as the location of the API key.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('inQuery', 'In Query', "To use query parameter as the location of the API key.", 'boolean', '', 'false', false, false, false, false, '', ''),
        new PropertyMeta('inCookie', 'In Cookie', "To use a cookie as the location of the API key.", 'boolean', '', 'false', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('basicAuth', 'BasicAuthDefinition', 'Basic Auth', "Rest security basic auth definition", 'rest,security,configuration', [
        new PropertyMeta('description', 'Description', "A short description for security scheme.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('key', 'Key', "Key used to refer to this security definition", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('bearerToken', 'BearerTokenDefinition', 'Bearer Token', "Rest security bearer token authentication definition", 'rest,security,configuration', [
        new PropertyMeta('description', 'Description', "A short description for security scheme.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('key', 'Key', "Key used to refer to this security definition", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('format', 'Format', "A hint to the client to identify how the bearer token is formatted.", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('delete', 'DeleteDefinition', 'Delete', "Rest DELETE command", 'rest', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this REST service from the route during build time. Once an REST service has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('path', 'Path', "The path mapping URIs of this REST operation such as /{id}.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('to', 'To', "The Camel endpoint this REST service will call, such as a direct endpoint to link to an existing route that handles this REST call.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('consumes', 'Consumes', "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json. This option will override what may be configured on a parent level", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('produces', 'Produces', "To define the content type what the REST service produces (uses for output), such as application/xml or application/json This option will override what may be configured on a parent level", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('type', 'Type', "Sets the class name to use for binding from input to POJO for the incoming data This option will override what may be configured on a parent level. The name of the class of the input data. Append a to the end of the name if you want the input to be an array type.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('outType', 'Out Type', "Sets the class name to use for binding from POJO to output for the outgoing data This option will override what may be configured on a parent level The name of the class of the input data. Append a to the end of the name if you want the input to be an array type.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('bindingMode', 'Binding Mode', "Sets the binding mode to use. This option will override what may be configured on a parent level The default value is off", 'string', 'off, auto, json, xml, json_xml', 'off', false, false, false, false, '', ''),
        new PropertyMeta('skipBindingOnErrorCode', 'Skip Binding On Error Code', "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do. This option will override what may be configured on a parent level", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('clientRequestValidation', 'Client Request Validation', "Whether to enable validation of the client request to check: 1) Content-Type header matches what the Rest DSL consumes; returns HTTP Status 415 if validation error. 2) Accept header matches what the Rest DSL produces; returns HTTP Status 406 if validation error. 3) Missing required data (query parameters, HTTP headers, body); returns HTTP Status 400 if validation error. 4) Parsing error of the message body (JSon, XML or Auto binding mode must be enabled); returns HTTP Status 400 if validation error.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableCORS', 'Enable CORS', "Whether to enable CORS headers in the HTTP response. This option will override what may be configured on a parent level The default value is false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableNoContentResponse', 'Enable No Content Response', "Whether to return HTTP 204 with an empty body when a response contains an empty JSON object or XML root object. The default value is false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('apiDocs', 'Api Docs', "Whether to include or exclude this rest operation in API documentation. The default value is true.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('deprecated', 'Deprecated', "Marks this rest operation as deprecated in OpenApi documentation.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('routeId', 'Route Id', "Sets the id of the route", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('param', 'param', "param", 'ParamDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('responseMessage', 'responseMessage', "responseMessage", 'ResponseMessageDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('security', 'security', "security", 'SecurityDefinition', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('get', 'GetDefinition', 'Get', "Rest GET command", 'rest', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this REST service from the route during build time. Once an REST service has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('path', 'Path', "The path mapping URIs of this REST operation such as /{id}.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('to', 'To', "The Camel endpoint this REST service will call, such as a direct endpoint to link to an existing route that handles this REST call.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('consumes', 'Consumes', "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json. This option will override what may be configured on a parent level", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('produces', 'Produces', "To define the content type what the REST service produces (uses for output), such as application/xml or application/json This option will override what may be configured on a parent level", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('type', 'Type', "Sets the class name to use for binding from input to POJO for the incoming data This option will override what may be configured on a parent level. The name of the class of the input data. Append a to the end of the name if you want the input to be an array type.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('outType', 'Out Type', "Sets the class name to use for binding from POJO to output for the outgoing data This option will override what may be configured on a parent level The name of the class of the input data. Append a to the end of the name if you want the input to be an array type.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('bindingMode', 'Binding Mode', "Sets the binding mode to use. This option will override what may be configured on a parent level The default value is off", 'string', 'off, auto, json, xml, json_xml', 'off', false, false, false, false, '', ''),
        new PropertyMeta('skipBindingOnErrorCode', 'Skip Binding On Error Code', "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do. This option will override what may be configured on a parent level", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('clientRequestValidation', 'Client Request Validation', "Whether to enable validation of the client request to check: 1) Content-Type header matches what the Rest DSL consumes; returns HTTP Status 415 if validation error. 2) Accept header matches what the Rest DSL produces; returns HTTP Status 406 if validation error. 3) Missing required data (query parameters, HTTP headers, body); returns HTTP Status 400 if validation error. 4) Parsing error of the message body (JSon, XML or Auto binding mode must be enabled); returns HTTP Status 400 if validation error.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableCORS', 'Enable CORS', "Whether to enable CORS headers in the HTTP response. This option will override what may be configured on a parent level The default value is false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableNoContentResponse', 'Enable No Content Response', "Whether to return HTTP 204 with an empty body when a response contains an empty JSON object or XML root object. The default value is false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('apiDocs', 'Api Docs', "Whether to include or exclude this rest operation in API documentation. The default value is true.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('deprecated', 'Deprecated', "Marks this rest operation as deprecated in OpenApi documentation.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('routeId', 'Route Id', "Sets the id of the route", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('param', 'param', "param", 'ParamDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('responseMessage', 'responseMessage', "responseMessage", 'ResponseMessageDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('security', 'security', "security", 'SecurityDefinition', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('head', 'HeadDefinition', 'Head', "Rest HEAD command", 'rest', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this REST service from the route during build time. Once an REST service has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('path', 'Path', "The path mapping URIs of this REST operation such as /{id}.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('to', 'To', "The Camel endpoint this REST service will call, such as a direct endpoint to link to an existing route that handles this REST call.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('consumes', 'Consumes', "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json. This option will override what may be configured on a parent level", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('produces', 'Produces', "To define the content type what the REST service produces (uses for output), such as application/xml or application/json This option will override what may be configured on a parent level", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('type', 'Type', "Sets the class name to use for binding from input to POJO for the incoming data This option will override what may be configured on a parent level. The name of the class of the input data. Append a to the end of the name if you want the input to be an array type.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('outType', 'Out Type', "Sets the class name to use for binding from POJO to output for the outgoing data This option will override what may be configured on a parent level The name of the class of the input data. Append a to the end of the name if you want the input to be an array type.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('bindingMode', 'Binding Mode', "Sets the binding mode to use. This option will override what may be configured on a parent level The default value is off", 'string', 'off, auto, json, xml, json_xml', 'off', false, false, false, false, '', ''),
        new PropertyMeta('skipBindingOnErrorCode', 'Skip Binding On Error Code', "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do. This option will override what may be configured on a parent level", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('clientRequestValidation', 'Client Request Validation', "Whether to enable validation of the client request to check: 1) Content-Type header matches what the Rest DSL consumes; returns HTTP Status 415 if validation error. 2) Accept header matches what the Rest DSL produces; returns HTTP Status 406 if validation error. 3) Missing required data (query parameters, HTTP headers, body); returns HTTP Status 400 if validation error. 4) Parsing error of the message body (JSon, XML or Auto binding mode must be enabled); returns HTTP Status 400 if validation error.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableCORS', 'Enable CORS', "Whether to enable CORS headers in the HTTP response. This option will override what may be configured on a parent level The default value is false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableNoContentResponse', 'Enable No Content Response', "Whether to return HTTP 204 with an empty body when a response contains an empty JSON object or XML root object. The default value is false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('apiDocs', 'Api Docs', "Whether to include or exclude this rest operation in API documentation. The default value is true.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('deprecated', 'Deprecated', "Marks this rest operation as deprecated in OpenApi documentation.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('routeId', 'Route Id', "Sets the id of the route", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('param', 'param', "param", 'ParamDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('responseMessage', 'responseMessage', "responseMessage", 'ResponseMessageDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('security', 'security', "security", 'SecurityDefinition', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('mutualTLS', 'MutualTLSDefinition', 'Mutual TLS', "Rest security mutual TLS authentication definition", 'rest,security,configuration', [
        new PropertyMeta('description', 'Description', "A short description for security scheme.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('key', 'Key', "Key used to refer to this security definition", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('openApi', 'OpenApiDefinition', 'Open Api', "To use OpenApi as contract-first with Camel Rest DSL.", 'rest', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable all the REST services from the OpenAPI contract from the route during build time. Once an REST service has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('specification', 'Specification', "Path to the OpenApi specification file.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('routeId', 'Route Id', "Sets the id of the route", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('missingOperation', 'Missing Operation', "Whether to fail, ignore or return a mock response for OpenAPI operations that are not mapped to a corresponding route.", 'string', 'fail, ignore, mock', 'fail', false, false, false, false, '', ''),
        new PropertyMeta('mockIncludePattern', 'Mock Include Pattern', "Used for inclusive filtering of mock data from directories. The pattern is using Ant-path style pattern. Multiple patterns can be specified separated by comma.", 'string', '', 'classpath:camel-mock/**', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('openIdConnect', 'OpenIdConnectDefinition', 'Open Id Connect', "Rest security OpenID Connect definition", 'rest,security,configuration', [
        new PropertyMeta('description', 'Description', "A short description for security scheme.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('key', 'Key', "Key used to refer to this security definition", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('url', 'Url', "OpenId Connect URL to discover OAuth2 configuration values.", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('param', 'ParamDefinition', 'Param', "To specify the rest operation parameters.", 'rest', [
        new PropertyMeta('description', 'Description', "Sets the parameter description.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('name', 'Name', "Sets the parameter name.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('type', 'Type', "Sets the parameter type.", 'string', 'body, formData, header, path, query', 'path', false, false, false, false, '', ''),
        new PropertyMeta('defaultValue', 'Default Value', "Sets the parameter default value.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('required', 'Required', "Sets the parameter required flag.", 'boolean', '', 'true', false, false, false, false, '', ''),
        new PropertyMeta('collectionFormat', 'Collection Format', "Sets the parameter collection format.", 'string', 'csv, multi, pipes, ssv, tsv', 'csv', false, false, false, false, '', ''),
        new PropertyMeta('arrayType', 'Array Type', "Sets the parameter array type. Required if data type is array. Describes the type of items in the array.", 'string', '', 'string', false, false, false, false, '', ''),
        new PropertyMeta('dataType', 'Data Type', "Sets the parameter data type.", 'string', '', 'string', false, false, false, false, '', ''),
        new PropertyMeta('dataFormat', 'Data Format', "Sets the parameter data format.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('allowableValues', 'Allowable Values', "Sets the parameter list of allowable values (enum).", 'string', '', '', false, false, true, true, '', ''),
        new PropertyMeta('examples', 'Examples', "Sets the parameter examples.", 'RestPropertyDefinition', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('patch', 'PatchDefinition', 'Patch', "Rest PATCH command", 'rest', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this REST service from the route during build time. Once an REST service has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('path', 'Path', "The path mapping URIs of this REST operation such as /{id}.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('to', 'To', "The Camel endpoint this REST service will call, such as a direct endpoint to link to an existing route that handles this REST call.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('consumes', 'Consumes', "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json. This option will override what may be configured on a parent level", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('produces', 'Produces', "To define the content type what the REST service produces (uses for output), such as application/xml or application/json This option will override what may be configured on a parent level", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('type', 'Type', "Sets the class name to use for binding from input to POJO for the incoming data This option will override what may be configured on a parent level. The name of the class of the input data. Append a to the end of the name if you want the input to be an array type.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('outType', 'Out Type', "Sets the class name to use for binding from POJO to output for the outgoing data This option will override what may be configured on a parent level The name of the class of the input data. Append a to the end of the name if you want the input to be an array type.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('bindingMode', 'Binding Mode', "Sets the binding mode to use. This option will override what may be configured on a parent level The default value is off", 'string', 'off, auto, json, xml, json_xml', 'off', false, false, false, false, '', ''),
        new PropertyMeta('skipBindingOnErrorCode', 'Skip Binding On Error Code', "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do. This option will override what may be configured on a parent level", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('clientRequestValidation', 'Client Request Validation', "Whether to enable validation of the client request to check: 1) Content-Type header matches what the Rest DSL consumes; returns HTTP Status 415 if validation error. 2) Accept header matches what the Rest DSL produces; returns HTTP Status 406 if validation error. 3) Missing required data (query parameters, HTTP headers, body); returns HTTP Status 400 if validation error. 4) Parsing error of the message body (JSon, XML or Auto binding mode must be enabled); returns HTTP Status 400 if validation error.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableCORS', 'Enable CORS', "Whether to enable CORS headers in the HTTP response. This option will override what may be configured on a parent level The default value is false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableNoContentResponse', 'Enable No Content Response', "Whether to return HTTP 204 with an empty body when a response contains an empty JSON object or XML root object. The default value is false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('apiDocs', 'Api Docs', "Whether to include or exclude this rest operation in API documentation. The default value is true.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('deprecated', 'Deprecated', "Marks this rest operation as deprecated in OpenApi documentation.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('routeId', 'Route Id', "Sets the id of the route", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('param', 'param', "param", 'ParamDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('responseMessage', 'responseMessage', "responseMessage", 'ResponseMessageDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('security', 'security', "security", 'SecurityDefinition', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('post', 'PostDefinition', 'Post', "Rest POST command", 'rest', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this REST service from the route during build time. Once an REST service has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('path', 'Path', "The path mapping URIs of this REST operation such as /{id}.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('to', 'To', "The Camel endpoint this REST service will call, such as a direct endpoint to link to an existing route that handles this REST call.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('consumes', 'Consumes', "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json. This option will override what may be configured on a parent level", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('produces', 'Produces', "To define the content type what the REST service produces (uses for output), such as application/xml or application/json This option will override what may be configured on a parent level", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('type', 'Type', "Sets the class name to use for binding from input to POJO for the incoming data This option will override what may be configured on a parent level. The name of the class of the input data. Append a to the end of the name if you want the input to be an array type.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('outType', 'Out Type', "Sets the class name to use for binding from POJO to output for the outgoing data This option will override what may be configured on a parent level The name of the class of the input data. Append a to the end of the name if you want the input to be an array type.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('bindingMode', 'Binding Mode', "Sets the binding mode to use. This option will override what may be configured on a parent level The default value is off", 'string', 'off, auto, json, xml, json_xml', 'off', false, false, false, false, '', ''),
        new PropertyMeta('skipBindingOnErrorCode', 'Skip Binding On Error Code', "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do. This option will override what may be configured on a parent level", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('clientRequestValidation', 'Client Request Validation', "Whether to enable validation of the client request to check: 1) Content-Type header matches what the Rest DSL consumes; returns HTTP Status 415 if validation error. 2) Accept header matches what the Rest DSL produces; returns HTTP Status 406 if validation error. 3) Missing required data (query parameters, HTTP headers, body); returns HTTP Status 400 if validation error. 4) Parsing error of the message body (JSon, XML or Auto binding mode must be enabled); returns HTTP Status 400 if validation error.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableCORS', 'Enable CORS', "Whether to enable CORS headers in the HTTP response. This option will override what may be configured on a parent level The default value is false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableNoContentResponse', 'Enable No Content Response', "Whether to return HTTP 204 with an empty body when a response contains an empty JSON object or XML root object. The default value is false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('apiDocs', 'Api Docs', "Whether to include or exclude this rest operation in API documentation. The default value is true.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('deprecated', 'Deprecated', "Marks this rest operation as deprecated in OpenApi documentation.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('routeId', 'Route Id', "Sets the id of the route", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('param', 'param', "param", 'ParamDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('responseMessage', 'responseMessage', "responseMessage", 'ResponseMessageDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('security', 'security', "security", 'SecurityDefinition', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('put', 'PutDefinition', 'Put', "Rest PUT command", 'rest', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('disabled', 'Disabled', "Whether to disable this REST service from the route during build time. Once an REST service has been disabled then it cannot be enabled later at runtime.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('path', 'Path', "The path mapping URIs of this REST operation such as /{id}.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('to', 'To', "The Camel endpoint this REST service will call, such as a direct endpoint to link to an existing route that handles this REST call.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('consumes', 'Consumes', "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json. This option will override what may be configured on a parent level", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('produces', 'Produces', "To define the content type what the REST service produces (uses for output), such as application/xml or application/json This option will override what may be configured on a parent level", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('type', 'Type', "Sets the class name to use for binding from input to POJO for the incoming data This option will override what may be configured on a parent level. The name of the class of the input data. Append a to the end of the name if you want the input to be an array type.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('outType', 'Out Type', "Sets the class name to use for binding from POJO to output for the outgoing data This option will override what may be configured on a parent level The name of the class of the input data. Append a to the end of the name if you want the input to be an array type.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('bindingMode', 'Binding Mode', "Sets the binding mode to use. This option will override what may be configured on a parent level The default value is off", 'string', 'off, auto, json, xml, json_xml', 'off', false, false, false, false, '', ''),
        new PropertyMeta('skipBindingOnErrorCode', 'Skip Binding On Error Code', "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do. This option will override what may be configured on a parent level", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('clientRequestValidation', 'Client Request Validation', "Whether to enable validation of the client request to check: 1) Content-Type header matches what the Rest DSL consumes; returns HTTP Status 415 if validation error. 2) Accept header matches what the Rest DSL produces; returns HTTP Status 406 if validation error. 3) Missing required data (query parameters, HTTP headers, body); returns HTTP Status 400 if validation error. 4) Parsing error of the message body (JSon, XML or Auto binding mode must be enabled); returns HTTP Status 400 if validation error.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableCORS', 'Enable CORS', "Whether to enable CORS headers in the HTTP response. This option will override what may be configured on a parent level The default value is false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableNoContentResponse', 'Enable No Content Response', "Whether to return HTTP 204 with an empty body when a response contains an empty JSON object or XML root object. The default value is false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('apiDocs', 'Api Docs', "Whether to include or exclude this rest operation in API documentation. The default value is true.", 'boolean', '', 'true', false, false, false, false, 'advanced', ''),
        new PropertyMeta('deprecated', 'Deprecated', "Marks this rest operation as deprecated in OpenApi documentation.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('routeId', 'Route Id', "Sets the id of the route", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('param', 'param', "param", 'ParamDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('responseMessage', 'responseMessage', "responseMessage", 'ResponseMessageDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('security', 'security', "security", 'SecurityDefinition', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('responseHeader', 'ResponseHeaderDefinition', 'Response Header', "To specify the rest operation response headers.", 'rest', [
        new PropertyMeta('description', 'Description', "Description of the parameter.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('name', 'Name', "Name of the parameter. This option is mandatory.", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('collectionFormat', 'Collection Format', "Sets the parameter collection format.", 'string', 'csv, multi, pipes, ssv, tsv', 'csv', false, false, false, false, '', ''),
        new PropertyMeta('arrayType', 'Array Type', "Sets the parameter array type. Required if data type is array. Describes the type of items in the array.", 'string', '', 'string', false, false, false, false, '', ''),
        new PropertyMeta('dataType', 'Data Type', "Sets the header data type.", 'string', '', 'string', false, false, false, false, '', ''),
        new PropertyMeta('dataFormat', 'Data Format', "Sets the parameter data format.", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('allowableValues', 'Allowable Values', "Sets the parameter list of allowable values.", 'string', '', '', false, false, true, true, '', ''),
        new PropertyMeta('example', 'Example', "Sets the example", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('responseMessage', 'ResponseMessageDefinition', 'Response Message', "To specify the rest operation response messages.", 'rest', [
        new PropertyMeta('code', 'Code', "The response code such as a HTTP status code", 'string', '', '200', false, false, false, false, '', ''),
        new PropertyMeta('message', 'Message', "The response message (description)", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('responseModel', 'Response Model', "The response model", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('header', 'Header', "Adds a response header", 'ResponseHeaderDefinition', '', '', false, false, true, true, '', ''),
        new PropertyMeta('examples', 'Examples', "Examples of response messages", 'RestPropertyDefinition', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('restBinding', 'RestBindingDefinition', 'Rest Binding', "To configure rest binding", 'rest', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('consumes', 'Consumes', "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('produces', 'Produces', "To define the content type what the REST service produces (uses for output), such as application/xml or application/json", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('bindingMode', 'Binding Mode', "Sets the binding mode to use. The default value is off", 'string', 'off, auto, json, xml, json_xml', 'off', false, false, false, false, '', ''),
        new PropertyMeta('type', 'Type', "Sets the class name to use for binding from input to POJO for the incoming data The name of the class of the input data. Append a to the end of the name if you want the input to be an array type.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('outType', 'Out Type', "Sets the class name to use for binding from POJO to output for the outgoing data The name of the class of the input data. Append a to the end of the name if you want the input to be an array type.", 'string', '', '', false, false, false, false, 'advanced', ''),
        new PropertyMeta('skipBindingOnErrorCode', 'Skip Binding On Error Code', "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('clientRequestValidation', 'Client Request Validation', "Whether to enable validation of the client request to check: 1) Content-Type header matches what the Rest DSL consumes; returns HTTP Status 415 if validation error. 2) Accept header matches what the Rest DSL produces; returns HTTP Status 406 if validation error. 3) Missing required data (query parameters, HTTP headers, body); returns HTTP Status 400 if validation error. 4) Parsing error of the message body (JSon, XML or Auto binding mode must be enabled); returns HTTP Status 400 if validation error.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableCORS', 'Enable CORS', "Whether to enable CORS headers in the HTTP response. The default value is false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('enableNoContentResponse', 'Enable No Content Response', "Whether to return HTTP 204 with an empty body when a response contains an empty JSON object or XML root object. The default value is false.", 'boolean', '', 'false', false, false, false, false, 'advanced', ''),
        new PropertyMeta('component', 'Component', "Sets the component name that this definition will apply to", 'string', '', '', false, false, false, false, 'advanced', ''),
    ], [
    ]),
    new ElementMeta('restProperty', 'RestPropertyDefinition', 'Rest Property', "A key value pair", 'rest', [
        new PropertyMeta('key', 'Key', "Property key", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('value', 'Value', "Property value", 'string', '', '', true, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('securityDefinitions', 'RestSecuritiesDefinition', 'Rest Security Definitions', "To configure rest security definitions.", 'rest,security,configuration', [
        new PropertyMeta('apiKey', 'apiKey', "apiKey", 'ApiKeyDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('basicAuth', 'basicAuth', "basicAuth", 'BasicAuthDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('bearer', 'bearer', "bearer", 'BearerTokenDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('mutualTLS', 'mutualTLS', "mutualTLS", 'MutualTLSDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('oauth2', 'oauth2', "oauth2", 'OAuth2Definition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('openIdConnect', 'openIdConnect', "openIdConnect", 'OpenIdConnectDefinition', '', '', false, false, false, true, '', ''),
    ], [
    ]),
    new ElementMeta('rests', 'RestsDefinition', 'Rests', "A series of rest services defined using the rest-dsl", 'rest', [
        new PropertyMeta('id', 'Id', "Sets the id of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('description', 'Description', "Sets the description of this node", 'string', '', '', false, false, false, false, '', ''),
        new PropertyMeta('rest', 'rest', "rest", 'RestDefinition', '', '', false, false, true, true, '', ''),
    ], [
    ]),
    new ElementMeta('security', 'SecurityDefinition', 'Rest Security', "Rest security definition", 'rest,security,configuration', [
        new PropertyMeta('key', 'Key', "Key used to refer to this security definition", 'string', '', '', true, false, false, false, '', ''),
        new PropertyMeta('scopes', 'Scopes', "The scopes to allow (separate multiple scopes by comma)", 'string', '', '', false, false, false, false, '', ''),
    ], [
    ]),
    new ElementMeta('transformers', 'TransformersDefinition', 'Transformations', "To configure transformers.", 'transformation', [
        new PropertyMeta('customTransformer', 'customTransformer', "customTransformer", 'CustomTransformerDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('dataFormatTransformer', 'dataFormatTransformer', "dataFormatTransformer", 'DataFormatTransformerDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('endpointTransformer', 'endpointTransformer', "endpointTransformer", 'EndpointTransformerDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('loadTransformer', 'loadTransformer', "loadTransformer", 'LoadTransformerDefinition', '', '', false, false, false, true, '', ''),
    ], [
    ]),
    new ElementMeta('validators', 'ValidatorsDefinition', 'Validations', "To configure validators.", 'validation', [
        new PropertyMeta('customValidator', 'customValidator', "customValidator", 'CustomValidatorDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('endpointValidator', 'endpointValidator', "endpointValidator", 'EndpointValidatorDefinition', '', '', false, false, false, true, '', ''),
        new PropertyMeta('predicateValidator', 'predicateValidator', "predicateValidator", 'PredicateValidatorDefinition', '', '', false, false, false, true, '', ''),
    ], [
    ]),
]

export const SensitiveKeys: string[] = [
    "oauthtokenurl",
    "clientid",
    "sassignature",
    "connectionstring",
    "sslpassword",
    "accesstoken",
    "accountkey",
    "proxyauthusername",
    "sslkeypassword",
    "userpassword",
    "acltoken",
    "password",
    "accesskey",
    "consumersecret",
    "proxyuser",
    "oauthclientsecret",
    "accesstokensecret",
    "securerandom",
    "keystore",
    "refreshtoken",
    "sessiontoken",
    "publishkey",
    "accountsid",
    "emailaddress",
    "blobaccesskey",
    "publickeyid",
    "p12filename",
    "ssltruststorepassword",
    "passphrase",
    "privatekeyfile",
    "zookeeperpassword",
    "apiuser",
    "cipherkey",
    "personalaccesstoken",
    "authkey",
    "privatekeyname",
    "systemid",
    "secretkey",
    "webhookverifytoken",
    "privatekeypassword",
    "secret",
    "login",
    "sourceblobaccesskey",
    "apipassword",
    "privatekey",
    "sslkeystorepassword",
    "oauthtoken",
    "sascredential",
    "verificationcode",
    "subscribekey",
    "certresourcepassword",
    "clientsecretcredential",
    "oauthclientid",
    "apikey",
    "clientsecret",
    "tokencredential",
    "blobstoragesharedkeycredential",
    "proxypassword",
    "queueownerawsaccountid",
    "token",
    "proxyauthpassword",
    "authorizationtoken",
    "sharedaccesskey",
    "apiusername",
    "api_key",
    "sasljaasconfig",
    "httpproxypassword",
    "user",
    "api_secret",
    "passcode",
    "consumerkey",
    "sslkeystore",
    "username"
]