/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.camel.karavan.api;

import io.quarkus.oidc.UserInfo;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import org.jboss.resteasy.reactive.NoCache;

import java.util.Set;

@Path("/ui/users")
@Produces(MediaType.APPLICATION_JSON)
public class UsersResource {

    @Inject
    SecurityIdentity securityIdentity;


    @GET
    @Path("/me")
    @NoCache
    public ProfileInfo me() {
        return new ProfileInfo(securityIdentity);
    }

    public static class ProfileInfo {

        private final String userName;
        private final String displayName;
        private final Set<String> roles;

        ProfileInfo(SecurityIdentity securityIdentity) {
            UserInfo userInfo = (UserInfo) securityIdentity.getAttributes().get("userinfo");
            this.userName = securityIdentity.getPrincipal().getName();
            this.roles = securityIdentity.getRoles();
            this.displayName = userInfo != null ? userInfo.getName() : userName;
        }

        public String getDisplayName() {
            return displayName;
        }

        public String getUserName() {
            return userName;
        }

        public Set<String> getRoles() {
            return roles;
        }
    }
}