/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Generated by karavan build tools - do NOT edit this file!
 */
export class ElementMeta {
    name: string = ''
    className: string = ''
    title: string = ''
    description: string = ''
    labels: string = ''
    properties: PropertyMeta[] = []


    constructor(name: string, className:string, title: string, description: string, labels: string, properties: PropertyMeta[]) {
        this.name = name;
        this.className = className;
        this.title = title;
        this.description = description;
        this.labels = labels;
        this.properties = properties;
    }
}

export class PropertyMeta {
    name: string = ''
    displayName: string = ''
    description: string = ''
    type: string = ''
    enumVals: string = ''
    defaultValue: string = ''
    required: boolean = false
    secret: boolean = false
    isArray: boolean = false
    isObject: boolean = false
    label: string = ''
    javaType: string = ''
    placeholder: boolean = false

    constructor(name: string, displayName: string, description: string, type: string, enumVals: string,
                defaultValue: string, required: boolean, secret: boolean, isArray: boolean, isObject: boolean,
                label: string, javaType: string, placeholder: boolean) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.type = type;
        this.enumVals = enumVals;
        this.defaultValue = defaultValue;
        this.required = required;
        this.secret = secret;
        this.isArray = isArray;
        this.isObject = isObject;
        this.label = label;
        this.javaType = javaType;
        this.placeholder = placeholder;
    }
}

export class CamelMetadataApi {

    static getCamelModelMetadataByName = (name: string): ElementMeta | undefined => {
       return CamelModelMetadata.find(value => value.name === name);
    }

    static getCamelModelMetadataByClassName = (className: string): ElementMeta | undefined => {
        return CamelModelMetadata.find(value => value.className === className);
    }

    static getCamelDataFormatMetadataByName = (name: string): ElementMeta | undefined => {
        return CamelDataFormatMetadata.find(value => value.name === name);
    }

    static getCamelDataFormatMetadataByClassName = (className: string): ElementMeta | undefined => {
        return CamelDataFormatMetadata.find(value => value.className === className);
    }

    static getCamelLanguageMetadataByClassName = (className: string): ElementMeta | undefined => {
        return CamelLanguageMetadata.find(value => value.className === className);
    }

    static getCamelLanguageMetadataByName = (name: string): ElementMeta | undefined => {
        return CamelLanguageMetadata.find(value => value.name === name);
    }

    static getLanguage = (name: string): [string, string, string] | undefined => {
        return Languages.find(value => value[0] === name);
    }

    static hasLanguage = (name: string): boolean | undefined => {
        return Languages.filter(value => value[0] === name).length > 0;
    }
}
