/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';

export function KaravanIcon(className?: string) {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
            id="svg50"
            width={32}
            height={32}
            preserveAspectRatio="xMidYMid"
            version="1.1"
            viewBox="0 0 256 256"
            className={className ? className : "logo"}
        >
            <defs id="defs31">
                <linearGradient id="linearGradient1351">
                    <stop
                        id="stop1347"
                        offset="0"
                        stopColor="#dcffff"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop1349"
                        offset="1"
                        stopColor="#96d2e6"
                        stopOpacity="1"
                    ></stop>
                </linearGradient>
                <circle id="path-1" cx="128" cy="128" r="128"></circle>
                <linearGradient
                    id="linearGradient-3"
                    x1="-26.051"
                    x2="254.316"
                    y1="271.331"
                    y2="0.048"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop
                        id="stop10"
                        offset="0%"
                        stopColor="#4790bb"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop12"
                        offset="10.996%"
                        stopColor="#64b7db"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop14"
                        offset="94.502%"
                        stopColor="#326ea0"
                        stopOpacity="1"
                    ></stop>
                </linearGradient>
                <linearGradient
                    id="linearGradient-4"
                    x1="-32.163"
                    x2="259.338"
                    y1="277.029"
                    y2="-5.028"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop id="stop17" offset="0%" stopColor="#F69923"></stop>
                    <stop id="stop19" offset="8.048%" stopColor="#F79A23"></stop>
                    <stop id="stop21" offset="41.874%" stopColor="#E97826"></stop>
                </linearGradient>
                <linearGradient
                    id="linearGradient-5"
                    x1="217.945"
                    x2="99.459"
                    y1="67.505"
                    y2="247.005"
                    gradientTransform="scale(.96442 1.0369)"
                    gradientUnits="userSpaceOnUse"
                    xlinkHref="#linearGradient-4"
                >
                    <stop
                        id="stop24"
                        offset="0%"
                        stopColor="#92d6d5"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop26"
                        offset="41.191%"
                        stopColor="#79b7cc"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop28"
                        offset="73.271%"
                        stopColor="#5891c5"
                        stopOpacity="1"
                    ></stop>
                </linearGradient>
                <mask id="mask-2" fill="#fff">
                    <use id="use33" xlinkHref="#path-1"></use>
                </mask>
                <mask id="mask-2-7" fill="#fff">
                    <use id="use137" xlinkHref="#path-1"></use>
                </mask>
                <linearGradient
                    id="linearGradient1345"
                    x1="233.122"
                    x2="2.24"
                    y1="56.015"
                    y2="242.78"
                    gradientUnits="userSpaceOnUse"
                    xlinkHref="#linearGradient1351"
                ></linearGradient>
            </defs>
            <circle
                id="circle38"
                cx="127.994"
                cy="127.994"
                r="123.111"
                fill="url(#linearGradient-3)"
                fillRule="nonzero"
                mask="url(#mask-2)"
            ></circle>
            <g id="g2266">
                <path
                    id="path42"
                    fill="url(#linearGradient-5)"
                    fillOpacity="1"
                    fillRule="nonzero"
                    d="M98.044 75.517c-1.751-.002-3.524.01-5.292.061-2.056.06-4.817.713-8 1.785 53.775 40.834 73.108 114.497 39.875 178.514 1.129.03 2.249.123 3.385.123 60.736 0 111.492-42.323 124.609-99.071-38.542-45.178-90.813-81.314-154.578-81.412z"
                    mask="url(#mask-2)"
                    opacity="0.75"
                ></path>
            </g>
            <path
                id="path44"
                fill="#1e4b7b"
                fillOpacity="1"
                fillRule="nonzero"
                d="M84.752 77.368C66.895 83.378 32.83 104.546.079 132.81c2.487 67.334 57.028 121.313 124.548 123.07 33.233-64.016 13.901-137.68-39.875-178.513z"
                mask="url(#mask-2)"
                opacity="0.75"
            ></path>
            <path
                id="path150"
                fill="url(#linearGradient1345)"
                fillOpacity="1"
                fillRule="nonzero"
                d="M128.747 54.005c-10.985 5.495 0 27.466 0 27.466C95.774 108.954 102.78 155.9 64.312 155.9c-20.97 0-42.242-24.077-64.233-38.828-.283 3.479-.785 6.972-.785 10.524 0 48.095 26.263 89.924 65.42 111.897 10.952-1.38 22.838-4.114 31.05-9.592 43.146-28.765 53.857-83.491 71.487-109.925 10.979-16.492 62.434-15.061 65.906-22.01 5.502-10.991-10.99-27.467-16.491-27.467h-43.958c-3.071 0-7.897-5.456-10.974-5.456h-16.492s-7.307-11.085-13.794-11.526c-.93-.066-1.83.053-2.7.488z"
                mask="url(#mask-2-7)"
                transform="translate(-.769 -.133)"
            ></path>
            <path
                id="path40"
                fill="#2d4150"
                fillOpacity="1"
                fillRule="nonzero"
                d="M128 256C57.308 256 0 198.692 0 128 0 57.308 57.308 0 128 0c70.692 0 128 57.308 128 128 0 70.692-57.308 128-128 128zm0-9.768c65.298 0 118.232-52.934 118.232-118.232S193.298 9.768 128 9.768 9.768 62.702 9.768 128 62.702 246.232 128 246.232z"
                mask="url(#mask-2)"
                transform="translate(-.59) scale(1.00078)"
            ></path>
        </svg>
    );
}

export function CamelIcon(props?: (JSX.IntrinsicAttributes & React.SVGProps<SVGSVGElement>) | undefined) {
    return (<svg
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
            preserveAspectRatio="xMidYMid"
            viewBox="0 0 256 256"
            {...props}
            className="icon" width="32px" height="32px">
            <defs>
                <linearGradient
                    id="b"
                    x1="-12.564%"
                    x2="101.304%"
                    y1="108.214%"
                    y2="-1.964%"
                >
                    <stop offset="0%" stopColor="#F69923"/>
                    <stop offset="10.996%" stopColor="#F79A23"/>
                    <stop offset="94.502%" stopColor="#E97826"/>
                </linearGradient>
                <linearGradient
                    id="d"
                    x1="-12.564%"
                    x2="101.304%"
                    y1="108.214%"
                    y2="-1.964%"
                >
                    <stop offset="0%" stopColor="#F69923"/>
                    <stop offset="8.048%" stopColor="#F79A23"/>
                    <stop offset="41.874%" stopColor="#E97826"/>
                </linearGradient>
                <linearGradient
                    id="e"
                    x1="74.724%"
                    x2="6.653%"
                    y1="-3.059%"
                    y2="100.066%"
                >
                    <stop offset="0%" stopColor="#F6E423"/>
                    <stop offset="41.191%" stopColor="#F79A23"/>
                    <stop offset="73.271%" stopColor="#E97826"/>
                </linearGradient>
                <circle id="a" cx={128} cy={128} r={128}/>
            </defs>
            <mask id="c" fill="#fff">
                <use xlinkHref="#a"/>
            </mask>
            <circle
                cx={127.994}
                cy={127.994}
                r={123.111}
                fill="url(#b)"
                mask="url(#c)"
            />
            <path
                fill="url(#d)"
                d="M128 256C57.308 256 0 198.692 0 128 0 57.308 57.308 0 128 0c70.692 0 128 57.308 128 128 0 70.692-57.308 128-128 128Zm0-9.768c65.298 0 118.232-52.934 118.232-118.232S193.298 9.768 128 9.768 9.768 62.702 9.768 128 62.702 246.232 128 246.232Z"
                mask="url(#c)"
            />
            <path
                fill="url(#e)"
                d="M98.044 75.517c-1.751-.002-3.524.01-5.292.061-2.056.06-4.817.713-8 1.785 53.775 40.834 73.108 114.497 39.875 178.514 1.129.03 2.249.123 3.385.123 60.736 0 111.492-42.323 124.609-99.071-38.542-45.178-90.813-81.314-154.578-81.412Z"
                mask="url(#c)"
                opacity={0.75}
            />
            <path
                fill="#28170B"
                d="M84.752 77.368C66.895 83.378 32.83 104.546.079 132.81c2.487 67.334 57.028 121.313 124.548 123.07 33.233-64.016 13.901-137.68-39.875-178.513Z"
                mask="url(#c)"
                opacity={0.75}
            />
            <path
                fill="#FFF"
                d="M128.747 54.005c-10.985 5.495 0 27.466 0 27.466C95.774 108.954 102.78 155.9 64.312 155.9c-20.97 0-42.242-24.077-64.233-38.828-.283 3.479-.785 6.972-.785 10.524 0 48.095 26.263 89.924 65.42 111.897 10.952-1.38 22.838-4.114 31.05-9.592 43.146-28.765 53.857-83.491 71.487-109.925 10.979-16.492 62.434-15.061 65.906-22.01 5.502-10.991-10.99-27.467-16.491-27.467h-43.958c-3.071 0-7.897-5.456-10.974-5.456h-16.492s-7.307-11.085-13.794-11.526c-.93-.066-1.83.053-2.7.488Z"
                mask="url(#c)"
            />
        </svg>
    );
}

export function getDesignerIcon(icon: string): React.JSX.Element {
    if (icon === 'kamelet') return (
        <svg
            className="top-icon" id="icon"
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
        >
            <title>{"application"}</title>
            <path d="M16 18H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2ZM6 6v10h10V6ZM26 12v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2ZM26 22v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2ZM16 22v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2Z" />
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
        )
    if (icon === 'code') return (
        <svg

            xmlns="http://www.w3.org/2000/svg"
            width="24"
            height="24"
            fill="none"
            viewBox="0 0 24 24"
        >
            <path
                fill="#000000"
                d="M8.502 5.387a.75.75 0 00-1.004-1.115L5.761 5.836c-.737.663-1.347 1.212-1.767 1.71-.44.525-.754 1.088-.754 1.784 0 .695.313 1.258.754 1.782.42.499 1.03 1.049 1.767 1.711l1.737 1.564a.75.75 0 101.004-1.115l-1.697-1.527c-.788-.709-1.319-1.19-1.663-1.598-.33-.393-.402-.622-.402-.817 0-.196.072-.425.402-.818.344-.409.875-.889 1.663-1.598l1.697-1.527zM14.18 4.275a.75.75 0 01.532.918l-3.987 15a.75.75 0 11-1.45-.386l3.987-15a.75.75 0 01.918-.532zM15.443 10.498a.75.75 0 011.059-.055l1.737 1.563c.737.663 1.347 1.213 1.767 1.711.44.524.754 1.088.754 1.783 0 .695-.313 1.259-.754 1.783-.42.498-1.03 1.048-1.767 1.71l-1.737 1.565a.75.75 0 11-1.004-1.116l1.697-1.526c.788-.71 1.319-1.19 1.663-1.599.33-.392.402-.622.402-.817 0-.195-.072-.425-.402-.817-.344-.41-.875-.89-1.663-1.599l-1.697-1.527a.75.75 0 01-.055-1.059z"
            ></path>
        </svg>
    )
    if (icon === 'routes') return (
        <svg className="top-icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <defs>
                <style>{".cls-1{fill:none;}"}</style>
            </defs>
            <path
                d="M29,10H24v2h5v6H22v2h3v2.142a4,4,0,1,0,2,0V20h2a2.0027,2.0027,0,0,0,2-2V12A2.0023,2.0023,0,0,0,29,10ZM28,26a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,28,26Z"/>
            <path
                d="M19,6H14V8h5v6H12v2h3v6.142a4,4,0,1,0,2,0V16h2a2.0023,2.0023,0,0,0,2-2V8A2.0023,2.0023,0,0,0,19,6ZM18,26a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,18,26Z"/>
            <path
                d="M9,2H3A2.002,2.002,0,0,0,1,4v6a2.002,2.002,0,0,0,2,2H5V22.142a4,4,0,1,0,2,0V12H9a2.002,2.002,0,0,0,2-2V4A2.002,2.002,0,0,0,9,2ZM8,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,26ZM3,10V4H9l.0015,6Z"/>
            <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" className="cls-1" width="32"
                  height="32"/>
        </svg>)
    if (icon === 'route') return (
        <svg className="top-icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <title>{"category"}</title>
            <path d="M27 22.141V18a2 2 0 0 0-2-2h-8v-4h2a2.002 2.002 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2h-6a2.002 2.002 0 0 0-2 2v6a2.002 2.002 0 0 0 2 2h2v4H7a2 2 0 0 0-2 2v4.142a4 4 0 1 0 2 0V18h8v4.142a4 4 0 1 0 2 0V18h8v4.141a4 4 0 1 0 2 0ZM13 4h6l.001 6H13ZM8 26a2 2 0 1 1-2-2 2.002 2.002 0 0 1 2 2Zm10 0a2 2 0 1 1-2-2 2.003 2.003 0 0 1 2 2Zm8 2a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2Z" />
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    )
    if (icon === 'rest') return (
        <svg className="top-icon" viewBox="0 0 32 32" width="32px" height="32px">
            <g className="layer">
                <title>Layer 1</title>
                <path
                    d="m23.50007,22l-0.5,0l0,-2l0.5,0a4.4975,4.4975 0 0 0 0.3564,-8.981l-0.8154,-0.0639l-0.0986,-0.812a6.9938,6.9938 0 0 0 -13.8838,0l-0.0991,0.812l-0.8155,0.0639a4.4975,4.4975 0 0 0 0.356,8.981l0.5,0l0,2l-0.5,0a6.4973,6.4973 0 0 1 -1.3,-12.8638a8.9943,8.9943 0 0 1 17.6006,0a6.4974,6.4974 0 0 1 -1.3006,12.8638z"
                    id="svg_1"/>
                <path
                    d="m22.9724,22.26637l0,-2l-2.1011,0a4.9678,4.9678 0 0 0 -0.7319,-1.7529l1.49,-1.49l-1.414,-1.414l-1.49,1.49a4.9678,4.9678 0 0 0 -1.753,-0.732l0,-2.1011l-2,0l0,2.1011a4.9678,4.9678 0 0 0 -1.7529,0.7319l-1.49,-1.49l-1.414,1.414l1.49,1.49a4.9678,4.9678 0 0 0 -0.732,1.753l-2.1011,0l0,2l2.1011,0a4.9678,4.9678 0 0 0 0.7319,1.7529l-1.49,1.49l1.414,1.414l1.49,-1.49a4.9678,4.9678 0 0 0 1.753,0.732l0,2.1011l2,0l0,-2.1011a4.9678,4.9678 0 0 0 1.7529,-0.7319l1.49,1.49l1.414,-1.414l-1.49,-1.49a4.9678,4.9678 0 0 0 0.732,-1.753l2.1011,0zm-7,2a3,3 0 1 1 3,-3a3.0033,3.0033 0 0 1 -3,3z"
                    id="svg_2" transform="rotate(25 15.9724 21.2664)" xmlns="http://www.w3.org/2000/svg"/>
            </g>
        </svg>
    )
    if (icon === 'beans') return (
        <svg className="top-icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <defs>
                <style>{".cls-1 {fill: none;}"}</style>
            </defs>
            <title>data--1</title>
            <rect x="15" y="6" width="13" height="2"/>
            <rect x="15" y="24" width="13" height="2"/>
            <rect x="4" y="15" width="13" height="2"/>
            <path d="M7,11a4,4,0,1,1,4-4A4,4,0,0,1,7,11ZM7,5A2,2,0,1,0,9,7,2,2,0,0,0,7,5Z" transform="translate(0 0)"/>
            <path d="M7,29a4,4,0,1,1,4-4A4,4,0,0,1,7,29Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,7,23Z" transform="translate(0 0)"/>
            <path d="M25,20a4,4,0,1,1,4-4A4,4,0,0,1,25,20Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,25,14Z"
                  transform="translate(0 0)"/>
            <g id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;">
                <rect className="cls-1" width="32" height="32"/>
            </g>
        </svg>
    )
    if (icon === 'dependencies') return (
        <svg className="top-icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <defs>
                <style>{".cls-1 {fill: none;}"}</style>
            </defs>
            <title>application</title>
            <path d="M16,18H6a2,2,0,0,1-2-2V6A2,2,0,0,1,6,4H16a2,2,0,0,1,2,2V16A2,2,0,0,1,16,18ZM6,6V16H16V6Z"
                  transform="translate(0 0)"/>
            <path d="M26,12v4H22V12h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V12a2,2,0,0,0-2-2Z"
                  transform="translate(0 0)"/>
            <path d="M26,22v4H22V22h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"
                  transform="translate(0 0)"/>
            <path d="M16,22v4H12V22h4m0-2H12a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"
                  transform="translate(0 0)"/>
            <g id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;">
                <rect className="cls-1" width="32" height="32"/>
            </g>
        </svg>
    )
    if (icon === 'error') return (
        <svg className="top-icon" width="36px" height="36px" viewBox="0 0 36 36" version="1.1"
             preserveAspectRatio="xMidYMid meet">
            <circle className="clr-i-outline clr-i-outline-path-1" cx="18" cy="26.06" r="1.33"/>
            <path className="clr-i-outline clr-i-outline-path-2"
                  d="M18,22.61a1,1,0,0,1-1-1v-12a1,1,0,1,1,2,0v12A1,1,0,0,1,18,22.61Z"/>
            <path className="clr-i-outline clr-i-outline-path-3"
                  d="M18,34A16,16,0,1,1,34,18,16,16,0,0,1,18,34ZM18,4A14,14,0,1,0,32,18,14,14,0,0,0,18,4Z"/>
            <rect x="0" y="0" width="36" height="36" fillOpacity="0"/>
        </svg>)
    if (icon === 'exception') return (
        <svg className="top-icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <defs>
                <style>{".cls-1{fill:none;}"}</style>
            </defs>
            <title>misuse--alt</title>
            <polygon
                points="21.41 23 16 17.591 10.59 23 9 21.41 14.409 16 9 10.591 10.591 9 16 14.409 21.409 9 23 10.591 17.591 16 23 21.41 21.41 23"/>
            <path d="M16,4A12,12,0,1,1,4,16,12.0136,12.0136,0,0,1,16,4m0-2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Z"
                  transform="translate(0)"/>
            <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" className="cls-1" width="32"
                  height="32"/>
        </svg>)
    if (icon === 'routeConfiguration') return (
        <svg className="top-icon" width="32" height="32" viewBox="0 0 32 32">
            <defs>
                <style>{".cls-1{fill:none;}"}</style>
            </defs>
            <path
                d="M28.83 21.17L25 17.37l.67-.67a1 1 0 000-1.41l-6-6a1 1 0 00-1.41 0l-.79.79-6.76-6.79a1 1 0 00-1.41 0l-4 4-.12.15-4 6a1 1 0 00.12 1.26l3 3a1 1 0 001.42 0L10 13.41l2.09 2.09-4.8 4.79a1 1 0 000 1.41l2 2a1 1 0 00.71.3 1 1 0 00.52-.15l4.33-2.6 2.44 2.45a1 1 0 001.41 0l.67-.7 3.79 3.83a4 4 0 005.66-5.66zM10 10.58l-5 5-1.71-1.71 3.49-5.24L10 5.41l6.09 6.09-2.59 2.58zm8 11l-2.84-2.84-5 3-.74-.74L19 11.41 23.59 16zm9.42 3.83a2 2 0 01-2.83 0l-3.8-3.79 2.83-2.83 3.8 3.79a2 2 0 010 2.83z"></path>
            <path
                d="M0 0H32V32H0z"
                className="cls-1"
                data-name="&lt;Transparent Rectangle&gt;"
            ></path>
        </svg>)
    if (icon === 'yaml') return (
        <svg className="top-icon" x="0px" y="0px" width="32px" height="32px"
             viewBox="0 0 32 32">
            <style type="text/css">{".st0{fill:none;}"}</style>
            <title>document</title>
            <path
                d="M25.7,9.3l-7-7C18.5,2.1,18.3,2,18,2H8C6.9,2,6,2.9,6,4v24c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V10C26,9.7,25.9,9.5,25.7,9.3  z M18,4.4l5.6,5.6H18V4.4z M24,28H8V4h8v6c0,1.1,0.9,2,2,2h6V28z"/>
            <rect x="10" y="22" width="12" height="2"/>
            <rect x="10" y="16" width="12" height="2"/>
            <rect className="st0" width="32" height="32"/>
        </svg>)
    if (icon === 'code') return (
        <svg className="top-icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <defs>
                <style>{".cls-1{fill:none;}"}</style>
            </defs>
            <title>code</title>
            <polygon points="31 16 24 23 22.59 21.59 28.17 16 22.59 10.41 24 9 31 16"/>
            <polygon points="1 16 8 9 9.41 10.41 3.83 16 9.41 21.59 8 23 1 16"/>
            <rect x="5.91" y="15" width="20.17" height="2" transform="translate(-3.6 27.31) rotate(-75)"/>
            <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" className="cls-1" width="32"
                  height="32" transform="translate(0 32) rotate(-90)"/>
        </svg>)
    return <></>;
}


export class BeanIcon extends React.Component<any> {

    render() {
        return (
            <svg className="icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
                <defs>
                    <style>{".cls-1 {fill: none;}"}</style>
                </defs>
                <title>data--1</title>
                <rect x="15" y="6" width="13" height="2"/>
                <rect x="15" y="24" width="13" height="2"/>
                <rect x="4" y="15" width="13" height="2"/>
                <path d="M7,11a4,4,0,1,1,4-4A4,4,0,0,1,7,11ZM7,5A2,2,0,1,0,9,7,2,2,0,0,0,7,5Z"
                      transform="translate(0 0)"/>
                <path d="M7,29a4,4,0,1,1,4-4A4,4,0,0,1,7,29Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,7,23Z"
                      transform="translate(0 0)"/>
                <path d="M25,20a4,4,0,1,1,4-4A4,4,0,0,1,25,20Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,25,14Z"
                      transform="translate(0 0)"/>
                <g id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;">
                    <rect className="cls-1" width="32" height="32"/>
                </g>
            </svg>
        )
    }
}

export class DependencyIcon extends React.Component<any> {

    render() {
        return (
            <svg className="icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
                <defs>
                    <style>{".cls-1 {fill: none;}"}</style>
                </defs>
                <title>application</title>
                <path d="M16,18H6a2,2,0,0,1-2-2V6A2,2,0,0,1,6,4H16a2,2,0,0,1,2,2V16A2,2,0,0,1,16,18ZM6,6V16H16V6Z"
                      transform="translate(0 0)"/>
                <path d="M26,12v4H22V12h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V12a2,2,0,0,0-2-2Z"
                      transform="translate(0 0)"/>
                <path d="M26,22v4H22V22h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"
                      transform="translate(0 0)"/>
                <path d="M16,22v4H12V22h4m0-2H12a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"
                      transform="translate(0 0)"/>
                <g id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;">
                    <rect className="cls-1" width="32" height="32"/>
                </g>
            </svg>
        )
    }
}

export class RestIcon extends React.Component<any> {

    render() {
        return (
            <svg className="icon" width="32px" height="32px" viewBox="0 0 32 32">
                <g className="layer">
                    <title>Layer 1</title>
                    <path
                        d="m23.50007,22l-0.5,0l0,-2l0.5,0a4.4975,4.4975 0 0 0 0.3564,-8.981l-0.8154,-0.0639l-0.0986,-0.812a6.9938,6.9938 0 0 0 -13.8838,0l-0.0991,0.812l-0.8155,0.0639a4.4975,4.4975 0 0 0 0.356,8.981l0.5,0l0,2l-0.5,0a6.4973,6.4973 0 0 1 -1.3,-12.8638a8.9943,8.9943 0 0 1 17.6006,0a6.4974,6.4974 0 0 1 -1.3006,12.8638z"
                        id="svg_1"/>
                    <path
                        d="m22.9724,22.26637l0,-2l-2.1011,0a4.9678,4.9678 0 0 0 -0.7319,-1.7529l1.49,-1.49l-1.414,-1.414l-1.49,1.49a4.9678,4.9678 0 0 0 -1.753,-0.732l0,-2.1011l-2,0l0,2.1011a4.9678,4.9678 0 0 0 -1.7529,0.7319l-1.49,-1.49l-1.414,1.414l1.49,1.49a4.9678,4.9678 0 0 0 -0.732,1.753l-2.1011,0l0,2l2.1011,0a4.9678,4.9678 0 0 0 0.7319,1.7529l-1.49,1.49l1.414,1.414l1.49,-1.49a4.9678,4.9678 0 0 0 1.753,0.732l0,2.1011l2,0l0,-2.1011a4.9678,4.9678 0 0 0 1.7529,-0.7319l1.49,1.49l1.414,-1.414l-1.49,-1.49a4.9678,4.9678 0 0 0 0.732,-1.753l2.1011,0zm-7,2a3,3 0 1 1 3,-3a3.0033,3.0033 0 0 1 -3,3z"
                        id="svg_2" transform="rotate(25 15.9724 21.2664)" xmlns="http://www.w3.org/2000/svg"/>
                </g>
            </svg>
        )
    }
}

export class ConceptIcon extends React.Component<any> {

    render() {
        return (
            <svg className="icon" width="32px" height="32px" viewBox="0 0 32 32">
                <defs>
                    <style>{".cls-1 {fill: none;}"}</style>
                </defs>
                <title>concept</title>
                <path
                    d="M20.8851,19.4711a5.9609,5.9609,0,0,0,0-6.9422L23,10.4141l1.293,1.2929a.9995.9995,0,0,0,1.414,0l4-4a.9994.9994,0,0,0,0-1.414l-4-4a.9994.9994,0,0,0-1.414,0l-4,4a.9994.9994,0,0,0,0,1.414L21.5859,9l-2.1148,2.1149a5.9609,5.9609,0,0,0-6.9422,0L10,8.5859V2H2v8H8.5859l2.529,2.5289a5.9609,5.9609,0,0,0,0,6.9422L9,21.5859,7.707,20.293a.9994.9994,0,0,0-1.414,0l-4,4a.9994.9994,0,0,0,0,1.414l4,4a.9995.9995,0,0,0,1.414,0l4-4a.9994.9994,0,0,0,0-1.414L10.4141,23l2.1148-2.1149a5.9609,5.9609,0,0,0,6.9422,0L22,23.4141V30h8V22H23.4141ZM25,4.4141,27.5859,7,25,9.5859,22.4141,7ZM7,27.5859,4.4141,25,7,22.4141,9.5859,25ZM8,8H4V4H8Zm4,8a4,4,0,1,1,4,4A4.0045,4.0045,0,0,1,12,16Zm12,8h4v4H24Z"/>
                <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" className="cls-1"
                      width="32" height="32"/>
            </svg>
        )
    }
}