/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Generated by karavan build tools - do NOT edit this file!
 */
import {v4 as uuidv4} from 'uuid';
import {CamelElement} from "./IntegrationDefinition";
export class ProcessorDefinition extends CamelElement {
    stepName?: string = 'processor';
    aggregate?: AggregateDefinition;
    bean?: BeanDefinition | string;
    doCatch?: CatchDefinition;
    choice?: ChoiceDefinition;
    circuitBreaker?: CircuitBreakerDefinition;
    claimCheck?: ClaimCheckDefinition;
    convertBodyTo?: ConvertBodyDefinition | string;
    convertHeaderTo?: ConvertHeaderDefinition;
    delay?: DelayDefinition;
    dynamicRouter?: DynamicRouterDefinition;
    enrich?: EnrichDefinition;
    filter?: FilterDefinition;
    doFinally?: FinallyDefinition;
    idempotentConsumer?: IdempotentConsumerDefinition;
    kamelet?: KameletDefinition | string;
    loadBalance?: LoadBalanceDefinition;
    log?: LogDefinition | string;
    loop?: LoopDefinition;
    marshal?: MarshalDefinition;
    multicast?: MulticastDefinition;
    onFallback?: OnFallbackDefinition;
    otherwise?: OtherwiseDefinition;
    pausable?: PausableDefinition;
    pipeline?: PipelineDefinition;
    policy?: PolicyDefinition;
    pollEnrich?: PollEnrichDefinition;
    process?: ProcessDefinition;
    recipientList?: RecipientListDefinition;
    removeHeader?: RemoveHeaderDefinition | string;
    removeHeaders?: RemoveHeadersDefinition | string;
    removeProperties?: RemovePropertiesDefinition | string;
    removeProperty?: RemovePropertyDefinition | string;
    resequence?: ResequenceDefinition;
    resumable?: ResumableDefinition;
    rollback?: RollbackDefinition | string;
    routingSlip?: RoutingSlipDefinition | string;
    saga?: SagaDefinition;
    sample?: SamplingDefinition | string;
    script?: ScriptDefinition;
    setBody?: SetBodyDefinition;
    setExchangePattern?: SetExchangePatternDefinition | string;
    setHeader?: SetHeaderDefinition;
    setHeaders?: SetHeadersDefinition;
    setProperty?: SetPropertyDefinition;
    sort?: SortDefinition;
    split?: SplitDefinition;
    step?: StepDefinition;
    stop?: StopDefinition;
    threads?: ThreadsDefinition;
    throttle?: ThrottleDefinition;
    throwException?: ThrowExceptionDefinition;
    to?: string;
    toD?: string;
    transacted?: TransactedDefinition;
    transform?: TransformDefinition;
    doTry?: TryDefinition;
    unmarshal?: UnmarshalDefinition;
    validate?: ValidateDefinition;
    when?: WhenDefinition;
    whenSkipSendToEndpoint?: WhenSkipSendToEndpointDefinition;
    wireTap?: WireTapDefinition;
    serviceCall?: ServiceCallDefinition | string;
    public constructor(init?: Partial<ProcessorDefinition>) {
        super('ProcessorDefinition');
        Object.assign(this, init);
    }
}

export class BeansDeserializer extends CamelElement {

    public constructor(init?: Partial<BeansDeserializer>) {
        super('BeansDeserializer');
        Object.assign(this, init);
    }
}

export class ErrorHandlerBuilderDeserializer extends CamelElement {
    deadLetterChannel?: DeadLetterChannelDefinition;
    defaultErrorHandler?: DefaultErrorHandlerDefinition;
    jtaTransactionErrorHandler?: JtaTransactionErrorHandlerDefinition;
    noErrorHandler?: NoErrorHandlerDefinition;
    refErrorHandler?: RefErrorHandlerDefinition | string;
    springTransactionErrorHandler?: SpringTransactionErrorHandlerDefinition;
    public constructor(init?: Partial<ErrorHandlerBuilderDeserializer>) {
        super('ErrorHandlerBuilderDeserializer');
        Object.assign(this, init);
    }
}

export class OutputAwareFromDefinition extends CamelElement {
    stepName?: string = 'outputAwareFrom';
    description?: string;
    id?: string = 'outputAwareFrom-' + uuidv4().substring(0,4);
    parameters?: any = {};
    steps: CamelElement[] = [];
    uri: string = '';
    public constructor(init?: Partial<OutputAwareFromDefinition>) {
        super('OutputAwareFromDefinition');
        Object.assign(this, init);
    }
}

export class AggregateDefinition extends CamelElement {
    stepName?: string = 'aggregate';
    id?: string = 'aggregate-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    correlationExpression?: ExpressionSubElementDefinition;
    completionPredicate?: ExpressionSubElementDefinition;
    completionTimeoutExpression?: ExpressionSubElementDefinition;
    completionSizeExpression?: ExpressionSubElementDefinition;
    optimisticLockRetryPolicy?: OptimisticLockRetryPolicyDefinition;
    parallelProcessing?: boolean;
    optimisticLocking?: boolean;
    executorService?: string;
    timeoutCheckerExecutorService?: string;
    aggregateController?: string;
    aggregationRepository?: string;
    aggregationStrategy: string = '';
    aggregationStrategyMethodName?: string;
    aggregationStrategyMethodAllowNull?: boolean;
    completionSize?: number;
    completionInterval?: string;
    completionTimeout?: string;
    completionTimeoutCheckerInterval?: string;
    completionFromBatchConsumer?: boolean;
    completionOnNewCorrelationGroup?: boolean;
    eagerCheckCompletion?: boolean;
    ignoreInvalidCorrelationKeys?: boolean;
    closeCorrelationKeyOnCompletion?: number;
    discardOnCompletionTimeout?: boolean;
    discardOnAggregationFailure?: boolean;
    forceCompletionOnStop?: boolean;
    completeAllOnStop?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<AggregateDefinition>) {
        super('AggregateDefinition');
        Object.assign(this, init);
    }
}

export class BeanDefinition extends CamelElement {
    stepName?: string = 'bean';
    id?: string = 'bean-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    ref?: string;
    method?: string;
    beanType?: string;
    scope?: string;
    public constructor(init?: Partial<BeanDefinition>) {
        super('BeanDefinition');
        Object.assign(this, init);
    }
}

export class CatchDefinition extends CamelElement {
    stepName?: string = 'doCatch';
    id?: string = 'doCatch-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    exception?: string[] = [];
    onWhen?: WhenDefinition;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<CatchDefinition>) {
        super('CatchDefinition');
        Object.assign(this, init);
    }
}

export class ChoiceDefinition extends CamelElement {
    stepName?: string = 'choice';
    id?: string = 'choice-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    when?: WhenDefinition[] = [];
    otherwise?: OtherwiseDefinition;
    precondition?: boolean;
    public constructor(init?: Partial<ChoiceDefinition>) {
        super('ChoiceDefinition');
        Object.assign(this, init);
    }
}

export class CircuitBreakerDefinition extends CamelElement {
    stepName?: string = 'circuitBreaker';
    id?: string = 'circuitBreaker-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    configuration?: string;
    resilience4jConfiguration?: Resilience4jConfigurationDefinition;
    faultToleranceConfiguration?: FaultToleranceConfigurationDefinition;
    onFallback?: OnFallbackDefinition;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<CircuitBreakerDefinition>) {
        super('CircuitBreakerDefinition');
        Object.assign(this, init);
    }
}

export class ClaimCheckDefinition extends CamelElement {
    stepName?: string = 'claimCheck';
    id?: string = 'claimCheck-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    operation?: string;
    key?: string;
    filter?: string;
    aggregationStrategy?: string;
    aggregationStrategyMethodName?: string;
    public constructor(init?: Partial<ClaimCheckDefinition>) {
        super('ClaimCheckDefinition');
        Object.assign(this, init);
    }
}

export class ContextScanDefinition extends CamelElement {
    stepName?: string = 'contextScan';
    includeNonSingletons?: boolean;
    excludes?: string[] = [];
    includes?: string[] = [];
    public constructor(init?: Partial<ContextScanDefinition>) {
        super('ContextScanDefinition');
        Object.assign(this, init);
    }
}

export class ConvertBodyDefinition extends CamelElement {
    stepName?: string = 'convertBodyTo';
    id?: string = 'convertBodyTo-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    type: string = '';
    mandatory?: boolean;
    charset?: string;
    public constructor(init?: Partial<ConvertBodyDefinition>) {
        super('ConvertBodyDefinition');
        Object.assign(this, init);
    }
}

export class ConvertHeaderDefinition extends CamelElement {
    stepName?: string = 'convertHeaderTo';
    id?: string = 'convertHeaderTo-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    name: string = '';
    type: string = '';
    mandatory?: boolean;
    charset?: string;
    public constructor(init?: Partial<ConvertHeaderDefinition>) {
        super('ConvertHeaderDefinition');
        Object.assign(this, init);
    }
}

export class DataFormatDefinition extends CamelElement {
    stepName?: string = 'dataFormat';
    id?: string = 'dataFormat-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<DataFormatDefinition>) {
        super('DataFormatDefinition');
        Object.assign(this, init);
    }
}

export class DelayDefinition extends CamelElement {
    stepName?: string = 'delay';
    id?: string = 'delay-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    asyncDelayed?: boolean;
    callerRunsWhenRejected?: boolean;
    executorService?: string;
    public constructor(init?: Partial<DelayDefinition>) {
        super('DelayDefinition');
        Object.assign(this, init);
    }
}

export class DynamicRouterDefinition extends CamelElement {
    stepName?: string = 'dynamicRouter';
    id?: string = 'dynamicRouter-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    uriDelimiter?: string;
    ignoreInvalidEndpoints?: boolean;
    cacheSize?: number;
    public constructor(init?: Partial<DynamicRouterDefinition>) {
        super('DynamicRouterDefinition');
        Object.assign(this, init);
    }
}

export class EnrichDefinition extends CamelElement {
    stepName?: string = 'enrich';
    id?: string = 'enrich-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    aggregationStrategy?: string;
    aggregationStrategyMethodName?: string;
    aggregationStrategyMethodAllowNull?: string;
    aggregateOnException?: boolean;
    shareUnitOfWork?: boolean;
    cacheSize?: number;
    ignoreInvalidEndpoint?: boolean;
    allowOptimisedComponents?: boolean;
    public constructor(init?: Partial<EnrichDefinition>) {
        super('EnrichDefinition');
        Object.assign(this, init);
    }
}

export class ErrorHandlerDefinition extends CamelElement {
    stepName?: string = 'errorHandler';
    id?: string = 'errorHandler-' + uuidv4().substring(0,4);
    deadLetterChannel?: DeadLetterChannelDefinition;
    defaultErrorHandler?: DefaultErrorHandlerDefinition;
    jtaTransactionErrorHandler?: JtaTransactionErrorHandlerDefinition;
    noErrorHandler?: NoErrorHandlerDefinition;
    springTransactionErrorHandler?: SpringTransactionErrorHandlerDefinition;
    public constructor(init?: Partial<ErrorHandlerDefinition>) {
        super('ErrorHandlerDefinition');
        Object.assign(this, init);
    }
}

export class ExpressionSubElementDefinition extends CamelElement {
    stepName?: string = 'expressionSubElement';
    constant?: ConstantExpression | string;
    csimple?: CSimpleExpression | string;
    datasonnet?: DatasonnetExpression | string;
    exchangeProperty?: ExchangePropertyExpression | string;
    groovy?: GroovyExpression | string;
    header?: HeaderExpression | string;
    hl7terser?: Hl7TerserExpression | string;
    java?: JavaExpression | string;
    joor?: JoorExpression | string;
    jq?: JqExpression | string;
    js?: JavaScriptExpression | string;
    jsonpath?: JsonPathExpression | string;
    language?: LanguageExpression;
    method?: MethodCallExpression | string;
    mvel?: MvelExpression | string;
    ognl?: OgnlExpression | string;
    python?: PythonExpression | string;
    ref?: RefExpression | string;
    simple?: SimpleExpression | string;
    spel?: SpELExpression | string;
    tokenize?: TokenizerExpression | string;
    xpath?: XPathExpression | string;
    xquery?: XQueryExpression | string;
    xtokenize?: XMLTokenizerExpression | string;
    public constructor(init?: Partial<ExpressionSubElementDefinition>) {
        super('ExpressionSubElementDefinition');
        Object.assign(this, init);
    }
}

export class FaultToleranceConfigurationDefinition extends CamelElement {
    stepName?: string = 'faultToleranceConfiguration';
    id?: string = 'faultToleranceConfiguration-' + uuidv4().substring(0,4);
    circuitBreaker?: string;
    delay?: string;
    successThreshold?: number;
    requestVolumeThreshold?: number;
    failureRatio?: number;
    timeoutEnabled?: boolean;
    timeoutDuration?: string;
    timeoutPoolSize?: number;
    timeoutScheduledExecutorService?: string;
    bulkheadEnabled?: boolean;
    bulkheadMaxConcurrentCalls?: number;
    bulkheadWaitingTaskQueue?: number;
    bulkheadExecutorService?: string;
    public constructor(init?: Partial<FaultToleranceConfigurationDefinition>) {
        super('FaultToleranceConfigurationDefinition');
        Object.assign(this, init);
    }
}

export class FilterDefinition extends CamelElement {
    stepName?: string = 'filter';
    id?: string = 'filter-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    statusPropertyName?: string;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<FilterDefinition>) {
        super('FilterDefinition');
        Object.assign(this, init);
    }
}

export class FinallyDefinition extends CamelElement {
    stepName?: string = 'doFinally';
    id?: string = 'doFinally-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<FinallyDefinition>) {
        super('FinallyDefinition');
        Object.assign(this, init);
    }
}

export class FromDefinition extends CamelElement {
    stepName?: string = 'from';
    id?: string = 'from-' + uuidv4().substring(0,4);
    description?: string;
    uri: string = '';
    parameters?: any = {};
    steps: CamelElement[] = [];
    public constructor(init?: Partial<FromDefinition>) {
        super('FromDefinition');
        Object.assign(this, init);
    }
}

export class GlobalOptionDefinition extends CamelElement {
    stepName?: string = 'globalOption';
    key: string = '';
    value: string = '';
    public constructor(init?: Partial<GlobalOptionDefinition>) {
        super('GlobalOptionDefinition');
        Object.assign(this, init);
    }
}

export class GlobalOptionsDefinition extends CamelElement {
    stepName?: string = 'globalOptions';
    globalOption?: GlobalOptionDefinition[] = [];
    public constructor(init?: Partial<GlobalOptionsDefinition>) {
        super('GlobalOptionsDefinition');
        Object.assign(this, init);
    }
}

export class IdempotentConsumerDefinition extends CamelElement {
    stepName?: string = 'idempotentConsumer';
    id?: string = 'idempotentConsumer-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    idempotentRepository: string = '';
    eager?: boolean;
    completionEager?: boolean;
    skipDuplicate?: boolean;
    removeOnFailure?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<IdempotentConsumerDefinition>) {
        super('IdempotentConsumerDefinition');
        Object.assign(this, init);
    }
}

export class InputTypeDefinition extends CamelElement {
    stepName?: string = 'inputType';
    id?: string = 'inputType-' + uuidv4().substring(0,4);
    description?: string;
    urn: string = '';
    validate?: boolean;
    public constructor(init?: Partial<InputTypeDefinition>) {
        super('InputTypeDefinition');
        Object.assign(this, init);
    }
}

export class InterceptDefinition extends CamelElement {
    stepName?: string = 'intercept';
    id?: string = 'intercept-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<InterceptDefinition>) {
        super('InterceptDefinition');
        Object.assign(this, init);
    }
}

export class InterceptFromDefinition extends CamelElement {
    stepName?: string = 'interceptFrom';
    id?: string = 'interceptFrom-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    uri?: string;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<InterceptFromDefinition>) {
        super('InterceptFromDefinition');
        Object.assign(this, init);
    }
}

export class InterceptSendToEndpointDefinition extends CamelElement {
    stepName?: string = 'interceptSendToEndpoint';
    id?: string = 'interceptSendToEndpoint-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    uri: string = '';
    skipSendToOriginalEndpoint?: string;
    afterUri?: string;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<InterceptSendToEndpointDefinition>) {
        super('InterceptSendToEndpointDefinition');
        Object.assign(this, init);
    }
}

export class KameletDefinition extends CamelElement {
    stepName?: string = 'kamelet';
    name: string = '';
    parameters?: any = {};
    public constructor(init?: Partial<KameletDefinition>) {
        super('KameletDefinition');
        Object.assign(this, init);
    }
}

export class LoadBalanceDefinition extends CamelElement {
    stepName?: string = 'loadBalance';
    id?: string = 'loadBalance-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    inheritErrorHandler?: boolean;
    customLoadBalancer?: CustomLoadBalancerDefinition | string;
    failover?: FailoverLoadBalancerDefinition;
    random?: RandomLoadBalancerDefinition;
    roundRobin?: RoundRobinLoadBalancerDefinition;
    sticky?: StickyLoadBalancerDefinition;
    topic?: TopicLoadBalancerDefinition;
    weighted?: WeightedLoadBalancerDefinition;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<LoadBalanceDefinition>) {
        super('LoadBalanceDefinition');
        Object.assign(this, init);
    }
}

export class LogDefinition extends CamelElement {
    stepName?: string = 'log';
    id?: string = 'log-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    message: string = '';
    loggingLevel?: string;
    logName?: string;
    marker?: string;
    logger?: string;
    public constructor(init?: Partial<LogDefinition>) {
        super('LogDefinition');
        Object.assign(this, init);
    }
}

export class LoopDefinition extends CamelElement {
    stepName?: string = 'loop';
    id?: string = 'loop-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    copy?: boolean;
    doWhile?: boolean;
    breakOnShutdown?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<LoopDefinition>) {
        super('LoopDefinition');
        Object.assign(this, init);
    }
}

export class MarshalDefinition extends CamelElement {
    stepName?: string = 'marshal';
    id?: string = 'marshal-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    asn1?: ASN1DataFormat | string;
    avro?: AvroDataFormat | string;
    barcode?: BarcodeDataFormat;
    base64?: Base64DataFormat;
    bindy?: BindyDataFormat;
    cbor?: CBORDataFormat;
    crypto?: CryptoDataFormat;
    csv?: CsvDataFormat | string;
    custom?: CustomDataFormat | string;
    fhirJson?: FhirJsonDataFormat;
    fhirXml?: FhirXmlDataFormat;
    flatpack?: FlatpackDataFormat;
    grok?: GrokDataFormat;
    gzipDeflater?: GzipDeflaterDataFormat;
    hl7?: HL7DataFormat;
    ical?: IcalDataFormat;
    jacksonXml?: JacksonXMLDataFormat;
    jaxb?: JaxbDataFormat;
    json?: JsonDataFormat;
    jsonApi?: JsonApiDataFormat;
    lzf?: LZFDataFormat;
    mimeMultipart?: MimeMultipartDataFormat;
    parquetAvro?: ParquetAvroDataFormat | string;
    pgp?: PGPDataFormat;
    protobuf?: ProtobufDataFormat | string;
    rss?: RssDataFormat;
    soap?: SoapDataFormat | string;
    swiftMt?: SwiftMtDataFormat | string;
    swiftMx?: SwiftMxDataFormat;
    syslog?: SyslogDataFormat;
    tarFile?: TarFileDataFormat;
    thrift?: ThriftDataFormat | string;
    tidyMarkup?: TidyMarkupDataFormat;
    univocityCsv?: UniVocityCsvDataFormat;
    univocityFixed?: UniVocityFixedDataFormat;
    univocityTsv?: UniVocityTsvDataFormat;
    xmlSecurity?: XMLSecurityDataFormat;
    yaml?: YAMLDataFormat;
    zipDeflater?: ZipDeflaterDataFormat;
    zipFile?: ZipFileDataFormat;
    public constructor(init?: Partial<MarshalDefinition>) {
        super('MarshalDefinition');
        Object.assign(this, init);
    }
}

export class MulticastDefinition extends CamelElement {
    stepName?: string = 'multicast';
    id?: string = 'multicast-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    aggregationStrategy?: string;
    aggregationStrategyMethodName?: string;
    aggregationStrategyMethodAllowNull?: boolean;
    parallelAggregate?: boolean;
    parallelProcessing?: boolean;
    synchronous?: boolean;
    streaming?: boolean;
    stopOnException?: boolean;
    timeout?: string;
    executorService?: string;
    onPrepare?: string;
    shareUnitOfWork?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<MulticastDefinition>) {
        super('MulticastDefinition');
        Object.assign(this, init);
    }
}

export class OnCompletionDefinition extends CamelElement {
    stepName?: string = 'onCompletion';
    id?: string = 'onCompletion-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    mode?: string;
    onCompleteOnly?: boolean;
    onFailureOnly?: boolean;
    parallelProcessing?: boolean;
    executorService?: string;
    useOriginalMessage?: boolean;
    onWhen?: WhenDefinition;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<OnCompletionDefinition>) {
        super('OnCompletionDefinition');
        Object.assign(this, init);
    }
}

export class OnExceptionDefinition extends CamelElement {
    stepName?: string = 'onException';
    id?: string = 'onException-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    exception?: string[] = [];
    onWhen?: WhenDefinition;
    retryWhile?: ExpressionSubElementDefinition;
    redeliveryPolicy?: RedeliveryPolicyDefinition;
    redeliveryPolicyRef?: string;
    handled?: ExpressionSubElementDefinition;
    continued?: ExpressionSubElementDefinition;
    onRedeliveryRef?: string;
    onExceptionOccurredRef?: string;
    useOriginalMessage?: boolean;
    useOriginalBody?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<OnExceptionDefinition>) {
        super('OnExceptionDefinition');
        Object.assign(this, init);
    }
}

export class OnFallbackDefinition extends CamelElement {
    stepName?: string = 'onFallback';
    id?: string = 'onFallback-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    fallbackViaNetwork?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<OnFallbackDefinition>) {
        super('OnFallbackDefinition');
        Object.assign(this, init);
    }
}

export class OptimisticLockRetryPolicyDefinition extends CamelElement {
    stepName?: string = 'optimisticLockRetryPolicy';
    maximumRetries?: number;
    retryDelay?: string;
    maximumRetryDelay?: string;
    exponentialBackOff?: boolean;
    randomBackOff?: boolean;
    public constructor(init?: Partial<OptimisticLockRetryPolicyDefinition>) {
        super('OptimisticLockRetryPolicyDefinition');
        Object.assign(this, init);
    }
}

export class OtherwiseDefinition extends CamelElement {
    stepName?: string = 'otherwise';
    id?: string = 'otherwise-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<OtherwiseDefinition>) {
        super('OtherwiseDefinition');
        Object.assign(this, init);
    }
}

export class OutputDefinition extends CamelElement {
    stepName?: string = 'output';
    description?: string;
    disabled?: boolean;
    id?: string = 'output-' + uuidv4().substring(0,4);
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<OutputDefinition>) {
        super('OutputDefinition');
        Object.assign(this, init);
    }
}

export class OutputTypeDefinition extends CamelElement {
    stepName?: string = 'outputType';
    id?: string = 'outputType-' + uuidv4().substring(0,4);
    description?: string;
    urn: string = '';
    validate?: boolean;
    public constructor(init?: Partial<OutputTypeDefinition>) {
        super('OutputTypeDefinition');
        Object.assign(this, init);
    }
}

export class PackageScanDefinition extends CamelElement {
    stepName?: string = 'packageScan';
    package?: string[] = [];
    excludes?: string[] = [];
    includes?: string[] = [];
    public constructor(init?: Partial<PackageScanDefinition>) {
        super('PackageScanDefinition');
        Object.assign(this, init);
    }
}

export class PausableDefinition extends CamelElement {
    stepName?: string = 'pausable';
    id?: string = 'pausable-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    consumerListener: string = '';
    untilCheck: string = '';
    public constructor(init?: Partial<PausableDefinition>) {
        super('PausableDefinition');
        Object.assign(this, init);
    }
}

export class PipelineDefinition extends CamelElement {
    stepName?: string = 'pipeline';
    id?: string = 'pipeline-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<PipelineDefinition>) {
        super('PipelineDefinition');
        Object.assign(this, init);
    }
}

export class PolicyDefinition extends CamelElement {
    stepName?: string = 'policy';
    id?: string = 'policy-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    ref: string = '';
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<PolicyDefinition>) {
        super('PolicyDefinition');
        Object.assign(this, init);
    }
}

export class PollEnrichDefinition extends CamelElement {
    stepName?: string = 'pollEnrich';
    id?: string = 'pollEnrich-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    aggregationStrategy?: string;
    aggregationStrategyMethodName?: string;
    aggregationStrategyMethodAllowNull?: string;
    aggregateOnException?: boolean;
    timeout?: string;
    cacheSize?: number;
    ignoreInvalidEndpoint?: boolean;
    public constructor(init?: Partial<PollEnrichDefinition>) {
        super('PollEnrichDefinition');
        Object.assign(this, init);
    }
}

export class ProcessDefinition extends CamelElement {
    stepName?: string = 'process';
    id?: string = 'process-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    ref: string = '';
    public constructor(init?: Partial<ProcessDefinition>) {
        super('ProcessDefinition');
        Object.assign(this, init);
    }
}

export class PropertyDefinition extends CamelElement {
    stepName?: string = 'property';
    key: string = '';
    value: string = '';
    public constructor(init?: Partial<PropertyDefinition>) {
        super('PropertyDefinition');
        Object.assign(this, init);
    }
}

export class PropertyExpressionDefinition extends CamelElement {
    stepName?: string = 'propertyExpression';
    key: string = '';
    expression?: ExpressionDefinition;
    public constructor(init?: Partial<PropertyExpressionDefinition>) {
        super('PropertyExpressionDefinition');
        Object.assign(this, init);
    }
}

export class RecipientListDefinition extends CamelElement {
    stepName?: string = 'recipientList';
    id?: string = 'recipientList-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    delimiter?: string;
    aggregationStrategy?: string;
    aggregationStrategyMethodName?: string;
    aggregationStrategyMethodAllowNull?: boolean;
    parallelAggregate?: boolean;
    parallelProcessing?: boolean;
    synchronous?: boolean;
    timeout?: string;
    executorService?: string;
    stopOnException?: boolean;
    ignoreInvalidEndpoints?: boolean;
    streaming?: boolean;
    onPrepare?: string;
    cacheSize?: number;
    shareUnitOfWork?: boolean;
    public constructor(init?: Partial<RecipientListDefinition>) {
        super('RecipientListDefinition');
        Object.assign(this, init);
    }
}

export class RedeliveryPolicyDefinition extends CamelElement {
    stepName?: string = 'redeliveryPolicy';
    id?: string = 'redeliveryPolicy-' + uuidv4().substring(0,4);
    maximumRedeliveries?: number;
    redeliveryDelay?: string;
    asyncDelayedRedelivery?: boolean;
    backOffMultiplier?: number;
    useExponentialBackOff?: boolean;
    collisionAvoidanceFactor?: number;
    useCollisionAvoidance?: boolean;
    maximumRedeliveryDelay?: string;
    retriesExhaustedLogLevel?: string;
    retryAttemptedLogLevel?: string;
    retryAttemptedLogInterval?: number;
    logRetryAttempted?: boolean;
    logStackTrace?: boolean;
    logRetryStackTrace?: boolean;
    logHandled?: boolean;
    logNewException?: boolean;
    logContinued?: boolean;
    logExhausted?: boolean;
    logExhaustedMessageHistory?: boolean;
    logExhaustedMessageBody?: boolean;
    disableRedelivery?: boolean;
    delayPattern?: string;
    allowRedeliveryWhileStopping?: boolean;
    exchangeFormatterRef?: string;
    public constructor(init?: Partial<RedeliveryPolicyDefinition>) {
        super('RedeliveryPolicyDefinition');
        Object.assign(this, init);
    }
}

export class RemoveHeaderDefinition extends CamelElement {
    stepName?: string = 'removeHeader';
    id?: string = 'removeHeader-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    name: string = '';
    public constructor(init?: Partial<RemoveHeaderDefinition>) {
        super('RemoveHeaderDefinition');
        Object.assign(this, init);
    }
}

export class RemoveHeadersDefinition extends CamelElement {
    stepName?: string = 'removeHeaders';
    id?: string = 'removeHeaders-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    pattern: string = '';
    excludePattern?: string;
    public constructor(init?: Partial<RemoveHeadersDefinition>) {
        super('RemoveHeadersDefinition');
        Object.assign(this, init);
    }
}

export class RemovePropertiesDefinition extends CamelElement {
    stepName?: string = 'removeProperties';
    id?: string = 'removeProperties-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    pattern: string = '';
    excludePattern?: string;
    public constructor(init?: Partial<RemovePropertiesDefinition>) {
        super('RemovePropertiesDefinition');
        Object.assign(this, init);
    }
}

export class RemovePropertyDefinition extends CamelElement {
    stepName?: string = 'removeProperty';
    id?: string = 'removeProperty-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    name: string = '';
    public constructor(init?: Partial<RemovePropertyDefinition>) {
        super('RemovePropertyDefinition');
        Object.assign(this, init);
    }
}

export class ResequenceDefinition extends CamelElement {
    stepName?: string = 'resequence';
    id?: string = 'resequence-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<ResequenceDefinition>) {
        super('ResequenceDefinition');
        Object.assign(this, init);
    }
}

export class Resilience4jConfigurationDefinition extends CamelElement {
    stepName?: string = 'resilience4jConfiguration';
    id?: string = 'resilience4jConfiguration-' + uuidv4().substring(0,4);
    circuitBreaker?: string;
    config?: string;
    failureRateThreshold?: number;
    permittedNumberOfCallsInHalfOpenState?: number;
    throwExceptionWhenHalfOpenOrOpenState?: boolean;
    slidingWindowSize?: number;
    slidingWindowType?: string;
    minimumNumberOfCalls?: number;
    writableStackTraceEnabled?: boolean;
    waitDurationInOpenState?: number;
    automaticTransitionFromOpenToHalfOpenEnabled?: boolean;
    slowCallRateThreshold?: number;
    slowCallDurationThreshold?: number;
    bulkheadEnabled?: boolean;
    bulkheadMaxConcurrentCalls?: number;
    bulkheadMaxWaitDuration?: number;
    timeoutEnabled?: boolean;
    timeoutExecutorService?: string;
    timeoutDuration?: number;
    timeoutCancelRunningFuture?: boolean;
    public constructor(init?: Partial<Resilience4jConfigurationDefinition>) {
        super('Resilience4jConfigurationDefinition');
        Object.assign(this, init);
    }
}

export class RestContextRefDefinition extends CamelElement {
    stepName?: string = 'restContextRef';
    ref: string = '';
    public constructor(init?: Partial<RestContextRefDefinition>) {
        super('RestContextRefDefinition');
        Object.assign(this, init);
    }
}

export class ResumableDefinition extends CamelElement {
    stepName?: string = 'resumable';
    id?: string = 'resumable-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    resumeStrategy: string = '';
    loggingLevel?: string;
    intermittent?: boolean;
    public constructor(init?: Partial<ResumableDefinition>) {
        super('ResumableDefinition');
        Object.assign(this, init);
    }
}

export class RollbackDefinition extends CamelElement {
    stepName?: string = 'rollback';
    id?: string = 'rollback-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    message?: string;
    markRollbackOnly?: boolean;
    markRollbackOnlyLast?: boolean;
    public constructor(init?: Partial<RollbackDefinition>) {
        super('RollbackDefinition');
        Object.assign(this, init);
    }
}

export class RouteBuilderDefinition extends CamelElement {
    stepName?: string = 'routeBuilder';
    id?: string = 'routeBuilder-' + uuidv4().substring(0,4);
    ref: string = '';
    public constructor(init?: Partial<RouteBuilderDefinition>) {
        super('RouteBuilderDefinition');
        Object.assign(this, init);
    }
}

export class RouteConfigurationContextRefDefinition extends CamelElement {
    stepName?: string = 'routeConfigurationContextRef';
    ref: string = '';
    public constructor(init?: Partial<RouteConfigurationContextRefDefinition>) {
        super('RouteConfigurationContextRefDefinition');
        Object.assign(this, init);
    }
}

export class RouteConfigurationDefinition extends CamelElement {
    stepName?: string = 'routeConfiguration';
    id?: string;
    description?: string;
    errorHandler?: ErrorHandlerDefinition;
    intercept?: InterceptDefinition[] = [];
    interceptFrom?: InterceptFromDefinition[] = [];
    interceptSendToEndpoint?: InterceptSendToEndpointDefinition[] = [];
    onException?: OnExceptionDefinition[] = [];
    onCompletion?: OnCompletionDefinition[] = [];
    precondition?: string;
    public constructor(init?: Partial<RouteConfigurationDefinition>) {
        super('RouteConfigurationDefinition');
        Object.assign(this, init);
    }
}

export class RouteContextRefDefinition extends CamelElement {
    stepName?: string = 'routeContextRef';
    ref: string = '';
    public constructor(init?: Partial<RouteContextRefDefinition>) {
        super('RouteContextRefDefinition');
        Object.assign(this, init);
    }
}

export class RouteDefinition extends CamelElement {
    stepName?: string = 'route';
    id?: string = 'route-' + uuidv4().substring(0,4);
    description?: string;
    group?: string;
    nodePrefixId?: string;
    routeConfigurationId?: string;
    autoStartup?: boolean;
    startupOrder?: number;
    trace?: boolean;
    messageHistory?: boolean;
    logMask?: boolean;
    shutdownRoute?: string;
    shutdownRunningTask?: string;
    precondition?: string;
    inputType?: InputTypeDefinition;
    outputType?: OutputTypeDefinition;
    from: FromDefinition = new FromDefinition();
    public constructor(init?: Partial<RouteDefinition>) {
        super('RouteDefinition');
        Object.assign(this, init);
    }
}

export class RouteTemplateBeanDefinition extends CamelElement {
    stepName?: string = 'routeTemplateBean';
    name: string = '';
    properties?: any = {};
    property?: PropertyDefinition[] = [];
    script?: string;
    scriptLanguage?: string;
    type: string = '';
    public constructor(init?: Partial<RouteTemplateBeanDefinition>) {
        super('RouteTemplateBeanDefinition');
        Object.assign(this, init);
    }
}

export class RouteTemplateDefinition extends CamelElement {
    stepName?: string = 'routeTemplate';
    id: string = 'routeTemplate-' + uuidv4().substring(0,4);
    description?: string;
    route?: RouteDefinition;
    beans?: RouteTemplateBeanDefinition[] = [];
    from?: FromDefinition;
    parameters?: RouteTemplateParameterDefinition[] = [];
    public constructor(init?: Partial<RouteTemplateDefinition>) {
        super('RouteTemplateDefinition');
        Object.assign(this, init);
    }
}

export class RouteTemplateParameterDefinition extends CamelElement {
    stepName?: string = 'routeTemplateParameter';
    defaultValue?: string;
    description?: string;
    name: string = '';
    required?: boolean;
    public constructor(init?: Partial<RouteTemplateParameterDefinition>) {
        super('RouteTemplateParameterDefinition');
        Object.assign(this, init);
    }
}

export class RoutingSlipDefinition extends CamelElement {
    stepName?: string = 'routingSlip';
    id?: string = 'routingSlip-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    uriDelimiter?: string;
    ignoreInvalidEndpoints?: boolean;
    cacheSize?: number;
    public constructor(init?: Partial<RoutingSlipDefinition>) {
        super('RoutingSlipDefinition');
        Object.assign(this, init);
    }
}

export class SagaActionUriDefinition extends CamelElement {
    stepName?: string = 'sagaActionUri';
    description?: string;
    disabled?: boolean;
    id?: string = 'sagaActionUri-' + uuidv4().substring(0,4);
    parameters?: any = {};
    uri: string = '';
    public constructor(init?: Partial<SagaActionUriDefinition>) {
        super('SagaActionUriDefinition');
        Object.assign(this, init);
    }
}

export class SagaDefinition extends CamelElement {
    stepName?: string = 'saga';
    id?: string = 'saga-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    sagaService?: string;
    propagation?: string;
    completionMode?: string;
    timeout?: string;
    compensation?: string;
    completion?: string;
    option?: PropertyExpressionDefinition[] = [];
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<SagaDefinition>) {
        super('SagaDefinition');
        Object.assign(this, init);
    }
}

export class SamplingDefinition extends CamelElement {
    stepName?: string = 'sample';
    id?: string = 'sample-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    samplePeriod?: string;
    messageFrequency?: number;
    public constructor(init?: Partial<SamplingDefinition>) {
        super('SamplingDefinition');
        Object.assign(this, init);
    }
}

export class ScriptDefinition extends CamelElement {
    stepName?: string = 'script';
    id?: string = 'script-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    public constructor(init?: Partial<ScriptDefinition>) {
        super('ScriptDefinition');
        Object.assign(this, init);
    }
}

export class SetBodyDefinition extends CamelElement {
    stepName?: string = 'setBody';
    id?: string = 'setBody-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    public constructor(init?: Partial<SetBodyDefinition>) {
        super('SetBodyDefinition');
        Object.assign(this, init);
    }
}

export class SetExchangePatternDefinition extends CamelElement {
    stepName?: string = 'setExchangePattern';
    id?: string = 'setExchangePattern-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    pattern?: string;
    public constructor(init?: Partial<SetExchangePatternDefinition>) {
        super('SetExchangePatternDefinition');
        Object.assign(this, init);
    }
}

export class SetHeaderDefinition extends CamelElement {
    stepName?: string = 'setHeader';
    id?: string = 'setHeader-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    name: string = '';
    expression?: ExpressionDefinition;
    public constructor(init?: Partial<SetHeaderDefinition>) {
        super('SetHeaderDefinition');
        Object.assign(this, init);
    }
}

export class SetHeadersDefinition extends CamelElement {
    stepName?: string = 'setHeaders';
    id?: string = 'setHeaders-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    headers?: SetHeaderDefinition[] = [];
    public constructor(init?: Partial<SetHeadersDefinition>) {
        super('SetHeadersDefinition');
        Object.assign(this, init);
    }
}

export class SetPropertyDefinition extends CamelElement {
    stepName?: string = 'setProperty';
    id?: string = 'setProperty-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    name: string = '';
    expression?: ExpressionDefinition;
    public constructor(init?: Partial<SetPropertyDefinition>) {
        super('SetPropertyDefinition');
        Object.assign(this, init);
    }
}

export class SortDefinition extends CamelElement {
    stepName?: string = 'sort';
    id?: string = 'sort-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    comparator?: string;
    public constructor(init?: Partial<SortDefinition>) {
        super('SortDefinition');
        Object.assign(this, init);
    }
}

export class SplitDefinition extends CamelElement {
    stepName?: string = 'split';
    id?: string = 'split-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    delimiter?: string;
    aggregationStrategy?: string;
    aggregationStrategyMethodName?: string;
    aggregationStrategyMethodAllowNull?: boolean;
    parallelAggregate?: boolean;
    parallelProcessing?: boolean;
    synchronous?: boolean;
    streaming?: boolean;
    stopOnException?: boolean;
    timeout?: string;
    executorService?: string;
    onPrepare?: string;
    shareUnitOfWork?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<SplitDefinition>) {
        super('SplitDefinition');
        Object.assign(this, init);
    }
}

export class StepDefinition extends CamelElement {
    stepName?: string = 'step';
    id?: string = 'step-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<StepDefinition>) {
        super('StepDefinition');
        Object.assign(this, init);
    }
}

export class StopDefinition extends CamelElement {
    stepName?: string = 'stop';
    id?: string = 'stop-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    public constructor(init?: Partial<StopDefinition>) {
        super('StopDefinition');
        Object.assign(this, init);
    }
}

export class TemplatedRouteBeanDefinition extends CamelElement {
    stepName?: string = 'templatedRouteBean';
    name: string = '';
    type: string = '';
    scriptLanguage?: string;
    property?: PropertyDefinition[] = [];
    properties?: any = {};
    script?: string;
    public constructor(init?: Partial<TemplatedRouteBeanDefinition>) {
        super('TemplatedRouteBeanDefinition');
        Object.assign(this, init);
    }
}

export class TemplatedRouteDefinition extends CamelElement {
    stepName?: string = 'templatedRoute';
    routeTemplateRef: string = '';
    routeId?: string;
    prefixId?: string;
    beans?: TemplatedRouteBeanDefinition[] = [];
    parameters?: TemplatedRouteParameterDefinition[] = [];
    public constructor(init?: Partial<TemplatedRouteDefinition>) {
        super('TemplatedRouteDefinition');
        Object.assign(this, init);
    }
}

export class TemplatedRouteParameterDefinition extends CamelElement {
    stepName?: string = 'templatedRouteParameter';
    name: string = '';
    value: string = '';
    public constructor(init?: Partial<TemplatedRouteParameterDefinition>) {
        super('TemplatedRouteParameterDefinition');
        Object.assign(this, init);
    }
}

export class ThreadPoolProfileDefinition extends CamelElement {
    stepName?: string = 'threadPoolProfile';
    id?: string = 'threadPoolProfile-' + uuidv4().substring(0,4);
    description?: string;
    defaultProfile?: boolean;
    poolSize?: number;
    maxPoolSize?: number;
    keepAliveTime?: number;
    timeUnit?: string;
    maxQueueSize?: number;
    allowCoreThreadTimeOut?: boolean;
    rejectedPolicy?: string;
    public constructor(init?: Partial<ThreadPoolProfileDefinition>) {
        super('ThreadPoolProfileDefinition');
        Object.assign(this, init);
    }
}

export class ThreadsDefinition extends CamelElement {
    stepName?: string = 'threads';
    id?: string = 'threads-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    executorService?: string;
    poolSize?: number;
    maxPoolSize?: number;
    keepAliveTime?: number;
    timeUnit?: string;
    maxQueueSize?: number;
    allowCoreThreadTimeOut?: boolean;
    threadName?: string;
    rejectedPolicy?: string;
    callerRunsWhenRejected?: string;
    public constructor(init?: Partial<ThreadsDefinition>) {
        super('ThreadsDefinition');
        Object.assign(this, init);
    }
}

export class ThrottleDefinition extends CamelElement {
    stepName?: string = 'throttle';
    id?: string = 'throttle-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    correlationExpression?: ExpressionSubElementDefinition;
    executorService?: string;
    asyncDelayed?: boolean;
    callerRunsWhenRejected?: boolean;
    rejectExecution?: boolean;
    public constructor(init?: Partial<ThrottleDefinition>) {
        super('ThrottleDefinition');
        Object.assign(this, init);
    }
}

export class ThrowExceptionDefinition extends CamelElement {
    stepName?: string = 'throwException';
    id?: string = 'throwException-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    message?: string;
    exceptionType?: string;
    ref?: string;
    public constructor(init?: Partial<ThrowExceptionDefinition>) {
        super('ThrowExceptionDefinition');
        Object.assign(this, init);
    }
}

export class ToDefinition extends CamelElement {
    stepName?: string = 'to';
    id?: string = 'to-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    uri: string = '';
    pattern?: string;
    parameters?: any = {};
    public constructor(init?: Partial<ToDefinition>) {
        super('ToDefinition');
        Object.assign(this, init);
    }
}

export class ToDynamicDefinition extends CamelElement {
    stepName?: string = 'toD';
    id?: string = 'toD-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    uri: string = '';
    pattern?: string;
    cacheSize?: number;
    ignoreInvalidEndpoint?: boolean;
    allowOptimisedComponents?: boolean;
    autoStartComponents?: boolean;
    parameters?: any = {};
    public constructor(init?: Partial<ToDynamicDefinition>) {
        super('ToDynamicDefinition');
        Object.assign(this, init);
    }
}

export class TransactedDefinition extends CamelElement {
    stepName?: string = 'transacted';
    id?: string = 'transacted-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    ref?: string;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<TransactedDefinition>) {
        super('TransactedDefinition');
        Object.assign(this, init);
    }
}

export class TransformDefinition extends CamelElement {
    stepName?: string = 'transform';
    id?: string = 'transform-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    fromType?: string;
    toType?: string;
    public constructor(init?: Partial<TransformDefinition>) {
        super('TransformDefinition');
        Object.assign(this, init);
    }
}

export class TryDefinition extends CamelElement {
    stepName?: string = 'doTry';
    id?: string = 'doTry-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    doCatch?: CatchDefinition[] = [];
    doFinally?: FinallyDefinition;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<TryDefinition>) {
        super('TryDefinition');
        Object.assign(this, init);
    }
}

export class UnmarshalDefinition extends CamelElement {
    stepName?: string = 'unmarshal';
    id?: string = 'unmarshal-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    allowNullBody?: boolean;
    asn1?: ASN1DataFormat | string;
    avro?: AvroDataFormat | string;
    barcode?: BarcodeDataFormat;
    base64?: Base64DataFormat;
    bindy?: BindyDataFormat;
    cbor?: CBORDataFormat;
    crypto?: CryptoDataFormat;
    csv?: CsvDataFormat | string;
    custom?: CustomDataFormat | string;
    fhirJson?: FhirJsonDataFormat;
    fhirXml?: FhirXmlDataFormat;
    flatpack?: FlatpackDataFormat;
    grok?: GrokDataFormat;
    gzipDeflater?: GzipDeflaterDataFormat;
    hl7?: HL7DataFormat;
    ical?: IcalDataFormat;
    jacksonXml?: JacksonXMLDataFormat;
    jaxb?: JaxbDataFormat;
    json?: JsonDataFormat;
    jsonApi?: JsonApiDataFormat;
    lzf?: LZFDataFormat;
    mimeMultipart?: MimeMultipartDataFormat;
    parquetAvro?: ParquetAvroDataFormat | string;
    pgp?: PGPDataFormat;
    protobuf?: ProtobufDataFormat | string;
    rss?: RssDataFormat;
    soap?: SoapDataFormat | string;
    swiftMt?: SwiftMtDataFormat | string;
    swiftMx?: SwiftMxDataFormat;
    syslog?: SyslogDataFormat;
    tarFile?: TarFileDataFormat;
    thrift?: ThriftDataFormat | string;
    tidyMarkup?: TidyMarkupDataFormat;
    univocityCsv?: UniVocityCsvDataFormat;
    univocityFixed?: UniVocityFixedDataFormat;
    univocityTsv?: UniVocityTsvDataFormat;
    xmlSecurity?: XMLSecurityDataFormat;
    yaml?: YAMLDataFormat;
    zipDeflater?: ZipDeflaterDataFormat;
    zipFile?: ZipFileDataFormat;
    public constructor(init?: Partial<UnmarshalDefinition>) {
        super('UnmarshalDefinition');
        Object.assign(this, init);
    }
}

export class ValidateDefinition extends CamelElement {
    stepName?: string = 'validate';
    id?: string = 'validate-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    predicateExceptionFactory?: string;
    public constructor(init?: Partial<ValidateDefinition>) {
        super('ValidateDefinition');
        Object.assign(this, init);
    }
}

export class ValueDefinition extends CamelElement {
    stepName?: string = 'value';
    value?: string;
    public constructor(init?: Partial<ValueDefinition>) {
        super('ValueDefinition');
        Object.assign(this, init);
    }
}

export class WhenDefinition extends CamelElement {
    stepName?: string = 'when';
    id?: string = 'when-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<WhenDefinition>) {
        super('WhenDefinition');
        Object.assign(this, init);
    }
}

export class WhenSkipSendToEndpointDefinition extends CamelElement {
    stepName?: string = 'whenSkipSendToEndpoint';
    id?: string = 'whenSkipSendToEndpoint-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    expression?: ExpressionDefinition;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<WhenSkipSendToEndpointDefinition>) {
        super('WhenSkipSendToEndpointDefinition');
        Object.assign(this, init);
    }
}

export class WireTapDefinition extends CamelElement {
    stepName?: string = 'wireTap';
    id?: string = 'wireTap-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    copy?: boolean;
    dynamicUri?: boolean;
    onPrepare?: string;
    executorService?: string;
    uri: string = '';
    pattern?: string;
    cacheSize?: number;
    ignoreInvalidEndpoint?: boolean;
    allowOptimisedComponents?: boolean;
    autoStartComponents?: boolean;
    parameters?: any = {};
    public constructor(init?: Partial<WireTapDefinition>) {
        super('WireTapDefinition');
        Object.assign(this, init);
    }
}

export class BeanConstructorDefinition extends CamelElement {
    stepName?: string = 'beanConstructor';
    index?: number;
    value: string = '';
    public constructor(init?: Partial<BeanConstructorDefinition>) {
        super('BeanConstructorDefinition');
        Object.assign(this, init);
    }
}

export class BeanConstructorsDefinition extends CamelElement {
    stepName?: string = 'beanConstructors';
    _constructor?: BeanConstructorDefinition[] = [];
    public constructor(init?: Partial<BeanConstructorsDefinition>) {
        super('BeanConstructorsDefinition');
        Object.assign(this, init);
    }
}

export class BeanPropertiesDefinition extends CamelElement {
    stepName?: string = 'properties';
    property?: BeanPropertyDefinition[] = [];
    public constructor(init?: Partial<BeanPropertiesDefinition>) {
        super('BeanPropertiesDefinition');
        Object.assign(this, init);
    }
}

export class BeanPropertyDefinition extends CamelElement {
    stepName?: string = 'beanProperty';
    key?: string;
    properties?: BeanPropertiesDefinition;
    value?: string;
    public constructor(init?: Partial<BeanPropertyDefinition>) {
        super('BeanPropertyDefinition');
        Object.assign(this, init);
    }
}

export class ComponentScanDefinition extends CamelElement {
    stepName?: string = 'componentScan';
    basePackage?: string;
    public constructor(init?: Partial<ComponentScanDefinition>) {
        super('ComponentScanDefinition');
        Object.assign(this, init);
    }
}

export class RegistryBeanDefinition extends CamelElement {
    stepName?: string = 'registryBean';
    builderClass?: string;
    builderMethod?: string;
    constructors?: any = {};
    destroyMethod?: string;
    factoryBean?: string;
    factoryMethod?: string;
    initMethod?: string;
    name: string = '';
    properties?: any = {};
    script?: string;
    scriptLanguage?: string;
    type: string = '';
    public constructor(init?: Partial<RegistryBeanDefinition>) {
        super('RegistryBeanDefinition');
        Object.assign(this, init);
    }
}

export class BlacklistServiceCallServiceFilterConfiguration extends CamelElement {
    id?: string = 'blacklistServiceCallServiceFilterConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    servers?: string[] = [];
    public constructor(init?: Partial<BlacklistServiceCallServiceFilterConfiguration>) {
        super('BlacklistServiceCallServiceFilterConfiguration');
        Object.assign(this, init);
    }
}

export class CachingServiceCallServiceDiscoveryConfiguration extends CamelElement {
    combinedServiceDiscovery?: CombinedServiceCallServiceDiscoveryConfiguration;
    consulServiceDiscovery?: ConsulServiceCallServiceDiscoveryConfiguration;
    dnsServiceDiscovery?: DnsServiceCallServiceDiscoveryConfiguration;
    kubernetesServiceDiscovery?: KubernetesServiceCallServiceDiscoveryConfiguration;
    staticServiceDiscovery?: StaticServiceCallServiceDiscoveryConfiguration;
    id?: string = 'cachingServiceCallServiceDiscoveryConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    timeout?: number;
    units?: string;
    public constructor(init?: Partial<CachingServiceCallServiceDiscoveryConfiguration>) {
        super('CachingServiceCallServiceDiscoveryConfiguration');
        Object.assign(this, init);
    }
}

export class CombinedServiceCallServiceDiscoveryConfiguration extends CamelElement {
    cachingServiceDiscovery?: CachingServiceCallServiceDiscoveryConfiguration;
    consulServiceDiscovery?: ConsulServiceCallServiceDiscoveryConfiguration;
    dnsServiceDiscovery?: DnsServiceCallServiceDiscoveryConfiguration;
    id?: string = 'combinedServiceCallServiceDiscoveryConfiguration-' + uuidv4().substring(0,4);
    kubernetesServiceDiscovery?: KubernetesServiceCallServiceDiscoveryConfiguration;
    properties?: PropertyDefinition[] = [];
    staticServiceDiscovery?: StaticServiceCallServiceDiscoveryConfiguration;
    public constructor(init?: Partial<CombinedServiceCallServiceDiscoveryConfiguration>) {
        super('CombinedServiceCallServiceDiscoveryConfiguration');
        Object.assign(this, init);
    }
}

export class CombinedServiceCallServiceFilterConfiguration extends CamelElement {
    blacklistServiceFilter?: BlacklistServiceCallServiceFilterConfiguration;
    customServiceFilter?: CustomServiceCallServiceFilterConfiguration;
    healthyServiceFilter?: HealthyServiceCallServiceFilterConfiguration;
    id?: string = 'combinedServiceCallServiceFilterConfiguration-' + uuidv4().substring(0,4);
    passThroughServiceFilter?: PassThroughServiceCallServiceFilterConfiguration;
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<CombinedServiceCallServiceFilterConfiguration>) {
        super('CombinedServiceCallServiceFilterConfiguration');
        Object.assign(this, init);
    }
}

export class ConsulServiceCallServiceDiscoveryConfiguration extends CamelElement {
    aclToken?: string;
    blockSeconds?: number;
    connectTimeoutMillis?: number;
    datacenter?: string;
    id?: string = 'consulServiceCallServiceDiscoveryConfiguration-' + uuidv4().substring(0,4);
    password?: string;
    properties?: PropertyDefinition[] = [];
    readTimeoutMillis?: number;
    url?: string;
    userName?: string;
    writeTimeoutMillis?: number;
    public constructor(init?: Partial<ConsulServiceCallServiceDiscoveryConfiguration>) {
        super('ConsulServiceCallServiceDiscoveryConfiguration');
        Object.assign(this, init);
    }
}

export class CustomServiceCallServiceFilterConfiguration extends CamelElement {
    id?: string = 'customServiceCallServiceFilterConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    ref?: string;
    public constructor(init?: Partial<CustomServiceCallServiceFilterConfiguration>) {
        super('CustomServiceCallServiceFilterConfiguration');
        Object.assign(this, init);
    }
}

export class DefaultServiceCallServiceLoadBalancerConfiguration extends CamelElement {
    id?: string = 'defaultServiceCallServiceLoadBalancerConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<DefaultServiceCallServiceLoadBalancerConfiguration>) {
        super('DefaultServiceCallServiceLoadBalancerConfiguration');
        Object.assign(this, init);
    }
}

export class DnsServiceCallServiceDiscoveryConfiguration extends CamelElement {
    domain?: string;
    id?: string = 'dnsServiceCallServiceDiscoveryConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    proto?: string;
    public constructor(init?: Partial<DnsServiceCallServiceDiscoveryConfiguration>) {
        super('DnsServiceCallServiceDiscoveryConfiguration');
        Object.assign(this, init);
    }
}

export class HealthyServiceCallServiceFilterConfiguration extends CamelElement {
    id?: string = 'healthyServiceCallServiceFilterConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<HealthyServiceCallServiceFilterConfiguration>) {
        super('HealthyServiceCallServiceFilterConfiguration');
        Object.assign(this, init);
    }
}

export class KubernetesServiceCallServiceDiscoveryConfiguration extends CamelElement {
    apiVersion?: string;
    caCertData?: string;
    caCertFile?: string;
    clientCertData?: string;
    clientCertFile?: string;
    clientKeyAlgo?: string;
    clientKeyData?: string;
    clientKeyFile?: string;
    clientKeyPassphrase?: string;
    dnsDomain?: string;
    id?: string = 'kubernetesServiceCallServiceDiscoveryConfiguration-' + uuidv4().substring(0,4);
    lookup?: string;
    masterUrl?: string;
    namespace?: string;
    oauthToken?: string;
    password?: string;
    portName?: string;
    portProtocol?: string;
    properties?: PropertyDefinition[] = [];
    trustCerts?: boolean;
    username?: string;
    public constructor(init?: Partial<KubernetesServiceCallServiceDiscoveryConfiguration>) {
        super('KubernetesServiceCallServiceDiscoveryConfiguration');
        Object.assign(this, init);
    }
}

export class PassThroughServiceCallServiceFilterConfiguration extends CamelElement {
    id?: string = 'passThroughServiceCallServiceFilterConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<PassThroughServiceCallServiceFilterConfiguration>) {
        super('PassThroughServiceCallServiceFilterConfiguration');
        Object.assign(this, init);
    }
}

export class ServiceCallConfigurationDefinition extends CamelElement {
    stepName?: string = 'serviceCallConfiguration';
    id?: string = 'serviceCallConfiguration-' + uuidv4().substring(0,4);
    expression?: ExpressionDefinition;
    uri?: string;
    component?: string;
    pattern?: string;
    serviceDiscoveryRef?: string;
    serviceFilterRef?: string;
    serviceChooserRef?: string;
    loadBalancerRef?: string;
    expressionRef?: string;
    blacklistServiceFilter?: BlacklistServiceCallServiceFilterConfiguration;
    combinedServiceFilter?: CombinedServiceCallServiceFilterConfiguration;
    customServiceFilter?: CustomServiceCallServiceFilterConfiguration;
    healthyServiceFilter?: HealthyServiceCallServiceFilterConfiguration;
    passThroughServiceFilter?: PassThroughServiceCallServiceFilterConfiguration;
    public constructor(init?: Partial<ServiceCallConfigurationDefinition>) {
        super('ServiceCallConfigurationDefinition');
        Object.assign(this, init);
    }
}

export class ServiceCallDefinition extends CamelElement {
    stepName?: string = 'serviceCall';
    id?: string = 'serviceCall-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    name: string = '';
    expression?: ExpressionDefinition;
    uri?: string;
    component?: string;
    pattern?: string;
    configurationRef?: string;
    serviceDiscoveryRef?: string;
    serviceFilterRef?: string;
    serviceChooserRef?: string;
    loadBalancerRef?: string;
    expressionRef?: string;
    public constructor(init?: Partial<ServiceCallDefinition>) {
        super('ServiceCallDefinition');
        Object.assign(this, init);
    }
}

export class ServiceCallExpressionConfiguration extends CamelElement {
    expressionType?: ExpressionDefinition;
    hostHeader?: string;
    id?: string = 'serviceCallExpressionConfiguration-' + uuidv4().substring(0,4);
    portHeader?: string;
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<ServiceCallExpressionConfiguration>) {
        super('ServiceCallExpressionConfiguration');
        Object.assign(this, init);
    }
}

export class ServiceCallServiceChooserConfiguration extends CamelElement {
    id?: string = 'serviceCallServiceChooserConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<ServiceCallServiceChooserConfiguration>) {
        super('ServiceCallServiceChooserConfiguration');
        Object.assign(this, init);
    }
}

export class ServiceCallServiceDiscoveryConfiguration extends CamelElement {
    id?: string = 'serviceCallServiceDiscoveryConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<ServiceCallServiceDiscoveryConfiguration>) {
        super('ServiceCallServiceDiscoveryConfiguration');
        Object.assign(this, init);
    }
}

export class ServiceCallServiceFilterConfiguration extends CamelElement {
    id?: string = 'serviceCallServiceFilterConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<ServiceCallServiceFilterConfiguration>) {
        super('ServiceCallServiceFilterConfiguration');
        Object.assign(this, init);
    }
}

export class ServiceCallServiceLoadBalancerConfiguration extends CamelElement {
    id?: string = 'serviceCallServiceLoadBalancerConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<ServiceCallServiceLoadBalancerConfiguration>) {
        super('ServiceCallServiceLoadBalancerConfiguration');
        Object.assign(this, init);
    }
}

export class StaticServiceCallServiceDiscoveryConfiguration extends CamelElement {
    id?: string = 'staticServiceCallServiceDiscoveryConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    servers?: string[] = [];
    public constructor(init?: Partial<StaticServiceCallServiceDiscoveryConfiguration>) {
        super('StaticServiceCallServiceDiscoveryConfiguration');
        Object.assign(this, init);
    }
}

export class ZooKeeperServiceCallServiceDiscoveryConfiguration extends CamelElement {
    basePath: string = '';
    connectionTimeout?: string;
    id?: string = 'zooKeeperServiceCallServiceDiscoveryConfiguration-' + uuidv4().substring(0,4);
    namespace?: string;
    nodes: string = '';
    properties?: PropertyDefinition[] = [];
    reconnectBaseSleepTime?: string;
    reconnectMaxRetries?: string;
    reconnectMaxSleepTime?: string;
    sessionTimeout?: string;
    public constructor(init?: Partial<ZooKeeperServiceCallServiceDiscoveryConfiguration>) {
        super('ZooKeeperServiceCallServiceDiscoveryConfiguration');
        Object.assign(this, init);
    }
}

export class BatchResequencerConfig extends CamelElement {
    allowDuplicates?: boolean;
    batchSize?: number;
    batchTimeout?: string;
    ignoreInvalidExchanges?: boolean;
    reverse?: boolean;
    public constructor(init?: Partial<BatchResequencerConfig>) {
        super('BatchResequencerConfig');
        Object.assign(this, init);
    }
}

export class StreamResequencerConfig extends CamelElement {
    capacity?: number;
    comparator?: string;
    deliveryAttemptInterval?: string;
    ignoreInvalidExchanges?: boolean;
    rejectOld?: boolean;
    timeout?: string;
    public constructor(init?: Partial<StreamResequencerConfig>) {
        super('StreamResequencerConfig');
        Object.assign(this, init);
    }
}

export class ASN1DataFormat extends CamelElement {
    dataFormatName?: string = 'asn1';
    id?: string = 'asn1-' + uuidv4().substring(0,4);
    unmarshalType?: string;
    usingIterator?: boolean;
    public constructor(init?: Partial<ASN1DataFormat>) {
        super('ASN1DataFormat');
        Object.assign(this, init);
    }
}

export class AvroDataFormat extends CamelElement {
    dataFormatName?: string = 'avro';
    id?: string = 'avro-' + uuidv4().substring(0,4);
    instanceClassName?: string;
    library?: string;
    objectMapper?: string;
    useDefaultObjectMapper?: boolean;
    unmarshalType?: string;
    jsonView?: string;
    include?: string;
    allowJmsType?: boolean;
    collectionType?: string;
    useList?: boolean;
    moduleClassNames?: string;
    moduleRefs?: string;
    enableFeatures?: string;
    disableFeatures?: string;
    allowUnmarshallType?: boolean;
    timezone?: string;
    autoDiscoverObjectMapper?: boolean;
    contentTypeHeader?: boolean;
    schemaResolver?: string;
    autoDiscoverSchemaResolver?: boolean;
    public constructor(init?: Partial<AvroDataFormat>) {
        super('AvroDataFormat');
        Object.assign(this, init);
    }
}

export class BarcodeDataFormat extends CamelElement {
    dataFormatName?: string = 'barcode';
    id?: string = 'barcode-' + uuidv4().substring(0,4);
    barcodeFormat?: string;
    imageType?: string;
    width?: number;
    height?: number;
    public constructor(init?: Partial<BarcodeDataFormat>) {
        super('BarcodeDataFormat');
        Object.assign(this, init);
    }
}

export class Base64DataFormat extends CamelElement {
    dataFormatName?: string = 'base64';
    id?: string = 'base64-' + uuidv4().substring(0,4);
    lineLength?: number;
    lineSeparator?: string;
    urlSafe?: boolean;
    public constructor(init?: Partial<Base64DataFormat>) {
        super('Base64DataFormat');
        Object.assign(this, init);
    }
}

export class BindyDataFormat extends CamelElement {
    dataFormatName?: string = 'bindy';
    id?: string = 'bindy-' + uuidv4().substring(0,4);
    type?: string;
    classType?: string;
    allowEmptyStream?: boolean;
    unwrapSingleInstance?: boolean;
    locale?: string;
    public constructor(init?: Partial<BindyDataFormat>) {
        super('BindyDataFormat');
        Object.assign(this, init);
    }
}

export class CBORDataFormat extends CamelElement {
    dataFormatName?: string = 'cbor';
    id?: string = 'cbor-' + uuidv4().substring(0,4);
    objectMapper?: string;
    useDefaultObjectMapper?: boolean;
    unmarshalType?: string;
    collectionType?: string;
    useList?: boolean;
    allowUnmarshallType?: boolean;
    prettyPrint?: boolean;
    allowJmsType?: boolean;
    enableFeatures?: string;
    disableFeatures?: string;
    public constructor(init?: Partial<CBORDataFormat>) {
        super('CBORDataFormat');
        Object.assign(this, init);
    }
}

export class CryptoDataFormat extends CamelElement {
    dataFormatName?: string = 'crypto';
    id?: string = 'crypto-' + uuidv4().substring(0,4);
    algorithm?: string;
    keyRef?: string;
    cryptoProvider?: string;
    initVectorRef?: string;
    algorithmParameterRef?: string;
    bufferSize?: number;
    macAlgorithm?: string;
    shouldAppendHMAC?: boolean;
    inline?: boolean;
    public constructor(init?: Partial<CryptoDataFormat>) {
        super('CryptoDataFormat');
        Object.assign(this, init);
    }
}

export class CsvDataFormat extends CamelElement {
    dataFormatName?: string = 'csv';
    id?: string = 'csv-' + uuidv4().substring(0,4);
    formatRef?: string;
    formatName?: string;
    commentMarkerDisabled?: boolean;
    commentMarker?: string;
    delimiter?: string;
    escapeDisabled?: boolean;
    escape?: string;
    headerDisabled?: boolean;
    header?: string[] = [];
    allowMissingColumnNames?: boolean;
    ignoreEmptyLines?: boolean;
    ignoreSurroundingSpaces?: boolean;
    nullStringDisabled?: boolean;
    nullString?: string;
    quoteDisabled?: boolean;
    quote?: string;
    recordSeparatorDisabled?: string;
    recordSeparator?: string;
    skipHeaderRecord?: boolean;
    quoteMode?: string;
    ignoreHeaderCase?: boolean;
    trim?: boolean;
    trailingDelimiter?: boolean;
    marshallerFactoryRef?: string;
    lazyLoad?: boolean;
    useMaps?: boolean;
    useOrderedMaps?: boolean;
    recordConverterRef?: string;
    captureHeaderRecord?: boolean;
    public constructor(init?: Partial<CsvDataFormat>) {
        super('CsvDataFormat');
        Object.assign(this, init);
    }
}

export class CustomDataFormat extends CamelElement {
    dataFormatName?: string = 'custom';
    id?: string = 'custom-' + uuidv4().substring(0,4);
    ref: string = '';
    public constructor(init?: Partial<CustomDataFormat>) {
        super('CustomDataFormat');
        Object.assign(this, init);
    }
}

export class DataFormatsDefinition extends CamelElement {
    stepName?: string = 'dataFormats';
    asn1?: ASN1DataFormat | string;
    avro?: AvroDataFormat | string;
    barcode?: BarcodeDataFormat;
    base64?: Base64DataFormat;
    bindy?: BindyDataFormat;
    cbor?: CBORDataFormat;
    crypto?: CryptoDataFormat;
    csv?: CsvDataFormat | string;
    custom?: CustomDataFormat | string;
    fhirJson?: FhirJsonDataFormat;
    fhirXml?: FhirXmlDataFormat;
    flatpack?: FlatpackDataFormat;
    grok?: GrokDataFormat;
    gzipDeflater?: GzipDeflaterDataFormat;
    hl7?: HL7DataFormat;
    ical?: IcalDataFormat;
    jacksonXml?: JacksonXMLDataFormat;
    jaxb?: JaxbDataFormat;
    json?: JsonDataFormat;
    jsonApi?: JsonApiDataFormat;
    lzf?: LZFDataFormat;
    mimeMultipart?: MimeMultipartDataFormat;
    parquetAvro?: ParquetAvroDataFormat | string;
    pgp?: PGPDataFormat;
    protobuf?: ProtobufDataFormat | string;
    rss?: RssDataFormat;
    soap?: SoapDataFormat | string;
    swiftMt?: SwiftMtDataFormat | string;
    swiftMx?: SwiftMxDataFormat;
    syslog?: SyslogDataFormat;
    tarFile?: TarFileDataFormat;
    thrift?: ThriftDataFormat | string;
    tidyMarkup?: TidyMarkupDataFormat;
    univocityCsv?: UniVocityCsvDataFormat;
    univocityFixed?: UniVocityFixedDataFormat;
    univocityTsv?: UniVocityTsvDataFormat;
    xmlSecurity?: XMLSecurityDataFormat;
    yaml?: YAMLDataFormat;
    zipDeflater?: ZipDeflaterDataFormat;
    zipFile?: ZipFileDataFormat;
    public constructor(init?: Partial<DataFormatsDefinition>) {
        super('DataFormatsDefinition');
        Object.assign(this, init);
    }
}

export class FhirJsonDataFormat extends CamelElement {
    dataFormatName?: string = 'fhirJson';
    id?: string = 'fhirJson-' + uuidv4().substring(0,4);
    fhirVersion?: string;
    fhirContext?: string;
    prettyPrint?: boolean;
    parserErrorHandler?: string;
    parserOptions?: string;
    preferTypes?: string;
    forceResourceId?: string;
    serverBaseUrl?: string;
    omitResourceId?: boolean;
    encodeElementsAppliesToChildResourcesOnly?: boolean;
    encodeElements?: string;
    dontEncodeElements?: string;
    stripVersionsFromReferences?: boolean;
    overrideResourceIdWithBundleEntryFullUrl?: boolean;
    summaryMode?: boolean;
    suppressNarratives?: boolean;
    dontStripVersionsFromReferencesAtPaths?: string;
    contentTypeHeader?: boolean;
    public constructor(init?: Partial<FhirJsonDataFormat>) {
        super('FhirJsonDataFormat');
        Object.assign(this, init);
    }
}

export class FhirXmlDataFormat extends CamelElement {
    dataFormatName?: string = 'fhirXml';
    id?: string = 'fhirXml-' + uuidv4().substring(0,4);
    fhirVersion?: string;
    fhirContext?: string;
    prettyPrint?: boolean;
    parserErrorHandler?: string;
    parserOptions?: string;
    preferTypes?: string;
    forceResourceId?: string;
    serverBaseUrl?: string;
    omitResourceId?: boolean;
    encodeElementsAppliesToChildResourcesOnly?: boolean;
    encodeElements?: string;
    dontEncodeElements?: string;
    stripVersionsFromReferences?: boolean;
    overrideResourceIdWithBundleEntryFullUrl?: boolean;
    summaryMode?: boolean;
    suppressNarratives?: boolean;
    dontStripVersionsFromReferencesAtPaths?: string;
    contentTypeHeader?: boolean;
    public constructor(init?: Partial<FhirXmlDataFormat>) {
        super('FhirXmlDataFormat');
        Object.assign(this, init);
    }
}

export class FlatpackDataFormat extends CamelElement {
    dataFormatName?: string = 'flatpack';
    id?: string = 'flatpack-' + uuidv4().substring(0,4);
    definition?: string;
    fixed?: boolean;
    delimiter?: string;
    ignoreFirstRecord?: boolean;
    allowShortLines?: boolean;
    ignoreExtraColumns?: boolean;
    textQualifier?: string;
    parserFactoryRef?: string;
    public constructor(init?: Partial<FlatpackDataFormat>) {
        super('FlatpackDataFormat');
        Object.assign(this, init);
    }
}

export class GrokDataFormat extends CamelElement {
    dataFormatName?: string = 'grok';
    id?: string = 'grok-' + uuidv4().substring(0,4);
    pattern: string = '';
    flattened?: boolean;
    allowMultipleMatchesPerLine?: boolean;
    namedOnly?: boolean;
    public constructor(init?: Partial<GrokDataFormat>) {
        super('GrokDataFormat');
        Object.assign(this, init);
    }
}

export class GzipDeflaterDataFormat extends CamelElement {
    dataFormatName?: string = 'gzipDeflater';
    id?: string = 'gzipDeflater-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<GzipDeflaterDataFormat>) {
        super('GzipDeflaterDataFormat');
        Object.assign(this, init);
    }
}

export class HL7DataFormat extends CamelElement {
    dataFormatName?: string = 'hl7';
    id?: string = 'hl7-' + uuidv4().substring(0,4);
    validate?: boolean;
    public constructor(init?: Partial<HL7DataFormat>) {
        super('HL7DataFormat');
        Object.assign(this, init);
    }
}

export class IcalDataFormat extends CamelElement {
    dataFormatName?: string = 'ical';
    id?: string = 'ical-' + uuidv4().substring(0,4);
    validating?: boolean;
    public constructor(init?: Partial<IcalDataFormat>) {
        super('IcalDataFormat');
        Object.assign(this, init);
    }
}

export class JacksonXMLDataFormat extends CamelElement {
    dataFormatName?: string = 'jacksonXml';
    id?: string = 'jacksonXml-' + uuidv4().substring(0,4);
    xmlMapper?: string;
    prettyPrint?: boolean;
    unmarshalType?: string;
    allowUnmarshallType?: boolean;
    jsonView?: string;
    include?: string;
    allowJmsType?: boolean;
    collectionType?: string;
    useList?: boolean;
    timezone?: string;
    enableJaxbAnnotationModule?: boolean;
    moduleClassNames?: string;
    moduleRefs?: string;
    enableFeatures?: string;
    disableFeatures?: string;
    contentTypeHeader?: boolean;
    public constructor(init?: Partial<JacksonXMLDataFormat>) {
        super('JacksonXMLDataFormat');
        Object.assign(this, init);
    }
}

export class JaxbDataFormat extends CamelElement {
    dataFormatName?: string = 'jaxb';
    id?: string = 'jaxb-' + uuidv4().substring(0,4);
    contextPath: string = '';
    contextPathIsClassName?: boolean;
    schema?: string;
    schemaSeverityLevel?: string;
    prettyPrint?: boolean;
    objectFactory?: boolean;
    ignoreJAXBElement?: boolean;
    mustBeJAXBElement?: boolean;
    filterNonXmlChars?: boolean;
    encoding?: string;
    fragment?: boolean;
    partClass?: string;
    partNamespace?: string;
    namespacePrefixRef?: string;
    xmlStreamWriterWrapper?: string;
    schemaLocation?: string;
    noNamespaceSchemaLocation?: string;
    jaxbProviderProperties?: string;
    contentTypeHeader?: boolean;
    accessExternalSchemaProtocols?: string;
    public constructor(init?: Partial<JaxbDataFormat>) {
        super('JaxbDataFormat');
        Object.assign(this, init);
    }
}

export class JsonApiDataFormat extends CamelElement {
    dataFormatName?: string = 'jsonApi';
    id?: string = 'jsonApi-' + uuidv4().substring(0,4);
    dataFormatTypes?: string;
    mainFormatType?: string;
    public constructor(init?: Partial<JsonApiDataFormat>) {
        super('JsonApiDataFormat');
        Object.assign(this, init);
    }
}

export class JsonDataFormat extends CamelElement {
    dataFormatName?: string = 'json';
    id?: string = 'json-' + uuidv4().substring(0,4);
    objectMapper?: string;
    useDefaultObjectMapper?: boolean;
    autoDiscoverObjectMapper?: boolean;
    prettyPrint?: boolean;
    library?: string;
    unmarshalType?: string;
    jsonView?: string;
    include?: string;
    allowJmsType?: boolean;
    collectionType?: string;
    useList?: boolean;
    moduleClassNames?: string;
    moduleRefs?: string;
    enableFeatures?: string;
    disableFeatures?: string;
    allowUnmarshallType?: boolean;
    timezone?: string;
    schemaResolver?: string;
    autoDiscoverSchemaResolver?: boolean;
    namingStrategy?: string;
    contentTypeHeader?: boolean;
    dateFormatPattern?: string;
    public constructor(init?: Partial<JsonDataFormat>) {
        super('JsonDataFormat');
        Object.assign(this, init);
    }
}

export class LZFDataFormat extends CamelElement {
    dataFormatName?: string = 'lzf';
    id?: string = 'lzf-' + uuidv4().substring(0,4);
    usingParallelCompression?: boolean;
    public constructor(init?: Partial<LZFDataFormat>) {
        super('LZFDataFormat');
        Object.assign(this, init);
    }
}

export class MimeMultipartDataFormat extends CamelElement {
    dataFormatName?: string = 'mimeMultipart';
    id?: string = 'mimeMultipart-' + uuidv4().substring(0,4);
    multipartSubType?: string;
    multipartWithoutAttachment?: boolean;
    headersInline?: boolean;
    includeHeaders?: string;
    binaryContent?: boolean;
    public constructor(init?: Partial<MimeMultipartDataFormat>) {
        super('MimeMultipartDataFormat');
        Object.assign(this, init);
    }
}

export class PGPDataFormat extends CamelElement {
    dataFormatName?: string = 'pgp';
    id?: string = 'pgp-' + uuidv4().substring(0,4);
    keyUserid?: string;
    signatureKeyUserid?: string;
    password?: string;
    signaturePassword?: string;
    keyFileName?: string;
    signatureKeyFileName?: string;
    signatureKeyRing?: string;
    armored?: boolean;
    integrity?: boolean;
    provider?: string;
    algorithm?: number;
    compressionAlgorithm?: number;
    hashAlgorithm?: number;
    signatureVerificationOption?: string;
    public constructor(init?: Partial<PGPDataFormat>) {
        super('PGPDataFormat');
        Object.assign(this, init);
    }
}

export class ParquetAvroDataFormat extends CamelElement {
    dataFormatName?: string = 'parquetAvro';
    id?: string = 'parquetAvro-' + uuidv4().substring(0,4);
    compressionCodecName?: string;
    unmarshalType?: string;
    lazyLoad?: boolean;
    public constructor(init?: Partial<ParquetAvroDataFormat>) {
        super('ParquetAvroDataFormat');
        Object.assign(this, init);
    }
}

export class ProtobufDataFormat extends CamelElement {
    dataFormatName?: string = 'protobuf';
    id?: string = 'protobuf-' + uuidv4().substring(0,4);
    instanceClass?: string;
    objectMapper?: string;
    useDefaultObjectMapper?: boolean;
    autoDiscoverObjectMapper?: boolean;
    library?: string;
    unmarshalType?: string;
    jsonView?: string;
    include?: string;
    allowJmsType?: boolean;
    collectionType?: string;
    useList?: boolean;
    moduleClassNames?: string;
    moduleRefs?: string;
    enableFeatures?: string;
    disableFeatures?: string;
    allowUnmarshallType?: boolean;
    timezone?: string;
    schemaResolver?: string;
    autoDiscoverSchemaResolver?: boolean;
    contentTypeFormat?: string;
    contentTypeHeader?: boolean;
    public constructor(init?: Partial<ProtobufDataFormat>) {
        super('ProtobufDataFormat');
        Object.assign(this, init);
    }
}

export class RssDataFormat extends CamelElement {
    dataFormatName?: string = 'rss';
    id?: string = 'rss-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<RssDataFormat>) {
        super('RssDataFormat');
        Object.assign(this, init);
    }
}

export class SoapDataFormat extends CamelElement {
    dataFormatName?: string = 'soap';
    id?: string = 'soap-' + uuidv4().substring(0,4);
    contextPath: string = '';
    encoding?: string;
    elementNameStrategyRef?: string;
    version?: string;
    namespacePrefixRef?: string;
    schema?: string;
    public constructor(init?: Partial<SoapDataFormat>) {
        super('SoapDataFormat');
        Object.assign(this, init);
    }
}

export class SwiftMtDataFormat extends CamelElement {
    dataFormatName?: string = 'swiftMt';
    id?: string = 'swiftMt-' + uuidv4().substring(0,4);
    writeInJson?: boolean;
    public constructor(init?: Partial<SwiftMtDataFormat>) {
        super('SwiftMtDataFormat');
        Object.assign(this, init);
    }
}

export class SwiftMxDataFormat extends CamelElement {
    dataFormatName?: string = 'swiftMx';
    id?: string = 'swiftMx-' + uuidv4().substring(0,4);
    writeConfigRef?: string;
    writeInJson?: boolean;
    readMessageId?: string;
    readConfigRef?: string;
    public constructor(init?: Partial<SwiftMxDataFormat>) {
        super('SwiftMxDataFormat');
        Object.assign(this, init);
    }
}

export class SyslogDataFormat extends CamelElement {
    dataFormatName?: string = 'syslog';
    id?: string = 'syslog-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<SyslogDataFormat>) {
        super('SyslogDataFormat');
        Object.assign(this, init);
    }
}

export class TarFileDataFormat extends CamelElement {
    dataFormatName?: string = 'tarFile';
    id?: string = 'tarFile-' + uuidv4().substring(0,4);
    usingIterator?: boolean;
    allowEmptyDirectory?: boolean;
    preservePathElements?: boolean;
    maxDecompressedSize?: number;
    public constructor(init?: Partial<TarFileDataFormat>) {
        super('TarFileDataFormat');
        Object.assign(this, init);
    }
}

export class ThriftDataFormat extends CamelElement {
    dataFormatName?: string = 'thrift';
    id?: string = 'thrift-' + uuidv4().substring(0,4);
    instanceClass?: string;
    contentTypeFormat?: string;
    contentTypeHeader?: boolean;
    public constructor(init?: Partial<ThriftDataFormat>) {
        super('ThriftDataFormat');
        Object.assign(this, init);
    }
}

export class TidyMarkupDataFormat extends CamelElement {
    dataFormatName?: string = 'tidyMarkup';
    id?: string = 'tidyMarkup-' + uuidv4().substring(0,4);
    dataObjectType?: string;
    omitXmlDeclaration?: boolean;
    public constructor(init?: Partial<TidyMarkupDataFormat>) {
        super('TidyMarkupDataFormat');
        Object.assign(this, init);
    }
}

export class UniVocityCsvDataFormat extends CamelElement {
    dataFormatName?: string = 'univocityCsv';
    id?: string = 'univocityCsv-' + uuidv4().substring(0,4);
    delimiter?: string;
    quoteAllFields?: boolean;
    quote?: string;
    quoteEscape?: string;
    nullValue?: string;
    skipEmptyLines?: boolean;
    ignoreTrailingWhitespaces?: boolean;
    ignoreLeadingWhitespaces?: boolean;
    headersDisabled?: boolean;
    headerExtractionEnabled?: boolean;
    numberOfRecordsToRead?: number;
    emptyValue?: string;
    lineSeparator?: string;
    normalizedLineSeparator?: string;
    comment?: string;
    lazyLoad?: boolean;
    asMap?: boolean;
    univocityHeader?: UniVocityHeader[] = [];
    public constructor(init?: Partial<UniVocityCsvDataFormat>) {
        super('UniVocityCsvDataFormat');
        Object.assign(this, init);
    }
}

export class UniVocityFixedDataFormat extends CamelElement {
    dataFormatName?: string = 'univocityFixed';
    id?: string = 'univocityFixed-' + uuidv4().substring(0,4);
    padding?: string;
    skipTrailingCharsUntilNewline?: boolean;
    recordEndsOnNewline?: boolean;
    nullValue?: string;
    skipEmptyLines?: boolean;
    ignoreTrailingWhitespaces?: boolean;
    ignoreLeadingWhitespaces?: boolean;
    headersDisabled?: boolean;
    headerExtractionEnabled?: boolean;
    numberOfRecordsToRead?: number;
    emptyValue?: string;
    lineSeparator?: string;
    normalizedLineSeparator?: string;
    comment?: string;
    lazyLoad?: boolean;
    asMap?: boolean;
    univocityHeader?: UniVocityHeader[] = [];
    public constructor(init?: Partial<UniVocityFixedDataFormat>) {
        super('UniVocityFixedDataFormat');
        Object.assign(this, init);
    }
}

export class UniVocityHeader extends CamelElement {
    length?: string;
    name?: string;
    public constructor(init?: Partial<UniVocityHeader>) {
        super('UniVocityHeader');
        Object.assign(this, init);
    }
}

export class UniVocityTsvDataFormat extends CamelElement {
    dataFormatName?: string = 'univocityTsv';
    id?: string = 'univocityTsv-' + uuidv4().substring(0,4);
    escapeChar?: string;
    nullValue?: string;
    skipEmptyLines?: boolean;
    ignoreTrailingWhitespaces?: boolean;
    ignoreLeadingWhitespaces?: boolean;
    headersDisabled?: boolean;
    headerExtractionEnabled?: boolean;
    numberOfRecordsToRead?: number;
    emptyValue?: string;
    lineSeparator?: string;
    normalizedLineSeparator?: string;
    comment?: string;
    lazyLoad?: boolean;
    asMap?: boolean;
    univocityHeader?: UniVocityHeader[] = [];
    public constructor(init?: Partial<UniVocityTsvDataFormat>) {
        super('UniVocityTsvDataFormat');
        Object.assign(this, init);
    }
}

export class XMLSecurityDataFormat extends CamelElement {
    dataFormatName?: string = 'xmlSecurity';
    id?: string = 'xmlSecurity-' + uuidv4().substring(0,4);
    xmlCipherAlgorithm?: string;
    passPhrase?: string;
    passPhraseByte?: string;
    secureTag?: string;
    secureTagContents?: boolean;
    keyCipherAlgorithm?: string;
    recipientKeyAlias?: string;
    keyOrTrustStoreParametersRef?: string;
    keyPassword?: string;
    digestAlgorithm?: string;
    mgfAlgorithm?: string;
    addKeyValueForEncryptedKey?: boolean;
    public constructor(init?: Partial<XMLSecurityDataFormat>) {
        super('XMLSecurityDataFormat');
        Object.assign(this, init);
    }
}

export class YAMLDataFormat extends CamelElement {
    dataFormatName?: string = 'yaml';
    id?: string = 'yaml-' + uuidv4().substring(0,4);
    library?: string;
    unmarshalType?: string;
    _constructor?: string;
    representer?: string;
    dumperOptions?: string;
    resolver?: string;
    useApplicationContextClassLoader?: boolean;
    prettyFlow?: boolean;
    allowAnyType?: boolean;
    typeFilter?: YAMLTypeFilterDefinition[] = [];
    maxAliasesForCollections?: number;
    allowRecursiveKeys?: boolean;
    public constructor(init?: Partial<YAMLDataFormat>) {
        super('YAMLDataFormat');
        Object.assign(this, init);
    }
}

export class YAMLTypeFilterDefinition extends CamelElement {
    stepName?: string = 'yAMLTypeFilter';
    type?: string;
    value?: string;
    public constructor(init?: Partial<YAMLTypeFilterDefinition>) {
        super('YAMLTypeFilterDefinition');
        Object.assign(this, init);
    }
}

export class ZipDeflaterDataFormat extends CamelElement {
    dataFormatName?: string = 'zipDeflater';
    id?: string = 'zipDeflater-' + uuidv4().substring(0,4);
    compressionLevel?: string;
    public constructor(init?: Partial<ZipDeflaterDataFormat>) {
        super('ZipDeflaterDataFormat');
        Object.assign(this, init);
    }
}

export class ZipFileDataFormat extends CamelElement {
    dataFormatName?: string = 'zipFile';
    id?: string = 'zipFile-' + uuidv4().substring(0,4);
    usingIterator?: boolean;
    allowEmptyDirectory?: boolean;
    preservePathElements?: boolean;
    maxDecompressedSize?: number;
    public constructor(init?: Partial<ZipFileDataFormat>) {
        super('ZipFileDataFormat');
        Object.assign(this, init);
    }
}

export class DeadLetterChannelDefinition extends CamelElement {
    stepName?: string = 'deadLetterChannel';
    id?: string = 'deadLetterChannel-' + uuidv4().substring(0,4);
    deadLetterUri: string = '';
    deadLetterHandleNewException?: boolean;
    redeliveryPolicy?: RedeliveryPolicyDefinition;
    useOriginalMessage?: boolean;
    useOriginalBody?: boolean;
    redeliveryPolicyRef?: string;
    loggerRef?: string;
    level?: string;
    logName?: string;
    onRedeliveryRef?: string;
    onExceptionOccurredRef?: string;
    onPrepareFailureRef?: string;
    retryWhileRef?: string;
    executorServiceRef?: string;
    public constructor(init?: Partial<DeadLetterChannelDefinition>) {
        super('DeadLetterChannelDefinition');
        Object.assign(this, init);
    }
}

export class DefaultErrorHandlerDefinition extends CamelElement {
    stepName?: string = 'defaultErrorHandler';
    id?: string = 'defaultErrorHandler-' + uuidv4().substring(0,4);
    redeliveryPolicy?: RedeliveryPolicyDefinition;
    useOriginalMessage?: boolean;
    useOriginalBody?: boolean;
    redeliveryPolicyRef?: string;
    loggerRef?: string;
    level?: string;
    logName?: string;
    onRedeliveryRef?: string;
    onExceptionOccurredRef?: string;
    onPrepareFailureRef?: string;
    retryWhileRef?: string;
    executorServiceRef?: string;
    public constructor(init?: Partial<DefaultErrorHandlerDefinition>) {
        super('DefaultErrorHandlerDefinition');
        Object.assign(this, init);
    }
}

export class JtaTransactionErrorHandlerDefinition extends CamelElement {
    stepName?: string = 'jtaTransactionErrorHandler';
    id?: string = 'jtaTransactionErrorHandler-' + uuidv4().substring(0,4);
    transactedPolicyRef?: string;
    rollbackLoggingLevel?: string;
    redeliveryPolicy?: RedeliveryPolicyDefinition;
    useOriginalMessage?: boolean;
    useOriginalBody?: boolean;
    redeliveryPolicyRef?: string;
    loggerRef?: string;
    level?: string;
    logName?: string;
    onRedeliveryRef?: string;
    onExceptionOccurredRef?: string;
    onPrepareFailureRef?: string;
    retryWhileRef?: string;
    executorServiceRef?: string;
    public constructor(init?: Partial<JtaTransactionErrorHandlerDefinition>) {
        super('JtaTransactionErrorHandlerDefinition');
        Object.assign(this, init);
    }
}

export class NoErrorHandlerDefinition extends CamelElement {
    stepName?: string = 'noErrorHandler';
    id?: string = 'noErrorHandler-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<NoErrorHandlerDefinition>) {
        super('NoErrorHandlerDefinition');
        Object.assign(this, init);
    }
}

export class RefErrorHandlerDefinition extends CamelElement {
    stepName?: string = 'refErrorHandler';
    id?: string = 'refErrorHandler-' + uuidv4().substring(0,4);
    ref: string = '';
    public constructor(init?: Partial<RefErrorHandlerDefinition>) {
        super('RefErrorHandlerDefinition');
        Object.assign(this, init);
    }
}

export class SpringTransactionErrorHandlerDefinition extends CamelElement {
    stepName?: string = 'springTransactionErrorHandler';
    id?: string = 'springTransactionErrorHandler-' + uuidv4().substring(0,4);
    transactedPolicyRef?: string;
    rollbackLoggingLevel?: string;
    redeliveryPolicy?: RedeliveryPolicyDefinition;
    useOriginalMessage?: boolean;
    useOriginalBody?: boolean;
    redeliveryPolicyRef?: string;
    loggerRef?: string;
    level?: string;
    logName?: string;
    onRedeliveryRef?: string;
    onExceptionOccurredRef?: string;
    onPrepareFailureRef?: string;
    retryWhileRef?: string;
    executorServiceRef?: string;
    public constructor(init?: Partial<SpringTransactionErrorHandlerDefinition>) {
        super('SpringTransactionErrorHandlerDefinition');
        Object.assign(this, init);
    }
}

export class CSimpleExpression extends CamelElement {
    expressionName?: string = 'csimple';
    id?: string = 'csimple-' + uuidv4().substring(0,4);
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    public constructor(init?: Partial<CSimpleExpression>) {
        super('CSimpleExpression');
        Object.assign(this, init);
    }
}

export class ConstantExpression extends CamelElement {
    expressionName?: string = 'constant';
    id?: string = 'constant-' + uuidv4().substring(0,4);
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    public constructor(init?: Partial<ConstantExpression>) {
        super('ConstantExpression');
        Object.assign(this, init);
    }
}

export class DatasonnetExpression extends CamelElement {
    expressionName?: string = 'datasonnet';
    id?: string = 'datasonnet-' + uuidv4().substring(0,4);
    expression: string = '';
    bodyMediaType?: string;
    outputMediaType?: string;
    resultType?: string;
    trim?: boolean;
    public constructor(init?: Partial<DatasonnetExpression>) {
        super('DatasonnetExpression');
        Object.assign(this, init);
    }
}

export class ExchangePropertyExpression extends CamelElement {
    expressionName?: string = 'exchangeProperty';
    id?: string = 'exchangeProperty-' + uuidv4().substring(0,4);
    expression: string = '';
    trim?: boolean;
    public constructor(init?: Partial<ExchangePropertyExpression>) {
        super('ExchangePropertyExpression');
        Object.assign(this, init);
    }
}

export class ExpressionDefinition extends CamelElement {
    stepName?: string = 'expression';
    constant?: ConstantExpression | string;
    csimple?: CSimpleExpression | string;
    datasonnet?: DatasonnetExpression | string;
    exchangeProperty?: ExchangePropertyExpression | string;
    groovy?: GroovyExpression | string;
    header?: HeaderExpression | string;
    hl7terser?: Hl7TerserExpression | string;
    java?: JavaExpression | string;
    joor?: JoorExpression | string;
    jq?: JqExpression | string;
    js?: JavaScriptExpression | string;
    jsonpath?: JsonPathExpression | string;
    language?: LanguageExpression;
    method?: MethodCallExpression | string;
    mvel?: MvelExpression | string;
    ognl?: OgnlExpression | string;
    python?: PythonExpression | string;
    ref?: RefExpression | string;
    simple?: SimpleExpression | string;
    spel?: SpELExpression | string;
    tokenize?: TokenizerExpression | string;
    xpath?: XPathExpression | string;
    xquery?: XQueryExpression | string;
    xtokenize?: XMLTokenizerExpression | string;
    public constructor(init?: Partial<ExpressionDefinition>) {
        super('ExpressionDefinition');
        Object.assign(this, init);
    }
}

export class GroovyExpression extends CamelElement {
    expressionName?: string = 'groovy';
    id?: string = 'groovy-' + uuidv4().substring(0,4);
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    public constructor(init?: Partial<GroovyExpression>) {
        super('GroovyExpression');
        Object.assign(this, init);
    }
}

export class HeaderExpression extends CamelElement {
    expressionName?: string = 'header';
    id?: string = 'header-' + uuidv4().substring(0,4);
    expression: string = '';
    trim?: boolean;
    public constructor(init?: Partial<HeaderExpression>) {
        super('HeaderExpression');
        Object.assign(this, init);
    }
}

export class Hl7TerserExpression extends CamelElement {
    expressionName?: string = 'hl7terser';
    id?: string = 'hl7terser-' + uuidv4().substring(0,4);
    expression: string = '';
    headerName?: string;
    propertyName?: string;
    resultType?: string;
    trim?: boolean;
    public constructor(init?: Partial<Hl7TerserExpression>) {
        super('Hl7TerserExpression');
        Object.assign(this, init);
    }
}

export class JavaExpression extends CamelElement {
    expressionName?: string = 'java';
    id?: string = 'java-' + uuidv4().substring(0,4);
    expression: string = '';
    preCompile?: boolean;
    singleQuotes?: boolean;
    resultType?: string;
    trim?: boolean;
    public constructor(init?: Partial<JavaExpression>) {
        super('JavaExpression');
        Object.assign(this, init);
    }
}

export class JavaScriptExpression extends CamelElement {
    expressionName?: string = 'js';
    id?: string = 'js-' + uuidv4().substring(0,4);
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    public constructor(init?: Partial<JavaScriptExpression>) {
        super('JavaScriptExpression');
        Object.assign(this, init);
    }
}

export class JoorExpression extends CamelElement {
    expressionName?: string = 'joor';
    id?: string = 'joor-' + uuidv4().substring(0,4);
    expression: string = '';
    preCompile?: boolean;
    singleQuotes?: boolean;
    resultType?: string;
    trim?: boolean;
    public constructor(init?: Partial<JoorExpression>) {
        super('JoorExpression');
        Object.assign(this, init);
    }
}

export class JqExpression extends CamelElement {
    expressionName?: string = 'jq';
    id?: string = 'jq-' + uuidv4().substring(0,4);
    expression: string = '';
    headerName?: string;
    propertyName?: string;
    resultType?: string;
    trim?: boolean;
    public constructor(init?: Partial<JqExpression>) {
        super('JqExpression');
        Object.assign(this, init);
    }
}

export class JsonPathExpression extends CamelElement {
    expressionName?: string = 'jsonpath';
    id?: string = 'jsonpath-' + uuidv4().substring(0,4);
    expression: string = '';
    suppressExceptions?: boolean;
    allowSimple?: boolean;
    allowEasyPredicate?: boolean;
    writeAsString?: boolean;
    unpackArray?: boolean;
    option?: string;
    headerName?: string;
    propertyName?: string;
    resultType?: string;
    trim?: boolean;
    public constructor(init?: Partial<JsonPathExpression>) {
        super('JsonPathExpression');
        Object.assign(this, init);
    }
}

export class LanguageExpression extends CamelElement {
    expressionName?: string = 'language';
    id?: string = 'language-' + uuidv4().substring(0,4);
    language: string = '';
    expression: string = '';
    trim?: boolean;
    public constructor(init?: Partial<LanguageExpression>) {
        super('LanguageExpression');
        Object.assign(this, init);
    }
}

export class MethodCallExpression extends CamelElement {
    expressionName?: string = 'method';
    id?: string = 'method-' + uuidv4().substring(0,4);
    ref?: string;
    method?: string;
    beanType?: string;
    scope?: string;
    validate?: boolean;
    resultType?: string;
    trim?: boolean;
    public constructor(init?: Partial<MethodCallExpression>) {
        super('MethodCallExpression');
        Object.assign(this, init);
    }
}

export class MvelExpression extends CamelElement {
    expressionName?: string = 'mvel';
    id?: string = 'mvel-' + uuidv4().substring(0,4);
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    public constructor(init?: Partial<MvelExpression>) {
        super('MvelExpression');
        Object.assign(this, init);
    }
}

export class OgnlExpression extends CamelElement {
    expressionName?: string = 'ognl';
    id?: string = 'ognl-' + uuidv4().substring(0,4);
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    public constructor(init?: Partial<OgnlExpression>) {
        super('OgnlExpression');
        Object.assign(this, init);
    }
}

export class PythonExpression extends CamelElement {
    expressionName?: string = 'python';
    id?: string = 'python-' + uuidv4().substring(0,4);
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    public constructor(init?: Partial<PythonExpression>) {
        super('PythonExpression');
        Object.assign(this, init);
    }
}

export class RefExpression extends CamelElement {
    expressionName?: string = 'ref';
    id?: string = 'ref-' + uuidv4().substring(0,4);
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    public constructor(init?: Partial<RefExpression>) {
        super('RefExpression');
        Object.assign(this, init);
    }
}

export class SimpleExpression extends CamelElement {
    expressionName?: string = 'simple';
    id?: string = 'simple-' + uuidv4().substring(0,4);
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    public constructor(init?: Partial<SimpleExpression>) {
        super('SimpleExpression');
        Object.assign(this, init);
    }
}

export class SpELExpression extends CamelElement {
    expressionName?: string = 'spel';
    id?: string = 'spel-' + uuidv4().substring(0,4);
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    public constructor(init?: Partial<SpELExpression>) {
        super('SpELExpression');
        Object.assign(this, init);
    }
}

export class TokenizerExpression extends CamelElement {
    expressionName?: string = 'tokenize';
    id?: string = 'tokenize-' + uuidv4().substring(0,4);
    token: string = '';
    endToken?: string;
    inheritNamespaceTagName?: string;
    regex?: boolean;
    xml?: boolean;
    includeTokens?: boolean;
    group?: string;
    groupDelimiter?: string;
    skipFirst?: boolean;
    headerName?: string;
    propertyName?: string;
    trim?: boolean;
    public constructor(init?: Partial<TokenizerExpression>) {
        super('TokenizerExpression');
        Object.assign(this, init);
    }
}

export class XMLTokenizerExpression extends CamelElement {
    expressionName?: string = 'xtokenize';
    id?: string = 'xtokenize-' + uuidv4().substring(0,4);
    expression: string = '';
    mode?: string;
    group?: number;
    namespace?: PropertyDefinition[] = [];
    headerName?: string;
    propertyName?: string;
    trim?: boolean;
    public constructor(init?: Partial<XMLTokenizerExpression>) {
        super('XMLTokenizerExpression');
        Object.assign(this, init);
    }
}

export class XPathExpression extends CamelElement {
    expressionName?: string = 'xpath';
    id?: string = 'xpath-' + uuidv4().substring(0,4);
    expression: string = '';
    documentType?: string;
    resultType?: string;
    saxon?: boolean;
    factoryRef?: string;
    objectModel?: string;
    logNamespaces?: boolean;
    threadSafety?: boolean;
    preCompile?: boolean;
    namespace?: PropertyDefinition[] = [];
    headerName?: string;
    propertyName?: string;
    trim?: boolean;
    public constructor(init?: Partial<XPathExpression>) {
        super('XPathExpression');
        Object.assign(this, init);
    }
}

export class XQueryExpression extends CamelElement {
    expressionName?: string = 'xquery';
    id?: string = 'xquery-' + uuidv4().substring(0,4);
    expression: string = '';
    resultType?: string;
    type?: string;
    configurationRef?: string;
    namespace?: PropertyDefinition[] = [];
    headerName?: string;
    propertyName?: string;
    trim?: boolean;
    public constructor(init?: Partial<XQueryExpression>) {
        super('XQueryExpression');
        Object.assign(this, init);
    }
}

export class CustomLoadBalancerDefinition extends CamelElement {
    stepName?: string = 'customLoadBalancer';
    id?: string = 'customLoadBalancer-' + uuidv4().substring(0,4);
    ref: string = '';
    public constructor(init?: Partial<CustomLoadBalancerDefinition>) {
        super('CustomLoadBalancerDefinition');
        Object.assign(this, init);
    }
}

export class FailoverLoadBalancerDefinition extends CamelElement {
    stepName?: string = 'failoverLoadBalancer';
    exception?: string[] = [];
    id?: string = 'failoverLoadBalancer-' + uuidv4().substring(0,4);
    maximumFailoverAttempts?: string;
    roundRobin?: string;
    sticky?: string;
    public constructor(init?: Partial<FailoverLoadBalancerDefinition>) {
        super('FailoverLoadBalancerDefinition');
        Object.assign(this, init);
    }
}

export class RandomLoadBalancerDefinition extends CamelElement {
    stepName?: string = 'randomLoadBalancer';
    id?: string = 'randomLoadBalancer-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<RandomLoadBalancerDefinition>) {
        super('RandomLoadBalancerDefinition');
        Object.assign(this, init);
    }
}

export class RoundRobinLoadBalancerDefinition extends CamelElement {
    stepName?: string = 'roundRobinLoadBalancer';
    id?: string = 'roundRobinLoadBalancer-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<RoundRobinLoadBalancerDefinition>) {
        super('RoundRobinLoadBalancerDefinition');
        Object.assign(this, init);
    }
}

export class StickyLoadBalancerDefinition extends CamelElement {
    stepName?: string = 'stickyLoadBalancer';
    correlationExpression?: ExpressionSubElementDefinition;
    id?: string = 'stickyLoadBalancer-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<StickyLoadBalancerDefinition>) {
        super('StickyLoadBalancerDefinition');
        Object.assign(this, init);
    }
}

export class TopicLoadBalancerDefinition extends CamelElement {
    stepName?: string = 'topicLoadBalancer';
    id?: string = 'topicLoadBalancer-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<TopicLoadBalancerDefinition>) {
        super('TopicLoadBalancerDefinition');
        Object.assign(this, init);
    }
}

export class WeightedLoadBalancerDefinition extends CamelElement {
    stepName?: string = 'weightedLoadBalancer';
    distributionRatio: string = '';
    distributionRatioDelimiter?: string;
    id?: string = 'weightedLoadBalancer-' + uuidv4().substring(0,4);
    roundRobin?: boolean;
    public constructor(init?: Partial<WeightedLoadBalancerDefinition>) {
        super('WeightedLoadBalancerDefinition');
        Object.assign(this, init);
    }
}

export class ApiKeyDefinition extends CamelElement {
    stepName?: string = 'apiKey';
    description?: string;
    name: string = '';
    key: string = '';
    inHeader?: boolean;
    inQuery?: boolean;
    inCookie?: boolean;
    public constructor(init?: Partial<ApiKeyDefinition>) {
        super('ApiKeyDefinition');
        Object.assign(this, init);
    }
}

export class BasicAuthDefinition extends CamelElement {
    stepName?: string = 'basicAuth';
    description?: string;
    key: string = '';
    public constructor(init?: Partial<BasicAuthDefinition>) {
        super('BasicAuthDefinition');
        Object.assign(this, init);
    }
}

export class BearerTokenDefinition extends CamelElement {
    stepName?: string = 'bearerToken';
    description?: string;
    key: string = '';
    format?: string;
    public constructor(init?: Partial<BearerTokenDefinition>) {
        super('BearerTokenDefinition');
        Object.assign(this, init);
    }
}

export class DeleteDefinition extends CamelElement {
    stepName?: string = 'delete';
    id?: string = 'delete-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    path?: string;
    to?: string;
    consumes?: string;
    produces?: string;
    type?: string;
    outType?: string;
    bindingMode?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCORS?: boolean;
    enableNoContentResponse?: boolean;
    apiDocs?: boolean;
    deprecated?: boolean;
    routeId?: string;
    param?: ParamDefinition[] = [];
    responseMessage?: ResponseMessageDefinition[] = [];
    security?: SecurityDefinition[] = [];
    public constructor(init?: Partial<DeleteDefinition>) {
        super('DeleteDefinition');
        Object.assign(this, init);
    }
}

export class GetDefinition extends CamelElement {
    stepName?: string = 'get';
    id?: string = 'get-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    path?: string;
    to?: string;
    consumes?: string;
    produces?: string;
    type?: string;
    outType?: string;
    bindingMode?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCORS?: boolean;
    enableNoContentResponse?: boolean;
    apiDocs?: boolean;
    deprecated?: boolean;
    routeId?: string;
    param?: ParamDefinition[] = [];
    responseMessage?: ResponseMessageDefinition[] = [];
    security?: SecurityDefinition[] = [];
    public constructor(init?: Partial<GetDefinition>) {
        super('GetDefinition');
        Object.assign(this, init);
    }
}

export class HeadDefinition extends CamelElement {
    stepName?: string = 'head';
    id?: string = 'head-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    path?: string;
    to?: string;
    consumes?: string;
    produces?: string;
    type?: string;
    outType?: string;
    bindingMode?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCORS?: boolean;
    enableNoContentResponse?: boolean;
    apiDocs?: boolean;
    deprecated?: boolean;
    routeId?: string;
    param?: ParamDefinition[] = [];
    responseMessage?: ResponseMessageDefinition[] = [];
    security?: SecurityDefinition[] = [];
    public constructor(init?: Partial<HeadDefinition>) {
        super('HeadDefinition');
        Object.assign(this, init);
    }
}

export class MutualTLSDefinition extends CamelElement {
    stepName?: string = 'mutualTLS';
    description?: string;
    key: string = '';
    public constructor(init?: Partial<MutualTLSDefinition>) {
        super('MutualTLSDefinition');
        Object.assign(this, init);
    }
}

export class OAuth2Definition extends CamelElement {
    stepName?: string = 'oAuth2';
    authorizationUrl?: string;
    description?: string;
    flow?: string;
    key: string = '';
    refreshUrl?: string;
    scopes?: RestPropertyDefinition[] = [];
    tokenUrl?: string;
    public constructor(init?: Partial<OAuth2Definition>) {
        super('OAuth2Definition');
        Object.assign(this, init);
    }
}

export class OpenIdConnectDefinition extends CamelElement {
    stepName?: string = 'openIdConnect';
    description?: string;
    key: string = '';
    url: string = '';
    public constructor(init?: Partial<OpenIdConnectDefinition>) {
        super('OpenIdConnectDefinition');
        Object.assign(this, init);
    }
}

export class ParamDefinition extends CamelElement {
    stepName?: string = 'param';
    description?: string;
    name: string = '';
    type?: string;
    defaultValue?: string;
    required?: boolean;
    collectionFormat?: string;
    arrayType?: string;
    dataType?: string;
    dataFormat?: string;
    allowableValues?: ValueDefinition[] = [];
    examples?: RestPropertyDefinition[] = [];
    public constructor(init?: Partial<ParamDefinition>) {
        super('ParamDefinition');
        Object.assign(this, init);
    }
}

export class PatchDefinition extends CamelElement {
    stepName?: string = 'patch';
    id?: string = 'patch-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    path?: string;
    to?: string;
    consumes?: string;
    produces?: string;
    type?: string;
    outType?: string;
    bindingMode?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCORS?: boolean;
    enableNoContentResponse?: boolean;
    apiDocs?: boolean;
    deprecated?: boolean;
    routeId?: string;
    param?: ParamDefinition[] = [];
    responseMessage?: ResponseMessageDefinition[] = [];
    security?: SecurityDefinition[] = [];
    public constructor(init?: Partial<PatchDefinition>) {
        super('PatchDefinition');
        Object.assign(this, init);
    }
}

export class PostDefinition extends CamelElement {
    stepName?: string = 'post';
    id?: string = 'post-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    path?: string;
    to?: string;
    consumes?: string;
    produces?: string;
    type?: string;
    outType?: string;
    bindingMode?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCORS?: boolean;
    enableNoContentResponse?: boolean;
    apiDocs?: boolean;
    deprecated?: boolean;
    routeId?: string;
    param?: ParamDefinition[] = [];
    responseMessage?: ResponseMessageDefinition[] = [];
    security?: SecurityDefinition[] = [];
    public constructor(init?: Partial<PostDefinition>) {
        super('PostDefinition');
        Object.assign(this, init);
    }
}

export class PutDefinition extends CamelElement {
    stepName?: string = 'put';
    id?: string = 'put-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    path?: string;
    to?: string;
    consumes?: string;
    produces?: string;
    type?: string;
    outType?: string;
    bindingMode?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCORS?: boolean;
    enableNoContentResponse?: boolean;
    apiDocs?: boolean;
    deprecated?: boolean;
    routeId?: string;
    param?: ParamDefinition[] = [];
    responseMessage?: ResponseMessageDefinition[] = [];
    security?: SecurityDefinition[] = [];
    public constructor(init?: Partial<PutDefinition>) {
        super('PutDefinition');
        Object.assign(this, init);
    }
}

export class ResponseHeaderDefinition extends CamelElement {
    stepName?: string = 'responseHeader';
    description?: string;
    name: string = '';
    collectionFormat?: string;
    arrayType?: string;
    dataType?: string;
    dataFormat?: string;
    allowableValues?: ValueDefinition[] = [];
    example?: string;
    public constructor(init?: Partial<ResponseHeaderDefinition>) {
        super('ResponseHeaderDefinition');
        Object.assign(this, init);
    }
}

export class ResponseMessageDefinition extends CamelElement {
    stepName?: string = 'responseMessage';
    code?: string;
    message: string = '';
    responseModel?: string;
    header?: ResponseHeaderDefinition[] = [];
    examples?: RestPropertyDefinition[] = [];
    public constructor(init?: Partial<ResponseMessageDefinition>) {
        super('ResponseMessageDefinition');
        Object.assign(this, init);
    }
}

export class RestBindingDefinition extends CamelElement {
    stepName?: string = 'restBinding';
    id?: string = 'restBinding-' + uuidv4().substring(0,4);
    description?: string;
    consumes?: string;
    produces?: string;
    bindingMode?: string;
    type?: string;
    outType?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCORS?: boolean;
    enableNoContentResponse?: boolean;
    component?: string;
    public constructor(init?: Partial<RestBindingDefinition>) {
        super('RestBindingDefinition');
        Object.assign(this, init);
    }
}

export class RestConfigurationDefinition extends CamelElement {
    stepName?: string = 'restConfiguration';
    component?: string;
    apiComponent?: string;
    producerComponent?: string;
    scheme?: string;
    host?: string;
    port?: string;
    apiHost?: string;
    useXForwardHeaders?: boolean;
    producerApiDoc?: string;
    contextPath?: string;
    apiContextPath?: string;
    apiContextRouteId?: string;
    apiVendorExtension?: boolean;
    hostNameResolver?: string;
    bindingMode?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCORS?: boolean;
    enableNoContentResponse?: boolean;
    inlineRoutes?: boolean;
    jsonDataFormat?: string;
    xmlDataFormat?: string;
    componentProperty?: RestPropertyDefinition[] = [];
    endpointProperty?: RestPropertyDefinition[] = [];
    consumerProperty?: RestPropertyDefinition[] = [];
    dataFormatProperty?: RestPropertyDefinition[] = [];
    apiProperty?: RestPropertyDefinition[] = [];
    corsHeaders?: RestPropertyDefinition[] = [];
    public constructor(init?: Partial<RestConfigurationDefinition>) {
        super('RestConfigurationDefinition');
        Object.assign(this, init);
    }
}

export class RestDefinition extends CamelElement {
    stepName?: string = 'rest';
    id?: string = 'rest-' + uuidv4().substring(0,4);
    description?: string;
    disabled?: boolean;
    path?: string;
    consumes?: string;
    produces?: string;
    bindingMode?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCORS?: boolean;
    enableNoContentResponse?: boolean;
    apiDocs?: boolean;
    tag?: string;
    securityDefinitions?: RestSecuritiesDefinition;
    securityRequirements?: SecurityDefinition[] = [];
    delete?: DeleteDefinition[] = [];
    get?: GetDefinition[] = [];
    head?: HeadDefinition[] = [];
    patch?: PatchDefinition[] = [];
    post?: PostDefinition[] = [];
    put?: PutDefinition[] = [];
    public constructor(init?: Partial<RestDefinition>) {
        super('RestDefinition');
        Object.assign(this, init);
    }
}

export class RestPropertyDefinition extends CamelElement {
    stepName?: string = 'restProperty';
    key: string = '';
    value: string = '';
    public constructor(init?: Partial<RestPropertyDefinition>) {
        super('RestPropertyDefinition');
        Object.assign(this, init);
    }
}

export class RestSecuritiesDefinition extends CamelElement {
    stepName?: string = 'securityDefinitions';
    apiKey?: ApiKeyDefinition;
    basicAuth?: BasicAuthDefinition;
    bearer?: BearerTokenDefinition;
    mutualTLS?: MutualTLSDefinition;
    oauth2?: OAuth2Definition;
    openIdConnect?: OpenIdConnectDefinition;
    public constructor(init?: Partial<RestSecuritiesDefinition>) {
        super('RestSecuritiesDefinition');
        Object.assign(this, init);
    }
}

export class RestsDefinition extends CamelElement {
    stepName?: string = 'rests';
    id?: string = 'rests-' + uuidv4().substring(0,4);
    description?: string;
    rest?: RestDefinition[] = [];
    public constructor(init?: Partial<RestsDefinition>) {
        super('RestsDefinition');
        Object.assign(this, init);
    }
}

export class SecurityDefinition extends CamelElement {
    stepName?: string = 'security';
    key: string = '';
    scopes?: string;
    public constructor(init?: Partial<SecurityDefinition>) {
        super('SecurityDefinition');
        Object.assign(this, init);
    }
}

export class CustomTransformerDefinition extends CamelElement {
    stepName?: string = 'customTransformer';
    className?: string;
    fromType?: string;
    name?: string;
    ref?: string;
    scheme?: string;
    toType?: string;
    public constructor(init?: Partial<CustomTransformerDefinition>) {
        super('CustomTransformerDefinition');
        Object.assign(this, init);
    }
}

export class DataFormatTransformerDefinition extends CamelElement {
    stepName?: string = 'dataFormatTransformer';
    asn1?: ASN1DataFormat | string;
    avro?: AvroDataFormat | string;
    barcode?: BarcodeDataFormat;
    base64?: Base64DataFormat;
    bindy?: BindyDataFormat;
    cbor?: CBORDataFormat;
    crypto?: CryptoDataFormat;
    csv?: CsvDataFormat | string;
    custom?: CustomDataFormat | string;
    fhirJson?: FhirJsonDataFormat;
    fhirXml?: FhirXmlDataFormat;
    flatpack?: FlatpackDataFormat;
    grok?: GrokDataFormat;
    gzipDeflater?: GzipDeflaterDataFormat;
    hl7?: HL7DataFormat;
    ical?: IcalDataFormat;
    jacksonXml?: JacksonXMLDataFormat;
    jaxb?: JaxbDataFormat;
    json?: JsonDataFormat;
    jsonApi?: JsonApiDataFormat;
    lzf?: LZFDataFormat;
    mimeMultipart?: MimeMultipartDataFormat;
    parquetAvro?: ParquetAvroDataFormat | string;
    pgp?: PGPDataFormat;
    protobuf?: ProtobufDataFormat | string;
    rss?: RssDataFormat;
    soap?: SoapDataFormat | string;
    swiftMt?: SwiftMtDataFormat | string;
    swiftMx?: SwiftMxDataFormat;
    syslog?: SyslogDataFormat;
    tarFile?: TarFileDataFormat;
    thrift?: ThriftDataFormat | string;
    tidyMarkup?: TidyMarkupDataFormat;
    univocityCsv?: UniVocityCsvDataFormat;
    univocityFixed?: UniVocityFixedDataFormat;
    univocityTsv?: UniVocityTsvDataFormat;
    xmlSecurity?: XMLSecurityDataFormat;
    yaml?: YAMLDataFormat;
    zipDeflater?: ZipDeflaterDataFormat;
    zipFile?: ZipFileDataFormat;
    fromType?: string;
    name?: string;
    scheme?: string;
    toType?: string;
    public constructor(init?: Partial<DataFormatTransformerDefinition>) {
        super('DataFormatTransformerDefinition');
        Object.assign(this, init);
    }
}

export class EndpointTransformerDefinition extends CamelElement {
    stepName?: string = 'endpointTransformer';
    fromType?: string;
    name?: string;
    ref?: string;
    scheme?: string;
    toType?: string;
    uri?: string;
    public constructor(init?: Partial<EndpointTransformerDefinition>) {
        super('EndpointTransformerDefinition');
        Object.assign(this, init);
    }
}

export class LoadTransformerDefinition extends CamelElement {
    stepName?: string = 'loadTransformer';
    defaults?: boolean;
    fromType?: string;
    name?: string;
    packageScan?: string;
    scheme?: string;
    toType?: string;
    public constructor(init?: Partial<LoadTransformerDefinition>) {
        super('LoadTransformerDefinition');
        Object.assign(this, init);
    }
}

export class TransformersDefinition extends CamelElement {
    stepName?: string = 'transformers';
    customTransformer?: CustomTransformerDefinition;
    dataFormatTransformer?: DataFormatTransformerDefinition;
    endpointTransformer?: EndpointTransformerDefinition;
    loadTransformer?: LoadTransformerDefinition;
    public constructor(init?: Partial<TransformersDefinition>) {
        super('TransformersDefinition');
        Object.assign(this, init);
    }
}

export class CustomValidatorDefinition extends CamelElement {
    stepName?: string = 'customValidator';
    className?: string;
    ref?: string;
    type?: string;
    public constructor(init?: Partial<CustomValidatorDefinition>) {
        super('CustomValidatorDefinition');
        Object.assign(this, init);
    }
}

export class EndpointValidatorDefinition extends CamelElement {
    stepName?: string = 'endpointValidator';
    ref?: string;
    type?: string;
    uri?: string;
    public constructor(init?: Partial<EndpointValidatorDefinition>) {
        super('EndpointValidatorDefinition');
        Object.assign(this, init);
    }
}

export class PredicateValidatorDefinition extends CamelElement {
    stepName?: string = 'predicateValidator';
    expression?: ExpressionDefinition;
    type?: string;
    public constructor(init?: Partial<PredicateValidatorDefinition>) {
        super('PredicateValidatorDefinition');
        Object.assign(this, init);
    }
}

export class ValidatorsDefinition extends CamelElement {
    stepName?: string = 'validators';
    customValidator?: CustomValidatorDefinition;
    endpointValidator?: EndpointValidatorDefinition;
    predicateValidator?: PredicateValidatorDefinition;
    public constructor(init?: Partial<ValidatorsDefinition>) {
        super('ValidatorsDefinition');
        Object.assign(this, init);
    }
}

