![Build](https://img.shields.io/badge/Build_with-Fun-blue.svg?style=for-the-badge)
![Camel](https://img.shields.io/badge/-Camel-blue.svg?style=for-the-badge&)
![Java](https://img.shields.io/badge/-Java-blue.svg?style=for-the-badge&logo=java)
![Quarkus](https://img.shields.io/badge/-Quarkus-blue.svg?style=for-the-badge&logo=quarkus)
![React](https://img.shields.io/badge/-React-blue.svg?style=for-the-badge&logo=react)
![Typescript](https://img.shields.io/badge/-Typescript-blue.svg?style=for-the-badge&logo=typescript)
![License](https://img.shields.io/badge/License-Apache-blue.svg?style=for-the-badge&logo=apache)

## Apache Camel Karavan 

**Apache Camel Karavan** is a **Low-Code Data Integration Platform** 

<img align="right" width="400" src="images/karavan-clouds-large.png">

It simplifies the Apache Camel experience and accelerates developer performance by visually designing and rapidly deploying integration microservices.

* Full power of Apache Camel through Visual Tool
* From Low-code use-cases to Pro-code projects
* Powered by 10+ years of Community Intelligence

## Features

### Designer

* Enterprise Integration Patterns
* 300+ Integration Components 
* REST API designer with OpenAPI to REST DSL generator
* YAML for Integration and Java custom code

### Deployer
* Simple shell scripts for build and deploy
* Configuration 
* Predefined customizable scripts for different platforms

<img align="right" width="400" src="images/karavan-dashboard.png">

### Dashboard
* Monitoring running integration microservices
* View live logs during development
* Tracing Exchange Data 

### Local
Karavan provides VS Code extension for local developer experience
* Design, code and run integrations on your laptop or PC 
* Deploy to Kubernetes or Openshift
* Download from [Marketplace](https://marketplace.visualstudio.com/items?itemName=camel-karavan.karavan) or [Open VSX Registry](https://open-vsx.org/extension/camel-karavan/karavan)

## Documentation

### How to install on
* [Docker](docs/WEB_DOCKER.md)
* [Kubernetes](docs/WEB_KUBERNETES.md)
* [Openshift](docs/WEB_OPENSHIFT.md)

### Developer guide
* [Architecture](docs/ARCHITECTURE.md)
* [How to build](docs/DEV.md)


### Feedback
If you haven't done so yet, please be sure to download Karavan and give it a try. We're excited to receive your feedback and learn about your experiences!

* [Ask questions](https://github.com/apache/camel-karavan/discussions)
* [Open Issues](https://github.com/apache/camel-karavan/issues)

