/**
 * Generated by karavan build tools - do NOT edit this file!
 */
import {v4 as uuidv4} from 'uuid';
import {CamelElement} from "./IntegrationDefinition";
export class ProcessorDefinition extends CamelElement {
    stepName?: string = 'processor';
    aggregate?: AggregateDefinition;
    bean?: BeanDefinition | string;
    doCatch?: CatchDefinition;
    choice?: ChoiceDefinition;
    circuitBreaker?: CircuitBreakerDefinition;
    claimCheck?: ClaimCheckDefinition;
    convertBodyTo?: ConvertBodyDefinition | string;
    delay?: DelayDefinition;
    dynamicRouter?: DynamicRouterDefinition;
    enrich?: EnrichDefinition;
    filter?: FilterDefinition;
    doFinally?: FinallyDefinition;
    idempotentConsumer?: IdempotentConsumerDefinition;
    inOnly?: InOnlyDefinition | string;
    inOut?: InOutDefinition | string;
    intercept?: InterceptDefinition;
    interceptFrom?: InterceptFromDefinition | string;
    interceptSendToEndpoint?: InterceptSendToEndpointDefinition | string;
    kamelet?: KameletDefinition | string;
    loadBalance?: LoadBalanceDefinition;
    log?: LogDefinition | string;
    loop?: LoopDefinition;
    marshal?: MarshalDefinition;
    multicast?: MulticastDefinition;
    onCompletion?: OnCompletionDefinition;
    onFallback?: OnFallbackDefinition;
    otherwise?: OtherwiseDefinition;
    pausable?: PausableDefinition;
    pipeline?: PipelineDefinition;
    policy?: PolicyDefinition;
    pollEnrich?: PollEnrichDefinition;
    process?: ProcessDefinition;
    recipientList?: RecipientListDefinition;
    removeHeader?: RemoveHeaderDefinition | string;
    removeHeaders?: RemoveHeadersDefinition | string;
    removeProperties?: RemovePropertiesDefinition | string;
    removeProperty?: RemovePropertyDefinition | string;
    resequence?: ResequenceDefinition;
    resumable?: ResumableDefinition;
    rollback?: RollbackDefinition | string;
    routingSlip?: RoutingSlipDefinition | string;
    saga?: SagaDefinition;
    sample?: SamplingDefinition | string;
    script?: ScriptDefinition;
    setBody?: SetBodyDefinition;
    setExchangePattern?: SetExchangePatternDefinition | string;
    setHeader?: SetHeaderDefinition;
    setProperty?: SetPropertyDefinition;
    sort?: SortDefinition;
    split?: SplitDefinition;
    step?: StepDefinition;
    stop?: StopDefinition;
    threads?: ThreadsDefinition;
    throttle?: ThrottleDefinition;
    throwException?: ThrowExceptionDefinition;
    to?: string;
    toD?: string;
    transacted?: TransactedDefinition;
    transform?: TransformDefinition;
    doTry?: TryDefinition;
    unmarshal?: UnmarshalDefinition;
    validate?: ValidateDefinition;
    when?: WhenDefinition;
    whenSkipSendToEndpoint?: WhenSkipSendToEndpointDefinition;
    wireTap?: WireTapDefinition;
    serviceCall?: ServiceCallDefinition | string;
    public constructor(init?: Partial<ProcessorDefinition>) {
        super('ProcessorDefinition');
        Object.assign(this, init);
    }
}

export class BeansDeserializer extends CamelElement {

    public constructor(init?: Partial<BeansDeserializer>) {
        super('BeansDeserializer');
        Object.assign(this, init);
    }
}

export class ErrorHandlerBuilderDeserializer extends CamelElement {
    deadLetterChannel?: DeadLetterChannelDefinition;
    defaultErrorHandler?: DefaultErrorHandlerDefinition;
    jtaTransactionErrorHandler?: JtaTransactionErrorHandlerDefinition;
    noErrorHandler?: NoErrorHandlerDefinition;
    refErrorHandler?: RefErrorHandlerDefinition | string;
    springTransactionErrorHandler?: SpringTransactionErrorHandlerDefinition;
    public constructor(init?: Partial<ErrorHandlerBuilderDeserializer>) {
        super('ErrorHandlerBuilderDeserializer');
        Object.assign(this, init);
    }
}

export class NamedBeanDefinition extends CamelElement {
    name: string = '';
    properties?: any = {};
    type: string = '';
    public constructor(init?: Partial<NamedBeanDefinition>) {
        super('NamedBeanDefinition');
        Object.assign(this, init);
    }
}

export class OutputAwareFromDefinition extends CamelElement {
    description?: string;
    id?: string;
    parameters?: any = {};
    steps: CamelElement[] = [];
    uri: string = '';
    public constructor(init?: Partial<OutputAwareFromDefinition>) {
        super('OutputAwareFromDefinition');
        Object.assign(this, init);
    }
}

export class AggregateDefinition extends CamelElement {
    stepName?: string = 'aggregate';
    correlationExpression?: ExpressionSubElementDefinition;
    completionPredicate?: ExpressionSubElementDefinition;
    completionTimeoutExpression?: ExpressionSubElementDefinition;
    completionSizeExpression?: ExpressionSubElementDefinition;
    optimisticLockRetryPolicy?: OptimisticLockRetryPolicyDefinition;
    parallelProcessing?: boolean;
    optimisticLocking?: boolean;
    executorService?: string;
    timeoutCheckerExecutorService?: string;
    aggregateController?: string;
    aggregationRepository?: string;
    aggregationStrategy: string = '';
    aggregationStrategyMethodName?: string;
    aggregationStrategyMethodAllowNull?: boolean;
    completionSize?: number;
    completionInterval?: string;
    completionTimeout?: string;
    completionTimeoutCheckerInterval?: string;
    completionFromBatchConsumer?: boolean;
    completionOnNewCorrelationGroup?: boolean;
    eagerCheckCompletion?: boolean;
    ignoreInvalidCorrelationKeys?: boolean;
    closeCorrelationKeyOnCompletion?: number;
    discardOnCompletionTimeout?: boolean;
    discardOnAggregationFailure?: boolean;
    forceCompletionOnStop?: boolean;
    completeAllOnStop?: boolean;
    disabled?: boolean;
    id?: string = 'aggregate-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<AggregateDefinition>) {
        super('AggregateDefinition');
        Object.assign(this, init);
    }
}

export class BeanDefinition extends CamelElement {
    stepName?: string = 'bean';
    ref?: string;
    method?: string;
    beanType?: string;
    scope?: string;
    disabled?: boolean;
    id?: string = 'bean-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<BeanDefinition>) {
        super('BeanDefinition');
        Object.assign(this, init);
    }
}

export class CatchDefinition extends CamelElement {
    stepName?: string = 'doCatch';
    exception?: string[] = [];
    onWhen?: WhenDefinition;
    disabled?: boolean;
    id?: string = 'doCatch-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<CatchDefinition>) {
        super('CatchDefinition');
        Object.assign(this, init);
    }
}

export class ChoiceDefinition extends CamelElement {
    stepName?: string = 'choice';
    when?: WhenDefinition[] = [];
    otherwise?: OtherwiseDefinition;
    precondition?: boolean;
    disabled?: boolean;
    id?: string = 'choice-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<ChoiceDefinition>) {
        super('ChoiceDefinition');
        Object.assign(this, init);
    }
}

export class CircuitBreakerDefinition extends CamelElement {
    stepName?: string = 'circuitBreaker';
    resilience4jConfiguration?: Resilience4jConfigurationDefinition;
    faultToleranceConfiguration?: FaultToleranceConfigurationDefinition;
    configuration?: string;
    disabled?: boolean;
    id?: string = 'circuitBreaker-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    onFallback?: OnFallbackDefinition;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<CircuitBreakerDefinition>) {
        super('CircuitBreakerDefinition');
        Object.assign(this, init);
    }
}

export class ClaimCheckDefinition extends CamelElement {
    stepName?: string = 'claimCheck';
    operation: string = '';
    key?: string;
    filter?: string;
    aggregationStrategy?: string;
    aggregationStrategyMethodName?: string;
    disabled?: boolean;
    id?: string = 'claimCheck-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<ClaimCheckDefinition>) {
        super('ClaimCheckDefinition');
        Object.assign(this, init);
    }
}

export class ContextScanDefinition extends CamelElement {
    stepName?: string = 'contextScan';
    includeNonSingletons?: boolean;
    excludes?: string[] = [];
    includes?: string[] = [];
    public constructor(init?: Partial<ContextScanDefinition>) {
        super('ContextScanDefinition');
        Object.assign(this, init);
    }
}

export class ConvertBodyDefinition extends CamelElement {
    stepName?: string = 'convertBodyTo';
    type: string = '';
    mandatory?: boolean;
    charset?: string;
    disabled?: boolean;
    id?: string = 'convertBodyTo-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<ConvertBodyDefinition>) {
        super('ConvertBodyDefinition');
        Object.assign(this, init);
    }
}

export class DataFormatDefinition extends CamelElement {
    stepName?: string = 'dataFormat';
    id?: string = 'dataFormat-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<DataFormatDefinition>) {
        super('DataFormatDefinition');
        Object.assign(this, init);
    }
}

export class DelayDefinition extends CamelElement {
    stepName?: string = 'delay';
    expression?: ExpressionDefinition;
    asyncDelayed?: boolean;
    callerRunsWhenRejected?: boolean;
    executorService?: string;
    disabled?: boolean;
    id?: string = 'delay-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<DelayDefinition>) {
        super('DelayDefinition');
        Object.assign(this, init);
    }
}

export class DescriptionDefinition extends CamelElement {
    stepName?: string = 'description';
    lang?: string;
    text?: string;
    public constructor(init?: Partial<DescriptionDefinition>) {
        super('DescriptionDefinition');
        Object.assign(this, init);
    }
}

export class DynamicRouterDefinition extends CamelElement {
    stepName?: string = 'dynamicRouter';
    expression?: ExpressionDefinition;
    uriDelimiter?: string;
    ignoreInvalidEndpoints?: boolean;
    cacheSize?: number;
    disabled?: boolean;
    id?: string = 'dynamicRouter-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<DynamicRouterDefinition>) {
        super('DynamicRouterDefinition');
        Object.assign(this, init);
    }
}

export class EnrichDefinition extends CamelElement {
    stepName?: string = 'enrich';
    expression?: ExpressionDefinition;
    aggregationStrategy?: string;
    aggregationStrategyMethodName?: string;
    aggregationStrategyMethodAllowNull?: string;
    aggregateOnException?: boolean;
    shareUnitOfWork?: boolean;
    cacheSize?: number;
    ignoreInvalidEndpoint?: boolean;
    allowOptimisedComponents?: boolean;
    disabled?: boolean;
    id?: string = 'enrich-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<EnrichDefinition>) {
        super('EnrichDefinition');
        Object.assign(this, init);
    }
}

export class ErrorHandlerDefinition extends CamelElement {
    stepName?: string = 'errorHandler';
    id?: string = 'errorHandler-' + uuidv4().substring(0,4);
    deadLetterChannel?: DeadLetterChannelDefinition;
    defaultErrorHandler?: DefaultErrorHandlerDefinition;
    jtaTransactionErrorHandler?: JtaTransactionErrorHandlerDefinition;
    noErrorHandler?: NoErrorHandlerDefinition;
    springTransactionErrorHandler?: SpringTransactionErrorHandlerDefinition;
    public constructor(init?: Partial<ErrorHandlerDefinition>) {
        super('ErrorHandlerDefinition');
        Object.assign(this, init);
    }
}

export class ExpressionSubElementDefinition extends CamelElement {
    stepName?: string = 'expressionSubElement';
    constant?: ConstantExpression | string;
    csimple?: CSimpleExpression | string;
    datasonnet?: DatasonnetExpression | string;
    exchangeProperty?: ExchangePropertyExpression | string;
    groovy?: GroovyExpression | string;
    header?: HeaderExpression | string;
    hl7terser?: Hl7TerserExpression | string;
    joor?: JoorExpression | string;
    jq?: JqExpression | string;
    js?: JavaScriptExpression | string;
    jsonpath?: JsonPathExpression | string;
    language?: LanguageExpression;
    method?: MethodCallExpression | string;
    mvel?: MvelExpression | string;
    ognl?: OgnlExpression | string;
    python?: PythonExpression | string;
    ref?: RefExpression | string;
    simple?: SimpleExpression | string;
    spel?: SpELExpression | string;
    tokenize?: TokenizerExpression | string;
    xpath?: XPathExpression | string;
    xquery?: XQueryExpression | string;
    xtokenize?: XMLTokenizerExpression | string;
    public constructor(init?: Partial<ExpressionSubElementDefinition>) {
        super('ExpressionSubElementDefinition');
        Object.assign(this, init);
    }
}

export class FaultToleranceConfigurationDefinition extends CamelElement {
    stepName?: string = 'faultToleranceConfiguration';
    circuitBreaker?: string;
    delay?: string;
    successThreshold?: number;
    requestVolumeThreshold?: number;
    failureRatio?: number;
    timeoutEnabled?: boolean;
    timeoutDuration?: string;
    timeoutPoolSize?: number;
    timeoutScheduledExecutorService?: string;
    bulkheadEnabled?: boolean;
    bulkheadMaxConcurrentCalls?: number;
    bulkheadWaitingTaskQueue?: number;
    bulkheadExecutorService?: string;
    id?: string = 'faultToleranceConfiguration-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<FaultToleranceConfigurationDefinition>) {
        super('FaultToleranceConfigurationDefinition');
        Object.assign(this, init);
    }
}

export class FilterDefinition extends CamelElement {
    stepName?: string = 'filter';
    expression?: ExpressionDefinition;
    statusPropertyName?: string;
    disabled?: boolean;
    id?: string = 'filter-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<FilterDefinition>) {
        super('FilterDefinition');
        Object.assign(this, init);
    }
}

export class FinallyDefinition extends CamelElement {
    stepName?: string = 'doFinally';
    disabled?: boolean;
    id?: string = 'doFinally-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<FinallyDefinition>) {
        super('FinallyDefinition');
        Object.assign(this, init);
    }
}

export class FromDefinition extends CamelElement {
    stepName?: string = 'from';
    uri: string = '';
    id?: string = 'from-' + uuidv4().substring(0,4);
    description?: string;
    parameters?: any = {};
    steps: CamelElement[] = [];
    public constructor(init?: Partial<FromDefinition>) {
        super('FromDefinition');
        Object.assign(this, init);
    }
}

export class GlobalOptionDefinition extends CamelElement {
    stepName?: string = 'globalOption';
    key: string = '';
    value: string = '';
    public constructor(init?: Partial<GlobalOptionDefinition>) {
        super('GlobalOptionDefinition');
        Object.assign(this, init);
    }
}

export class GlobalOptionsDefinition extends CamelElement {
    stepName?: string = 'globalOptions';
    globalOption?: GlobalOptionDefinition[] = [];
    public constructor(init?: Partial<GlobalOptionsDefinition>) {
        super('GlobalOptionsDefinition');
        Object.assign(this, init);
    }
}

export class IdempotentConsumerDefinition extends CamelElement {
    stepName?: string = 'idempotentConsumer';
    expression?: ExpressionDefinition;
    idempotentRepository: string = '';
    eager?: boolean;
    completionEager?: boolean;
    skipDuplicate?: boolean;
    removeOnFailure?: boolean;
    disabled?: boolean;
    id?: string = 'idempotentConsumer-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<IdempotentConsumerDefinition>) {
        super('IdempotentConsumerDefinition');
        Object.assign(this, init);
    }
}

export class InOnlyDefinition extends CamelElement {
    stepName?: string = 'inOnly';
    uri: string = '';
    disabled?: boolean;
    id?: string = 'inOnly-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    parameters?: any = {};
    public constructor(init?: Partial<InOnlyDefinition>) {
        super('InOnlyDefinition');
        Object.assign(this, init);
    }
}

export class InOutDefinition extends CamelElement {
    stepName?: string = 'inOut';
    uri: string = '';
    disabled?: boolean;
    id?: string = 'inOut-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    parameters?: any = {};
    public constructor(init?: Partial<InOutDefinition>) {
        super('InOutDefinition');
        Object.assign(this, init);
    }
}

export class InputTypeDefinition extends CamelElement {
    stepName?: string = 'inputType';
    urn: string = '';
    validate?: boolean;
    id?: string = 'inputType-' + uuidv4().substring(0,4);
    description?: string;
    public constructor(init?: Partial<InputTypeDefinition>) {
        super('InputTypeDefinition');
        Object.assign(this, init);
    }
}

export class InterceptDefinition extends CamelElement {
    stepName?: string = 'intercept';
    disabled?: boolean;
    id?: string = 'intercept-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<InterceptDefinition>) {
        super('InterceptDefinition');
        Object.assign(this, init);
    }
}

export class InterceptFromDefinition extends CamelElement {
    stepName?: string = 'interceptFrom';
    uri?: string;
    disabled?: boolean;
    id?: string = 'interceptFrom-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<InterceptFromDefinition>) {
        super('InterceptFromDefinition');
        Object.assign(this, init);
    }
}

export class InterceptSendToEndpointDefinition extends CamelElement {
    stepName?: string = 'interceptSendToEndpoint';
    uri: string = '';
    skipSendToOriginalEndpoint?: string;
    afterUri?: string;
    disabled?: boolean;
    id?: string = 'interceptSendToEndpoint-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<InterceptSendToEndpointDefinition>) {
        super('InterceptSendToEndpointDefinition');
        Object.assign(this, init);
    }
}

export class KameletDefinition extends CamelElement {
    stepName?: string = 'kamelet';
    name: string = '';
    inheritErrorHandler?: boolean;
    parameters?: any = {};
    public constructor(init?: Partial<KameletDefinition>) {
        super('KameletDefinition');
        Object.assign(this, init);
    }
}

export class LoadBalanceDefinition extends CamelElement {
    stepName?: string = 'loadBalance';
    disabled?: boolean;
    inheritErrorHandler?: boolean;
    id?: string = 'loadBalance-' + uuidv4().substring(0,4);
    description?: string;
    customLoadBalancer?: CustomLoadBalancerDefinition | string;
    failover?: FailoverLoadBalancerDefinition;
    random?: RandomLoadBalancerDefinition;
    roundRobin?: RoundRobinLoadBalancerDefinition;
    steps?: CamelElement[] = [];
    sticky?: StickyLoadBalancerDefinition;
    topic?: TopicLoadBalancerDefinition;
    weighted?: WeightedLoadBalancerDefinition;
    public constructor(init?: Partial<LoadBalanceDefinition>) {
        super('LoadBalanceDefinition');
        Object.assign(this, init);
    }
}

export class LogDefinition extends CamelElement {
    stepName?: string = 'log';
    message: string = '';
    loggingLevel?: string;
    logName?: string;
    marker?: string;
    logger?: string;
    disabled?: boolean;
    id?: string = 'log-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<LogDefinition>) {
        super('LogDefinition');
        Object.assign(this, init);
    }
}

export class LoopDefinition extends CamelElement {
    stepName?: string = 'loop';
    expression?: ExpressionDefinition;
    copy?: boolean;
    doWhile?: boolean;
    breakOnShutdown?: boolean;
    disabled?: boolean;
    id?: string = 'loop-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<LoopDefinition>) {
        super('LoopDefinition');
        Object.assign(this, init);
    }
}

export class MarshalDefinition extends CamelElement {
    stepName?: string = 'marshal';
    disabled?: boolean;
    id?: string = 'marshal-' + uuidv4().substring(0,4);
    description?: string;
    any23?: Any23DataFormat | string;
    asn1?: ASN1DataFormat | string;
    avro?: AvroDataFormat | string;
    barcode?: BarcodeDataFormat;
    base64?: Base64DataFormat;
    bindy?: BindyDataFormat;
    cbor?: CBORDataFormat;
    crypto?: CryptoDataFormat;
    csv?: CsvDataFormat | string;
    custom?: CustomDataFormat | string;
    fhirJson?: FhirJsonDataFormat;
    fhirXml?: FhirXmlDataFormat;
    flatpack?: FlatpackDataFormat;
    grok?: GrokDataFormat;
    gzipDeflater?: GzipDeflaterDataFormat;
    hl7?: HL7DataFormat;
    ical?: IcalDataFormat;
    inheritErrorHandler?: boolean;
    jacksonXml?: JacksonXMLDataFormat;
    jaxb?: JaxbDataFormat;
    json?: JsonDataFormat;
    jsonApi?: JsonApiDataFormat;
    lzf?: LZFDataFormat;
    mimeMultipart?: MimeMultipartDataFormat;
    pgp?: PGPDataFormat;
    protobuf?: ProtobufDataFormat | string;
    rss?: RssDataFormat;
    soap?: SoapDataFormat | string;
    swiftMt?: SwiftMtDataFormat | string;
    swiftMx?: SwiftMxDataFormat;
    syslog?: SyslogDataFormat;
    tarFile?: TarFileDataFormat;
    thrift?: ThriftDataFormat | string;
    tidyMarkup?: TidyMarkupDataFormat;
    univocityCsv?: UniVocityCsvDataFormat;
    univocityFixed?: UniVocityFixedDataFormat;
    univocityTsv?: UniVocityTsvDataFormat;
    xmlSecurity?: XMLSecurityDataFormat;
    xstream?: XStreamDataFormat | string;
    yaml?: YAMLDataFormat;
    zipDeflater?: ZipDeflaterDataFormat;
    zipFile?: ZipFileDataFormat;
    public constructor(init?: Partial<MarshalDefinition>) {
        super('MarshalDefinition');
        Object.assign(this, init);
    }
}

export class MulticastDefinition extends CamelElement {
    stepName?: string = 'multicast';
    aggregationStrategy?: string;
    aggregationStrategyMethodName?: string;
    aggregationStrategyMethodAllowNull?: boolean;
    parallelAggregate?: boolean;
    parallelProcessing?: boolean;
    synchronous?: boolean;
    streaming?: boolean;
    stopOnException?: boolean;
    timeout?: string;
    executorService?: string;
    onPrepare?: string;
    shareUnitOfWork?: boolean;
    disabled?: boolean;
    id?: string = 'multicast-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<MulticastDefinition>) {
        super('MulticastDefinition');
        Object.assign(this, init);
    }
}

export class OnCompletionDefinition extends CamelElement {
    stepName?: string = 'onCompletion';
    mode?: string;
    onCompleteOnly?: boolean;
    onFailureOnly?: boolean;
    parallelProcessing?: boolean;
    executorService?: string;
    useOriginalMessage?: boolean;
    onWhen?: WhenDefinition;
    disabled?: boolean;
    id?: string = 'onCompletion-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<OnCompletionDefinition>) {
        super('OnCompletionDefinition');
        Object.assign(this, init);
    }
}

export class OnExceptionDefinition extends CamelElement {
    stepName?: string = 'onException';
    exception?: string[] = [];
    onWhen?: WhenDefinition;
    retryWhile?: ExpressionSubElementDefinition;
    redeliveryPolicy?: RedeliveryPolicyDefinition;
    redeliveryPolicyRef?: string;
    handled?: ExpressionSubElementDefinition;
    continued?: ExpressionSubElementDefinition;
    onRedeliveryRef?: string;
    onExceptionOccurredRef?: string;
    useOriginalMessage?: boolean;
    useOriginalBody?: boolean;
    disabled?: boolean;
    id?: string = 'onException-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<OnExceptionDefinition>) {
        super('OnExceptionDefinition');
        Object.assign(this, init);
    }
}

export class OnFallbackDefinition extends CamelElement {
    stepName?: string = 'onFallback';
    fallbackViaNetwork?: boolean;
    disabled?: boolean;
    id?: string = 'onFallback-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<OnFallbackDefinition>) {
        super('OnFallbackDefinition');
        Object.assign(this, init);
    }
}

export class OptimisticLockRetryPolicyDefinition extends CamelElement {
    stepName?: string = 'optimisticLockRetryPolicy';
    maximumRetries?: number;
    retryDelay?: string;
    maximumRetryDelay?: string;
    exponentialBackOff?: boolean;
    randomBackOff?: boolean;
    public constructor(init?: Partial<OptimisticLockRetryPolicyDefinition>) {
        super('OptimisticLockRetryPolicyDefinition');
        Object.assign(this, init);
    }
}

export class OtherwiseDefinition extends CamelElement {
    stepName?: string = 'otherwise';
    disabled?: boolean;
    id?: string = 'otherwise-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<OtherwiseDefinition>) {
        super('OtherwiseDefinition');
        Object.assign(this, init);
    }
}

export class OutputDefinition extends CamelElement {
    stepName?: string = 'output';
    description?: string;
    disabled?: boolean;
    id?: string = 'output-' + uuidv4().substring(0,4);
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<OutputDefinition>) {
        super('OutputDefinition');
        Object.assign(this, init);
    }
}

export class OutputTypeDefinition extends CamelElement {
    stepName?: string = 'outputType';
    urn: string = '';
    validate?: boolean;
    id?: string = 'outputType-' + uuidv4().substring(0,4);
    description?: string;
    public constructor(init?: Partial<OutputTypeDefinition>) {
        super('OutputTypeDefinition');
        Object.assign(this, init);
    }
}

export class PackageScanDefinition extends CamelElement {
    stepName?: string = 'packageScan';
    package?: string[] = [];
    excludes?: string[] = [];
    includes?: string[] = [];
    public constructor(init?: Partial<PackageScanDefinition>) {
        super('PackageScanDefinition');
        Object.assign(this, init);
    }
}

export class PausableDefinition extends CamelElement {
    stepName?: string = 'pausable';
    consumerListener: string = '';
    untilCheck: string = '';
    disabled?: boolean;
    id?: string = 'pausable-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<PausableDefinition>) {
        super('PausableDefinition');
        Object.assign(this, init);
    }
}

export class PipelineDefinition extends CamelElement {
    stepName?: string = 'pipeline';
    disabled?: boolean;
    id?: string = 'pipeline-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<PipelineDefinition>) {
        super('PipelineDefinition');
        Object.assign(this, init);
    }
}

export class PolicyDefinition extends CamelElement {
    stepName?: string = 'policy';
    ref: string = '';
    disabled?: boolean;
    id?: string = 'policy-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<PolicyDefinition>) {
        super('PolicyDefinition');
        Object.assign(this, init);
    }
}

export class PollEnrichDefinition extends CamelElement {
    stepName?: string = 'pollEnrich';
    expression?: ExpressionDefinition;
    aggregationStrategy?: string;
    aggregationStrategyMethodName?: string;
    aggregationStrategyMethodAllowNull?: string;
    aggregateOnException?: boolean;
    timeout?: string;
    cacheSize?: number;
    ignoreInvalidEndpoint?: boolean;
    disabled?: boolean;
    id?: string = 'pollEnrich-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<PollEnrichDefinition>) {
        super('PollEnrichDefinition');
        Object.assign(this, init);
    }
}

export class ProcessDefinition extends CamelElement {
    stepName?: string = 'process';
    ref: string = '';
    disabled?: boolean;
    id?: string = 'process-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<ProcessDefinition>) {
        super('ProcessDefinition');
        Object.assign(this, init);
    }
}

export class PropertyDefinition extends CamelElement {
    stepName?: string = 'property';
    key: string = '';
    value: string = '';
    public constructor(init?: Partial<PropertyDefinition>) {
        super('PropertyDefinition');
        Object.assign(this, init);
    }
}

export class PropertyExpressionDefinition extends CamelElement {
    stepName?: string = 'propertyExpression';
    key: string = '';
    expression?: ExpressionDefinition;
    public constructor(init?: Partial<PropertyExpressionDefinition>) {
        super('PropertyExpressionDefinition');
        Object.assign(this, init);
    }
}

export class RecipientListDefinition extends CamelElement {
    stepName?: string = 'recipientList';
    expression?: ExpressionDefinition;
    delimiter?: string;
    aggregationStrategy?: string;
    aggregationStrategyMethodName?: string;
    aggregationStrategyMethodAllowNull?: boolean;
    parallelAggregate?: boolean;
    parallelProcessing?: boolean;
    synchronous?: boolean;
    timeout?: string;
    executorService?: string;
    stopOnException?: boolean;
    ignoreInvalidEndpoints?: boolean;
    streaming?: boolean;
    onPrepare?: string;
    cacheSize?: number;
    shareUnitOfWork?: boolean;
    disabled?: boolean;
    id?: string = 'recipientList-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<RecipientListDefinition>) {
        super('RecipientListDefinition');
        Object.assign(this, init);
    }
}

export class RedeliveryPolicyDefinition extends CamelElement {
    stepName?: string = 'redeliveryPolicy';
    maximumRedeliveries?: number;
    redeliveryDelay?: string;
    asyncDelayedRedelivery?: boolean;
    backOffMultiplier?: number;
    useExponentialBackOff?: boolean;
    collisionAvoidanceFactor?: number;
    useCollisionAvoidance?: boolean;
    maximumRedeliveryDelay?: string;
    retriesExhaustedLogLevel?: string;
    retryAttemptedLogLevel?: string;
    retryAttemptedLogInterval?: number;
    logRetryAttempted?: boolean;
    logStackTrace?: boolean;
    logRetryStackTrace?: boolean;
    logHandled?: boolean;
    logNewException?: boolean;
    logContinued?: boolean;
    logExhausted?: boolean;
    logExhaustedMessageHistory?: boolean;
    logExhaustedMessageBody?: boolean;
    disableRedelivery?: boolean;
    delayPattern?: string;
    allowRedeliveryWhileStopping?: boolean;
    exchangeFormatterRef?: string;
    id?: string = 'redeliveryPolicy-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<RedeliveryPolicyDefinition>) {
        super('RedeliveryPolicyDefinition');
        Object.assign(this, init);
    }
}

export class RemoveHeaderDefinition extends CamelElement {
    stepName?: string = 'removeHeader';
    name: string = '';
    disabled?: boolean;
    id?: string = 'removeHeader-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<RemoveHeaderDefinition>) {
        super('RemoveHeaderDefinition');
        Object.assign(this, init);
    }
}

export class RemoveHeadersDefinition extends CamelElement {
    stepName?: string = 'removeHeaders';
    pattern: string = '';
    excludePattern?: string;
    disabled?: boolean;
    id?: string = 'removeHeaders-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<RemoveHeadersDefinition>) {
        super('RemoveHeadersDefinition');
        Object.assign(this, init);
    }
}

export class RemovePropertiesDefinition extends CamelElement {
    stepName?: string = 'removeProperties';
    pattern: string = '';
    excludePattern?: string;
    disabled?: boolean;
    id?: string = 'removeProperties-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<RemovePropertiesDefinition>) {
        super('RemovePropertiesDefinition');
        Object.assign(this, init);
    }
}

export class RemovePropertyDefinition extends CamelElement {
    stepName?: string = 'removeProperty';
    name: string = '';
    disabled?: boolean;
    id?: string = 'removeProperty-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<RemovePropertyDefinition>) {
        super('RemovePropertyDefinition');
        Object.assign(this, init);
    }
}

export class ResequenceDefinition extends CamelElement {
    stepName?: string = 'resequence';
    expression: ExpressionDefinition = new ExpressionDefinition();
    disabled?: boolean;
    id?: string = 'resequence-' + uuidv4().substring(0,4);
    description?: string;
    batchConfig?: BatchResequencerConfig;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    streamConfig?: StreamResequencerConfig;
    public constructor(init?: Partial<ResequenceDefinition>) {
        super('ResequenceDefinition');
        Object.assign(this, init);
    }
}

export class Resilience4jConfigurationDefinition extends CamelElement {
    stepName?: string = 'resilience4jConfiguration';
    circuitBreaker?: string;
    config?: string;
    failureRateThreshold?: number;
    permittedNumberOfCallsInHalfOpenState?: number;
    throwExceptionWhenHalfOpenOrOpenState?: boolean;
    slidingWindowSize?: number;
    slidingWindowType?: string;
    minimumNumberOfCalls?: number;
    writableStackTraceEnabled?: boolean;
    waitDurationInOpenState?: number;
    automaticTransitionFromOpenToHalfOpenEnabled?: boolean;
    slowCallRateThreshold?: number;
    slowCallDurationThreshold?: number;
    id?: string = 'resilience4jConfiguration-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<Resilience4jConfigurationDefinition>) {
        super('Resilience4jConfigurationDefinition');
        Object.assign(this, init);
    }
}

export class RestContextRefDefinition extends CamelElement {
    stepName?: string = 'restContextRef';
    ref: string = '';
    public constructor(init?: Partial<RestContextRefDefinition>) {
        super('RestContextRefDefinition');
        Object.assign(this, init);
    }
}

export class ResumableDefinition extends CamelElement {
    stepName?: string = 'resumable';
    resumeStrategy: string = '';
    intermittent?: boolean;
    disabled?: boolean;
    id?: string = 'resumable-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<ResumableDefinition>) {
        super('ResumableDefinition');
        Object.assign(this, init);
    }
}

export class RollbackDefinition extends CamelElement {
    stepName?: string = 'rollback';
    message?: string;
    markRollbackOnly?: boolean;
    markRollbackOnlyLast?: boolean;
    disabled?: boolean;
    id?: string = 'rollback-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<RollbackDefinition>) {
        super('RollbackDefinition');
        Object.assign(this, init);
    }
}

export class RouteBuilderDefinition extends CamelElement {
    stepName?: string = 'routeBuilder';
    ref: string = '';
    id?: string = 'routeBuilder-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<RouteBuilderDefinition>) {
        super('RouteBuilderDefinition');
        Object.assign(this, init);
    }
}

export class RouteConfigurationContextRefDefinition extends CamelElement {
    stepName?: string = 'routeConfigurationContextRef';
    ref: string = '';
    public constructor(init?: Partial<RouteConfigurationContextRefDefinition>) {
        super('RouteConfigurationContextRefDefinition');
        Object.assign(this, init);
    }
}

export class RouteConfigurationDefinition extends CamelElement {
    stepName?: string = 'routeConfiguration';
    errorHandler?: ErrorHandlerDefinition;
    intercept?: InterceptDefinition[] = [];
    interceptFrom?: InterceptFromDefinition[] = [];
    interceptSendToEndpoint?: InterceptSendToEndpointDefinition[] = [];
    onException?: OnExceptionDefinition[] = [];
    onCompletion?: OnCompletionDefinition[] = [];
    precondition?: string;
    id?: string;
    public constructor(init?: Partial<RouteConfigurationDefinition>) {
        super('RouteConfigurationDefinition');
        Object.assign(this, init);
    }
}

export class RouteContextRefDefinition extends CamelElement {
    stepName?: string = 'routeContextRef';
    ref: string = '';
    public constructor(init?: Partial<RouteContextRefDefinition>) {
        super('RouteContextRefDefinition');
        Object.assign(this, init);
    }
}

export class RouteDefinition extends CamelElement {
    stepName?: string = 'route';
    group?: string;
    nodePrefixId?: string;
    routeConfigurationId?: string;
    precondition?: string;
    trace?: boolean;
    messageHistory?: boolean;
    logMask?: boolean;
    autoStartup?: boolean;
    startupOrder?: number;
    id?: string = 'route-' + uuidv4().substring(0,4);
    description?: string;
    from: FromDefinition = new FromDefinition();
    routePolicy?: string;
    streamCaching?: boolean;
    public constructor(init?: Partial<RouteDefinition>) {
        super('RouteDefinition');
        Object.assign(this, init);
    }
}

export class RouteTemplateBeanDefinition extends CamelElement {
    stepName?: string = 'routeTemplateBean';
    beanType?: string;
    name: string = '';
    properties?: any = {};
    property?: PropertyDefinition[] = [];
    script?: string;
    type: string = '';
    public constructor(init?: Partial<RouteTemplateBeanDefinition>) {
        super('RouteTemplateBeanDefinition');
        Object.assign(this, init);
    }
}

export class RouteTemplateDefinition extends CamelElement {
    stepName?: string = 'routeTemplate';
    route?: RouteDefinition;
    id: string = 'routeTemplate-' + uuidv4().substring(0,4);
    beans?: RouteTemplateBeanDefinition[] = [];
    from?: FromDefinition;
    parameters?: RouteTemplateParameterDefinition[] = [];
    public constructor(init?: Partial<RouteTemplateDefinition>) {
        super('RouteTemplateDefinition');
        Object.assign(this, init);
    }
}

export class RouteTemplateParameterDefinition extends CamelElement {
    stepName?: string = 'routeTemplateParameter';
    defaultValue?: string;
    description?: string;
    name: string = '';
    required?: boolean;
    public constructor(init?: Partial<RouteTemplateParameterDefinition>) {
        super('RouteTemplateParameterDefinition');
        Object.assign(this, init);
    }
}

export class RoutingSlipDefinition extends CamelElement {
    stepName?: string = 'routingSlip';
    expression?: ExpressionDefinition;
    uriDelimiter?: string;
    ignoreInvalidEndpoints?: boolean;
    cacheSize?: number;
    disabled?: boolean;
    id?: string = 'routingSlip-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<RoutingSlipDefinition>) {
        super('RoutingSlipDefinition');
        Object.assign(this, init);
    }
}

export class SagaActionUriDefinition extends CamelElement {
    stepName?: string = 'sagaActionUri';
    description?: string;
    disabled?: boolean;
    id?: string = 'sagaActionUri-' + uuidv4().substring(0,4);
    inheritErrorHandler?: boolean;
    parameters?: any = {};
    uri: string = '';
    public constructor(init?: Partial<SagaActionUriDefinition>) {
        super('SagaActionUriDefinition');
        Object.assign(this, init);
    }
}

export class SagaDefinition extends CamelElement {
    stepName?: string = 'saga';
    sagaService?: string;
    propagation?: string;
    completionMode?: string;
    timeout?: string;
    compensation?: string;
    completion?: string;
    option?: PropertyExpressionDefinition[] = [];
    disabled?: boolean;
    id?: string = 'saga-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<SagaDefinition>) {
        super('SagaDefinition');
        Object.assign(this, init);
    }
}

export class SamplingDefinition extends CamelElement {
    stepName?: string = 'sample';
    samplePeriod?: string;
    messageFrequency?: number;
    disabled?: boolean;
    id?: string = 'sample-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<SamplingDefinition>) {
        super('SamplingDefinition');
        Object.assign(this, init);
    }
}

export class ScriptDefinition extends CamelElement {
    stepName?: string = 'script';
    expression?: ExpressionDefinition;
    disabled?: boolean;
    id?: string = 'script-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<ScriptDefinition>) {
        super('ScriptDefinition');
        Object.assign(this, init);
    }
}

export class SetBodyDefinition extends CamelElement {
    stepName?: string = 'setBody';
    expression?: ExpressionDefinition;
    disabled?: boolean;
    id?: string = 'setBody-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<SetBodyDefinition>) {
        super('SetBodyDefinition');
        Object.assign(this, init);
    }
}

export class SetExchangePatternDefinition extends CamelElement {
    stepName?: string = 'setExchangePattern';
    pattern: string = '';
    disabled?: boolean;
    id?: string = 'setExchangePattern-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<SetExchangePatternDefinition>) {
        super('SetExchangePatternDefinition');
        Object.assign(this, init);
    }
}

export class SetHeaderDefinition extends CamelElement {
    stepName?: string = 'setHeader';
    name: string = '';
    expression?: ExpressionDefinition;
    disabled?: boolean;
    id?: string = 'setHeader-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<SetHeaderDefinition>) {
        super('SetHeaderDefinition');
        Object.assign(this, init);
    }
}

export class SetPropertyDefinition extends CamelElement {
    stepName?: string = 'setProperty';
    name: string = '';
    expression?: ExpressionDefinition;
    disabled?: boolean;
    id?: string = 'setProperty-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<SetPropertyDefinition>) {
        super('SetPropertyDefinition');
        Object.assign(this, init);
    }
}

export class SortDefinition extends CamelElement {
    stepName?: string = 'sort';
    expression?: ExpressionDefinition;
    comparator?: string;
    disabled?: boolean;
    id?: string = 'sort-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<SortDefinition>) {
        super('SortDefinition');
        Object.assign(this, init);
    }
}

export class SplitDefinition extends CamelElement {
    stepName?: string = 'split';
    expression?: ExpressionDefinition;
    delimiter?: string;
    aggregationStrategy?: string;
    aggregationStrategyMethodName?: string;
    aggregationStrategyMethodAllowNull?: boolean;
    parallelAggregate?: boolean;
    parallelProcessing?: boolean;
    synchronous?: boolean;
    streaming?: boolean;
    stopOnException?: boolean;
    timeout?: string;
    executorService?: string;
    onPrepare?: string;
    shareUnitOfWork?: boolean;
    disabled?: boolean;
    id?: string = 'split-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<SplitDefinition>) {
        super('SplitDefinition');
        Object.assign(this, init);
    }
}

export class StepDefinition extends CamelElement {
    stepName?: string = 'step';
    disabled?: boolean;
    id?: string = 'step-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<StepDefinition>) {
        super('StepDefinition');
        Object.assign(this, init);
    }
}

export class StopDefinition extends CamelElement {
    stepName?: string = 'stop';
    disabled?: boolean;
    id?: string = 'stop-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<StopDefinition>) {
        super('StopDefinition');
        Object.assign(this, init);
    }
}

export class TemplatedRouteBeanDefinition extends CamelElement {
    stepName?: string = 'templatedRouteBean';
    name: string = '';
    type: string = '';
    beanType?: string;
    property?: PropertyDefinition[] = [];
    script?: string;
    properties?: any = {};
    public constructor(init?: Partial<TemplatedRouteBeanDefinition>) {
        super('TemplatedRouteBeanDefinition');
        Object.assign(this, init);
    }
}

export class TemplatedRouteDefinition extends CamelElement {
    stepName?: string = 'templatedRoute';
    routeTemplateRef: string = '';
    routeId?: string;
    prefixId?: string;
    beans?: TemplatedRouteBeanDefinition[] = [];
    parameters?: TemplatedRouteParameterDefinition[] = [];
    public constructor(init?: Partial<TemplatedRouteDefinition>) {
        super('TemplatedRouteDefinition');
        Object.assign(this, init);
    }
}

export class TemplatedRouteParameterDefinition extends CamelElement {
    stepName?: string = 'templatedRouteParameter';
    name: string = '';
    value: string = '';
    public constructor(init?: Partial<TemplatedRouteParameterDefinition>) {
        super('TemplatedRouteParameterDefinition');
        Object.assign(this, init);
    }
}

export class ThreadPoolProfileDefinition extends CamelElement {
    stepName?: string = 'threadPoolProfile';
    defaultProfile?: boolean;
    poolSize?: number;
    maxPoolSize?: number;
    keepAliveTime?: number;
    timeUnit?: string;
    maxQueueSize?: number;
    allowCoreThreadTimeOut?: boolean;
    rejectedPolicy?: string;
    id?: string = 'threadPoolProfile-' + uuidv4().substring(0,4);
    description?: string;
    public constructor(init?: Partial<ThreadPoolProfileDefinition>) {
        super('ThreadPoolProfileDefinition');
        Object.assign(this, init);
    }
}

export class ThreadsDefinition extends CamelElement {
    stepName?: string = 'threads';
    executorService?: string;
    poolSize?: number;
    maxPoolSize?: number;
    keepAliveTime?: number;
    timeUnit?: string;
    maxQueueSize?: number;
    allowCoreThreadTimeOut?: boolean;
    threadName?: string;
    rejectedPolicy?: string;
    callerRunsWhenRejected?: string;
    disabled?: boolean;
    id?: string = 'threads-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<ThreadsDefinition>) {
        super('ThreadsDefinition');
        Object.assign(this, init);
    }
}

export class ThrottleDefinition extends CamelElement {
    stepName?: string = 'throttle';
    expression?: ExpressionDefinition;
    correlationExpression?: ExpressionSubElementDefinition;
    executorService?: string;
    timePeriodMillis?: string;
    asyncDelayed?: boolean;
    callerRunsWhenRejected?: boolean;
    rejectExecution?: boolean;
    disabled?: boolean;
    id?: string = 'throttle-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<ThrottleDefinition>) {
        super('ThrottleDefinition');
        Object.assign(this, init);
    }
}

export class ThrowExceptionDefinition extends CamelElement {
    stepName?: string = 'throwException';
    message?: string;
    exceptionType?: string;
    ref?: string;
    disabled?: boolean;
    id?: string = 'throwException-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<ThrowExceptionDefinition>) {
        super('ThrowExceptionDefinition');
        Object.assign(this, init);
    }
}

export class ToDefinition extends CamelElement {
    stepName?: string = 'to';
    uri: string = '';
    disabled?: boolean;
    pattern?: string;
    id?: string = 'to-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    parameters?: any = {};
    public constructor(init?: Partial<ToDefinition>) {
        super('ToDefinition');
        Object.assign(this, init);
    }
}

export class ToDynamicDefinition extends CamelElement {
    stepName?: string = 'toD';
    uri: string = '';
    pattern?: string;
    cacheSize?: number;
    ignoreInvalidEndpoint?: boolean;
    allowOptimisedComponents?: boolean;
    autoStartComponents?: boolean;
    disabled?: boolean;
    id?: string = 'toD-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    parameters?: any = {};
    public constructor(init?: Partial<ToDynamicDefinition>) {
        super('ToDynamicDefinition');
        Object.assign(this, init);
    }
}

export class TransactedDefinition extends CamelElement {
    stepName?: string = 'transacted';
    ref?: string;
    disabled?: boolean;
    id?: string = 'transacted-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<TransactedDefinition>) {
        super('TransactedDefinition');
        Object.assign(this, init);
    }
}

export class TransformDefinition extends CamelElement {
    stepName?: string = 'transform';
    expression?: ExpressionDefinition;
    disabled?: boolean;
    id?: string = 'transform-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<TransformDefinition>) {
        super('TransformDefinition');
        Object.assign(this, init);
    }
}

export class TryDefinition extends CamelElement {
    stepName?: string = 'doTry';
    disabled?: boolean;
    id?: string = 'doTry-' + uuidv4().substring(0,4);
    description?: string;
    doCatch?: CatchDefinition[] = [];
    doFinally?: FinallyDefinition;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<TryDefinition>) {
        super('TryDefinition');
        Object.assign(this, init);
    }
}

export class UnmarshalDefinition extends CamelElement {
    stepName?: string = 'unmarshal';
    allowNullBody?: boolean;
    disabled?: boolean;
    id?: string = 'unmarshal-' + uuidv4().substring(0,4);
    description?: string;
    any23?: Any23DataFormat | string;
    asn1?: ASN1DataFormat | string;
    avro?: AvroDataFormat | string;
    barcode?: BarcodeDataFormat;
    base64?: Base64DataFormat;
    bindy?: BindyDataFormat;
    cbor?: CBORDataFormat;
    crypto?: CryptoDataFormat;
    csv?: CsvDataFormat | string;
    custom?: CustomDataFormat | string;
    fhirJson?: FhirJsonDataFormat;
    fhirXml?: FhirXmlDataFormat;
    flatpack?: FlatpackDataFormat;
    grok?: GrokDataFormat;
    gzipDeflater?: GzipDeflaterDataFormat;
    hl7?: HL7DataFormat;
    ical?: IcalDataFormat;
    inheritErrorHandler?: boolean;
    jacksonXml?: JacksonXMLDataFormat;
    jaxb?: JaxbDataFormat;
    json?: JsonDataFormat;
    jsonApi?: JsonApiDataFormat;
    lzf?: LZFDataFormat;
    mimeMultipart?: MimeMultipartDataFormat;
    pgp?: PGPDataFormat;
    protobuf?: ProtobufDataFormat | string;
    rss?: RssDataFormat;
    soap?: SoapDataFormat | string;
    swiftMt?: SwiftMtDataFormat | string;
    swiftMx?: SwiftMxDataFormat;
    syslog?: SyslogDataFormat;
    tarFile?: TarFileDataFormat;
    thrift?: ThriftDataFormat | string;
    tidyMarkup?: TidyMarkupDataFormat;
    univocityCsv?: UniVocityCsvDataFormat;
    univocityFixed?: UniVocityFixedDataFormat;
    univocityTsv?: UniVocityTsvDataFormat;
    xmlSecurity?: XMLSecurityDataFormat;
    xstream?: XStreamDataFormat | string;
    yaml?: YAMLDataFormat;
    zipDeflater?: ZipDeflaterDataFormat;
    zipFile?: ZipFileDataFormat;
    public constructor(init?: Partial<UnmarshalDefinition>) {
        super('UnmarshalDefinition');
        Object.assign(this, init);
    }
}

export class ValidateDefinition extends CamelElement {
    stepName?: string = 'validate';
    expression?: ExpressionDefinition;
    predicateExceptionFactory?: string;
    disabled?: boolean;
    id?: string = 'validate-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    public constructor(init?: Partial<ValidateDefinition>) {
        super('ValidateDefinition');
        Object.assign(this, init);
    }
}

export class ValueDefinition extends CamelElement {
    stepName?: string = 'value';
    value?: string;
    public constructor(init?: Partial<ValueDefinition>) {
        super('ValueDefinition');
        Object.assign(this, init);
    }
}

export class WhenDefinition extends CamelElement {
    stepName?: string = 'when';
    expression?: ExpressionDefinition;
    disabled?: boolean;
    id?: string = 'when-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<WhenDefinition>) {
        super('WhenDefinition');
        Object.assign(this, init);
    }
}

export class WhenSkipSendToEndpointDefinition extends CamelElement {
    stepName?: string = 'whenSkipSendToEndpoint';
    expression?: ExpressionDefinition;
    disabled?: boolean;
    id?: string = 'whenSkipSendToEndpoint-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    steps?: CamelElement[] = [];
    public constructor(init?: Partial<WhenSkipSendToEndpointDefinition>) {
        super('WhenSkipSendToEndpointDefinition');
        Object.assign(this, init);
    }
}

export class WireTapDefinition extends CamelElement {
    stepName?: string = 'wireTap';
    copy?: boolean;
    dynamicUri?: boolean;
    onPrepare?: string;
    executorService?: string;
    uri: string = '';
    pattern?: string;
    cacheSize?: number;
    ignoreInvalidEndpoint?: boolean;
    allowOptimisedComponents?: boolean;
    autoStartComponents?: boolean;
    disabled?: boolean;
    id?: string = 'wireTap-' + uuidv4().substring(0,4);
    description?: string;
    inheritErrorHandler?: boolean;
    parameters?: any = {};
    public constructor(init?: Partial<WireTapDefinition>) {
        super('WireTapDefinition');
        Object.assign(this, init);
    }
}

export class BlacklistServiceCallServiceFilterConfiguration extends CamelElement {
    id?: string = 'blacklistServiceCallServiceFilterConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    servers?: string[] = [];
    public constructor(init?: Partial<BlacklistServiceCallServiceFilterConfiguration>) {
        super('BlacklistServiceCallServiceFilterConfiguration');
        Object.assign(this, init);
    }
}

export class CachingServiceCallServiceDiscoveryConfiguration extends CamelElement {
    combinedServiceDiscovery?: CombinedServiceCallServiceDiscoveryConfiguration;
    consulServiceDiscovery?: ConsulServiceCallServiceDiscoveryConfiguration;
    dnsServiceDiscovery?: DnsServiceCallServiceDiscoveryConfiguration;
    id?: string = 'cachingServiceCallServiceDiscoveryConfiguration-' + uuidv4().substring(0,4);
    kubernetesServiceDiscovery?: KubernetesServiceCallServiceDiscoveryConfiguration;
    properties?: PropertyDefinition[] = [];
    staticServiceDiscovery?: StaticServiceCallServiceDiscoveryConfiguration;
    timeout?: number;
    units?: string;
    public constructor(init?: Partial<CachingServiceCallServiceDiscoveryConfiguration>) {
        super('CachingServiceCallServiceDiscoveryConfiguration');
        Object.assign(this, init);
    }
}

export class CombinedServiceCallServiceDiscoveryConfiguration extends CamelElement {
    cachingServiceDiscovery?: CachingServiceCallServiceDiscoveryConfiguration;
    consulServiceDiscovery?: ConsulServiceCallServiceDiscoveryConfiguration;
    dnsServiceDiscovery?: DnsServiceCallServiceDiscoveryConfiguration;
    id?: string = 'combinedServiceCallServiceDiscoveryConfiguration-' + uuidv4().substring(0,4);
    kubernetesServiceDiscovery?: KubernetesServiceCallServiceDiscoveryConfiguration;
    properties?: PropertyDefinition[] = [];
    staticServiceDiscovery?: StaticServiceCallServiceDiscoveryConfiguration;
    public constructor(init?: Partial<CombinedServiceCallServiceDiscoveryConfiguration>) {
        super('CombinedServiceCallServiceDiscoveryConfiguration');
        Object.assign(this, init);
    }
}

export class CombinedServiceCallServiceFilterConfiguration extends CamelElement {
    blacklistServiceFilter?: BlacklistServiceCallServiceFilterConfiguration;
    customServiceFilter?: CustomServiceCallServiceFilterConfiguration;
    healthyServiceFilter?: HealthyServiceCallServiceFilterConfiguration;
    id?: string = 'combinedServiceCallServiceFilterConfiguration-' + uuidv4().substring(0,4);
    passThroughServiceFilter?: PassThroughServiceCallServiceFilterConfiguration;
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<CombinedServiceCallServiceFilterConfiguration>) {
        super('CombinedServiceCallServiceFilterConfiguration');
        Object.assign(this, init);
    }
}

export class ConsulServiceCallServiceDiscoveryConfiguration extends CamelElement {
    aclToken?: string;
    blockSeconds?: number;
    connectTimeoutMillis?: number;
    datacenter?: string;
    id?: string = 'consulServiceCallServiceDiscoveryConfiguration-' + uuidv4().substring(0,4);
    password?: string;
    properties?: PropertyDefinition[] = [];
    readTimeoutMillis?: number;
    url?: string;
    userName?: string;
    writeTimeoutMillis?: number;
    public constructor(init?: Partial<ConsulServiceCallServiceDiscoveryConfiguration>) {
        super('ConsulServiceCallServiceDiscoveryConfiguration');
        Object.assign(this, init);
    }
}

export class CustomServiceCallServiceFilterConfiguration extends CamelElement {
    id?: string = 'customServiceCallServiceFilterConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    ref?: string;
    public constructor(init?: Partial<CustomServiceCallServiceFilterConfiguration>) {
        super('CustomServiceCallServiceFilterConfiguration');
        Object.assign(this, init);
    }
}

export class DefaultServiceCallServiceLoadBalancerConfiguration extends CamelElement {
    id?: string = 'defaultServiceCallServiceLoadBalancerConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<DefaultServiceCallServiceLoadBalancerConfiguration>) {
        super('DefaultServiceCallServiceLoadBalancerConfiguration');
        Object.assign(this, init);
    }
}

export class DnsServiceCallServiceDiscoveryConfiguration extends CamelElement {
    domain?: string;
    id?: string = 'dnsServiceCallServiceDiscoveryConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    proto?: string;
    public constructor(init?: Partial<DnsServiceCallServiceDiscoveryConfiguration>) {
        super('DnsServiceCallServiceDiscoveryConfiguration');
        Object.assign(this, init);
    }
}

export class HealthyServiceCallServiceFilterConfiguration extends CamelElement {
    id?: string = 'healthyServiceCallServiceFilterConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<HealthyServiceCallServiceFilterConfiguration>) {
        super('HealthyServiceCallServiceFilterConfiguration');
        Object.assign(this, init);
    }
}

export class KubernetesServiceCallServiceDiscoveryConfiguration extends CamelElement {
    apiVersion?: string;
    caCertData?: string;
    caCertFile?: string;
    clientCertData?: string;
    clientCertFile?: string;
    clientKeyAlgo?: string;
    clientKeyData?: string;
    clientKeyFile?: string;
    clientKeyPassphrase?: string;
    dnsDomain?: string;
    id?: string = 'kubernetesServiceCallServiceDiscoveryConfiguration-' + uuidv4().substring(0,4);
    lookup?: string;
    masterUrl?: string;
    namespace?: string;
    oauthToken?: string;
    password?: string;
    portName?: string;
    portProtocol?: string;
    properties?: PropertyDefinition[] = [];
    trustCerts?: boolean;
    username?: string;
    public constructor(init?: Partial<KubernetesServiceCallServiceDiscoveryConfiguration>) {
        super('KubernetesServiceCallServiceDiscoveryConfiguration');
        Object.assign(this, init);
    }
}

export class PassThroughServiceCallServiceFilterConfiguration extends CamelElement {
    id?: string = 'passThroughServiceCallServiceFilterConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<PassThroughServiceCallServiceFilterConfiguration>) {
        super('PassThroughServiceCallServiceFilterConfiguration');
        Object.assign(this, init);
    }
}

export class ServiceCallConfigurationDefinition extends CamelElement {
    stepName?: string = 'serviceCallConfiguration';
    expression?: ServiceCallExpressionConfiguration;
    uri?: string;
    component?: string;
    pattern?: string;
    serviceDiscoveryRef?: string;
    serviceFilterRef?: string;
    serviceChooserRef?: string;
    loadBalancerRef?: string;
    expressionRef?: string;
    id?: string = 'serviceCallConfiguration-' + uuidv4().substring(0,4);
    blacklistServiceFilter?: BlacklistServiceCallServiceFilterConfiguration;
    cachingServiceDiscovery?: CachingServiceCallServiceDiscoveryConfiguration;
    combinedServiceDiscovery?: CombinedServiceCallServiceDiscoveryConfiguration;
    combinedServiceFilter?: CombinedServiceCallServiceFilterConfiguration;
    consulServiceDiscovery?: ConsulServiceCallServiceDiscoveryConfiguration;
    customServiceFilter?: CustomServiceCallServiceFilterConfiguration;
    defaultLoadBalancer?: DefaultServiceCallServiceLoadBalancerConfiguration;
    dnsServiceDiscovery?: DnsServiceCallServiceDiscoveryConfiguration;
    healthyServiceFilter?: HealthyServiceCallServiceFilterConfiguration;
    kubernetesServiceDiscovery?: KubernetesServiceCallServiceDiscoveryConfiguration;
    passThroughServiceFilter?: PassThroughServiceCallServiceFilterConfiguration;
    staticServiceDiscovery?: StaticServiceCallServiceDiscoveryConfiguration;
    zookeeperServiceDiscovery?: ZooKeeperServiceCallServiceDiscoveryConfiguration;
    public constructor(init?: Partial<ServiceCallConfigurationDefinition>) {
        super('ServiceCallConfigurationDefinition');
        Object.assign(this, init);
    }
}

export class ServiceCallDefinition extends CamelElement {
    stepName?: string = 'serviceCall';
    name: string = '';
    expression?: ServiceCallExpressionConfiguration;
    uri?: string;
    component?: string;
    pattern?: string;
    configurationRef?: string;
    serviceDiscoveryRef?: string;
    serviceFilterRef?: string;
    serviceChooserRef?: string;
    loadBalancerRef?: string;
    expressionRef?: string;
    disabled?: boolean;
    id?: string = 'serviceCall-' + uuidv4().substring(0,4);
    description?: string;
    blacklistServiceFilter?: BlacklistServiceCallServiceFilterConfiguration;
    cachingServiceDiscovery?: CachingServiceCallServiceDiscoveryConfiguration;
    combinedServiceDiscovery?: CombinedServiceCallServiceDiscoveryConfiguration;
    combinedServiceFilter?: CombinedServiceCallServiceFilterConfiguration;
    consulServiceDiscovery?: ConsulServiceCallServiceDiscoveryConfiguration;
    customServiceFilter?: CustomServiceCallServiceFilterConfiguration;
    defaultLoadBalancer?: DefaultServiceCallServiceLoadBalancerConfiguration;
    dnsServiceDiscovery?: DnsServiceCallServiceDiscoveryConfiguration;
    healthyServiceFilter?: HealthyServiceCallServiceFilterConfiguration;
    inheritErrorHandler?: boolean;
    kubernetesServiceDiscovery?: KubernetesServiceCallServiceDiscoveryConfiguration;
    passThroughServiceFilter?: PassThroughServiceCallServiceFilterConfiguration;
    staticServiceDiscovery?: StaticServiceCallServiceDiscoveryConfiguration;
    zookeeperServiceDiscovery?: ZooKeeperServiceCallServiceDiscoveryConfiguration;
    public constructor(init?: Partial<ServiceCallDefinition>) {
        super('ServiceCallDefinition');
        Object.assign(this, init);
    }
}

export class ServiceCallExpressionConfiguration extends CamelElement {
    expressionType?: ExpressionDefinition;
    hostHeader?: string;
    id?: string = 'serviceCallExpressionConfiguration-' + uuidv4().substring(0,4);
    portHeader?: string;
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<ServiceCallExpressionConfiguration>) {
        super('ServiceCallExpressionConfiguration');
        Object.assign(this, init);
    }
}

export class ServiceCallServiceChooserConfiguration extends CamelElement {
    id?: string = 'serviceCallServiceChooserConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<ServiceCallServiceChooserConfiguration>) {
        super('ServiceCallServiceChooserConfiguration');
        Object.assign(this, init);
    }
}

export class ServiceCallServiceDiscoveryConfiguration extends CamelElement {
    id?: string = 'serviceCallServiceDiscoveryConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<ServiceCallServiceDiscoveryConfiguration>) {
        super('ServiceCallServiceDiscoveryConfiguration');
        Object.assign(this, init);
    }
}

export class ServiceCallServiceFilterConfiguration extends CamelElement {
    id?: string = 'serviceCallServiceFilterConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<ServiceCallServiceFilterConfiguration>) {
        super('ServiceCallServiceFilterConfiguration');
        Object.assign(this, init);
    }
}

export class ServiceCallServiceLoadBalancerConfiguration extends CamelElement {
    id?: string = 'serviceCallServiceLoadBalancerConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    public constructor(init?: Partial<ServiceCallServiceLoadBalancerConfiguration>) {
        super('ServiceCallServiceLoadBalancerConfiguration');
        Object.assign(this, init);
    }
}

export class StaticServiceCallServiceDiscoveryConfiguration extends CamelElement {
    id?: string = 'staticServiceCallServiceDiscoveryConfiguration-' + uuidv4().substring(0,4);
    properties?: PropertyDefinition[] = [];
    servers?: string[] = [];
    public constructor(init?: Partial<StaticServiceCallServiceDiscoveryConfiguration>) {
        super('StaticServiceCallServiceDiscoveryConfiguration');
        Object.assign(this, init);
    }
}

export class ZooKeeperServiceCallServiceDiscoveryConfiguration extends CamelElement {
    basePath: string = '';
    connectionTimeout?: string;
    id?: string = 'zooKeeperServiceCallServiceDiscoveryConfiguration-' + uuidv4().substring(0,4);
    namespace?: string;
    nodes: string = '';
    properties?: PropertyDefinition[] = [];
    reconnectBaseSleepTime?: string;
    reconnectMaxRetries?: string;
    reconnectMaxSleepTime?: string;
    sessionTimeout?: string;
    public constructor(init?: Partial<ZooKeeperServiceCallServiceDiscoveryConfiguration>) {
        super('ZooKeeperServiceCallServiceDiscoveryConfiguration');
        Object.assign(this, init);
    }
}

export class BatchResequencerConfig extends CamelElement {
    allowDuplicates?: boolean;
    batchSize?: number;
    batchTimeout?: string;
    ignoreInvalidExchanges?: boolean;
    reverse?: boolean;
    public constructor(init?: Partial<BatchResequencerConfig>) {
        super('BatchResequencerConfig');
        Object.assign(this, init);
    }
}

export class StreamResequencerConfig extends CamelElement {
    capacity?: number;
    comparator?: string;
    deliveryAttemptInterval?: string;
    ignoreInvalidExchanges?: boolean;
    rejectOld?: boolean;
    timeout?: string;
    public constructor(init?: Partial<StreamResequencerConfig>) {
        super('StreamResequencerConfig');
        Object.assign(this, init);
    }
}

export class ASN1DataFormat extends CamelElement {
    dataFormatName?: string = 'asn1';
    unmarshalType?: string;
    usingIterator?: boolean;
    id?: string = 'asn1-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<ASN1DataFormat>) {
        super('ASN1DataFormat');
        Object.assign(this, init);
    }
}

export class Any23DataFormat extends CamelElement {
    dataFormatName?: string = 'any23';
    outputFormat?: string;
    baseUri?: string;
    configuration?: PropertyDefinition[] = [];
    extractors?: string[] = [];
    id?: string = 'any23-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<Any23DataFormat>) {
        super('Any23DataFormat');
        Object.assign(this, init);
    }
}

export class AvroDataFormat extends CamelElement {
    dataFormatName?: string = 'avro';
    instanceClassName?: string;
    library?: string;
    objectMapper?: string;
    useDefaultObjectMapper?: boolean;
    unmarshalType?: string;
    jsonView?: string;
    include?: string;
    allowJmsType?: boolean;
    collectionType?: string;
    useList?: boolean;
    moduleClassNames?: string;
    moduleRefs?: string;
    enableFeatures?: string;
    disableFeatures?: string;
    allowUnmarshallType?: boolean;
    timezone?: string;
    autoDiscoverObjectMapper?: boolean;
    contentTypeHeader?: boolean;
    schemaResolver?: string;
    autoDiscoverSchemaResolver?: boolean;
    id?: string = 'avro-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<AvroDataFormat>) {
        super('AvroDataFormat');
        Object.assign(this, init);
    }
}

export class BarcodeDataFormat extends CamelElement {
    dataFormatName?: string = 'barcode';
    barcodeFormat?: string;
    imageType?: string;
    width?: number;
    height?: number;
    id?: string = 'barcode-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<BarcodeDataFormat>) {
        super('BarcodeDataFormat');
        Object.assign(this, init);
    }
}

export class Base64DataFormat extends CamelElement {
    dataFormatName?: string = 'base64';
    lineLength?: number;
    lineSeparator?: string;
    urlSafe?: boolean;
    id?: string = 'base64-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<Base64DataFormat>) {
        super('Base64DataFormat');
        Object.assign(this, init);
    }
}

export class BindyDataFormat extends CamelElement {
    dataFormatName?: string = 'bindy';
    type: string = '';
    classType?: string;
    allowEmptyStream?: boolean;
    unwrapSingleInstance?: boolean;
    locale?: string;
    id?: string = 'bindy-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<BindyDataFormat>) {
        super('BindyDataFormat');
        Object.assign(this, init);
    }
}

export class CBORDataFormat extends CamelElement {
    dataFormatName?: string = 'cbor';
    objectMapper?: string;
    useDefaultObjectMapper?: boolean;
    unmarshalType?: string;
    collectionType?: string;
    useList?: boolean;
    allowUnmarshallType?: boolean;
    prettyPrint?: boolean;
    allowJmsType?: boolean;
    enableFeatures?: string;
    disableFeatures?: string;
    id?: string = 'cbor-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<CBORDataFormat>) {
        super('CBORDataFormat');
        Object.assign(this, init);
    }
}

export class CryptoDataFormat extends CamelElement {
    dataFormatName?: string = 'crypto';
    algorithm?: string;
    keyRef?: string;
    cryptoProvider?: string;
    initVectorRef?: string;
    algorithmParameterRef?: string;
    bufferSize?: number;
    macAlgorithm?: string;
    shouldAppendHmac?: boolean;
    inline?: boolean;
    id?: string = 'crypto-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<CryptoDataFormat>) {
        super('CryptoDataFormat');
        Object.assign(this, init);
    }
}

export class CsvDataFormat extends CamelElement {
    dataFormatName?: string = 'csv';
    formatRef?: string;
    formatName?: string;
    commentMarkerDisabled?: boolean;
    commentMarker?: string;
    delimiter?: string;
    escapeDisabled?: boolean;
    escape?: string;
    headerDisabled?: boolean;
    header?: string[] = [];
    allowMissingColumnNames?: boolean;
    ignoreEmptyLines?: boolean;
    ignoreSurroundingSpaces?: boolean;
    nullStringDisabled?: boolean;
    nullString?: string;
    quoteDisabled?: boolean;
    quote?: string;
    recordSeparatorDisabled?: string;
    recordSeparator?: string;
    skipHeaderRecord?: boolean;
    quoteMode?: string;
    ignoreHeaderCase?: boolean;
    trim?: boolean;
    trailingDelimiter?: boolean;
    marshallerFactoryRef?: string;
    lazyLoad?: boolean;
    useMaps?: boolean;
    useOrderedMaps?: boolean;
    recordConverterRef?: string;
    captureHeaderRecord?: boolean;
    id?: string = 'csv-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<CsvDataFormat>) {
        super('CsvDataFormat');
        Object.assign(this, init);
    }
}

export class CustomDataFormat extends CamelElement {
    dataFormatName?: string = 'custom';
    ref: string = '';
    id?: string = 'custom-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<CustomDataFormat>) {
        super('CustomDataFormat');
        Object.assign(this, init);
    }
}

export class DataFormatsDefinition extends CamelElement {
    stepName?: string = 'dataFormats';
    any23?: Any23DataFormat | string;
    asn1?: ASN1DataFormat | string;
    avro?: AvroDataFormat | string;
    barcode?: BarcodeDataFormat;
    base64?: Base64DataFormat;
    bindy?: BindyDataFormat;
    cbor?: CBORDataFormat;
    crypto?: CryptoDataFormat;
    csv?: CsvDataFormat | string;
    custom?: CustomDataFormat | string;
    fhirJson?: FhirJsonDataFormat;
    fhirXml?: FhirXmlDataFormat;
    flatpack?: FlatpackDataFormat;
    grok?: GrokDataFormat;
    gzipDeflater?: GzipDeflaterDataFormat;
    hl7?: HL7DataFormat;
    ical?: IcalDataFormat;
    jacksonXml?: JacksonXMLDataFormat;
    jaxb?: JaxbDataFormat;
    json?: JsonDataFormat;
    jsonApi?: JsonApiDataFormat;
    lzf?: LZFDataFormat;
    mimeMultipart?: MimeMultipartDataFormat;
    pgp?: PGPDataFormat;
    protobuf?: ProtobufDataFormat | string;
    rss?: RssDataFormat;
    soap?: SoapDataFormat | string;
    swiftMt?: SwiftMtDataFormat | string;
    swiftMx?: SwiftMxDataFormat;
    syslog?: SyslogDataFormat;
    tarFile?: TarFileDataFormat;
    thrift?: ThriftDataFormat | string;
    tidyMarkup?: TidyMarkupDataFormat;
    univocityCsv?: UniVocityCsvDataFormat;
    univocityFixed?: UniVocityFixedDataFormat;
    univocityTsv?: UniVocityTsvDataFormat;
    xmlSecurity?: XMLSecurityDataFormat;
    xstream?: XStreamDataFormat | string;
    yaml?: YAMLDataFormat;
    zipDeflater?: ZipDeflaterDataFormat;
    zipFile?: ZipFileDataFormat;
    public constructor(init?: Partial<DataFormatsDefinition>) {
        super('DataFormatsDefinition');
        Object.assign(this, init);
    }
}

export class FhirJsonDataFormat extends CamelElement {
    dataFormatName?: string = 'fhirJson';
    fhirVersion?: string;
    fhirContext?: string;
    prettyPrint?: boolean;
    parserErrorHandler?: string;
    parserOptions?: string;
    preferTypes?: string;
    forceResourceId?: string;
    serverBaseUrl?: string;
    omitResourceId?: boolean;
    encodeElementsAppliesToChildResourcesOnly?: boolean;
    encodeElements?: string;
    dontEncodeElements?: string;
    stripVersionsFromReferences?: boolean;
    overrideResourceIdWithBundleEntryFullUrl?: boolean;
    summaryMode?: boolean;
    suppressNarratives?: boolean;
    dontStripVersionsFromReferencesAtPaths?: string;
    contentTypeHeader?: boolean;
    id?: string = 'fhirJson-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<FhirJsonDataFormat>) {
        super('FhirJsonDataFormat');
        Object.assign(this, init);
    }
}

export class FhirXmlDataFormat extends CamelElement {
    dataFormatName?: string = 'fhirXml';
    fhirVersion?: string;
    fhirContext?: string;
    prettyPrint?: boolean;
    parserErrorHandler?: string;
    parserOptions?: string;
    preferTypes?: string;
    forceResourceId?: string;
    serverBaseUrl?: string;
    omitResourceId?: boolean;
    encodeElementsAppliesToChildResourcesOnly?: boolean;
    encodeElements?: string;
    dontEncodeElements?: string;
    stripVersionsFromReferences?: boolean;
    overrideResourceIdWithBundleEntryFullUrl?: boolean;
    summaryMode?: boolean;
    suppressNarratives?: boolean;
    dontStripVersionsFromReferencesAtPaths?: string;
    contentTypeHeader?: boolean;
    id?: string = 'fhirXml-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<FhirXmlDataFormat>) {
        super('FhirXmlDataFormat');
        Object.assign(this, init);
    }
}

export class FlatpackDataFormat extends CamelElement {
    dataFormatName?: string = 'flatpack';
    definition?: string;
    fixed?: boolean;
    delimiter?: string;
    ignoreFirstRecord?: boolean;
    allowShortLines?: boolean;
    ignoreExtraColumns?: boolean;
    textQualifier?: string;
    parserFactoryRef?: string;
    id?: string = 'flatpack-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<FlatpackDataFormat>) {
        super('FlatpackDataFormat');
        Object.assign(this, init);
    }
}

export class GrokDataFormat extends CamelElement {
    dataFormatName?: string = 'grok';
    pattern: string = '';
    flattened?: boolean;
    allowMultipleMatchesPerLine?: boolean;
    namedOnly?: boolean;
    id?: string = 'grok-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<GrokDataFormat>) {
        super('GrokDataFormat');
        Object.assign(this, init);
    }
}

export class GzipDeflaterDataFormat extends CamelElement {
    dataFormatName?: string = 'gzipDeflater';
    id?: string = 'gzipDeflater-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<GzipDeflaterDataFormat>) {
        super('GzipDeflaterDataFormat');
        Object.assign(this, init);
    }
}

export class HL7DataFormat extends CamelElement {
    dataFormatName?: string = 'hl7';
    validate?: boolean;
    id?: string = 'hl7-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<HL7DataFormat>) {
        super('HL7DataFormat');
        Object.assign(this, init);
    }
}

export class IcalDataFormat extends CamelElement {
    dataFormatName?: string = 'ical';
    validating?: boolean;
    id?: string = 'ical-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<IcalDataFormat>) {
        super('IcalDataFormat');
        Object.assign(this, init);
    }
}

export class JacksonXMLDataFormat extends CamelElement {
    dataFormatName?: string = 'jacksonXml';
    xmlMapper?: string;
    prettyPrint?: boolean;
    unmarshalType?: string;
    allowUnmarshallType?: boolean;
    jsonView?: string;
    include?: string;
    allowJmsType?: boolean;
    collectionType?: string;
    useList?: boolean;
    timezone?: string;
    enableJaxbAnnotationModule?: boolean;
    moduleClassNames?: string;
    moduleRefs?: string;
    enableFeatures?: string;
    disableFeatures?: string;
    contentTypeHeader?: boolean;
    id?: string = 'jacksonXml-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<JacksonXMLDataFormat>) {
        super('JacksonXMLDataFormat');
        Object.assign(this, init);
    }
}

export class JaxbDataFormat extends CamelElement {
    dataFormatName?: string = 'jaxb';
    contextPath: string = '';
    contextPathIsClassName?: boolean;
    schema?: string;
    schemaSeverityLevel?: string;
    prettyPrint?: boolean;
    objectFactory?: boolean;
    ignoreJaxbElement?: boolean;
    mustBeJaxbElement?: boolean;
    filterNonXmlChars?: boolean;
    encoding?: string;
    fragment?: boolean;
    partClass?: string;
    partNamespace?: string;
    namespacePrefixRef?: string;
    xmlStreamWriterWrapper?: string;
    schemaLocation?: string;
    noNamespaceSchemaLocation?: string;
    jaxbProviderProperties?: string;
    contentTypeHeader?: boolean;
    accessExternalSchemaProtocols?: string;
    id?: string = 'jaxb-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<JaxbDataFormat>) {
        super('JaxbDataFormat');
        Object.assign(this, init);
    }
}

export class JsonApiDataFormat extends CamelElement {
    dataFormatName?: string = 'jsonApi';
    dataFormatTypes?: string;
    mainFormatType?: string;
    id?: string = 'jsonApi-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<JsonApiDataFormat>) {
        super('JsonApiDataFormat');
        Object.assign(this, init);
    }
}

export class JsonDataFormat extends CamelElement {
    dataFormatName?: string = 'json';
    objectMapper?: string;
    useDefaultObjectMapper?: boolean;
    autoDiscoverObjectMapper?: boolean;
    prettyPrint?: boolean;
    library?: string;
    unmarshalType?: string;
    jsonView?: string;
    include?: string;
    allowJmsType?: boolean;
    collectionType?: string;
    useList?: boolean;
    moduleClassNames?: string;
    moduleRefs?: string;
    enableFeatures?: string;
    disableFeatures?: string;
    permissions?: string;
    allowUnmarshallType?: boolean;
    timezone?: string;
    dropRootNode?: boolean;
    schemaResolver?: string;
    autoDiscoverSchemaResolver?: boolean;
    namingStrategy?: string;
    contentTypeHeader?: boolean;
    dateFormatPattern?: string;
    id?: string = 'json-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<JsonDataFormat>) {
        super('JsonDataFormat');
        Object.assign(this, init);
    }
}

export class LZFDataFormat extends CamelElement {
    dataFormatName?: string = 'lzf';
    usingParallelCompression?: boolean;
    id?: string = 'lzf-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<LZFDataFormat>) {
        super('LZFDataFormat');
        Object.assign(this, init);
    }
}

export class MimeMultipartDataFormat extends CamelElement {
    dataFormatName?: string = 'mimeMultipart';
    multipartSubType?: string;
    multipartWithoutAttachment?: boolean;
    headersInline?: boolean;
    includeHeaders?: string;
    binaryContent?: boolean;
    id?: string = 'mimeMultipart-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<MimeMultipartDataFormat>) {
        super('MimeMultipartDataFormat');
        Object.assign(this, init);
    }
}

export class PGPDataFormat extends CamelElement {
    dataFormatName?: string = 'pgp';
    keyUserid?: string;
    signatureKeyUserid?: string;
    password?: string;
    signaturePassword?: string;
    keyFileName?: string;
    signatureKeyFileName?: string;
    signatureKeyRing?: string;
    armored?: boolean;
    integrity?: boolean;
    provider?: string;
    algorithm?: number;
    compressionAlgorithm?: number;
    hashAlgorithm?: number;
    signatureVerificationOption?: string;
    id?: string = 'pgp-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<PGPDataFormat>) {
        super('PGPDataFormat');
        Object.assign(this, init);
    }
}

export class ProtobufDataFormat extends CamelElement {
    dataFormatName?: string = 'protobuf';
    instanceClass?: string;
    objectMapper?: string;
    useDefaultObjectMapper?: boolean;
    autoDiscoverObjectMapper?: boolean;
    library?: string;
    unmarshalType?: string;
    jsonView?: string;
    include?: string;
    allowJmsType?: boolean;
    collectionType?: string;
    useList?: boolean;
    moduleClassNames?: string;
    moduleRefs?: string;
    enableFeatures?: string;
    disableFeatures?: string;
    allowUnmarshallType?: boolean;
    timezone?: string;
    schemaResolver?: string;
    autoDiscoverSchemaResolver?: boolean;
    contentTypeFormat?: string;
    contentTypeHeader?: boolean;
    id?: string = 'protobuf-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<ProtobufDataFormat>) {
        super('ProtobufDataFormat');
        Object.assign(this, init);
    }
}

export class RssDataFormat extends CamelElement {
    dataFormatName?: string = 'rss';
    id?: string = 'rss-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<RssDataFormat>) {
        super('RssDataFormat');
        Object.assign(this, init);
    }
}

export class SoapDataFormat extends CamelElement {
    dataFormatName?: string = 'soap';
    contextPath: string = '';
    encoding?: string;
    elementNameStrategyRef?: string;
    version?: string;
    namespacePrefixRef?: string;
    schema?: string;
    id?: string = 'soap-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<SoapDataFormat>) {
        super('SoapDataFormat');
        Object.assign(this, init);
    }
}

export class SwiftMtDataFormat extends CamelElement {
    dataFormatName?: string = 'swiftMt';
    writeInJson?: boolean;
    id?: string = 'swiftMt-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<SwiftMtDataFormat>) {
        super('SwiftMtDataFormat');
        Object.assign(this, init);
    }
}

export class SwiftMxDataFormat extends CamelElement {
    dataFormatName?: string = 'swiftMx';
    writeConfigRef?: string;
    writeInJson?: boolean;
    readMessageId?: string;
    readConfigRef?: string;
    id?: string = 'swiftMx-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<SwiftMxDataFormat>) {
        super('SwiftMxDataFormat');
        Object.assign(this, init);
    }
}

export class SyslogDataFormat extends CamelElement {
    dataFormatName?: string = 'syslog';
    id?: string = 'syslog-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<SyslogDataFormat>) {
        super('SyslogDataFormat');
        Object.assign(this, init);
    }
}

export class TarFileDataFormat extends CamelElement {
    dataFormatName?: string = 'tarFile';
    usingIterator?: boolean;
    allowEmptyDirectory?: boolean;
    preservePathElements?: boolean;
    maxDecompressedSize?: number;
    id?: string = 'tarFile-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<TarFileDataFormat>) {
        super('TarFileDataFormat');
        Object.assign(this, init);
    }
}

export class ThriftDataFormat extends CamelElement {
    dataFormatName?: string = 'thrift';
    instanceClass?: string;
    contentTypeFormat?: string;
    contentTypeHeader?: boolean;
    id?: string = 'thrift-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<ThriftDataFormat>) {
        super('ThriftDataFormat');
        Object.assign(this, init);
    }
}

export class TidyMarkupDataFormat extends CamelElement {
    dataFormatName?: string = 'tidyMarkup';
    dataObjectType?: string;
    omitXmlDeclaration?: boolean;
    id?: string = 'tidyMarkup-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<TidyMarkupDataFormat>) {
        super('TidyMarkupDataFormat');
        Object.assign(this, init);
    }
}

export class UniVocityCsvDataFormat extends CamelElement {
    dataFormatName?: string = 'univocityCsv';
    delimiter?: string;
    quoteAllFields?: boolean;
    quote?: string;
    quoteEscape?: string;
    nullValue?: string;
    skipEmptyLines?: boolean;
    ignoreTrailingWhitespaces?: boolean;
    ignoreLeadingWhitespaces?: boolean;
    headersDisabled?: boolean;
    headerExtractionEnabled?: boolean;
    numberOfRecordsToRead?: number;
    emptyValue?: string;
    lineSeparator?: string;
    normalizedLineSeparator?: string;
    comment?: string;
    lazyLoad?: boolean;
    asMap?: boolean;
    id?: string = 'univocityCsv-' + uuidv4().substring(0,4);
    univocityHeader?: UniVocityHeader[] = [];
    public constructor(init?: Partial<UniVocityCsvDataFormat>) {
        super('UniVocityCsvDataFormat');
        Object.assign(this, init);
    }
}

export class UniVocityFixedDataFormat extends CamelElement {
    dataFormatName?: string = 'univocityFixed';
    padding?: string;
    skipTrailingCharsUntilNewline?: boolean;
    recordEndsOnNewline?: boolean;
    nullValue?: string;
    skipEmptyLines?: boolean;
    ignoreTrailingWhitespaces?: boolean;
    ignoreLeadingWhitespaces?: boolean;
    headersDisabled?: boolean;
    headerExtractionEnabled?: boolean;
    numberOfRecordsToRead?: number;
    emptyValue?: string;
    lineSeparator?: string;
    normalizedLineSeparator?: string;
    comment?: string;
    lazyLoad?: boolean;
    asMap?: boolean;
    id?: string = 'univocityFixed-' + uuidv4().substring(0,4);
    univocityHeader?: UniVocityHeader[] = [];
    public constructor(init?: Partial<UniVocityFixedDataFormat>) {
        super('UniVocityFixedDataFormat');
        Object.assign(this, init);
    }
}

export class UniVocityHeader extends CamelElement {
    length?: string;
    name?: string;
    public constructor(init?: Partial<UniVocityHeader>) {
        super('UniVocityHeader');
        Object.assign(this, init);
    }
}

export class UniVocityTsvDataFormat extends CamelElement {
    dataFormatName?: string = 'univocityTsv';
    escapeChar?: string;
    nullValue?: string;
    skipEmptyLines?: boolean;
    ignoreTrailingWhitespaces?: boolean;
    ignoreLeadingWhitespaces?: boolean;
    headersDisabled?: boolean;
    headerExtractionEnabled?: boolean;
    numberOfRecordsToRead?: number;
    emptyValue?: string;
    lineSeparator?: string;
    normalizedLineSeparator?: string;
    comment?: string;
    lazyLoad?: boolean;
    asMap?: boolean;
    id?: string = 'univocityTsv-' + uuidv4().substring(0,4);
    univocityHeader?: UniVocityHeader[] = [];
    public constructor(init?: Partial<UniVocityTsvDataFormat>) {
        super('UniVocityTsvDataFormat');
        Object.assign(this, init);
    }
}

export class XMLSecurityDataFormat extends CamelElement {
    dataFormatName?: string = 'xmlSecurity';
    xmlCipherAlgorithm?: string;
    passPhrase?: string;
    passPhraseByte?: string;
    secureTag?: string;
    secureTagContents?: boolean;
    keyCipherAlgorithm?: string;
    recipientKeyAlias?: string;
    keyOrTrustStoreParametersRef?: string;
    keyPassword?: string;
    digestAlgorithm?: string;
    mgfAlgorithm?: string;
    addKeyValueForEncryptedKey?: boolean;
    id?: string = 'xmlSecurity-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<XMLSecurityDataFormat>) {
        super('XMLSecurityDataFormat');
        Object.assign(this, init);
    }
}

export class XStreamDataFormat extends CamelElement {
    dataFormatName?: string = 'xstream';
    permissions?: string;
    encoding?: string;
    driver?: string;
    driverRef?: string;
    mode?: string;
    contentTypeHeader?: boolean;
    converters?: PropertyDefinition[] = [];
    aliases?: PropertyDefinition[] = [];
    omitFields?: PropertyDefinition[] = [];
    implicitCollections?: PropertyDefinition[] = [];
    id?: string = 'xstream-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<XStreamDataFormat>) {
        super('XStreamDataFormat');
        Object.assign(this, init);
    }
}

export class YAMLDataFormat extends CamelElement {
    dataFormatName?: string = 'yaml';
    library?: string;
    unmarshalType?: string;
    _constructor?: string;
    representer?: string;
    dumperOptions?: string;
    resolver?: string;
    useApplicationContextClassLoader?: boolean;
    prettyFlow?: boolean;
    allowAnyType?: boolean;
    typeFilter?: YAMLTypeFilterDefinition[] = [];
    maxAliasesForCollections?: number;
    allowRecursiveKeys?: boolean;
    id?: string = 'yaml-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<YAMLDataFormat>) {
        super('YAMLDataFormat');
        Object.assign(this, init);
    }
}

export class YAMLTypeFilterDefinition extends CamelElement {
    stepName?: string = 'yAMLTypeFilter';
    type?: string;
    value?: string;
    public constructor(init?: Partial<YAMLTypeFilterDefinition>) {
        super('YAMLTypeFilterDefinition');
        Object.assign(this, init);
    }
}

export class ZipDeflaterDataFormat extends CamelElement {
    dataFormatName?: string = 'zipDeflater';
    compressionLevel?: string;
    id?: string = 'zipDeflater-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<ZipDeflaterDataFormat>) {
        super('ZipDeflaterDataFormat');
        Object.assign(this, init);
    }
}

export class ZipFileDataFormat extends CamelElement {
    dataFormatName?: string = 'zipFile';
    usingIterator?: boolean;
    allowEmptyDirectory?: boolean;
    preservePathElements?: boolean;
    maxDecompressedSize?: number;
    id?: string = 'zipFile-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<ZipFileDataFormat>) {
        super('ZipFileDataFormat');
        Object.assign(this, init);
    }
}

export class DeadLetterChannelDefinition extends CamelElement {
    stepName?: string = 'deadLetterChannel';
    deadLetterUri: string = '';
    deadLetterHandleNewException?: boolean;
    loggerRef?: string;
    level?: string;
    logName?: string;
    useOriginalMessage?: boolean;
    useOriginalBody?: boolean;
    onRedeliveryRef?: string;
    onExceptionOccurredRef?: string;
    onPrepareFailureRef?: string;
    retryWhileRef?: string;
    redeliveryPolicyRef?: string;
    executorServiceRef?: string;
    redeliveryPolicy?: RedeliveryPolicyDefinition;
    id?: string = 'deadLetterChannel-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<DeadLetterChannelDefinition>) {
        super('DeadLetterChannelDefinition');
        Object.assign(this, init);
    }
}

export class DefaultErrorHandlerDefinition extends CamelElement {
    stepName?: string = 'defaultErrorHandler';
    loggerRef?: string;
    level?: string;
    logName?: string;
    useOriginalMessage?: boolean;
    useOriginalBody?: boolean;
    onRedeliveryRef?: string;
    onExceptionOccurredRef?: string;
    onPrepareFailureRef?: string;
    retryWhileRef?: string;
    redeliveryPolicyRef?: string;
    executorServiceRef?: string;
    redeliveryPolicy?: RedeliveryPolicyDefinition;
    id?: string = 'defaultErrorHandler-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<DefaultErrorHandlerDefinition>) {
        super('DefaultErrorHandlerDefinition');
        Object.assign(this, init);
    }
}

export class JtaTransactionErrorHandlerDefinition extends CamelElement {
    stepName?: string = 'jtaTransactionErrorHandler';
    transactedPolicyRef?: string;
    rollbackLoggingLevel?: string;
    loggerRef?: string;
    level?: string;
    logName?: string;
    useOriginalMessage?: boolean;
    useOriginalBody?: boolean;
    onRedeliveryRef?: string;
    onExceptionOccurredRef?: string;
    onPrepareFailureRef?: string;
    retryWhileRef?: string;
    redeliveryPolicyRef?: string;
    executorServiceRef?: string;
    redeliveryPolicy?: RedeliveryPolicyDefinition;
    id?: string = 'jtaTransactionErrorHandler-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<JtaTransactionErrorHandlerDefinition>) {
        super('JtaTransactionErrorHandlerDefinition');
        Object.assign(this, init);
    }
}

export class NoErrorHandlerDefinition extends CamelElement {
    stepName?: string = 'noErrorHandler';
    id?: string = 'noErrorHandler-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<NoErrorHandlerDefinition>) {
        super('NoErrorHandlerDefinition');
        Object.assign(this, init);
    }
}

export class RefErrorHandlerDefinition extends CamelElement {
    stepName?: string = 'refErrorHandler';
    ref: string = '';
    id?: string = 'refErrorHandler-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<RefErrorHandlerDefinition>) {
        super('RefErrorHandlerDefinition');
        Object.assign(this, init);
    }
}

export class SpringTransactionErrorHandlerDefinition extends CamelElement {
    stepName?: string = 'springTransactionErrorHandler';
    transactedPolicyRef?: string;
    rollbackLoggingLevel?: string;
    loggerRef?: string;
    level?: string;
    logName?: string;
    useOriginalMessage?: boolean;
    useOriginalBody?: boolean;
    onRedeliveryRef?: string;
    onExceptionOccurredRef?: string;
    onPrepareFailureRef?: string;
    retryWhileRef?: string;
    redeliveryPolicyRef?: string;
    executorServiceRef?: string;
    redeliveryPolicy?: RedeliveryPolicyDefinition;
    id?: string = 'springTransactionErrorHandler-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<SpringTransactionErrorHandlerDefinition>) {
        super('SpringTransactionErrorHandlerDefinition');
        Object.assign(this, init);
    }
}

export class CSimpleExpression extends CamelElement {
    expressionName?: string = 'csimple';
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    id?: string = 'csimple-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<CSimpleExpression>) {
        super('CSimpleExpression');
        Object.assign(this, init);
    }
}

export class ConstantExpression extends CamelElement {
    expressionName?: string = 'constant';
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    id?: string = 'constant-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<ConstantExpression>) {
        super('ConstantExpression');
        Object.assign(this, init);
    }
}

export class DatasonnetExpression extends CamelElement {
    expressionName?: string = 'datasonnet';
    expression: string = '';
    bodyMediaType?: string;
    outputMediaType?: string;
    resultType?: string;
    trim?: boolean;
    id?: string = 'datasonnet-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<DatasonnetExpression>) {
        super('DatasonnetExpression');
        Object.assign(this, init);
    }
}

export class ExchangePropertyExpression extends CamelElement {
    expressionName?: string = 'exchangeProperty';
    expression: string = '';
    trim?: boolean;
    id?: string = 'exchangeProperty-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<ExchangePropertyExpression>) {
        super('ExchangePropertyExpression');
        Object.assign(this, init);
    }
}

export class ExpressionDefinition extends CamelElement {
    stepName?: string = 'expression';
    constant?: ConstantExpression | string;
    csimple?: CSimpleExpression | string;
    datasonnet?: DatasonnetExpression | string;
    exchangeProperty?: ExchangePropertyExpression | string;
    groovy?: GroovyExpression | string;
    header?: HeaderExpression | string;
    hl7terser?: Hl7TerserExpression | string;
    joor?: JoorExpression | string;
    jq?: JqExpression | string;
    js?: JavaScriptExpression | string;
    jsonpath?: JsonPathExpression | string;
    language?: LanguageExpression;
    method?: MethodCallExpression | string;
    mvel?: MvelExpression | string;
    ognl?: OgnlExpression | string;
    python?: PythonExpression | string;
    ref?: RefExpression | string;
    simple?: SimpleExpression | string;
    spel?: SpELExpression | string;
    tokenize?: TokenizerExpression | string;
    xpath?: XPathExpression | string;
    xquery?: XQueryExpression | string;
    xtokenize?: XMLTokenizerExpression | string;
    public constructor(init?: Partial<ExpressionDefinition>) {
        super('ExpressionDefinition');
        Object.assign(this, init);
    }
}

export class GroovyExpression extends CamelElement {
    expressionName?: string = 'groovy';
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    id?: string = 'groovy-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<GroovyExpression>) {
        super('GroovyExpression');
        Object.assign(this, init);
    }
}

export class HeaderExpression extends CamelElement {
    expressionName?: string = 'header';
    expression: string = '';
    trim?: boolean;
    id?: string = 'header-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<HeaderExpression>) {
        super('HeaderExpression');
        Object.assign(this, init);
    }
}

export class Hl7TerserExpression extends CamelElement {
    expressionName?: string = 'hl7terser';
    expression: string = '';
    headerName?: string;
    propertyName?: string;
    resultType?: string;
    trim?: boolean;
    id?: string = 'hl7terser-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<Hl7TerserExpression>) {
        super('Hl7TerserExpression');
        Object.assign(this, init);
    }
}

export class JavaScriptExpression extends CamelElement {
    expressionName?: string = 'js';
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    id?: string = 'js-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<JavaScriptExpression>) {
        super('JavaScriptExpression');
        Object.assign(this, init);
    }
}

export class JoorExpression extends CamelElement {
    expressionName?: string = 'joor';
    expression: string = '';
    preCompile?: boolean;
    singleQuotes?: boolean;
    resultType?: string;
    trim?: boolean;
    id?: string = 'joor-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<JoorExpression>) {
        super('JoorExpression');
        Object.assign(this, init);
    }
}

export class JqExpression extends CamelElement {
    expressionName?: string = 'jq';
    expression: string = '';
    headerName?: string;
    propertyName?: string;
    resultType?: string;
    trim?: boolean;
    id?: string = 'jq-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<JqExpression>) {
        super('JqExpression');
        Object.assign(this, init);
    }
}

export class JsonPathExpression extends CamelElement {
    expressionName?: string = 'jsonpath';
    expression: string = '';
    suppressExceptions?: boolean;
    allowSimple?: boolean;
    allowEasyPredicate?: boolean;
    writeAsString?: boolean;
    unpackArray?: boolean;
    option?: string;
    headerName?: string;
    propertyName?: string;
    resultType?: string;
    trim?: boolean;
    id?: string = 'jsonpath-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<JsonPathExpression>) {
        super('JsonPathExpression');
        Object.assign(this, init);
    }
}

export class LanguageExpression extends CamelElement {
    expressionName?: string = 'language';
    language: string = '';
    expression: string = '';
    trim?: boolean;
    id?: string = 'language-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<LanguageExpression>) {
        super('LanguageExpression');
        Object.assign(this, init);
    }
}

export class MethodCallExpression extends CamelElement {
    expressionName?: string = 'method';
    ref?: string;
    method?: string;
    beanType?: string;
    scope?: string;
    resultType?: string;
    trim?: boolean;
    id?: string = 'method-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<MethodCallExpression>) {
        super('MethodCallExpression');
        Object.assign(this, init);
    }
}

export class MvelExpression extends CamelElement {
    expressionName?: string = 'mvel';
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    id?: string = 'mvel-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<MvelExpression>) {
        super('MvelExpression');
        Object.assign(this, init);
    }
}

export class OgnlExpression extends CamelElement {
    expressionName?: string = 'ognl';
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    id?: string = 'ognl-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<OgnlExpression>) {
        super('OgnlExpression');
        Object.assign(this, init);
    }
}

export class PythonExpression extends CamelElement {
    expressionName?: string = 'python';
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    id?: string = 'python-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<PythonExpression>) {
        super('PythonExpression');
        Object.assign(this, init);
    }
}

export class RefExpression extends CamelElement {
    expressionName?: string = 'ref';
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    id?: string = 'ref-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<RefExpression>) {
        super('RefExpression');
        Object.assign(this, init);
    }
}

export class SimpleExpression extends CamelElement {
    expressionName?: string = 'simple';
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    id?: string = 'simple-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<SimpleExpression>) {
        super('SimpleExpression');
        Object.assign(this, init);
    }
}

export class SpELExpression extends CamelElement {
    expressionName?: string = 'spel';
    expression: string = '';
    resultType?: string;
    trim?: boolean;
    id?: string = 'spel-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<SpELExpression>) {
        super('SpELExpression');
        Object.assign(this, init);
    }
}

export class TokenizerExpression extends CamelElement {
    expressionName?: string = 'tokenize';
    token: string = '';
    endToken?: string;
    inheritNamespaceTagName?: string;
    regex?: boolean;
    xml?: boolean;
    includeTokens?: boolean;
    group?: string;
    groupDelimiter?: string;
    skipFirst?: boolean;
    headerName?: string;
    propertyName?: string;
    trim?: boolean;
    id?: string = 'tokenize-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<TokenizerExpression>) {
        super('TokenizerExpression');
        Object.assign(this, init);
    }
}

export class XMLTokenizerExpression extends CamelElement {
    expressionName?: string = 'xtokenize';
    expression: string = '';
    mode?: string;
    group?: number;
    namespace?: PropertyDefinition[] = [];
    headerName?: string;
    propertyName?: string;
    trim?: boolean;
    id?: string = 'xtokenize-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<XMLTokenizerExpression>) {
        super('XMLTokenizerExpression');
        Object.assign(this, init);
    }
}

export class XPathExpression extends CamelElement {
    expressionName?: string = 'xpath';
    expression: string = '';
    documentType?: string;
    resultType?: string;
    saxon?: boolean;
    factoryRef?: string;
    objectModel?: string;
    logNamespaces?: boolean;
    threadSafety?: boolean;
    preCompile?: boolean;
    namespace?: PropertyDefinition[] = [];
    headerName?: string;
    propertyName?: string;
    trim?: boolean;
    id?: string = 'xpath-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<XPathExpression>) {
        super('XPathExpression');
        Object.assign(this, init);
    }
}

export class XQueryExpression extends CamelElement {
    expressionName?: string = 'xquery';
    expression: string = '';
    resultType?: string;
    type?: string;
    configurationRef?: string;
    namespace?: PropertyDefinition[] = [];
    headerName?: string;
    propertyName?: string;
    trim?: boolean;
    id?: string = 'xquery-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<XQueryExpression>) {
        super('XQueryExpression');
        Object.assign(this, init);
    }
}

export class CustomLoadBalancerDefinition extends CamelElement {
    stepName?: string = 'customLoadBalancer';
    ref: string = '';
    id?: string = 'customLoadBalancer-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<CustomLoadBalancerDefinition>) {
        super('CustomLoadBalancerDefinition');
        Object.assign(this, init);
    }
}

export class FailoverLoadBalancerDefinition extends CamelElement {
    stepName?: string = 'failoverLoadBalancer';
    exception?: string[] = [];
    id?: string = 'failoverLoadBalancer-' + uuidv4().substring(0,4);
    maximumFailoverAttempts?: string;
    roundRobin?: string;
    sticky?: string;
    public constructor(init?: Partial<FailoverLoadBalancerDefinition>) {
        super('FailoverLoadBalancerDefinition');
        Object.assign(this, init);
    }
}

export class RandomLoadBalancerDefinition extends CamelElement {
    stepName?: string = 'randomLoadBalancer';
    id?: string = 'randomLoadBalancer-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<RandomLoadBalancerDefinition>) {
        super('RandomLoadBalancerDefinition');
        Object.assign(this, init);
    }
}

export class RoundRobinLoadBalancerDefinition extends CamelElement {
    stepName?: string = 'roundRobinLoadBalancer';
    id?: string = 'roundRobinLoadBalancer-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<RoundRobinLoadBalancerDefinition>) {
        super('RoundRobinLoadBalancerDefinition');
        Object.assign(this, init);
    }
}

export class StickyLoadBalancerDefinition extends CamelElement {
    stepName?: string = 'stickyLoadBalancer';
    correlationExpression?: ExpressionSubElementDefinition;
    id?: string = 'stickyLoadBalancer-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<StickyLoadBalancerDefinition>) {
        super('StickyLoadBalancerDefinition');
        Object.assign(this, init);
    }
}

export class TopicLoadBalancerDefinition extends CamelElement {
    stepName?: string = 'topicLoadBalancer';
    id?: string = 'topicLoadBalancer-' + uuidv4().substring(0,4);
    public constructor(init?: Partial<TopicLoadBalancerDefinition>) {
        super('TopicLoadBalancerDefinition');
        Object.assign(this, init);
    }
}

export class WeightedLoadBalancerDefinition extends CamelElement {
    stepName?: string = 'weightedLoadBalancer';
    distributionRatio: string = '';
    distributionRatioDelimiter?: string;
    id?: string = 'weightedLoadBalancer-' + uuidv4().substring(0,4);
    roundRobin?: boolean;
    public constructor(init?: Partial<WeightedLoadBalancerDefinition>) {
        super('WeightedLoadBalancerDefinition');
        Object.assign(this, init);
    }
}

export class ApiKeyDefinition extends CamelElement {
    stepName?: string = 'apiKey';
    name: string = '';
    key: string = '';
    inHeader?: boolean;
    inQuery?: boolean;
    inCookie?: boolean;
    description?: string;
    public constructor(init?: Partial<ApiKeyDefinition>) {
        super('ApiKeyDefinition');
        Object.assign(this, init);
    }
}

export class BasicAuthDefinition extends CamelElement {
    stepName?: string = 'basicAuth';
    key: string = '';
    description?: string;
    public constructor(init?: Partial<BasicAuthDefinition>) {
        super('BasicAuthDefinition');
        Object.assign(this, init);
    }
}

export class BearerTokenDefinition extends CamelElement {
    stepName?: string = 'bearerToken';
    key: string = '';
    format?: string;
    description?: string;
    public constructor(init?: Partial<BearerTokenDefinition>) {
        super('BearerTokenDefinition');
        Object.assign(this, init);
    }
}

export class DeleteDefinition extends CamelElement {
    stepName?: string = 'delete';
    path?: string;
    to?: string;
    consumes?: string;
    produces?: string;
    disabled?: boolean;
    type?: string;
    outType?: string;
    bindingMode?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCors?: boolean;
    apiDocs?: boolean;
    deprecated?: boolean;
    routeId?: string;
    id?: string = 'delete-' + uuidv4().substring(0,4);
    description?: string;
    param?: ParamDefinition[] = [];
    responseMessage?: ResponseMessageDefinition[] = [];
    security?: SecurityDefinition[] = [];
    public constructor(init?: Partial<DeleteDefinition>) {
        super('DeleteDefinition');
        Object.assign(this, init);
    }
}

export class GetDefinition extends CamelElement {
    stepName?: string = 'get';
    path?: string;
    to?: string;
    consumes?: string;
    produces?: string;
    disabled?: boolean;
    type?: string;
    outType?: string;
    bindingMode?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCors?: boolean;
    apiDocs?: boolean;
    deprecated?: boolean;
    routeId?: string;
    id?: string = 'get-' + uuidv4().substring(0,4);
    description?: string;
    param?: ParamDefinition[] = [];
    responseMessage?: ResponseMessageDefinition[] = [];
    security?: SecurityDefinition[] = [];
    public constructor(init?: Partial<GetDefinition>) {
        super('GetDefinition');
        Object.assign(this, init);
    }
}

export class HeadDefinition extends CamelElement {
    stepName?: string = 'head';
    path?: string;
    to?: string;
    consumes?: string;
    produces?: string;
    disabled?: boolean;
    type?: string;
    outType?: string;
    bindingMode?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCors?: boolean;
    apiDocs?: boolean;
    deprecated?: boolean;
    routeId?: string;
    id?: string = 'head-' + uuidv4().substring(0,4);
    description?: string;
    param?: ParamDefinition[] = [];
    responseMessage?: ResponseMessageDefinition[] = [];
    security?: SecurityDefinition[] = [];
    public constructor(init?: Partial<HeadDefinition>) {
        super('HeadDefinition');
        Object.assign(this, init);
    }
}

export class MutualTLSDefinition extends CamelElement {
    stepName?: string = 'mutualTLS';
    key: string = '';
    description?: string;
    public constructor(init?: Partial<MutualTLSDefinition>) {
        super('MutualTLSDefinition');
        Object.assign(this, init);
    }
}

export class OAuth2Definition extends CamelElement {
    stepName?: string = 'oAuth2';
    authorizationUrl?: string;
    description?: string;
    flow?: string;
    key: string = '';
    refreshUrl?: string;
    scopes?: RestPropertyDefinition[] = [];
    tokenUrl?: string;
    public constructor(init?: Partial<OAuth2Definition>) {
        super('OAuth2Definition');
        Object.assign(this, init);
    }
}

export class OpenIdConnectDefinition extends CamelElement {
    stepName?: string = 'openIdConnect';
    key: string = '';
    url: string = '';
    description?: string;
    public constructor(init?: Partial<OpenIdConnectDefinition>) {
        super('OpenIdConnectDefinition');
        Object.assign(this, init);
    }
}

export class ParamDefinition extends CamelElement {
    stepName?: string = 'param';
    name: string = '';
    type: string = '';
    defaultValue?: string;
    required?: boolean;
    collectionFormat?: string;
    arrayType?: string;
    dataType?: string;
    dataFormat?: string;
    allowableValues?: ValueDefinition[] = [];
    examples?: RestPropertyDefinition[] = [];
    description?: string;
    public constructor(init?: Partial<ParamDefinition>) {
        super('ParamDefinition');
        Object.assign(this, init);
    }
}

export class PatchDefinition extends CamelElement {
    stepName?: string = 'patch';
    path?: string;
    to?: string;
    consumes?: string;
    produces?: string;
    disabled?: boolean;
    type?: string;
    outType?: string;
    bindingMode?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCors?: boolean;
    apiDocs?: boolean;
    deprecated?: boolean;
    routeId?: string;
    id?: string = 'patch-' + uuidv4().substring(0,4);
    description?: string;
    param?: ParamDefinition[] = [];
    responseMessage?: ResponseMessageDefinition[] = [];
    security?: SecurityDefinition[] = [];
    public constructor(init?: Partial<PatchDefinition>) {
        super('PatchDefinition');
        Object.assign(this, init);
    }
}

export class PostDefinition extends CamelElement {
    stepName?: string = 'post';
    path?: string;
    to?: string;
    consumes?: string;
    produces?: string;
    disabled?: boolean;
    type?: string;
    outType?: string;
    bindingMode?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCors?: boolean;
    apiDocs?: boolean;
    deprecated?: boolean;
    routeId?: string;
    id?: string = 'post-' + uuidv4().substring(0,4);
    description?: string;
    param?: ParamDefinition[] = [];
    responseMessage?: ResponseMessageDefinition[] = [];
    security?: SecurityDefinition[] = [];
    public constructor(init?: Partial<PostDefinition>) {
        super('PostDefinition');
        Object.assign(this, init);
    }
}

export class PutDefinition extends CamelElement {
    stepName?: string = 'put';
    path?: string;
    to?: string;
    consumes?: string;
    produces?: string;
    disabled?: boolean;
    type?: string;
    outType?: string;
    bindingMode?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCors?: boolean;
    apiDocs?: boolean;
    deprecated?: boolean;
    routeId?: string;
    id?: string = 'put-' + uuidv4().substring(0,4);
    description?: string;
    param?: ParamDefinition[] = [];
    responseMessage?: ResponseMessageDefinition[] = [];
    security?: SecurityDefinition[] = [];
    public constructor(init?: Partial<PutDefinition>) {
        super('PutDefinition');
        Object.assign(this, init);
    }
}

export class ResponseHeaderDefinition extends CamelElement {
    stepName?: string = 'responseHeader';
    name: string = '';
    collectionFormat?: string;
    arrayType?: string;
    dataType?: string;
    dataFormat?: string;
    allowableValues?: ValueDefinition[] = [];
    example?: string;
    description?: string;
    public constructor(init?: Partial<ResponseHeaderDefinition>) {
        super('ResponseHeaderDefinition');
        Object.assign(this, init);
    }
}

export class ResponseMessageDefinition extends CamelElement {
    stepName?: string = 'responseMessage';
    code?: string;
    message: string = '';
    responseModel?: string;
    header?: ResponseHeaderDefinition[] = [];
    examples?: RestPropertyDefinition[] = [];
    public constructor(init?: Partial<ResponseMessageDefinition>) {
        super('ResponseMessageDefinition');
        Object.assign(this, init);
    }
}

export class RestBindingDefinition extends CamelElement {
    stepName?: string = 'restBinding';
    consumes?: string;
    produces?: string;
    bindingMode?: string;
    type?: string;
    outType?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCors?: boolean;
    component?: string;
    id?: string = 'restBinding-' + uuidv4().substring(0,4);
    description?: string;
    public constructor(init?: Partial<RestBindingDefinition>) {
        super('RestBindingDefinition');
        Object.assign(this, init);
    }
}

export class RestConfigurationDefinition extends CamelElement {
    stepName?: string = 'restConfiguration';
    component?: string;
    apiComponent?: string;
    producerComponent?: string;
    scheme?: string;
    host?: string;
    port?: string;
    apiHost?: string;
    useXForwardHeaders?: boolean;
    producerApiDoc?: string;
    contextPath?: string;
    apiContextPath?: string;
    apiContextRouteId?: string;
    apiVendorExtension?: boolean;
    hostNameResolver?: string;
    bindingMode?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCors?: boolean;
    inlineRoutes?: boolean;
    jsonDataFormat?: string;
    xmlDataFormat?: string;
    componentProperty?: RestPropertyDefinition[] = [];
    endpointProperty?: RestPropertyDefinition[] = [];
    consumerProperty?: RestPropertyDefinition[] = [];
    dataFormatProperty?: RestPropertyDefinition[] = [];
    apiProperty?: RestPropertyDefinition[] = [];
    corsHeaders?: RestPropertyDefinition[] = [];
    public constructor(init?: Partial<RestConfigurationDefinition>) {
        super('RestConfigurationDefinition');
        Object.assign(this, init);
    }
}

export class RestDefinition extends CamelElement {
    stepName?: string = 'rest';
    path?: string;
    consumes?: string;
    produces?: string;
    disabled?: boolean;
    bindingMode?: string;
    skipBindingOnErrorCode?: boolean;
    clientRequestValidation?: boolean;
    enableCors?: boolean;
    apiDocs?: boolean;
    tag?: string;
    securityDefinitions?: RestSecuritiesDefinition;
    securityRequirements?: SecurityDefinition[] = [];
    id?: string = 'rest-' + uuidv4().substring(0,4);
    description?: string;
    delete?: DeleteDefinition[] = [];
    get?: GetDefinition[] = [];
    head?: HeadDefinition[] = [];
    patch?: PatchDefinition[] = [];
    post?: PostDefinition[] = [];
    put?: PutDefinition[] = [];
    public constructor(init?: Partial<RestDefinition>) {
        super('RestDefinition');
        Object.assign(this, init);
    }
}

export class RestPropertyDefinition extends CamelElement {
    stepName?: string = 'restProperty';
    key: string = '';
    value: string = '';
    public constructor(init?: Partial<RestPropertyDefinition>) {
        super('RestPropertyDefinition');
        Object.assign(this, init);
    }
}

export class RestSecuritiesDefinition extends CamelElement {
    stepName?: string = 'restSecurities';
    apiKey?: ApiKeyDefinition;
    basicAuth?: BasicAuthDefinition;
    bearer?: BearerTokenDefinition;
    mutualTls?: MutualTLSDefinition;
    oauth2?: OAuth2Definition;
    openIdConnect?: OpenIdConnectDefinition;
    public constructor(init?: Partial<RestSecuritiesDefinition>) {
        super('RestSecuritiesDefinition');
        Object.assign(this, init);
    }
}

export class RestsDefinition extends CamelElement {
    stepName?: string = 'rests';
    id?: string = 'rests-' + uuidv4().substring(0,4);
    description?: string;
    rest?: RestDefinition[] = [];
    public constructor(init?: Partial<RestsDefinition>) {
        super('RestsDefinition');
        Object.assign(this, init);
    }
}

export class SecurityDefinition extends CamelElement {
    stepName?: string = 'security';
    key: string = '';
    scopes?: string;
    public constructor(init?: Partial<SecurityDefinition>) {
        super('SecurityDefinition');
        Object.assign(this, init);
    }
}

export class CustomTransformerDefinition extends CamelElement {
    stepName?: string = 'customTransformer';
    className?: string;
    fromType?: string;
    ref?: string;
    scheme?: string;
    toType?: string;
    public constructor(init?: Partial<CustomTransformerDefinition>) {
        super('CustomTransformerDefinition');
        Object.assign(this, init);
    }
}

export class DataFormatTransformerDefinition extends CamelElement {
    stepName?: string = 'dataFormatTransformer';
    any23?: Any23DataFormat | string;
    asn1?: ASN1DataFormat | string;
    avro?: AvroDataFormat | string;
    barcode?: BarcodeDataFormat;
    base64?: Base64DataFormat;
    bindy?: BindyDataFormat;
    cbor?: CBORDataFormat;
    crypto?: CryptoDataFormat;
    csv?: CsvDataFormat | string;
    custom?: CustomDataFormat | string;
    fhirJson?: FhirJsonDataFormat;
    fhirXml?: FhirXmlDataFormat;
    flatpack?: FlatpackDataFormat;
    fromType?: string;
    grok?: GrokDataFormat;
    gzipDeflater?: GzipDeflaterDataFormat;
    hl7?: HL7DataFormat;
    ical?: IcalDataFormat;
    jacksonXml?: JacksonXMLDataFormat;
    jaxb?: JaxbDataFormat;
    json?: JsonDataFormat;
    jsonApi?: JsonApiDataFormat;
    lzf?: LZFDataFormat;
    mimeMultipart?: MimeMultipartDataFormat;
    pgp?: PGPDataFormat;
    protobuf?: ProtobufDataFormat | string;
    rss?: RssDataFormat;
    scheme?: string;
    soap?: SoapDataFormat | string;
    swiftMt?: SwiftMtDataFormat | string;
    swiftMx?: SwiftMxDataFormat;
    syslog?: SyslogDataFormat;
    tarFile?: TarFileDataFormat;
    thrift?: ThriftDataFormat | string;
    tidyMarkup?: TidyMarkupDataFormat;
    toType?: string;
    univocityCsv?: UniVocityCsvDataFormat;
    univocityFixed?: UniVocityFixedDataFormat;
    univocityTsv?: UniVocityTsvDataFormat;
    xmlSecurity?: XMLSecurityDataFormat;
    xstream?: XStreamDataFormat | string;
    yaml?: YAMLDataFormat;
    zipDeflater?: ZipDeflaterDataFormat;
    zipFile?: ZipFileDataFormat;
    public constructor(init?: Partial<DataFormatTransformerDefinition>) {
        super('DataFormatTransformerDefinition');
        Object.assign(this, init);
    }
}

export class EndpointTransformerDefinition extends CamelElement {
    stepName?: string = 'endpointTransformer';
    fromType?: string;
    ref?: string;
    scheme?: string;
    toType?: string;
    uri?: string;
    public constructor(init?: Partial<EndpointTransformerDefinition>) {
        super('EndpointTransformerDefinition');
        Object.assign(this, init);
    }
}

export class TransformersDefinition extends CamelElement {
    stepName?: string = 'transformers';
    customTransformer?: CustomTransformerDefinition;
    dataFormatTransformer?: DataFormatTransformerDefinition;
    endpointTransformer?: EndpointTransformerDefinition;
    public constructor(init?: Partial<TransformersDefinition>) {
        super('TransformersDefinition');
        Object.assign(this, init);
    }
}

export class CustomValidatorDefinition extends CamelElement {
    stepName?: string = 'customValidator';
    className?: string;
    ref?: string;
    type?: string;
    public constructor(init?: Partial<CustomValidatorDefinition>) {
        super('CustomValidatorDefinition');
        Object.assign(this, init);
    }
}

export class EndpointValidatorDefinition extends CamelElement {
    stepName?: string = 'endpointValidator';
    ref?: string;
    type?: string;
    uri?: string;
    public constructor(init?: Partial<EndpointValidatorDefinition>) {
        super('EndpointValidatorDefinition');
        Object.assign(this, init);
    }
}

export class PredicateValidatorDefinition extends CamelElement {
    stepName?: string = 'predicateValidator';
    expression?: ExpressionDefinition;
    type?: string;
    public constructor(init?: Partial<PredicateValidatorDefinition>) {
        super('PredicateValidatorDefinition');
        Object.assign(this, init);
    }
}

export class ValidatorsDefinition extends CamelElement {
    stepName?: string = 'validators';
    customValidator?: CustomValidatorDefinition;
    endpointValidator?: EndpointValidatorDefinition;
    predicateValidator?: PredicateValidatorDefinition;
    public constructor(init?: Partial<ValidatorsDefinition>) {
        super('ValidatorsDefinition');
        Object.assign(this, init);
    }
}

