/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.karavan.api;

import io.quarkus.scheduler.Scheduled;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.multi.multicast.MultiConnectAfter;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.eventbus.EventBus;
import io.vertx.mutiny.core.eventbus.Message;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.RestStreamElementType;
import org.reactivestreams.Publisher;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseEventSink;
import java.util.Date;
import java.util.Objects;

@Path("/api/sse")
public class SseResource {

    private static final Logger LOGGER = Logger.getLogger(SseResource.class.getName());

    @Inject
    @Channel("log")
    Publisher<JsonObject> publisher;

    @Inject
    @Channel("log")
    @OnOverflow(value = OnOverflow.Strategy.BUFFER, bufferSize = 1000)
    Emitter<JsonObject> emitter;

//    @Scheduled(every="1s")
//    void increment() {
//        emitter.send(JsonObject.of("name", "marat1", "marat",  new Date()));
//        emitter.send(JsonObject.of("name", "marat2", "marat",  new Date()));
//    }

    @GET
    @Produces(MediaType.SERVER_SENT_EVENTS)
    @RestStreamElementType("text/plain")
    @Path("/{name}")
    public Publisher<JsonObject> stream(@PathParam("name") String name,
                                        @Context SseEventSink eventSink,
                                        @Context Sse sse) {
        System.out.println("----------");
        System.out.println(name);
        return Multi.createFrom().publisher(publisher).filter(e -> Objects.equals(e.getString("name"), name));
    }
}