/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';

export function KaravanIcon(className?: string) {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
            id="svg50"
            width="256"
            height="256"
            preserveAspectRatio="xMidYMid"
            version="1.1"
            viewBox="0 0 256 256"
            className={className ? className : "logo"}
        >
            <defs id="defs31">
                <linearGradient id="linearGradient1351">
                    <stop
                        id="stop1347"
                        offset="0"
                        stopColor="#dcffff"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop1349"
                        offset="1"
                        stopColor="#96d2e6"
                        stopOpacity="1"
                    ></stop>
                </linearGradient>
                <circle id="path-1" cx="128" cy="128" r="128"></circle>
                <linearGradient
                    id="linearGradient-3"
                    x1="-26.051"
                    x2="254.316"
                    y1="271.331"
                    y2="0.048"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop
                        id="stop10"
                        offset="0%"
                        stopColor="#4790bb"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop12"
                        offset="10.996%"
                        stopColor="#64b7db"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop14"
                        offset="94.502%"
                        stopColor="#326ea0"
                        stopOpacity="1"
                    ></stop>
                </linearGradient>
                <linearGradient
                    id="linearGradient-4"
                    x1="-32.163"
                    x2="259.338"
                    y1="277.029"
                    y2="-5.028"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop id="stop17" offset="0%" stopColor="#F69923"></stop>
                    <stop id="stop19" offset="8.048%" stopColor="#F79A23"></stop>
                    <stop id="stop21" offset="41.874%" stopColor="#E97826"></stop>
                </linearGradient>
                <linearGradient
                    id="linearGradient-5"
                    x1="217.945"
                    x2="99.459"
                    y1="67.505"
                    y2="247.005"
                    gradientTransform="scale(.96442 1.0369)"
                    gradientUnits="userSpaceOnUse"
                    xlinkHref="#linearGradient-4"
                >
                    <stop
                        id="stop24"
                        offset="0%"
                        stopColor="#92d6d5"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop26"
                        offset="41.191%"
                        stopColor="#79b7cc"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop28"
                        offset="73.271%"
                        stopColor="#5891c5"
                        stopOpacity="1"
                    ></stop>
                </linearGradient>
                <mask id="mask-2" fill="#fff">
                    <use id="use33" xlinkHref="#path-1"></use>
                </mask>
                <mask id="mask-2-7" fill="#fff">
                    <use id="use137" xlinkHref="#path-1"></use>
                </mask>
                <linearGradient
                    id="linearGradient1345"
                    x1="233.122"
                    x2="2.24"
                    y1="56.015"
                    y2="242.78"
                    gradientUnits="userSpaceOnUse"
                    xlinkHref="#linearGradient1351"
                ></linearGradient>
            </defs>
            <circle
                id="circle38"
                cx="127.994"
                cy="127.994"
                r="123.111"
                fill="url(#linearGradient-3)"
                fillRule="nonzero"
                mask="url(#mask-2)"
            ></circle>
            <g id="g2266">
                <path
                    id="path42"
                    fill="url(#linearGradient-5)"
                    fillOpacity="1"
                    fillRule="nonzero"
                    d="M98.044 75.517c-1.751-.002-3.524.01-5.292.061-2.056.06-4.817.713-8 1.785 53.775 40.834 73.108 114.497 39.875 178.514 1.129.03 2.249.123 3.385.123 60.736 0 111.492-42.323 124.609-99.071-38.542-45.178-90.813-81.314-154.578-81.412z"
                    mask="url(#mask-2)"
                    opacity="0.75"
                ></path>
            </g>
            <path
                id="path44"
                fill="#1e4b7b"
                fillOpacity="1"
                fillRule="nonzero"
                d="M84.752 77.368C66.895 83.378 32.83 104.546.079 132.81c2.487 67.334 57.028 121.313 124.548 123.07 33.233-64.016 13.901-137.68-39.875-178.513z"
                mask="url(#mask-2)"
                opacity="0.75"
            ></path>
            <path
                id="path150"
                fill="url(#linearGradient1345)"
                fillOpacity="1"
                fillRule="nonzero"
                d="M128.747 54.005c-10.985 5.495 0 27.466 0 27.466C95.774 108.954 102.78 155.9 64.312 155.9c-20.97 0-42.242-24.077-64.233-38.828-.283 3.479-.785 6.972-.785 10.524 0 48.095 26.263 89.924 65.42 111.897 10.952-1.38 22.838-4.114 31.05-9.592 43.146-28.765 53.857-83.491 71.487-109.925 10.979-16.492 62.434-15.061 65.906-22.01 5.502-10.991-10.99-27.467-16.491-27.467h-43.958c-3.071 0-7.897-5.456-10.974-5.456h-16.492s-7.307-11.085-13.794-11.526c-.93-.066-1.83.053-2.7.488z"
                mask="url(#mask-2-7)"
                transform="translate(-.769 -.133)"
            ></path>
            <path
                id="path40"
                fill="#2d4150"
                fillOpacity="1"
                fillRule="nonzero"
                d="M128 256C57.308 256 0 198.692 0 128 0 57.308 57.308 0 128 0c70.692 0 128 57.308 128 128 0 70.692-57.308 128-128 128zm0-9.768c65.298 0 118.232-52.934 118.232-118.232S193.298 9.768 128 9.768 9.768 62.702 9.768 128 62.702 246.232 128 246.232z"
                mask="url(#mask-2)"
                transform="translate(-.59) scale(1.00078)"
            ></path>
        </svg>
    );
}

export function getDesignerIcon(icon: string) {
    if (icon === 'routes') return (
        <svg className="top-icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <defs>
                <style>{".cls-1{fill:none;}"}</style>
            </defs>
            <path d="M29,10H24v2h5v6H22v2h3v2.142a4,4,0,1,0,2,0V20h2a2.0027,2.0027,0,0,0,2-2V12A2.0023,2.0023,0,0,0,29,10ZM28,26a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,28,26Z"/>
            <path d="M19,6H14V8h5v6H12v2h3v6.142a4,4,0,1,0,2,0V16h2a2.0023,2.0023,0,0,0,2-2V8A2.0023,2.0023,0,0,0,19,6ZM18,26a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,18,26Z"/>
            <path
                d="M9,2H3A2.002,2.002,0,0,0,1,4v6a2.002,2.002,0,0,0,2,2H5V22.142a4,4,0,1,0,2,0V12H9a2.002,2.002,0,0,0,2-2V4A2.002,2.002,0,0,0,9,2ZM8,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,26ZM3,10V4H9l.0015,6Z"/>
            <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" className="cls-1" width="32" height="32"/>
        </svg>)
    if (icon === 'rest') return (
        <svg className="top-icon" viewBox="0 0 32 32">
            <g className="layer">
                <title>Layer 1</title>
                <path
                    d="m23.50007,22l-0.5,0l0,-2l0.5,0a4.4975,4.4975 0 0 0 0.3564,-8.981l-0.8154,-0.0639l-0.0986,-0.812a6.9938,6.9938 0 0 0 -13.8838,0l-0.0991,0.812l-0.8155,0.0639a4.4975,4.4975 0 0 0 0.356,8.981l0.5,0l0,2l-0.5,0a6.4973,6.4973 0 0 1 -1.3,-12.8638a8.9943,8.9943 0 0 1 17.6006,0a6.4974,6.4974 0 0 1 -1.3006,12.8638z"
                    id="svg_1"/>
                <path
                    d="m22.9724,22.26637l0,-2l-2.1011,0a4.9678,4.9678 0 0 0 -0.7319,-1.7529l1.49,-1.49l-1.414,-1.414l-1.49,1.49a4.9678,4.9678 0 0 0 -1.753,-0.732l0,-2.1011l-2,0l0,2.1011a4.9678,4.9678 0 0 0 -1.7529,0.7319l-1.49,-1.49l-1.414,1.414l1.49,1.49a4.9678,4.9678 0 0 0 -0.732,1.753l-2.1011,0l0,2l2.1011,0a4.9678,4.9678 0 0 0 0.7319,1.7529l-1.49,1.49l1.414,1.414l1.49,-1.49a4.9678,4.9678 0 0 0 1.753,0.732l0,2.1011l2,0l0,-2.1011a4.9678,4.9678 0 0 0 1.7529,-0.7319l1.49,1.49l1.414,-1.414l-1.49,-1.49a4.9678,4.9678 0 0 0 0.732,-1.753l2.1011,0zm-7,2a3,3 0 1 1 3,-3a3.0033,3.0033 0 0 1 -3,3z"
                    id="svg_2" transform="rotate(25 15.9724 21.2664)" xmlns="http://www.w3.org/2000/svg"/>
            </g>
        </svg>
    )
    if (icon === 'beans') return (
        <svg className="top-icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <defs>
                <style>{".cls-1 {fill: none;}"}</style>
            </defs>
            <title>data--1</title>
            <rect x="15" y="6" width="13" height="2"/>
            <rect x="15" y="24" width="13" height="2"/>
            <rect x="4" y="15" width="13" height="2"/>
            <path d="M7,11a4,4,0,1,1,4-4A4,4,0,0,1,7,11ZM7,5A2,2,0,1,0,9,7,2,2,0,0,0,7,5Z" transform="translate(0 0)"/>
            <path d="M7,29a4,4,0,1,1,4-4A4,4,0,0,1,7,29Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,7,23Z" transform="translate(0 0)"/>
            <path d="M25,20a4,4,0,1,1,4-4A4,4,0,0,1,25,20Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,25,14Z" transform="translate(0 0)"/>
            <g id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;">
                <rect className="cls-1" width="32" height="32"/>
            </g>
        </svg>
    )
    if (icon === 'dependencies') return (
        <svg className="top-icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <defs>
                <style>{".cls-1 {fill: none;}"}</style>
            </defs>
            <title>application</title>
            <path d="M16,18H6a2,2,0,0,1-2-2V6A2,2,0,0,1,6,4H16a2,2,0,0,1,2,2V16A2,2,0,0,1,16,18ZM6,6V16H16V6Z" transform="translate(0 0)"/>
            <path d="M26,12v4H22V12h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V12a2,2,0,0,0-2-2Z" transform="translate(0 0)"/>
            <path d="M26,22v4H22V22h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z" transform="translate(0 0)"/>
            <path d="M16,22v4H12V22h4m0-2H12a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z" transform="translate(0 0)"/>
            <g id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;">
                <rect className="cls-1" width="32" height="32"/>
            </g>
        </svg>
    )
    if (icon === 'error') return (
        <svg className="top-icon" width="36px" height="36px" viewBox="0 0 36 36" version="1.1" preserveAspectRatio="xMidYMid meet">
            <circle className="clr-i-outline clr-i-outline-path-1" cx="18" cy="26.06" r="1.33"/>
            <path className="clr-i-outline clr-i-outline-path-2" d="M18,22.61a1,1,0,0,1-1-1v-12a1,1,0,1,1,2,0v12A1,1,0,0,1,18,22.61Z"/>
            <path className="clr-i-outline clr-i-outline-path-3" d="M18,34A16,16,0,1,1,34,18,16,16,0,0,1,18,34ZM18,4A14,14,0,1,0,32,18,14,14,0,0,0,18,4Z"/>
            <rect x="0" y="0" width="36" height="36" fillOpacity="0"/>
        </svg>)
    if (icon === 'exception') return (
        <svg className="top-icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <defs>
                <style>{".cls-1{fill:none;}"}</style>
            </defs>
            <title>misuse--alt</title>
            <polygon points="21.41 23 16 17.591 10.59 23 9 21.41 14.409 16 9 10.591 10.591 9 16 14.409 21.409 9 23 10.591 17.591 16 23 21.41 21.41 23"/>
            <path d="M16,4A12,12,0,1,1,4,16,12.0136,12.0136,0,0,1,16,4m0-2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Z" transform="translate(0)"/>
            <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" className="cls-1" width="32" height="32"/>
        </svg>)
    if (icon === 'routeConfiguration') return (
        <svg className="top-icon" width="32" height="32" viewBox="0 0 32 32">
            <defs>
                <style>{".cls-1{fill:none;}"}</style>
            </defs>
            <path d="M28.83 21.17L25 17.37l.67-.67a1 1 0 000-1.41l-6-6a1 1 0 00-1.41 0l-.79.79-6.76-6.79a1 1 0 00-1.41 0l-4 4-.12.15-4 6a1 1 0 00.12 1.26l3 3a1 1 0 001.42 0L10 13.41l2.09 2.09-4.8 4.79a1 1 0 000 1.41l2 2a1 1 0 00.71.3 1 1 0 00.52-.15l4.33-2.6 2.44 2.45a1 1 0 001.41 0l.67-.7 3.79 3.83a4 4 0 005.66-5.66zM10 10.58l-5 5-1.71-1.71 3.49-5.24L10 5.41l6.09 6.09-2.59 2.58zm8 11l-2.84-2.84-5 3-.74-.74L19 11.41 23.59 16zm9.42 3.83a2 2 0 01-2.83 0l-3.8-3.79 2.83-2.83 3.8 3.79a2 2 0 010 2.83z"></path>
            <path
                d="M0 0H32V32H0z"
                className="cls-1"
                data-name="&lt;Transparent Rectangle&gt;"
            ></path>
        </svg>)
    if (icon === 'yaml') return (
        <svg className="top-icon" x="0px" y="0px" width="32px" height="32px"
             viewBox="0 0 32 32">
            <style type="text/css">{".st0{fill:none;}"}</style>
            <title>document</title>
            <path
                d="M25.7,9.3l-7-7C18.5,2.1,18.3,2,18,2H8C6.9,2,6,2.9,6,4v24c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V10C26,9.7,25.9,9.5,25.7,9.3  z M18,4.4l5.6,5.6H18V4.4z M24,28H8V4h8v6c0,1.1,0.9,2,2,2h6V28z"/>
            <rect x="10" y="22" width="12" height="2"/>
            <rect x="10" y="16" width="12" height="2"/>
            <rect className="st0" width="32" height="32"/>
        </svg>)
    if (icon === 'code') return (
        <svg className="top-icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <defs>
                <style>{".cls-1{fill:none;}"}</style>
            </defs>
            <title>code</title>
            <polygon points="31 16 24 23 22.59 21.59 28.17 16 22.59 10.41 24 9 31 16"/>
            <polygon points="1 16 8 9 9.41 10.41 3.83 16 9.41 21.59 8 23 1 16"/>
            <rect x="5.91" y="15" width="20.17" height="2" transform="translate(-3.6 27.31) rotate(-75)"/>
            <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" className="cls-1" width="32" height="32" transform="translate(0 32) rotate(-90)"/>
        </svg>)
}


export class BeanIcon extends React.Component<any> {

    render() {
        return (
            <svg className="icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
                <defs>
                    <style>{".cls-1 {fill: none;}"}</style>
                </defs>
                <title>data--1</title>
                <rect x="15" y="6" width="13" height="2"/>
                <rect x="15" y="24" width="13" height="2"/>
                <rect x="4" y="15" width="13" height="2"/>
                <path d="M7,11a4,4,0,1,1,4-4A4,4,0,0,1,7,11ZM7,5A2,2,0,1,0,9,7,2,2,0,0,0,7,5Z" transform="translate(0 0)"/>
                <path d="M7,29a4,4,0,1,1,4-4A4,4,0,0,1,7,29Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,7,23Z" transform="translate(0 0)"/>
                <path d="M25,20a4,4,0,1,1,4-4A4,4,0,0,1,25,20Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,25,14Z" transform="translate(0 0)"/>
                <g id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;">
                    <rect className="cls-1" width="32" height="32"/>
                </g>
            </svg>
        )
    }
}

export class DependencyIcon extends React.Component<any> {

    render() {
        return (
            <svg className="icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
                <defs>
                    <style>{".cls-1 {fill: none;}"}</style>
                </defs>
                <title>application</title>
                <path d="M16,18H6a2,2,0,0,1-2-2V6A2,2,0,0,1,6,4H16a2,2,0,0,1,2,2V16A2,2,0,0,1,16,18ZM6,6V16H16V6Z" transform="translate(0 0)"/>
                <path d="M26,12v4H22V12h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V12a2,2,0,0,0-2-2Z" transform="translate(0 0)"/>
                <path d="M26,22v4H22V22h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z" transform="translate(0 0)"/>
                <path d="M16,22v4H12V22h4m0-2H12a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z" transform="translate(0 0)"/>
                <g id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;">
                    <rect className="cls-1" width="32" height="32"/>
                </g>
            </svg>
        )
    }
}

export class RestIcon extends React.Component<any> {

    render() {
        return (
            <svg className="icon" viewBox="0 0 32 32">
                <g className="layer">
                    <title>Layer 1</title>
                    <path
                        d="m23.50007,22l-0.5,0l0,-2l0.5,0a4.4975,4.4975 0 0 0 0.3564,-8.981l-0.8154,-0.0639l-0.0986,-0.812a6.9938,6.9938 0 0 0 -13.8838,0l-0.0991,0.812l-0.8155,0.0639a4.4975,4.4975 0 0 0 0.356,8.981l0.5,0l0,2l-0.5,0a6.4973,6.4973 0 0 1 -1.3,-12.8638a8.9943,8.9943 0 0 1 17.6006,0a6.4974,6.4974 0 0 1 -1.3006,12.8638z"
                        id="svg_1"/>
                    <path
                        d="m22.9724,22.26637l0,-2l-2.1011,0a4.9678,4.9678 0 0 0 -0.7319,-1.7529l1.49,-1.49l-1.414,-1.414l-1.49,1.49a4.9678,4.9678 0 0 0 -1.753,-0.732l0,-2.1011l-2,0l0,2.1011a4.9678,4.9678 0 0 0 -1.7529,0.7319l-1.49,-1.49l-1.414,1.414l1.49,1.49a4.9678,4.9678 0 0 0 -0.732,1.753l-2.1011,0l0,2l2.1011,0a4.9678,4.9678 0 0 0 0.7319,1.7529l-1.49,1.49l1.414,1.414l1.49,-1.49a4.9678,4.9678 0 0 0 1.753,0.732l0,2.1011l2,0l0,-2.1011a4.9678,4.9678 0 0 0 1.7529,-0.7319l1.49,1.49l1.414,-1.414l-1.49,-1.49a4.9678,4.9678 0 0 0 0.732,-1.753l2.1011,0zm-7,2a3,3 0 1 1 3,-3a3.0033,3.0033 0 0 1 -3,3z"
                        id="svg_2" transform="rotate(25 15.9724 21.2664)" xmlns="http://www.w3.org/2000/svg"/>
                </g>
            </svg>
        )
    }
}

export class ConceptIcon extends React.Component<any> {

    render() {
        return (
            <svg className="icon" width="32px" height="32px" viewBox="0 0 32 32">
                <defs>
                    <style>{".cls-1 {fill: none;}"}</style>
                </defs>
                <title>concept</title>
                <path
                    d="M20.8851,19.4711a5.9609,5.9609,0,0,0,0-6.9422L23,10.4141l1.293,1.2929a.9995.9995,0,0,0,1.414,0l4-4a.9994.9994,0,0,0,0-1.414l-4-4a.9994.9994,0,0,0-1.414,0l-4,4a.9994.9994,0,0,0,0,1.414L21.5859,9l-2.1148,2.1149a5.9609,5.9609,0,0,0-6.9422,0L10,8.5859V2H2v8H8.5859l2.529,2.5289a5.9609,5.9609,0,0,0,0,6.9422L9,21.5859,7.707,20.293a.9994.9994,0,0,0-1.414,0l-4,4a.9994.9994,0,0,0,0,1.414l4,4a.9995.9995,0,0,0,1.414,0l4-4a.9994.9994,0,0,0,0-1.414L10.4141,23l2.1148-2.1149a5.9609,5.9609,0,0,0,6.9422,0L22,23.4141V30h8V22H23.4141ZM25,4.4141,27.5859,7,25,9.5859,22.4141,7ZM7,27.5859,4.4141,25,7,22.4141,9.5859,25ZM8,8H4V4H8Zm4,8a4,4,0,1,1,4,4A4.0045,4.0045,0,0,1,12,16Zm12,8h4v4H24Z"/>
                <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" className="cls-1" width="32" height="32"/>
            </svg>
        )
    }
}

export function AggregateIcon() {
    return (
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 700 700" className="icon">
            <path d="M496.2 417.71l-130.22 101.1c-.19.14-.39.29-.59.42a28.39 28.39 0 01-30.77 0c-.21-.13-.4-.28-.59-.42L203.8 417.71h292.4z"></path>
            <path d="M516.1 426.23v202.1c0 4.12-3.34 7.46-7.45 7.46H191.36c-4.11 0-7.46-3.34-7.46-7.46V426.22l138.52 107.53c.68.53 1.31.98 1.94 1.38 7.79 5.04 16.72 7.55 25.66 7.55s17.86-2.52 25.66-7.55c.62-.4 1.25-.85 1.94-1.38l138.5-107.52zM247.14 358.45l-12.91 30.22-.03.06v.03c-.11.21-.21.43-.32.64s-.23.42-.36.61c-.08.14-.17.27-.27.4-.08.11-.16.21-.24.31-.1.13-.21.25-.31.36-.08.09-.16.18-.24.25-.05.06-.1.11-.16.15l-.27.25c-.17.15-.33.29-.51.42-.15.13-.3.23-.47.33-.19.13-.39.25-.59.36s-.42.22-.63.31c-.22.1-.44.18-.66.26-.25.09-.49.17-.75.23-.2.05-.4.09-.61.13-.72.12-1.46.15-2.2.08-.19-.01-.36-.04-.55-.07-.04 0-.08-.02-.11-.02l-32.43-5.52a8.494 8.494 0 01-6.95-9.81 8.5 8.5 0 019.81-6.95l15.17 2.58-34.61-63.46a8.494 8.494 0 013.39-11.53c4.12-2.25 9.28-.73 11.53 3.39l34.61 63.46 6.04-14.15a8.508 8.508 0 0111.16-4.48c4.31 1.85 6.32 6.84 4.48 11.16zM452.86 358.45l12.91 30.22.03.06v.03c.11.21.21.43.32.64s.23.42.36.61c.08.14.17.27.27.4.08.11.16.21.24.31.1.13.21.25.31.36.08.09.16.18.24.25.05.06.1.11.16.15l.27.25c.17.15.33.29.51.42.15.13.3.23.47.33.19.13.39.25.59.36s.42.22.63.31c.22.1.44.18.66.26.25.09.49.17.75.23.2.05.4.09.61.13.72.12 1.46.15 2.2.08.19-.01.36-.04.55-.07.04 0 .08-.02.11-.02l32.43-5.52a8.494 8.494 0 006.95-9.81 8.5 8.5 0 00-9.81-6.95l-15.17 2.58 34.61-63.46c2.25-4.13.73-9.28-3.39-11.53s-9.28-.73-11.53 3.39l-34.61 63.46-6.04-14.15a8.508 8.508 0 00-11.16-4.48c-4.31 1.85-6.32 6.84-4.48 11.16zM260.53 145.6l-76.07 57.24c-5.52 4.16-13.24 4.16-18.76 0L89.62 145.6h170.91z"></path>
            <path d="M277.46 154.15V264.2c0 5.52-4.48 10-10 10H82.69c-5.52 0-10-4.48-10-10V154.14l82.79 62.29c5.77 4.34 12.69 6.51 19.6 6.51s13.83-2.17 19.6-6.51l82.78-62.28z"></path>
            <g>
                <path d="M610.57 145.6l-76.07 57.24c-5.52 4.16-13.24 4.16-18.76 0l-76.08-57.24h170.91z"></path>
                <path d="M627.5 154.15V264.2c0 5.52-4.48 10-10 10H432.73c-5.52 0-10-4.48-10-10V154.14l82.79 62.29c5.77 4.34 12.69 6.51 19.6 6.51s13.83-2.17 19.6-6.51l82.78-62.28z"></path>
            </g>
        </svg>
    );
}

export function ChoiceIcon() {
    return (
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 700 700" className="icon">
            <path d="M407.33 113.97V609.2c0 2.75-1.9 5-4.22 5H291.55c-2.33 0-4.22-2.25-4.22-5V113.97c0-2.76 1.89-5 4.22-5h111.56c2.32 0 4.22 2.24 4.22 5zM27.1 437.55l60.87-57.64c.95-.9 2.32-1.41 3.76-1.41H258.2c2.76 0 5 1.87 5 4.17v111.65c0 2.3-2.24 4.17-5 4.17H91.54c-1.38 0-2.7-.48-3.65-1.32L27.2 443.15c-1.77-1.58-1.81-3.99-.1-5.61zM667.57 285.62l-60.87 57.64c-.95.9-2.32 1.41-3.76 1.41H436.47c-2.76 0-5-1.87-5-4.17V228.85c0-2.3 2.24-4.17 5-4.17h166.66c1.38 0 2.7.48 3.65 1.32l60.69 54.02c1.77 1.58 1.81 3.99.1 5.61z"></path>
        </svg>
    );
}


export function SplitIcon() {
    return (
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 700 700" className="icon">
            <path d="M496.2 83.65l-130.22 101.1c-.19.14-.39.29-.59.42a28.39 28.39 0 01-30.77 0c-.21-.13-.4-.28-.59-.42L203.8 83.65h292.4z"></path>
            <path d="M516.1 92.17v202.1c0 4.12-3.34 7.46-7.45 7.46H191.36c-4.11 0-7.46-3.34-7.46-7.46V92.16l138.52 107.53c.68.53 1.31.98 1.94 1.38 7.79 5.04 16.72 7.55 25.66 7.55s17.86-2.52 25.66-7.55c.62-.4 1.25-.85 1.94-1.38l138.5-107.52zM524.34 397.22l-12.91 30.22-.03.06v.03c-.11.21-.21.43-.32.64s-.23.42-.36.61c-.08.14-.17.27-.27.4-.08.11-.16.21-.24.31-.1.13-.21.25-.31.36-.08.09-.16.18-.24.25-.05.06-.1.11-.16.15l-.27.25c-.17.15-.33.29-.51.42-.15.13-.3.23-.47.33-.19.13-.39.25-.59.36s-.42.22-.63.31c-.22.1-.44.18-.66.26-.25.09-.49.17-.75.23-.2.05-.4.09-.61.13-.72.12-1.46.15-2.2.08-.19-.01-.36-.04-.55-.07-.04 0-.08-.02-.11-.02l-32.43-5.52a8.494 8.494 0 01-6.95-9.81 8.5 8.5 0 019.81-6.95l15.17 2.58-34.61-63.46a8.494 8.494 0 013.39-11.53c4.12-2.25 9.28-.73 11.53 3.39l34.61 63.46 6.04-14.15a8.508 8.508 0 0111.16-4.48c4.31 1.85 6.32 6.84 4.48 11.16zM175.66 399.19l12.91 30.22.03.06v.03c.11.21.21.43.32.64s.23.42.36.61c.08.14.17.27.27.4.08.11.16.21.24.31.1.13.21.25.31.36.08.09.16.18.24.25.05.06.1.11.16.15l.27.25c.17.15.33.29.51.42.15.13.3.23.47.33.19.13.39.25.59.36s.42.22.63.31c.22.1.44.18.66.26.25.09.49.17.75.23.2.05.4.09.61.13.72.12 1.46.15 2.2.08.19-.01.36-.04.55-.07.04 0 .08-.02.11-.02l32.43-5.52a8.494 8.494 0 006.95-9.81 8.5 8.5 0 00-9.81-6.95l-15.17 2.58 34.61-63.46c2.25-4.13.73-9.28-3.39-11.53s-9.28-.73-11.53 3.39l-34.61 63.46-6.04-14.15a8.508 8.508 0 00-11.16-4.48c-4.31 1.85-6.32 6.84-4.48 11.16zM260.43 467.71l-76.07 57.24c-5.52 4.16-13.24 4.16-18.76 0l-76.08-57.24h170.91z"></path>
            <path d="M277.36 476.26v110.05c0 5.52-4.48 10-10 10H82.59c-5.52 0-10-4.48-10-10V476.25l82.79 62.29c5.77 4.34 12.69 6.51 19.6 6.51s13.83-2.17 19.6-6.51l82.78-62.28z"></path>
            <g>
                <path d="M610.48 467.71l-76.07 57.24c-5.52 4.16-13.24 4.16-18.76 0l-76.08-57.24h170.91z"></path>
                <path d="M627.41 476.26v110.05c0 5.52-4.48 10-10 10H432.64c-5.52 0-10-4.48-10-10V476.25l82.79 62.29c5.77 4.34 12.69 6.51 19.6 6.51s13.83-2.17 19.6-6.51l82.78-62.28z"></path>
            </g>
        </svg>
    );
}

export function SagaIcon() {
    return (
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 700 700" className="icon">
            <path d="M626.41 255.77c-.56-4.77-2.95-9.03-6.71-11.99l-46.46-36.64-1.06-1.09-.8-.28c-.81-.52-1.67-.98-2.56-1.36-.43-.19-.85-.36-1.25-.5-.47-.16-.96-.31-1.51-.45-.47-.11-.96-.22-1.45-.3-.49-.08-.97-.14-1.43-.18-.96-.08-1.95-.08-2.91-.01-.41.03-.83.08-1.23.14-.41.06-.82.14-1.25.23l-.58.14c-.1.03-.2.05-.31.08-.11.03-.21.06-.3.09-.29.08-.57.18-.86.28-.49.17-.99.37-1.53.61l-.16.08c-.32.15-.65.31-.97.49-.49.26-.93.53-1.34.81-.39.26-.76.52-1.12.8l-46.96 37.05a17.823 17.823 0 00-6.72 12c-.57 4.77.76 9.47 3.72 13.21 3.42 4.36 8.56 6.86 14.12 6.86 4.01 0 7.96-1.37 11.12-3.87l17.82-14.05V438.9c0 25.31-10.5 49.83-28.8 67.29-18.09 17.26-41.65 26.13-66.35 24.99-47.06-2.21-84.23-39.8-86.39-86.44 20.51-3.9 39.27-14.42 53.46-30.11 16.07-17.77 24.91-40.72 24.91-64.63s-8.84-46.86-24.91-64.63c-14.24-15.74-33.09-26.28-53.7-30.15-1.52-32.97-15.83-64.54-39.77-87.4-25.27-24.1-58.24-36.49-92.84-34.88-67.7 3.16-120.74 58.77-120.74 126.63l.46 174.43c-20.98 7.36-35.58 27.43-35.58 50.14 0 29.27 23.81 53.08 53.08 53.08s53.09-23.81 53.09-53.08c0-22.71-14.6-42.79-35.59-50.14l.46-174.45c0-48.61 37.99-88.46 86.49-90.73 24.71-1.15 48.28 7.73 66.36 24.99 16.9 16.13 27.14 38.27 28.61 61.47-20.48 3.92-39.21 14.43-53.38 30.09-16.07 17.77-24.92 40.72-24.92 64.63s8.85 46.86 24.92 64.63c14.23 15.73 33.06 26.27 53.64 30.14 2.2 65.86 54.41 119.19 120.65 122.28 1.86.09 3.82.14 6 .14 32.35 0 63.19-12.44 86.84-35.02 25.37-24.21 39.91-58.2 39.91-93.27V257.92l17.82 14.06c7.78 6.13 19.09 4.79 25.22-2.98 2.98-3.76 4.31-8.46 3.74-13.23zm-290.7 132.81c-3.31 0-6.49-1.32-8.83-3.66l-24.76-24.75c-4.88-4.89-4.88-12.8 0-17.68 4.88-4.88 12.8-4.88 17.68 0l15.91 15.91 39.92-39.91c4.88-4.88 12.79-4.88 17.68 0 4.88 4.88 4.88 12.79 0 17.68l-48.76 48.75a12.504 12.504 0 01-8.84 3.66z"></path>
        </svg>
    );
}

export function TransformIcon() {
    return (
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 700 700" className="icon">
            <path d="M441.77 277.51l-82.73 64.23c-.07.05-.13.09-.19.13-5.37 3.48-12.33 3.48-17.69.01-.07-.05-.13-.09-.18-.13l-82.76-64.24h183.54z"></path>
            <path d="M462.2 287.02V420.7c0 .98-.79 1.77-1.77 1.77H239.57c-.98 0-1.77-.79-1.77-1.77V287.02l90.91 70.56c.54.44 1.06.8 1.57 1.12 5.99 3.88 12.86 5.81 19.72 5.81s13.73-1.94 19.73-5.81c.49-.32 1.01-.68 1.58-1.13l90.89-70.55zM622.28 330.68l-35.89 31.78a1.48 1.48 0 01-1.98 0l-35.89-31.78c-.3-.26-.48-.63-.51-1.03-.02-.4.11-.79.38-1.09l11.28-12.73c.55-.61 1.49-.67 2.11-.12l12.44 11.02c-5.24-51.26-28.18-99.47-64.84-136.12-35.82-35.82-81.13-58.05-131.04-64.27-.1 0-.19-.03-.28-.06v.09s-9.35-.94-9.42-9.69c-.05-5.85 3.31-10.87 9.61-10.42.15-.03.3-.04.45-.02 55.19 6.39 105.27 30.67 144.83 70.23 40.9 40.89 66.02 94.81 70.96 152.11l14.54-12.87c.29-.27.68-.41 1.08-.38.4.03.77.21 1.03.51l11.27 12.73c.55.62.49 1.56-.13 2.11zM362.48 115.58l-31.79 35.89c-.26.3-.63.48-1.03.51-.4.02-.79-.11-1.08-.38l-12.72-11.27a1.49 1.49 0 01-.13-2.11l11.02-12.45c-51.25 5.24-99.47 28.18-136.13 64.84-32.4 32.41-53.91 73.12-62.2 117.73-.04.2-.11.38-.21.54-.42 2.15-2.28 8.68-9.58 8.74-5.75.05-10.7-3.2-10.43-9.3v-.02c-.03-.16-.03-.33 0-.49 8.58-49.85 32.19-95.26 68.28-131.34 40.9-40.9 94.82-66.03 152.11-70.97l-12.86-14.53a1.49 1.49 0 01.13-2.11l12.72-11.27c.62-.55 1.56-.49 2.11.12l31.79 35.89c.51.56.51 1.42 0 1.98zM331.08 583.33c.05 5.85-3.31 10.87-9.61 10.42h-.17c-55.19-6.39-105.27-30.67-144.83-70.23-44.17-44.16-69.56-102.59-71.72-164.84l-13.78 12.2c-.29.27-.68.41-1.08.38-.4-.03-.77-.21-1.03-.51l-11.27-12.73a1.49 1.49 0 01.13-2.11l35.89-31.78c.56-.5 1.42-.5 1.98 0l35.88 31.78c.62.55.68 1.49.13 2.11l-11.27 12.73c-.26.3-.63.48-1.03.51-.39.03-.79-.11-1.08-.38l-13.44-11.9c2.21 56.78 25.51 110.07 65.83 150.4 35.82 35.82 81.14 58.05 131.05 64.27 0 0 9.35.94 9.42 9.69zM593.75 378.68c-6.39 55.2-30.67 105.28-70.22 144.83-40.9 40.9-94.82 66.03-152.11 70.97l12.86 14.53c.55.62.49 1.56-.13 2.11l-12.73 11.28c-.27.25-.62.38-.99.38h-.09c-.4-.03-.77-.21-1.03-.51l-31.78-35.89c-.51-.56-.51-1.42 0-1.98l31.78-35.89c.55-.63 1.49-.68 2.11-.13l12.73 11.27c.3.26.48.63.51 1.03.02.4-.11.79-.38 1.08l-11.02 12.45c51.26-5.24 99.47-28.18 136.12-64.84 35.82-35.83 58.05-81.14 64.27-131.05.02-.14.05-.26.1-.38h-.13s.94-9.34 9.69-9.42c5.85-.04 10.87 3.32 10.42 9.61h-.03c.06.18.07.36.05.55z"></path>
        </svg>
    );
}

export function FilterIcon() {
    return (
        <svg xmlns="http://www.w3.org/2000/svg" id="a" viewBox="0 0 700 700" className="icon">
            <path d="M565.62 156.56L413.36 350.33a10.032 10.032 0 00-2.14 6.18v190.52c0 19.05-25.01 34.49-55.86 34.49s-55.86-15.44-55.86-34.49V356.51c0-2.24-.75-4.42-2.14-6.18L145.1 156.56c-5.15-6.56-.48-16.18 7.87-16.18h404.79c8.34 0 13.02 9.62 7.86 16.18z"></path>
        </svg>
    );
}

export function SortIcon() {
    return (
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 700 700" className="icon">
            <defs>
                <style>{".b{stroke-linejoin: round;}.b,.c {stroke-linecap: round;}.b,.c,.d {fill: none;stroke: #000;stroke-width: 35px;}.c,.d {stroke-miterlimit: 10;}"}</style>
            </defs>
            <path d="M160.63 168.63L160.63 531.37" className="d"></path>
            <path d="M576.31 170.27L269.3 170.27" className="c"></path>
            <path d="M517.53 290.64L269.3 290.64" className="c"></path>
            <path d="M458.75 411L269.3 411" className="c"></path>
            <path d="M399.97 531.37L269.3 531.37" className="c"></path>
            <path d="M197.7 197.95L160.63 168.71 123.55 197.95" className="b"></path>
            <path d="M123.55 502.12L160.62 531.37 197.7 502.12" className="b"></path>
        </svg>
    );
}

export function OnCompletion() {
    return (
        <svg
            className="icon" width="32px" height="32px"
            xmlns="http://www.w3.org/2000/svg"
            id="icon"
            fill="#000"
            viewBox="0 0 32 32"
        >
            <defs>
                <style>{".cls-1 { fill: none; }"}</style>
            </defs>
            <path d="M22 26.59L19.41 24 18 25.41 22 29.41 30 21.41 28.59 20 22 26.59z"></path>
            <circle cx="16" cy="16" r="2"></circle>
            <path d="M16 22a6 6 0 116-6 6.007 6.007 0 01-6 6zm0-10a4 4 0 104 4 4.005 4.005 0 00-4-4z"></path>
            <path d="M28 16a12 12 0 10-12 12v-2a10 10 0 1110-10z"></path>
            <path
                id="_Transparent_Rectangle_"
                d="M0 0H32V32H0z"
                className="cls-1"
                data-name="&lt;Transparent Rectangle&gt;"
            ></path>
        </svg>
    );
}

export function Intercept() {
    return (
        <svg
            className="icon" width="32px" height="32px"
            xmlns="http://www.w3.org/2000/svg"
            id="icon"
            fill="#000"
            viewBox="0 0 32 32"
        >
            <defs>
                <style>{".cls-1 {    fill: none; }"}</style>
            </defs>
            <path d="M15 4H17V28H15z"></path>
            <path d="M10 7v18H4V7h6m0-2H4a2 2 0 00-2 2v18a2 2 0 002 2h6a2 2 0 002-2V7a2 2 0 00-2-2zM28 7v18h-6V7h6m0-2h-6a2 2 0 00-2 2v18a2 2 0 002 2h6a2 2 0 002-2V7a2 2 0 00-2-2z"></path>
            <path
                id="_Transparent_Rectangle_"
                d="M0 0H32V32H0z"
                className="cls-1"
                data-name="&lt;Transparent Rectangle&gt;"
            ></path>
        </svg>
    );
}

export function InterceptFrom() {
    return (
        <svg
            className="icon" width="32px" height="32px"
            xmlns="http://www.w3.org/2000/svg"
            id="icon"
            fill="#000"
            viewBox="0 0 32 32"
        >
            <defs>
                <style>{".cls-1 {    fill: none; }"}</style>
            </defs>
            <path d="M26 30H14a2 2 0 01-2-2v-3h2v3h12V4H14v3h-2V4a2 2 0 012-2h12a2 2 0 012 2v24a2 2 0 01-2 2z"></path>
            <path d="M14.59 20.59L18.17 17 4 17 4 15 18.17 15 14.59 11.41 16 10 22 16 16 22 14.59 20.59z"></path>
            <path
                id="_Transparent_Rectangle_"
                d="M0 0H32V32H0z"
                className="cls-1"
                data-name="&lt;Transparent Rectangle&gt;"
            ></path>
        </svg>
    );
}

export function InterceptSendToEndpoint() {
    return (
        <svg
            className="icon" width="32px" height="32px"
            xmlns="http://www.w3.org/2000/svg"
            id="icon"
            fill="#000"
            viewBox="0 0 32 32"
        >
            <defs>
                <style>{".cls-1 {    fill: none; }"}</style>
            </defs>
            <path d="M6 30h12a2.002 2.002 0 002-2v-3h-2v3H6V4h12v3h2V4a2.002 2.002 0 00-2-2H6a2.002 2.002 0 00-2 2v24a2.002 2.002 0 002 2z"></path>
            <path d="M20.586 20.586L24.172 17 10 17 10 15 24.172 15 20.586 11.414 22 10 28 16 22 22 20.586 20.586z"></path>
            <path
                id="_Transparent_Rectangle_"
                d="M0 0H32V32H0z"
                className="cls-1"
                data-name="&lt;Transparent Rectangle&gt;"
            ></path>
        </svg>
    );
}


export function SpringIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="32"
            height="32"
            viewBox="0 0 32 32"
            className="icon">
            <g fill="none" fillRule="evenodd">
                <path d="M0 0h32v32H0z"></path>
                <path
                    fill="#70AD51"
                    d="M5.466 27.993a1.364 1.364 0 10-.087-.076l-.266-.234C1.972 24.762 0 20.597 0 15.978 0 7.168 7.168 0 15.98 0c4.48 0 8.53 1.857 11.435 4.836a14.681 14.681 0 001.7-3.015c2.036 6.118 3.233 11.26 2.795 15.31-.592 8.274-7.508 14.83-15.93 14.83a15.903 15.903 0 01-10.276-3.757l-.238-.21zm23.58-4.982c4.01-5.336 1.775-13.965-.085-19.48-1.657 3.453-5.738 6.094-9.262 6.93-3.303.788-6.226.142-9.283 1.318-6.97 2.68-6.86 10.992-3.02 12.86.002 0 .23.124.227.12 0-.002 5.644-1.122 8.764-2.274 4.56-1.684 9.566-5.835 11.213-10.657-.877 5.015-5.182 9.84-9.507 12.056-2.302 1.182-4.092 1.445-7.88 2.756-.464.158-.828.314-.828.314.96-.16 1.917-.212 1.917-.212 5.393-.255 13.807 1.516 17.745-3.73z"
                ></path>
            </g>
        </svg>
    );
}

export function QuarkusIcon() {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="257"
            height="257"
            preserveAspectRatio="xMidYMid"
            viewBox="-0.5 0 257 257"
            className="icon">
            <path
                fill="#4695EB"
                d="M213.554 0c23.418.08 42.377 19.052 42.443 42.47v171.084c-.066 23.428-19.042 42.404-42.47 42.47h-25.439l-11.661-28.318h37.127c7.774-.1 14.051-6.378 14.152-14.152V42.47c-.1-7.774-6.378-14.051-14.152-14.152H42.47c-7.774.1-14.051 6.378-14.152 14.152v171.084c.1 7.774 6.378 14.051 14.152 14.152h62.607l22.935-48.494 31.625 76.812H42.47C19.042 255.958.066 236.982 0 213.554V42.47C.066 19.042 19.042.066 42.47 0h171.084zm-43.983 139.727v45.51l-39.417-22.748 39.417-22.762zM86.453 94.218v45.51l-39.418-22.762 39.418-22.748zm80.976-49.231v45.51l-39.417-22.762 39.417-22.748z"
            ></path>
            <path
                fill="#FF004A"
                d="M86.453 139.727l39.417 22.762-39.417 22.748v-45.51zm83.118-45.509l39.418 22.748-39.418 22.761V94.218zM88.595 44.987l39.417 22.748-39.417 22.761V44.987z"
            ></path>
            <path
                fill="#091313"
                d="M86.453 94.218l39.417 22.748v45.523l-39.417-22.762V94.218zm83.118 0v45.51l-39.417 22.76v-45.522l39.417-22.748zm-41.559-26.483l39.417 22.761-39.417 22.761-39.417-22.76 39.417-22.762z"
            ></path>
        </svg>
    );
}