# Changelog

## [Unreleased](https://github.com/apache/camel-kamelets/tree/HEAD)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v4.0.0-RC1...HEAD)

**Implemented enhancements:**

- aws-ec2 kamelets proposed improvement [\#516](https://github.com/apache/camel-kamelets/issues/516)

**Fixed bugs:**

- Yaks test job is reported in success despite test failure [\#1576](https://github.com/apache/camel-kamelets/issues/1576)

**Closed issues:**

- Mongodb kamelets lack kamelets-utils dependency [\#1602](https://github.com/apache/camel-kamelets/issues/1602)
- Minio Sink Kamelet: Like we do in S3 add the ability to specify objectName instead of using header [\#1599](https://github.com/apache/camel-kamelets/issues/1599)
- Azure Datalake still uses camel-kamelets-utils from github notation [\#1597](https://github.com/apache/camel-kamelets/issues/1597)
- Add Support for Topic in Servicebus Kamelets [\#1596](https://github.com/apache/camel-kamelets/issues/1596)
- NoSuchEndpointException while using TOD uri in kamelets/salesforce-update-sink.kamelet.yaml  [\#1590](https://github.com/apache/camel-kamelets/issues/1590)
- Warning during build due to peter-evans/create-pull-request@v3 using node12 [\#1588](https://github.com/apache/camel-kamelets/issues/1588)
- CI enablement for PPC64LE   [\#1582](https://github.com/apache/camel-kamelets/issues/1582)
- Fix yaks test failing on main branch [\#1579](https://github.com/apache/camel-kamelets/issues/1579)
- Remove forbidden parameter names list in validator [\#1577](https://github.com/apache/camel-kamelets/issues/1577)
- CI enablement on PPC64le for Camel-kamelets [\#1549](https://github.com/apache/camel-kamelets/issues/1549)
- Switch from Fabric 8 Camel K Extension to Camel K CRDS in Catalog [\#1539](https://github.com/apache/camel-kamelets/issues/1539)
- Create an Opensearch Search Source Kamelet [\#1537](https://github.com/apache/camel-kamelets/issues/1537)
- Create an Opensearch Index sink Kamelet [\#1536](https://github.com/apache/camel-kamelets/issues/1536)
- Support personal token authentication in jira kamelet [\#1529](https://github.com/apache/camel-kamelets/issues/1529)
- Release Camel Kamelets 4.0.0-RC1 [\#1525](https://github.com/apache/camel-kamelets/issues/1525)
- ElasicSearchSink-TrustCertificates [\#1246](https://github.com/apache/camel-kamelets/issues/1246)
- Salesforce Sink Kamelet: Provide a general sink [\#875](https://github.com/apache/camel-kamelets/issues/875)
- Add an Header From Kamelet Action [\#707](https://github.com/apache/camel-kamelets/issues/707)

**Merged pull requests:**

- Upgrade Camel K CRDs to 2.0.1 [\#1617](https://github.com/apache/camel-kamelets/pull/1617) ([apupier](https://github.com/apupier))
- Generated sources regen [\#1616](https://github.com/apache/camel-kamelets/pull/1616) ([github-actions[bot]](https://github.com/apps/github-actions))
- fix\(ci\): remove example breaking site [\#1614](https://github.com/apache/camel-kamelets/pull/1614) ([squakez](https://github.com/squakez))
- Generated sources regen [\#1613](https://github.com/apache/camel-kamelets/pull/1613) ([github-actions[bot]](https://github.com/apps/github-actions))
- Create salesforce-composite-upsert-sink.kamelet.yaml [\#1612](https://github.com/apache/camel-kamelets/pull/1612) ([Ziauddin135](https://github.com/Ziauddin135))
- Validate should use 1.20.x golang [\#1611](https://github.com/apache/camel-kamelets/pull/1611) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1608](https://github.com/apache/camel-kamelets/pull/1608) ([github-actions[bot]](https://github.com/apps/github-actions))
- Use Data Type Transformer API provided by Camel 4.0 [\#1607](https://github.com/apache/camel-kamelets/pull/1607) ([christophd](https://github.com/christophd))
- Mongodb kamelets lack kamelets-utils dependency [\#1603](https://github.com/apache/camel-kamelets/pull/1603) ([oscerd](https://github.com/oscerd))
- Minio Sink Kamelet: Like we do in S3 add the ability to specify objec… [\#1601](https://github.com/apache/camel-kamelets/pull/1601) ([oscerd](https://github.com/oscerd))
- Warning during build due to peter-evans/create-pull-request@v3 using … [\#1600](https://github.com/apache/camel-kamelets/pull/1600) ([oscerd](https://github.com/oscerd))
- Azure Datalake still uses camel-kamelets-utils from github notation [\#1598](https://github.com/apache/camel-kamelets/pull/1598) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1595](https://github.com/apache/camel-kamelets/pull/1595) ([github-actions[bot]](https://github.com/apps/github-actions))
- Added Opensearch Search Source Kamelet [\#1594](https://github.com/apache/camel-kamelets/pull/1594) ([oscerd](https://github.com/oscerd))
- Added Opensearch Sink Kamelet [\#1592](https://github.com/apache/camel-kamelets/pull/1592) ([oscerd](https://github.com/oscerd))
- chore\(doc\) : Add examples for simple-filter-action kamelet [\#1589](https://github.com/apache/camel-kamelets/pull/1589) ([gansheer](https://github.com/gansheer))
- Remove no more needed GitHub actions/cache [\#1587](https://github.com/apache/camel-kamelets/pull/1587) ([apupier](https://github.com/apupier))
- chore\(test\): Fix YAKS tests [\#1586](https://github.com/apache/camel-kamelets/pull/1586) ([christophd](https://github.com/christophd))
- Rename Jenkinsfile [\#1584](https://github.com/apache/camel-kamelets/pull/1584) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1583](https://github.com/apache/camel-kamelets/pull/1583) ([github-actions[bot]](https://github.com/apps/github-actions))
- Camel-Kamelets : Adding jenkinsfile for ppc64le [\#1581](https://github.com/apache/camel-kamelets/pull/1581) ([shreyakajbaje](https://github.com/shreyakajbaje))
- Generated sources regen [\#1580](https://github.com/apache/camel-kamelets/pull/1580) ([github-actions[bot]](https://github.com/apps/github-actions))
- Remove no more needed check on reserved keyword for kamelet [\#1578](https://github.com/apache/camel-kamelets/pull/1578) ([apupier](https://github.com/apupier))
- Update GitHub Action version [\#1575](https://github.com/apache/camel-kamelets/pull/1575) ([apupier](https://github.com/apupier))
- Fix typo on Jbang --\> JBang [\#1574](https://github.com/apache/camel-kamelets/pull/1574) ([apupier](https://github.com/apupier))
- Fix typos in readme of infra [\#1573](https://github.com/apache/camel-kamelets/pull/1573) ([apupier](https://github.com/apupier))
- Remove mention to SVN in readme [\#1572](https://github.com/apache/camel-kamelets/pull/1572) ([apupier](https://github.com/apupier))
- Generated sources regen for SBOM [\#1571](https://github.com/apache/camel-kamelets/pull/1571) ([github-actions[bot]](https://github.com/apps/github-actions))
- Fix typo Ceritificate [\#1570](https://github.com/apache/camel-kamelets/pull/1570) ([apupier](https://github.com/apupier))
- Fix typos in GitHub kamelets [\#1569](https://github.com/apache/camel-kamelets/pull/1569) ([apupier](https://github.com/apupier))
- Remove Nicola Ferraro from assignees of PR automatically created for [\#1568](https://github.com/apache/camel-kamelets/pull/1568) ([apupier](https://github.com/apupier))
- Generated sources regen [\#1567](https://github.com/apache/camel-kamelets/pull/1567) ([github-actions[bot]](https://github.com/apps/github-actions))
- Use https instead of http for maven metadata information of the [\#1564](https://github.com/apache/camel-kamelets/pull/1564) ([apupier](https://github.com/apupier))
- CAMEL-19561 - align Artemis version with Camel 4.0.0 [\#1563](https://github.com/apache/camel-kamelets/pull/1563) ([apupier](https://github.com/apupier))
- Fix typo in doc [\#1561](https://github.com/apache/camel-kamelets/pull/1561) ([apupier](https://github.com/apupier))
- Remove unused attribute in camel-kamelet-utils [\#1560](https://github.com/apache/camel-kamelets/pull/1560) ([apupier](https://github.com/apupier))
- Use generics in camel-kamelet-utils [\#1559](https://github.com/apache/camel-kamelets/pull/1559) ([apupier](https://github.com/apupier))
- Remove unused imports in camel-kamelet-utils [\#1558](https://github.com/apache/camel-kamelets/pull/1558) ([apupier](https://github.com/apupier))
- Upgrade maven-rat-plugin from 0.14 to 0.15 [\#1557](https://github.com/apache/camel-kamelets/pull/1557) ([apupier](https://github.com/apupier))
- Upgrade maven-assembly-plugin from 3.4.2 to 3.6.0 [\#1556](https://github.com/apache/camel-kamelets/pull/1556) ([apupier](https://github.com/apupier))
- Fix indentation in pom.xml \(tab used instead of spaces\) [\#1555](https://github.com/apache/camel-kamelets/pull/1555) ([apupier](https://github.com/apupier))
- Upgrade maven-javadoc-plugin from 3.4.0 to 3.5.0 [\#1554](https://github.com/apache/camel-kamelets/pull/1554) ([apupier](https://github.com/apupier))
- Upgrade maven-surefire-plugin from 3.0.0-M7 to 3.1.2 [\#1553](https://github.com/apache/camel-kamelets/pull/1553) ([apupier](https://github.com/apupier))
- Upgrade Camel from 4.0.0-RC1 to 4.0.0 [\#1552](https://github.com/apache/camel-kamelets/pull/1552) ([apupier](https://github.com/apupier))
- Upgrade Camel K CRD from 1.12 to 2.0.0 [\#1551](https://github.com/apache/camel-kamelets/pull/1551) ([apupier](https://github.com/apupier))
- Generated sources regen for SBOM [\#1550](https://github.com/apache/camel-kamelets/pull/1550) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen for SBOM [\#1548](https://github.com/apache/camel-kamelets/pull/1548) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen for SBOM [\#1547](https://github.com/apache/camel-kamelets/pull/1547) ([github-actions[bot]](https://github.com/apps/github-actions))
- AWS SQS Removal in infra: Added Ansible removal for SQS Queue [\#1545](https://github.com/apache/camel-kamelets/pull/1545) ([oscerd](https://github.com/oscerd))
- Ansible AWS S3 Removal: Added instruction to README [\#1544](https://github.com/apache/camel-kamelets/pull/1544) ([oscerd](https://github.com/oscerd))
- AWS S3 Removal in infra: Added Ansible removal for S3 Bucket [\#1543](https://github.com/apache/camel-kamelets/pull/1543) ([oscerd](https://github.com/oscerd))
- Upgrade Tag to 4.0.0-RC1 [\#1542](https://github.com/apache/camel-kamelets/pull/1542) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1541](https://github.com/apache/camel-kamelets/pull/1541) ([github-actions[bot]](https://github.com/apps/github-actions))
- Switch from Fabric8 Camel K Extension to Camel K CRDS [\#1540](https://github.com/apache/camel-kamelets/pull/1540) ([oscerd](https://github.com/oscerd))
- Added an extract field tests for horizontal tab escaping [\#1538](https://github.com/apache/camel-kamelets/pull/1538) ([oscerd](https://github.com/oscerd))
- Provide some infrastructure as code configuration files for Terraform/Ansible/Cloudformation - AWS SQS [\#1535](https://github.com/apache/camel-kamelets/pull/1535) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1534](https://github.com/apache/camel-kamelets/pull/1534) ([github-actions[bot]](https://github.com/apps/github-actions))
- Support personal token authentication to jira [\#1530](https://github.com/apache/camel-kamelets/pull/1530) ([claudio4j](https://github.com/claudio4j))

## [v4.0.0-RC1](https://github.com/apache/camel-kamelets/tree/v4.0.0-RC1) (2023-07-05)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v3.21.0...v4.0.0-RC1)

**Closed issues:**

- Bump to Camel 4.0.0-RC1 [\#1524](https://github.com/apache/camel-kamelets/issues/1524)
- Release 3.21.0 [\#1523](https://github.com/apache/camel-kamelets/issues/1523)

**Merged pull requests:**

- Upgrade Camel to version 4.0.0-RC1 [\#1528](https://github.com/apache/camel-kamelets/pull/1528) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1526](https://github.com/apache/camel-kamelets/pull/1526) ([github-actions[bot]](https://github.com/apps/github-actions))
- Azure Storage Blob Kamelets: Expose the credentialsType parameter wit… [\#1518](https://github.com/apache/camel-kamelets/pull/1518) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1513](https://github.com/apache/camel-kamelets/pull/1513) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen for SBOM [\#1512](https://github.com/apache/camel-kamelets/pull/1512) ([github-actions[bot]](https://github.com/apps/github-actions))
- FTP/SFTP/FTPS Source Kamelets: Add Delete option [\#1509](https://github.com/apache/camel-kamelets/pull/1509) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1506](https://github.com/apache/camel-kamelets/pull/1506) ([github-actions[bot]](https://github.com/apps/github-actions))
- Provide some infrastructure as code configuration files for Terraform/Ansible/Cloudformation  [\#1505](https://github.com/apache/camel-kamelets/pull/1505) ([oscerd](https://github.com/oscerd))
- Align jackson version with core camel project [\#1502](https://github.com/apache/camel-kamelets/pull/1502) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1500](https://github.com/apache/camel-kamelets/pull/1500) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen for SBOM [\#1495](https://github.com/apache/camel-kamelets/pull/1495) ([github-actions[bot]](https://github.com/apps/github-actions))
- Upgrade PostgreSQL Driver to version 42.6.0 [\#1494](https://github.com/apache/camel-kamelets/pull/1494) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#1491](https://github.com/apache/camel-kamelets/pull/1491) ([github-actions[bot]](https://github.com/apps/github-actions))
- Bump Redshift-jdbc to version 2.1.0.14 [\#1490](https://github.com/apache/camel-kamelets/pull/1490) ([oscerd](https://github.com/oscerd))
- chore: Enhance Kamelet data type implementations [\#1489](https://github.com/apache/camel-kamelets/pull/1489) ([christophd](https://github.com/christophd))
- Bean: Use properties instead of property with key and value [\#1488](https://github.com/apache/camel-kamelets/pull/1488) ([oscerd](https://github.com/oscerd))
- Bean: Use properties instead of property with key and value [\#1487](https://github.com/apache/camel-kamelets/pull/1487) ([oscerd](https://github.com/oscerd))
- chore: Improve YAKS tests [\#1486](https://github.com/apache/camel-kamelets/pull/1486) ([christophd](https://github.com/christophd))
- Bean: Use properties instead of property with key and value [\#1485](https://github.com/apache/camel-kamelets/pull/1485) ([oscerd](https://github.com/oscerd))
- Bean: Use properties instead of property with key and value [\#1484](https://github.com/apache/camel-kamelets/pull/1484) ([oscerd](https://github.com/oscerd))
- Bean: Use properties instead of property with key and value [\#1483](https://github.com/apache/camel-kamelets/pull/1483) ([oscerd](https://github.com/oscerd))
- Bean: Use properties instead of property with key and value  [\#1482](https://github.com/apache/camel-kamelets/pull/1482) ([oscerd](https://github.com/oscerd))
- Bean: Use properties instead of property with key and value - AWS DDB Sink [\#1481](https://github.com/apache/camel-kamelets/pull/1481) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1480](https://github.com/apache/camel-kamelets/pull/1480) ([github-actions[bot]](https://github.com/apps/github-actions))
- Kafka Secured Kamelets: use double quote around user and password [\#1477](https://github.com/apache/camel-kamelets/pull/1477) ([oscerd](https://github.com/oscerd))
- added sslCipherSuite property so TLS can be enabled [\#1474](https://github.com/apache/camel-kamelets/pull/1474) ([vedran-kolka-syntio](https://github.com/vedran-kolka-syntio))
- Generated sources regen for SBOM [\#1473](https://github.com/apache/camel-kamelets/pull/1473) ([github-actions[bot]](https://github.com/apps/github-actions))

## [v3.21.0](https://github.com/apache/camel-kamelets/tree/v3.21.0) (2023-06-30)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v3.20.6...v3.21.0)

**Closed issues:**

- Azure Storage Blob Kamelets: Expose the credentialsType parameter with SHARED\_ACCOUNT\_KEY as default [\#1517](https://github.com/apache/camel-kamelets/issues/1517)
- Release 3.20.6 [\#1515](https://github.com/apache/camel-kamelets/issues/1515)
- Add Twitter timeline sink Kamelet [\#102](https://github.com/apache/camel-kamelets/issues/102)
- Add Twitter Direct Message Sink Kamelet [\#100](https://github.com/apache/camel-kamelets/issues/100)
- Add Box Source Kamelet [\#17](https://github.com/apache/camel-kamelets/issues/17)

## [v3.20.6](https://github.com/apache/camel-kamelets/tree/v3.20.6) (2023-06-26)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v3.20.5...v3.20.6)

**Closed issues:**

- Bump to Camel 3.20.6 [\#1514](https://github.com/apache/camel-kamelets/issues/1514)
- coffee-source.kamelet.yaml not found [\#1508](https://github.com/apache/camel-kamelets/issues/1508)
- FTP/SFTP/FTPS Source Kamelets: Add Delete option [\#1507](https://github.com/apache/camel-kamelets/issues/1507)
- Align jackson version with core camel project [\#1499](https://github.com/apache/camel-kamelets/issues/1499)
- Release 3.20.5 [\#1497](https://github.com/apache/camel-kamelets/issues/1497)
- Bump to Camel 3.20.5 [\#1496](https://github.com/apache/camel-kamelets/issues/1496)
- Support boolean values in additionalProperties of Kafka kamelet [\#1492](https://github.com/apache/camel-kamelets/issues/1492)
- AWS S3 Source Connector: Add an maxMessagesPerPoll option so we can define the batch dimension [\#1250](https://github.com/apache/camel-kamelets/issues/1250)

## [v3.20.5](https://github.com/apache/camel-kamelets/tree/v3.20.5) (2023-05-29)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v3.20.4...v3.20.5)

**Closed issues:**

- Kafka Secured Kamelets: use double quote around user and password [\#1476](https://github.com/apache/camel-kamelets/issues/1476)
- Bean: Use `properties` instead of `property` with `key` and `value` [\#1475](https://github.com/apache/camel-kamelets/issues/1475)
- Release 3.20.4 [\#1472](https://github.com/apache/camel-kamelets/issues/1472)

## [v3.20.4](https://github.com/apache/camel-kamelets/tree/v3.20.4) (2023-05-16)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v4.0.0-M3...v3.20.4)

**Closed issues:**

- Release 4.0.0-M3 [\#1469](https://github.com/apache/camel-kamelets/issues/1469)

## [v4.0.0-M3](https://github.com/apache/camel-kamelets/tree/v4.0.0-M3) (2023-05-11)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v3.20.3...v4.0.0-M3)

**Closed issues:**

- Bump to Camel 4.0.0-M3 [\#1468](https://github.com/apache/camel-kamelets/issues/1468)
- Migrate deprecated jackson-dataformat-yaml used in Kamelets catalog [\#1463](https://github.com/apache/camel-kamelets/issues/1463)
- Bump to 3.20.4 [\#1459](https://github.com/apache/camel-kamelets/issues/1459)
- Remove Solr Kamelets [\#1456](https://github.com/apache/camel-kamelets/issues/1456)
- Add a Simple Filter Action [\#1448](https://github.com/apache/camel-kamelets/issues/1448)
- Upgrade to Camel 3.20.3 [\#1428](https://github.com/apache/camel-kamelets/issues/1428)
- Release 4.0.0-M2 [\#1427](https://github.com/apache/camel-kamelets/issues/1427)
- telegram-sink chat-id property must be required and/or have a default? [\#981](https://github.com/apache/camel-kamelets/issues/981)
- Add Azure CosmosDB Sink Kamelet [\#446](https://github.com/apache/camel-kamelets/issues/446)

**Merged pull requests:**

- Add Azure CosmosDB Sink Kamelet [\#1471](https://github.com/apache/camel-kamelets/pull/1471) ([oscerd](https://github.com/oscerd))
- Upgrade Camel to 4.0.0-M3 [\#1470](https://github.com/apache/camel-kamelets/pull/1470) ([oscerd](https://github.com/oscerd))
- Upgrade CycloneDX Maven plugin to version 2.7.8 [\#1467](https://github.com/apache/camel-kamelets/pull/1467) ([oscerd](https://github.com/oscerd))
- Upgrade Jackson from 2.14.1 to 2.15.0 [\#1465](https://github.com/apache/camel-kamelets/pull/1465) ([apupier](https://github.com/apupier))
- Generated sources regen for SBOM [\#1462](https://github.com/apache/camel-kamelets/pull/1462) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen for SBOM [\#1461](https://github.com/apache/camel-kamelets/pull/1461) ([github-actions[bot]](https://github.com/apps/github-actions))
- Make Kamelet Catalog examples to use Camel JBang [\#1458](https://github.com/apache/camel-kamelets/pull/1458) ([oscerd](https://github.com/oscerd))
- Remove Solr Kamelets [\#1457](https://github.com/apache/camel-kamelets/pull/1457) ([oscerd](https://github.com/oscerd))
- Upgrade Classgraph to version 4.8.157 [\#1455](https://github.com/apache/camel-kamelets/pull/1455) ([oscerd](https://github.com/oscerd))
- Upgrade CycloneDX Maven Plugin to version 2.7.7 [\#1454](https://github.com/apache/camel-kamelets/pull/1454) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1453](https://github.com/apache/camel-kamelets/pull/1453) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen [\#1452](https://github.com/apache/camel-kamelets/pull/1452) ([github-actions[bot]](https://github.com/apps/github-actions))
- Simple Filter Action Kamelet [\#1449](https://github.com/apache/camel-kamelets/pull/1449) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1447](https://github.com/apache/camel-kamelets/pull/1447) ([github-actions[bot]](https://github.com/apps/github-actions))

## [v3.20.3](https://github.com/apache/camel-kamelets/tree/v3.20.3) (2023-04-13)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v4.0.0-M2...v3.20.3)

## [v4.0.0-M2](https://github.com/apache/camel-kamelets/tree/v4.0.0-M2) (2023-04-13)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v3.20.2...v4.0.0-M2)

**Fixed bugs:**

- catalog: io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps does not retain extensions [\#284](https://github.com/apache/camel-kamelets/issues/284)

**Closed issues:**

- oracle-database-source.kamelet doesn't create the correct JDBC connection String  [\#1443](https://github.com/apache/camel-kamelets/issues/1443)
- Create a Kamelet action for setting a specific kafka key based on a particular header incoming [\#1430](https://github.com/apache/camel-kamelets/issues/1430)
- Transformer not printing the custom headers set in Processor [\#1429](https://github.com/apache/camel-kamelets/issues/1429)
- Create a Graphql Sink Kamelet [\#1424](https://github.com/apache/camel-kamelets/issues/1424)
- Cassandra Kamelets: Consistency Level in source should list only available consistency level for reading [\#1410](https://github.com/apache/camel-kamelets/issues/1410)
- Azure Storage Blob Sink: Remove operation parameter, since the kamelet has been developed just for uploadBlockBlob operation [\#1405](https://github.com/apache/camel-kamelets/issues/1405)
- Azure Storage Blob Kamelets: Use just the SHARED\_ACCOUNT\_KEY credentials as default  [\#1400](https://github.com/apache/camel-kamelets/issues/1400)
- Extract Field: Add a property to trim the field [\#1395](https://github.com/apache/camel-kamelets/issues/1395)
- Kafka Source Kamelets: Enable deserializeHeaders by default [\#1382](https://github.com/apache/camel-kamelets/issues/1382)
- AWS DDB Sink Kamelet: Remove WriteCapacity parameter [\#1381](https://github.com/apache/camel-kamelets/issues/1381)
- AWS S3 Source Kamelet: Removing includeBody option [\#1373](https://github.com/apache/camel-kamelets/issues/1373)
- SFTP source - it creates a new folder \(if doesn't exist\) instead of throwing an exception [\#1345](https://github.com/apache/camel-kamelets/issues/1345)
- DynamoDB Sink - use enum for available operations [\#1336](https://github.com/apache/camel-kamelets/issues/1336)
- Deprecating parameters [\#1330](https://github.com/apache/camel-kamelets/issues/1330)
- Release Camel-Kamelets 4.0.0-M1 [\#1313](https://github.com/apache/camel-kamelets/issues/1313)
- Release Camel-Kamelets 3.20.2 [\#1312](https://github.com/apache/camel-kamelets/issues/1312)
- Bump to Camel 3.20.2 [\#1299](https://github.com/apache/camel-kamelets/issues/1299)
- Add azure data lake gen2 [\#1075](https://github.com/apache/camel-kamelets/issues/1075)
- Switch examples to use Kafka kamelets [\#389](https://github.com/apache/camel-kamelets/issues/389)
- Expose user-relevant options in kafka sources/sinks [\#247](https://github.com/apache/camel-kamelets/issues/247)

**Merged pull requests:**

-  fixed Oracle connection URL [\#1442](https://github.com/apache/camel-kamelets/pull/1442) ([mrinalsharma](https://github.com/mrinalsharma))
- DynamoDB Sink Kamelet: Improved description for put, update and delete item operation [\#1438](https://github.com/apache/camel-kamelets/pull/1438) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1437](https://github.com/apache/camel-kamelets/pull/1437) ([github-actions[bot]](https://github.com/apps/github-actions))
- Upgrade CycloneDX maven plugin to version 2.7.6 [\#1436](https://github.com/apache/camel-kamelets/pull/1436) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#1435](https://github.com/apache/camel-kamelets/pull/1435) ([github-actions[bot]](https://github.com/apps/github-actions))
- Fix typo in description of telegram source kamelet [\#1434](https://github.com/apache/camel-kamelets/pull/1434) ([apupier](https://github.com/apupier))
- Generated sources regen for SBOM [\#1433](https://github.com/apache/camel-kamelets/pull/1433) ([github-actions[bot]](https://github.com/apps/github-actions))
- Create a Kamelet action for setting a specific kafka key based on a particular header incoming [\#1432](https://github.com/apache/camel-kamelets/pull/1432) ([oscerd](https://github.com/oscerd))
- Upgrade to Camel 4.0.0-M2 [\#1426](https://github.com/apache/camel-kamelets/pull/1426) ([oscerd](https://github.com/oscerd))
- Added GraphQL basic sink Kamelet [\#1425](https://github.com/apache/camel-kamelets/pull/1425) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1423](https://github.com/apache/camel-kamelets/pull/1423) ([github-actions[bot]](https://github.com/apps/github-actions))
- Cassandra Kamelets: Consistency Level in source should list only available consistency level for writing [\#1422](https://github.com/apache/camel-kamelets/pull/1422) ([oscerd](https://github.com/oscerd))
- Azure Storage Blob Kamelets: Use just the SHARED\_ACCOUNT\_KEY credentials as default [\#1415](https://github.com/apache/camel-kamelets/pull/1415) ([oscerd](https://github.com/oscerd))
- Cassandra Kamelets: Consistency Level in source should list only available consistency level for reading [\#1411](https://github.com/apache/camel-kamelets/pull/1411) ([oscerd](https://github.com/oscerd))
- Azure Storage Blob Sink: Remove operation parameter, since the kamelet has been developed just for uploadBlockBlob operation [\#1406](https://github.com/apache/camel-kamelets/pull/1406) ([oscerd](https://github.com/oscerd))
- Azure Storage Blob Kamelets: Use just the SHARED\_ACCOUNT\_KEY credentials as default [\#1401](https://github.com/apache/camel-kamelets/pull/1401) ([oscerd](https://github.com/oscerd))
- Extract Field: Add a property to trim the field [\#1396](https://github.com/apache/camel-kamelets/pull/1396) ([oscerd](https://github.com/oscerd))
- AWS DDB Sink Kamelet: Remove WriteCapacity parameter [\#1391](https://github.com/apache/camel-kamelets/pull/1391) ([oscerd](https://github.com/oscerd))
- Add azure data lake gen2 - Sink Kamelet [\#1390](https://github.com/apache/camel-kamelets/pull/1390) ([oscerd](https://github.com/oscerd))
- Add azure data lake gen2 - Source Kamelet [\#1387](https://github.com/apache/camel-kamelets/pull/1387) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1386](https://github.com/apache/camel-kamelets/pull/1386) ([github-actions[bot]](https://github.com/apps/github-actions))
- Kafka Source Kamelets: Enable deserializeHeaders by default  [\#1383](https://github.com/apache/camel-kamelets/pull/1383) ([oscerd](https://github.com/oscerd))
- JMS AMQP 1.0 Source/Sink Kamelets: Replace QPID client with camel-amqp [\#1378](https://github.com/apache/camel-kamelets/pull/1378) ([gansheer](https://github.com/gansheer))
- AWS S3 Source Kamelet: Removing includeBody option [\#1374](https://github.com/apache/camel-kamelets/pull/1374) ([oscerd](https://github.com/oscerd))
- Add Enum for Http Methods in HTTP Sink Kamelets [\#1369](https://github.com/apache/camel-kamelets/pull/1369) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1368](https://github.com/apache/camel-kamelets/pull/1368) ([github-actions[bot]](https://github.com/apps/github-actions))
- Azure functions HTTP methods enum [\#1362](https://github.com/apache/camel-kamelets/pull/1362) ([oscerd](https://github.com/oscerd))
- Adding autoCreate parameter to FTPS Kamelets [\#1358](https://github.com/apache/camel-kamelets/pull/1358) ([oscerd](https://github.com/oscerd))
- Adding autoCreate option to FTP too [\#1354](https://github.com/apache/camel-kamelets/pull/1354) ([oscerd](https://github.com/oscerd))
- Switch examples to use Kafka kamelets [\#1353](https://github.com/apache/camel-kamelets/pull/1353) ([oscerd](https://github.com/oscerd))
- SFTP source - it creates a new folder \(if doesn't exist\) instead of throwing an exception [\#1349](https://github.com/apache/camel-kamelets/pull/1349) ([oscerd](https://github.com/oscerd))
- Remove Activemq-http from POM and BOM since we don't use it anymore [\#1348](https://github.com/apache/camel-kamelets/pull/1348) ([oscerd](https://github.com/oscerd))
- Upgrade Artemis to version 2.28.0 [\#1347](https://github.com/apache/camel-kamelets/pull/1347) ([oscerd](https://github.com/oscerd))
- Upgrade Redshift-jdbc42 to version 2.1.0.12 [\#1346](https://github.com/apache/camel-kamelets/pull/1346) ([oscerd](https://github.com/oscerd))
- Updated Prefix Enum after Kamelets removal [\#1344](https://github.com/apache/camel-kamelets/pull/1344) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1338](https://github.com/apache/camel-kamelets/pull/1338) ([github-actions[bot]](https://github.com/apps/github-actions))
- Issue-1336: DynamoDB Sink - use enum for available operations [\#1337](https://github.com/apache/camel-kamelets/pull/1337) ([manstis](https://github.com/manstis))
- chore: Run deploy GitHub workflow job on main repo only [\#1335](https://github.com/apache/camel-kamelets/pull/1335) ([christophd](https://github.com/christophd))
- chore: Fix Log4j2 to SLF4J2 binding [\#1334](https://github.com/apache/camel-kamelets/pull/1334) ([christophd](https://github.com/christophd))
- chore: Remove experimental data type Kamelets [\#1333](https://github.com/apache/camel-kamelets/pull/1333) ([christophd](https://github.com/christophd))
- Upgrade to Cyclonedx Maven Plugin 2.7.5 [\#1332](https://github.com/apache/camel-kamelets/pull/1332) ([oscerd](https://github.com/oscerd))
- chore: Add data-type-action Kamelet [\#1328](https://github.com/apache/camel-kamelets/pull/1328) ([christophd](https://github.com/christophd))
- chore: Remove Jitpack [\#1326](https://github.com/apache/camel-kamelets/pull/1326) ([christophd](https://github.com/christophd))
- MQ sink does not map headers from Kafka source [\#1323](https://github.com/apache/camel-kamelets/pull/1323) ([oscerd](https://github.com/oscerd))
- chore: Fix YAKS tests [\#1322](https://github.com/apache/camel-kamelets/pull/1322) ([christophd](https://github.com/christophd))
- Issue-981: Restore optional usage of chatId Configuration Option and correct narrative [\#1318](https://github.com/apache/camel-kamelets/pull/1318) ([manstis](https://github.com/manstis))
- Generated sources regen [\#1317](https://github.com/apache/camel-kamelets/pull/1317) ([github-actions[bot]](https://github.com/apps/github-actions))

## [v3.20.2](https://github.com/apache/camel-kamelets/tree/v3.20.2) (2023-03-01)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v4.0.0-M1...v3.20.2)

**Closed issues:**

- MQ sink does not map headers from Kafka source [\#1321](https://github.com/apache/camel-kamelets/issues/1321)

## [v4.0.0-M1](https://github.com/apache/camel-kamelets/tree/v4.0.0-M1) (2023-02-28)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v3.20.1.1...v4.0.0-M1)

**Closed issues:**

-  Bind variables cannot be used for table names  [\#1310](https://github.com/apache/camel-kamelets/issues/1310)
- Is there any kind of SMT available in camel-kamelets [\#1309](https://github.com/apache/camel-kamelets/issues/1309)
- jms-apache-activemq-sink-binding: error during trait customization: component not found for uri [\#1304](https://github.com/apache/camel-kamelets/issues/1304)
- Add SBOM Generation and related Github Action [\#1292](https://github.com/apache/camel-kamelets/issues/1292)
- Switch Main branch to Camel 4 [\#1287](https://github.com/apache/camel-kamelets/issues/1287)
- Add an annotations to Kamelets to define the level of complexity [\#1267](https://github.com/apache/camel-kamelets/issues/1267)
- Convert all the parameters with multiple possible values to enum [\#1260](https://github.com/apache/camel-kamelets/issues/1260)
- Cassandra Kamelets: add extraTypesCodec parameter [\#1256](https://github.com/apache/camel-kamelets/issues/1256)
- Release 3.20.1.1 [\#1253](https://github.com/apache/camel-kamelets/issues/1253)
- kamelets catalog 3.20.1 contains some SNAPSHOT dependencies [\#1252](https://github.com/apache/camel-kamelets/issues/1252)
- Release 0.9.4 [\#1241](https://github.com/apache/camel-kamelets/issues/1241)
- Kamelet - Parameters that are enum based should have a way to define this in the spec [\#1046](https://github.com/apache/camel-kamelets/issues/1046)
- Steps in KameletBinding accept also non-action kamelets resources [\#741](https://github.com/apache/camel-kamelets/issues/741)
- Kamelet for ElasticSearch Sink provides no mechanism to set indexId or ce-indexId [\#673](https://github.com/apache/camel-kamelets/issues/673)
- Add a "namespace" label to help group kamelets [\#640](https://github.com/apache/camel-kamelets/issues/640)

**Merged pull requests:**

- Release should be set to JDK17 [\#1316](https://github.com/apache/camel-kamelets/pull/1316) ([oscerd](https://github.com/oscerd))
- Regen [\#1315](https://github.com/apache/camel-kamelets/pull/1315) ([oscerd](https://github.com/oscerd))
- Upgrade PostgreSQL driver to version 42.5.4 [\#1314](https://github.com/apache/camel-kamelets/pull/1314) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1311](https://github.com/apache/camel-kamelets/pull/1311) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen [\#1306](https://github.com/apache/camel-kamelets/pull/1306) ([github-actions[bot]](https://github.com/apps/github-actions))
- Issue-981: Improve narrative for chatId. [\#1305](https://github.com/apache/camel-kamelets/pull/1305) ([manstis](https://github.com/manstis))
- Generated sources regen for SBOM [\#1303](https://github.com/apache/camel-kamelets/pull/1303) ([github-actions[bot]](https://github.com/apps/github-actions))
- Add a "namespace" label to help group kamelets  [\#1302](https://github.com/apache/camel-kamelets/pull/1302) ([oscerd](https://github.com/oscerd))
- Generated sources regen for SBOM [\#1298](https://github.com/apache/camel-kamelets/pull/1298) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen for SBOM [\#1297](https://github.com/apache/camel-kamelets/pull/1297) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen for SBOM [\#1296](https://github.com/apache/camel-kamelets/pull/1296) ([github-actions[bot]](https://github.com/apps/github-actions))
- Added SBOM generation action [\#1295](https://github.com/apache/camel-kamelets/pull/1295) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#1294](https://github.com/apache/camel-kamelets/pull/1294) ([github-actions[bot]](https://github.com/apps/github-actions))
- Added SBOM generation to camel-kamelets [\#1293](https://github.com/apache/camel-kamelets/pull/1293) ([oscerd](https://github.com/oscerd))
- Convert all the parameters with multiple possible values to enum  [\#1291](https://github.com/apache/camel-kamelets/pull/1291) ([oscerd](https://github.com/oscerd))
- Switch Main branch to Camel 4 [\#1288](https://github.com/apache/camel-kamelets/pull/1288) ([oscerd](https://github.com/oscerd))
- Convert all the parameters with multiple possible values to enum - FTP/FTPS Source [\#1286](https://github.com/apache/camel-kamelets/pull/1286) ([oscerd](https://github.com/oscerd))
- Convert all the parameters with multiple possible values to enum - Fhir Source [\#1283](https://github.com/apache/camel-kamelets/pull/1283) ([oscerd](https://github.com/oscerd))
- Convert all the parameters with multiple possible values to enum - Cassandra  [\#1282](https://github.com/apache/camel-kamelets/pull/1282) ([oscerd](https://github.com/oscerd))
- Convert all the parameters with multiple possible values to enum - Azure Storage Blob CDC [\#1279](https://github.com/apache/camel-kamelets/pull/1279) ([oscerd](https://github.com/oscerd))
- Convert all the parameters with multiple possible values to enum - Azure Servicebus Source [\#1278](https://github.com/apache/camel-kamelets/pull/1278) ([oscerd](https://github.com/oscerd))
- Convert all the parameters with multiple possible values to enum - Azure Storage Blob [\#1272](https://github.com/apache/camel-kamelets/pull/1272) ([oscerd](https://github.com/oscerd))
- Convert all the parameters with multiple possible values to enum - Azure Storage Blob Changefeed [\#1270](https://github.com/apache/camel-kamelets/pull/1270) ([oscerd](https://github.com/oscerd))
- chore: Fix flaky AWS DDB sink YAKS tests [\#1268](https://github.com/apache/camel-kamelets/pull/1268) ([christophd](https://github.com/christophd))
- Convert all the parameters with multiple possible values to enum - Azure Storage Blob CDC [\#1266](https://github.com/apache/camel-kamelets/pull/1266) ([oscerd](https://github.com/oscerd))
- Convert all the parameters with multiple possible values to enum - AWS Translate [\#1264](https://github.com/apache/camel-kamelets/pull/1264) ([oscerd](https://github.com/oscerd))
- Convert all the parameters with multiple possible values to enum - AWS Translate [\#1261](https://github.com/apache/camel-kamelets/pull/1261) ([oscerd](https://github.com/oscerd))
- Cassandra Kamelets: add extraTypesCodec parameter  [\#1258](https://github.com/apache/camel-kamelets/pull/1258) ([oscerd](https://github.com/oscerd))
- chore: Fix YAKS tests [\#1255](https://github.com/apache/camel-kamelets/pull/1255) ([christophd](https://github.com/christophd))
- Added ssl support to mongodb kamelets. [\#1251](https://github.com/apache/camel-kamelets/pull/1251) ([valdar](https://github.com/valdar))
- Kafka secured kamelets: Fixed description [\#1249](https://github.com/apache/camel-kamelets/pull/1249) ([oscerd](https://github.com/oscerd))
- Kafka SCRAM kamelets: Fixed description [\#1248](https://github.com/apache/camel-kamelets/pull/1248) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#1247](https://github.com/apache/camel-kamelets/pull/1247) ([github-actions[bot]](https://github.com/apps/github-actions))
- KafkaKameletsWithScram512 [\#1245](https://github.com/apache/camel-kamelets/pull/1245) ([mthirion](https://github.com/mthirion))
- isolate the verifyHeader method in testSupportedHeaders to allow customizations [\#1243](https://github.com/apache/camel-kamelets/pull/1243) ([claudio4j](https://github.com/claudio4j))
- fix: salesforce update kamelet fix [\#1240](https://github.com/apache/camel-kamelets/pull/1240) ([Matheusafonsouza](https://github.com/Matheusafonsouza))
- Elasticsearch Kamelets: Moving from Camel-Elasticsearch-Rest to Camel-Elastichsearch - Index Kamelet [\#1239](https://github.com/apache/camel-kamelets/pull/1239) ([oscerd](https://github.com/oscerd))
- Elasticsearch Kamelets: Moving from Camel-Elasticsearch-Rest to Camel-Elastichsearch - Search Kamelet [\#1238](https://github.com/apache/camel-kamelets/pull/1238) ([oscerd](https://github.com/oscerd))
- Next is 3.21.0-SNAPSHOT [\#1237](https://github.com/apache/camel-kamelets/pull/1237) ([oscerd](https://github.com/oscerd))
- Elasticsearch Kamelets: Moving from Camel-Elasticsearch-Rest to Camel-Elastichsearch - Index Kamelet [\#1236](https://github.com/apache/camel-kamelets/pull/1236) ([oscerd](https://github.com/oscerd))
- Upgrade to Camel 3.20.1 [\#1232](https://github.com/apache/camel-kamelets/pull/1232) ([oscerd](https://github.com/oscerd))

## [v3.20.1.1](https://github.com/apache/camel-kamelets/tree/v3.20.1.1) (2023-01-26)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v0.9.4...v3.20.1.1)

## [v0.9.4](https://github.com/apache/camel-kamelets/tree/v0.9.4) (2023-01-24)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v3.20.1...v0.9.4)

**Closed issues:**

- Elasticsearch Kamelets: Moving from Camel-Elasticsearch-Rest to Camel-Elastichsearch [\#1235](https://github.com/apache/camel-kamelets/issues/1235)
- Release 3.20.1 [\#1234](https://github.com/apache/camel-kamelets/issues/1234)

## [v3.20.1](https://github.com/apache/camel-kamelets/tree/v3.20.1) (2023-01-10)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v3.20.0...v3.20.1)

**Closed issues:**

- Upgrade to Camel 3.20.1 [\#1231](https://github.com/apache/camel-kamelets/issues/1231)
- Errors with log-sink and log-action Kamelet [\#1227](https://github.com/apache/camel-kamelets/issues/1227)

## [v3.20.0](https://github.com/apache/camel-kamelets/tree/v3.20.0) (2022-12-21)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v0.10.0...v3.20.0)

**Closed issues:**

- Use a semantic version instead of `main-SNAPSHOT` [\#1218](https://github.com/apache/camel-kamelets/issues/1218)
- Google Pubsub Kamelets: Make serviceAccountKey optional [\#1214](https://github.com/apache/camel-kamelets/issues/1214)
- Version alignment: Align the camel-kamelets project version to the camel core version [\#1211](https://github.com/apache/camel-kamelets/issues/1211)
- Slack Source Kamelet: Set default delay to 1 minute [\#1207](https://github.com/apache/camel-kamelets/issues/1207)
- Documentation. Can Kamelet pull dependencies from private artifactory? [\#1205](https://github.com/apache/camel-kamelets/issues/1205)
- MQTT source kamelet does not include topic [\#1204](https://github.com/apache/camel-kamelets/issues/1204)
- google-storage-sink serviceAccountKey is not required [\#1203](https://github.com/apache/camel-kamelets/issues/1203)
- RAW does not seem to work in Kamelet [\#1200](https://github.com/apache/camel-kamelets/issues/1200)
- Log sink should show streams by default [\#1198](https://github.com/apache/camel-kamelets/issues/1198)
- Camel Google Pubsub headers names changed in Camel 3.20.0 [\#1194](https://github.com/apache/camel-kamelets/issues/1194)
- Release 0.10.0 [\#1128](https://github.com/apache/camel-kamelets/issues/1128)
- aws-ddb-sink-binding doesn't send data to DynamoDB [\#1038](https://github.com/apache/camel-kamelets/issues/1038)
- Add Camel test for the beans used in some of the Kamelet action [\#730](https://github.com/apache/camel-kamelets/issues/730)

**Merged pull requests:**

- Point to 3.20.0 since it has been released [\#1229](https://github.com/apache/camel-kamelets/pull/1229) ([oscerd](https://github.com/oscerd))
- 3.20.0-SNAPSHOT upgrade, until 3.20.0 will be released [\#1225](https://github.com/apache/camel-kamelets/pull/1225) ([oscerd](https://github.com/oscerd))
- Upgrade Activemq-http to version 5.17.3 [\#1224](https://github.com/apache/camel-kamelets/pull/1224) ([oscerd](https://github.com/oscerd))
- Upgrade Artemis to version 2.27.1 [\#1223](https://github.com/apache/camel-kamelets/pull/1223) ([oscerd](https://github.com/oscerd))
- Added a Deploy action on push [\#1222](https://github.com/apache/camel-kamelets/pull/1222) ([oscerd](https://github.com/oscerd))
- Version alignment: Align the camel-kamelets project version to the camel core version [\#1221](https://github.com/apache/camel-kamelets/pull/1221) ([oscerd](https://github.com/oscerd))
- Add FHIR sink kamelet [\#1219](https://github.com/apache/camel-kamelets/pull/1219) ([bramplouvier](https://github.com/bramplouvier))
- fixed Azure Storage Blob changefeed source connector [\#1217](https://github.com/apache/camel-kamelets/pull/1217) ([valdar](https://github.com/valdar))
- Upgrade Redshift Jdbc42 to version 2.1.0.10 [\#1216](https://github.com/apache/camel-kamelets/pull/1216) ([oscerd](https://github.com/oscerd))
- Google pubsub optional service account key [\#1215](https://github.com/apache/camel-kamelets/pull/1215) ([oscerd](https://github.com/oscerd))
- Log sink and log action should show streams by default [\#1213](https://github.com/apache/camel-kamelets/pull/1213) ([oscerd](https://github.com/oscerd))
- Camel Google Pubsub headers names changed in Camel 3.20.0 [\#1212](https://github.com/apache/camel-kamelets/pull/1212) ([oscerd](https://github.com/oscerd))
- Slack Source Kamelet: Set default delay to 1 minute [\#1208](https://github.com/apache/camel-kamelets/pull/1208) ([oscerd](https://github.com/oscerd))
- Google Storage Source/Sink Kamelet: serviceAccountKey is not required [\#1206](https://github.com/apache/camel-kamelets/pull/1206) ([oscerd](https://github.com/oscerd))

## [v0.10.0](https://github.com/apache/camel-kamelets/tree/v0.10.0) (2022-12-05)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v0.9.3...v0.10.0)

**Closed issues:**

- Add a Google Cloud Storage CDC Source Kamelet [\#1188](https://github.com/apache/camel-kamelets/issues/1188)
- Add an Azure Storage Blob CDC Source Kamelet [\#1185](https://github.com/apache/camel-kamelets/issues/1185)
- Azure Storage Blob Sink Kamelet: Add it-test [\#1182](https://github.com/apache/camel-kamelets/issues/1182)
- Add delay parameter to all SQL Source Kamelets [\#1161](https://github.com/apache/camel-kamelets/issues/1161)
- Azure Storage Blob Changefeed Source Kamelet: Add CredentialType to parameters [\#1158](https://github.com/apache/camel-kamelets/issues/1158)
- SFTP / SCP connectors missing authentication options to use a private key [\#1157](https://github.com/apache/camel-kamelets/issues/1157)
- FTP / SFTP connectors missing setting for binary mode transfers [\#1156](https://github.com/apache/camel-kamelets/issues/1156)
- Add a JQ Action [\#1153](https://github.com/apache/camel-kamelets/issues/1153)
- IT Tests: Add Tests for Kinesis Firehose [\#1151](https://github.com/apache/camel-kamelets/issues/1151)
- IT Tests: Add tests for AWS SNS [\#1150](https://github.com/apache/camel-kamelets/issues/1150)
- IT Tests: make terraform configuration more stable [\#1149](https://github.com/apache/camel-kamelets/issues/1149)
- Integration tests based on camel-jbang [\#1147](https://github.com/apache/camel-kamelets/issues/1147)
- Release 0.9.3 [\#1129](https://github.com/apache/camel-kamelets/issues/1129)
- Nats Kamelets: Mark servers as secret parameter since it could contains sensitive data if authenticated [\#1086](https://github.com/apache/camel-kamelets/issues/1086)
- Support key authentication in sftp kamelet [\#778](https://github.com/apache/camel-kamelets/issues/778)

**Merged pull requests:**

- Azure Storage Blob CDC: Add RAW to toD accessKey parameter [\#1201](https://github.com/apache/camel-kamelets/pull/1201) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#1199](https://github.com/apache/camel-kamelets/pull/1199) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen [\#1197](https://github.com/apache/camel-kamelets/pull/1197) ([github-actions[bot]](https://github.com/apps/github-actions))
- Review level support 0.10.x [\#1195](https://github.com/apache/camel-kamelets/pull/1195) ([oscerd](https://github.com/oscerd))
- CDC Source Kamelets for AWS S3, Azure Storage Blob and Google Storage are in a Preview state [\#1193](https://github.com/apache/camel-kamelets/pull/1193) ([oscerd](https://github.com/oscerd))
- Added Microsoft Exchange IMAP OAUTH source kamelet [\#1192](https://github.com/apache/camel-kamelets/pull/1192) ([luigidemasi](https://github.com/luigidemasi))
- Add a Google Cloud Storage CDC Source Kamelet - Remove useless logging [\#1191](https://github.com/apache/camel-kamelets/pull/1191) ([oscerd](https://github.com/oscerd))
- Azure Storage Blob CDC Source Kamelet: Parameter is getBlob and not getObject [\#1190](https://github.com/apache/camel-kamelets/pull/1190) ([oscerd](https://github.com/oscerd))
- Add a Google Cloud Storage CDC Source Kamelet [\#1189](https://github.com/apache/camel-kamelets/pull/1189) ([oscerd](https://github.com/oscerd))
- Add an Azure Storage Blob CDC Source Kamelet - Fix description [\#1187](https://github.com/apache/camel-kamelets/pull/1187) ([oscerd](https://github.com/oscerd))
- Add an Azure Storage Blob CDC Source Kamelet [\#1186](https://github.com/apache/camel-kamelets/pull/1186) ([oscerd](https://github.com/oscerd))
- Added repeatCount parameter to timer source Kamelet [\#1184](https://github.com/apache/camel-kamelets/pull/1184) ([oscerd](https://github.com/oscerd))
- Azure Storage Blob Sink Kamelet: Add it-test to Makefile [\#1183](https://github.com/apache/camel-kamelets/pull/1183) ([oscerd](https://github.com/oscerd))
- Fix mail-sink Kamelet [\#1181](https://github.com/apache/camel-kamelets/pull/1181) ([christophd](https://github.com/christophd))
- Added an Azure Storage Blob Source It Test [\#1180](https://github.com/apache/camel-kamelets/pull/1180) ([oscerd](https://github.com/oscerd))
- Added an it-tests for AWS S3 CDC [\#1179](https://github.com/apache/camel-kamelets/pull/1179) ([oscerd](https://github.com/oscerd))
- Upgrade Jackson to version 2.14.1 [\#1178](https://github.com/apache/camel-kamelets/pull/1178) ([oscerd](https://github.com/oscerd))
- Upgrade ActiveMQ Artemis to version 2.27.0 [\#1177](https://github.com/apache/camel-kamelets/pull/1177) ([oscerd](https://github.com/oscerd))
- Upgrade PostgreSQL driver to version 42.5.1 [\#1176](https://github.com/apache/camel-kamelets/pull/1176) ([oscerd](https://github.com/oscerd))
- SCP Sink IT Test [\#1175](https://github.com/apache/camel-kamelets/pull/1175) ([oscerd](https://github.com/oscerd))
- It-Tests Makefile: Add specific targets for different kind of it-tests [\#1174](https://github.com/apache/camel-kamelets/pull/1174) ([oscerd](https://github.com/oscerd))
- SCP connector missing authentication options to use a private key [\#1172](https://github.com/apache/camel-kamelets/pull/1172) ([oscerd](https://github.com/oscerd))
- Added it-test for SFTP Sink [\#1171](https://github.com/apache/camel-kamelets/pull/1171) ([oscerd](https://github.com/oscerd))
- SFTP / SCP connectors missing authentication options to use a private key [\#1170](https://github.com/apache/camel-kamelets/pull/1170) ([oscerd](https://github.com/oscerd))
- Upgrade Classgraph to version 4.8.151 [\#1168](https://github.com/apache/camel-kamelets/pull/1168) ([oscerd](https://github.com/oscerd))
- JSLT Action - Fix too many slashes in example of template [\#1167](https://github.com/apache/camel-kamelets/pull/1167) ([tadayosi](https://github.com/tadayosi))
- FTP / SFTP connectors missing setting for binary mode transfers [\#1165](https://github.com/apache/camel-kamelets/pull/1165) ([oscerd](https://github.com/oscerd))
- Add delay parameter to all SQL Source Kamelets [\#1163](https://github.com/apache/camel-kamelets/pull/1163) ([oscerd](https://github.com/oscerd))
- chore: Introduce Kamelet input/output data types [\#1162](https://github.com/apache/camel-kamelets/pull/1162) ([christophd](https://github.com/christophd))
- Azure Storage Blob Changefeed Source Kamelet: Add CredentialType to parameters [\#1159](https://github.com/apache/camel-kamelets/pull/1159) ([oscerd](https://github.com/oscerd))
- Kinesis Firehose Sink IT Test [\#1155](https://github.com/apache/camel-kamelets/pull/1155) ([oscerd](https://github.com/oscerd))
- IT Tests: Add tests for AWS SNS [\#1152](https://github.com/apache/camel-kamelets/pull/1152) ([oscerd](https://github.com/oscerd))
- Support more properties for Log Sink/Action Kamelets [\#1148](https://github.com/apache/camel-kamelets/pull/1148) ([tadayosi](https://github.com/tadayosi))
- Add Makefile for install, generate, and validate [\#1145](https://github.com/apache/camel-kamelets/pull/1145) ([tadayosi](https://github.com/tadayosi))
- Add Log Action Kamelet [\#1144](https://github.com/apache/camel-kamelets/pull/1144) ([tadayosi](https://github.com/tadayosi))
- Add level property to Log Sink [\#1142](https://github.com/apache/camel-kamelets/pull/1142) ([tadayosi](https://github.com/tadayosi))
- Nats Kamelets: Mark servers as secret parameter since it could contains sensitive data if authenticated [\#1140](https://github.com/apache/camel-kamelets/pull/1140) ([oscerd](https://github.com/oscerd))
- Fixed name of upload-source script in README [\#1139](https://github.com/apache/camel-kamelets/pull/1139) ([oscerd](https://github.com/oscerd))
- aws-s3-sink kamelet ignores keyName property [\#1136](https://github.com/apache/camel-kamelets/pull/1136) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#1135](https://github.com/apache/camel-kamelets/pull/1135) ([github-actions[bot]](https://github.com/apps/github-actions))
- Create an AWS S3 CDC Source Kamelet [\#1134](https://github.com/apache/camel-kamelets/pull/1134) ([oscerd](https://github.com/oscerd))
- AWS Cloudtrail Source Kamelet: Add an eventsource parameter [\#1132](https://github.com/apache/camel-kamelets/pull/1132) ([oscerd](https://github.com/oscerd))
- Azure Storage Blob Source Kamelet: Add a deleteAfterRead parameter [\#1126](https://github.com/apache/camel-kamelets/pull/1126) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#1125](https://github.com/apache/camel-kamelets/pull/1125) ([github-actions[bot]](https://github.com/apps/github-actions))
- Azure Storage Blob Source Kamelet: Add a deleteAfterRead parameter [\#1124](https://github.com/apache/camel-kamelets/pull/1124) ([oscerd](https://github.com/oscerd))
- Azure Storage Blob Source Kamelet: Add a delay parameter [\#1122](https://github.com/apache/camel-kamelets/pull/1122) ([oscerd](https://github.com/oscerd))
- SQL Server Sink and Source: with 11.2.0.jre11 there are troubles connecting to SQL Server [\#1114](https://github.com/apache/camel-kamelets/pull/1114) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#1111](https://github.com/apache/camel-kamelets/pull/1111) ([github-actions[bot]](https://github.com/apps/github-actions))
- Google Functions: use base64 for service account key [\#1109](https://github.com/apache/camel-kamelets/pull/1109) ([rinaldodev](https://github.com/rinaldodev))
- Generated sources regen [\#1107](https://github.com/apache/camel-kamelets/pull/1107) ([github-actions[bot]](https://github.com/apps/github-actions))
- azure-eventhubs-sink: remove hardcoded jackson dependencies [\#1106](https://github.com/apache/camel-kamelets/pull/1106) ([lburgazzoli](https://github.com/lburgazzoli))
- Salesforce Source Kamelet - Add operationName as parameter with subscribe as default value [\#1105](https://github.com/apache/camel-kamelets/pull/1105) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#1104](https://github.com/apache/camel-kamelets/pull/1104) ([github-actions[bot]](https://github.com/apps/github-actions))
- Add AWS CloudTrail Source Kamelet [\#1103](https://github.com/apache/camel-kamelets/pull/1103) ([oscerd](https://github.com/oscerd))
- Kamelet Scheme method in catalog [\#1102](https://github.com/apache/camel-kamelets/pull/1102) ([oscerd](https://github.com/oscerd))
-  Added a Catalog Method showing the supported headers \(specific for consumer, producer and common\) for a Kamelet [\#1101](https://github.com/apache/camel-kamelets/pull/1101) ([oscerd](https://github.com/oscerd))
- Added a Catalog Method showing the supported headers \(specific for consumer, producer and common\) for a Kamelet [\#1100](https://github.com/apache/camel-kamelets/pull/1100) ([oscerd](https://github.com/oscerd))
- Added a Catalog Method showing the supported headers \(specific for consumer, producer and common\) for a Kamelet  [\#1099](https://github.com/apache/camel-kamelets/pull/1099) ([oscerd](https://github.com/oscerd))
- Added a Catalog Method showing the supported headers \(specific for co… [\#1098](https://github.com/apache/camel-kamelets/pull/1098) ([oscerd](https://github.com/oscerd))
- Added a Catalog Method showing the supported headers \(specific for consumer, producer and common\) for a Kamelet  [\#1097](https://github.com/apache/camel-kamelets/pull/1097) ([oscerd](https://github.com/oscerd))
- Added a Catalog Method showing the supported headers \(specific for consumer, producer and common\) for a Kamelet  [\#1096](https://github.com/apache/camel-kamelets/pull/1096) ([oscerd](https://github.com/oscerd))
- Added a Catalog Method showing the supported headers \(specific for consumer, producer and common\) for a Kamelet [\#1095](https://github.com/apache/camel-kamelets/pull/1095) ([oscerd](https://github.com/oscerd))
- Added a Catalog Method showing the supported headers \(specific for consumer, producer and common\) for a Kamelet [\#1094](https://github.com/apache/camel-kamelets/pull/1094) ([oscerd](https://github.com/oscerd))
- Improve KAFKA SSL source [\#1093](https://github.com/apache/camel-kamelets/pull/1093) ([MarcoMartins86](https://github.com/MarcoMartins86))
- Added a Catalog Method showing the supported headers \(specific for consumer, producer and common\) for a Kamelet [\#1092](https://github.com/apache/camel-kamelets/pull/1092) ([oscerd](https://github.com/oscerd))
- Added a Catalog Method showing the supported headers \(specific for consumer, producer and common\) for a Kamelet - Azure [\#1091](https://github.com/apache/camel-kamelets/pull/1091) ([oscerd](https://github.com/oscerd))
- Added a Catalog Method showing the supported headers \(specific for co… [\#1090](https://github.com/apache/camel-kamelets/pull/1090) ([oscerd](https://github.com/oscerd))
- Added a Catalog Method showing the supported headers \(specific for consumer, producer and common\) for a Kamelet [\#1089](https://github.com/apache/camel-kamelets/pull/1089) ([oscerd](https://github.com/oscerd))
- Duplicate some of headers with a different name - Azure Storage Blob Source [\#1087](https://github.com/apache/camel-kamelets/pull/1087) ([oscerd](https://github.com/oscerd))
- Switch Azure Storage Blob Source from timer producer style to a pure consumer [\#1084](https://github.com/apache/camel-kamelets/pull/1084) ([oscerd](https://github.com/oscerd))
- Duplicate some of headers with a different name - Azure Storage Queue Source [\#1082](https://github.com/apache/camel-kamelets/pull/1082) ([oscerd](https://github.com/oscerd))
- Fixed dependencies from kamelets-utils [\#1081](https://github.com/apache/camel-kamelets/pull/1081) ([oscerd](https://github.com/oscerd))
- Upgrade ActiveMQ Http to version 5.17.2 [\#1080](https://github.com/apache/camel-kamelets/pull/1080) ([oscerd](https://github.com/oscerd))
- Fix keyName condition [\#1079](https://github.com/apache/camel-kamelets/pull/1079) ([claudio4j](https://github.com/claudio4j))
- Duplicate some of headers with a different name - AWS Kinesis Source [\#1078](https://github.com/apache/camel-kamelets/pull/1078) ([oscerd](https://github.com/oscerd))
- Added some documentation in kafka not secured sink about headers deduplication [\#1077](https://github.com/apache/camel-kamelets/pull/1077) ([oscerd](https://github.com/oscerd))
- fix ceph-source attributes [\#1076](https://github.com/apache/camel-kamelets/pull/1076) ([claudio4j](https://github.com/claudio4j))
- Adding a bean to deduplicate headers [\#1073](https://github.com/apache/camel-kamelets/pull/1073) ([oscerd](https://github.com/oscerd))
- Duplicate some of headers with a different name - AWS SQS Source [\#1072](https://github.com/apache/camel-kamelets/pull/1072) ([oscerd](https://github.com/oscerd))
- AWS SQS Source Kamelet: Add greedy parameter [\#1070](https://github.com/apache/camel-kamelets/pull/1070) ([oscerd](https://github.com/oscerd))
- RabbitMQ Source Kamelet: Add a vhost parameter [\#1068](https://github.com/apache/camel-kamelets/pull/1068) ([oscerd](https://github.com/oscerd))
- Upgrade to Camel 3.19.0 [\#1066](https://github.com/apache/camel-kamelets/pull/1066) ([oscerd](https://github.com/oscerd))
- Google BigQuery Sink Kamelet: Use ServiceAccountKey parameter instead of forming a connectionFactoryBean [\#1065](https://github.com/apache/camel-kamelets/pull/1065) ([oscerd](https://github.com/oscerd))
- Azure Storage Blob Kamelets should specify which kind of credentials to use [\#1062](https://github.com/apache/camel-kamelets/pull/1062) ([oscerd](https://github.com/oscerd))
- Elasticsearch-search-source won't let me define basic authentication [\#1057](https://github.com/apache/camel-kamelets/pull/1057) ([oscerd](https://github.com/oscerd))
- Upgrade Log4j to version 2.19.0 [\#1055](https://github.com/apache/camel-kamelets/pull/1055) ([oscerd](https://github.com/oscerd))
- Upgrade Depedencies: Camel-K Kubernetes-client extension and Junit Jupiter [\#1054](https://github.com/apache/camel-kamelets/pull/1054) ([oscerd](https://github.com/oscerd))
- Upgrade Artemis to version 2.26.0 [\#1053](https://github.com/apache/camel-kamelets/pull/1053) ([oscerd](https://github.com/oscerd))
- Upgrade Jackson to version 2.13.4 [\#1052](https://github.com/apache/camel-kamelets/pull/1052) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#1049](https://github.com/apache/camel-kamelets/pull/1049) ([github-actions[bot]](https://github.com/apps/github-actions))
- minio: do not convert source payload to json [\#1048](https://github.com/apache/camel-kamelets/pull/1048) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove Kamelet from name as we do not use that, so its just XXX Sink … [\#1045](https://github.com/apache/camel-kamelets/pull/1045) ([davsclaus](https://github.com/davsclaus))
- Fix chuck-norris kamelet to use a new online service that works. [\#1043](https://github.com/apache/camel-kamelets/pull/1043) ([davsclaus](https://github.com/davsclaus))
- Azure Eventhubs Sink - partition parameter [\#1039](https://github.com/apache/camel-kamelets/pull/1039) ([oscerd](https://github.com/oscerd))
- Upgrade to Camel 3.19.0: Remove AWS SDK Utils from AWS Kamelets [\#1036](https://github.com/apache/camel-kamelets/pull/1036) ([oscerd](https://github.com/oscerd))
- Azure Eventhubs Source Kamelet: Return raw data instead of transforming to json [\#1035](https://github.com/apache/camel-kamelets/pull/1035) ([oscerd](https://github.com/oscerd))
- Upgrade to Camel 3.18.2 [\#1033](https://github.com/apache/camel-kamelets/pull/1033) ([oscerd](https://github.com/oscerd))
- Salesforce Source: Specify NotifyFor.. parameters as configurable instead than having hardcoded [\#1028](https://github.com/apache/camel-kamelets/pull/1028) ([oscerd](https://github.com/oscerd))
- AWS region enum updated for AWS Kamelets [\#1026](https://github.com/apache/camel-kamelets/pull/1026) ([oscerd](https://github.com/oscerd))
- AWS S3 Streaming Upload: Remove StreamingUploadMode parameter since it is true by default [\#1025](https://github.com/apache/camel-kamelets/pull/1025) ([oscerd](https://github.com/oscerd))
- Kamelets release improvements [\#1023](https://github.com/apache/camel-kamelets/pull/1023) ([oscerd](https://github.com/oscerd))
- \[GoogleStorage\] Fix description typo [\#1022](https://github.com/apache/camel-kamelets/pull/1022) ([avano](https://github.com/avano))
- Added RegexRouter action test [\#1021](https://github.com/apache/camel-kamelets/pull/1021) ([oscerd](https://github.com/oscerd))
- More replace field tests [\#1019](https://github.com/apache/camel-kamelets/pull/1019) ([oscerd](https://github.com/oscerd))
- Added ReplaceField Test [\#1018](https://github.com/apache/camel-kamelets/pull/1018) ([oscerd](https://github.com/oscerd))
- Activemq http 5.17.1 Upgrade [\#1017](https://github.com/apache/camel-kamelets/pull/1017) ([oscerd](https://github.com/oscerd))
- Artemis 2.24.0 Upgrade  [\#1016](https://github.com/apache/camel-kamelets/pull/1016) ([oscerd](https://github.com/oscerd))
- Postgresql 42.5.0 Upgrade [\#1015](https://github.com/apache/camel-kamelets/pull/1015) ([oscerd](https://github.com/oscerd))
- Added HoistField Action Test [\#1014](https://github.com/apache/camel-kamelets/pull/1014) ([oscerd](https://github.com/oscerd))
- More MaskField test and regen [\#1013](https://github.com/apache/camel-kamelets/pull/1013) ([oscerd](https://github.com/oscerd))
- Added a Mask Field test for Action [\#1012](https://github.com/apache/camel-kamelets/pull/1012) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#1010](https://github.com/apache/camel-kamelets/pull/1010) ([github-actions[bot]](https://github.com/apps/github-actions))

## [v0.9.3](https://github.com/apache/camel-kamelets/tree/v0.9.3) (2022-11-04)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v0.9.2...v0.9.3)

**Closed issues:**

- Create an AWS S3 CDC Source Kamelet [\#1133](https://github.com/apache/camel-kamelets/issues/1133)
- aws-s3-sink kamelet ignores keyName property [\#1131](https://github.com/apache/camel-kamelets/issues/1131)
- AWS Cloudtrail Source Kamelet: Add an eventsource parameter [\#1130](https://github.com/apache/camel-kamelets/issues/1130)
- Azure Storage Blob Source Kamelet: Switch from timer to pure consumer implementation \(0.9.x\) [\#1120](https://github.com/apache/camel-kamelets/issues/1120)
- Azure Storage Blob Source: Add a deleteAfterRead parameter [\#1119](https://github.com/apache/camel-kamelets/issues/1119)
- Azure Storage Blob Source Kamelet: Add a delay parameter [\#1118](https://github.com/apache/camel-kamelets/issues/1118)
- Azure Storage Blob Kamelets: Specify the kind of the authentication \(0.9.x\) [\#1117](https://github.com/apache/camel-kamelets/issues/1117)
- SQL Server Sink and Source: When using driver \>= 11.0 the jdbc connection fails [\#1113](https://github.com/apache/camel-kamelets/issues/1113)
- Release 0.9.2 [\#1110](https://github.com/apache/camel-kamelets/issues/1110)

## [v0.9.2](https://github.com/apache/camel-kamelets/tree/v0.9.2) (2022-10-26)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v0.9.1...v0.9.2)

**Closed issues:**

- Kafka SSL SCRAM Login [\#1085](https://github.com/apache/camel-kamelets/issues/1085)
- Azure Storage Blob Source Kamelet: Switch from the current implementation to real consumer [\#1083](https://github.com/apache/camel-kamelets/issues/1083)
- AWS SQS Source Kamelet: Add greedy parameter [\#1069](https://github.com/apache/camel-kamelets/issues/1069)
- Salesforce kamelet - Adjust for Camel 3.19.x [\#998](https://github.com/apache/camel-kamelets/issues/998)
- Add AWS CloudTrail Source Kamelet [\#993](https://github.com/apache/camel-kamelets/issues/993)

## [v0.9.1](https://github.com/apache/camel-kamelets/tree/v0.9.1) (2022-10-05)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v0.9.0...v0.9.1)

**Closed issues:**

- RabbitMQ Source Kamelet: Add a vhost parameter [\#1067](https://github.com/apache/camel-kamelets/issues/1067)
- Azure Storage Blob Kamelets should specify which kind of credentials to use [\#1061](https://github.com/apache/camel-kamelets/issues/1061)
- elasticsearch-search-source won't let me define basic authentication [\#1056](https://github.com/apache/camel-kamelets/issues/1056)
- Upgrade to Artemis 2.25.x [\#1047](https://github.com/apache/camel-kamelets/issues/1047)
- chuck-norris-kamelet HTTP error code 500 [\#1042](https://github.com/apache/camel-kamelets/issues/1042)
- Backport https://github.com/apache/camel-kamelets/pull/1030 to 0.9.x [\#1040](https://github.com/apache/camel-kamelets/issues/1040)
- Google BigQuery Sink Kamelet: Use ServiceAccountKey parameter instead of forming a connectionFactoryBean  [\#1037](https://github.com/apache/camel-kamelets/issues/1037)
- Upgrade to Camel 3.18.2 [\#1032](https://github.com/apache/camel-kamelets/issues/1032)
- Azure Eventhubs Source Kamelet: Return raw data instead of transforming to json  [\#1031](https://github.com/apache/camel-kamelets/issues/1031)
- Salesforce Source: Specify NotifyFor.. parameters as configurable instead than having hardcoded [\#1027](https://github.com/apache/camel-kamelets/issues/1027)
- AWS S3 Streaming Upload: Remove StreamingUploadMode parameter since it is true by default [\#1024](https://github.com/apache/camel-kamelets/issues/1024)
- Upgrade to Camel 3.19.0: Remove AWS SDK Utils from AWS Kamelets [\#1011](https://github.com/apache/camel-kamelets/issues/1011)
- Azure Eventhubs Sink - partition parameter [\#1005](https://github.com/apache/camel-kamelets/issues/1005)
- google-bigquery-sink credential file didn't read from my local [\#959](https://github.com/apache/camel-kamelets/issues/959)
- Add supported runtime and platforms to documentation [\#428](https://github.com/apache/camel-kamelets/issues/428)

## [v0.9.0](https://github.com/apache/camel-kamelets/tree/v0.9.0) (2022-08-24)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v0.8.1...v0.9.0)

**Closed issues:**

- AWS Kamelets: Explicitly add AWS SDK Utils dependency [\#1008](https://github.com/apache/camel-kamelets/issues/1008)
- Add Ceph kamelets [\#1003](https://github.com/apache/camel-kamelets/issues/1003)
- SFTP Kamelet Source: Support ignoreFileNotFoundOrPermissionError parameter [\#994](https://github.com/apache/camel-kamelets/issues/994)
- Add an AWS Eventbridge Sink Kamelet [\#986](https://github.com/apache/camel-kamelets/issues/986)
- Reopen of \#962 - ISSUE WITH KAMELET azure-servicebus-source output is message length instead of message [\#980](https://github.com/apache/camel-kamelets/issues/980)
- Add Azure Functions Sink Kamelet [\#972](https://github.com/apache/camel-kamelets/issues/972)
- Bump to Camel 3.18.0 [\#967](https://github.com/apache/camel-kamelets/issues/967)
- ISSUE WITH KAMELET azure-servicebus-source output is message length instead of message [\#962](https://github.com/apache/camel-kamelets/issues/962)
- Add splunk sources and sinks [\#955](https://github.com/apache/camel-kamelets/issues/955)
- Add Jira sink kamelets [\#952](https://github.com/apache/camel-kamelets/issues/952)
- Revisit support level label for all the Kamelets [\#944](https://github.com/apache/camel-kamelets/issues/944)
- Jira source supporting oauth [\#938](https://github.com/apache/camel-kamelets/issues/938)
- Upgrade to Camel 3.17.0 [\#934](https://github.com/apache/camel-kamelets/issues/934)
- Turn AWS region in an enum [\#932](https://github.com/apache/camel-kamelets/issues/932)
- aws-\* kamelets heve wrton type for aws\_delay property [\#924](https://github.com/apache/camel-kamelets/issues/924)
- Provide some default behavior on Slack sink Kamelet [\#923](https://github.com/apache/camel-kamelets/issues/923)
- Fix IBM MQ kamelets to use general MQConnectionFactory [\#921](https://github.com/apache/camel-kamelets/issues/921)
- Release 0.8.1 [\#920](https://github.com/apache/camel-kamelets/issues/920)
- \[json-serialize-action\] does not work as intended [\#652](https://github.com/apache/camel-kamelets/issues/652)
- Add SCP Sink Kamelet [\#177](https://github.com/apache/camel-kamelets/issues/177)
- Add SCP Source Kamelet [\#176](https://github.com/apache/camel-kamelets/issues/176)
- Add AWS DynamoDB Sink Kamelet [\#142](https://github.com/apache/camel-kamelets/issues/142)
- Add Salesforce sink kamelet [\#124](https://github.com/apache/camel-kamelets/issues/124)
- Add AWS Eventbridge Sink Kamelet [\#119](https://github.com/apache/camel-kamelets/issues/119)
- Add Quartz source kamelet [\#63](https://github.com/apache/camel-kamelets/issues/63)

**Merged pull requests:**

- AWS Kamelets: Explicitly add AWS SDK Utils dependency [\#1009](https://github.com/apache/camel-kamelets/pull/1009) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#1007](https://github.com/apache/camel-kamelets/pull/1007) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen [\#1006](https://github.com/apache/camel-kamelets/pull/1006) ([github-actions[bot]](https://github.com/apps/github-actions))
- Add Ceph kamelets [\#1004](https://github.com/apache/camel-kamelets/pull/1004) ([claudio4j](https://github.com/claudio4j))
- Upgrade to Camel 3.18.1 [\#1002](https://github.com/apache/camel-kamelets/pull/1002) ([davsclaus](https://github.com/davsclaus))
- chore: note on using capped collections [\#1001](https://github.com/apache/camel-kamelets/pull/1001) ([squakez](https://github.com/squakez))
- chore: remove AWS region example from aws definitions as they are now enums [\#1000](https://github.com/apache/camel-kamelets/pull/1000) ([lburgazzoli](https://github.com/lburgazzoli))
- feat: enable raw payload on salesforce create/update kamelets [\#999](https://github.com/apache/camel-kamelets/pull/999) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade Log4J to version 2.18.0 [\#997](https://github.com/apache/camel-kamelets/pull/997) ([oscerd](https://github.com/oscerd))
- Build and Maven dependencies upgrade [\#996](https://github.com/apache/camel-kamelets/pull/996) ([oscerd](https://github.com/oscerd))
- SFTP Kamelet Source: Support ignoreFileNotFoundOrPermissionError parameter [\#995](https://github.com/apache/camel-kamelets/pull/995) ([oscerd](https://github.com/oscerd))
- Upgrade to Artemis 2.23.1 [\#992](https://github.com/apache/camel-kamelets/pull/992) ([davsclaus](https://github.com/davsclaus))
- Generated sources regen [\#991](https://github.com/apache/camel-kamelets/pull/991) ([github-actions[bot]](https://github.com/apps/github-actions))
- Cleaning up docs and reference in AWS Kamelets [\#990](https://github.com/apache/camel-kamelets/pull/990) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#989](https://github.com/apache/camel-kamelets/pull/989) ([github-actions[bot]](https://github.com/apps/github-actions))
- New action that gets features from OGC API server. [\#988](https://github.com/apache/camel-kamelets/pull/988) ([Delawen](https://github.com/Delawen))
- Added AWS Eventbridge Sink Kamelet [\#987](https://github.com/apache/camel-kamelets/pull/987) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#985](https://github.com/apache/camel-kamelets/pull/985) ([github-actions[bot]](https://github.com/apps/github-actions))
- Azure Functions is preview not stable [\#984](https://github.com/apache/camel-kamelets/pull/984) ([oscerd](https://github.com/oscerd))
- ISSUE WITH KAMELET azure-servicebus-source output is message length i… [\#983](https://github.com/apache/camel-kamelets/pull/983) ([oscerd](https://github.com/oscerd))
- Adding a new kamelet that uses the nominatim geocoder [\#982](https://github.com/apache/camel-kamelets/pull/982) ([Delawen](https://github.com/Delawen))
- Generated sources regen [\#979](https://github.com/apache/camel-kamelets/pull/979) ([github-actions[bot]](https://github.com/apps/github-actions))
- tiny typo fix [\#978](https://github.com/apache/camel-kamelets/pull/978) ([kahboom](https://github.com/kahboom))
- Bump Classgraph to version 4.8.149 [\#977](https://github.com/apache/camel-kamelets/pull/977) ([oscerd](https://github.com/oscerd))
- Postgresql driver update to 42.4.0 [\#976](https://github.com/apache/camel-kamelets/pull/976) ([oscerd](https://github.com/oscerd))
- Switch Azure Functions Kamelet to Vertx-HTTP [\#975](https://github.com/apache/camel-kamelets/pull/975) ([oscerd](https://github.com/oscerd))
- Redshift upgrade to 2.1.0.9 [\#974](https://github.com/apache/camel-kamelets/pull/974) ([oscerd](https://github.com/oscerd))
- Azure functions kamelet [\#973](https://github.com/apache/camel-kamelets/pull/973) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#971](https://github.com/apache/camel-kamelets/pull/971) ([github-actions[bot]](https://github.com/apps/github-actions))
-  doc-config-descriptions-2 timer-generator [\#970](https://github.com/apache/camel-kamelets/pull/970) ([MelissaFlinn](https://github.com/MelissaFlinn))
- Missing optional in chatId parameter [\#969](https://github.com/apache/camel-kamelets/pull/969) ([Delawen](https://github.com/Delawen))
- Upgrade Camel version to 3.18.0 [\#968](https://github.com/apache/camel-kamelets/pull/968) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#966](https://github.com/apache/camel-kamelets/pull/966) ([github-actions[bot]](https://github.com/apps/github-actions))
- Update slack source 'Delay' description and example [\#965](https://github.com/apache/camel-kamelets/pull/965) ([jomarko](https://github.com/jomarko))
- Generated sources regen [\#964](https://github.com/apache/camel-kamelets/pull/964) ([github-actions[bot]](https://github.com/apps/github-actions))
- Doc config descriptions [\#963](https://github.com/apache/camel-kamelets/pull/963) ([MelissaFlinn](https://github.com/MelissaFlinn))
- Jira source Kamelet supporting oauth [\#961](https://github.com/apache/camel-kamelets/pull/961) ([oscerd](https://github.com/oscerd))
- Revisit support level label for all the Kamelets - Remaining Kamelets [\#960](https://github.com/apache/camel-kamelets/pull/960) ([oscerd](https://github.com/oscerd))
- Revisit support level label for all the Kamelets - Google Kamelets [\#958](https://github.com/apache/camel-kamelets/pull/958) ([oscerd](https://github.com/oscerd))
- Revisit support level label for all the Kamelets - Azure Kamelets [\#957](https://github.com/apache/camel-kamelets/pull/957) ([oscerd](https://github.com/oscerd))
- Revisit support level label for all the Kamelets - AWS Kamelets [\#956](https://github.com/apache/camel-kamelets/pull/956) ([oscerd](https://github.com/oscerd))
- Add Splunk sources and sinks [\#954](https://github.com/apache/camel-kamelets/pull/954) ([claudio4j](https://github.com/claudio4j))
- chore: Avoid NPE on extract/insert field Kamelets [\#953](https://github.com/apache/camel-kamelets/pull/953) ([christophd](https://github.com/christophd))
- Add Jira sink [\#951](https://github.com/apache/camel-kamelets/pull/951) ([claudio4j](https://github.com/claudio4j))
- Fix identation of steps in yaml dsl examples [\#950](https://github.com/apache/camel-kamelets/pull/950) ([claudio4j](https://github.com/claudio4j))
- Generated sources regen [\#948](https://github.com/apache/camel-kamelets/pull/948) ([github-actions[bot]](https://github.com/apps/github-actions))
- Remove the corrupted embedded png images in jms-ibm-mq logo [\#947](https://github.com/apache/camel-kamelets/pull/947) ([essobedo](https://github.com/essobedo))
- Fix the shadow declaration in the logo of bigquery Kamelet [\#946](https://github.com/apache/camel-kamelets/pull/946) ([essobedo](https://github.com/essobedo))
- Fix the svg version in the logo of mysql Kamelets [\#945](https://github.com/apache/camel-kamelets/pull/945) ([essobedo](https://github.com/essobedo))
- Upgrade Jackson to version 2.13.3 [\#943](https://github.com/apache/camel-kamelets/pull/943) ([oscerd](https://github.com/oscerd))
- Postgresql upgrade to 42.3.6 [\#942](https://github.com/apache/camel-kamelets/pull/942) ([oscerd](https://github.com/oscerd))
- Bump Apache Parent POM to version 26 [\#941](https://github.com/apache/camel-kamelets/pull/941) ([oscerd](https://github.com/oscerd))
- Upgrade Kubernetes client to version 5.12.2 [\#940](https://github.com/apache/camel-kamelets/pull/940) ([oscerd](https://github.com/oscerd))
- Upgrade Classgraph to version 4.8.147 [\#939](https://github.com/apache/camel-kamelets/pull/939) ([oscerd](https://github.com/oscerd))
- Point to 3.17.x for main [\#936](https://github.com/apache/camel-kamelets/pull/936) ([oscerd](https://github.com/oscerd))
- Upgrade Camel to version 3.17.0 [\#935](https://github.com/apache/camel-kamelets/pull/935) ([oscerd](https://github.com/oscerd))
- Turn AWS Region into an enum [\#933](https://github.com/apache/camel-kamelets/pull/933) ([oscerd](https://github.com/oscerd))
- SCP Sink Kamelet [\#931](https://github.com/apache/camel-kamelets/pull/931) ([oscerd](https://github.com/oscerd))
- Upgrade Redshift JDBC to version 2.1.0.7 [\#930](https://github.com/apache/camel-kamelets/pull/930) ([oscerd](https://github.com/oscerd))
- fix \#924 kamelets heve wrong type for properteries. [\#928](https://github.com/apache/camel-kamelets/pull/928) ([valdar](https://github.com/valdar))
- Fix IBM MQ kamelets to use general MQConnectionFactory [\#922](https://github.com/apache/camel-kamelets/pull/922) ([claudio4j](https://github.com/claudio4j))
- Added default value for keyName in aws-s3-sink.kamelet.yaml [\#919](https://github.com/apache/camel-kamelets/pull/919) ([valdar](https://github.com/valdar))
- Beer Source Kamelet [\#918](https://github.com/apache/camel-kamelets/pull/918) ([oscerd](https://github.com/oscerd))
- aws-\* kamelets: expose delay parameter where possible [\#917](https://github.com/apache/camel-kamelets/pull/917) ([oscerd](https://github.com/oscerd))
- Upgrade PostgreSQL Driver to version 42.3.4 [\#916](https://github.com/apache/camel-kamelets/pull/916) ([oscerd](https://github.com/oscerd))
- Create a Maven Kamelet Plugin - First commit [\#915](https://github.com/apache/camel-kamelets/pull/915) ([oscerd](https://github.com/oscerd))
- Validate the parameters in a Kamelet by looking at catalog [\#914](https://github.com/apache/camel-kamelets/pull/914) ([oscerd](https://github.com/oscerd))
- aws-kinesis-source kamelets incompatible with camel 3.16 [\#911](https://github.com/apache/camel-kamelets/pull/911) ([oscerd](https://github.com/oscerd))
- Validate the parameters in a Kamelet by looking at catalog [\#910](https://github.com/apache/camel-kamelets/pull/910) ([oscerd](https://github.com/oscerd))
- Validate the parameters in a Kamelet by looking at catalog [\#909](https://github.com/apache/camel-kamelets/pull/909) ([oscerd](https://github.com/oscerd))
- Upgrade Classgraph to version 4.8.146 [\#907](https://github.com/apache/camel-kamelets/pull/907) ([oscerd](https://github.com/oscerd))
- Fix the binding examples of jms-ibm-mq kamelets [\#905](https://github.com/apache/camel-kamelets/pull/905) ([claudio4j](https://github.com/claudio4j))
- MongoDB Changes Stream Consumer Source Kamelet - Stream Filter parameter [\#904](https://github.com/apache/camel-kamelets/pull/904) ([oscerd](https://github.com/oscerd))
- MongoDB Source Kamelet: The collection must be capped. Added to description. [\#903](https://github.com/apache/camel-kamelets/pull/903) ([oscerd](https://github.com/oscerd))
- Provide IBM MQ Sink and Source Kamelets [\#902](https://github.com/apache/camel-kamelets/pull/902) ([claudio4j](https://github.com/claudio4j))
- AWS DDB Streams: IteratorType has been renamed and sequenceNumberProvider is not an option anymore [\#900](https://github.com/apache/camel-kamelets/pull/900) ([oscerd](https://github.com/oscerd))
- Update non-working examples in Kamelet Catalog docs [\#897](https://github.com/apache/camel-kamelets/pull/897) ([claudio4j](https://github.com/claudio4j))
- MongoDB Changes Stream Consumer Source Kamelet [\#895](https://github.com/apache/camel-kamelets/pull/895) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#892](https://github.com/apache/camel-kamelets/pull/892) ([github-actions[bot]](https://github.com/apps/github-actions))
- Update throttle-action.kamelet.yaml [\#891](https://github.com/apache/camel-kamelets/pull/891) ([MelissaFlinn](https://github.com/MelissaFlinn))

## [v0.8.1](https://github.com/apache/camel-kamelets/tree/v0.8.1) (2022-05-09)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v0.8.0...v0.8.1)

**Closed issues:**

- Create a Maven Kamelet Plugin [\#913](https://github.com/apache/camel-kamelets/issues/913)
- aws-kinesis-source kamelets incompatible with camel 3.16 [\#908](https://github.com/apache/camel-kamelets/issues/908)
- aws-\* kamelets: expose `delay` parameter where possible. [\#906](https://github.com/apache/camel-kamelets/issues/906)
- Provide IBM MQ Sink and Source Kamelets [\#901](https://github.com/apache/camel-kamelets/issues/901)
- Validate the parameters in a Kamelet by looking at catalog [\#899](https://github.com/apache/camel-kamelets/issues/899)
- AWS DDB Streams: IteratorType has been renamed and sequenceNumberProvider is not an option anymore [\#898](https://github.com/apache/camel-kamelets/issues/898)
- MongoDB Changes Stream Consumer Source Kamelet - Stream Filter parameter [\#896](https://github.com/apache/camel-kamelets/issues/896)
- MongoDB Changes Stream Consumer Source Kamelet [\#893](https://github.com/apache/camel-kamelets/issues/893)
- override example template for these action kamelets [\#866](https://github.com/apache/camel-kamelets/issues/866)
- Random beer kamelet [\#335](https://github.com/apache/camel-kamelets/issues/335)

## [v0.8.0](https://github.com/apache/camel-kamelets/tree/v0.8.0) (2022-04-13)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v0.7.1...v0.8.0)

**Implemented enhancements:**

- make user and password properties of elasticsearch-index-sink optional with ? [\#703](https://github.com/apache/camel-kamelets/issues/703)

**Closed issues:**

- ActiveMQ Classic sink+source kamelets [\#885](https://github.com/apache/camel-kamelets/issues/885)
- Google Sheets Source Kamelet: Review the Kamelet [\#877](https://github.com/apache/camel-kamelets/issues/877)
- Google Sheets Source Kamelet: Range is a String and not a boolean [\#876](https://github.com/apache/camel-kamelets/issues/876)
- AWS Kinesis Firehose Kamelet: Introduce optional overrideEndpoint and uriEndpointOverride for testing purpose [\#868](https://github.com/apache/camel-kamelets/issues/868)
- AWS EC2 Kamelet: Introduce optional overrideEndpoint and uriEndpointOverride for testing purpose [\#867](https://github.com/apache/camel-kamelets/issues/867)
- AWS DynamoDB Streams Kamelet: Introduce optional overrideEndpoint and uriEndpointOverride for testing purpose [\#864](https://github.com/apache/camel-kamelets/issues/864)
- Azure Servicebus Souce Kamelet: Add subscriptionName as optional parameter for Topic  [\#861](https://github.com/apache/camel-kamelets/issues/861)
- AWS Kinesis Kamelets: Introduce optional overrideEndpoint and uriEndpointOverride for testing purpose [\#859](https://github.com/apache/camel-kamelets/issues/859)
- AWS S3 Sink: Add an optional keyName parameter [\#857](https://github.com/apache/camel-kamelets/issues/857)
- aws-sqs-fifo-sink: missing protocol option in the contentBasedDeduplication choice [\#856](https://github.com/apache/camel-kamelets/issues/856)
- Jolt Action: Define transformDSL as parameter [\#850](https://github.com/apache/camel-kamelets/issues/850)
- Use URI notation for some of the parameters we define in actions [\#844](https://github.com/apache/camel-kamelets/issues/844)
- Add Google BigQuery sink kamelet [\#843](https://github.com/apache/camel-kamelets/issues/843)
- Add Azure Storage Blob Changefeed Source Kamelet [\#840](https://github.com/apache/camel-kamelets/issues/840)
- AWS Cloudwatch Kamelet: Introduce optional overrideEndpoint and uriEndpointOverride for testing purpose [\#826](https://github.com/apache/camel-kamelets/issues/826)
- AWS SNS Kamelet: Introduce optional overrideEndpoint and uriEndpointOverride for testing purpose [\#825](https://github.com/apache/camel-kamelets/issues/825)
- AWS SQS Kamelets: Introduce optional overrideEndpoint, uriEndpointOverride and amazonAWSHost for testing purpose [\#824](https://github.com/apache/camel-kamelets/issues/824)
- AWS S3 Kamelets: Introduce optional overrideEndpoint and uriEndpointOverride for testing purpose [\#823](https://github.com/apache/camel-kamelets/issues/823)
- Azure Servicebus Source Kamelet: add serviceBusReceiveMode option [\#809](https://github.com/apache/camel-kamelets/issues/809)
- Improve GH Action Build Regen by building two times and having everything generated in one shot [\#797](https://github.com/apache/camel-kamelets/issues/797)
- kinesis improvements [\#796](https://github.com/apache/camel-kamelets/issues/796)
- YAKS tests are constantly failing [\#792](https://github.com/apache/camel-kamelets/issues/792)
- Camel 3.16 - Update kamelets to model changes [\#791](https://github.com/apache/camel-kamelets/issues/791)
- Upgrade Artemis dependency to 2.20.0 [\#782](https://github.com/apache/camel-kamelets/issues/782)
- Use Camel-K Kubernetes Client extension 5.12.1 [\#779](https://github.com/apache/camel-kamelets/issues/779)
- Release 0.7.1 [\#776](https://github.com/apache/camel-kamelets/issues/776)
- Azure Eventhubs source Kamelet: Add optional eventPosition parameter [\#766](https://github.com/apache/camel-kamelets/issues/766)
- Create a oracle sql kamelet [\#761](https://github.com/apache/camel-kamelets/issues/761)
- Add GH Action for testing Kamelets Catalog stuff on each PR  [\#760](https://github.com/apache/camel-kamelets/issues/760)
- Refactor From yaml instruction after upgrading to 3.15.0-SNAPSHOT [\#758](https://github.com/apache/camel-kamelets/issues/758)
- Remove getKameletFlow method from Catalog API [\#757](https://github.com/apache/camel-kamelets/issues/757)
- 0.8.x should point to Camel 3.15.0 [\#756](https://github.com/apache/camel-kamelets/issues/756)
- Add a Kafka Sink Kamelet supporting SSL [\#724](https://github.com/apache/camel-kamelets/issues/724)
- Add a Kafka Source Kamelet supporting SSL [\#723](https://github.com/apache/camel-kamelets/issues/723)
- Add a MQTT 5 Sink Kamelet [\#722](https://github.com/apache/camel-kamelets/issues/722)
- Add a MQTT 5 Source Kamelet [\#721](https://github.com/apache/camel-kamelets/issues/721)
- Add a JSLT Kamelet Action [\#711](https://github.com/apache/camel-kamelets/issues/711)
- Align camel-k model to the latest release of Kubernetes client.. [\#708](https://github.com/apache/camel-kamelets/issues/708)
- make elasticsearch-index-sink user and password properties optional with "?" syntax [\#704](https://github.com/apache/camel-kamelets/issues/704)
- Add Azure Servicebus Source Kamelet [\#629](https://github.com/apache/camel-kamelets/issues/629)
- Add Azure Servicebus Sink Kamelet [\#628](https://github.com/apache/camel-kamelets/issues/628)
- Add Pulsar source Kamelet [\#76](https://github.com/apache/camel-kamelets/issues/76)

**Merged pull requests:**

- Upgrade redshift-jdbc42 to version 2.1.0.5 [\#890](https://github.com/apache/camel-kamelets/pull/890) ([oscerd](https://github.com/oscerd))
- Activemq Source and Sink kamelet: Add explicit dependency activemq-http [\#889](https://github.com/apache/camel-kamelets/pull/889) ([oscerd](https://github.com/oscerd))
- Kafka SSL Source Kamelet re-added in Kamelets dir [\#888](https://github.com/apache/camel-kamelets/pull/888) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#887](https://github.com/apache/camel-kamelets/pull/887) ([github-actions[bot]](https://github.com/apps/github-actions))
- Issue 885 [\#886](https://github.com/apache/camel-kamelets/pull/886) ([agiertli](https://github.com/agiertli))
- Generated sources regen [\#884](https://github.com/apache/camel-kamelets/pull/884) ([github-actions[bot]](https://github.com/apps/github-actions))
- ISSUE-723 kafka-ssl-source kamelet [\#883](https://github.com/apache/camel-kamelets/pull/883) ([agiertli](https://github.com/agiertli))
- Generated sources regen [\#882](https://github.com/apache/camel-kamelets/pull/882) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[ISSUE-724\] kafka-ssl-sink kamelet [\#881](https://github.com/apache/camel-kamelets/pull/881) ([agiertli](https://github.com/agiertli))
- Upgrade Classgraph to version 4.8.143 [\#880](https://github.com/apache/camel-kamelets/pull/880) ([oscerd](https://github.com/oscerd))
- Jolt Action: Define transformDSL as parameter [\#879](https://github.com/apache/camel-kamelets/pull/879) ([oscerd](https://github.com/oscerd))
- fix \#877 fix \#876 : range is a string, correct usage of spreadsheetId… [\#878](https://github.com/apache/camel-kamelets/pull/878) ([valdar](https://github.com/valdar))
- Generated sources regen [\#874](https://github.com/apache/camel-kamelets/pull/874) ([github-actions[bot]](https://github.com/apps/github-actions))
- Upgrade Camel to version 3.16.0 [\#873](https://github.com/apache/camel-kamelets/pull/873) ([oscerd](https://github.com/oscerd))
- aws-sqs-fifo-sink: missing protocol option in the contentBasedDeduplication choice [\#872](https://github.com/apache/camel-kamelets/pull/872) ([oscerd](https://github.com/oscerd))
- AWS EC2 Kamelet: Introduce optional overrideEndpoint and uriEndpointOverride for testing purpose [\#871](https://github.com/apache/camel-kamelets/pull/871) ([oscerd](https://github.com/oscerd))
- AWS Kinesis Firehose: Introduce optional overrideEndpoint and uriEndpointOverride for testing purpose [\#870](https://github.com/apache/camel-kamelets/pull/870) ([oscerd](https://github.com/oscerd))
- AWS DynamoDB Streams: Introduce optional overrideEndpoint and uriEndpointOverride for testing purpose [\#869](https://github.com/apache/camel-kamelets/pull/869) ([oscerd](https://github.com/oscerd))
- AWS DDB Streams Kamelet: Fixed description for Default Credentials Provider [\#865](https://github.com/apache/camel-kamelets/pull/865) ([oscerd](https://github.com/oscerd))
- Azure Servicebus Souce Kamelet: Add subscriptionName as optional parameter for Topic [\#863](https://github.com/apache/camel-kamelets/pull/863) ([oscerd](https://github.com/oscerd))
- feature\(salesforce-sink\): Add, update, and delete salesforce sink [\#862](https://github.com/apache/camel-kamelets/pull/862) ([Delawen](https://github.com/Delawen))
- AWS Kinesis Kamelets: Introduce optional overrideEndpoint and uriEndpointOverride for testing purpose [\#860](https://github.com/apache/camel-kamelets/pull/860) ([oscerd](https://github.com/oscerd))
- AWS S3 Sink: Add an optional keyName parameter [\#858](https://github.com/apache/camel-kamelets/pull/858) ([oscerd](https://github.com/oscerd))
- Use URI notation for some of the parameters we define in actions [\#855](https://github.com/apache/camel-kamelets/pull/855) ([oscerd](https://github.com/oscerd))
- Use URI notation for some of the parameters we define in actions  [\#854](https://github.com/apache/camel-kamelets/pull/854) ([oscerd](https://github.com/oscerd))
- Use URI notation for some of the parameters we define in actions [\#853](https://github.com/apache/camel-kamelets/pull/853) ([oscerd](https://github.com/oscerd))
- Use URI notation for some of the parameters we define in actions [\#852](https://github.com/apache/camel-kamelets/pull/852) ([oscerd](https://github.com/oscerd))
- Use URI notation for some of the parameters we define in actions  [\#851](https://github.com/apache/camel-kamelets/pull/851) ([oscerd](https://github.com/oscerd))
- Add Google Big Query Sink Kamelet [\#849](https://github.com/apache/camel-kamelets/pull/849) ([claudio4j](https://github.com/claudio4j))
- Use URI notation for some of the parameters we define in actions  [\#848](https://github.com/apache/camel-kamelets/pull/848) ([oscerd](https://github.com/oscerd))
- Use URI notation for some of the parameters we define in actions [\#847](https://github.com/apache/camel-kamelets/pull/847) ([oscerd](https://github.com/oscerd))
- chore: Overwrite JitPack dependencies for pull request builds [\#846](https://github.com/apache/camel-kamelets/pull/846) ([christophd](https://github.com/christophd))
- Use URI notation for some of the parameters we define in actions [\#845](https://github.com/apache/camel-kamelets/pull/845) ([oscerd](https://github.com/oscerd))
- chore: Add header deserialize option on Kafka source [\#842](https://github.com/apache/camel-kamelets/pull/842) ([christophd](https://github.com/christophd))
- Add Azure Storage Blob Changefeed Source Kamelet [\#841](https://github.com/apache/camel-kamelets/pull/841) ([oscerd](https://github.com/oscerd))
- Typos in AWS Kamelets [\#839](https://github.com/apache/camel-kamelets/pull/839) ([oscerd](https://github.com/oscerd))
- AWS SQS Kamelets: Introduce optional overrideEndpoint and uriEndpointOverride for testing purpose [\#838](https://github.com/apache/camel-kamelets/pull/838) ([oscerd](https://github.com/oscerd))
- AWS S3 Streaming Upload Kamelet: Introduce optional overrideEndpoint and uriEndpointOverride for testing purpose [\#837](https://github.com/apache/camel-kamelets/pull/837) ([oscerd](https://github.com/oscerd))
- AWS SNS FIFO Kamelet: Introduce optional overrideEndpoint and uriEndpointOverride for testing purpose [\#836](https://github.com/apache/camel-kamelets/pull/836) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#835](https://github.com/apache/camel-kamelets/pull/835) ([github-actions[bot]](https://github.com/apps/github-actions))
- chore: Add Kamelet rest-openapi-sink [\#834](https://github.com/apache/camel-kamelets/pull/834) ([christophd](https://github.com/christophd))
- AWS CloudWatch Kamelet: Introduce optional overrideEndpoint and uriEndpointOverride for testing purpose [\#833](https://github.com/apache/camel-kamelets/pull/833) ([oscerd](https://github.com/oscerd))
- AWS SNS Kamelet: Introduce optional overrideEndpoint and uriEndpointOverride for testing purpose [\#832](https://github.com/apache/camel-kamelets/pull/832) ([oscerd](https://github.com/oscerd))
- Add Camel test for the beans used in some of the Kamelet action - Ins… [\#830](https://github.com/apache/camel-kamelets/pull/830) ([oscerd](https://github.com/oscerd))
- Upgrade Classgraph to version 4.8.141 [\#829](https://github.com/apache/camel-kamelets/pull/829) ([oscerd](https://github.com/oscerd))
- AWS S3 Kamelets: Introduce optional overrideEndpoint and uriEndpointOverride for testing purpose  [\#828](https://github.com/apache/camel-kamelets/pull/828) ([oscerd](https://github.com/oscerd))
- AWS DynamoDB Sink: Fixed description [\#827](https://github.com/apache/camel-kamelets/pull/827) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#822](https://github.com/apache/camel-kamelets/pull/822) ([github-actions[bot]](https://github.com/apps/github-actions))
- MQTT5 Sink Kamelet [\#821](https://github.com/apache/camel-kamelets/pull/821) ([oscerd](https://github.com/oscerd))
- MQTT v5 Source Kamelet [\#820](https://github.com/apache/camel-kamelets/pull/820) ([oscerd](https://github.com/oscerd))
- Add Kamelet aws-ddb-sink [\#819](https://github.com/apache/camel-kamelets/pull/819) ([christophd](https://github.com/christophd))
- Redshift Jdbc 4.2 2.1.0.4 [\#818](https://github.com/apache/camel-kamelets/pull/818) ([oscerd](https://github.com/oscerd))
- PostgreSQL 42.3.3 Update [\#817](https://github.com/apache/camel-kamelets/pull/817) ([oscerd](https://github.com/oscerd))
- Slack Source: Token documentation improvements [\#816](https://github.com/apache/camel-kamelets/pull/816) ([oscerd](https://github.com/oscerd))
- Azure Servicebus Source Kamelet: add serviceBusReceiveMode option [\#814](https://github.com/apache/camel-kamelets/pull/814) ([oscerd](https://github.com/oscerd))
- Azure servicebus datashapes [\#813](https://github.com/apache/camel-kamelets/pull/813) ([oscerd](https://github.com/oscerd))
- Add Azure Servicebus Sink Kamelet [\#812](https://github.com/apache/camel-kamelets/pull/812) ([oscerd](https://github.com/oscerd))
- AWS Kinesis Source Kamelet Improvements [\#811](https://github.com/apache/camel-kamelets/pull/811) ([oscerd](https://github.com/oscerd))
- Add Azure Servicebus Source Kamelet [\#808](https://github.com/apache/camel-kamelets/pull/808) ([oscerd](https://github.com/oscerd))
- AWS Kinesis Kamelets improvements [\#807](https://github.com/apache/camel-kamelets/pull/807) ([oscerd](https://github.com/oscerd))
- Upgrade Jackson to version 2.13.2 [\#806](https://github.com/apache/camel-kamelets/pull/806) ([oscerd](https://github.com/oscerd))
- Added Java Tests GH Action on PR [\#803](https://github.com/apache/camel-kamelets/pull/803) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#802](https://github.com/apache/camel-kamelets/pull/802) ([github-actions[bot]](https://github.com/apps/github-actions))
- Improve GH Action Build Regen by building two times and having everyt… [\#801](https://github.com/apache/camel-kamelets/pull/801) ([oscerd](https://github.com/oscerd))
- Docs: Next release point Camel 3.15.0 [\#799](https://github.com/apache/camel-kamelets/pull/799) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#798](https://github.com/apache/camel-kamelets/pull/798) ([github-actions[bot]](https://github.com/apps/github-actions))
- fix\(ci\): Bump Camel K version to 1.7.0 [\#795](https://github.com/apache/camel-kamelets/pull/795) ([christophd](https://github.com/christophd))
- Use OpenJDK 11 when building with JitPack [\#794](https://github.com/apache/camel-kamelets/pull/794) ([christophd](https://github.com/christophd))
- Bump Log4j to version 2.17.2 [\#793](https://github.com/apache/camel-kamelets/pull/793) ([oscerd](https://github.com/oscerd))
- Upgrade Jackson to version 2.13.1 [\#790](https://github.com/apache/camel-kamelets/pull/790) ([oscerd](https://github.com/oscerd))
- salesforce: fix SalesforceComponent beanc reation [\#789](https://github.com/apache/camel-kamelets/pull/789) ([lburgazzoli](https://github.com/lburgazzoli))
- Generated sources regen [\#788](https://github.com/apache/camel-kamelets/pull/788) ([github-actions[bot]](https://github.com/apps/github-actions))
- salesforce: move credentials to SalesforceComponent bean [\#787](https://github.com/apache/camel-kamelets/pull/787) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade Slf4j to version 1.7.36 [\#786](https://github.com/apache/camel-kamelets/pull/786) ([oscerd](https://github.com/oscerd))
- make elasticsearch-index-sink user and password properties optional with "?" syntax [\#785](https://github.com/apache/camel-kamelets/pull/785) ([oscerd](https://github.com/oscerd))
- JSLT Kamelet Action [\#784](https://github.com/apache/camel-kamelets/pull/784) ([oscerd](https://github.com/oscerd))
- Upgrade Artemis dependency to 2.20.0 [\#783](https://github.com/apache/camel-kamelets/pull/783) ([oscerd](https://github.com/oscerd))
- Remove getKameletFlow method from Catalog API [\#781](https://github.com/apache/camel-kamelets/pull/781) ([oscerd](https://github.com/oscerd))
- Upgrade Camel-K Kubernetes-client model to version 5.12.1 [\#780](https://github.com/apache/camel-kamelets/pull/780) ([oscerd](https://github.com/oscerd))
- Update to Camel 3.15.0 [\#777](https://github.com/apache/camel-kamelets/pull/777) ([oscerd](https://github.com/oscerd))
- Support Default Credentials Provider for AWS Kamelets [\#774](https://github.com/apache/camel-kamelets/pull/774) ([oscerd](https://github.com/oscerd))
- Support default credentials provider for AWS Kamelets [\#772](https://github.com/apache/camel-kamelets/pull/772) ([oscerd](https://github.com/oscerd))
- Support default credentials provider in AWS Kamelets [\#770](https://github.com/apache/camel-kamelets/pull/770) ([oscerd](https://github.com/oscerd))
- AWS Kamelets - Support default credentials provider  [\#768](https://github.com/apache/camel-kamelets/pull/768) ([oscerd](https://github.com/oscerd))
- Support DefaultCredentialProvider in the AWS Kamelets - AWS DDB Streams [\#767](https://github.com/apache/camel-kamelets/pull/767) ([oscerd](https://github.com/oscerd))
- Fix test for camel-kamelets-catalog: We don't use flow anymore, but t… [\#764](https://github.com/apache/camel-kamelets/pull/764) ([oscerd](https://github.com/oscerd))
- Change to flow description [\#763](https://github.com/apache/camel-kamelets/pull/763) ([squakez](https://github.com/squakez))
- chore: use template in favour of flow spec [\#754](https://github.com/apache/camel-kamelets/pull/754) ([squakez](https://github.com/squakez))
- Generated sources regen [\#753](https://github.com/apache/camel-kamelets/pull/753) ([github-actions[bot]](https://github.com/apps/github-actions))
- fix\(ci\): validate kamelets directory [\#752](https://github.com/apache/camel-kamelets/pull/752) ([squakez](https://github.com/squakez))
- chore: move deprecated flow to template [\#750](https://github.com/apache/camel-kamelets/pull/750) ([squakez](https://github.com/squakez))
- Support DefaultCredentialProvider in the AWS Kamelets - AWS CloudWatch [\#748](https://github.com/apache/camel-kamelets/pull/748) ([oscerd](https://github.com/oscerd))
- Support DefaultCredentialProvider in the AWS Kamelets - AWS S3 Sink [\#743](https://github.com/apache/camel-kamelets/pull/743) ([oscerd](https://github.com/oscerd))
- Support DefaultCredentialProvider in the AWS Kamelets - AWS S3 Source [\#742](https://github.com/apache/camel-kamelets/pull/742) ([oscerd](https://github.com/oscerd))
- Backport GH Action [\#740](https://github.com/apache/camel-kamelets/pull/740) ([oscerd](https://github.com/oscerd))
- Support DefaultCredentialProvider in the AWS Kamelets - AWS S3 Source [\#737](https://github.com/apache/camel-kamelets/pull/737) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#734](https://github.com/apache/camel-kamelets/pull/734) ([github-actions[bot]](https://github.com/apps/github-actions))
- doc-update-header-actions-try2 [\#733](https://github.com/apache/camel-kamelets/pull/733) ([MelissaFlinn](https://github.com/MelissaFlinn))
- Fix \#729 to use toD for dynamic to eip [\#731](https://github.com/apache/camel-kamelets/pull/731) ([davsclaus](https://github.com/davsclaus))
- camel-website \#701 camel-kamelets RI table setup \(main\) [\#725](https://github.com/apache/camel-kamelets/pull/725) ([djencks](https://github.com/djencks))

## [v0.7.1](https://github.com/apache/camel-kamelets/tree/v0.7.1) (2022-02-07)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v0.7.0...v0.7.1)

**Fixed bugs:**

- Validator script to use template in favour of flow [\#751](https://github.com/apache/camel-kamelets/issues/751)

**Closed issues:**

- Add Backport GH Action [\#739](https://github.com/apache/camel-kamelets/issues/739)
- Bean reference and processors seem to be non-existent [\#736](https://github.com/apache/camel-kamelets/issues/736)
- Support DefaultCredentialProvider in the AWS Kamelets [\#735](https://github.com/apache/camel-kamelets/issues/735)
- Use toD for dynamic to in Kamelets [\#729](https://github.com/apache/camel-kamelets/issues/729)

## [v0.7.0](https://github.com/apache/camel-kamelets/tree/v0.7.0) (2022-01-18)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v0.6.0...v0.7.0)

**Closed issues:**

- Add drop headers Kamelet action [\#706](https://github.com/apache/camel-kamelets/issues/706)
- Add drop header Kamelet action [\#705](https://github.com/apache/camel-kamelets/issues/705)
- elasticsearch-index-sink has no way to set username and password [\#701](https://github.com/apache/camel-kamelets/issues/701)
- Extract Field Action: Sanitize/check the header name if set and avoid clashes [\#689](https://github.com/apache/camel-kamelets/issues/689)
- Extract Field Action: Add the possibility of setting the header name in case of headerOutput is true [\#688](https://github.com/apache/camel-kamelets/issues/688)
- Insert Field Action: Use Simple as default and not constant for the value parameter binding [\#684](https://github.com/apache/camel-kamelets/issues/684)
- Insert Header Action: Use Simple as default and not constant for the value parameter binding [\#682](https://github.com/apache/camel-kamelets/issues/682)
- Extract Field Action: Make it possible to set if the extracted field should be in the body or in a particular header [\#677](https://github.com/apache/camel-kamelets/issues/677)
- Bump Commons-dbcp2 to 2.9.0 [\#672](https://github.com/apache/camel-kamelets/issues/672)
- Create a Camel-Kamelets BOM [\#670](https://github.com/apache/camel-kamelets/issues/670)
- Split Github Source Kamelet in multiple Kamelets [\#648](https://github.com/apache/camel-kamelets/issues/648)
- Documentation: Add information in active branches, about what is the camel-k version using the catalog [\#632](https://github.com/apache/camel-kamelets/issues/632)
- Create an AWS SES Sink Kamelet [\#616](https://github.com/apache/camel-kamelets/issues/616)
- Github Kamelet Source Commits: Add startingSha as optional parameter [\#537](https://github.com/apache/camel-kamelets/issues/537)
- replace-field-action disabled and enabled are mandatory [\#461](https://github.com/apache/camel-kamelets/issues/461)
- replace-field-action is not adding the renames field to enabled list by default [\#460](https://github.com/apache/camel-kamelets/issues/460)

**Merged pull requests:**

- Generated sources regen [\#719](https://github.com/apache/camel-kamelets/pull/719) ([github-actions[bot]](https://github.com/apps/github-actions))
- Fix cassandra kamelets [\#718](https://github.com/apache/camel-kamelets/pull/718) ([asmigala](https://github.com/asmigala))
- camel-website \#710: kamelets RI info \(main\) [\#715](https://github.com/apache/camel-kamelets/pull/715) ([djencks](https://github.com/djencks))
- Drop headers Kamelet action [\#714](https://github.com/apache/camel-kamelets/pull/714) ([oscerd](https://github.com/oscerd))
- Fixing Validation of Slack Source Kamelet [\#713](https://github.com/apache/camel-kamelets/pull/713) ([oscerd](https://github.com/oscerd))
- Drop header Kamelet Action [\#712](https://github.com/apache/camel-kamelets/pull/712) ([oscerd](https://github.com/oscerd))
- fix docs [\#710](https://github.com/apache/camel-kamelets/pull/710) ([djencks](https://github.com/djencks))
- Generated sources regen [\#702](https://github.com/apache/camel-kamelets/pull/702) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen [\#700](https://github.com/apache/camel-kamelets/pull/700) ([github-actions[bot]](https://github.com/apps/github-actions))
- Add some KEDA markers [\#698](https://github.com/apache/camel-kamelets/pull/698) ([nicolaferraro](https://github.com/nicolaferraro))
- Replace-field-action disabled and enabled are mandatory [\#697](https://github.com/apache/camel-kamelets/pull/697) ([oscerd](https://github.com/oscerd))
- Move to Official Apache Maven Wrapper [\#696](https://github.com/apache/camel-kamelets/pull/696) ([oscerd](https://github.com/oscerd))
- Comments for explicit Kamelets deps [\#695](https://github.com/apache/camel-kamelets/pull/695) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#693](https://github.com/apache/camel-kamelets/pull/693) ([github-actions[bot]](https://github.com/apps/github-actions))
- Slack source improvements [\#692](https://github.com/apache/camel-kamelets/pull/692) ([lburgazzoli](https://github.com/lburgazzoli))
- Extract Field Action: Sanitize/check the header name if set and avoid clashes [\#691](https://github.com/apache/camel-kamelets/pull/691) ([oscerd](https://github.com/oscerd))
- Extract Field Action: Add the possibility of setting the header name in case of headerOutput is true [\#690](https://github.com/apache/camel-kamelets/pull/690) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#687](https://github.com/apache/camel-kamelets/pull/687) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen [\#686](https://github.com/apache/camel-kamelets/pull/686) ([github-actions[bot]](https://github.com/apps/github-actions))
- Insert Field Action: Use Simple as default and not constant for the value parameter binding [\#685](https://github.com/apache/camel-kamelets/pull/685) ([oscerd](https://github.com/oscerd))
- Insert Header Action: Use Simple as default and not constant for the value parameter binding [\#683](https://github.com/apache/camel-kamelets/pull/683) ([oscerd](https://github.com/oscerd))
- Extract Field Action: Make it possible to set if the extracted field should be in the body or in a particular header [\#681](https://github.com/apache/camel-kamelets/pull/681) ([oscerd](https://github.com/oscerd))
- Bump Commons-dbcp2 to 2.9.0 [\#678](https://github.com/apache/camel-kamelets/pull/678) ([oscerd](https://github.com/oscerd))
- Fix Kamelets link in documentation [\#675](https://github.com/apache/camel-kamelets/pull/675) ([oscerd](https://github.com/oscerd))
- Create a Camel-Kamelets BOM [\#674](https://github.com/apache/camel-kamelets/pull/674) ([oscerd](https://github.com/oscerd))
- Added a first version of Camel-Kamelets-Bom [\#671](https://github.com/apache/camel-kamelets/pull/671) ([oscerd](https://github.com/oscerd))
- AWS SES Sink Kamelet [\#669](https://github.com/apache/camel-kamelets/pull/669) ([oscerd](https://github.com/oscerd))
- Removed Github Source Kamelet [\#668](https://github.com/apache/camel-kamelets/pull/668) ([oscerd](https://github.com/oscerd))
- Github Pull Request comments Source Kamelet [\#667](https://github.com/apache/camel-kamelets/pull/667) ([oscerd](https://github.com/oscerd))
- Github Pull Request Source Kamelet [\#666](https://github.com/apache/camel-kamelets/pull/666) ([oscerd](https://github.com/oscerd))
- Upgrade Kubernetes Client to version 5.11.1 [\#665](https://github.com/apache/camel-kamelets/pull/665) ([oscerd](https://github.com/oscerd))
- Update Log4j to 2.17.1 to address CVE-2021-44832 [\#664](https://github.com/apache/camel-kamelets/pull/664) ([neel24](https://github.com/neel24))
- main update to docs local build v2 [\#661](https://github.com/apache/camel-kamelets/pull/661) ([djencks](https://github.com/djencks))
- Update websocket icon [\#658](https://github.com/apache/camel-kamelets/pull/658) ([Croway](https://github.com/Croway))
- Github Events Source Kamelet [\#657](https://github.com/apache/camel-kamelets/pull/657) ([oscerd](https://github.com/oscerd))
- Github Tag Source Kamelet [\#656](https://github.com/apache/camel-kamelets/pull/656) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#655](https://github.com/apache/camel-kamelets/pull/655) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[json-serialize-action\] Unsupported field: unmarshalTypeName [\#653](https://github.com/apache/camel-kamelets/pull/653) ([lburgazzoli](https://github.com/lburgazzoli))
- GitHub commit source Kamelet [\#650](https://github.com/apache/camel-kamelets/pull/650) ([oscerd](https://github.com/oscerd))
- Json-Patch Action Kamelet [\#649](https://github.com/apache/camel-kamelets/pull/649) ([oscerd](https://github.com/oscerd))
- elasticsearch-index-sink kamelet should allow empty indexId [\#646](https://github.com/apache/camel-kamelets/pull/646) ([oscerd](https://github.com/oscerd))
- Upgrade Camel-K Extension to version 5.11.0 [\#645](https://github.com/apache/camel-kamelets/pull/645) ([oscerd](https://github.com/oscerd))
- Update Log4j to 2.17.0 to address CVE-2021-45105 [\#642](https://github.com/apache/camel-kamelets/pull/642) ([neel24](https://github.com/neel24))
- Add Google Cloud Functions Sink Kamelet [\#641](https://github.com/apache/camel-kamelets/pull/641) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#638](https://github.com/apache/camel-kamelets/pull/638) ([github-actions[bot]](https://github.com/apps/github-actions))
- Added generation and validation instructions in README.md [\#637](https://github.com/apache/camel-kamelets/pull/637) ([valdar](https://github.com/valdar))
- fix \#635: cassandra sink and source kamelets problems [\#636](https://github.com/apache/camel-kamelets/pull/636) ([valdar](https://github.com/valdar))
- Google Storage Sink Kamelet [\#634](https://github.com/apache/camel-kamelets/pull/634) ([oscerd](https://github.com/oscerd))
- Google Storage Source Kamelet [\#633](https://github.com/apache/camel-kamelets/pull/633) ([oscerd](https://github.com/oscerd))
- Update YAKS to v0.7.0 [\#631](https://github.com/apache/camel-kamelets/pull/631) ([christophd](https://github.com/christophd))
- \[Docs\] Generate kamelets pages using Antora \(main\) [\#630](https://github.com/apache/camel-kamelets/pull/630) ([djencks](https://github.com/djencks))
- Bump Maven wrapper version to 3.8.4 [\#627](https://github.com/apache/camel-kamelets/pull/627) ([oscerd](https://github.com/oscerd))
- Rename cloudwatch cw\_namespace property [\#626](https://github.com/apache/camel-kamelets/pull/626) ([tplevko](https://github.com/tplevko))
- Generated sources regen [\#625](https://github.com/apache/camel-kamelets/pull/625) ([github-actions[bot]](https://github.com/apps/github-actions))
- \#397: Add Pulsar sink Kamelet [\#624](https://github.com/apache/camel-kamelets/pull/624) ([luigidemasi](https://github.com/luigidemasi))
- Websocket icon fix [\#623](https://github.com/apache/camel-kamelets/pull/623) ([oscerd](https://github.com/oscerd))
- AWS Redshift Sink Kamelet [\#622](https://github.com/apache/camel-kamelets/pull/622) ([oscerd](https://github.com/oscerd))
- AWS Redshift SQL Source Kamelet [\#621](https://github.com/apache/camel-kamelets/pull/621) ([oscerd](https://github.com/oscerd))
- Elasticsearch index sink indexId random generator for null [\#618](https://github.com/apache/camel-kamelets/pull/618) ([oscerd](https://github.com/oscerd))
- Rename bootstrap server properties [\#617](https://github.com/apache/camel-kamelets/pull/617) ([nicolaferraro](https://github.com/nicolaferraro))
- \#76: Add Pulsar source Kamelet [\#614](https://github.com/apache/camel-kamelets/pull/614) ([luigidemasi](https://github.com/luigidemasi))
- SSH Sink Kamelet [\#613](https://github.com/apache/camel-kamelets/pull/613) ([oscerd](https://github.com/oscerd))
- The remove-property EIP should use name instead of property-name [\#612](https://github.com/apache/camel-kamelets/pull/612) ([oscerd](https://github.com/oscerd))
- Add mail sink Kamelet [\#610](https://github.com/apache/camel-kamelets/pull/610) ([christophd](https://github.com/christophd))
- Add websocket source [\#609](https://github.com/apache/camel-kamelets/pull/609) ([Croway](https://github.com/Croway))
- The remove-header-name EIP should use name instead of header-name [\#608](https://github.com/apache/camel-kamelets/pull/608) ([oscerd](https://github.com/oscerd))
- Solr Sink Kamelet: Added credentials [\#606](https://github.com/apache/camel-kamelets/pull/606) ([oscerd](https://github.com/oscerd))
- Solr Source Kamelet: Added credentials field [\#605](https://github.com/apache/camel-kamelets/pull/605) ([oscerd](https://github.com/oscerd))
- Added Solr Source Query [\#604](https://github.com/apache/camel-kamelets/pull/604) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#603](https://github.com/apache/camel-kamelets/pull/603) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen [\#602](https://github.com/apache/camel-kamelets/pull/602) ([github-actions[bot]](https://github.com/apps/github-actions))
- Add wttr.in Source Kamelet [\#601](https://github.com/apache/camel-kamelets/pull/601) ([tadayosi](https://github.com/tadayosi))
- Add Redis source kamelet [\#599](https://github.com/apache/camel-kamelets/pull/599) ([Croway](https://github.com/Croway))
- Solr Sink Kamelet [\#596](https://github.com/apache/camel-kamelets/pull/596) ([oscerd](https://github.com/oscerd))
- Removed duplicated license from timer source [\#595](https://github.com/apache/camel-kamelets/pull/595) ([oscerd](https://github.com/oscerd))
- Kamelet YAML files links are broken [\#593](https://github.com/apache/camel-kamelets/pull/593) ([oscerd](https://github.com/oscerd))
- Upgrade Classgraph to version 4.8.137 [\#589](https://github.com/apache/camel-kamelets/pull/589) ([oscerd](https://github.com/oscerd))
- Added License to Kamelets YAML [\#588](https://github.com/apache/camel-kamelets/pull/588) ([oscerd](https://github.com/oscerd))
- Fix Elasticsearch Source Kamelet title [\#587](https://github.com/apache/camel-kamelets/pull/587) ([oscerd](https://github.com/oscerd))
- AWS Secrets Manager Sink Kamelet [\#586](https://github.com/apache/camel-kamelets/pull/586) ([oscerd](https://github.com/oscerd))
- README for generator and validator updated [\#585](https://github.com/apache/camel-kamelets/pull/585) ([oscerd](https://github.com/oscerd))
- Infinispan Sink Kamelet [\#584](https://github.com/apache/camel-kamelets/pull/584) ([oscerd](https://github.com/oscerd))
- Moved all the kamelet.yaml files to kamelets folder [\#583](https://github.com/apache/camel-kamelets/pull/583) ([oscerd](https://github.com/oscerd))
- Salesforce Source Kamelet: Do not use kamelet-reify anymore [\#582](https://github.com/apache/camel-kamelets/pull/582) ([oscerd](https://github.com/oscerd))
- Elasticsearch Search Source Kamelet: Do not use kamelet-reify anymore [\#581](https://github.com/apache/camel-kamelets/pull/581) ([oscerd](https://github.com/oscerd))
- Elasticsearch Index Sink Kamelet: Do not use kamelet-reify anymore [\#580](https://github.com/apache/camel-kamelets/pull/580) ([oscerd](https://github.com/oscerd))
- Infinispan Source Kamelet: Removed deadcode in source [\#578](https://github.com/apache/camel-kamelets/pull/578) ([oscerd](https://github.com/oscerd))
- Infinispan Source Kamelets: Fix default value and description for EventType [\#577](https://github.com/apache/camel-kamelets/pull/577) ([oscerd](https://github.com/oscerd))
- Infinispan Source Kamelet: Do not use kamelet-reify [\#576](https://github.com/apache/camel-kamelets/pull/576) ([oscerd](https://github.com/oscerd))
- fix: use the right json schema type for integers [\#575](https://github.com/apache/camel-kamelets/pull/575) ([lburgazzoli](https://github.com/lburgazzoli))
- Bump Kubernetes Client Camel-K extension to version 5.10.1 [\#574](https://github.com/apache/camel-kamelets/pull/574) ([oscerd](https://github.com/oscerd))
- Bump Classgraph to version 4.8.133 [\#573](https://github.com/apache/camel-kamelets/pull/573) ([oscerd](https://github.com/oscerd))
- Added Throttle Action Kamelet [\#572](https://github.com/apache/camel-kamelets/pull/572) ([oscerd](https://github.com/oscerd))
- Fixed DB Typos [\#570](https://github.com/apache/camel-kamelets/pull/570) ([oscerd](https://github.com/oscerd))
- Salesforce Source Kamelet: Make notifyForFields configurable [\#569](https://github.com/apache/camel-kamelets/pull/569) ([oscerd](https://github.com/oscerd))
- mflinn-kamelet-template-minor-fix [\#567](https://github.com/apache/camel-kamelets/pull/567) ([MelissaFlinn](https://github.com/MelissaFlinn))
- Couchbase Sink Kamelet: Initial version [\#566](https://github.com/apache/camel-kamelets/pull/566) ([oscerd](https://github.com/oscerd))

## [v0.6.0](https://github.com/apache/camel-kamelets/tree/v0.6.0) (2021-12-22)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v0.5.0...v0.6.0)

**Implemented enhancements:**

- Add SSH Sink Kamelet [\#504](https://github.com/apache/camel-kamelets/issues/504)

**Closed issues:**

- \[json-serialize-action\] Unsupported field: unmarshalTypeName [\#651](https://github.com/apache/camel-kamelets/issues/651)
- Add a Json Patch Action Kamelet [\#647](https://github.com/apache/camel-kamelets/issues/647)
- Upgrade to Kubernetes Client Camel-K extension 5.11.0 [\#644](https://github.com/apache/camel-kamelets/issues/644)
- `elasticsearch-index-sink` kamelet should allow empty `indexId` [\#643](https://github.com/apache/camel-kamelets/issues/643)
- Add Google Cloud Functions Sink Kamelet [\#639](https://github.com/apache/camel-kamelets/issues/639)
- cassandra sink and source kamelets problems [\#635](https://github.com/apache/camel-kamelets/issues/635)
- Create an AWS Redshift SQL Sink Kamelet [\#620](https://github.com/apache/camel-kamelets/issues/620)
- Create an AWS Redshift SQL Source Kamelet [\#619](https://github.com/apache/camel-kamelets/issues/619)
- Elasticsearch index sink indexId random generator for null [\#615](https://github.com/apache/camel-kamelets/issues/615)
- The remove-property EIP should use name instead of property-name [\#611](https://github.com/apache/camel-kamelets/issues/611)
- The remove-header-name EIP should use name instead of header-name [\#607](https://github.com/apache/camel-kamelets/issues/607)
- Create a Solr Source Kamelet [\#598](https://github.com/apache/camel-kamelets/issues/598)
- Support Basic Authentication in Solr Sink/Solr Source [\#597](https://github.com/apache/camel-kamelets/issues/597)
- Kamelet YAML files links are broken [\#592](https://github.com/apache/camel-kamelets/issues/592)
- Provide source code release package [\#590](https://github.com/apache/camel-kamelets/issues/590)
- Create an Infinispan Sink Kamelet for put operation [\#579](https://github.com/apache/camel-kamelets/issues/579)
- Create a throttle action [\#571](https://github.com/apache/camel-kamelets/issues/571)
- Salesforce Source Kamelet: Make notifyForFields configurable [\#568](https://github.com/apache/camel-kamelets/issues/568)
- Add an AWS Secrets Manager Kamelet Sink [\#562](https://github.com/apache/camel-kamelets/issues/562)
- Do not use kamelet-reify anymore [\#554](https://github.com/apache/camel-kamelets/issues/554)
- Create Couchbase Sink Kamelet [\#543](https://github.com/apache/camel-kamelets/issues/543)
- Add Google Storage Sink kamelet [\#527](https://github.com/apache/camel-kamelets/issues/527)
- Add Google Storage Source Kamelet [\#526](https://github.com/apache/camel-kamelets/issues/526)
- Postgres db as sink [\#458](https://github.com/apache/camel-kamelets/issues/458)
- Move kamelets from root folder into a sub folder [\#448](https://github.com/apache/camel-kamelets/issues/448)
- Add Pulsar sink Kamelet [\#397](https://github.com/apache/camel-kamelets/issues/397)
- Add a Vertx-kafka sink kamelet [\#191](https://github.com/apache/camel-kamelets/issues/191)
- Add a Vertx-kafka Source kamelet [\#190](https://github.com/apache/camel-kamelets/issues/190)
- Add Solr Sink Kamelet [\#160](https://github.com/apache/camel-kamelets/issues/160)

## [v0.5.0](https://github.com/apache/camel-kamelets/tree/v0.5.0) (2021-11-09)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v0.4.0...v0.5.0)

**Closed issues:**

- Jira Source Kamelet: To use Joda we need to register the JodaModule from Jackson [\#560](https://github.com/apache/camel-kamelets/issues/560)
- Use secrets with KameletBindings [\#549](https://github.com/apache/camel-kamelets/issues/549)
- Add x-description URNs to fields to group related properties [\#548](https://github.com/apache/camel-kamelets/issues/548)
- Create a MQTT sink [\#544](https://github.com/apache/camel-kamelets/issues/544)
- Add a method to Kamelet catalog to print all the dependencies for each single Kamelet [\#541](https://github.com/apache/camel-kamelets/issues/541)
- Google Sheets Source Kamelet: Introduce repeatCount optional parameter [\#535](https://github.com/apache/camel-kamelets/issues/535)
- Add Jolt Kamelet Action [\#515](https://github.com/apache/camel-kamelets/issues/515)
- telegram-source seems to not emit proper cloud-events [\#513](https://github.com/apache/camel-kamelets/issues/513)
- Adding filter for exluding explicit content to chuck-norris-source [\#511](https://github.com/apache/camel-kamelets/issues/511)
- AWS S3 Streaming Upload Kamelet: Support also StreamingUploadTimeout parameter [\#500](https://github.com/apache/camel-kamelets/issues/500)
- Minio Sink Kamelet: The exchangeId as object Name should be set as header and not as property [\#495](https://github.com/apache/camel-kamelets/issues/495)
- Google Pubsub Sink Kamelet [\#491](https://github.com/apache/camel-kamelets/issues/491)
- Google Pubsub Source Kamelet [\#490](https://github.com/apache/camel-kamelets/issues/490)
- camel-kOperator Install [\#469](https://github.com/apache/camel-kamelets/issues/469)
- To-D doesn't work in a Kamelet [\#449](https://github.com/apache/camel-kamelets/issues/449)
- Provide dependency info in each kamelet's catalog page [\#412](https://github.com/apache/camel-kamelets/issues/412)
- Support GCP pub sub kamelet [\#396](https://github.com/apache/camel-kamelets/issues/396)
- Docs: add a link to the kamelet yaml in the related doc page [\#376](https://github.com/apache/camel-kamelets/issues/376)
- Infinispan source Kamelet: Convert resulting headers into consumable headers for knative [\#181](https://github.com/apache/camel-kamelets/issues/181)
- Support Subject as header into sns sink and sns fifo sink [\#98](https://github.com/apache/camel-kamelets/issues/98)

**Merged pull requests:**

- Upgrade Camel to 3.12.0 preparing for camel-k release 1.7.0 [\#565](https://github.com/apache/camel-kamelets/pull/565) ([oscerd](https://github.com/oscerd))
- Upgrade Kubernetes-client to version 5.9.0 [\#564](https://github.com/apache/camel-kamelets/pull/564) ([oscerd](https://github.com/oscerd))
- Bump Classgraph to version 4.8.131 [\#563](https://github.com/apache/camel-kamelets/pull/563) ([oscerd](https://github.com/oscerd))
- Jira Source Kamelet: Fix Joda usage [\#561](https://github.com/apache/camel-kamelets/pull/561) ([oscerd](https://github.com/oscerd))
- Main fix doc gen [\#559](https://github.com/apache/camel-kamelets/pull/559) ([djencks](https://github.com/djencks))
- Generated sources regen [\#557](https://github.com/apache/camel-kamelets/pull/557) ([github-actions[bot]](https://github.com/apps/github-actions))
- chore: fix wrong flow definition in slack sink [\#556](https://github.com/apache/camel-kamelets/pull/556) ([lburgazzoli](https://github.com/lburgazzoli))
- Generated sources regen [\#555](https://github.com/apache/camel-kamelets/pull/555) ([github-actions[bot]](https://github.com/apps/github-actions))
- mongodb-source-kamelet decription update [\#553](https://github.com/apache/camel-kamelets/pull/553) ([MelissaFlinn](https://github.com/MelissaFlinn))
- camel-kamelets Main latest to next [\#552](https://github.com/apache/camel-kamelets/pull/552) ([djencks](https://github.com/djencks))
- Add a method to Kamelet catalog to print all the dependencies for eac… [\#551](https://github.com/apache/camel-kamelets/pull/551) ([oscerd](https://github.com/oscerd))
- Fix \#548: add credentials group to kamelets descriptor [\#550](https://github.com/apache/camel-kamelets/pull/550) ([nicolaferraro](https://github.com/nicolaferraro))
- Chore: add authorization to the MQTT Kamelet [\#547](https://github.com/apache/camel-kamelets/pull/547) ([nicolaferraro](https://github.com/nicolaferraro))
- Create an MQTT sink [\#546](https://github.com/apache/camel-kamelets/pull/546) ([nicolaferraro](https://github.com/nicolaferraro))
- Jira source requires jackson-datatype-joda [\#545](https://github.com/apache/camel-kamelets/pull/545) ([oscerd](https://github.com/oscerd))
- kamelets-doc-template-edit [\#538](https://github.com/apache/camel-kamelets/pull/538) ([MelissaFlinn](https://github.com/MelissaFlinn))
- Google Sheets Source Kamelet: introducing repeatCount optional parameter [\#536](https://github.com/apache/camel-kamelets/pull/536) ([oscerd](https://github.com/oscerd))
- Regen Infinispan Source Kamelet [\#534](https://github.com/apache/camel-kamelets/pull/534) ([oscerd](https://github.com/oscerd))
- Infinispan source Kamelet: Convert resulting headers into consumable headers for knative [\#533](https://github.com/apache/camel-kamelets/pull/533) ([oscerd](https://github.com/oscerd))
- Upgrade Junit to version 5.8.1 [\#532](https://github.com/apache/camel-kamelets/pull/532) ([oscerd](https://github.com/oscerd))
- Upgrade Commons-io to version 2.11.0 [\#531](https://github.com/apache/camel-kamelets/pull/531) ([oscerd](https://github.com/oscerd))
- Upgrade to latest Camel 3.11.2 [\#530](https://github.com/apache/camel-kamelets/pull/530) ([oscerd](https://github.com/oscerd))
- Upgrade Kubernetes Client to version 5.8.0 [\#529](https://github.com/apache/camel-kamelets/pull/529) ([oscerd](https://github.com/oscerd))
- Upgrade Classgraph to version 4.8.117 [\#528](https://github.com/apache/camel-kamelets/pull/528) ([oscerd](https://github.com/oscerd))
- Jolt Transformation Action Kamelet [\#525](https://github.com/apache/camel-kamelets/pull/525) ([oscerd](https://github.com/oscerd))
- Fix \#513: use valid CloudEvents attributes [\#524](https://github.com/apache/camel-kamelets/pull/524) ([nicolaferraro](https://github.com/nicolaferraro))
- Generated sources regen [\#523](https://github.com/apache/camel-kamelets/pull/523) ([github-actions[bot]](https://github.com/apps/github-actions))
- Fixed aws-cloudwatch-sink.kamelet.yaml by making set header work as i… [\#522](https://github.com/apache/camel-kamelets/pull/522) ([valdar](https://github.com/valdar))
- Chore: fix kamel bind command syntax and use Channel instead of InMemoryChannel [\#521](https://github.com/apache/camel-kamelets/pull/521) ([nicolaferraro](https://github.com/nicolaferraro))
- Camel-Kamelets-Catalog: Fixed SQS Tests [\#520](https://github.com/apache/camel-kamelets/pull/520) ([oscerd](https://github.com/oscerd))
- Regen documentation [\#519](https://github.com/apache/camel-kamelets/pull/519) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#518](https://github.com/apache/camel-kamelets/pull/518) ([github-actions[bot]](https://github.com/apps/github-actions))
- Added amazonAWSHost and protocol optional parameters to aws-sqs-\* kamelets. [\#517](https://github.com/apache/camel-kamelets/pull/517) ([valdar](https://github.com/valdar))
- Generated sources regen [\#514](https://github.com/apache/camel-kamelets/pull/514) ([github-actions[bot]](https://github.com/apps/github-actions))
- Exclude explicit quotes for chuck-norris source [\#512](https://github.com/apache/camel-kamelets/pull/512) ([rhuss](https://github.com/rhuss))
- Docs: add a link to the kamelet yaml in the related doc page [\#510](https://github.com/apache/camel-kamelets/pull/510) ([oscerd](https://github.com/oscerd))
- Provide dependency info in each kamelet's catalog page [\#509](https://github.com/apache/camel-kamelets/pull/509) ([oscerd](https://github.com/oscerd))
- Bump Wrapper to version 3.8.2 [\#508](https://github.com/apache/camel-kamelets/pull/508) ([oscerd](https://github.com/oscerd))
- AWS SNS Fifo Subject Support [\#507](https://github.com/apache/camel-kamelets/pull/507) ([oscerd](https://github.com/oscerd))
- AWS SNS Subject Header [\#506](https://github.com/apache/camel-kamelets/pull/506) ([oscerd](https://github.com/oscerd))
- AWS S3 Streaming Upload Kamelet: Support also StreamingUploadTimeout parameter [\#505](https://github.com/apache/camel-kamelets/pull/505) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#503](https://github.com/apache/camel-kamelets/pull/503) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated rabbitmq-source.kamelet.yaml [\#502](https://github.com/apache/camel-kamelets/pull/502) ([valdar](https://github.com/valdar))
- Update kamelets [\#501](https://github.com/apache/camel-kamelets/pull/501) ([nicolaferraro](https://github.com/nicolaferraro))
- Upgrade Jackson to version 2.12.5 [\#499](https://github.com/apache/camel-kamelets/pull/499) ([oscerd](https://github.com/oscerd))
- Upgrade Camel-k extension from kubernetes-client to version 5.7.3 [\#498](https://github.com/apache/camel-kamelets/pull/498) ([oscerd](https://github.com/oscerd))
- Minio Source and Sink: Remove reference to S3 [\#497](https://github.com/apache/camel-kamelets/pull/497) ([oscerd](https://github.com/oscerd))
- Minio Sink Kamelet: The exchangeId as object Name should be set as header and not as property [\#496](https://github.com/apache/camel-kamelets/pull/496) ([oscerd](https://github.com/oscerd))
- Google pubsub sink Kamelet [\#494](https://github.com/apache/camel-kamelets/pull/494) ([oscerd](https://github.com/oscerd))
- Google Pubsub Source Kamelet  [\#493](https://github.com/apache/camel-kamelets/pull/493) ([oscerd](https://github.com/oscerd))
- Google Pubsub Source Kamelet [\#492](https://github.com/apache/camel-kamelets/pull/492) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#489](https://github.com/apache/camel-kamelets/pull/489) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen [\#488](https://github.com/apache/camel-kamelets/pull/488) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Website\] Put block role in correct place in template. [\#487](https://github.com/apache/camel-kamelets/pull/487) ([djencks](https://github.com/djencks))
- mongodb-source: Changed properties username and password as optional. [\#486](https://github.com/apache/camel-kamelets/pull/486) ([valdar](https://github.com/valdar))
- Changed properties username and password as optional. [\#485](https://github.com/apache/camel-kamelets/pull/485) ([valdar](https://github.com/valdar))

## [v0.4.0](https://github.com/apache/camel-kamelets/tree/v0.4.0) (2021-09-03)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v0.3.0...v0.4.0)

**Closed issues:**

- Create Kubernetes resources Kamelet sources  [\#473](https://github.com/apache/camel-kamelets/issues/473)
- Add an XJ Identity action [\#470](https://github.com/apache/camel-kamelets/issues/470)
- KameletBinding - Component Credentials [\#468](https://github.com/apache/camel-kamelets/issues/468)
- How does many optional options design when use camel components in kamelets [\#467](https://github.com/apache/camel-kamelets/issues/467)
- insert-field-action has no documentation on how to set headers/fields as value [\#463](https://github.com/apache/camel-kamelets/issues/463)
- topicName param [\#459](https://github.com/apache/camel-kamelets/issues/459)
- Salesforce yaml [\#457](https://github.com/apache/camel-kamelets/issues/457)
- Add Azure CosmosDB Source Kamelet [\#445](https://github.com/apache/camel-kamelets/issues/445)
- Add a Json Schema Validator Action [\#442](https://github.com/apache/camel-kamelets/issues/442)
- Add an XJ Template Action [\#441](https://github.com/apache/camel-kamelets/issues/441)
- Add a Jsonata action Kamelet [\#426](https://github.com/apache/camel-kamelets/issues/426)
- Add a Chunk Template Action Kamelet [\#418](https://github.com/apache/camel-kamelets/issues/418)
- Add a String Template Action Kamelet [\#417](https://github.com/apache/camel-kamelets/issues/417)
- Add a Freemarker Template Action Kamelet [\#416](https://github.com/apache/camel-kamelets/issues/416)
- Add a Mvel Template Action Kamelet [\#415](https://github.com/apache/camel-kamelets/issues/415)
- Add a Velocity Template Action Kamelet [\#414](https://github.com/apache/camel-kamelets/issues/414)
- Kamelet with other components [\#413](https://github.com/apache/camel-kamelets/issues/413)
- Add a log sink kamelet [\#390](https://github.com/apache/camel-kamelets/issues/390)
- AWS S3 Kamelet \(source\) - fetch only meta-data [\#372](https://github.com/apache/camel-kamelets/issues/372)
- Split kamelet catalog and utilities [\#319](https://github.com/apache/camel-kamelets/issues/319)
- Add MongoDB Sink Kamelet  [\#158](https://github.com/apache/camel-kamelets/issues/158)

**Merged pull requests:**

- Revert "Put block role in correct place in template" [\#481](https://github.com/apache/camel-kamelets/pull/481) ([oscerd](https://github.com/oscerd))
- \[Website\] Put block role in correct place in template [\#480](https://github.com/apache/camel-kamelets/pull/480) ([djencks](https://github.com/djencks))
- Kubernetes nodes source Kamelet [\#479](https://github.com/apache/camel-kamelets/pull/479) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#478](https://github.com/apache/camel-kamelets/pull/478) ([github-actions[bot]](https://github.com/apps/github-actions))
- Added camel:bean dependency to elasticsearch-index-sink.kamelet.yaml [\#477](https://github.com/apache/camel-kamelets/pull/477) ([valdar](https://github.com/valdar))
- Kubernetes Pods Source Kamelets [\#476](https://github.com/apache/camel-kamelets/pull/476) ([oscerd](https://github.com/oscerd))
- Use stable released version of Yaks 0.4.0 [\#475](https://github.com/apache/camel-kamelets/pull/475) ([oscerd](https://github.com/oscerd))
- Kubernetes namespaces Source Kamelet [\#474](https://github.com/apache/camel-kamelets/pull/474) ([oscerd](https://github.com/oscerd))
- XJ Template Action Kamelet [\#472](https://github.com/apache/camel-kamelets/pull/472) ([oscerd](https://github.com/oscerd))
- XJ Identity Action Kamelet [\#471](https://github.com/apache/camel-kamelets/pull/471) ([oscerd](https://github.com/oscerd))
- Insert field action doc [\#466](https://github.com/apache/camel-kamelets/pull/466) ([oscerd](https://github.com/oscerd))
- Added support for generating YAML binding template files [\#465](https://github.com/apache/camel-kamelets/pull/465) ([orpiske](https://github.com/orpiske))
- Externalize the Kamelet binding template in the Kafka Source [\#456](https://github.com/apache/camel-kamelets/pull/456) ([orpiske](https://github.com/orpiske))
- Generated sources regen [\#455](https://github.com/apache/camel-kamelets/pull/455) ([github-actions[bot]](https://github.com/apps/github-actions))
- Remove wrong type in aws-sqs-source [\#454](https://github.com/apache/camel-kamelets/pull/454) ([nicolaferraro](https://github.com/nicolaferraro))
- AWS s3 Streaming upload: minor fixes to docs and default value [\#453](https://github.com/apache/camel-kamelets/pull/453) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#452](https://github.com/apache/camel-kamelets/pull/452) ([github-actions[bot]](https://github.com/apps/github-actions))
- Create log-sink.kamelet.yaml [\#451](https://github.com/apache/camel-kamelets/pull/451) ([nicolaferraro](https://github.com/nicolaferraro))
- Azure storage blob source fix [\#450](https://github.com/apache/camel-kamelets/pull/450) ([oscerd](https://github.com/oscerd))
- Azure CosmosDB Source Kamelet [\#447](https://github.com/apache/camel-kamelets/pull/447) ([oscerd](https://github.com/oscerd))
- Added Velocity-based templates for the Kamelets [\#444](https://github.com/apache/camel-kamelets/pull/444) ([orpiske](https://github.com/orpiske))
- Json validator Kamelet action [\#443](https://github.com/apache/camel-kamelets/pull/443) ([oscerd](https://github.com/oscerd))
- Elasticsearch Sink Index: Fixed default value for indexName and indexId [\#440](https://github.com/apache/camel-kamelets/pull/440) ([oscerd](https://github.com/oscerd))
- String template Kamelet action [\#439](https://github.com/apache/camel-kamelets/pull/439) ([oscerd](https://github.com/oscerd))
- Chunk template Kamelet Action [\#438](https://github.com/apache/camel-kamelets/pull/438) ([oscerd](https://github.com/oscerd))
- Freemarker Template Kamelet Action [\#437](https://github.com/apache/camel-kamelets/pull/437) ([oscerd](https://github.com/oscerd))
- Http Sink Remove CamelHttpUri Header [\#436](https://github.com/apache/camel-kamelets/pull/436) ([oscerd](https://github.com/oscerd))
- MVEL Template Kamelet Action [\#435](https://github.com/apache/camel-kamelets/pull/435) ([oscerd](https://github.com/oscerd))
- AWS S3 Kamelet \(source\) - fetch only meta-data [\#434](https://github.com/apache/camel-kamelets/pull/434) ([oscerd](https://github.com/oscerd))
- AWS S3 Source: Added Prefix parameter as optional parameter [\#433](https://github.com/apache/camel-kamelets/pull/433) ([oscerd](https://github.com/oscerd))
- Kafka Sink/source Kamelets: Changing some parameters name [\#432](https://github.com/apache/camel-kamelets/pull/432) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#431](https://github.com/apache/camel-kamelets/pull/431) ([github-actions[bot]](https://github.com/apps/github-actions))
- Velocity Template action [\#430](https://github.com/apache/camel-kamelets/pull/430) ([oscerd](https://github.com/oscerd))
- Add slack sink kamelet [\#429](https://github.com/apache/camel-kamelets/pull/429) ([doru1004](https://github.com/doru1004))
- Jsonata action Kamelet [\#427](https://github.com/apache/camel-kamelets/pull/427) ([oscerd](https://github.com/oscerd))
- Elasticsearch search Kamelet: User and password are optional [\#425](https://github.com/apache/camel-kamelets/pull/425) ([oscerd](https://github.com/oscerd))
- Elasticsearch Index Sink: User/password optional, fixed headers [\#424](https://github.com/apache/camel-kamelets/pull/424) ([oscerd](https://github.com/oscerd))
- ci: configure concurrency and workflow\_dispatch [\#422](https://github.com/apache/camel-kamelets/pull/422) ([lburgazzoli](https://github.com/lburgazzoli))
- Update deps [\#421](https://github.com/apache/camel-kamelets/pull/421) ([lburgazzoli](https://github.com/lburgazzoli))
- Split kamelet catalog and utilities \#319 [\#420](https://github.com/apache/camel-kamelets/pull/420) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix aws-kinesis-sink [\#419](https://github.com/apache/camel-kamelets/pull/419) ([nicolaferraro](https://github.com/nicolaferraro))
- Generated sources regen [\#411](https://github.com/apache/camel-kamelets/pull/411) ([github-actions[bot]](https://github.com/apps/github-actions))
- chore\(validator\): additional checks on kamelets and fix infinispan so… [\#410](https://github.com/apache/camel-kamelets/pull/410) ([nicolaferraro](https://github.com/nicolaferraro))
- CAMEL-16788: workaround to prevent override from system env variables [\#409](https://github.com/apache/camel-kamelets/pull/409) ([nicolaferraro](https://github.com/nicolaferraro))

## [v0.3.0](https://github.com/apache/camel-kamelets/tree/v0.3.0) (2021-07-01)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v0.2.1...v0.3.0)

**Closed issues:**

- Add a Mustache Template Action Kamelet [\#406](https://github.com/apache/camel-kamelets/issues/406)
- Create MS SQL Server Source Kamelet [\#365](https://github.com/apache/camel-kamelets/issues/365)
- Create MS SQL Server Sink Kamelet  [\#364](https://github.com/apache/camel-kamelets/issues/364)
- Create MariaDB Source Kamelet [\#360](https://github.com/apache/camel-kamelets/issues/360)
- Create MariaDB Sink Kamelet [\#359](https://github.com/apache/camel-kamelets/issues/359)
- Create PostgreSQL Source Kamelet [\#356](https://github.com/apache/camel-kamelets/issues/356)
- Create PostgreSQL Sink Kamelet [\#355](https://github.com/apache/camel-kamelets/issues/355)
- Create MySQL Source Kamelet [\#353](https://github.com/apache/camel-kamelets/issues/353)
- Create MySQL Sink Kamelet [\#352](https://github.com/apache/camel-kamelets/issues/352)
- AWS Kinesis Kamelets: Region is not capitalized  [\#347](https://github.com/apache/camel-kamelets/issues/347)
- Space in property "name" of insert-header-action cause IllegalArgumentException [\#346](https://github.com/apache/camel-kamelets/issues/346)
- Header Matches Filter Action Kamelet [\#344](https://github.com/apache/camel-kamelets/issues/344)
- Add a Predicate Filter Action Kamelet [\#342](https://github.com/apache/camel-kamelets/issues/342)
- Topic Name Matches Filter Action [\#340](https://github.com/apache/camel-kamelets/issues/340)
- Add Tombstone filter  [\#338](https://github.com/apache/camel-kamelets/issues/338)
- Has Header action [\#336](https://github.com/apache/camel-kamelets/issues/336)
- Support Google cloud dataproc kafka sink [\#333](https://github.com/apache/camel-kamelets/issues/333)
- Add BatchSize to AWS S3 Streaming Upload Kamelet [\#332](https://github.com/apache/camel-kamelets/issues/332)
- Add an AWS S3 Streaming upload Kamelet [\#326](https://github.com/apache/camel-kamelets/issues/326)
- Create a SQL Sink Kamelet [\#325](https://github.com/apache/camel-kamelets/issues/325)
- Create a SQL Source Kamelet [\#324](https://github.com/apache/camel-kamelets/issues/324)
- Create a JMS Sink Kamelet [\#323](https://github.com/apache/camel-kamelets/issues/323)
- Create a JMS Source Kamelet [\#322](https://github.com/apache/camel-kamelets/issues/322)
- Add support level information to generated adoc for each kamelet  [\#315](https://github.com/apache/camel-kamelets/issues/315)
- SFTP Sink Kamelet [\#306](https://github.com/apache/camel-kamelets/issues/306)
- FTPS Sink Kamelet [\#305](https://github.com/apache/camel-kamelets/issues/305)
- FTP Sink Kamelet [\#303](https://github.com/apache/camel-kamelets/issues/303)
- Add NATS Sink Kamelet [\#301](https://github.com/apache/camel-kamelets/issues/301)
- Add an AWS Translate action [\#297](https://github.com/apache/camel-kamelets/issues/297)
- Add an HTTP/HTTPS secured version of the Kamelet source [\#295](https://github.com/apache/camel-kamelets/issues/295)
- Add an HTTP/HTTPS secured version of the kamelet sink [\#294](https://github.com/apache/camel-kamelets/issues/294)
- Add MessageTimestampRouter action [\#287](https://github.com/apache/camel-kamelets/issues/287)
- Add TimestampRouter action [\#286](https://github.com/apache/camel-kamelets/issues/286)
- Elasticsearch Sink KameletBinding fails to build [\#285](https://github.com/apache/camel-kamelets/issues/285)
- Add RegexRouter action [\#278](https://github.com/apache/camel-kamelets/issues/278)
- Hoist field should work with primitive types [\#262](https://github.com/apache/camel-kamelets/issues/262)
- Actions should not marshal into JSON if the input was not JSON [\#261](https://github.com/apache/camel-kamelets/issues/261)
- Add Hoistfield action [\#258](https://github.com/apache/camel-kamelets/issues/258)
- Provide a avro-deserialize-action and a avro-serialize-action [\#245](https://github.com/apache/camel-kamelets/issues/245)
- Provide a json-deserialize-action and a json-serialize-action [\#244](https://github.com/apache/camel-kamelets/issues/244)
- Switch to JSONNode as intermediate representation in transformations [\#243](https://github.com/apache/camel-kamelets/issues/243)
- Invalid label values [\#238](https://github.com/apache/camel-kamelets/issues/238)
- Add an Extract Field Action [\#236](https://github.com/apache/camel-kamelets/issues/236)
- Add group label methods to Kamelets Catalog [\#235](https://github.com/apache/camel-kamelets/issues/235)
- Add Value To Key Action [\#227](https://github.com/apache/camel-kamelets/issues/227)
- Avoid Kamelets Catalog to throw IOException [\#225](https://github.com/apache/camel-kamelets/issues/225)
- Strip .kamelet from kamelets included in the catalog [\#224](https://github.com/apache/camel-kamelets/issues/224)
- Add group label to all kamelets [\#223](https://github.com/apache/camel-kamelets/issues/223)
- Add labels related to kamelets trust level [\#222](https://github.com/apache/camel-kamelets/issues/222)
- Declare implicit dependencies [\#214](https://github.com/apache/camel-kamelets/issues/214)
- Publish snapshots on Apache snapshots repository of the kamelet catalog [\#213](https://github.com/apache/camel-kamelets/issues/213)
- KameletCatalog is empty with a bundled jar [\#209](https://github.com/apache/camel-kamelets/issues/209)
- Add Kafka Sink Kamelet not authenticated [\#206](https://github.com/apache/camel-kamelets/issues/206)
- Add Kafka Source Kamelet not authenticated  [\#205](https://github.com/apache/camel-kamelets/issues/205)
- Add a Kafka Sink Kamelet authenticated  [\#204](https://github.com/apache/camel-kamelets/issues/204)
- Add a Kafka Source Kamelet authenticated [\#203](https://github.com/apache/camel-kamelets/issues/203)
- Add a Mask Field Action [\#196](https://github.com/apache/camel-kamelets/issues/196)
- Add a replace field action [\#195](https://github.com/apache/camel-kamelets/issues/195)
- Add an Insert Header action [\#194](https://github.com/apache/camel-kamelets/issues/194)
- Add a Kafka Sink Kamelet [\#189](https://github.com/apache/camel-kamelets/issues/189)
- Add a GH Action for recreate the kamelet catalog on each commit [\#179](https://github.com/apache/camel-kamelets/issues/179)
- Password definition [\#178](https://github.com/apache/camel-kamelets/issues/178)
- Add a caffeine-cache action [\#169](https://github.com/apache/camel-kamelets/issues/169)
- Add DNS ip, dig and lookup Kamelet actions [\#168](https://github.com/apache/camel-kamelets/issues/168)
- Kamelet Catalog as Maven dependency [\#165](https://github.com/apache/camel-kamelets/issues/165)
- Add CassandraQL sink Kamelet [\#162](https://github.com/apache/camel-kamelets/issues/162)
- Add CassandraQL Source Kamelet [\#161](https://github.com/apache/camel-kamelets/issues/161)
- Add MongoDB Source Kamelet [\#159](https://github.com/apache/camel-kamelets/issues/159)
- Add an Exec Sink Kamelet [\#155](https://github.com/apache/camel-kamelets/issues/155)
- Add kamel bind command to documentation [\#146](https://github.com/apache/camel-kamelets/issues/146)
- Allow kamelets of type action [\#145](https://github.com/apache/camel-kamelets/issues/145)
- Create Azure Storage Queue Source Kamelet [\#139](https://github.com/apache/camel-kamelets/issues/139)
- Add an AWS SQS Batch Sink Kamelet [\#137](https://github.com/apache/camel-kamelets/issues/137)
- Add AWS Kinesis Sink Kamelet [\#118](https://github.com/apache/camel-kamelets/issues/118)
- Add AWS EC2 Sink Kamelet [\#117](https://github.com/apache/camel-kamelets/issues/117)
- Add AWS CloudWatch sink [\#116](https://github.com/apache/camel-kamelets/issues/116)
- Add Git Source Kamelet [\#64](https://github.com/apache/camel-kamelets/issues/64)
- Add an Infinispan source kamelet [\#62](https://github.com/apache/camel-kamelets/issues/62)

**Merged pull requests:**

- Mustache Template Action Kamelet [\#407](https://github.com/apache/camel-kamelets/pull/407) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#405](https://github.com/apache/camel-kamelets/pull/405) ([github-actions[bot]](https://github.com/apps/github-actions))
- Fixed invalid connection URL parameter in JMS AMQP Kamelets [\#404](https://github.com/apache/camel-kamelets/pull/404) ([orpiske](https://github.com/orpiske))
- Fixed broken dependency specification for the JMS AMQP Kamelet [\#403](https://github.com/apache/camel-kamelets/pull/403) ([orpiske](https://github.com/orpiske))
- Stop using kamelet-reify for JMS Kamelets [\#402](https://github.com/apache/camel-kamelets/pull/402) ([orpiske](https://github.com/orpiske))
- Enhance mongodb sink kamelet [\#401](https://github.com/apache/camel-kamelets/pull/401) ([claudio4j](https://github.com/claudio4j))
- MongoDB Sink Kamelet [\#400](https://github.com/apache/camel-kamelets/pull/400) ([oscerd](https://github.com/oscerd))
- MongoDB Source Kamelet Improvements [\#399](https://github.com/apache/camel-kamelets/pull/399) ([oscerd](https://github.com/oscerd))
- MongoDB Source Kamelet [\#398](https://github.com/apache/camel-kamelets/pull/398) ([oscerd](https://github.com/oscerd))
- AWS Kinesis source kamelet [\#395](https://github.com/apache/camel-kamelets/pull/395) ([oscerd](https://github.com/oscerd))
- AWS Kinesis Kamelet Source [\#393](https://github.com/apache/camel-kamelets/pull/393) ([oscerd](https://github.com/oscerd))
- AWS Kinesis Source Kamelet [\#392](https://github.com/apache/camel-kamelets/pull/392) ([oscerd](https://github.com/oscerd))
- Fix JMS Kamelets names [\#391](https://github.com/apache/camel-kamelets/pull/391) ([orpiske](https://github.com/orpiske))
- Use template for documents and add kamel bind and Kafka instructions [\#388](https://github.com/apache/camel-kamelets/pull/388) ([nicolaferraro](https://github.com/nicolaferraro))
- AWS EC2 Sink Kamelet [\#387](https://github.com/apache/camel-kamelets/pull/387) ([oscerd](https://github.com/oscerd))
- AWS EC2 Sink Kamelet [\#386](https://github.com/apache/camel-kamelets/pull/386) ([oscerd](https://github.com/oscerd))
- SQL Server Source Kamelet [\#385](https://github.com/apache/camel-kamelets/pull/385) ([oscerd](https://github.com/oscerd))
- Fix MariaDB Sink Kamelet [\#384](https://github.com/apache/camel-kamelets/pull/384) ([oscerd](https://github.com/oscerd))
- MariaDB Source Kamelet [\#383](https://github.com/apache/camel-kamelets/pull/383) ([oscerd](https://github.com/oscerd))
- MySQL Source Kamelet [\#382](https://github.com/apache/camel-kamelets/pull/382) ([oscerd](https://github.com/oscerd))
- PostgreSQL Source Kamelet [\#381](https://github.com/apache/camel-kamelets/pull/381) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#380](https://github.com/apache/camel-kamelets/pull/380) ([github-actions[bot]](https://github.com/apps/github-actions))
- Cassandra Sink: Added the in type [\#379](https://github.com/apache/camel-kamelets/pull/379) ([oscerd](https://github.com/oscerd))
- S3 Batch Size For Streaming Upload [\#378](https://github.com/apache/camel-kamelets/pull/378) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#377](https://github.com/apache/camel-kamelets/pull/377) ([github-actions[bot]](https://github.com/apps/github-actions))
- AWS S3 Source Kamelet add includeBody Option [\#375](https://github.com/apache/camel-kamelets/pull/375) ([oscerd](https://github.com/oscerd))
- Added JMS sink kamelet for AMQP 1.0 [\#374](https://github.com/apache/camel-kamelets/pull/374) ([orpiske](https://github.com/orpiske))
- Added a JMS sink Kamelet for Apache Artemis [\#373](https://github.com/apache/camel-kamelets/pull/373) ([orpiske](https://github.com/orpiske))
- SQL Kamelets completed [\#371](https://github.com/apache/camel-kamelets/pull/371) ([oscerd](https://github.com/oscerd))
- MariaDB Sink Kamelet fix description and more information [\#370](https://github.com/apache/camel-kamelets/pull/370) ([oscerd](https://github.com/oscerd))
- MySQL Sink Kamelet Fix description [\#369](https://github.com/apache/camel-kamelets/pull/369) ([oscerd](https://github.com/oscerd))
- PostgreSQL Sink Kamelet more information [\#368](https://github.com/apache/camel-kamelets/pull/368) ([oscerd](https://github.com/oscerd))
- SQL Server Sink description and type [\#367](https://github.com/apache/camel-kamelets/pull/367) ([oscerd](https://github.com/oscerd))
- MS SQL Server Sink Kamelet [\#366](https://github.com/apache/camel-kamelets/pull/366) ([oscerd](https://github.com/oscerd))
- Added JMS source kamelet for Apache Artermis [\#363](https://github.com/apache/camel-kamelets/pull/363) ([orpiske](https://github.com/orpiske))
- AMQP JMS source kamelet [\#362](https://github.com/apache/camel-kamelets/pull/362) ([orpiske](https://github.com/orpiske))
- MariaDB Sink Kamelet [\#361](https://github.com/apache/camel-kamelets/pull/361) ([oscerd](https://github.com/oscerd))
- MySQL minor fixes [\#358](https://github.com/apache/camel-kamelets/pull/358) ([oscerd](https://github.com/oscerd))
- Postgresql sink Kamelet [\#357](https://github.com/apache/camel-kamelets/pull/357) ([oscerd](https://github.com/oscerd))
- MySQL Sink Kamelet [\#354](https://github.com/apache/camel-kamelets/pull/354) ([oscerd](https://github.com/oscerd))
- Has Header Filter Example Field [\#351](https://github.com/apache/camel-kamelets/pull/351) ([oscerd](https://github.com/oscerd))
- Header Matches Filter Action Kamelet [\#350](https://github.com/apache/camel-kamelets/pull/350) ([oscerd](https://github.com/oscerd))
- AWS Kinesis Kamelets: Region is not capitalized [\#349](https://github.com/apache/camel-kamelets/pull/349) ([oscerd](https://github.com/oscerd))
- Space in property "name" of insert-header-action cause IllegalArgumentException [\#348](https://github.com/apache/camel-kamelets/pull/348) ([oscerd](https://github.com/oscerd))
- Space in property "name" of insert-header-action seems to cause java.… [\#345](https://github.com/apache/camel-kamelets/pull/345) ([lfabriko](https://github.com/lfabriko))
- Predicate filter Action Kamelet [\#343](https://github.com/apache/camel-kamelets/pull/343) ([oscerd](https://github.com/oscerd))
- Topic names matches filter action [\#341](https://github.com/apache/camel-kamelets/pull/341) ([oscerd](https://github.com/oscerd))
- Tombstone filter [\#339](https://github.com/apache/camel-kamelets/pull/339) ([oscerd](https://github.com/oscerd))
- Has Header Action [\#337](https://github.com/apache/camel-kamelets/pull/337) ([oscerd](https://github.com/oscerd))
- Azure storage queue source [\#334](https://github.com/apache/camel-kamelets/pull/334) ([oscerd](https://github.com/oscerd))
- Add protobuf serdes [\#331](https://github.com/apache/camel-kamelets/pull/331) ([nicolaferraro](https://github.com/nicolaferraro))
- Avro serialization and deserialization [\#330](https://github.com/apache/camel-kamelets/pull/330) ([nicolaferraro](https://github.com/nicolaferraro))
- AWS S3 Sink Kamelet: removed Override option for URI [\#329](https://github.com/apache/camel-kamelets/pull/329) ([oscerd](https://github.com/oscerd))
- Aws2 s3 sink streaming upload [\#327](https://github.com/apache/camel-kamelets/pull/327) ([oscerd](https://github.com/oscerd))
- Regen chuck norris source kamelet through generator [\#321](https://github.com/apache/camel-kamelets/pull/321) ([oscerd](https://github.com/oscerd))
- Chuck Norris Kamelet [\#318](https://github.com/apache/camel-kamelets/pull/318) ([davsclaus](https://github.com/davsclaus))
- Added support level to autogenerated docs for Kamelets [\#316](https://github.com/apache/camel-kamelets/pull/316) ([oscerd](https://github.com/oscerd))
- Added Support Level annotation to kamelet [\#314](https://github.com/apache/camel-kamelets/pull/314) ([oscerd](https://github.com/oscerd))
- SFTP Sink Kamelet  [\#313](https://github.com/apache/camel-kamelets/pull/313) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#310](https://github.com/apache/camel-kamelets/pull/310) ([github-actions[bot]](https://github.com/apps/github-actions))
- FTPS Sink Kamelet [\#308](https://github.com/apache/camel-kamelets/pull/308) ([oscerd](https://github.com/oscerd))
- Update release scripts to work with maven release [\#307](https://github.com/apache/camel-kamelets/pull/307) ([nicolaferraro](https://github.com/nicolaferraro))
- FTP Sink Kamelet  [\#304](https://github.com/apache/camel-kamelets/pull/304) ([oscerd](https://github.com/oscerd))
- NATS Sink Kamelet [\#302](https://github.com/apache/camel-kamelets/pull/302) ([oscerd](https://github.com/oscerd))
- Listing AWS Translate supported language in description [\#300](https://github.com/apache/camel-kamelets/pull/300) ([oscerd](https://github.com/oscerd))
- AWS Translate action [\#299](https://github.com/apache/camel-kamelets/pull/299) ([oscerd](https://github.com/oscerd))
- Http secured sink Kamelet [\#298](https://github.com/apache/camel-kamelets/pull/298) ([oscerd](https://github.com/oscerd))
- Http secured source [\#296](https://github.com/apache/camel-kamelets/pull/296) ([oscerd](https://github.com/oscerd))
- Message timestamp router action [\#293](https://github.com/apache/camel-kamelets/pull/293) ([oscerd](https://github.com/oscerd))
- Timestamp router action is no more an action kafka specific only [\#292](https://github.com/apache/camel-kamelets/pull/292) ([oscerd](https://github.com/oscerd))
- Use Json as output only where it makes sense [\#291](https://github.com/apache/camel-kamelets/pull/291) ([oscerd](https://github.com/oscerd))
- Align timestamp router action [\#290](https://github.com/apache/camel-kamelets/pull/290) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#289](https://github.com/apache/camel-kamelets/pull/289) ([github-actions[bot]](https://github.com/apps/github-actions))
- Timestamp router action [\#288](https://github.com/apache/camel-kamelets/pull/288) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#283](https://github.com/apache/camel-kamelets/pull/283) ([github-actions[bot]](https://github.com/apps/github-actions))
- feature\(es-sink\): Make indexName optional. [\#282](https://github.com/apache/camel-kamelets/pull/282) ([Delawen](https://github.com/Delawen))
- Fix CI tests [\#281](https://github.com/apache/camel-kamelets/pull/281) ([nicolaferraro](https://github.com/nicolaferraro))
- chore: fix website doc [\#280](https://github.com/apache/camel-kamelets/pull/280) ([nicolaferraro](https://github.com/nicolaferraro))
- Regex Router Action [\#279](https://github.com/apache/camel-kamelets/pull/279) ([oscerd](https://github.com/oscerd))
- Value to Key Action: Use KafkaConstants class for referencing Kafka K… [\#277](https://github.com/apache/camel-kamelets/pull/277) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#276](https://github.com/apache/camel-kamelets/pull/276) ([github-actions[bot]](https://github.com/apps/github-actions))
- Kafka Source \#247 [\#275](https://github.com/apache/camel-kamelets/pull/275) ([oscerd](https://github.com/oscerd))
- Kafka not secured fix for \#247 [\#274](https://github.com/apache/camel-kamelets/pull/274) ([oscerd](https://github.com/oscerd))
- Adding indexId to ElasticSearch Sink kamelet. [\#273](https://github.com/apache/camel-kamelets/pull/273) ([Delawen](https://github.com/Delawen))
- Generated sources regen [\#272](https://github.com/apache/camel-kamelets/pull/272) ([github-actions[bot]](https://github.com/apps/github-actions))
- Add openai-classification action [\#271](https://github.com/apache/camel-kamelets/pull/271) ([nicolaferraro](https://github.com/nicolaferraro))
- Manual commit kafka action [\#270](https://github.com/apache/camel-kamelets/pull/270) ([oscerd](https://github.com/oscerd))
- Insert field Action \#261 [\#269](https://github.com/apache/camel-kamelets/pull/269) ([oscerd](https://github.com/oscerd))
- Mask field Action \#261 [\#268](https://github.com/apache/camel-kamelets/pull/268) ([oscerd](https://github.com/oscerd))
- Replace Field action \#261 [\#267](https://github.com/apache/camel-kamelets/pull/267) ([oscerd](https://github.com/oscerd))
- Value to key \#261 [\#266](https://github.com/apache/camel-kamelets/pull/266) ([oscerd](https://github.com/oscerd))
- Json serialize action [\#265](https://github.com/apache/camel-kamelets/pull/265) ([oscerd](https://github.com/oscerd))
- Json deserialize action [\#264](https://github.com/apache/camel-kamelets/pull/264) ([oscerd](https://github.com/oscerd))
- Extract Field update [\#263](https://github.com/apache/camel-kamelets/pull/263) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#260](https://github.com/apache/camel-kamelets/pull/260) ([github-actions[bot]](https://github.com/apps/github-actions))
- Hoistfield action [\#259](https://github.com/apache/camel-kamelets/pull/259) ([oscerd](https://github.com/oscerd))
- Added HoistField method in utils library [\#257](https://github.com/apache/camel-kamelets/pull/257) ([oscerd](https://github.com/oscerd))
- Add group label methods to Kamelets Catalog [\#256](https://github.com/apache/camel-kamelets/pull/256) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#255](https://github.com/apache/camel-kamelets/pull/255) ([github-actions[bot]](https://github.com/apps/github-actions))
- Issue/214 [\#254](https://github.com/apache/camel-kamelets/pull/254) ([valdar](https://github.com/valdar))
- Generated sources regen [\#252](https://github.com/apache/camel-kamelets/pull/252) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen [\#251](https://github.com/apache/camel-kamelets/pull/251) ([github-actions[bot]](https://github.com/apps/github-actions))
- Replace field Action JsonNode [\#249](https://github.com/apache/camel-kamelets/pull/249) ([oscerd](https://github.com/oscerd))
- Mask Field JsonNode [\#248](https://github.com/apache/camel-kamelets/pull/248) ([oscerd](https://github.com/oscerd))
- Insert Field Action updated [\#246](https://github.com/apache/camel-kamelets/pull/246) ([oscerd](https://github.com/oscerd))
- Mask Field Action [\#242](https://github.com/apache/camel-kamelets/pull/242) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#241](https://github.com/apache/camel-kamelets/pull/241) ([github-actions[bot]](https://github.com/apps/github-actions))
- chore: add checks for duplicate titles and descriptions and fix format [\#240](https://github.com/apache/camel-kamelets/pull/240) ([nicolaferraro](https://github.com/nicolaferraro))
- Group as annotation and not label [\#239](https://github.com/apache/camel-kamelets/pull/239) ([oscerd](https://github.com/oscerd))
- Extract field Action [\#237](https://github.com/apache/camel-kamelets/pull/237) ([oscerd](https://github.com/oscerd))
- Labels group [\#234](https://github.com/apache/camel-kamelets/pull/234) ([oscerd](https://github.com/oscerd))
- More Group labels [\#233](https://github.com/apache/camel-kamelets/pull/233) ([oscerd](https://github.com/oscerd))
- More group labels [\#232](https://github.com/apache/camel-kamelets/pull/232) ([oscerd](https://github.com/oscerd))
- More group labels  [\#231](https://github.com/apache/camel-kamelets/pull/231) ([oscerd](https://github.com/oscerd))
- Azure Kamelet Group Label [\#230](https://github.com/apache/camel-kamelets/pull/230) ([oscerd](https://github.com/oscerd))
- AWS Kamelet Group Label [\#229](https://github.com/apache/camel-kamelets/pull/229) ([oscerd](https://github.com/oscerd))
- Value to key Action [\#228](https://github.com/apache/camel-kamelets/pull/228) ([oscerd](https://github.com/oscerd))
- Avoid IOException on constructor \#225 [\#226](https://github.com/apache/camel-kamelets/pull/226) ([apupier](https://github.com/apupier))
- Kafka sink Kamelet [\#221](https://github.com/apache/camel-kamelets/pull/221) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#220](https://github.com/apache/camel-kamelets/pull/220) ([github-actions[bot]](https://github.com/apps/github-actions))
- Fix kafka sink not secured [\#219](https://github.com/apache/camel-kamelets/pull/219) ([oscerd](https://github.com/oscerd))
- Add a gh action for deploying the camel-kamelets catalog and library [\#218](https://github.com/apache/camel-kamelets/pull/218) ([oscerd](https://github.com/oscerd))
- Add a gh action for deploying the camel-kamelets catalog and library [\#217](https://github.com/apache/camel-kamelets/pull/217) ([oscerd](https://github.com/oscerd))
- Add a gh action for deploying the camel-kamelets catalog and library [\#216](https://github.com/apache/camel-kamelets/pull/216) ([oscerd](https://github.com/oscerd))
- Kafka Sink Kamelet not secured [\#215](https://github.com/apache/camel-kamelets/pull/215) ([oscerd](https://github.com/oscerd))
- Remove unused import [\#212](https://github.com/apache/camel-kamelets/pull/212) ([apupier](https://github.com/apupier))
- Kafka not secured source [\#211](https://github.com/apache/camel-kamelets/pull/211) ([oscerd](https://github.com/oscerd))
- KameletCatalog is empty with a bundled jar [\#210](https://github.com/apache/camel-kamelets/pull/210) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#208](https://github.com/apache/camel-kamelets/pull/208) ([github-actions[bot]](https://github.com/apps/github-actions))
- Kafka source authenticated [\#207](https://github.com/apache/camel-kamelets/pull/207) ([oscerd](https://github.com/oscerd))
- chore: remove dependency from quarkus and use default format for depe… [\#202](https://github.com/apache/camel-kamelets/pull/202) ([nicolaferraro](https://github.com/nicolaferraro))
- Generated sources regen [\#201](https://github.com/apache/camel-kamelets/pull/201) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen [\#200](https://github.com/apache/camel-kamelets/pull/200) ([github-actions[bot]](https://github.com/apps/github-actions))
- fix kamelet test [\#199](https://github.com/apache/camel-kamelets/pull/199) ([nicolaferraro](https://github.com/nicolaferraro))
- Generated sources regen [\#198](https://github.com/apache/camel-kamelets/pull/198) ([github-actions[bot]](https://github.com/apps/github-actions))
- Insert header action [\#197](https://github.com/apache/camel-kamelets/pull/197) ([oscerd](https://github.com/oscerd))
- Generated sources regen [\#193](https://github.com/apache/camel-kamelets/pull/193) ([github-actions[bot]](https://github.com/apps/github-actions))
- Refactor code to add utility library [\#192](https://github.com/apache/camel-kamelets/pull/192) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix json schema type, password fields and invalid YAML [\#188](https://github.com/apache/camel-kamelets/pull/188) ([nicolaferraro](https://github.com/nicolaferraro))
- Generated sources regen [\#187](https://github.com/apache/camel-kamelets/pull/187) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen [\#186](https://github.com/apache/camel-kamelets/pull/186) ([github-actions[bot]](https://github.com/apps/github-actions))
- Add validator bound to the CI and fix kamelets [\#185](https://github.com/apache/camel-kamelets/pull/185) ([nicolaferraro](https://github.com/nicolaferraro))
- Generated sources regen [\#183](https://github.com/apache/camel-kamelets/pull/183) ([github-actions[bot]](https://github.com/apps/github-actions))
- Generated sources regen [\#182](https://github.com/apache/camel-kamelets/pull/182) ([github-actions[bot]](https://github.com/apps/github-actions))
- Infinispan Source Kamelet [\#180](https://github.com/apache/camel-kamelets/pull/180) ([oscerd](https://github.com/oscerd))
- Caffeine action Kamelet [\#175](https://github.com/apache/camel-kamelets/pull/175) ([oscerd](https://github.com/oscerd))
- Dns lookup Action Kamelet [\#174](https://github.com/apache/camel-kamelets/pull/174) ([oscerd](https://github.com/oscerd))
- Elasticsearch sink to insert data [\#173](https://github.com/apache/camel-kamelets/pull/173) ([Delawen](https://github.com/Delawen))
- ElasticSearch search source kamelet [\#172](https://github.com/apache/camel-kamelets/pull/172) ([Delawen](https://github.com/Delawen))
- DNS DIG Action Kamelet [\#171](https://github.com/apache/camel-kamelets/pull/171) ([oscerd](https://github.com/oscerd))
- DNS IP Action [\#170](https://github.com/apache/camel-kamelets/pull/170) ([oscerd](https://github.com/oscerd))
- Cassandra source fix [\#167](https://github.com/apache/camel-kamelets/pull/167) ([oscerd](https://github.com/oscerd))
- CQL Sink Kamelet [\#166](https://github.com/apache/camel-kamelets/pull/166) ([oscerd](https://github.com/oscerd))
- CQL Source Kamelet [\#164](https://github.com/apache/camel-kamelets/pull/164) ([oscerd](https://github.com/oscerd))
- Add OpenAI Completion Kamelet Action [\#163](https://github.com/apache/camel-kamelets/pull/163) ([nicolaferraro](https://github.com/nicolaferraro))
- AWS Kinesis Sink Kamelet [\#157](https://github.com/apache/camel-kamelets/pull/157) ([oscerd](https://github.com/oscerd))
- Exec sink Kamelet [\#156](https://github.com/apache/camel-kamelets/pull/156) ([oscerd](https://github.com/oscerd))
- AWS SQS Batch sink [\#154](https://github.com/apache/camel-kamelets/pull/154) ([oscerd](https://github.com/oscerd))
- Fix \#145: allow kamelets of type action and doc [\#153](https://github.com/apache/camel-kamelets/pull/153) ([nicolaferraro](https://github.com/nicolaferraro))
- Azure eventhubs sink Kamelet [\#151](https://github.com/apache/camel-kamelets/pull/151) ([oscerd](https://github.com/oscerd))
- Azure eventhubs source Kamelet [\#150](https://github.com/apache/camel-kamelets/pull/150) ([oscerd](https://github.com/oscerd))
- Cron Source Kamelet [\#147](https://github.com/apache/camel-kamelets/pull/147) ([oscerd](https://github.com/oscerd))
- PDF Action Kamelet [\#144](https://github.com/apache/camel-kamelets/pull/144) ([oscerd](https://github.com/oscerd))
- Azure storage queue sink [\#143](https://github.com/apache/camel-kamelets/pull/143) ([oscerd](https://github.com/oscerd))
- chore\(release\): add release script [\#141](https://github.com/apache/camel-kamelets/pull/141) ([nicolaferraro](https://github.com/nicolaferraro))
- Add HTTP sink kamelet and fix CI [\#140](https://github.com/apache/camel-kamelets/pull/140) ([nicolaferraro](https://github.com/nicolaferraro))
- Dropbox source: Fixed period description option [\#136](https://github.com/apache/camel-kamelets/pull/136) ([oscerd](https://github.com/oscerd))
- Use to-d instead of tod for compatibility with 1.4 [\#135](https://github.com/apache/camel-kamelets/pull/135) ([nicolaferraro](https://github.com/nicolaferraro))
- Azure storage blob source Kamelet [\#134](https://github.com/apache/camel-kamelets/pull/134) ([oscerd](https://github.com/oscerd))
- Azure storage blob sink [\#133](https://github.com/apache/camel-kamelets/pull/133) ([oscerd](https://github.com/oscerd))
- FTP/FTPS and SFTP Source Kamelet: Add an header containing the filena… [\#130](https://github.com/apache/camel-kamelets/pull/130) ([oscerd](https://github.com/oscerd))
- FTP/FTPS and SFTP Source Kamelet: Add an header containing the filena… [\#129](https://github.com/apache/camel-kamelets/pull/129) ([oscerd](https://github.com/oscerd))
- FTP/FTPS and SFTP Source Kamelet: Add an header containing the filena… [\#128](https://github.com/apache/camel-kamelets/pull/128) ([oscerd](https://github.com/oscerd))
- FTP/FTPS and SFTP: Don't convert body to String, leave as-is or at le… [\#127](https://github.com/apache/camel-kamelets/pull/127) ([oscerd](https://github.com/oscerd))
- FTP/FTPS and SFTP: Don't convert body to String, leave as-is or at le… [\#126](https://github.com/apache/camel-kamelets/pull/126) ([oscerd](https://github.com/oscerd))
- FTP/FTPS and SFTP: Don't convert body to String, leave as-is or at le… [\#125](https://github.com/apache/camel-kamelets/pull/125) ([oscerd](https://github.com/oscerd))
- Add AWS CloudWatch Kamelet [\#123](https://github.com/apache/camel-kamelets/pull/123) ([claudio4j](https://github.com/claudio4j))
- chore: add headers to telegram-source for symmetry with sink [\#120](https://github.com/apache/camel-kamelets/pull/120) ([nicolaferraro](https://github.com/nicolaferraro))
- Kinesis Firehose Kamelet Sink [\#115](https://github.com/apache/camel-kamelets/pull/115) ([oscerd](https://github.com/oscerd))
- Minio Kamelet sink [\#111](https://github.com/apache/camel-kamelets/pull/111) ([oscerd](https://github.com/oscerd))
- Minio Source Kamelet [\#110](https://github.com/apache/camel-kamelets/pull/110) ([oscerd](https://github.com/oscerd))
- AWS S3 Sink Kamelet [\#107](https://github.com/apache/camel-kamelets/pull/107) ([claudio4j](https://github.com/claudio4j))
- AWS Lambda sink Kamelet [\#106](https://github.com/apache/camel-kamelets/pull/106) ([oscerd](https://github.com/oscerd))
- Direct message twitter Source Kamelet [\#105](https://github.com/apache/camel-kamelets/pull/105) ([oscerd](https://github.com/oscerd))
- Twitter Timeline source kamelet [\#104](https://github.com/apache/camel-kamelets/pull/104) ([oscerd](https://github.com/oscerd))
- Twitter search kamelet: Removed modeline [\#103](https://github.com/apache/camel-kamelets/pull/103) ([oscerd](https://github.com/oscerd))
- AWS SNS FIFO [\#96](https://github.com/apache/camel-kamelets/pull/96) ([oscerd](https://github.com/oscerd))
- AWS SNS Sink [\#94](https://github.com/apache/camel-kamelets/pull/94) ([oscerd](https://github.com/oscerd))
- FHIR source kamelet [\#91](https://github.com/apache/camel-kamelets/pull/91) ([oscerd](https://github.com/oscerd))
- AWS DDB Streams [\#89](https://github.com/apache/camel-kamelets/pull/89) ([oscerd](https://github.com/oscerd))
- Dropbox sink kamelet [\#88](https://github.com/apache/camel-kamelets/pull/88) ([oscerd](https://github.com/oscerd))
- Sqs autocreate queue [\#86](https://github.com/apache/camel-kamelets/pull/86) ([oscerd](https://github.com/oscerd))
- AWS S3 Source Kamelet: Added autoCreateBucket option with default false [\#85](https://github.com/apache/camel-kamelets/pull/85) ([oscerd](https://github.com/oscerd))
- Dropbox Kamelet Source: Query is required [\#81](https://github.com/apache/camel-kamelets/pull/81) ([oscerd](https://github.com/oscerd))
- Dropbox Kamelet Source [\#80](https://github.com/apache/camel-kamelets/pull/80) ([oscerd](https://github.com/oscerd))
- SQS Fifo Kamelet Sink [\#78](https://github.com/apache/camel-kamelets/pull/78) ([oscerd](https://github.com/oscerd))
- AWS SQS Sink [\#75](https://github.com/apache/camel-kamelets/pull/75) ([oscerd](https://github.com/oscerd))
- SSH Source Kamelet [\#73](https://github.com/apache/camel-kamelets/pull/73) ([oscerd](https://github.com/oscerd))
- Kafka source should not marshal to JSON [\#72](https://github.com/apache/camel-kamelets/pull/72) ([oscerd](https://github.com/oscerd))
- File watch kamelet source [\#69](https://github.com/apache/camel-kamelets/pull/69) ([oscerd](https://github.com/oscerd))
- chore: add links to developer guide [\#68](https://github.com/apache/camel-kamelets/pull/68) ([nicolaferraro](https://github.com/nicolaferraro))
- GitHub source Kamelet [\#61](https://github.com/apache/camel-kamelets/pull/61) ([oscerd](https://github.com/oscerd))
- Google rename [\#59](https://github.com/apache/camel-kamelets/pull/59) ([oscerd](https://github.com/oscerd))
- Google Sheets icon [\#57](https://github.com/apache/camel-kamelets/pull/57) ([oscerd](https://github.com/oscerd))
- Add kamelets from developer guide [\#55](https://github.com/apache/camel-kamelets/pull/55) ([nicolaferraro](https://github.com/nicolaferraro))
- Add delay option to google-\* kamelet source [\#54](https://github.com/apache/camel-kamelets/pull/54) ([oscerd](https://github.com/oscerd))
- Google Sheets Stream Source Kamelet [\#52](https://github.com/apache/camel-kamelets/pull/52) ([oscerd](https://github.com/oscerd))
- Gmail Stream source kamelet [\#51](https://github.com/apache/camel-kamelets/pull/51) ([oscerd](https://github.com/oscerd))
- Google Calendar Stream Source Kamelet [\#49](https://github.com/apache/camel-kamelets/pull/49) ([oscerd](https://github.com/oscerd))
- Fix http source to use camel-http [\#48](https://github.com/apache/camel-kamelets/pull/48) ([nicolaferraro](https://github.com/nicolaferraro))
- FTP - SFTP - FTPS: No need for jackson and json [\#47](https://github.com/apache/camel-kamelets/pull/47) ([oscerd](https://github.com/oscerd))
- RabbitMQ source kamelet [\#46](https://github.com/apache/camel-kamelets/pull/46) ([oscerd](https://github.com/oscerd))
- FTPS Source Kamelet [\#43](https://github.com/apache/camel-kamelets/pull/43) ([oscerd](https://github.com/oscerd))
- Added SFTP source Kamelet [\#42](https://github.com/apache/camel-kamelets/pull/42) ([oscerd](https://github.com/oscerd))
- Add a Jenkinsfile to trigger the website build when something changes… [\#40](https://github.com/apache/camel-kamelets/pull/40) ([oscerd](https://github.com/oscerd))
- FTP Source Kamelet: Add passiveMode, recursive and convert body to St… [\#38](https://github.com/apache/camel-kamelets/pull/38) ([oscerd](https://github.com/oscerd))
- AWS SQS Source Kamelet: No need for camel-jackson [\#37](https://github.com/apache/camel-kamelets/pull/37) ([oscerd](https://github.com/oscerd))
- AWS S3: No need for camel-jackson dependency [\#36](https://github.com/apache/camel-kamelets/pull/36) ([oscerd](https://github.com/oscerd))
- AWS Kinesis Kamelet Source: No need for JSON [\#35](https://github.com/apache/camel-kamelets/pull/35) ([oscerd](https://github.com/oscerd))
- AWS SQS Kamelet Source: No need for json marshal [\#34](https://github.com/apache/camel-kamelets/pull/34) ([oscerd](https://github.com/oscerd))
- AWS S3 Kamelet Source: No need for marshal json [\#33](https://github.com/apache/camel-kamelets/pull/33) ([oscerd](https://github.com/oscerd))
- FTP Source Kamelet [\#32](https://github.com/apache/camel-kamelets/pull/32) ([oscerd](https://github.com/oscerd))
- NATS Source Kamelet [\#31](https://github.com/apache/camel-kamelets/pull/31) ([oscerd](https://github.com/oscerd))
- Add Kafka Source kamelet [\#29](https://github.com/apache/camel-kamelets/pull/29) ([oscerd](https://github.com/oscerd))
- Fix \#18: add mail source kamelet [\#28](https://github.com/apache/camel-kamelets/pull/28) ([nicolaferraro](https://github.com/nicolaferraro))
- Minio Source: Regen [\#27](https://github.com/apache/camel-kamelets/pull/27) ([oscerd](https://github.com/oscerd))
- Minio Source: Fixed bucketName field [\#26](https://github.com/apache/camel-kamelets/pull/26) ([oscerd](https://github.com/oscerd))
- Added Minio source Kamelet [\#25](https://github.com/apache/camel-kamelets/pull/25) ([oscerd](https://github.com/oscerd))
- Add a webhook Kamelet [\#14](https://github.com/apache/camel-kamelets/pull/14) ([nicolaferraro](https://github.com/nicolaferraro))
- Moved AWS-Kinesis to AWS2-Kinesis [\#13](https://github.com/apache/camel-kamelets/pull/13) ([oscerd](https://github.com/oscerd))
- Added AWS2-S3 source kamelet [\#11](https://github.com/apache/camel-kamelets/pull/11) ([oscerd](https://github.com/oscerd))
- chore: avoid spamming the dev mailing list \(from next time\) [\#8](https://github.com/apache/camel-kamelets/pull/8) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix links in documentation [\#7](https://github.com/apache/camel-kamelets/pull/7) ([nicolaferraro](https://github.com/nicolaferraro))
- chore: fix generated YAML and required props [\#6](https://github.com/apache/camel-kamelets/pull/6) ([nicolaferraro](https://github.com/nicolaferraro))
- Added ASF Yaml configuration [\#5](https://github.com/apache/camel-kamelets/pull/5) ([oscerd](https://github.com/oscerd))
- chore: add some kamelets from existing examples [\#4](https://github.com/apache/camel-kamelets/pull/4) ([nicolaferraro](https://github.com/nicolaferraro))
- chore: add CI configuration [\#3](https://github.com/apache/camel-kamelets/pull/3) ([nicolaferraro](https://github.com/nicolaferraro))
- Auto-generate the Kamelet Catalog website [\#2](https://github.com/apache/camel-kamelets/pull/2) ([nicolaferraro](https://github.com/nicolaferraro))
- Initial rules about the catalog [\#1](https://github.com/apache/camel-kamelets/pull/1) ([nicolaferraro](https://github.com/nicolaferraro))

## [v0.2.1](https://github.com/apache/camel-kamelets/tree/v0.2.1) (2021-04-16)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v0.2.0...v0.2.1)

## [v0.2.0](https://github.com/apache/camel-kamelets/tree/v0.2.0) (2021-04-16)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/v0.1.0...v0.2.0)

**Closed issues:**

- Add Azure Eventhubs Sink Kamelet [\#149](https://github.com/apache/camel-kamelets/issues/149)
- Add Azure Eventhubs Source Kamelet [\#148](https://github.com/apache/camel-kamelets/issues/148)
- Create Azure Storage Queue Sink Kamelet [\#138](https://github.com/apache/camel-kamelets/issues/138)
- Add Cron source kamelet [\#65](https://github.com/apache/camel-kamelets/issues/65)
- CI is not working properly [\#60](https://github.com/apache/camel-kamelets/issues/60)

## [v0.1.0](https://github.com/apache/camel-kamelets/tree/v0.1.0) (2021-04-13)

[Full Changelog](https://github.com/apache/camel-kamelets/compare/b522c6e387ed5eb5f64616c75252a2391048db83...v0.1.0)

**Closed issues:**

- Add Azure Storage Blob Source Kamelet [\#132](https://github.com/apache/camel-kamelets/issues/132)
- Add Azure Storage Blob Sink Kamelet [\#131](https://github.com/apache/camel-kamelets/issues/131)
- FTP/FTPS and SFTP Source Kamelet: Add an header containing the filename named file and ce-file [\#122](https://github.com/apache/camel-kamelets/issues/122)
- FTP/FTPS and SFTP: Don't convert body to String, leave as-is or at least try to convert to inputstream [\#121](https://github.com/apache/camel-kamelets/issues/121)
- Add generic set-header action [\#113](https://github.com/apache/camel-kamelets/issues/113)
- Add AWS S3 Sink kamelet [\#112](https://github.com/apache/camel-kamelets/issues/112)
- Minio Source: Missing endpoint and autoCreateBucket option [\#109](https://github.com/apache/camel-kamelets/issues/109)
- Add Minio Sink Kamelet [\#108](https://github.com/apache/camel-kamelets/issues/108)
- Add Twitter Timeline source Kamelet [\#101](https://github.com/apache/camel-kamelets/issues/101)
- Add Twitter Direct Message source Kamelet [\#99](https://github.com/apache/camel-kamelets/issues/99)
- Add AWS Lambda Sink Kamelet [\#97](https://github.com/apache/camel-kamelets/issues/97)
- Add AWS SNS FIFO Sink [\#95](https://github.com/apache/camel-kamelets/issues/95)
- Add AWS Kinesis Firehose Sink Kamelet [\#93](https://github.com/apache/camel-kamelets/issues/93)
- Add AWS SNS Sink Kamelet [\#92](https://github.com/apache/camel-kamelets/issues/92)
- Add Fhir source Kamelet [\#90](https://github.com/apache/camel-kamelets/issues/90)
- Add Dropbox Sink Kamelet [\#87](https://github.com/apache/camel-kamelets/issues/87)
- Add AWS DynamoDB Streams source Kamelet [\#84](https://github.com/apache/camel-kamelets/issues/84)
- Add autocreateQueue to AWS SQS sink and source [\#83](https://github.com/apache/camel-kamelets/issues/83)
- Add autocreateBucket to AWS S3 source [\#82](https://github.com/apache/camel-kamelets/issues/82)
- Add AWS SQS Fifo Sink Kamelet [\#77](https://github.com/apache/camel-kamelets/issues/77)
- Add AWS SQS sink Kamelet [\#74](https://github.com/apache/camel-kamelets/issues/74)
- Kafka source should not marshal to JSON [\#71](https://github.com/apache/camel-kamelets/issues/71)
- Add SSH Source Kamelet [\#70](https://github.com/apache/camel-kamelets/issues/70)
- Add Docker source Kamelet [\#67](https://github.com/apache/camel-kamelets/issues/67)
- Add File watch source kamelet [\#66](https://github.com/apache/camel-kamelets/issues/66)
- Rename google-\*-stream kamelets to google-\* since for source we'll use stream by default [\#58](https://github.com/apache/camel-kamelets/issues/58)
- Fix google sheets icon [\#56](https://github.com/apache/camel-kamelets/issues/56)
- Add delay option to google-\* kamelet source [\#53](https://github.com/apache/camel-kamelets/issues/53)
- Add Github source kamelet [\#50](https://github.com/apache/camel-kamelets/issues/50)
- Add RabbitMQ source Kamelet [\#44](https://github.com/apache/camel-kamelets/issues/44)
- Add FTPS source kamelet [\#41](https://github.com/apache/camel-kamelets/issues/41)
- Add a Jenkinsfile to trigger the website build when something changes in docs [\#39](https://github.com/apache/camel-kamelets/issues/39)
- Add NATS Source Kamelet [\#30](https://github.com/apache/camel-kamelets/issues/30)
- Add Kafka Source kamelet  [\#24](https://github.com/apache/camel-kamelets/issues/24)
- Add SFTP Source Kamelet [\#23](https://github.com/apache/camel-kamelets/issues/23)
- Add Dropbox Source Kamelet  [\#22](https://github.com/apache/camel-kamelets/issues/22)
- Add Google Sheets Stream Source Kamelet [\#21](https://github.com/apache/camel-kamelets/issues/21)
- Add Google Calendar Stream Source Kamelet [\#20](https://github.com/apache/camel-kamelets/issues/20)
- Add Google Mail Stream Source Kamelet [\#19](https://github.com/apache/camel-kamelets/issues/19)
- Add Mail Source Kamelet [\#18](https://github.com/apache/camel-kamelets/issues/18)
- Add FTP Source kamelet [\#16](https://github.com/apache/camel-kamelets/issues/16)
- Add a Minio source kamelet [\#15](https://github.com/apache/camel-kamelets/issues/15)
- Move AWS-Kinesis to AWS2-Kinesis component [\#12](https://github.com/apache/camel-kamelets/issues/12)
- Add AWS2-S3 source kamelet [\#10](https://github.com/apache/camel-kamelets/issues/10)
- Add AWS-S3 source kamelet [\#9](https://github.com/apache/camel-kamelets/issues/9)



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
