/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.elasticsearch.common;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

import org.apache.camel.test.infra.elasticsearch.services.ElasticSearchLocalContainerService;
import org.testcontainers.elasticsearch.ElasticsearchContainer;

public class ElasticSearchLocalContainerServiceHack extends ElasticSearchLocalContainerService {
    public ElasticSearchLocalContainerServiceHack() {
        super();
    }

    public ElasticSearchLocalContainerServiceHack(String imageName) {
        super(imageName);
    }

    public ElasticSearchLocalContainerServiceHack(ElasticsearchContainer container) {
        super(container);
    }

    @Override
    public void registerProperties() {
        System.setProperty("elasticsearch.host", this.getElasticSearchHost());
        System.setProperty("elasticsearch.port", String.valueOf(this.getPort()));
        this.getContainer().caCertAsBytes().ifPresent(content -> {
            try {
                Field certPath = getClass().getSuperclass().getDeclaredField("certPath");
                certPath.setAccessible(true); // enables access to private variables
                certPath.set(this, Files.createTempFile("http_ca", ".crt"));
                Files.write((Path) certPath.get(this), content, new OpenOption[0]);

                Field sslContext = getClass().getSuperclass().getDeclaredField("sslContext");
                sslContext.setAccessible(true); // enables access to private variables
                sslContext.set(this, this.getContainer().createSslContextFromCa());
            } catch (IOException | NoSuchFieldException | IllegalAccessException var3) {
                throw new RuntimeException(var3);
            }
        });
    }
}
