/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */package org.apache.camel.kafkaconnector.mqttsink;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelMqttsinkSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_MQTTSINK_KAMELET_TOPIC_CONF = "camel.kamelet.mqtt-sink.topic";
    public static final String CAMEL_SINK_MQTTSINK_KAMELET_TOPIC_DOC = "The topic to send messages to Example: mytopic";
    public static final String CAMEL_SINK_MQTTSINK_KAMELET_TOPIC_DEFAULT = null;
    public static final String CAMEL_SINK_MQTTSINK_KAMELET_BROKER_URL_CONF = "camel.kamelet.mqtt-sink.brokerUrl";
    public static final String CAMEL_SINK_MQTTSINK_KAMELET_BROKER_URL_DOC = "The URL of the broker where to establish the connection Example: tcp://mosquitto:1883";
    public static final String CAMEL_SINK_MQTTSINK_KAMELET_BROKER_URL_DEFAULT = null;
    public static final String CAMEL_SINK_MQTTSINK_KAMELET_USERNAME_CONF = "camel.kamelet.mqtt-sink.username";
    public static final String CAMEL_SINK_MQTTSINK_KAMELET_USERNAME_DOC = "Username to use when connecting to the MQTT broker";
    public static final String CAMEL_SINK_MQTTSINK_KAMELET_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_MQTTSINK_KAMELET_PASSWORD_CONF = "camel.kamelet.mqtt-sink.password";
    public static final String CAMEL_SINK_MQTTSINK_KAMELET_PASSWORD_DOC = "Password to use when connecting to the MQTT broker";
    public static final String CAMEL_SINK_MQTTSINK_KAMELET_PASSWORD_DEFAULT = null;

    public CamelMqttsinkSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelMqttsinkSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_MQTTSINK_KAMELET_TOPIC_CONF, ConfigDef.Type.STRING, CAMEL_SINK_MQTTSINK_KAMELET_TOPIC_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_MQTTSINK_KAMELET_TOPIC_DOC);
        conf.define(CAMEL_SINK_MQTTSINK_KAMELET_BROKER_URL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_MQTTSINK_KAMELET_BROKER_URL_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_MQTTSINK_KAMELET_BROKER_URL_DOC);
        conf.define(CAMEL_SINK_MQTTSINK_KAMELET_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_MQTTSINK_KAMELET_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_MQTTSINK_KAMELET_USERNAME_DOC);
        conf.define(CAMEL_SINK_MQTTSINK_KAMELET_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_MQTTSINK_KAMELET_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_MQTTSINK_KAMELET_PASSWORD_DOC);
        return conf;
    }
}