/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */package org.apache.camel.kafkaconnector.redissource;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelRedissourceSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_REDISSOURCE_KAMELET_REDIS_HOST_CONF = "camel.kamelet.redis-source.redisHost";
    public static final String CAMEL_SOURCE_REDISSOURCE_KAMELET_REDIS_HOST_DOC = "The host where Redis server is running";
    public static final String CAMEL_SOURCE_REDISSOURCE_KAMELET_REDIS_HOST_DEFAULT = null;
    public static final String CAMEL_SOURCE_REDISSOURCE_KAMELET_REDIS_PORT_CONF = "camel.kamelet.redis-source.redisPort";
    public static final String CAMEL_SOURCE_REDISSOURCE_KAMELET_REDIS_PORT_DOC = "The port where Redis server is running";
    public static final Integer CAMEL_SOURCE_REDISSOURCE_KAMELET_REDIS_PORT_DEFAULT = null;
    public static final String CAMEL_SOURCE_REDISSOURCE_KAMELET_COMMAND_CONF = "camel.kamelet.redis-source.command";
    public static final String CAMEL_SOURCE_REDISSOURCE_KAMELET_COMMAND_DOC = "Redis Command";
    public static final String CAMEL_SOURCE_REDISSOURCE_KAMELET_COMMAND_DEFAULT = "SUBSCRIBE";
    public static final String CAMEL_SOURCE_REDISSOURCE_KAMELET_CHANNELS_CONF = "camel.kamelet.redis-source.channels";
    public static final String CAMEL_SOURCE_REDISSOURCE_KAMELET_CHANNELS_DOC = "Redis Channels";
    public static final String CAMEL_SOURCE_REDISSOURCE_KAMELET_CHANNELS_DEFAULT = "one";
    public static final String CAMEL_SOURCE_REDISSOURCE_KAMELET_SERIALIZER_CONF = "camel.kamelet.redis-source.serializer";
    public static final String CAMEL_SOURCE_REDISSOURCE_KAMELET_SERIALIZER_DOC = "RedisSerializer fully qualified name implementation";
    public static final String CAMEL_SOURCE_REDISSOURCE_KAMELET_SERIALIZER_DEFAULT = "org.springframework.data.redis.serializer.StringRedisSerializer";

    public CamelRedissourceSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelRedissourceSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_REDISSOURCE_KAMELET_REDIS_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_REDISSOURCE_KAMELET_REDIS_HOST_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_REDISSOURCE_KAMELET_REDIS_HOST_DOC);
        conf.define(CAMEL_SOURCE_REDISSOURCE_KAMELET_REDIS_PORT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_REDISSOURCE_KAMELET_REDIS_PORT_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_REDISSOURCE_KAMELET_REDIS_PORT_DOC);
        conf.define(CAMEL_SOURCE_REDISSOURCE_KAMELET_COMMAND_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_REDISSOURCE_KAMELET_COMMAND_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_REDISSOURCE_KAMELET_COMMAND_DOC);
        conf.define(CAMEL_SOURCE_REDISSOURCE_KAMELET_CHANNELS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_REDISSOURCE_KAMELET_CHANNELS_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_REDISSOURCE_KAMELET_CHANNELS_DOC);
        conf.define(CAMEL_SOURCE_REDISSOURCE_KAMELET_SERIALIZER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_REDISSOURCE_KAMELET_SERIALIZER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_REDISSOURCE_KAMELET_SERIALIZER_DOC);
        return conf;
    }
}