/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */package org.apache.camel.kafkaconnector.kafkasslsource;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelKafkasslsourceSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_TOPIC_CONF = "camel.kamelet.kafka-ssl-source.topic";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_TOPIC_DOC = "Comma separated list of Kafka topic names";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_TOPIC_DEFAULT = null;
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_BOOTSTRAP_SERVERS_CONF = "camel.kamelet.kafka-ssl-source.bootstrapServers";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_BOOTSTRAP_SERVERS_DOC = "Comma separated list of Kafka Broker URLs";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_BOOTSTRAP_SERVERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SECURITY_PROTOCOL_CONF = "camel.kamelet.kafka-ssl-source.securityProtocol";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SECURITY_PROTOCOL_DOC = "Protocol used to communicate with brokers. SASL_PLAINTEXT, PLAINTEXT, SASL_SSL and SSL are supported";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SECURITY_PROTOCOL_DEFAULT = "SSL";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SASL_MECHANISM_CONF = "camel.kamelet.kafka-ssl-source.saslMechanism";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SASL_MECHANISM_DOC = "The Simple Authentication and Security Layer (SASL) Mechanism used.";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SASL_MECHANISM_DEFAULT = "GSSAPI";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_AUTO_COMMIT_ENABLE_CONF = "camel.kamelet.kafka-ssl-source.autoCommitEnable";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_AUTO_COMMIT_ENABLE_DOC = "If true, periodically commit to ZooKeeper the offset of messages already fetched by the consumer";
    public static final Boolean CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_AUTO_COMMIT_ENABLE_DEFAULT = true;
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_ALLOW_MANUAL_COMMIT_CONF = "camel.kamelet.kafka-ssl-source.allowManualCommit";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_ALLOW_MANUAL_COMMIT_DOC = "Whether to allow doing manual commits";
    public static final Boolean CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_ALLOW_MANUAL_COMMIT_DEFAULT = false;
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_POLL_ON_ERROR_CONF = "camel.kamelet.kafka-ssl-source.pollOnError";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_POLL_ON_ERROR_DOC = "What to do if kafka threw an exception while polling for new messages. There are 5 enums and the value can be one of DISCARD, ERROR_HANDLER, RECONNECT, RETRY, STOP";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_POLL_ON_ERROR_DEFAULT = "ERROR_HANDLER";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_AUTO_OFFSET_RESET_CONF = "camel.kamelet.kafka-ssl-source.autoOffsetReset";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_AUTO_OFFSET_RESET_DOC = "What to do when there is no initial offset. There are 3 enums and the value can be one of latest, earliest, none";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_AUTO_OFFSET_RESET_DEFAULT = "latest";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_CONSUMER_GROUP_CONF = "camel.kamelet.kafka-ssl-source.consumerGroup";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_CONSUMER_GROUP_DOC = "A string that uniquely identifies the group of consumers to which this source belongs Example: my-group-id";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_CONSUMER_GROUP_DEFAULT = null;
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_DESERIALIZE_HEADERS_CONF = "camel.kamelet.kafka-ssl-source.deserializeHeaders";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_DESERIALIZE_HEADERS_DOC = "When enabled the Kamelet source will deserialize all message headers to String representation.";
    public static final Boolean CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_DESERIALIZE_HEADERS_DEFAULT = false;
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEY_PASSWORD_CONF = "camel.kamelet.kafka-ssl-source.sslKeyPassword";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEY_PASSWORD_DOC = "The password of the private key in the key store file.";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEY_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEYSTORE_PASSWORD_CONF = "camel.kamelet.kafka-ssl-source.sslKeystorePassword";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEYSTORE_PASSWORD_DOC = "The store password for the key store file.This is optional for client and only needed if ssl.keystore.location is configured.";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEYSTORE_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_PROTOCOL_CONF = "camel.kamelet.kafka-ssl-source.sslProtocol";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_PROTOCOL_DOC = "The SSL protocol used to generate the SSLContext. Default setting is TLS, which is fine for most cases. Allowed values in recent JVMs are TLS, TLSv1.1 and TLSv1.2. SSL, SSLv2 and SSLv3 may be supported in older JVMs, but their usage is discouraged due to known security vulnerabilities.";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_PROTOCOL_DEFAULT = "TLSv1.2";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEYSTORE_LOCATION_CONF = "camel.kamelet.kafka-ssl-source.sslKeystoreLocation";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEYSTORE_LOCATION_DOC = "The location of the key store file. This is optional for client and can be used for two-way authentication for client.";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEYSTORE_LOCATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_TRUSTSTORE_LOCATION_CONF = "camel.kamelet.kafka-ssl-source.sslTruststoreLocation";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_TRUSTSTORE_LOCATION_DOC = "The location of the trust store file.";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_TRUSTSTORE_LOCATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_ENABLED_PROTOCOLS_CONF = "camel.kamelet.kafka-ssl-source.sslEnabledProtocols";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_ENABLED_PROTOCOLS_DOC = "The list of protocols enabled for SSL connections. TLSv1.2, TLSv1.1 and TLSv1 are enabled by default.";
    public static final String CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_ENABLED_PROTOCOLS_DEFAULT = "TLSv1.2,TLSv1.1,TLSv1";

    public CamelKafkasslsourceSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelKafkasslsourceSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_TOPIC_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_TOPIC_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_TOPIC_DOC);
        conf.define(CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_BOOTSTRAP_SERVERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_BOOTSTRAP_SERVERS_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_BOOTSTRAP_SERVERS_DOC);
        conf.define(CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SECURITY_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SECURITY_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SECURITY_PROTOCOL_DOC);
        conf.define(CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SASL_MECHANISM_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SASL_MECHANISM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SASL_MECHANISM_DOC);
        conf.define(CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_AUTO_COMMIT_ENABLE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_AUTO_COMMIT_ENABLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_AUTO_COMMIT_ENABLE_DOC);
        conf.define(CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_ALLOW_MANUAL_COMMIT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_ALLOW_MANUAL_COMMIT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_ALLOW_MANUAL_COMMIT_DOC);
        conf.define(CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_POLL_ON_ERROR_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_POLL_ON_ERROR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_POLL_ON_ERROR_DOC);
        conf.define(CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_AUTO_OFFSET_RESET_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_AUTO_OFFSET_RESET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_AUTO_OFFSET_RESET_DOC);
        conf.define(CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_CONSUMER_GROUP_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_CONSUMER_GROUP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_CONSUMER_GROUP_DOC);
        conf.define(CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_DESERIALIZE_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_DESERIALIZE_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_DESERIALIZE_HEADERS_DOC);
        conf.define(CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEY_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEY_PASSWORD_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEY_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEYSTORE_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEYSTORE_PASSWORD_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEYSTORE_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_PROTOCOL_DOC);
        conf.define(CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEYSTORE_LOCATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEYSTORE_LOCATION_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_KEYSTORE_LOCATION_DOC);
        conf.define(CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_TRUSTSTORE_LOCATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_TRUSTSTORE_LOCATION_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_TRUSTSTORE_LOCATION_DOC);
        conf.define(CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_ENABLED_PROTOCOLS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_ENABLED_PROTOCOLS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_KAFKASSLSOURCE_KAMELET_SSL_ENABLED_PROTOCOLS_DOC);
        return conf;
    }
}