/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.websocketsource;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelWebsocketsourceSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_WEBSOCKET_HOST_CONF = "camel.kamelet.websocket-source.websocketHost";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_WEBSOCKET_HOST_DOC = "The hostname";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_WEBSOCKET_HOST_DEFAULT = "0.0.0.0";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_WEBSOCKET_PORT_CONF = "camel.kamelet.websocket-source.websocketPort";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_WEBSOCKET_PORT_DOC = "The port number";
    public static final Integer CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_WEBSOCKET_PORT_DEFAULT = 9292;
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_RESOURCE_URI_CONF = "camel.kamelet.websocket-source.resourceUri";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_RESOURCE_URI_DOC = "Name of the websocket channel to use.";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_RESOURCE_URI_DEFAULT = null;
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_MAX_BINARY_MESSAGE_SIZE_CONF = "camel.kamelet.websocket-source.maxBinaryMessageSize";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_MAX_BINARY_MESSAGE_SIZE_DOC = "Can be used to set the size in bytes that the websocket created by the websocketServlet may be accept before closing. (Default is -1 - or unlimited).";
    public static final Integer CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_MAX_BINARY_MESSAGE_SIZE_DEFAULT = -1;
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_BRIDGE_ERROR_HANDLER_CONF = "camel.kamelet.websocket-source.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_BRIDGE_ERROR_HANDLER_DEFAULT = "false";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SESSION_SUPPORT_CONF = "camel.kamelet.websocket-source.sessionSupport";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SESSION_SUPPORT_DOC = "Whether to enable session support which enables HttpSession for each http request.";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SESSION_SUPPORT_DEFAULT = "false";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SUBPROTOCOL_CONF = "camel.kamelet.websocket-source.subprotocol";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SUBPROTOCOL_DOC = "Comma-separated list of subprotocols that are supported by the application.";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SUBPROTOCOL_DEFAULT = "any";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_LAZY_START_PRODUCER_CONF = "camel.kamelet.websocket-source.lazyStartProducer";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message).";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_LAZY_START_PRODUCER_DEFAULT = "false";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SEND_TIMEOUT_CONF = "camel.kamelet.websocket-source.sendTimeout";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SEND_TIMEOUT_DOC = "Timeout in millis when sending to a websocket channel. The default timeout is 30000 (30 seconds).";
    public static final Integer CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SEND_TIMEOUT_DEFAULT = 30000;
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_BUFFER_SIZE_CONF = "camel.kamelet.websocket-source.bufferSize";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_BUFFER_SIZE_DOC = "Set the buffer size of the websocketServlet";
    public static final Integer CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_BUFFER_SIZE_DEFAULT = 8192;
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_MAX_IDLE_TIME_CONF = "camel.kamelet.websocket-source.maxIdleTime";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_MAX_IDLE_TIME_DOC = "SetSet the time in ms that the websocket created by the websocketServlet may be idle before closing.";
    public static final Integer CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_MAX_IDLE_TIME_DEFAULT = 300000;
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_ALLOWED_ORIGINS_CONF = "camel.kamelet.websocket-source.allowedOrigins";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_ALLOWED_ORIGINS_DOC = "The CORS allowed origins. Use to allow all.";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_ALLOWED_ORIGINS_DEFAULT = "";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_CROSS_ORIGIN_FILTER_ON_CONF = "camel.kamelet.websocket-source.crossOriginFilterOn";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_CROSS_ORIGIN_FILTER_ON_DOC = "Whether to enable CORS.";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_CROSS_ORIGIN_FILTER_ON_DEFAULT = "false";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_FILTER_PATH_CONF = "camel.kamelet.websocket-source.filterPath";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_FILTER_PATH_DOC = "Context path for filtering CORS.";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_FILTER_PATH_DEFAULT = "";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_ENABLE_JMX_CONF = "camel.kamelet.websocket-source.enableJmx";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_ENABLE_JMX_DOC = "Enable JMX support.";
    public static final String CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_ENABLE_JMX_DEFAULT = "false";

    public CamelWebsocketsourceSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelWebsocketsourceSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_WEBSOCKET_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_WEBSOCKET_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_WEBSOCKET_HOST_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_WEBSOCKET_PORT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_WEBSOCKET_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_WEBSOCKET_PORT_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_RESOURCE_URI_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_RESOURCE_URI_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_RESOURCE_URI_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_MAX_BINARY_MESSAGE_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_MAX_BINARY_MESSAGE_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_MAX_BINARY_MESSAGE_SIZE_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SESSION_SUPPORT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SESSION_SUPPORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SESSION_SUPPORT_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SUBPROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SUBPROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SUBPROTOCOL_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_LAZY_START_PRODUCER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SEND_TIMEOUT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SEND_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_SEND_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_BUFFER_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_BUFFER_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_BUFFER_SIZE_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_MAX_IDLE_TIME_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_MAX_IDLE_TIME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_MAX_IDLE_TIME_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_ALLOWED_ORIGINS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_ALLOWED_ORIGINS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_ALLOWED_ORIGINS_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_CROSS_ORIGIN_FILTER_ON_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_CROSS_ORIGIN_FILTER_ON_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_CROSS_ORIGIN_FILTER_ON_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_FILTER_PATH_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_FILTER_PATH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_FILTER_PATH_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_ENABLE_JMX_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_ENABLE_JMX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETSOURCE_KAMELET_ENABLE_JMX_DOC);
        return conf;
    }
}