/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.couchbasesink;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelCouchbasesinkSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_PROTOCOL_CONF = "camel.kamelet.couchbase-sink.protocol";
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_PROTOCOL_DOC = "The protocol to use";
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_PROTOCOL_DEFAULT = null;
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_COUCHBASE_HOSTNAME_CONF = "camel.kamelet.couchbase-sink.couchbaseHostname";
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_COUCHBASE_HOSTNAME_DOC = "The hostname to use";
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_COUCHBASE_HOSTNAME_DEFAULT = null;
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_COUCHBASE_PORT_CONF = "camel.kamelet.couchbase-sink.couchbasePort";
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_COUCHBASE_PORT_DOC = "The port to use";
    public static final Integer CAMEL_SINK_COUCHBASESINK_KAMELET_COUCHBASE_PORT_DEFAULT = 8091;
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_BUCKET_CONF = "camel.kamelet.couchbase-sink.bucket";
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_BUCKET_DOC = "The bucket to use";
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_BUCKET_DEFAULT = null;
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_USERNAME_CONF = "camel.kamelet.couchbase-sink.username";
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_USERNAME_DOC = "Username to connect to Couchbase.";
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_PASSWORD_CONF = "camel.kamelet.couchbase-sink.password";
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_PASSWORD_DOC = "Password to connect to Couchbase.";
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_STARTING_ID_CONF = "camel.kamelet.couchbase-sink.startingId";
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_STARTING_ID_DOC = "The starting id";
    public static final Long CAMEL_SINK_COUCHBASESINK_KAMELET_STARTING_ID_DEFAULT = 1L;
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_AUTO_START_ID_CONF = "camel.kamelet.couchbase-sink.autoStartId";
    public static final String CAMEL_SINK_COUCHBASESINK_KAMELET_AUTO_START_ID_DOC = "Auto Start Id or not";
    public static final Boolean CAMEL_SINK_COUCHBASESINK_KAMELET_AUTO_START_ID_DEFAULT = true;

    public CamelCouchbasesinkSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelCouchbasesinkSinkConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_COUCHBASESINK_KAMELET_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_COUCHBASESINK_KAMELET_PROTOCOL_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_COUCHBASESINK_KAMELET_PROTOCOL_DOC);
        conf.define(CAMEL_SINK_COUCHBASESINK_KAMELET_COUCHBASE_HOSTNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_COUCHBASESINK_KAMELET_COUCHBASE_HOSTNAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_COUCHBASESINK_KAMELET_COUCHBASE_HOSTNAME_DOC);
        conf.define(CAMEL_SINK_COUCHBASESINK_KAMELET_COUCHBASE_PORT_CONF, ConfigDef.Type.INT, CAMEL_SINK_COUCHBASESINK_KAMELET_COUCHBASE_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_COUCHBASESINK_KAMELET_COUCHBASE_PORT_DOC);
        conf.define(CAMEL_SINK_COUCHBASESINK_KAMELET_BUCKET_CONF, ConfigDef.Type.STRING, CAMEL_SINK_COUCHBASESINK_KAMELET_BUCKET_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_COUCHBASESINK_KAMELET_BUCKET_DOC);
        conf.define(CAMEL_SINK_COUCHBASESINK_KAMELET_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_COUCHBASESINK_KAMELET_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_COUCHBASESINK_KAMELET_USERNAME_DOC);
        conf.define(CAMEL_SINK_COUCHBASESINK_KAMELET_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_COUCHBASESINK_KAMELET_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_COUCHBASESINK_KAMELET_PASSWORD_DOC);
        conf.define(CAMEL_SINK_COUCHBASESINK_KAMELET_STARTING_ID_CONF, ConfigDef.Type.LONG, CAMEL_SINK_COUCHBASESINK_KAMELET_STARTING_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_COUCHBASESINK_KAMELET_STARTING_ID_DOC);
        conf.define(CAMEL_SINK_COUCHBASESINK_KAMELET_AUTO_START_ID_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_COUCHBASESINK_KAMELET_AUTO_START_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_COUCHBASESINK_KAMELET_AUTO_START_ID_DOC);
        return conf;
    }
}