# Changelog

## [Unreleased](https://github.com/apache/camel-kafka-connector/tree/HEAD)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.11.0...HEAD)

**Fixed bugs:**

- Error with Syslog Source Connector [\#665](https://github.com/apache/camel-kafka-connector/issues/665)

**Closed issues:**

- Update Antora usage [\#1308](https://github.com/apache/camel-kafka-connector/issues/1308)
- CamelAws2s3SinkConnector not processing kafka null \(deleted\) messages [\#1300](https://github.com/apache/camel-kafka-connector/issues/1300)
- Fails to create CamelAws2sqsSourceConnector [\#1293](https://github.com/apache/camel-kafka-connector/issues/1293)
- Problem with line breaks kafka-hdfs sink connector [\#1291](https://github.com/apache/camel-kafka-connector/issues/1291)
- The pre-release salesforce source connector, how does the query field work? [\#1289](https://github.com/apache/camel-kafka-connector/issues/1289)
- Cannot findr camel-salesforce-source-kafka-connector in maven repository [\#1284](https://github.com/apache/camel-kafka-connector/issues/1284)
- Using kinesis sink with STS assumeRole credentials? [\#1272](https://github.com/apache/camel-kafka-connector/issues/1272)
- Salesforce Camel Kafka Source Connector not converting to JSON [\#1271](https://github.com/apache/camel-kafka-connector/issues/1271)
- java.lang.NullPointerException in kinesis sink connector if headers not present  [\#1268](https://github.com/apache/camel-kafka-connector/issues/1268)
- AWS SQS Source Message Delete [\#1266](https://github.com/apache/camel-kafka-connector/issues/1266)
- Modular packaging of connectors? [\#1264](https://github.com/apache/camel-kafka-connector/issues/1264)
- Bearer Token with HTTP sink? [\#1255](https://github.com/apache/camel-kafka-connector/issues/1255)
- One file per message \(kafka hdfs sink connector\) [\#1222](https://github.com/apache/camel-kafka-connector/issues/1222)
- Run slow tests on Apache CI [\#786](https://github.com/apache/camel-kafka-connector/issues/786)

**Merged pull requests:**

- 1.0.0release [\#1312](https://github.com/apache/camel-kafka-connector/pull/1312) ([valdar](https://github.com/valdar))
- \#1308 update Antora structure \(main\) [\#1309](https://github.com/apache/camel-kafka-connector/pull/1309) ([djencks](https://github.com/djencks))
- Fix Maven IT failures due to doc generation removal [\#1307](https://github.com/apache/camel-kafka-connector/pull/1307) ([tadayosi](https://github.com/tadayosi))
- update to docs local build v2 [\#1305](https://github.com/apache/camel-kafka-connector/pull/1305) ([djencks](https://github.com/djencks))
- Main local index page and local/partial build [\#1298](https://github.com/apache/camel-kafka-connector/pull/1298) ([djencks](https://github.com/djencks))
- README - fix link to 'getting started guide' [\#1297](https://github.com/apache/camel-kafka-connector/pull/1297) ([aSemy](https://github.com/aSemy))
- Prepare to 1.0.0 [\#1294](https://github.com/apache/camel-kafka-connector/pull/1294) ([valdar](https://github.com/valdar))
- Fixed missing syslog documentation. [\#1288](https://github.com/apache/camel-kafka-connector/pull/1288) ([valdar](https://github.com/valdar))
- Main collect [\#1286](https://github.com/apache/camel-kafka-connector/pull/1286) ([djencks](https://github.com/djencks))
- Fixed documentation for removed connectors. [\#1283](https://github.com/apache/camel-kafka-connector/pull/1283) ([valdar](https://github.com/valdar))
- chore: regen. [\#1281](https://github.com/apache/camel-kafka-connector/pull/1281) ([valdar](https://github.com/valdar))
- GenerateCamelKafkaConnectorsMojo : Added possibility to exclude conne… [\#1280](https://github.com/apache/camel-kafka-connector/pull/1280) ([valdar](https://github.com/valdar))
- Camel3.12 [\#1279](https://github.com/apache/camel-kafka-connector/pull/1279) ([valdar](https://github.com/valdar))
- Main latest to next2 [\#1278](https://github.com/apache/camel-kafka-connector/pull/1278) ([djencks](https://github.com/djencks))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1277](https://github.com/apache/camel-kafka-connector/pull/1277) ([github-actions[bot]](https://github.com/apps/github-actions))
- camel kafka connector main latest to next [\#1275](https://github.com/apache/camel-kafka-connector/pull/1275) ([djencks](https://github.com/djencks))
- Kamelets [\#1273](https://github.com/apache/camel-kafka-connector/pull/1273) ([valdar](https://github.com/valdar))
- Update try-it-out-locally.adoc [\#1270](https://github.com/apache/camel-kafka-connector/pull/1270) ([duanasq](https://github.com/duanasq))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1267](https://github.com/apache/camel-kafka-connector/pull/1267) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1260](https://github.com/apache/camel-kafka-connector/pull/1260) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1259](https://github.com/apache/camel-kafka-connector/pull/1259) ([github-actions[bot]](https://github.com/apps/github-actions))
- chore: regen. [\#1257](https://github.com/apache/camel-kafka-connector/pull/1257) ([valdar](https://github.com/valdar))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1256](https://github.com/apache/camel-kafka-connector/pull/1256) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1252](https://github.com/apache/camel-kafka-connector/pull/1252) ([github-actions[bot]](https://github.com/apps/github-actions))
- Upgrade Strimzi to version 0.25.0 [\#1251](https://github.com/apache/camel-kafka-connector/pull/1251) ([oscerd](https://github.com/oscerd))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1246](https://github.com/apache/camel-kafka-connector/pull/1246) ([github-actions[bot]](https://github.com/apps/github-actions))
- Upgrade to Camel 3.11.1 [\#1244](https://github.com/apache/camel-kafka-connector/pull/1244) ([oscerd](https://github.com/oscerd))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1240](https://github.com/apache/camel-kafka-connector/pull/1240) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1239](https://github.com/apache/camel-kafka-connector/pull/1239) ([github-actions[bot]](https://github.com/apps/github-actions))
- Upgrade to Camel 3.11.0 [\#1238](https://github.com/apache/camel-kafka-connector/pull/1238) ([oscerd](https://github.com/oscerd))
- Adjusted test code to avoid recycling test topics [\#1234](https://github.com/apache/camel-kafka-connector/pull/1234) ([orpiske](https://github.com/orpiske))
- \(chores\): replaces duplicated TestUtils code with the one from Camel Core [\#1233](https://github.com/apache/camel-kafka-connector/pull/1233) ([orpiske](https://github.com/orpiske))
- Update compatibility matrix with no LTS for 0.8, 0.9 and 0.10.x [\#1231](https://github.com/apache/camel-kafka-connector/pull/1231) ([oscerd](https://github.com/oscerd))
- Align compatibility matrix [\#1229](https://github.com/apache/camel-kafka-connector/pull/1229) ([oscerd](https://github.com/oscerd))
- Upgrade to Strimzi 0.24.0 [\#1226](https://github.com/apache/camel-kafka-connector/pull/1226) ([oscerd](https://github.com/oscerd))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1225](https://github.com/apache/camel-kafka-connector/pull/1225) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1223](https://github.com/apache/camel-kafka-connector/pull/1223) ([github-actions[bot]](https://github.com/apps/github-actions))
- Camel File Sink Connector: updates [\#1220](https://github.com/apache/camel-kafka-connector/pull/1220) ([orpiske](https://github.com/orpiske))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1215](https://github.com/apache/camel-kafka-connector/pull/1215) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1214](https://github.com/apache/camel-kafka-connector/pull/1214) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1213](https://github.com/apache/camel-kafka-connector/pull/1213) ([github-actions[bot]](https://github.com/apps/github-actions))
- Added a brief note about adjusting connectors behavior via Kafka message headers [\#1212](https://github.com/apache/camel-kafka-connector/pull/1212) ([orpiske](https://github.com/orpiske))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1210](https://github.com/apache/camel-kafka-connector/pull/1210) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1207](https://github.com/apache/camel-kafka-connector/pull/1207) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1205](https://github.com/apache/camel-kafka-connector/pull/1205) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1203](https://github.com/apache/camel-kafka-connector/pull/1203) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1202](https://github.com/apache/camel-kafka-connector/pull/1202) ([github-actions[bot]](https://github.com/apps/github-actions))
- Littel documentation adjustments. [\#1201](https://github.com/apache/camel-kafka-connector/pull/1201) ([valdar](https://github.com/valdar))
- Some documentation link fixes. [\#1199](https://github.com/apache/camel-kafka-connector/pull/1199) ([valdar](https://github.com/valdar))
- Added Release Documentation. [\#1197](https://github.com/apache/camel-kafka-connector/pull/1197) ([valdar](https://github.com/valdar))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1194](https://github.com/apache/camel-kafka-connector/pull/1194) ([github-actions[bot]](https://github.com/apps/github-actions))
- Salesforce issue [\#1193](https://github.com/apache/camel-kafka-connector/pull/1193) ([valdar](https://github.com/valdar))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1191](https://github.com/apache/camel-kafka-connector/pull/1191) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1189](https://github.com/apache/camel-kafka-connector/pull/1189) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1187](https://github.com/apache/camel-kafka-connector/pull/1187) ([github-actions[bot]](https://github.com/apps/github-actions))
- Update to Camel 3.11.0-SNAPSHOT [\#1185](https://github.com/apache/camel-kafka-connector/pull/1185) ([valdar](https://github.com/valdar))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1182](https://github.com/apache/camel-kafka-connector/pull/1182) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1180](https://github.com/apache/camel-kafka-connector/pull/1180) ([github-actions[bot]](https://github.com/apps/github-actions))
- Made Kinesis tests hopefully more robust. [\#1179](https://github.com/apache/camel-kafka-connector/pull/1179) ([valdar](https://github.com/valdar))
- Fixed Kinesis shards failing tests. [\#1178](https://github.com/apache/camel-kafka-connector/pull/1178) ([valdar](https://github.com/valdar))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1177](https://github.com/apache/camel-kafka-connector/pull/1177) ([github-actions[bot]](https://github.com/apps/github-actions))
- Fix AWS2 Cloud Watch test issues due to LocalStack bug [\#1176](https://github.com/apache/camel-kafka-connector/pull/1176) ([orpiske](https://github.com/orpiske))
- Fix AWS2 Kinesis Sink issues [\#1175](https://github.com/apache/camel-kafka-connector/pull/1175) ([orpiske](https://github.com/orpiske))
- Upgrade to Strimzi 0.23.0 [\#1174](https://github.com/apache/camel-kafka-connector/pull/1174) ([oscerd](https://github.com/oscerd))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1172](https://github.com/apache/camel-kafka-connector/pull/1172) ([github-actions[bot]](https://github.com/apps/github-actions))
- Moving Changelog action to version 1.4 [\#1170](https://github.com/apache/camel-kafka-connector/pull/1170) ([oscerd](https://github.com/oscerd))
- Kafka 2.8.0 and Strimzi [\#1169](https://github.com/apache/camel-kafka-connector/pull/1169) ([oscerd](https://github.com/oscerd))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1168](https://github.com/apache/camel-kafka-connector/pull/1168) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1167](https://github.com/apache/camel-kafka-connector/pull/1167) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1165](https://github.com/apache/camel-kafka-connector/pull/1165) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1164](https://github.com/apache/camel-kafka-connector/pull/1164) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1163](https://github.com/apache/camel-kafka-connector/pull/1163) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1162](https://github.com/apache/camel-kafka-connector/pull/1162) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1161](https://github.com/apache/camel-kafka-connector/pull/1161) ([github-actions[bot]](https://github.com/apps/github-actions))
- Minor fixes for AWS SQS tests when running against actual AWS [\#1160](https://github.com/apache/camel-kafka-connector/pull/1160) ([orpiske](https://github.com/orpiske))
- Fixed AWS test errors w/ Strimzi due to incorrect test lifecycle [\#1159](https://github.com/apache/camel-kafka-connector/pull/1159) ([orpiske](https://github.com/orpiske))
- Avoid using a fixed port for the REST service of Kafka Connect [\#1158](https://github.com/apache/camel-kafka-connector/pull/1158) ([orpiske](https://github.com/orpiske))
- Add autoCreateTopic to fix AWS v2 SNS tests [\#1157](https://github.com/apache/camel-kafka-connector/pull/1157) ([orpiske](https://github.com/orpiske))
- Removes outdated AWS v1 log configuration [\#1155](https://github.com/apache/camel-kafka-connector/pull/1155) ([orpiske](https://github.com/orpiske))
- Return ealier from SJMS test to avoid locking the test [\#1154](https://github.com/apache/camel-kafka-connector/pull/1154) ([orpiske](https://github.com/orpiske))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1153](https://github.com/apache/camel-kafka-connector/pull/1153) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector main Branch [\#1152](https://github.com/apache/camel-kafka-connector/pull/1152) ([github-actions[bot]](https://github.com/apps/github-actions))
- Fix address already in use error in HTTP integration tests [\#1151](https://github.com/apache/camel-kafka-connector/pull/1151) ([orpiske](https://github.com/orpiske))
- Avoid using canonical host due to multiple address/port allocation issues on GH actions [\#1150](https://github.com/apache/camel-kafka-connector/pull/1150) ([orpiske](https://github.com/orpiske))
- Work around Jackson conflicts for the azure-storage-blob tests [\#1148](https://github.com/apache/camel-kafka-connector/pull/1148) ([orpiske](https://github.com/orpiske))
- CAMEL-16524: the camel-crypto-cms component was removed from Camel Core [\#1146](https://github.com/apache/camel-kafka-connector/pull/1146) ([orpiske](https://github.com/orpiske))
- \[Github Actions\] Periodic Sync Camel-kafka-connector master Branch [\#1142](https://github.com/apache/camel-kafka-connector/pull/1142) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Github Actions\] Periodic Sync Camel-kafka-connector master Branch [\#1141](https://github.com/apache/camel-kafka-connector/pull/1141) ([github-actions[bot]](https://github.com/apps/github-actions))
- Suffling itest order around a bit to investigate origin of some rando… [\#1140](https://github.com/apache/camel-kafka-connector/pull/1140) ([valdar](https://github.com/valdar))
- \[Github Actions\] Periodic Sync Camel-kafka-connector master Branch [\#1139](https://github.com/apache/camel-kafka-connector/pull/1139) ([github-actions[bot]](https://github.com/apps/github-actions))
- FieldsToHeadersTransform: added option to copy whole value/key relate… [\#1138](https://github.com/apache/camel-kafka-connector/pull/1138) ([valdar](https://github.com/valdar))
- Build the sync PR on master and not on camel-master [\#1137](https://github.com/apache/camel-kafka-connector/pull/1137) ([oscerd](https://github.com/oscerd))
- Go to 3.10.0-SNAPSHOT [\#1136](https://github.com/apache/camel-kafka-connector/pull/1136) ([oscerd](https://github.com/oscerd))
-  SMT FieldsToHeaders Documentation  \#902 [\#1134](https://github.com/apache/camel-kafka-connector/pull/1134) ([luigidemasi](https://github.com/luigidemasi))
- Re-enabled Google pub/sub test [\#1132](https://github.com/apache/camel-kafka-connector/pull/1132) ([orpiske](https://github.com/orpiske))
- Re-enabled MongoDB source test after moving to Camel 3.9.0 \(issue \#974\) [\#1131](https://github.com/apache/camel-kafka-connector/pull/1131) ([orpiske](https://github.com/orpiske))
- Updated tests after camel 3.9.0 fixed \#924. [\#1129](https://github.com/apache/camel-kafka-connector/pull/1129) ([valdar](https://github.com/valdar))
- Camel 3.9.0 alignment [\#1126](https://github.com/apache/camel-kafka-connector/pull/1126) ([oscerd](https://github.com/oscerd))
- Add Camel 3.7.3 and ckc 0.7.3 to compatibility matrix [\#1122](https://github.com/apache/camel-kafka-connector/pull/1122) ([oscerd](https://github.com/oscerd))
- Fixed CS in cxfrs itest [\#1120](https://github.com/apache/camel-kafka-connector/pull/1120) ([oscerd](https://github.com/oscerd))
- Upgrade Strimzi to version 0.22.1 [\#1118](https://github.com/apache/camel-kafka-connector/pull/1118) ([oscerd](https://github.com/oscerd))
- NetworkUtils should be able to hold a free port for later usage \#1109 [\#1111](https://github.com/apache/camel-kafka-connector/pull/1111) ([ffang](https://github.com/ffang))
- Upgrade Strimzi to version 0.22.0 [\#1106](https://github.com/apache/camel-kafka-connector/pull/1106) ([oscerd](https://github.com/oscerd))
- add itests for camel-cxfrs-kafka-connector \#996 [\#1099](https://github.com/apache/camel-kafka-connector/pull/1099) ([ffang](https://github.com/ffang))
- Introduce MockWebServer extension for testing \#1085 [\#1097](https://github.com/apache/camel-kafka-connector/pull/1097) ([tadayosi](https://github.com/tadayosi))
- Add https itests [\#1096](https://github.com/apache/camel-kafka-connector/pull/1096) ([tadayosi](https://github.com/tadayosi))
- Some folowup improvements fro \#969 and \#202. [\#1093](https://github.com/apache/camel-kafka-connector/pull/1093) ([valdar](https://github.com/valdar))
- Issue/969 [\#1091](https://github.com/apache/camel-kafka-connector/pull/1091) ([valdar](https://github.com/valdar))
- \(backport\) Added Google pub/sub sink integration test [\#1088](https://github.com/apache/camel-kafka-connector/pull/1088) ([orpiske](https://github.com/orpiske))
- Add netty-http itests \#1036 [\#1084](https://github.com/apache/camel-kafka-connector/pull/1084) ([tadayosi](https://github.com/tadayosi))
- Added Camel-Kafka-connector 0.8.0 to compatibility matrix [\#1081](https://github.com/apache/camel-kafka-connector/pull/1081) ([oscerd](https://github.com/oscerd))
- Fix Netty tests reliability [\#1079](https://github.com/apache/camel-kafka-connector/pull/1079) ([orpiske](https://github.com/orpiske))
- Refresh to master fixes that were lying on camel-master \(pt 3\) [\#1076](https://github.com/apache/camel-kafka-connector/pull/1076) ([orpiske](https://github.com/orpiske))
- Refresh to master fixes that were lying on camel-master \(pt 2\) [\#1075](https://github.com/apache/camel-kafka-connector/pull/1075) ([orpiske](https://github.com/orpiske))
- Refresh to master fixes that were lying on camel-master [\#1074](https://github.com/apache/camel-kafka-connector/pull/1074) ([orpiske](https://github.com/orpiske))
- Add netty sink itest \#1036 [\#1071](https://github.com/apache/camel-kafka-connector/pull/1071) ([tadayosi](https://github.com/tadayosi))
- Add Netty source itest \#1036 [\#1066](https://github.com/apache/camel-kafka-connector/pull/1066) ([tadayosi](https://github.com/tadayosi))
- chore: update latestReleasedVersion to 0.8.0 and regen. [\#1063](https://github.com/apache/camel-kafka-connector/pull/1063) ([valdar](https://github.com/valdar))
- The count of transforms, converter and aggregation strategy seems to be broken for docs  [\#1059](https://github.com/apache/camel-kafka-connector/pull/1059) ([oscerd](https://github.com/oscerd))
- Add SMT for GenericFile of Camel-file-kafka-connector [\#1055](https://github.com/apache/camel-kafka-connector/pull/1055) ([oscerd](https://github.com/oscerd))
- Added 0.7.1 and 0.7.2 release to camel compatibility matrix [\#1054](https://github.com/apache/camel-kafka-connector/pull/1054) ([oscerd](https://github.com/oscerd))
- Website: connectors' list formatting problems [\#1042](https://github.com/apache/camel-kafka-connector/pull/1042) ([oscerd](https://github.com/oscerd))
- Generate just one connector package: .zip or .tar.gz [\#1039](https://github.com/apache/camel-kafka-connector/pull/1039) ([oscerd](https://github.com/oscerd))
- Last released version is 0.7.2 [\#1033](https://github.com/apache/camel-kafka-connector/pull/1033) ([oscerd](https://github.com/oscerd))
- Add gh action for daily maven plugins IT [\#1032](https://github.com/apache/camel-kafka-connector/pull/1032) ([tadayosi](https://github.com/tadayosi))
- Remove headers docs [\#1029](https://github.com/apache/camel-kafka-connector/pull/1029) ([oscerd](https://github.com/oscerd))
- Temporarily disable the syslog source tests on Github [\#1025](https://github.com/apache/camel-kafka-connector/pull/1025) ([orpiske](https://github.com/orpiske))
- Fixed checkstyle issues with the CXF integration tests [\#1023](https://github.com/apache/camel-kafka-connector/pull/1023) ([orpiske](https://github.com/orpiske))
- Make sure CXF tests are included in the test run [\#1021](https://github.com/apache/camel-kafka-connector/pull/1021) ([orpiske](https://github.com/orpiske))
- Add tests to camel-kafka-connector-generator-maven-plugin [\#1019](https://github.com/apache/camel-kafka-connector/pull/1019) ([tadayosi](https://github.com/tadayosi))
- \(backport\) Delay starting the producer on the syslog test to avoid failing due to port not being available [\#1017](https://github.com/apache/camel-kafka-connector/pull/1017) ([orpiske](https://github.com/orpiske))
- Delay starting the producer on the syslog test to avoid failing due to port not being available [\#1016](https://github.com/apache/camel-kafka-connector/pull/1016) ([orpiske](https://github.com/orpiske))
- \(backport\) Ensure parallel builds with mvnd work on clean environments [\#1015](https://github.com/apache/camel-kafka-connector/pull/1015) ([orpiske](https://github.com/orpiske))
- Ensure parallel builds with mvnd work on clean environments [\#1014](https://github.com/apache/camel-kafka-connector/pull/1014) ([orpiske](https://github.com/orpiske))
- \(backport\) Added AWS v2 SNS sink integration test [\#1013](https://github.com/apache/camel-kafka-connector/pull/1013) ([orpiske](https://github.com/orpiske))
- Added AWS v2 SNS sink integration test [\#1012](https://github.com/apache/camel-kafka-connector/pull/1012) ([orpiske](https://github.com/orpiske))
- Resolve Netty conflicts preventing Azure tests from running [\#1011](https://github.com/apache/camel-kafka-connector/pull/1011) ([orpiske](https://github.com/orpiske))
- Revert "Temporarily disabled a error handling test for SJMS2 due to failures on GH actions" [\#1010](https://github.com/apache/camel-kafka-connector/pull/1010) ([orpiske](https://github.com/orpiske))
- \[Github Actions\] Periodic Sync Camel-kafka-connector camel-master Branch [\#1009](https://github.com/apache/camel-kafka-connector/pull/1009) ([github-actions[bot]](https://github.com/apps/github-actions))
- Back port test fixes from master [\#1008](https://github.com/apache/camel-kafka-connector/pull/1008) ([orpiske](https://github.com/orpiske))
- Fix problem when call 'context.errantRecordReporter\(\)' will result in a NoSuchMethodException or NoClassDefFoundError when the sink connector is deployed to Connect runtimes older than Kafka 2.6 [\#1007](https://github.com/apache/camel-kafka-connector/pull/1007) ([Evgen1000end](https://github.com/Evgen1000end))
- Cleanup the check state logic on the KafkaConnectEmbeddedService [\#1006](https://github.com/apache/camel-kafka-connector/pull/1006) ([orpiske](https://github.com/orpiske))
- Rework the syslog integration tests to let JUnit handle camel's lifecycle in the test [\#1005](https://github.com/apache/camel-kafka-connector/pull/1005) ([orpiske](https://github.com/orpiske))
- Avoid blocking connector initialization on SSH tests as it leads to failures on GH actions [\#1004](https://github.com/apache/camel-kafka-connector/pull/1004) ([orpiske](https://github.com/orpiske))
- Re run failed tests automatically [\#1003](https://github.com/apache/camel-kafka-connector/pull/1003) ([orpiske](https://github.com/orpiske))
- Bump Testcontainers to version 1.15.2 [\#1002](https://github.com/apache/camel-kafka-connector/pull/1002) ([oscerd](https://github.com/oscerd))
- Regen [\#1001](https://github.com/apache/camel-kafka-connector/pull/1001) ([oscerd](https://github.com/oscerd))
- Full regen of camel-master [\#1000](https://github.com/apache/camel-kafka-connector/pull/1000) ([oscerd](https://github.com/oscerd))
- Avoid creating everything from scratch for every Cassandra sink test [\#999](https://github.com/apache/camel-kafka-connector/pull/999) ([orpiske](https://github.com/orpiske))
- Backport source test improvements and fixes [\#998](https://github.com/apache/camel-kafka-connector/pull/998) ([orpiske](https://github.com/orpiske))
- Regen connectors with descriptions [\#995](https://github.com/apache/camel-kafka-connector/pull/995) ([oscerd](https://github.com/oscerd))
- \[Backport camel-master\] Improve description of connector in documentation [\#994](https://github.com/apache/camel-kafka-connector/pull/994) ([github-actions[bot]](https://github.com/apps/github-actions))
- Improve description of connector in documentation [\#993](https://github.com/apache/camel-kafka-connector/pull/993) ([oscerd](https://github.com/oscerd))
- Override Camel's testcontainer version and upgrade to 1.15.1 due to GH issue \#990 [\#991](https://github.com/apache/camel-kafka-connector/pull/991) ([orpiske](https://github.com/orpiske))
- Added missing slow tests filter to avoid trying to run the AWS v2 test on GH actions [\#989](https://github.com/apache/camel-kafka-connector/pull/989) ([orpiske](https://github.com/orpiske))
- Cleanup all source integration tests [\#987](https://github.com/apache/camel-kafka-connector/pull/987) ([orpiske](https://github.com/orpiske))
- \[Github Actions\] Periodic Sync Camel-kafka-connector camel-master Branch [\#982](https://github.com/apache/camel-kafka-connector/pull/982) ([github-actions[bot]](https://github.com/apps/github-actions))
- fixed \#980 : camel.source.contentLogLevel config not honored in sourc… [\#981](https://github.com/apache/camel-kafka-connector/pull/981) ([valdar](https://github.com/valdar))
- \(Backport\) Make producing test messages for sink tests more flexible [\#977](https://github.com/apache/camel-kafka-connector/pull/977) ([orpiske](https://github.com/orpiske))
- Backport sink test cleanups to camel-master [\#972](https://github.com/apache/camel-kafka-connector/pull/972) ([orpiske](https://github.com/orpiske))
- Make producing test messages for sink tests more flexible [\#971](https://github.com/apache/camel-kafka-connector/pull/971) ([orpiske](https://github.com/orpiske))
- Cleanup sink test cases [\#970](https://github.com/apache/camel-kafka-connector/pull/970) ([orpiske](https://github.com/orpiske))
- Revert "Test PR" [\#968](https://github.com/apache/camel-kafka-connector/pull/968) ([oscerd](https://github.com/oscerd))
- Align camel-master to master [\#967](https://github.com/apache/camel-kafka-connector/pull/967) ([oscerd](https://github.com/oscerd))
- Test PR [\#965](https://github.com/apache/camel-kafka-connector/pull/965) ([oscerd](https://github.com/oscerd))
- Add connector entries to doc nav [\#964](https://github.com/apache/camel-kafka-connector/pull/964) ([tadayosi](https://github.com/tadayosi))
- Added idempotency test using header expressions [\#963](https://github.com/apache/camel-kafka-connector/pull/963) ([orpiske](https://github.com/orpiske))
- SJMS2 itests: Avoid creating a new consumer for every message received [\#962](https://github.com/apache/camel-kafka-connector/pull/962) ([orpiske](https://github.com/orpiske))
- Camel-master tests: Fixed dataformat [\#961](https://github.com/apache/camel-kafka-connector/pull/961) ([oscerd](https://github.com/oscerd))
- Added a basic test for idempotency [\#960](https://github.com/apache/camel-kafka-connector/pull/960) ([orpiske](https://github.com/orpiske))
- Camel master changelog [\#958](https://github.com/apache/camel-kafka-connector/pull/958) ([oscerd](https://github.com/oscerd))
- Re-introduce changelog [\#956](https://github.com/apache/camel-kafka-connector/pull/956) ([oscerd](https://github.com/oscerd))
- \[Backport camel-master\] Backport action: Added license [\#955](https://github.com/apache/camel-kafka-connector/pull/955) ([github-actions[bot]](https://github.com/apps/github-actions))
- Backport action: Added license [\#954](https://github.com/apache/camel-kafka-connector/pull/954) ([oscerd](https://github.com/oscerd))
- \[Backport camel-master\] Removed node setup from backport action [\#953](https://github.com/apache/camel-kafka-connector/pull/953) ([github-actions[bot]](https://github.com/apps/github-actions))
- Removed node setup from backport action [\#952](https://github.com/apache/camel-kafka-connector/pull/952) ([oscerd](https://github.com/oscerd))
- \[Backport camel-master\] Remove rebase camel-master on master, it is too buggy [\#951](https://github.com/apache/camel-kafka-connector/pull/951) ([github-actions[bot]](https://github.com/apps/github-actions))
- Remove rebase camel-master on master, it is too buggy [\#950](https://github.com/apache/camel-kafka-connector/pull/950) ([oscerd](https://github.com/oscerd))
- \[Backport camel-master\] Removed newline from README [\#949](https://github.com/apache/camel-kafka-connector/pull/949) ([github-actions[bot]](https://github.com/apps/github-actions))
- Removed newline from README [\#948](https://github.com/apache/camel-kafka-connector/pull/948) ([oscerd](https://github.com/oscerd))
- Test for Backport action - DO NOT MERGE [\#947](https://github.com/apache/camel-kafka-connector/pull/947) ([oscerd](https://github.com/oscerd))
- Backport.yml updated [\#946](https://github.com/apache/camel-kafka-connector/pull/946) ([oscerd](https://github.com/oscerd))
- Update documentation for testing backport action [\#944](https://github.com/apache/camel-kafka-connector/pull/944) ([oscerd](https://github.com/oscerd))
- The backport action is not allowed in ASF [\#943](https://github.com/apache/camel-kafka-connector/pull/943) ([oscerd](https://github.com/oscerd))
- Backport action test: Fixed some grammar on README [\#942](https://github.com/apache/camel-kafka-connector/pull/942) ([oscerd](https://github.com/oscerd))
- Added an example of backport yml action [\#941](https://github.com/apache/camel-kafka-connector/pull/941) ([oscerd](https://github.com/oscerd))
- \#873 initial cxf Source/Sink connectors test [\#940](https://github.com/apache/camel-kafka-connector/pull/940) ([ffang](https://github.com/ffang))
- Added Azure Storage Queue source test case [\#938](https://github.com/apache/camel-kafka-connector/pull/938) ([orpiske](https://github.com/orpiske))
- Add a map Camel Headers to Kafka headers option to make the behavior … [\#937](https://github.com/apache/camel-kafka-connector/pull/937) ([oscerd](https://github.com/oscerd))
- Provide option to delete camel kafka submodule if they are not in camel catalog [\#936](https://github.com/apache/camel-kafka-connector/pull/936) ([claudio4j](https://github.com/claudio4j))
- create a toHeader SMT \#902 [\#935](https://github.com/apache/camel-kafka-connector/pull/935) ([luigidemasi](https://github.com/luigidemasi))
- Upgrade archetype instructions to version 0.8.0 [\#934](https://github.com/apache/camel-kafka-connector/pull/934) ([oscerd](https://github.com/oscerd))
- Bump docs to 0.7.1 [\#932](https://github.com/apache/camel-kafka-connector/pull/932) ([oscerd](https://github.com/oscerd))
- Added AWS v2 S3 sink test case [\#931](https://github.com/apache/camel-kafka-connector/pull/931) ([orpiske](https://github.com/orpiske))
- Added AWS v2 KMS sink test case [\#930](https://github.com/apache/camel-kafka-connector/pull/930) ([orpiske](https://github.com/orpiske))
- Added a daily workflow for building with newer Java versions \(\#928\) [\#929](https://github.com/apache/camel-kafka-connector/pull/929) ([orpiske](https://github.com/orpiske))
- Add a map Camel Properties to Kafka headers option to make the behavi… [\#927](https://github.com/apache/camel-kafka-connector/pull/927) ([oscerd](https://github.com/oscerd))
- Removes the daily JDK 14 github action because it is already being run on the default CI action [\#926](https://github.com/apache/camel-kafka-connector/pull/926) ([orpiske](https://github.com/orpiske))
- Fix table doc and rename connecotr word [\#925](https://github.com/apache/camel-kafka-connector/pull/925) ([claudio4j](https://github.com/claudio4j))
- Added AWS v2 Kinesis sink test case [\#921](https://github.com/apache/camel-kafka-connector/pull/921) ([orpiske](https://github.com/orpiske))
- Prevent matrix jobs from rewriting the archived log on github actions [\#920](https://github.com/apache/camel-kafka-connector/pull/920) ([orpiske](https://github.com/orpiske))
- Added AWS v2 IAM sink test case [\#919](https://github.com/apache/camel-kafka-connector/pull/919) ([orpiske](https://github.com/orpiske))
- Java 14 changes [\#918](https://github.com/apache/camel-kafka-connector/pull/918) ([orpiske](https://github.com/orpiske))
- \(chores\) fixed typo in AWS v2 Cloud Watch test [\#916](https://github.com/apache/camel-kafka-connector/pull/916) ([orpiske](https://github.com/orpiske))
- Added new integration test for AWS 2 EC2 [\#915](https://github.com/apache/camel-kafka-connector/pull/915) ([orpiske](https://github.com/orpiske))
- Added integration tests for AWS2 cloud watch [\#914](https://github.com/apache/camel-kafka-connector/pull/914) ([orpiske](https://github.com/orpiske))
- Camel-Cron connector: We need to add at least camel-quartz as dependency [\#909](https://github.com/apache/camel-kafka-connector/pull/909) ([oscerd](https://github.com/oscerd))
- Added new daily JDK 14 build on github actions [\#907](https://github.com/apache/camel-kafka-connector/pull/907) ([orpiske](https://github.com/orpiske))
- Strimzi project is now using Quay for their images [\#901](https://github.com/apache/camel-kafka-connector/pull/901) ([orpiske](https://github.com/orpiske))
- \(chores\) Cleanup unused annotations [\#900](https://github.com/apache/camel-kafka-connector/pull/900) ([orpiske](https://github.com/orpiske))
- Removed unused HDFS test files that were migrated to camel-test-infra [\#899](https://github.com/apache/camel-kafka-connector/pull/899) ([orpiske](https://github.com/orpiske))
- Fixed version in compatibility matrix for 0.6.1 [\#898](https://github.com/apache/camel-kafka-connector/pull/898) ([oscerd](https://github.com/oscerd))
- Add a column to compatibility matrix about Kafka version [\#897](https://github.com/apache/camel-kafka-connector/pull/897) ([oscerd](https://github.com/oscerd))
- Bump Strimzi to version 0.21.1 [\#895](https://github.com/apache/camel-kafka-connector/pull/895) ([oscerd](https://github.com/oscerd))
- Fix HDFS tests incompatibilities [\#893](https://github.com/apache/camel-kafka-connector/pull/893) ([orpiske](https://github.com/orpiske))
- Compatibility matrix: added ckc 0.7.0 [\#891](https://github.com/apache/camel-kafka-connector/pull/891) ([oscerd](https://github.com/oscerd))
- Bump Apicurio Registry to version 1.3.2.Final [\#890](https://github.com/apache/camel-kafka-connector/pull/890) ([oscerd](https://github.com/oscerd))
- Fix using an incorrect format for the continuity check logic [\#888](https://github.com/apache/camel-kafka-connector/pull/888) ([orpiske](https://github.com/orpiske))
- Always run the archiving step so we can have log files on failure and cancelled [\#887](https://github.com/apache/camel-kafka-connector/pull/887) ([orpiske](https://github.com/orpiske))
- Modify the Github Actions configuration to allow archiving test logs \(\#882\) [\#885](https://github.com/apache/camel-kafka-connector/pull/885) ([orpiske](https://github.com/orpiske))
- Upgrade Strimzi to version 0.21.0.kafka-2.7.0 [\#884](https://github.com/apache/camel-kafka-connector/pull/884) ([oscerd](https://github.com/oscerd))
- AWS2-Kinesis SMT for extracting data [\#883](https://github.com/apache/camel-kafka-connector/pull/883) ([oscerd](https://github.com/oscerd))
- Ensures that Couchbase client dependencies are packed with the connector \(GH issue \#878\) [\#880](https://github.com/apache/camel-kafka-connector/pull/880) ([orpiske](https://github.com/orpiske))
- Bump to Kafka 2.7.0 [\#877](https://github.com/apache/camel-kafka-connector/pull/877) ([oscerd](https://github.com/oscerd))
- \(chores\) Cleanup topic deletion code and allow public access to the admin client [\#871](https://github.com/apache/camel-kafka-connector/pull/871) ([orpiske](https://github.com/orpiske))
- Added a test to make sure we retain original exception data on errors [\#870](https://github.com/apache/camel-kafka-connector/pull/870) ([orpiske](https://github.com/orpiske))
- Updates SSH tests to Camel's 3.7 test infra interfaces [\#869](https://github.com/apache/camel-kafka-connector/pull/869) ([orpiske](https://github.com/orpiske))
- Smt struct to json [\#867](https://github.com/apache/camel-kafka-connector/pull/867) ([valdar](https://github.com/valdar))
- Remove Github changelog action [\#864](https://github.com/apache/camel-kafka-connector/pull/864) ([oscerd](https://github.com/oscerd))
- Test cleanups [\#863](https://github.com/apache/camel-kafka-connector/pull/863) ([orpiske](https://github.com/orpiske))
- \(chores\) Fixed typos [\#862](https://github.com/apache/camel-kafka-connector/pull/862) ([orpiske](https://github.com/orpiske))
- Added an EventTypeTransforms to Github Source connector [\#861](https://github.com/apache/camel-kafka-connector/pull/861) ([oscerd](https://github.com/oscerd))
- Removed unused AWS common modules that was moved to Camel Core [\#860](https://github.com/apache/camel-kafka-connector/pull/860) ([orpiske](https://github.com/orpiske))
- Migrate Azure tests to the new test infra [\#859](https://github.com/apache/camel-kafka-connector/pull/859) ([orpiske](https://github.com/orpiske))
- Test cleanups when using Strimzi containers [\#856](https://github.com/apache/camel-kafka-connector/pull/856) ([orpiske](https://github.com/orpiske))
- Prevent the source ssh test from trying to load the user's private key during the test [\#854](https://github.com/apache/camel-kafka-connector/pull/854) ([orpiske](https://github.com/orpiske))
- Fixed idempotency images names [\#851](https://github.com/apache/camel-kafka-connector/pull/851) ([oscerd](https://github.com/oscerd))
- Idempotency [\#849](https://github.com/apache/camel-kafka-connector/pull/849) ([oscerd](https://github.com/oscerd))
- Added docs for idempotency first draft [\#848](https://github.com/apache/camel-kafka-connector/pull/848) ([oscerd](https://github.com/oscerd))
- Disable couchbase tests by default because they are too unreliable [\#847](https://github.com/apache/camel-kafka-connector/pull/847) ([orpiske](https://github.com/orpiske))
- Create timeout when creating Cassandra's test table [\#841](https://github.com/apache/camel-kafka-connector/pull/841) ([orpiske](https://github.com/orpiske))
- Ensure the DLQ configuration from Kafka Connect is correctly handled \(issue \#835\) [\#836](https://github.com/apache/camel-kafka-connector/pull/836) ([orpiske](https://github.com/orpiske))
- Update try-it-out-on-kubernetes procedure [\#828](https://github.com/apache/camel-kafka-connector/pull/828) ([fvaleri](https://github.com/fvaleri))
- Added a JDBC test case that does not use a custom test data source [\#827](https://github.com/apache/camel-kafka-connector/pull/827) ([orpiske](https://github.com/orpiske))
- Removed download page [\#826](https://github.com/apache/camel-kafka-connector/pull/826) ([oscerd](https://github.com/oscerd))
- Fix docs link [\#819](https://github.com/apache/camel-kafka-connector/pull/819) ([oscerd](https://github.com/oscerd))
- Added src distribution to sha512 generation list includes. [\#818](https://github.com/apache/camel-kafka-connector/pull/818) ([valdar](https://github.com/valdar))
- 0.7.0 docs [\#814](https://github.com/apache/camel-kafka-connector/pull/814) ([oscerd](https://github.com/oscerd))
- Camel kafka connector 0.7.x [\#811](https://github.com/apache/camel-kafka-connector/pull/811) ([valdar](https://github.com/valdar))
- Fix pre release [\#810](https://github.com/apache/camel-kafka-connector/pull/810) ([valdar](https://github.com/valdar))
- Added Kafka idempotent repository cache size and poll timeout docs in… [\#809](https://github.com/apache/camel-kafka-connector/pull/809) ([oscerd](https://github.com/oscerd))
- Salesforce fixes [\#808](https://github.com/apache/camel-kafka-connector/pull/808) ([orpiske](https://github.com/orpiske))
- Removed repeated idempotency.enabled option in source connector basic… [\#806](https://github.com/apache/camel-kafka-connector/pull/806) ([oscerd](https://github.com/oscerd))
- Align SQL tests with test infra from Camel 3.7 [\#804](https://github.com/apache/camel-kafka-connector/pull/804) ([orpiske](https://github.com/orpiske))
- Align RabbitMQ tests with test infra from Camel 3.7 [\#803](https://github.com/apache/camel-kafka-connector/pull/803) ([orpiske](https://github.com/orpiske))
- Align MongoDB tests with test infra from Camel 3.7 [\#802](https://github.com/apache/camel-kafka-connector/pull/802) ([orpiske](https://github.com/orpiske))
- Align JDBC tests with test infra from Camel 3.7 [\#801](https://github.com/apache/camel-kafka-connector/pull/801) ([orpiske](https://github.com/orpiske))
- Align HDFS tests with test infra from Camel 3.7 [\#800](https://github.com/apache/camel-kafka-connector/pull/800) ([orpiske](https://github.com/orpiske))
- Align ElasticSearch tests with test infra from Camel 3.7 [\#799](https://github.com/apache/camel-kafka-connector/pull/799) ([orpiske](https://github.com/orpiske))
- Align Cassandra tests with test infra from Camel 3.7 [\#798](https://github.com/apache/camel-kafka-connector/pull/798) ([orpiske](https://github.com/orpiske))
- Add SJMS2 patches to master [\#797](https://github.com/apache/camel-kafka-connector/pull/797) ([orpiske](https://github.com/orpiske))
- Upgrade Strimzi to 0.20.1 [\#796](https://github.com/apache/camel-kafka-connector/pull/796) ([oscerd](https://github.com/oscerd))
- Removed staging repositories for 3.7.0 [\#794](https://github.com/apache/camel-kafka-connector/pull/794) ([oscerd](https://github.com/oscerd))
- Camel master sync [\#791](https://github.com/apache/camel-kafka-connector/pull/791) ([oscerd](https://github.com/oscerd))
- Camel-Master updated to 3.7.0 staging [\#789](https://github.com/apache/camel-kafka-connector/pull/789) ([oscerd](https://github.com/oscerd))
- Couchbase timeout fixes on camel-master [\#787](https://github.com/apache/camel-kafka-connector/pull/787) ([orpiske](https://github.com/orpiske))
- Rebase camel-master on master by hand [\#783](https://github.com/apache/camel-kafka-connector/pull/783) ([oscerd](https://github.com/oscerd))
- \[Github Actions\] Periodic Sync Camel-kafka-connector camel-master Branch [\#776](https://github.com/apache/camel-kafka-connector/pull/776) ([github-actions[bot]](https://github.com/apps/github-actions))
- Set the service version to the supported one from Azurite to prevent test failures [\#775](https://github.com/apache/camel-kafka-connector/pull/775) ([orpiske](https://github.com/orpiske))
- Fix example CamelAmqpSourceConnector using sink instead of source pro… [\#768](https://github.com/apache/camel-kafka-connector/pull/768) ([apupier](https://github.com/apupier))
- Binary distribution created [\#765](https://github.com/apache/camel-kafka-connector/pull/765) ([valdar](https://github.com/valdar))
- Remove headers fix [\#764](https://github.com/apache/camel-kafka-connector/pull/764) ([oscerd](https://github.com/oscerd))
- chore: documentation regen for 0.6.1 [\#761](https://github.com/apache/camel-kafka-connector/pull/761) ([valdar](https://github.com/valdar))
- Support Poll timeout and key cache size as option for kafka idempotent repository [\#760](https://github.com/apache/camel-kafka-connector/pull/760) ([oscerd](https://github.com/oscerd))
- Docs update website [\#759](https://github.com/apache/camel-kafka-connector/pull/759) ([oscerd](https://github.com/oscerd))
- Camel-SQL Kafka Connector Added integration tests [\#758](https://github.com/apache/camel-kafka-connector/pull/758) ([oscerd](https://github.com/oscerd))
- Apicurio archetype docs [\#756](https://github.com/apache/camel-kafka-connector/pull/756) ([oscerd](https://github.com/oscerd))
- Documentation for dataformat archetype [\#753](https://github.com/apache/camel-kafka-connector/pull/753) ([oscerd](https://github.com/oscerd))
- Set JMS clients scope runtime to include required dependencies in the package [\#752](https://github.com/apache/camel-kafka-connector/pull/752) ([fvaleri](https://github.com/fvaleri))
- Disable slow tests [\#749](https://github.com/apache/camel-kafka-connector/pull/749) ([orpiske](https://github.com/orpiske))
- fix \#738 : added timestamp information to source records. [\#748](https://github.com/apache/camel-kafka-connector/pull/748) ([valdar](https://github.com/valdar))
- Move SshTransforms from example/it test class directly in the camel-ssh-kafka-connector [\#747](https://github.com/apache/camel-kafka-connector/pull/747) ([oscerd](https://github.com/oscerd))
- Fixed Commons-io dependency version in ssh IT test [\#741](https://github.com/apache/camel-kafka-connector/pull/741) ([oscerd](https://github.com/oscerd))
- Camel-SSH-Kafka-connector integration test [\#740](https://github.com/apache/camel-kafka-connector/pull/740) ([oscerd](https://github.com/oscerd))
- Issue/715 [\#732](https://github.com/apache/camel-kafka-connector/pull/732) ([valdar](https://github.com/valdar))
- Fixed wrong config references in both CamelSinkTask and CamelSourceTask [\#731](https://github.com/apache/camel-kafka-connector/pull/731) ([oscerd](https://github.com/oscerd))
- Prevent NPEs in the \(unlikely\) case the record value is null [\#730](https://github.com/apache/camel-kafka-connector/pull/730) ([orpiske](https://github.com/orpiske))
- Added documentation for idempotency in basic configuration docs [\#729](https://github.com/apache/camel-kafka-connector/pull/729) ([oscerd](https://github.com/oscerd))
- Added Support for KafkaIdempotentRepository [\#725](https://github.com/apache/camel-kafka-connector/pull/725) ([oscerd](https://github.com/oscerd))
- Use a Registry Ref for IdempotentRepository [\#722](https://github.com/apache/camel-kafka-connector/pull/722) ([oscerd](https://github.com/oscerd))
- Use the errorHandler variable coming from Builder [\#718](https://github.com/apache/camel-kafka-connector/pull/718) ([oscerd](https://github.com/oscerd))
- Idempotency [\#716](https://github.com/apache/camel-kafka-connector/pull/716) ([oscerd](https://github.com/oscerd))
- Issue/692 [\#714](https://github.com/apache/camel-kafka-connector/pull/714) ([valdar](https://github.com/valdar))
- Decouple the jdbc clients from the service to simplify using the test infra from Camel [\#713](https://github.com/apache/camel-kafka-connector/pull/713) ([orpiske](https://github.com/orpiske))
- Add RemoteFileTransforms to the FTP connector directly  [\#709](https://github.com/apache/camel-kafka-connector/pull/709) ([oscerd](https://github.com/oscerd))
- Add RemoteFileTransforms to the FTPS connector directly [\#707](https://github.com/apache/camel-kafka-connector/pull/707) ([oscerd](https://github.com/oscerd))
- Added missing dependency causing Strimzi tests to fail [\#706](https://github.com/apache/camel-kafka-connector/pull/706) ([orpiske](https://github.com/orpiske))
- Decouple the Azure clients from the service to simplify using the test infra from Camel [\#704](https://github.com/apache/camel-kafka-connector/pull/704) ([orpiske](https://github.com/orpiske))
- Review Archetype generation after new dependencies added to core [\#699](https://github.com/apache/camel-kafka-connector/pull/699) ([oscerd](https://github.com/oscerd))
- Avoid NPE on Windows for Catalog initialization \#697 [\#698](https://github.com/apache/camel-kafka-connector/pull/698) ([apupier](https://github.com/apupier))
- Added Download page [\#691](https://github.com/apache/camel-kafka-connector/pull/691) ([oscerd](https://github.com/oscerd))
- SFTP connector: add RemoteFileTransform [\#690](https://github.com/apache/camel-kafka-connector/pull/690) ([oscerd](https://github.com/oscerd))
- Remove hacktoberfest from label list [\#689](https://github.com/apache/camel-kafka-connector/pull/689) ([oscerd](https://github.com/oscerd))
- Added PojoToSchemaAndStructTransform to infer POJO kafka connec schem… [\#686](https://github.com/apache/camel-kafka-connector/pull/686) ([valdar](https://github.com/valdar))
- AWS v2 tests tweaks [\#684](https://github.com/apache/camel-kafka-connector/pull/684) ([orpiske](https://github.com/orpiske))
- Provide API to retrieve Basic configuration \#679 [\#683](https://github.com/apache/camel-kafka-connector/pull/683) ([apupier](https://github.com/apupier))
- Minor SJMS2 test cleanups [\#681](https://github.com/apache/camel-kafka-connector/pull/681) ([orpiske](https://github.com/orpiske))
- fix typo [\#680](https://github.com/apache/camel-kafka-connector/pull/680) ([apupier](https://github.com/apupier))
- Use foreach instead of Iterator to simplify code [\#678](https://github.com/apache/camel-kafka-connector/pull/678) ([apupier](https://github.com/apupier))
- Avoid mix of stream and non-stream; simplify comparison [\#676](https://github.com/apache/camel-kafka-connector/pull/676) ([apupier](https://github.com/apupier))
- 672 provide description in catalog [\#675](https://github.com/apache/camel-kafka-connector/pull/675) ([apupier](https://github.com/apupier))
- Use genericity to simplify code in CamelKafkaConnectorUpdateMojo [\#674](https://github.com/apache/camel-kafka-connector/pull/674) ([apupier](https://github.com/apupier))
- Remove unused private code [\#673](https://github.com/apache/camel-kafka-connector/pull/673) ([apupier](https://github.com/apupier))
- Decouple the RabbitMQ client from the service to simplify using the test infra from Camel [\#666](https://github.com/apache/camel-kafka-connector/pull/666) ([orpiske](https://github.com/orpiske))
- Decouple the MongoDB client from the service to simplify using the test infra from Camel [\#662](https://github.com/apache/camel-kafka-connector/pull/662) ([orpiske](https://github.com/orpiske))
- Added a dataformat archetype for extending connectors [\#661](https://github.com/apache/camel-kafka-connector/pull/661) ([oscerd](https://github.com/oscerd))
- Update azure-tests [\#659](https://github.com/apache/camel-kafka-connector/pull/659) ([unsortedhashsets](https://github.com/unsortedhashsets))
- Index.adoc should reflect nav.adoc [\#658](https://github.com/apache/camel-kafka-connector/pull/658) ([oscerd](https://github.com/oscerd))
- Added a page in docs related to basic configuration of camel kafka co… [\#657](https://github.com/apache/camel-kafka-connector/pull/657) ([oscerd](https://github.com/oscerd))
- Added specific section in documentation related to archetype [\#656](https://github.com/apache/camel-kafka-connector/pull/656) ([oscerd](https://github.com/oscerd))
- Update archetypes docs to point to the latest snapshot 0.7.0 [\#654](https://github.com/apache/camel-kafka-connector/pull/654) ([oscerd](https://github.com/oscerd))
- Error handling 1st part [\#653](https://github.com/apache/camel-kafka-connector/pull/653) ([oscerd](https://github.com/oscerd))
- Minor fixes [\#652](https://github.com/apache/camel-kafka-connector/pull/652) ([valdar](https://github.com/valdar))
- Provide an archetype with needed bits to use Apicurio Registry stuff [\#650](https://github.com/apache/camel-kafka-connector/pull/650) ([oscerd](https://github.com/oscerd))
- Added 0.6.0 to camel compatibility matrix [\#648](https://github.com/apache/camel-kafka-connector/pull/648) ([oscerd](https://github.com/oscerd))
- Aligned docs and link to 0.6.0 [\#647](https://github.com/apache/camel-kafka-connector/pull/647) ([oscerd](https://github.com/oscerd))
- Upgrade to Strimzi 0.20.0 and kafka-2.6.0 [\#642](https://github.com/apache/camel-kafka-connector/pull/642) ([oscerd](https://github.com/oscerd))
- Minor changes to docs - correct the camel-log and camel-timer properties file names, verbiage change on untar/unzip section. [\#639](https://github.com/apache/camel-kafka-connector/pull/639) ([cunningt](https://github.com/cunningt))
- Decouple the Elasticsearch client from the service to simplify moving the services to Camel core [\#638](https://github.com/apache/camel-kafka-connector/pull/638) ([orpiske](https://github.com/orpiske))

## [camel-kafka-connector-0.11.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.11.0) (2021-09-21)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.10.1...camel-kafka-connector-0.11.0)

**Closed issues:**

- how to convert csv to json using unmarshal/marshal  [\#1253](https://github.com/apache/camel-kafka-connector/issues/1253)
- Bump to Strimzi 0.25.0 [\#1248](https://github.com/apache/camel-kafka-connector/issues/1248)
- Configurable parameters in AWS2-s3 Kafka source connector [\#1247](https://github.com/apache/camel-kafka-connector/issues/1247)
- Using a Kafka Consumer with Idempotency enabled Kafka consume [\#1245](https://github.com/apache/camel-kafka-connector/issues/1245)
- Bump to Camel 3.11.1 [\#1243](https://github.com/apache/camel-kafka-connector/issues/1243)
- Endpoint doesn't get resolved when using Camel Splunk HEC Kafka connector [\#1241](https://github.com/apache/camel-kafka-connector/issues/1241)
- Upgrade to Camel 3.11.0 [\#1237](https://github.com/apache/camel-kafka-connector/issues/1237)
- idempotency support in Kafka AWS s3 source connector [\#1236](https://github.com/apache/camel-kafka-connector/issues/1236)
- aws2-s3 prefix not working with Kafka source connector [\#1235](https://github.com/apache/camel-kafka-connector/issues/1235)
- Is it possible to attach Custom Processor to existing Connector? [\#1228](https://github.com/apache/camel-kafka-connector/issues/1228)
- Access headers on S3 Source connector [\#1224](https://github.com/apache/camel-kafka-connector/issues/1224)
- Jira source connector only sourcing new issues [\#1221](https://github.com/apache/camel-kafka-connector/issues/1221)
- Bump to Strimzi Operator 0.24.0 [\#1219](https://github.com/apache/camel-kafka-connector/issues/1219)
- Improve documentation about limitations of special chars in the file connector [\#1218](https://github.com/apache/camel-kafka-connector/issues/1218)
- Java bean error when using aws2-s3-source connector [\#1217](https://github.com/apache/camel-kafka-connector/issues/1217)
- AWSS2-S3-Kafka connector sink returns 403 with bucket and object not public [\#1216](https://github.com/apache/camel-kafka-connector/issues/1216)
- Issue with camel-google-pubsub-kafka-connector sink configuration [\#1209](https://github.com/apache/camel-kafka-connector/issues/1209)
- CamelFileSink Connector appendChars = \n not working [\#1208](https://github.com/apache/camel-kafka-connector/issues/1208)
- aws2s3 sink connector cannot access kafka headers [\#1200](https://github.com/apache/camel-kafka-connector/issues/1200)
- Missing kafkaconnector parent pom artifact for version 0.10.0 [\#1190](https://github.com/apache/camel-kafka-connector/issues/1190)
- camel-minio-kafka-connector can't split minio file [\#1124](https://github.com/apache/camel-kafka-connector/issues/1124)

## [camel-kafka-connector-0.10.1](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.10.1) (2021-06-16)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.10.0...camel-kafka-connector-0.10.1)

**Closed issues:**

- aws2s3 source connector split file into several messages  [\#1196](https://github.com/apache/camel-kafka-connector/issues/1196)
- camel-elasticsearch-rest-kafka-connector indexId [\#1192](https://github.com/apache/camel-kafka-connector/issues/1192)
- CAMEL-AWS-KINESIS-KAFKA-CONNECTOR SOURCE CONFIGURATION [\#1186](https://github.com/apache/camel-kafka-connector/issues/1186)
- Release 0.10.0 [\#1184](https://github.com/apache/camel-kafka-connector/issues/1184)
- Bump to Camel 3.10.0 [\#1183](https://github.com/apache/camel-kafka-connector/issues/1183)
- camel-salesforce-kafka-connector missing dependency library [\#1114](https://github.com/apache/camel-kafka-connector/issues/1114)
- Improve documentation TOC [\#389](https://github.com/apache/camel-kafka-connector/issues/389)

## [camel-kafka-connector-0.10.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.10.0) (2021-05-22)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.9.0...camel-kafka-connector-0.10.0)

**Implemented enhancements:**

- Verify that sha512 files are correctly published during next release [\#162](https://github.com/apache/camel-kafka-connector/issues/162)

**Fixed bugs:**

- HTTPS-sink-connector duplicates protocol  [\#1077](https://github.com/apache/camel-kafka-connector/issues/1077)
- MongoDB tests failing with Camel master [\#974](https://github.com/apache/camel-kafka-connector/issues/974)

**Closed issues:**

- Salesforce Sink Connector does not honour `offset.flush.interval.ms` [\#1181](https://github.com/apache/camel-kafka-connector/issues/1181)
- Upgrade to Strimzi 0.23.0 [\#1173](https://github.com/apache/camel-kafka-connector/issues/1173)
- Camel Rest Kafka Connector - Issue with Kubernetes Rest connector. [\#1171](https://github.com/apache/camel-kafka-connector/issues/1171)
- Upgrade to Strimzi 0.23.0 RC [\#1166](https://github.com/apache/camel-kafka-connector/issues/1166)
- AWS SNS seems to be broken with Camel 3.9 and above [\#1156](https://github.com/apache/camel-kafka-connector/issues/1156)
- Jackson conflicts causing Azure Storage Blob tests to fail [\#1147](https://github.com/apache/camel-kafka-connector/issues/1147)
- Upgrade to Kafka 2.8.0 [\#1145](https://github.com/apache/camel-kafka-connector/issues/1145)
- example of a sql source connector url pattern [\#1144](https://github.com/apache/camel-kafka-connector/issues/1144)
- Upstream CI failures [\#1143](https://github.com/apache/camel-kafka-connector/issues/1143)
- Align master to latest camel snapshot [\#1133](https://github.com/apache/camel-kafka-connector/issues/1133)
- Connector Kafka Idempotency Crash Resilience [\#1128](https://github.com/apache/camel-kafka-connector/issues/1128)
- Release 0.9.0 [\#1127](https://github.com/apache/camel-kafka-connector/issues/1127)
- NetworkUtils should be able to hold a free port for later usage [\#1109](https://github.com/apache/camel-kafka-connector/issues/1109)
- Google pub/sub: endpoint option cannot be set [\#1086](https://github.com/apache/camel-kafka-connector/issues/1086)
- Missing message key on outbound using Camel Kafka KafkaConnector [\#988](https://github.com/apache/camel-kafka-connector/issues/988)
- Question: S3 source connector pulls duplicate data when task.max \> 1 [\#959](https://github.com/apache/camel-kafka-connector/issues/959)
- add itests for camel-cxf-kafka-connector [\#873](https://github.com/apache/camel-kafka-connector/issues/873)
- SJMS2 connector fails with qpid JmsConnectionFactory [\#751](https://github.com/apache/camel-kafka-connector/issues/751)

## [camel-kafka-connector-0.9.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.9.0) (2021-03-30)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.7.3...camel-kafka-connector-0.9.0)

**Fixed bugs:**

- Camel-Netty-\* connectors are not working [\#924](https://github.com/apache/camel-kafka-connector/issues/924)

**Closed issues:**

- Upgrade Strimzi to version 0.22.1 [\#1117](https://github.com/apache/camel-kafka-connector/issues/1117)
- camel-mongodb-kafka-connector produce message format error [\#1113](https://github.com/apache/camel-kafka-connector/issues/1113)
- aws2 s3 source connector ClassCastException for value.conver [\#1107](https://github.com/apache/camel-kafka-connector/issues/1107)
- Upgrade Strimzi to version 0.22.0 [\#1105](https://github.com/apache/camel-kafka-connector/issues/1105)
- Release 0.7.3 [\#1095](https://github.com/apache/camel-kafka-connector/issues/1095)

## [camel-kafka-connector-0.7.3](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.7.3) (2021-03-13)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.8.0...camel-kafka-connector-0.7.3)

**Fixed bugs:**

- Prevent Kafka Connect from leaking passwords and sensitive data [\#1050](https://github.com/apache/camel-kafka-connector/issues/1050)
- Convert NettyChannelBufferStreamCache from NettyHttpSource not converted to string [\#969](https://github.com/apache/camel-kafka-connector/issues/969)

**Closed issues:**

- netty-http sink itests - mock web server out of test code into JUnit 5 extension [\#1085](https://github.com/apache/camel-kafka-connector/issues/1085)
- `camel.source.endpoint.sync` issue in CamelInfinispanSourceConnector in 0.8.0 [\#1068](https://github.com/apache/camel-kafka-connector/issues/1068)
- ITests don't work when a test class is specified with `-Dtest=...` [\#1062](https://github.com/apache/camel-kafka-connector/issues/1062)
- The count of transforms, converter and aggregation strategy seems to be broken for docs [\#1057](https://github.com/apache/camel-kafka-connector/issues/1057)
- Add SMT for GenericFile of Camel-file-kafka-connector [\#1047](https://github.com/apache/camel-kafka-connector/issues/1047)
- Add itests for camel-kafka-netty\*-connectors [\#1036](https://github.com/apache/camel-kafka-connector/issues/1036)
- Grab topics using regex and put in S3 by topic name [\#1020](https://github.com/apache/camel-kafka-connector/issues/1020)
- How to set Map property via the kafka connector configuration [\#323](https://github.com/apache/camel-kafka-connector/issues/323)

## [camel-kafka-connector-0.8.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.8.0) (2021-02-22)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.7.2...camel-kafka-connector-0.8.0)

**Implemented enhancements:**

- Camel components secret options are showed in logs [\#159](https://github.com/apache/camel-kafka-connector/issues/159)

**Fixed bugs:**

- Azure storage queue failing on Camel Master [\#976](https://github.com/apache/camel-kafka-connector/issues/976)
- SJMS2 Startup test failing on Camel Master [\#975](https://github.com/apache/camel-kafka-connector/issues/975)
- Add tests to camel-kafka-connector-generator-maven-plugin [\#166](https://github.com/apache/camel-kafka-connector/issues/166)

**Closed issues:**

- Website: connectors' list formatting problems [\#1041](https://github.com/apache/camel-kafka-connector/issues/1041)
- Generate just one connector package: .zip or .tar.gz [\#1030](https://github.com/apache/camel-kafka-connector/issues/1030)
- Azure storage blob failing on camel-master [\#997](https://github.com/apache/camel-kafka-connector/issues/997)
- Consistent failures in GH tests [\#990](https://github.com/apache/camel-kafka-connector/issues/990)
- Release 0.7.2 once Camel 3.7.2 will be released [\#978](https://github.com/apache/camel-kafka-connector/issues/978)
- Add removeHeaders documentation [\#903](https://github.com/apache/camel-kafka-connector/issues/903)
- Add test for AWS 2 SNS [\#700](https://github.com/apache/camel-kafka-connector/issues/700)
- Add an example of FHIR connector's usage [\#402](https://github.com/apache/camel-kafka-connector/issues/402)
- aws2S3connector: camel.source.endpoint.runLoggingLevel=TRACE no trace log [\#340](https://github.com/apache/camel-kafka-connector/issues/340)
- Add a release notes page in docs [\#302](https://github.com/apache/camel-kafka-connector/issues/302)

## [camel-kafka-connector-0.7.2](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.7.2) (2021-02-13)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.7.1...camel-kafka-connector-0.7.2)

**Implemented enhancements:**

- camel-kafka-connector-generator-maven-plugin: optionally delete submodules not in catalog [\#149](https://github.com/apache/camel-kafka-connector/issues/149)

**Fixed bugs:**

- Java 14 support: gmavenplus-plugin likely not compatible [\#910](https://github.com/apache/camel-kafka-connector/issues/910)

**Closed issues:**

- camel.source.contentLogLevel config not honored in source connectors [\#980](https://github.com/apache/camel-kafka-connector/issues/980)
- Improve description of connector [\#979](https://github.com/apache/camel-kafka-connector/issues/979)
- CamelKafkaConnectMain is showing sensitive information in summary [\#973](https://github.com/apache/camel-kafka-connector/issues/973)
- Camel-master: Let's change the gh action to be triggered when a push on master has been done [\#939](https://github.com/apache/camel-kafka-connector/issues/939)
- Add a map Camel Headers to Kafka headers option to make the behavior configurable [\#923](https://github.com/apache/camel-kafka-connector/issues/923)
- Add a map Camel Properties to Kafka headers option to make the behavior configurable [\#922](https://github.com/apache/camel-kafka-connector/issues/922)
- Java 14 support [\#913](https://github.com/apache/camel-kafka-connector/issues/913)
- create a toHeader SMT  [\#902](https://github.com/apache/camel-kafka-connector/issues/902)
- Upgrade to Camel 3.7.1 the 0.7.x branch and release [\#872](https://github.com/apache/camel-kafka-connector/issues/872)
- Camel-Master: SJMS2 it test is failing [\#844](https://github.com/apache/camel-kafka-connector/issues/844)
- Support camel dataformat configuration for marshaller/unmarshaller [\#816](https://github.com/apache/camel-kafka-connector/issues/816)
- Create a Twitter timeline example [\#640](https://github.com/apache/camel-kafka-connector/issues/640)
- Introduce Error Handling Options possibilities [\#407](https://github.com/apache/camel-kafka-connector/issues/407)

## [camel-kafka-connector-0.7.1](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.7.1) (2021-01-24)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.7.0...camel-kafka-connector-0.7.1)

**Implemented enhancements:**

- Produce a download/release page [\#163](https://github.com/apache/camel-kafka-connector/issues/163)

**Fixed bugs:**

- Error reporting configuration incorrectly handled [\#835](https://github.com/apache/camel-kafka-connector/issues/835)

**Closed issues:**

- Camel-Cron connector: We need to add at least camel-quartz as dependency [\#908](https://github.com/apache/camel-kafka-connector/issues/908)
- Add a column to compatibility matrix about Kafka version [\#896](https://github.com/apache/camel-kafka-connector/issues/896)
- Bump to Strimzi 0.21.1 [\#894](https://github.com/apache/camel-kafka-connector/issues/894)
- Bump Apicurio Registry to 1.3.2.Final [\#889](https://github.com/apache/camel-kafka-connector/issues/889)
- Modify the Github Actions configuration to allow archiving test logs [\#882](https://github.com/apache/camel-kafka-connector/issues/882)
- HDFS tests running suspiciously flaky on Github actions [\#879](https://github.com/apache/camel-kafka-connector/issues/879)
- Couchbase dependency missing? [\#878](https://github.com/apache/camel-kafka-connector/issues/878)
- Bump to Strimzi 0.21.0 [\#876](https://github.com/apache/camel-kafka-connector/issues/876)
- Bump to Kafka 2.7.0 [\#875](https://github.com/apache/camel-kafka-connector/issues/875)
- \[Question\] liveness and readiness probes example for camel-kafka-connector [\#874](https://github.com/apache/camel-kafka-connector/issues/874)
- AWS2-Kinesis: Add examples [\#866](https://github.com/apache/camel-kafka-connector/issues/866)
- AWS2-Kinesis connector: Add a transformation to extract only the data from a source stream [\#857](https://github.com/apache/camel-kafka-connector/issues/857)
- Github source connector: Add some transforms to deal with the different possible events [\#853](https://github.com/apache/camel-kafka-connector/issues/853)
- \[Question\] How to process avro message in S3 connector [\#843](https://github.com/apache/camel-kafka-connector/issues/843)
- Remove changelog gh action [\#842](https://github.com/apache/camel-kafka-connector/issues/842)
- Support Parquet input Files using HDFS \(compressed or not compressed\) [\#840](https://github.com/apache/camel-kafka-connector/issues/840)
- Add Github examples [\#825](https://github.com/apache/camel-kafka-connector/issues/825)
- Add JDBC examples [\#824](https://github.com/apache/camel-kafka-connector/issues/824)
- Add Mongodb examples [\#823](https://github.com/apache/camel-kafka-connector/issues/823)
- Investigate usage of NO\_DEFAULT\_VALUE instead of null for properties [\#821](https://github.com/apache/camel-kafka-connector/issues/821)
- Reading data from AMQP protocal using Strimzi kafka connector [\#817](https://github.com/apache/camel-kafka-connector/issues/817)
- Date templating not working in version 0.6.0 [\#812](https://github.com/apache/camel-kafka-connector/issues/812)
- Camel-AWS2-S3 connector: Add out of the box specific Aggregation Strategies [\#784](https://github.com/apache/camel-kafka-connector/issues/784)
- using aws2-s3 source and sink to move files between buckets [\#762](https://github.com/apache/camel-kafka-connector/issues/762)
- Add Braintree examples [\#628](https://github.com/apache/camel-kafka-connector/issues/628)
- Create example for Couchbase connector [\#597](https://github.com/apache/camel-kafka-connector/issues/597)
- Create a Google calendar example [\#424](https://github.com/apache/camel-kafka-connector/issues/424)

## [camel-kafka-connector-0.7.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.7.0) (2020-12-21)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.6.1...camel-kafka-connector-0.7.0)

**Fixed bugs:**

- Jetty conflicts in Salesforce connector [\#807](https://github.com/apache/camel-kafka-connector/issues/807)

**Closed issues:**

- CamelAmqpSourceConnector example contains wrong camel.sink parameters [\#767](https://github.com/apache/camel-kafka-connector/issues/767)
- Getting some error logs for camel.connector 3.1.0 with strimzi 0.20.0 update [\#766](https://github.com/apache/camel-kafka-connector/issues/766)
- Add a removeHeaders option on both source and sink [\#763](https://github.com/apache/camel-kafka-connector/issues/763)
- Added Camel-SQL kafka connector integration test [\#757](https://github.com/apache/camel-kafka-connector/issues/757)
- Create binary distribution [\#754](https://github.com/apache/camel-kafka-connector/issues/754)
- Possibly moving Integration tests in a separated repository? [\#746](https://github.com/apache/camel-kafka-connector/issues/746)
- Support Poll timeout and key cache size as option for kafka idempotent repository [\#734](https://github.com/apache/camel-kafka-connector/issues/734)
- Provide validation of properties file from the catalog [\#671](https://github.com/apache/camel-kafka-connector/issues/671)
- Include possible enum values in Catalog [\#645](https://github.com/apache/camel-kafka-connector/issues/645)
- \[camel-main-support\] Use camel's built-in support for configuring data formats trough properties [\#497](https://github.com/apache/camel-kafka-connector/issues/497)
- Create Arangodb examples [\#457](https://github.com/apache/camel-kafka-connector/issues/457)

## [camel-kafka-connector-0.6.1](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.6.1) (2020-11-27)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.6.0...camel-kafka-connector-0.6.1)

**Implemented enhancements:**

- Review Archetype generation after new dependencies added to core [\#693](https://github.com/apache/camel-kafka-connector/issues/693)
- Cache already computed Schemas in PojoToSchemaAndStructTransform [\#692](https://github.com/apache/camel-kafka-connector/issues/692)

**Closed issues:**

- Move SshTransforms from example/it test class directly in the camel-ssh-kafka-connector [\#742](https://github.com/apache/camel-kafka-connector/issues/742)
- Missing timestamp information [\#738](https://github.com/apache/camel-kafka-connector/issues/738)
- Create SSH connector examples [\#737](https://github.com/apache/camel-kafka-connector/issues/737)
- Create Twitter direct message examples [\#736](https://github.com/apache/camel-kafka-connector/issues/736)
- Added example for AWS2-STS [\#727](https://github.com/apache/camel-kafka-connector/issues/727)
- File language and core languages in general are not working [\#720](https://github.com/apache/camel-kafka-connector/issues/720)
- Idempotency: Support KafkaIdempotentRepository from Camel  [\#719](https://github.com/apache/camel-kafka-connector/issues/719)
- Create the sink counterpart of the PojoToSchemaAndStructTransform [\#715](https://github.com/apache/camel-kafka-connector/issues/715)
- Add Google Sheets Stream source example [\#703](https://github.com/apache/camel-kafka-connector/issues/703)
- Add RemoteFileTransforms to the FTPS connector directly [\#702](https://github.com/apache/camel-kafka-connector/issues/702)
- Add RemoteFileTransforms to the FTP connector directly [\#701](https://github.com/apache/camel-kafka-connector/issues/701)
- Camel Kafka Connector Catalog throws NPE on Windows [\#697](https://github.com/apache/camel-kafka-connector/issues/697)
- Create Camel Google Mail Stream Source example [\#696](https://github.com/apache/camel-kafka-connector/issues/696)
- Create Google Calendar Stream Source Example [\#695](https://github.com/apache/camel-kafka-connector/issues/695)
- Provide API in Camel Connector Catalog to retrieve Camel Kafka Basic configuration [\#679](https://github.com/apache/camel-kafka-connector/issues/679)
- Provide description for connector in the catalog [\#672](https://github.com/apache/camel-kafka-connector/issues/672)
- Add RemoteFileTransforms to the connector directly [\#670](https://github.com/apache/camel-kafka-connector/issues/670)
- Added Git connector examples [\#669](https://github.com/apache/camel-kafka-connector/issues/669)
- Add SFTP examples [\#668](https://github.com/apache/camel-kafka-connector/issues/668)
- Add Simple Language support  [\#667](https://github.com/apache/camel-kafka-connector/issues/667)
- Create example for camel-pgevent connector [\#664](https://github.com/apache/camel-kafka-connector/issues/664)
- Support Idempotency on source and sink [\#663](https://github.com/apache/camel-kafka-connector/issues/663)
- Add an extensible connector archetype with dataformat [\#660](https://github.com/apache/camel-kafka-connector/issues/660)
- Create a Camel-exec example [\#649](https://github.com/apache/camel-kafka-connector/issues/649)
- Provide an archetype with needed bits to use Apicurio Registry stuff [\#646](https://github.com/apache/camel-kafka-connector/issues/646)
- Bump to Strimzi 0.20.0 and Kafka 2.6.0 [\#641](https://github.com/apache/camel-kafka-connector/issues/641)
- Add Twittersearch examples [\#637](https://github.com/apache/camel-kafka-connector/issues/637)
- Add Openshift instrunctions for Telegram examples [\#636](https://github.com/apache/camel-kafka-connector/issues/636)
- Create example for camel-resteasy-kafka-source-connector [\#565](https://github.com/apache/camel-kafka-connector/issues/565)
- Beans aggregation size and timeout [\#487](https://github.com/apache/camel-kafka-connector/issues/487)
- Camel-telegram wrongly parse chatId from headers [\#463](https://github.com/apache/camel-kafka-connector/issues/463)
- Release 0.4.4 [\#451](https://github.com/apache/camel-kafka-connector/issues/451)
- camel-azure-storage-queue-kafka-connector: Unknown parameter 'accountName' [\#409](https://github.com/apache/camel-kafka-connector/issues/409)

## [camel-kafka-connector-0.6.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.6.0) (2020-10-24)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.4.4...camel-kafka-connector-0.6.0)

**Implemented enhancements:**

- Better handling of property with no default values using `ConfigDef.NO_DEFAULT_VALUE` [\#563](https://github.com/apache/camel-kafka-connector/issues/563)
- camel-kafka-connector-generator-maven-plugin: prevent the ovewrite of exixting classes unless they are @Generated annotated [\#146](https://github.com/apache/camel-kafka-connector/issues/146)

**Closed issues:**

- Add the required field for connector options in docs and catalog [\#617](https://github.com/apache/camel-kafka-connector/issues/617)
- Move ConnectRecordValueToMapTransformer of Elastisearch IT test in the connector [\#615](https://github.com/apache/camel-kafka-connector/issues/615)
- Add a Telegram example  [\#613](https://github.com/apache/camel-kafka-connector/issues/613)
- Remove camel-hipchat from camel-master [\#603](https://github.com/apache/camel-kafka-connector/issues/603)
- Add a file watch connector example  [\#600](https://github.com/apache/camel-kafka-connector/issues/600)
- Camel Kafka connector extensible is broken with mvnd [\#598](https://github.com/apache/camel-kafka-connector/issues/598)
- Rename all transformers, converters, aggregationStrategies to reflect the maning convention we have [\#590](https://github.com/apache/camel-kafka-connector/issues/590)
- Strimzi 0.20: Lets test early with Release candidate [\#581](https://github.com/apache/camel-kafka-connector/issues/581)
- Slack Connector: Add the slack transformer from itest to the slack connector ootb [\#580](https://github.com/apache/camel-kafka-connector/issues/580)
- Provide API on Camel Kafka Connector to add/remove connectors dynamically [\#573](https://github.com/apache/camel-kafka-connector/issues/573)
- Improve README [\#569](https://github.com/apache/camel-kafka-connector/issues/569)
- Create an AWS2-Translate example [\#564](https://github.com/apache/camel-kafka-connector/issues/564)
- Add converters, transforms and aggregationStrategies to catalog [\#559](https://github.com/apache/camel-kafka-connector/issues/559)
- Add more convenience method to CamelKafkaConnectorCatalog [\#558](https://github.com/apache/camel-kafka-connector/issues/558)
- Improve Catalog and cleanup [\#537](https://github.com/apache/camel-kafka-connector/issues/537)
- Create a source distribution module [\#524](https://github.com/apache/camel-kafka-connector/issues/524)
- Create examples with dataformat in camel-kafka-connector-examples repo [\#509](https://github.com/apache/camel-kafka-connector/issues/509)
- \[task helper\] use EndpointUriFactory to generate endpoint URIs [\#500](https://github.com/apache/camel-kafka-connector/issues/500)
- Examples instructions for Openshift too [\#465](https://github.com/apache/camel-kafka-connector/issues/465)
- Add integration test for archetype [\#462](https://github.com/apache/camel-kafka-connector/issues/462)
- Provide a catalog of potential configuration properties specific to Camel Kafka Connector [\#430](https://github.com/apache/camel-kafka-connector/issues/430)

**Merged pull requests:**

- Switches the AWS v2 test infra-structure [\#635](https://github.com/apache/camel-kafka-connector/pull/635) ([orpiske](https://github.com/orpiske))
- Decouple the Cassandra client from the service to simplify moving the services to Camel core [\#634](https://github.com/apache/camel-kafka-connector/pull/634) ([orpiske](https://github.com/orpiske))
- Switches the AWS v1 test infra-structure [\#633](https://github.com/apache/camel-kafka-connector/pull/633) ([orpiske](https://github.com/orpiske))
- Switches the Kafka test infra-structure [\#632](https://github.com/apache/camel-kafka-connector/pull/632) ([orpiske](https://github.com/orpiske))
- Early Strimzi Test: Lets test with 0.20.0 RC3 [\#631](https://github.com/apache/camel-kafka-connector/pull/631) ([oscerd](https://github.com/oscerd))
- Added integration test for Couchbase sink [\#630](https://github.com/apache/camel-kafka-connector/pull/630) ([orpiske](https://github.com/orpiske))
- Added convenience method to get option from connector name and option name [\#627](https://github.com/apache/camel-kafka-connector/pull/627) ([oscerd](https://github.com/oscerd))
- Automatic changelog: Remove deprecated github action commands [\#626](https://github.com/apache/camel-kafka-connector/pull/626) ([oscerd](https://github.com/oscerd))
- Cleanup distribution [\#625](https://github.com/apache/camel-kafka-connector/pull/625) ([oscerd](https://github.com/oscerd))
- Add the required field for connector options in docs and catalog [\#624](https://github.com/apache/camel-kafka-connector/pull/624) ([oscerd](https://github.com/oscerd))
- cleanup core deps and leftovers [\#623](https://github.com/apache/camel-kafka-connector/pull/623) ([lburgazzoli](https://github.com/lburgazzoli))
- core: use EndpointUriFactory to compute endpoint urls instead of the runtime catalog [\#622](https://github.com/apache/camel-kafka-connector/pull/622) ([lburgazzoli](https://github.com/lburgazzoli))
- Removed Camel 3.6.0 staging repository [\#620](https://github.com/apache/camel-kafka-connector/pull/620) ([oscerd](https://github.com/oscerd))
- Move ConnectRecordValueToMapTransformer of Elastisearch IT test in the connector [\#618](https://github.com/apache/camel-kafka-connector/pull/618) ([oscerd](https://github.com/oscerd))
- Swap arguments so they are in the correct order: expected value, actual [\#616](https://github.com/apache/camel-kafka-connector/pull/616) ([apupier](https://github.com/apupier))
- Added Release to 0.4.4 to Camel compatibility matrix [\#614](https://github.com/apache/camel-kafka-connector/pull/614) ([oscerd](https://github.com/oscerd))
- Staging 3.6.0 and camel master [\#612](https://github.com/apache/camel-kafka-connector/pull/612) ([oscerd](https://github.com/oscerd))
- JDK naming Jenkinsfiles [\#610](https://github.com/apache/camel-kafka-connector/pull/610) ([oscerd](https://github.com/oscerd))
- Apply the Strimzi next profile only to the connector build [\#608](https://github.com/apache/camel-kafka-connector/pull/608) ([orpiske](https://github.com/orpiske))
- Reneamed a method to better understanding, added a test and javadoc a… [\#607](https://github.com/apache/camel-kafka-connector/pull/607) ([valdar](https://github.com/valdar))
- Catalog improve [\#606](https://github.com/apache/camel-kafka-connector/pull/606) ([valdar](https://github.com/valdar))
- Improve CKC core [\#601](https://github.com/apache/camel-kafka-connector/pull/601) ([lburgazzoli](https://github.com/lburgazzoli))
- Updated the mvnd command on the readme [\#599](https://github.com/apache/camel-kafka-connector/pull/599) ([orpiske](https://github.com/orpiske))
- Camel-kafka-connector-catalog: Adding some more tests [\#596](https://github.com/apache/camel-kafka-connector/pull/596) ([oscerd](https://github.com/oscerd))
- Slack transforms [\#595](https://github.com/apache/camel-kafka-connector/pull/595) ([oscerd](https://github.com/oscerd))
- Rename all transformers, converters, aggregationStrategies to reflect the maning convention we have [\#593](https://github.com/apache/camel-kafka-connector/pull/593) ([oscerd](https://github.com/oscerd))
- Improve readme [\#591](https://github.com/apache/camel-kafka-connector/pull/591) ([orpiske](https://github.com/orpiske))
- Add converters, transforms and aggregationStrategies to catalog [\#589](https://github.com/apache/camel-kafka-connector/pull/589) ([oscerd](https://github.com/oscerd))
- Avoid usage of static for Camel Kafka Connector catalog [\#588](https://github.com/apache/camel-kafka-connector/pull/588) ([apupier](https://github.com/apupier))
- Added GH actions to run the camel-master build using the Strimzi Next profile [\#587](https://github.com/apache/camel-kafka-connector/pull/587) ([orpiske](https://github.com/orpiske))
- Changes to documents - change version from 0.3.0-SNAPSHOT, give the right location of the properties file within docs/examples [\#586](https://github.com/apache/camel-kafka-connector/pull/586) ([cunningt](https://github.com/cunningt))
- Issue/563 [\#585](https://github.com/apache/camel-kafka-connector/pull/585) ([valdar](https://github.com/valdar))
- JMS example: Added missing steps [\#584](https://github.com/apache/camel-kafka-connector/pull/584) ([oscerd](https://github.com/oscerd))
- Added new test for Azure Storage Blob sink [\#582](https://github.com/apache/camel-kafka-connector/pull/582) ([orpiske](https://github.com/orpiske))
- ISSUE-524 Create a source distribution module [\#577](https://github.com/apache/camel-kafka-connector/pull/577) ([cunningt](https://github.com/cunningt))
- ISSUE-146 Prevent the overwrite of existing classes unless they are @Generated annotated [\#576](https://github.com/apache/camel-kafka-connector/pull/576) ([cunningt](https://github.com/cunningt))
- Camel-Kafka-kafka-connector is back [\#575](https://github.com/apache/camel-kafka-connector/pull/575) ([oscerd](https://github.com/oscerd))
- 573 allow to add remove elements from catalog dynamically through api [\#574](https://github.com/apache/camel-kafka-connector/pull/574) ([apupier](https://github.com/apupier))
- Add back AWS\*-connectors [\#572](https://github.com/apache/camel-kafka-connector/pull/572) ([oscerd](https://github.com/oscerd))
- Improve Catalog and cleanup [\#571](https://github.com/apache/camel-kafka-connector/pull/571) ([oscerd](https://github.com/oscerd))
- github action: add trigger on workflow\_dispatch [\#568](https://github.com/apache/camel-kafka-connector/pull/568) ([lburgazzoli](https://github.com/lburgazzoli))
- GH actions: Fixed deploy action [\#567](https://github.com/apache/camel-kafka-connector/pull/567) ([oscerd](https://github.com/oscerd))
- Do not use the wrapper test client on the AWS v2 service classes [\#562](https://github.com/apache/camel-kafka-connector/pull/562) ([orpiske](https://github.com/orpiske))
- Have CamelKafkaConnectorCatalog working with bundled jar [\#554](https://github.com/apache/camel-kafka-connector/pull/554) ([apupier](https://github.com/apupier))
- Catalog: Removed static modifier from getConnectorsModel [\#553](https://github.com/apache/camel-kafka-connector/pull/553) ([oscerd](https://github.com/oscerd))
- build: execute ci-build for pr/push to the camel-master branch [\#552](https://github.com/apache/camel-kafka-connector/pull/552) ([lburgazzoli](https://github.com/lburgazzoli))
- Jenkinsfiles clean [\#551](https://github.com/apache/camel-kafka-connector/pull/551) ([oscerd](https://github.com/oscerd))
- Catalog: expose an API for consuming connectors catalog metadata and options [\#548](https://github.com/apache/camel-kafka-connector/pull/548) ([oscerd](https://github.com/oscerd))
- core: simplify kafka headers to camel exchange mapping [\#547](https://github.com/apache/camel-kafka-connector/pull/547) ([lburgazzoli](https://github.com/lburgazzoli))
- source: better handling of headers of type Data [\#546](https://github.com/apache/camel-kafka-connector/pull/546) ([lburgazzoli](https://github.com/lburgazzoli))
- Do not use the wrapper test client on the AWS service classes [\#545](https://github.com/apache/camel-kafka-connector/pull/545) ([orpiske](https://github.com/orpiske))
- core: cast from Byte\[\] to byte\[\] fails because of incompatible types [\#543](https://github.com/apache/camel-kafka-connector/pull/543) ([lburgazzoli](https://github.com/lburgazzoli))
- core: add support for aggreation on source sinks [\#541](https://github.com/apache/camel-kafka-connector/pull/541) ([lburgazzoli](https://github.com/lburgazzoli))
- Improve Catalog and cleanup [\#540](https://github.com/apache/camel-kafka-connector/pull/540) ([oscerd](https://github.com/oscerd))
- \[core\] use Endpoint instead of URI string to send exchnages using the producer template [\#538](https://github.com/apache/camel-kafka-connector/pull/538) ([lburgazzoli](https://github.com/lburgazzoli))
- Catalog: Rename the json file to reflect the id and connectors.properties content [\#536](https://github.com/apache/camel-kafka-connector/pull/536) ([oscerd](https://github.com/oscerd))
- Improve core [\#535](https://github.com/apache/camel-kafka-connector/pull/535) ([lburgazzoli](https://github.com/lburgazzoli))
- Clean up usages of org.junit.Assert [\#533](https://github.com/apache/camel-kafka-connector/pull/533) ([mureinik](https://github.com/mureinik))
- chore\(build\): merge GitHub workflow master-pr-build master-push-build [\#532](https://github.com/apache/camel-kafka-connector/pull/532) ([lburgazzoli](https://github.com/lburgazzoli))
- Added build details using mvnd [\#531](https://github.com/apache/camel-kafka-connector/pull/531) ([orpiske](https://github.com/orpiske))
- Add a Maven Plugin to collect the connector descriptors for catalog purpose [\#530](https://github.com/apache/camel-kafka-connector/pull/530) ([oscerd](https://github.com/oscerd))
- chore\(build\): split build in multiple steps [\#528](https://github.com/apache/camel-kafka-connector/pull/528) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(build\): use AdoptOpenJDK to set-up java [\#527](https://github.com/apache/camel-kafka-connector/pull/527) ([lburgazzoli](https://github.com/lburgazzoli))
- \[camel-main-support\] Use BaseMainSupport instead of Main [\#526](https://github.com/apache/camel-kafka-connector/pull/526) ([lburgazzoli](https://github.com/lburgazzoli))
- Create descriptors for source and sink connector for catalog purpose [\#525](https://github.com/apache/camel-kafka-connector/pull/525) ([oscerd](https://github.com/oscerd))
- camel-kafka-connector-model should have tooling pom as parent pom [\#521](https://github.com/apache/camel-kafka-connector/pull/521) ([valdar](https://github.com/valdar))
- Added encoding to maven-resources-plugin to avoid warning [\#520](https://github.com/apache/camel-kafka-connector/pull/520) ([oscerd](https://github.com/oscerd))
- Fixed GH Actions with the new camel-kafka-connector-model [\#519](https://github.com/apache/camel-kafka-connector/pull/519) ([oscerd](https://github.com/oscerd))
- Move model classes CamelKafkaConnectorModel and CamelKafkaConnectorOp… [\#518](https://github.com/apache/camel-kafka-connector/pull/518) ([oscerd](https://github.com/oscerd))
- adding docs that explain the directory requirement under the plugins folder [\#517](https://github.com/apache/camel-kafka-connector/pull/517) ([codexetreme](https://github.com/codexetreme))
- Added a camel-kafka-connector-catalog collecting all the JSON metadata [\#516](https://github.com/apache/camel-kafka-connector/pull/516) ([oscerd](https://github.com/oscerd))
- Generate a Json Metadata file for each connector [\#512](https://github.com/apache/camel-kafka-connector/pull/512) ([oscerd](https://github.com/oscerd))
- Opted the project in for HAcktoberfest 2020. [\#511](https://github.com/apache/camel-kafka-connector/pull/511) ([valdar](https://github.com/valdar))
- Add an integration test for the archetype [\#510](https://github.com/apache/camel-kafka-connector/pull/510) ([cunningt](https://github.com/cunningt))
- \[camel-main-support\] Reordering props should not be required anymore [\#507](https://github.com/apache/camel-kafka-connector/pull/507) ([oscerd](https://github.com/oscerd))
- Removed folder added for error and regen docs [\#504](https://github.com/apache/camel-kafka-connector/pull/504) ([oscerd](https://github.com/oscerd))
- Throttles strimzi startup to prevent resource reuse errors [\#503](https://github.com/apache/camel-kafka-connector/pull/503) ([orpiske](https://github.com/orpiske))
- Rabbitmq itest [\#501](https://github.com/apache/camel-kafka-connector/pull/501) ([valdar](https://github.com/valdar))
- Removed the Jenkinsfile deploy pipeline, we are now using gh action [\#496](https://github.com/apache/camel-kafka-connector/pull/496) ([oscerd](https://github.com/oscerd))
- Upgrade Maven Wrapper to 0.5.6 [\#495](https://github.com/apache/camel-kafka-connector/pull/495) ([oscerd](https://github.com/oscerd))
- Deploy on ASF Snapshot [\#493](https://github.com/apache/camel-kafka-connector/pull/493) ([oscerd](https://github.com/oscerd))
- Issue 490 [\#491](https://github.com/apache/camel-kafka-connector/pull/491) ([oscerd](https://github.com/oscerd))
- Fixes changelog to run only on master [\#488](https://github.com/apache/camel-kafka-connector/pull/488) ([oscerd](https://github.com/oscerd))
- Removed bean-validator kafka connector [\#483](https://github.com/apache/camel-kafka-connector/pull/483) ([oscerd](https://github.com/oscerd))
- Re-introduce camel-bean-kafka-connector [\#482](https://github.com/apache/camel-kafka-connector/pull/482) ([oscerd](https://github.com/oscerd))
- Bean connector removed [\#481](https://github.com/apache/camel-kafka-connector/pull/481) ([oscerd](https://github.com/oscerd))
- Added AWS S3 test using AWS v2 [\#480](https://github.com/apache/camel-kafka-connector/pull/480) ([orpiske](https://github.com/orpiske))
- Fix GH connection timeout issue [\#478](https://github.com/apache/camel-kafka-connector/pull/478) ([orpiske](https://github.com/orpiske))
- Fixes typos when an invalid instance type is provided [\#477](https://github.com/apache/camel-kafka-connector/pull/477) ([orpiske](https://github.com/orpiske))
- Implement the connection timeout work-around [\#476](https://github.com/apache/camel-kafka-connector/pull/476) ([orpiske](https://github.com/orpiske))
- Removed browse and class connector [\#475](https://github.com/apache/camel-kafka-connector/pull/475) ([oscerd](https://github.com/oscerd))
- Removed digitalocean connector [\#472](https://github.com/apache/camel-kafka-connector/pull/472) ([oscerd](https://github.com/oscerd))
- .asf.yaml: Enabled only rebase and squash button on PR [\#471](https://github.com/apache/camel-kafka-connector/pull/471) ([oscerd](https://github.com/oscerd))
- Replaced the use of kubectl with oc command. [\#468](https://github.com/apache/camel-kafka-connector/pull/468) ([valdar](https://github.com/valdar))
- Updated opesnhift documentation to strimzi 0.19.0 and compatible with… [\#467](https://github.com/apache/camel-kafka-connector/pull/467) ([valdar](https://github.com/valdar))
- Document update [\#464](https://github.com/apache/camel-kafka-connector/pull/464) ([NiteshKoushik](https://github.com/NiteshKoushik))
- Document Update [\#461](https://github.com/apache/camel-kafka-connector/pull/461) ([NiteshKoushik](https://github.com/NiteshKoushik))
- Document Update [\#460](https://github.com/apache/camel-kafka-connector/pull/460) ([NiteshKoushik](https://github.com/NiteshKoushik))
- Switch from Gitter to Zulip [\#459](https://github.com/apache/camel-kafka-connector/pull/459) ([lburgazzoli](https://github.com/lburgazzoli))
- Support for topics.regex [\#458](https://github.com/apache/camel-kafka-connector/pull/458) ([oscerd](https://github.com/oscerd))
- Added 0.5.0 to the compatibility matrix [\#453](https://github.com/apache/camel-kafka-connector/pull/453) ([oscerd](https://github.com/oscerd))
- 0.5.0 docs [\#452](https://github.com/apache/camel-kafka-connector/pull/452) ([oscerd](https://github.com/oscerd))
- Updated SQS example [\#450](https://github.com/apache/camel-kafka-connector/pull/450) ([oscerd](https://github.com/oscerd))
- Updated SQS example [\#449](https://github.com/apache/camel-kafka-connector/pull/449) ([oscerd](https://github.com/oscerd))
- Update AWS SNS example [\#448](https://github.com/apache/camel-kafka-connector/pull/448) ([oscerd](https://github.com/oscerd))
- Updated the AWS S3 example [\#447](https://github.com/apache/camel-kafka-connector/pull/447) ([oscerd](https://github.com/oscerd))
- Updated the Cassandra example [\#446](https://github.com/apache/camel-kafka-connector/pull/446) ([oscerd](https://github.com/oscerd))
- Cut down the connectors number [\#445](https://github.com/apache/camel-kafka-connector/pull/445) ([oscerd](https://github.com/oscerd))
- Transformers package renaming [\#444](https://github.com/apache/camel-kafka-connector/pull/444) ([oscerd](https://github.com/oscerd))
- Define a default naming for converters, transforms and aggregation packages [\#443](https://github.com/apache/camel-kafka-connector/pull/443) ([oscerd](https://github.com/oscerd))
- Remove useless connector [\#441](https://github.com/apache/camel-kafka-connector/pull/441) ([oscerd](https://github.com/oscerd))
- AWS SQS tests w/ SDK v2 [\#438](https://github.com/apache/camel-kafka-connector/pull/438) ([orpiske](https://github.com/orpiske))

## [camel-kafka-connector-0.4.4](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.4.4) (2020-10-10)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.5.0...camel-kafka-connector-0.4.4)

**Fixed bugs:**

- Azure blob sink does not put file in azure [\#270](https://github.com/apache/camel-kafka-connector/issues/270)

**Closed issues:**

- source: better handling of headers of type Data [\#544](https://github.com/apache/camel-kafka-connector/issues/544)
- Catalog: expose an API for consuming connectors catalog metadata and options [\#542](https://github.com/apache/camel-kafka-connector/issues/542)
- Catalog: Rename the json file to reflect the id and connectors.properties content [\#534](https://github.com/apache/camel-kafka-connector/issues/534)
- Add a Maven Plugin to collect the connector descriptors for catalog purpose [\#529](https://github.com/apache/camel-kafka-connector/issues/529)
- Create descriptors for source and sink connector for catalog purpose [\#523](https://github.com/apache/camel-kafka-connector/issues/523)
- Move model classes CamelKafkaConnectorModel and CamelKafkaConnectorOptionModel in their own module [\#515](https://github.com/apache/camel-kafka-connector/issues/515)
- Copy all Json connectors metadata into a camel-kafka-connector-catalog [\#514](https://github.com/apache/camel-kafka-connector/issues/514)
- Document build steps w/ mvnd [\#513](https://github.com/apache/camel-kafka-connector/issues/513)
- Generator a JSON metadata file for each connector [\#508](https://github.com/apache/camel-kafka-connector/issues/508)
- \[camel-main-support\] Use BaseMainSupport instead of Main [\#499](https://github.com/apache/camel-kafka-connector/issues/499)
- \[camel-main-support\] Reordering props should not be required anymore [\#498](https://github.com/apache/camel-kafka-connector/issues/498)
- Add an ASF deploy GH Action like other camel projects [\#492](https://github.com/apache/camel-kafka-connector/issues/492)
- MongoDB Kafka Connector: In the docs add Json as base value converter [\#490](https://github.com/apache/camel-kafka-connector/issues/490)
- Create an Infinispan example [\#486](https://github.com/apache/camel-kafka-connector/issues/486)
- Create Minio connector examples [\#456](https://github.com/apache/camel-kafka-connector/issues/456)
- Support topics.regex  [\#454](https://github.com/apache/camel-kafka-connector/issues/454)
- Define a default naming for converters, transforms and aggregation packages [\#439](https://github.com/apache/camel-kafka-connector/issues/439)
- High CPU Usage with RabbitMQ Connector \(polling interface implemented incorrectly?\) [\#414](https://github.com/apache/camel-kafka-connector/issues/414)
- How to have connector output JSON String? [\#398](https://github.com/apache/camel-kafka-connector/issues/398)
- Question: Does Camel looks for IAM roles from Env variables [\#282](https://github.com/apache/camel-kafka-connector/issues/282)

## [camel-kafka-connector-0.5.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.5.0) (2020-09-09)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.4.0...camel-kafka-connector-0.5.0)

**Implemented enhancements:**

- Add the connector class to use in the documentation of each connector [\#321](https://github.com/apache/camel-kafka-connector/issues/321)
- Support multiple topics for connector configuration [\#197](https://github.com/apache/camel-kafka-connector/issues/197)
- Generate a catalog of supported connectors [\#141](https://github.com/apache/camel-kafka-connector/issues/141)

**Fixed bugs:**

- flaky syslog integration test  [\#367](https://github.com/apache/camel-kafka-connector/issues/367)
- UnitOfWork.done\(\) needs to be called on Polled exchanges [\#202](https://github.com/apache/camel-kafka-connector/issues/202)

**Closed issues:**

- Unreleased Resource: Database [\#436](https://github.com/apache/camel-kafka-connector/issues/436)
- Create an NSQ example [\#429](https://github.com/apache/camel-kafka-connector/issues/429)
- Archetype: Add a parameter to the archetype generator to be able to specify what connector we want to extend [\#419](https://github.com/apache/camel-kafka-connector/issues/419)
- IMPROVEMENT REQUEST: Add a transformer mode to the connectors to make lightweight edits to the messages while they are being produced/consumed [\#410](https://github.com/apache/camel-kafka-connector/issues/410)
- aws2-S3-connector: \(gzip/zip\) compression with sink [\#387](https://github.com/apache/camel-kafka-connector/issues/387)
- Discussion: troubleshooting documentation? [\#381](https://github.com/apache/camel-kafka-connector/issues/381)
- Bump to Camel 3.4.3 [\#379](https://github.com/apache/camel-kafka-connector/issues/379)
- Documentation: SJMS2 connector is incompatible with activemq-all [\#378](https://github.com/apache/camel-kafka-connector/issues/378)
- Unclean startup causes an NPE on shutdown [\#376](https://github.com/apache/camel-kafka-connector/issues/376)
- Make the camel-kafka-connector archetype use the parent POM [\#362](https://github.com/apache/camel-kafka-connector/issues/362)
- Exception on endpoint being treated as a polling consumer before createPollingConsumer is called. [\#361](https://github.com/apache/camel-kafka-connector/issues/361)
- Add a Nats connector examples in camel-kafka-connector-examples repo [\#359](https://github.com/apache/camel-kafka-connector/issues/359)
- Add a compatibility matrix related to camel version in docs [\#344](https://github.com/apache/camel-kafka-connector/issues/344)
- aws2S3connector: moveAfterRead true bucket not created [\#339](https://github.com/apache/camel-kafka-connector/issues/339)
- CamelAwssqsSinkConnector does not work when specifying AWS credentials in camel.sink.endpoint [\#319](https://github.com/apache/camel-kafka-connector/issues/319)
- Create a Kinesis Firehose Connector example [\#318](https://github.com/apache/camel-kafka-connector/issues/318)
- Nullpointer exception at org.apache.camel.component.aws2.s3.AWS2S3Producer.processSingleOp [\#299](https://github.com/apache/camel-kafka-connector/issues/299)
- Add Aggregate integration test [\#291](https://github.com/apache/camel-kafka-connector/issues/291)
- Enable testRetrieveFromCassandraWithCustomStrategy on CamelSourceCassandraITCase [\#288](https://github.com/apache/camel-kafka-connector/issues/288)

**Merged pull requests:**

- Fix potentially unreleased DB resources in test code [\#437](https://github.com/apache/camel-kafka-connector/pull/437) ([orpiske](https://github.com/orpiske))
- Automatic changelog: Run it just one time during the night [\#435](https://github.com/apache/camel-kafka-connector/pull/435) ([oscerd](https://github.com/oscerd))
- Run the changelog automatic updated every hour [\#434](https://github.com/apache/camel-kafka-connector/pull/434) ([oscerd](https://github.com/oscerd))
- Update try-it-out-on-openshift-with-strimzi.adoc with latest AWS S3 connector config [\#433](https://github.com/apache/camel-kafka-connector/pull/433) ([smccarthy-ie](https://github.com/smccarthy-ie))
- Pr Build and push build needs to point to master [\#432](https://github.com/apache/camel-kafka-connector/pull/432) ([oscerd](https://github.com/oscerd))
- adding a key transformer to the AWS2-SQS connector so that the CamelH… [\#431](https://github.com/apache/camel-kafka-connector/pull/431) ([codexetreme](https://github.com/codexetreme))
- Proposed fix for issue \#414 [\#428](https://github.com/apache/camel-kafka-connector/pull/428) ([orpiske](https://github.com/orpiske))
- Camel 3.5.0 [\#427](https://github.com/apache/camel-kafka-connector/pull/427) ([oscerd](https://github.com/oscerd))
- Docs: Updated archetypes docs [\#422](https://github.com/apache/camel-kafka-connector/pull/422) ([oscerd](https://github.com/oscerd))
- Archetype: Add a parameter to the archetype generator to be able to s… [\#421](https://github.com/apache/camel-kafka-connector/pull/421) ([oscerd](https://github.com/oscerd))
- Fix a minor typo [\#420](https://github.com/apache/camel-kafka-connector/pull/420) ([oscerd](https://github.com/oscerd))
- Removed deploy phase from jenkinsfile, we already have the daily snap… [\#418](https://github.com/apache/camel-kafka-connector/pull/418) ([oscerd](https://github.com/oscerd))
- Remove deploy phase from Jenkinsfile, we have the daily snapshot depl… [\#417](https://github.com/apache/camel-kafka-connector/pull/417) ([oscerd](https://github.com/oscerd))
- \[Github Actions\] Periodic Sync Camel-kafka-connector camel-master Branch [\#416](https://github.com/apache/camel-kafka-connector/pull/416) ([github-actions[bot]](https://github.com/apps/github-actions))
- Activemq-all note for SJMS2 connector [\#415](https://github.com/apache/camel-kafka-connector/pull/415) ([oscerd](https://github.com/oscerd))
- Rework the testing documentation and adds test writing details [\#413](https://github.com/apache/camel-kafka-connector/pull/413) ([orpiske](https://github.com/orpiske))
- Added new test for Azure Storage Queue sink [\#412](https://github.com/apache/camel-kafka-connector/pull/412) ([orpiske](https://github.com/orpiske))
- Support Multiple topics on Source Connector [\#411](https://github.com/apache/camel-kafka-connector/pull/411) ([oscerd](https://github.com/oscerd))
- Added connector class on each connector documentation page [\#405](https://github.com/apache/camel-kafka-connector/pull/405) ([oscerd](https://github.com/oscerd))
- Added a pipeline for deploying on daily basis [\#404](https://github.com/apache/camel-kafka-connector/pull/404) ([oscerd](https://github.com/oscerd))
- \#389 - Fix doc- Kubernetes command [\#401](https://github.com/apache/camel-kafka-connector/pull/401) ([rogeriob2br](https://github.com/rogeriob2br))
- Fix mongodb test [\#396](https://github.com/apache/camel-kafka-connector/pull/396) ([unsortedhashsets](https://github.com/unsortedhashsets))
- Removed wrong terminal output from example in archetype docs [\#394](https://github.com/apache/camel-kafka-connector/pull/394) ([oscerd](https://github.com/oscerd))
- Kafka-clients is not a test dependency [\#393](https://github.com/apache/camel-kafka-connector/pull/393) ([oscerd](https://github.com/oscerd))
- Added automatic-sync gh action for camel-kafka-connector on camel-mas… [\#392](https://github.com/apache/camel-kafka-connector/pull/392) ([oscerd](https://github.com/oscerd))
- Adds basic aggregation test \(github issue \#291\) [\#388](https://github.com/apache/camel-kafka-connector/pull/388) ([orpiske](https://github.com/orpiske))
- Fix flaky syslog test [\#386](https://github.com/apache/camel-kafka-connector/pull/386) ([orpiske](https://github.com/orpiske))
- Added a simple troubleshooting guide [\#383](https://github.com/apache/camel-kafka-connector/pull/383) ([orpiske](https://github.com/orpiske))
- Upgrade to camel 3.4.3 [\#380](https://github.com/apache/camel-kafka-connector/pull/380) ([oscerd](https://github.com/oscerd))
- Prevent NPEs on shutdown when critical errors occur [\#377](https://github.com/apache/camel-kafka-connector/pull/377) ([orpiske](https://github.com/orpiske))
- Fixed incorrect number of log arguments in S3 exception handling [\#375](https://github.com/apache/camel-kafka-connector/pull/375) ([orpiske](https://github.com/orpiske))
- Defer topic deletion [\#374](https://github.com/apache/camel-kafka-connector/pull/374) ([orpiske](https://github.com/orpiske))
- Fixes for edge cases [\#373](https://github.com/apache/camel-kafka-connector/pull/373) ([orpiske](https://github.com/orpiske))
- Added missing fromUrl to the log message [\#372](https://github.com/apache/camel-kafka-connector/pull/372) ([orpiske](https://github.com/orpiske))
- Removes debugging message [\#370](https://github.com/apache/camel-kafka-connector/pull/370) ([orpiske](https://github.com/orpiske))
- Removing backport gh action. It doesn't work. [\#369](https://github.com/apache/camel-kafka-connector/pull/369) ([oscerd](https://github.com/oscerd))
- Minor AWS tests cleanups [\#368](https://github.com/apache/camel-kafka-connector/pull/368) ([orpiske](https://github.com/orpiske))
- Building endpoint uris should for secret options automatic use RAW\(\) … [\#366](https://github.com/apache/camel-kafka-connector/pull/366) ([davsclaus](https://github.com/davsclaus))
- Cutting down connectors [\#365](https://github.com/apache/camel-kafka-connector/pull/365) ([oscerd](https://github.com/oscerd))
- Make the camel-kafka-connector archetype use the parent POM [\#363](https://github.com/apache/camel-kafka-connector/pull/363) ([oscerd](https://github.com/oscerd))
- AWS SDK v2 integration tests: Kinesis [\#358](https://github.com/apache/camel-kafka-connector/pull/358) ([orpiske](https://github.com/orpiske))
- Use latest Strimzi's docker images [\#357](https://github.com/apache/camel-kafka-connector/pull/357) ([oscerd](https://github.com/oscerd))
- Fixed camel compatibility matrix table [\#356](https://github.com/apache/camel-kafka-connector/pull/356) ([oscerd](https://github.com/oscerd))
- Added a camel-compatibility matrix page [\#355](https://github.com/apache/camel-kafka-connector/pull/355) ([oscerd](https://github.com/oscerd))
- Upgrade Archetype docs [\#354](https://github.com/apache/camel-kafka-connector/pull/354) ([oscerd](https://github.com/oscerd))
- Fixed index adoc [\#352](https://github.com/apache/camel-kafka-connector/pull/352) ([oscerd](https://github.com/oscerd))
- Added missing connector in connectors pom [\#350](https://github.com/apache/camel-kafka-connector/pull/350) ([oscerd](https://github.com/oscerd))
- Release 0.4.0 [\#346](https://github.com/apache/camel-kafka-connector/pull/346) ([oscerd](https://github.com/oscerd))
- AWS Kinesis test fixes when in remote mode [\#345](https://github.com/apache/camel-kafka-connector/pull/345) ([orpiske](https://github.com/orpiske))
- Issue/194 [\#341](https://github.com/apache/camel-kafka-connector/pull/341) ([valdar](https://github.com/valdar))
- Re-enable a Cassandra test disabled due to CAMEL-15219 [\#337](https://github.com/apache/camel-kafka-connector/pull/337) ([orpiske](https://github.com/orpiske))
- Add CORE protocol support to SJMS2 connector [\#336](https://github.com/apache/camel-kafka-connector/pull/336) ([fvaleri](https://github.com/fvaleri))
- Document how to run camel-kafka-connector on Kubernetes. [\#335](https://github.com/apache/camel-kafka-connector/pull/335) ([fvaleri](https://github.com/fvaleri))
- Archetypes docs [\#334](https://github.com/apache/camel-kafka-connector/pull/334) ([oscerd](https://github.com/oscerd))
- Added Aggregation documentation [\#332](https://github.com/apache/camel-kafka-connector/pull/332) ([oscerd](https://github.com/oscerd))
- Introducing a camel-kafka-connector-extensible archetype for adding b… [\#330](https://github.com/apache/camel-kafka-connector/pull/330) ([oscerd](https://github.com/oscerd))
- Adds a new manual integration test for Slack source [\#328](https://github.com/apache/camel-kafka-connector/pull/328) ([orpiske](https://github.com/orpiske))
- Bump Camel to version 3.4.2 [\#327](https://github.com/apache/camel-kafka-connector/pull/327) ([oscerd](https://github.com/oscerd))
- Issue/325 [\#326](https://github.com/apache/camel-kafka-connector/pull/326) ([valdar](https://github.com/valdar))
- Added additional explanation about testing  [\#317](https://github.com/apache/camel-kafka-connector/pull/317) ([orpiske](https://github.com/orpiske))
- Added tests for JDBC sink [\#316](https://github.com/apache/camel-kafka-connector/pull/316) ([orpiske](https://github.com/orpiske))
- Reverts the work-around for CAMEL-15063 [\#312](https://github.com/apache/camel-kafka-connector/pull/312) ([orpiske](https://github.com/orpiske))
- Fix HDFS tests with Camel 3.4 \(related to issue \#263\) [\#309](https://github.com/apache/camel-kafka-connector/pull/309) ([orpiske](https://github.com/orpiske))
- Fixes AWS test cases when running with remote AWS services [\#308](https://github.com/apache/camel-kafka-connector/pull/308) ([orpiske](https://github.com/orpiske))
- Avoid logging the autoconfiguration summary from CamelMain [\#307](https://github.com/apache/camel-kafka-connector/pull/307) ([oscerd](https://github.com/oscerd))
- Upgrade Kafka to version 2.5.0 [\#306](https://github.com/apache/camel-kafka-connector/pull/306) ([oscerd](https://github.com/oscerd))
- Fix Typo in CamelTypeConverterTransform [\#304](https://github.com/apache/camel-kafka-connector/pull/304) ([oscerd](https://github.com/oscerd))
- Added Aggregation timeout [\#301](https://github.com/apache/camel-kafka-connector/pull/301) ([oscerd](https://github.com/oscerd))
- Fixes camel-dependencies to point to 3.4.0 [\#298](https://github.com/apache/camel-kafka-connector/pull/298) ([oscerd](https://github.com/oscerd))
- ToD support [\#296](https://github.com/apache/camel-kafka-connector/pull/296) ([oscerd](https://github.com/oscerd))
- Add tests for MongoDB [\#295](https://github.com/apache/camel-kafka-connector/pull/295) ([orpiske](https://github.com/orpiske))
- Temporarily disable HDFS tests due to issue \#263 [\#294](https://github.com/apache/camel-kafka-connector/pull/294) ([orpiske](https://github.com/orpiske))
- Bump to Camel 3.4.0 [\#293](https://github.com/apache/camel-kafka-connector/pull/293) ([oscerd](https://github.com/oscerd))
- Updated the packages docs page [\#292](https://github.com/apache/camel-kafka-connector/pull/292) ([oscerd](https://github.com/oscerd))
- Aggregate Support [\#289](https://github.com/apache/camel-kafka-connector/pull/289) ([oscerd](https://github.com/oscerd))
- Cassandra test improvements [\#286](https://github.com/apache/camel-kafka-connector/pull/286) ([orpiske](https://github.com/orpiske))
- Backport [\#285](https://github.com/apache/camel-kafka-connector/pull/285) ([oscerd](https://github.com/oscerd))
- Use release 0.3.0 as lastReleasedVersion [\#284](https://github.com/apache/camel-kafka-connector/pull/284) ([oscerd](https://github.com/oscerd))
- Fixed component exclusion in combination with filter [\#281](https://github.com/apache/camel-kafka-connector/pull/281) ([oscerd](https://github.com/oscerd))
- Component exclusion [\#278](https://github.com/apache/camel-kafka-connector/pull/278) ([oscerd](https://github.com/oscerd))
- Added tests for Camel HDFS Sink [\#277](https://github.com/apache/camel-kafka-connector/pull/277) ([orpiske](https://github.com/orpiske))
- Fix a javadoc issue. [\#276](https://github.com/apache/camel-kafka-connector/pull/276) ([valdar](https://github.com/valdar))
- fix \#259: Camel-elasticsearch-rest-kafka-connector throws java.lang.N… [\#275](https://github.com/apache/camel-kafka-connector/pull/275) ([valdar](https://github.com/valdar))
- Throw ConnectException due to failed exchanges [\#273](https://github.com/apache/camel-kafka-connector/pull/273) ([omarsmak](https://github.com/omarsmak))
- Issue/260 [\#272](https://github.com/apache/camel-kafka-connector/pull/272) ([valdar](https://github.com/valdar))
- Test modularization cleanups [\#271](https://github.com/apache/camel-kafka-connector/pull/271) ([orpiske](https://github.com/orpiske))
- AWS2-S3 connector: Added the same set of converters/transformers we h… [\#268](https://github.com/apache/camel-kafka-connector/pull/268) ([oscerd](https://github.com/oscerd))
- Docs download link [\#266](https://github.com/apache/camel-kafka-connector/pull/266) ([oscerd](https://github.com/oscerd))
- Add AMQP examples for source and sink [\#265](https://github.com/apache/camel-kafka-connector/pull/265) ([rgannu](https://github.com/rgannu))
- Split the tests in modules per service [\#262](https://github.com/apache/camel-kafka-connector/pull/262) ([orpiske](https://github.com/orpiske))
- chore\(pgp\): update pgp key for Nicola Ferraro [\#256](https://github.com/apache/camel-kafka-connector/pull/256) ([nicolaferraro](https://github.com/nicolaferraro))
- Updated try-it-out-on-openshift-with-strimzi.adoc [\#255](https://github.com/apache/camel-kafka-connector/pull/255) ([valdar](https://github.com/valdar))
- Adds integration tests for Salesforce [\#247](https://github.com/apache/camel-kafka-connector/pull/247) ([orpiske](https://github.com/orpiske))
- Fixed quickstarts docs [\#246](https://github.com/apache/camel-kafka-connector/pull/246) ([oscerd](https://github.com/oscerd))
- Sf fix [\#244](https://github.com/apache/camel-kafka-connector/pull/244) ([valdar](https://github.com/valdar))
- Use camel-depencencies to import versions of common libraries like Ja… [\#243](https://github.com/apache/camel-kafka-connector/pull/243) ([oscerd](https://github.com/oscerd))
- Fix CamelSinkAWSSQSITCase unreliability with blocking initialization [\#242](https://github.com/apache/camel-kafka-connector/pull/242) ([orpiske](https://github.com/orpiske))
- Bump Log4j to version 2.13.3 [\#240](https://github.com/apache/camel-kafka-connector/pull/240) ([oscerd](https://github.com/oscerd))
- Example prop autogen [\#239](https://github.com/apache/camel-kafka-connector/pull/239) ([valdar](https://github.com/valdar))
- Bump Jackson to version 2.10.4 [\#238](https://github.com/apache/camel-kafka-connector/pull/238) ([oscerd](https://github.com/oscerd))
- Bump Qpid JMS client to version 0.51.0 [\#237](https://github.com/apache/camel-kafka-connector/pull/237) ([oscerd](https://github.com/oscerd))
- Upgrade Strimzi images to 0.18.0-kafka-2.4.1 [\#236](https://github.com/apache/camel-kafka-connector/pull/236) ([oscerd](https://github.com/oscerd))
- CamelSinkTask Properties need to be cleaned up before going ahead [\#235](https://github.com/apache/camel-kafka-connector/pull/235) ([oscerd](https://github.com/oscerd))
- CamelSinkTask headers must be cleaned before sending them ahead [\#232](https://github.com/apache/camel-kafka-connector/pull/232) ([oscerd](https://github.com/oscerd))
- Bump to Camel 3.3.0 [\#231](https://github.com/apache/camel-kafka-connector/pull/231) ([oscerd](https://github.com/oscerd))
- Version bump to Camel 3.3.0 [\#230](https://github.com/apache/camel-kafka-connector/pull/230) ([orpiske](https://github.com/orpiske))
- Connectors doc generation shuld be moved from `core` to `connectors` … [\#229](https://github.com/apache/camel-kafka-connector/pull/229) ([oscerd](https://github.com/oscerd))
- Syslog docs [\#227](https://github.com/apache/camel-kafka-connector/pull/227) ([oscerd](https://github.com/oscerd))
- Fixed con cong autogen [\#222](https://github.com/apache/camel-kafka-connector/pull/222) ([valdar](https://github.com/valdar))
- Remove core from test plugin path [\#218](https://github.com/apache/camel-kafka-connector/pull/218) ([orpiske](https://github.com/orpiske))
- Sink test refactoring [\#216](https://github.com/apache/camel-kafka-connector/pull/216) ([fvaleri](https://github.com/fvaleri))
- Add contentLogLevel task property [\#193](https://github.com/apache/camel-kafka-connector/pull/193) ([fvaleri](https://github.com/fvaleri))

## [camel-kafka-connector-0.4.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.4.0) (2020-07-29)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.3.0...camel-kafka-connector-0.4.0)

**Implemented enhancements:**

- Being able to inject an aggregator in a sink connector [\#274](https://github.com/apache/camel-kafka-connector/issues/274)
- In case of Sink we need to use toD instead of to [\#252](https://github.com/apache/camel-kafka-connector/issues/252)
- Upgrade to Kafka 2.5.0 [\#249](https://github.com/apache/camel-kafka-connector/issues/249)
- Improve integration test support when component dependencies are present [\#211](https://github.com/apache/camel-kafka-connector/issues/211)
- Support both marshal and unmarshal in source and sinks [\#194](https://github.com/apache/camel-kafka-connector/issues/194)
- camel-kafka-connector-generator-maven-plugin: implement a component exclusion mechanism [\#148](https://github.com/apache/camel-kafka-connector/issues/148)

**Fixed bugs:**

- BigDecimal values are not handled correctly in Headers serialization and deserialization [\#325](https://github.com/apache/camel-kafka-connector/issues/325)
- Camel HDFS: does not work due to dependencies conflicts [\#263](https://github.com/apache/camel-kafka-connector/issues/263)
- NullPointerException during shutdown when using Salesforce component [\#245](https://github.com/apache/camel-kafka-connector/issues/245)

**Closed issues:**

- Camel-Elasticsearch Connector not working on OpenShift [\#342](https://github.com/apache/camel-kafka-connector/issues/342)
- aws2S3connector connected to minio ClassCastException [\#338](https://github.com/apache/camel-kafka-connector/issues/338)
- Add documentation for archetype [\#333](https://github.com/apache/camel-kafka-connector/issues/333)
- Add an archetype to be able to extend the existing connectors with converters/aggregators/transformations/pojo etc. [\#329](https://github.com/apache/camel-kafka-connector/issues/329)
- The committed block count cannot exceed the maximum limit of 50,000 blocks. [\#324](https://github.com/apache/camel-kafka-connector/issues/324)
- Upgrade to Camel 3.4.2 once released [\#322](https://github.com/apache/camel-kafka-connector/issues/322)
- CamelAwssqsSinkConnector is leaking AWS credentials into Kafka Connect log [\#320](https://github.com/apache/camel-kafka-connector/issues/320)
- How install camel-jira-kafka-connector [\#315](https://github.com/apache/camel-kafka-connector/issues/315)
- From S3 to kafka, when using Idempotent filter, Do we still fetch S3 file content ? [\#314](https://github.com/apache/camel-kafka-connector/issues/314)
- How to break messages when ingesting into kafka [\#313](https://github.com/apache/camel-kafka-connector/issues/313)
- In S3 source connector, how to fetch only new files ? [\#311](https://github.com/apache/camel-kafka-connector/issues/311)
- CAMEL-15063 work-around may be removed [\#310](https://github.com/apache/camel-kafka-connector/issues/310)
- Add an aggregation page in docs [\#303](https://github.com/apache/camel-kafka-connector/issues/303)
- Outdated camel-dependencies version? [\#297](https://github.com/apache/camel-kafka-connector/issues/297)
- Aggregator support for completionTimeout too [\#290](https://github.com/apache/camel-kafka-connector/issues/290)
- Upgrade to Camel 3.4.0 LTS version [\#283](https://github.com/apache/camel-kafka-connector/issues/283)
- Camel-MongoDB Kafka connector: example with sink connector [\#212](https://github.com/apache/camel-kafka-connector/issues/212)

## [camel-kafka-connector-0.3.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.3.0) (2020-06-17)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.2.0...camel-kafka-connector-0.3.0)

**Implemented enhancements:**

- Use camel-depencencies to import versions of common libraries like Jakson, qpid, log4j etc. [\#241](https://github.com/apache/camel-kafka-connector/issues/241)
- Autogenerate and example config file for each connector [\#220](https://github.com/apache/camel-kafka-connector/issues/220)
- S3 source connector delete files from source bucket [\#97](https://github.com/apache/camel-kafka-connector/issues/97)
-  Create example and itest for camel-syslog [\#77](https://github.com/apache/camel-kafka-connector/issues/77)

**Fixed bugs:**

- Camel-elasticsearch-rest-kafka-connector throws java.lang.NoClassDefFoundError: org/apache/logging/log4j/LogManager [\#259](https://github.com/apache/camel-kafka-connector/issues/259)
- Wrong signature of autogenerated method `public static ConfigDef conf(Map<String, String> parsedConfig)` of each `Camel*ConnectorConfig` [\#221](https://github.com/apache/camel-kafka-connector/issues/221)
- Possible problems in CamelSinkAWSSQSITCase tests [\#215](https://github.com/apache/camel-kafka-connector/issues/215)

**Closed issues:**

- Question: How to provide aws role:arn value to authenticate S3  [\#267](https://github.com/apache/camel-kafka-connector/issues/267)
- Add CamelAMQP source and sink example properties [\#264](https://github.com/apache/camel-kafka-connector/issues/264)
- Add download links to the connectors list page [\#261](https://github.com/apache/camel-kafka-connector/issues/261)
- AWS S3: bucket name not resolved when using URL configuration [\#260](https://github.com/apache/camel-kafka-connector/issues/260)
- Caused by: java.lang.NoClassDefFoundError: Could not initialize class org.apache.camel.kafkaconnector.CamelSinkConnectorConfig [\#251](https://github.com/apache/camel-kafka-connector/issues/251)
- Camel AWS2-S3: Add the same converters and transforms we have for AWS-S3 connector [\#250](https://github.com/apache/camel-kafka-connector/issues/250)
- pls  [\#248](https://github.com/apache/camel-kafka-connector/issues/248)
- Connectors doc generation shuld be moved from `core` to `connectors` module [\#226](https://github.com/apache/camel-kafka-connector/issues/226)
- Investigate why syslog documentation result in a missing link [\#225](https://github.com/apache/camel-kafka-connector/issues/225)
- CamelSinkTask Properties need to be cleaned up before going ahead [\#224](https://github.com/apache/camel-kafka-connector/issues/224)
- CamelSinkTask headers must be cleaned before sending them ahead [\#223](https://github.com/apache/camel-kafka-connector/issues/223)
- Updater the readme of autogenerated connectors doc page [\#219](https://github.com/apache/camel-kafka-connector/issues/219)
- Bump to Camel 3.3.0 [\#217](https://github.com/apache/camel-kafka-connector/issues/217)

## [camel-kafka-connector-0.2.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.2.0) (2020-05-17)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.1.0...camel-kafka-connector-0.2.0)

**Implemented enhancements:**

- Avoid Thread.sleep in test, use Awaitility FTW [\#186](https://github.com/apache/camel-kafka-connector/issues/186)
- make the topics property consistent between source and sink connectors [\#175](https://github.com/apache/camel-kafka-connector/issues/175)
- Produce an assembly artifact containing all the released artifacts [\#165](https://github.com/apache/camel-kafka-connector/issues/165)
- Create and ad hoc connector for syslog [\#145](https://github.com/apache/camel-kafka-connector/issues/145)
- Take in to account endpoint path options order into connector code generation [\#144](https://github.com/apache/camel-kafka-connector/issues/144)

**Fixed bugs:**

- Ordering of endpoint path options is not taken in account [\#143](https://github.com/apache/camel-kafka-connector/issues/143)

**Closed issues:**

- Add connector dependencies in distribution package [\#203](https://github.com/apache/camel-kafka-connector/issues/203)
- Switch to Camel 3.2.0 [\#199](https://github.com/apache/camel-kafka-connector/issues/199)
- Cannot apply transforms to Telegram Source Connector [\#188](https://github.com/apache/camel-kafka-connector/issues/188)
- Connectors doc: Show up only the priority in the table column [\#182](https://github.com/apache/camel-kafka-connector/issues/182)
- Add an index for connectors in docs [\#169](https://github.com/apache/camel-kafka-connector/issues/169)
- Autogenerate documentation for sink and source connectors [\#167](https://github.com/apache/camel-kafka-connector/issues/167)
- Provided dependencies management [\#158](https://github.com/apache/camel-kafka-connector/issues/158)
- Checkstyle missing unused imports? [\#156](https://github.com/apache/camel-kafka-connector/issues/156)
- Generate a table with supported connectors [\#142](https://github.com/apache/camel-kafka-connector/issues/142)
- Test coverage: springboot autoconfigurations vs kafka-connect configuration format [\#132](https://github.com/apache/camel-kafka-connector/issues/132)
- Release 0.1.0 [\#130](https://github.com/apache/camel-kafka-connector/issues/130)

**Merged pull requests:**

- Syslog connector [\#214](https://github.com/apache/camel-kafka-connector/pull/214) ([valdar](https://github.com/valdar))
- Bump Testcontainers to version 1.14.2 [\#213](https://github.com/apache/camel-kafka-connector/pull/213) ([oscerd](https://github.com/oscerd))
- Removes usage of fixed hostnames in integration tests [\#210](https://github.com/apache/camel-kafka-connector/pull/210) ([orpiske](https://github.com/orpiske))
- Grammar fixes in basic concepts adoc [\#209](https://github.com/apache/camel-kafka-connector/pull/209) ([oscerd](https://github.com/oscerd))
- chore: rename poorly named variable in test code [\#208](https://github.com/apache/camel-kafka-connector/pull/208) ([orpiske](https://github.com/orpiske))
- Re-enable Cassandra test using properties [\#207](https://github.com/apache/camel-kafka-connector/pull/207) ([orpiske](https://github.com/orpiske))
- Bump to Camel 3.2.0 [\#206](https://github.com/apache/camel-kafka-connector/pull/206) ([oscerd](https://github.com/oscerd))
- Improved CamelSourceTaskTest [\#205](https://github.com/apache/camel-kafka-connector/pull/205) ([fvaleri](https://github.com/fvaleri))
- Removed Thread.seep\(...\) in unit tests in order to avoid possible sou… [\#204](https://github.com/apache/camel-kafka-connector/pull/204) ([valdar](https://github.com/valdar))
- Flakey tests [\#200](https://github.com/apache/camel-kafka-connector/pull/200) ([valdar](https://github.com/valdar))
- Generate a table with supported connectors [\#198](https://github.com/apache/camel-kafka-connector/pull/198) ([oscerd](https://github.com/oscerd))
- Make the topics property consistent between source and sink connectors [\#196](https://github.com/apache/camel-kafka-connector/pull/196) ([oscerd](https://github.com/oscerd))
- Produce an assembly artifact containing all the released artifacts [\#195](https://github.com/apache/camel-kafka-connector/pull/195) ([oscerd](https://github.com/oscerd))
- Switched to use RuntimeCatalog.asEndpointUri method to construct the … [\#192](https://github.com/apache/camel-kafka-connector/pull/192) ([valdar](https://github.com/valdar))
- Connectors doc: Show up only the priority in the table column [\#190](https://github.com/apache/camel-kafka-connector/pull/190) ([oscerd](https://github.com/oscerd))
- Added test on different component properties formats fix \#132 [\#187](https://github.com/apache/camel-kafka-connector/pull/187) ([valdar](https://github.com/valdar))
- Code cleanup [\#184](https://github.com/apache/camel-kafka-connector/pull/184) ([fvaleri](https://github.com/fvaleri))
- Lets try to use a shortname of 50 for connectors options [\#181](https://github.com/apache/camel-kafka-connector/pull/181) ([oscerd](https://github.com/oscerd))
- Camel-kafka-generator-maven-plugin: Use the Strings class from toolin… [\#180](https://github.com/apache/camel-kafka-connector/pull/180) ([oscerd](https://github.com/oscerd))
- Introduce the shortName method for option name [\#179](https://github.com/apache/camel-kafka-connector/pull/179) ([oscerd](https://github.com/oscerd))
- Added a little example of AWS-S3 source connector [\#177](https://github.com/apache/camel-kafka-connector/pull/177) ([oscerd](https://github.com/oscerd))
- Docs generation now contains also the number of options available per connectors [\#176](https://github.com/apache/camel-kafka-connector/pull/176) ([oscerd](https://github.com/oscerd))
- Adds a manual test for the Camel Slack sink connector [\#174](https://github.com/apache/camel-kafka-connector/pull/174) ([orpiske](https://github.com/orpiske))
- Special case for coap+tcp and coaps+tcp [\#173](https://github.com/apache/camel-kafka-connector/pull/173) ([oscerd](https://github.com/oscerd))
- Regen docs [\#172](https://github.com/apache/camel-kafka-connector/pull/172) ([oscerd](https://github.com/oscerd))
- Regen docs pages by adding title, so Antora will be happy [\#171](https://github.com/apache/camel-kafka-connector/pull/171) ([oscerd](https://github.com/oscerd))
- Add an index for docs [\#170](https://github.com/apache/camel-kafka-connector/pull/170) ([oscerd](https://github.com/oscerd))
- Docs sink source [\#168](https://github.com/apache/camel-kafka-connector/pull/168) ([oscerd](https://github.com/oscerd))
- Pom fixes [\#161](https://github.com/apache/camel-kafka-connector/pull/161) ([valdar](https://github.com/valdar))
- Added a building section in the docs [\#160](https://github.com/apache/camel-kafka-connector/pull/160) ([oscerd](https://github.com/oscerd))
- Fixes a couple of style violations and warnings on test code [\#157](https://github.com/apache/camel-kafka-connector/pull/157) ([orpiske](https://github.com/orpiske))
- Additional tests for different configuration styles [\#155](https://github.com/apache/camel-kafka-connector/pull/155) ([orpiske](https://github.com/orpiske))
- Release0.1.0 [\#154](https://github.com/apache/camel-kafka-connector/pull/154) ([valdar](https://github.com/valdar))
- Fixed github action issue with never released builts. [\#153](https://github.com/apache/camel-kafka-connector/pull/153) ([valdar](https://github.com/valdar))
- Upgrade testcontainers to version 1.14.1 [\#152](https://github.com/apache/camel-kafka-connector/pull/152) ([oscerd](https://github.com/oscerd))
- Moved from camel-core to camel-core-engine as a dependecnies. [\#140](https://github.com/apache/camel-kafka-connector/pull/140) ([valdar](https://github.com/valdar))
- Added gpg key for valdar. [\#139](https://github.com/apache/camel-kafka-connector/pull/139) ([valdar](https://github.com/valdar))
- Test code fixes for the auto-generated connectors [\#138](https://github.com/apache/camel-kafka-connector/pull/138) ([orpiske](https://github.com/orpiske))
- Misc [\#133](https://github.com/apache/camel-kafka-connector/pull/133) ([valdar](https://github.com/valdar))
- Packaging the connectors as zip and tar.gz [\#131](https://github.com/apache/camel-kafka-connector/pull/131) ([oscerd](https://github.com/oscerd))
- Auto gen [\#129](https://github.com/apache/camel-kafka-connector/pull/129) ([valdar](https://github.com/valdar))
- Upgrade Testcontainers to version 1.14.0 [\#126](https://github.com/apache/camel-kafka-connector/pull/126) ([oscerd](https://github.com/oscerd))
- Upgrade Junit Jupiter to version 5.6.2 [\#125](https://github.com/apache/camel-kafka-connector/pull/125) ([oscerd](https://github.com/oscerd))
- Replaces our own connect runtime implementation with the embedded one from Kafka [\#124](https://github.com/apache/camel-kafka-connector/pull/124) ([orpiske](https://github.com/orpiske))
- Removed unused class HTTPEchoService [\#123](https://github.com/apache/camel-kafka-connector/pull/123) ([orpiske](https://github.com/orpiske))
- Fixes a misplaced log error message flooding the logs w/ invalid errors [\#122](https://github.com/apache/camel-kafka-connector/pull/122) ([orpiske](https://github.com/orpiske))
- Sidebar menu Tidy up name -issue 14567 [\#121](https://github.com/apache/camel-kafka-connector/pull/121) ([rimshach](https://github.com/rimshach))
- Bump Qpid JMS to version 0.50.0 [\#119](https://github.com/apache/camel-kafka-connector/pull/119) ([oscerd](https://github.com/oscerd))
- Improve documentation for the about section [\#116](https://github.com/apache/camel-kafka-connector/pull/116) ([AemieJ](https://github.com/AemieJ))
- Binded itests to test phase to better accommodate github actions disk… [\#115](https://github.com/apache/camel-kafka-connector/pull/115) ([valdar](https://github.com/valdar))
- Auto gen [\#114](https://github.com/apache/camel-kafka-connector/pull/114) ([valdar](https://github.com/valdar))
- Added a Jenkinsfile for JDK11 [\#113](https://github.com/apache/camel-kafka-connector/pull/113) ([oscerd](https://github.com/oscerd))
- Added a Jenkinsfile for JDK8 and being able to deploy automatically [\#112](https://github.com/apache/camel-kafka-connector/pull/112) ([oscerd](https://github.com/oscerd))
- Pointing to ASF Snapshot and use the apache Parent [\#111](https://github.com/apache/camel-kafka-connector/pull/111) ([oscerd](https://github.com/oscerd))
- Bump Junit Jupiter to version 5.6.1 [\#110](https://github.com/apache/camel-kafka-connector/pull/110) ([oscerd](https://github.com/oscerd))
- Bump ActiveMQ to version 5.15.12 [\#109](https://github.com/apache/camel-kafka-connector/pull/109) ([oscerd](https://github.com/oscerd))
- Avoid building all the code for sourcecheck verification [\#108](https://github.com/apache/camel-kafka-connector/pull/108) ([orpiske](https://github.com/orpiske))
- Added support for remote AWS testing [\#107](https://github.com/apache/camel-kafka-connector/pull/107) ([orpiske](https://github.com/orpiske))
- Upgrade Kafka to version 2.4.1 - fixes \#105 [\#106](https://github.com/apache/camel-kafka-connector/pull/106) ([oscerd](https://github.com/oscerd))
- Upgrade Jackson to version 2.10.3 [\#103](https://github.com/apache/camel-kafka-connector/pull/103) ([oscerd](https://github.com/oscerd))
- Auto gen step 2: generated connectors structure and dependencies. [\#102](https://github.com/apache/camel-kafka-connector/pull/102) ([valdar](https://github.com/valdar))
- Ensure that local containers used during tests are properly shutdown after the test is completed [\#101](https://github.com/apache/camel-kafka-connector/pull/101) ([orpiske](https://github.com/orpiske))
- Upgrade test containers [\#100](https://github.com/apache/camel-kafka-connector/pull/100) ([orpiske](https://github.com/orpiske))
- Bump to Camel 3.1.0 [\#99](https://github.com/apache/camel-kafka-connector/pull/99) ([oscerd](https://github.com/oscerd))
- Little updates to docs [\#98](https://github.com/apache/camel-kafka-connector/pull/98) ([oscerd](https://github.com/oscerd))
- Fix missing licenses [\#94](https://github.com/apache/camel-kafka-connector/pull/94) ([orpiske](https://github.com/orpiske))
- Adds support for running tests against external ElasticSearch instances [\#93](https://github.com/apache/camel-kafka-connector/pull/93) ([orpiske](https://github.com/orpiske))
- Adds support for running tests against external Cassandra instances [\#92](https://github.com/apache/camel-kafka-connector/pull/92) ([orpiske](https://github.com/orpiske))
- Small adjustment to sourcechecks. [\#91](https://github.com/apache/camel-kafka-connector/pull/91) ([valdar](https://github.com/valdar))
- Fixed README.adoc links after Antora init. [\#90](https://github.com/apache/camel-kafka-connector/pull/90) ([valdar](https://github.com/valdar))
- fix\(docs\): replace anchor syntax for placeholder [\#89](https://github.com/apache/camel-kafka-connector/pull/89) ([zregvart](https://github.com/zregvart))
- chore\(docs\): cleanup wording and syntax [\#88](https://github.com/apache/camel-kafka-connector/pull/88) ([zregvart](https://github.com/zregvart))
- feat\(docs\): setup Antora [\#87](https://github.com/apache/camel-kafka-connector/pull/87) ([zregvart](https://github.com/zregvart))
- \[SECURITY\] Use HTTPS to resolve dependencies in Maven Build [\#86](https://github.com/apache/camel-kafka-connector/pull/86) ([JLLeitschuh](https://github.com/JLLeitschuh))
- First step for issue \#15 [\#85](https://github.com/apache/camel-kafka-connector/pull/85) ([valdar](https://github.com/valdar))
- Upgrade Qpid JMS client to version 0.48.0 [\#84](https://github.com/apache/camel-kafka-connector/pull/84) ([oscerd](https://github.com/oscerd))
- Added support for using an external JMS broker [\#83](https://github.com/apache/camel-kafka-connector/pull/83) ([orpiske](https://github.com/orpiske))
- Added support for loading test properties from a properties file [\#82](https://github.com/apache/camel-kafka-connector/pull/82) ([orpiske](https://github.com/orpiske))
- Bump TestContainers to version 1.12.5 [\#81](https://github.com/apache/camel-kafka-connector/pull/81) ([oscerd](https://github.com/oscerd))
- Bump to Camel 3.0.1 [\#80](https://github.com/apache/camel-kafka-connector/pull/80) ([oscerd](https://github.com/oscerd))
- Upgrade Junit to version 5.6.0 [\#79](https://github.com/apache/camel-kafka-connector/pull/79) ([oscerd](https://github.com/oscerd))
- Upgrade strimzi images to the latest version [\#78](https://github.com/apache/camel-kafka-connector/pull/78) ([orpiske](https://github.com/orpiske))
- Migrates all the test cases to Junit 5 [\#75](https://github.com/apache/camel-kafka-connector/pull/75) ([orpiske](https://github.com/orpiske))
- Added sourcecheck to github actions, added master push github action … [\#73](https://github.com/apache/camel-kafka-connector/pull/73) ([valdar](https://github.com/valdar))
- Updated integration test image to kafka 2.4 [\#72](https://github.com/apache/camel-kafka-connector/pull/72) ([valdar](https://github.com/valdar))
- Fix issue \#67: Flaky test: CamelSinkCassandraITCase [\#71](https://github.com/apache/camel-kafka-connector/pull/71) ([orpiske](https://github.com/orpiske))
- Bump Kafka to version 2.4.0 [\#70](https://github.com/apache/camel-kafka-connector/pull/70) ([oscerd](https://github.com/oscerd))
- Upgrade ActiveMQ to version 5.15.11 [\#68](https://github.com/apache/camel-kafka-connector/pull/68) ([oscerd](https://github.com/oscerd))
- Added support for testing the Kafka service using Strimzi [\#66](https://github.com/apache/camel-kafka-connector/pull/66) ([valdar](https://github.com/valdar))
- Auto gen [\#65](https://github.com/apache/camel-kafka-connector/pull/65) ([valdar](https://github.com/valdar))
- Add integration test for Cassandra CQL [\#64](https://github.com/apache/camel-kafka-connector/pull/64) ([orpiske](https://github.com/orpiske))
- Bump Jackson to version 2.10.2 [\#63](https://github.com/apache/camel-kafka-connector/pull/63) ([oscerd](https://github.com/oscerd))
- Use artifactId instead of project.name to build colon-less distro paths [\#62](https://github.com/apache/camel-kafka-connector/pull/62) ([ppalaga](https://github.com/ppalaga))
- Bump Junit to version 4.13 [\#61](https://github.com/apache/camel-kafka-connector/pull/61) ([oscerd](https://github.com/oscerd))
- Should use year instead of week year [\#60](https://github.com/apache/camel-kafka-connector/pull/60) ([orpiske](https://github.com/orpiske))
- Property placeholders [\#59](https://github.com/apache/camel-kafka-connector/pull/59) ([oscerd](https://github.com/oscerd))
- Relaxing condition to accomodate some timeout glitches, fix \#55 [\#58](https://github.com/apache/camel-kafka-connector/pull/58) ([valdar](https://github.com/valdar))
- Convert the embeddable Kafka Connect runner to a JUnit rule [\#57](https://github.com/apache/camel-kafka-connector/pull/57) ([orpiske](https://github.com/orpiske))
- Stop removing JMS-related containers after they are built [\#56](https://github.com/apache/camel-kafka-connector/pull/56) ([orpiske](https://github.com/orpiske))
- Upgrade test containers to the latest version [\#54](https://github.com/apache/camel-kafka-connector/pull/54) ([orpiske](https://github.com/orpiske))
- Fixes [\#52](https://github.com/apache/camel-kafka-connector/pull/52) ([valdar](https://github.com/valdar))
- Rearrange date and time [\#51](https://github.com/apache/camel-kafka-connector/pull/51) ([omarsmak](https://github.com/omarsmak))
- Fixed missing license [\#50](https://github.com/apache/camel-kafka-connector/pull/50) ([orpiske](https://github.com/orpiske))
- fix checkstyle violation [\#49](https://github.com/apache/camel-kafka-connector/pull/49) ([omarsmak](https://github.com/omarsmak))
- Add checkstyle profile  [\#48](https://github.com/apache/camel-kafka-connector/pull/48) ([omarsmak](https://github.com/omarsmak))
- CassandraQL sink connector example [\#47](https://github.com/apache/camel-kafka-connector/pull/47) ([oscerd](https://github.com/oscerd))
- Cassandraql source example [\#46](https://github.com/apache/camel-kafka-connector/pull/46) ([oscerd](https://github.com/oscerd))
- Added a gitter badge for our chat [\#45](https://github.com/apache/camel-kafka-connector/pull/45) ([oscerd](https://github.com/oscerd))
- Fix Kafka instance type should read from the property not from the system env [\#42](https://github.com/apache/camel-kafka-connector/pull/42) ([orpiske](https://github.com/orpiske))
- Adds an example configuration for ElasticSearch Index [\#41](https://github.com/apache/camel-kafka-connector/pull/41) ([orpiske](https://github.com/orpiske))
- Allow to configure a source record key from camel message header key [\#39](https://github.com/apache/camel-kafka-connector/pull/39) ([omarsmak](https://github.com/omarsmak))
- Replaces artemis with qpid-dispatch router [\#38](https://github.com/apache/camel-kafka-connector/pull/38) ([orpiske](https://github.com/orpiske))
- Infer the suitable schema in the SourceTask [\#37](https://github.com/apache/camel-kafka-connector/pull/37) ([omarsmak](https://github.com/omarsmak))
- Adds support for ElasticSearch index operation + tests [\#36](https://github.com/apache/camel-kafka-connector/pull/36) ([orpiske](https://github.com/orpiske))
- Support camel type converter [\#34](https://github.com/apache/camel-kafka-connector/pull/34) ([omarsmak](https://github.com/omarsmak))
- Send S3ObjectSerializer I/O error to the LOG instead of stdout [\#33](https://github.com/apache/camel-kafka-connector/pull/33) ([orpiske](https://github.com/orpiske))
- Support using an external Kafka for the tests [\#29](https://github.com/apache/camel-kafka-connector/pull/29) ([orpiske](https://github.com/orpiske))
- Camel-AWS S3 example: Use a Transformation instead of a converter [\#28](https://github.com/apache/camel-kafka-connector/pull/28) ([oscerd](https://github.com/oscerd))
- Map list as headers [\#26](https://github.com/apache/camel-kafka-connector/pull/26) ([oscerd](https://github.com/oscerd))
- Setting up POM as ASF standard [\#14](https://github.com/apache/camel-kafka-connector/pull/14) ([oscerd](https://github.com/oscerd))
- Reduce log default log verbosity [\#12](https://github.com/apache/camel-kafka-connector/pull/12) ([orpiske](https://github.com/orpiske))
- Cleanup the AWS SQS Sink test [\#11](https://github.com/apache/camel-kafka-connector/pull/11) ([orpiske](https://github.com/orpiske))
- Mark camel components as provided dependencies [\#10](https://github.com/apache/camel-kafka-connector/pull/10) ([jerrinot](https://github.com/jerrinot))
- Added release profile for the beginning [\#8](https://github.com/apache/camel-kafka-connector/pull/8) ([oscerd](https://github.com/oscerd))
- Fix Sink File test [\#6](https://github.com/apache/camel-kafka-connector/pull/6) ([orpiske](https://github.com/orpiske))
- chore: update maven to v3.6.3 [\#5](https://github.com/apache/camel-kafka-connector/pull/5) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(build\): set up github actions [\#4](https://github.com/apache/camel-kafka-connector/pull/4) ([lburgazzoli](https://github.com/lburgazzoli))
- Adding Keys, Notice and License files [\#3](https://github.com/apache/camel-kafka-connector/pull/3) ([oscerd](https://github.com/oscerd))
- First commit [\#1](https://github.com/apache/camel-kafka-connector/pull/1) ([oscerd](https://github.com/oscerd))

## [camel-kafka-connector-0.1.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.1.0) (2020-04-25)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/190bc368d41fda51a7693c91b1150aac377b79d5...camel-kafka-connector-0.1.0)

**Implemented enhancements:**

- Migrating to Junit 5 [\#74](https://github.com/apache/camel-kafka-connector/issues/74)
- Replace `confluentinc/cp-kafka` image with an upstream version [\#43](https://github.com/apache/camel-kafka-connector/issues/43)
- Test code cleanups: embedded connect runtime improvements [\#24](https://github.com/apache/camel-kafka-connector/issues/24)
- Add a CI job for PR [\#19](https://github.com/apache/camel-kafka-connector/issues/19)
- Support Map and List as Headers [\#18](https://github.com/apache/camel-kafka-connector/issues/18)
- Find a way to manage dependencies [\#15](https://github.com/apache/camel-kafka-connector/issues/15)
- Unclean shutdown causing lots of warning messages in the logs [\#13](https://github.com/apache/camel-kafka-connector/issues/13)

**Fixed bugs:**

- Unable to initialize REST resources in tests [\#120](https://github.com/apache/camel-kafka-connector/issues/120)
- ERROR - Plugin class loader for connector: was not found. [\#118](https://github.com/apache/camel-kafka-connector/issues/118)
- Flaky test: CamelSinkCassandraITCase [\#67](https://github.com/apache/camel-kafka-connector/issues/67)
- Integrations tests fails if confluentinc/cp-kafka:5.2.1 has not been pulled [\#25](https://github.com/apache/camel-kafka-connector/issues/25)

**Closed issues:**

- Create a documentation index and reflect it on the website [\#136](https://github.com/apache/camel-kafka-connector/issues/136)
- Documentation: Add instructions on how to use the packaged connectors in Kafka Connect [\#134](https://github.com/apache/camel-kafka-connector/issues/134)
- Generate documentation to be integrated with Antora and camel website [\#128](https://github.com/apache/camel-kafka-connector/issues/128)
- Define how to package the connectors  [\#127](https://github.com/apache/camel-kafka-connector/issues/127)
- Upgrade to Kafka 2.4.1 [\#105](https://github.com/apache/camel-kafka-connector/issues/105)
- Not able to add resource file [\#104](https://github.com/apache/camel-kafka-connector/issues/104)
- Not able to run aws s3 source connector  [\#95](https://github.com/apache/camel-kafka-connector/issues/95)
- Bump Kafka to version 2.4.0 [\#69](https://github.com/apache/camel-kafka-connector/issues/69)
- Unstable test: CamelSourceTaskTest.testSourcePollingTimeout [\#55](https://github.com/apache/camel-kafka-connector/issues/55)
- Add a sink and sources examples with camel-cassandraql [\#35](https://github.com/apache/camel-kafka-connector/issues/35)
- Better support for value Schema in the SourceTask [\#32](https://github.com/apache/camel-kafka-connector/issues/32)
- run integration test insided github actions? [\#31](https://github.com/apache/camel-kafka-connector/issues/31)
- INFRA - Turn off mail noise to Camel @dev mailing list [\#30](https://github.com/apache/camel-kafka-connector/issues/30)
- Allow the user to set the key of the SourceRecord explicitly [\#20](https://github.com/apache/camel-kafka-connector/issues/20)
- support camel type converters [\#16](https://github.com/apache/camel-kafka-connector/issues/16)
- The camel-kafka-connector artifacts pulls number of dependencies [\#9](https://github.com/apache/camel-kafka-connector/issues/9)
- Add Release profile [\#7](https://github.com/apache/camel-kafka-connector/issues/7)



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
