/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.sjms2;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelSjms2SourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_SJMS2_PATH_DESTINATION_TYPE_CONF = "camel.source.path.destinationType";
    public static final String CAMEL_SOURCE_SJMS2_PATH_DESTINATION_TYPE_DOC = "The kind of destination to use One of: [queue] [topic]";
    public static final String CAMEL_SOURCE_SJMS2_PATH_DESTINATION_TYPE_DEFAULT = "queue";
    public static final String CAMEL_SOURCE_SJMS2_PATH_DESTINATION_NAME_CONF = "camel.source.path.destinationName";
    public static final String CAMEL_SOURCE_SJMS2_PATH_DESTINATION_NAME_DOC = "DestinationName is a JMS queue or topic name. By default, the destinationName is interpreted as a queue name.";
    public static final String CAMEL_SOURCE_SJMS2_PATH_DESTINATION_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_ACKNOWLEDGEMENT_MODE_CONF = "camel.source.endpoint.acknowledgementMode";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_ACKNOWLEDGEMENT_MODE_DOC = "The JMS acknowledgement name, which is one of: SESSION_TRANSACTED, CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE One of: [SESSION_TRANSACTED] [CLIENT_ACKNOWLEDGE] [AUTO_ACKNOWLEDGE] [DUPS_OK_ACKNOWLEDGE]";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_ACKNOWLEDGEMENT_MODE_DEFAULT = "AUTO_ACKNOWLEDGE";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_CONNECTION_FACTORY_CONF = "camel.source.endpoint.connectionFactory";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_CONNECTION_FACTORY_DOC = "The connection factory to be use. A connection factory must be configured either on the component or endpoint.";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_CONNECTION_FACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_DISABLE_REPLY_TO_CONF = "camel.source.endpoint.disableReplyTo";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_DISABLE_REPLY_TO_DOC = "Specifies whether Camel ignores the JMSReplyTo header in messages. If true, Camel does not send a reply back to the destination specified in the JMSReplyTo header. You can use this option if you want Camel to consume from a route and you do not want Camel to automatically send back a reply message because another component in your code handles the reply message. You can also use this option if you want to use Camel as a proxy between different message brokers and you want to route message from one system to another.";
    public static final Boolean CAMEL_SOURCE_SJMS2_ENDPOINT_DISABLE_REPLY_TO_DEFAULT = false;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_CONF = "camel.source.endpoint.replyTo";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_DOC = "Provides an explicit ReplyTo destination (overrides any incoming value of Message.getJMSReplyTo() in consumer).";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_TEST_CONNECTION_ON_STARTUP_CONF = "camel.source.endpoint.testConnectionOnStartup";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_TEST_CONNECTION_ON_STARTUP_DOC = "Specifies whether to test the connection on startup. This ensures that when Camel starts that all the JMS consumers have a valid connection to the JMS broker. If a connection cannot be granted then Camel throws an exception on startup. This ensures that Camel is not started with failed connections. The JMS producers is tested as well.";
    public static final Boolean CAMEL_SOURCE_SJMS2_ENDPOINT_TEST_CONNECTION_ON_STARTUP_DEFAULT = false;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_CONSUMER_CONF = "camel.source.endpoint.asyncConsumer";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_CONSUMER_DOC = "Whether the JmsConsumer processes the Exchange asynchronously. If enabled then the JmsConsumer may pickup the next message from the JMS queue, while the previous message is being processed asynchronously (by the Asynchronous Routing Engine). This means that messages may be processed not 100% strictly in order. If disabled (as default) then the Exchange is fully processed before the JmsConsumer will pickup the next message from the JMS queue. Note if transacted has been enabled, then asyncConsumer=true does not run asynchronously, as transaction must be executed synchronously (Camel 3.0 may support async transactions).";
    public static final Boolean CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_CONSUMER_DEFAULT = false;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_AUTO_STARTUP_CONF = "camel.source.endpoint.autoStartup";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_AUTO_STARTUP_DOC = "Specifies whether the consumer container should auto-startup.";
    public static final Boolean CAMEL_SOURCE_SJMS2_ENDPOINT_AUTO_STARTUP_DEFAULT = true;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_SJMS2_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_CLIENT_ID_CONF = "camel.source.endpoint.clientId";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_CLIENT_ID_DOC = "Sets the JMS client ID to use. Note that this value, if specified, must be unique and can only be used by a single JMS connection instance. It is typically only required for durable topic subscriptions. If using Apache ActiveMQ you may prefer to use Virtual Topics instead.";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_CLIENT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_CONCURRENT_CONSUMERS_CONF = "camel.source.endpoint.concurrentConsumers";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_CONCURRENT_CONSUMERS_DOC = "Specifies the default number of concurrent consumers when consuming from JMS (not for request/reply over JMS). See also the maxMessagesPerTask option to control dynamic scaling up/down of threads. When doing request/reply over JMS then the option replyToConcurrentConsumers is used to control number of concurrent consumers on the reply message listener.";
    public static final Integer CAMEL_SOURCE_SJMS2_ENDPOINT_CONCURRENT_CONSUMERS_DEFAULT = 1;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_DURABLE_CONF = "camel.source.endpoint.durable";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_DURABLE_DOC = "Sets topic consumer to durable.";
    public static final Boolean CAMEL_SOURCE_SJMS2_ENDPOINT_DURABLE_DEFAULT = false;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_DURABLE_SUBSCRIPTION_NAME_CONF = "camel.source.endpoint.durableSubscriptionName";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_DURABLE_SUBSCRIPTION_NAME_DOC = "The durable subscriber name for specifying durable topic subscriptions. The clientId option must be configured as well.";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_DURABLE_SUBSCRIPTION_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_DELIVERY_PERSISTENT_CONF = "camel.source.endpoint.replyToDeliveryPersistent";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_DELIVERY_PERSISTENT_DOC = "Specifies whether to use persistent delivery by default for replies.";
    public static final Boolean CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_DELIVERY_PERSISTENT_DEFAULT = true;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_SHARED_CONF = "camel.source.endpoint.shared";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_SHARED_DOC = "Sets the consumer to shared.";
    public static final Boolean CAMEL_SOURCE_SJMS2_ENDPOINT_SHARED_DEFAULT = false;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_SUBSCRIPTION_ID_CONF = "camel.source.endpoint.subscriptionId";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_SUBSCRIPTION_ID_DOC = "Sets the subscription Id, required for durable or shared topics.";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_SUBSCRIPTION_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_EAGER_LOADING_OF_PROPERTIES_CONF = "camel.source.endpoint.eagerLoadingOfProperties";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_EAGER_LOADING_OF_PROPERTIES_DOC = "Enables eager loading of JMS properties and payload as soon as a message is loaded which generally is inefficient as the JMS properties may not be required but sometimes can catch early any issues with the underlying JMS provider and the use of JMS properties. See also the option eagerPoisonBody.";
    public static final Boolean CAMEL_SOURCE_SJMS2_ENDPOINT_EAGER_LOADING_OF_PROPERTIES_DEFAULT = false;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_EAGER_POISON_BODY_CONF = "camel.source.endpoint.eagerPoisonBody";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_EAGER_POISON_BODY_DOC = "If eagerLoadingOfProperties is enabled and the JMS message payload (JMS body or JMS properties) is poison (cannot be read/mapped), then set this text as the message body instead so the message can be processed (the cause of the poison are already stored as exception on the Exchange). This can be turned off by setting eagerPoisonBody=false. See also the option eagerLoadingOfProperties.";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_EAGER_POISON_BODY_DEFAULT = "Poison JMS message due to ${exception.message}";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_MESSAGE_SELECTOR_CONF = "camel.source.endpoint.messageSelector";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_MESSAGE_SELECTOR_DOC = "Sets the JMS Message selector syntax.";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_MESSAGE_SELECTOR_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_SAME_DESTINATION_ALLOWED_CONF = "camel.source.endpoint.replyToSameDestinationAllowed";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_SAME_DESTINATION_ALLOWED_DOC = "Whether a JMS consumer is allowed to send a reply message to the same destination that the consumer is using to consume from. This prevents an endless loop by consuming and sending back the same message to itself.";
    public static final Boolean CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_SAME_DESTINATION_ALLOWED_DEFAULT = false;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_START_LISTENER_CONF = "camel.source.endpoint.asyncStartListener";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_START_LISTENER_DOC = "Whether to startup the consumer message listener asynchronously, when starting a route. For example if a JmsConsumer cannot get a connection to a remote JMS broker, then it may block while retrying and/or failover. This will cause Camel to block while starting routes. By setting this option to true, you will let routes startup, while the JmsConsumer connects to the JMS broker using a dedicated thread in asynchronous mode. If this option is used, then beware that if the connection could not be established, then an exception is logged at WARN level, and the consumer will not be able to receive messages; You can then restart the route to retry.";
    public static final Boolean CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_START_LISTENER_DEFAULT = false;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_STOP_LISTENER_CONF = "camel.source.endpoint.asyncStopListener";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_STOP_LISTENER_DOC = "Whether to stop the consumer message listener asynchronously, when stopping a route.";
    public static final Boolean CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_STOP_LISTENER_DEFAULT = false;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_DESTINATION_CREATION_STRATEGY_CONF = "camel.source.endpoint.destinationCreationStrategy";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_DESTINATION_CREATION_STRATEGY_DOC = "To use a custom DestinationCreationStrategy.";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_DESTINATION_CREATION_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_EXCEPTION_LISTENER_CONF = "camel.source.endpoint.exceptionListener";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_EXCEPTION_LISTENER_DOC = "Specifies the JMS Exception Listener that is to be notified of any underlying JMS exceptions.";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_EXCEPTION_LISTENER_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_HEADER_FILTER_STRATEGY_CONF = "camel.source.endpoint.headerFilterStrategy";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_HEADER_FILTER_STRATEGY_DOC = "To use a custom HeaderFilterStrategy to filter header to and from Camel message.";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_HEADER_FILTER_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_INCLUDE_ALL_JMSXPROPERTIES_CONF = "camel.source.endpoint.includeAllJMSXProperties";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_INCLUDE_ALL_JMSXPROPERTIES_DOC = "Whether to include all JMSXxxx properties when mapping from JMS to Camel Message. Setting this to true will include properties such as JMSXAppID, and JMSXUserID etc. Note: If you are using a custom headerFilterStrategy then this option does not apply.";
    public static final Boolean CAMEL_SOURCE_SJMS2_ENDPOINT_INCLUDE_ALL_JMSXPROPERTIES_DEFAULT = false;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_JMS_KEY_FORMAT_STRATEGY_CONF = "camel.source.endpoint.jmsKeyFormatStrategy";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_JMS_KEY_FORMAT_STRATEGY_DOC = "Pluggable strategy for encoding and decoding JMS keys so they can be compliant with the JMS specification. Camel provides two implementations out of the box: default and passthrough. The default strategy will safely marshal dots and hyphens (. and -). The passthrough strategy leaves the key as is. Can be used for JMS brokers which do not care whether JMS header keys contain illegal characters. You can provide your own implementation of the org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it using the # notation.";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_JMS_KEY_FORMAT_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_MAP_JMS_MESSAGE_CONF = "camel.source.endpoint.mapJmsMessage";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_MAP_JMS_MESSAGE_DOC = "Specifies whether Camel should auto map the received JMS message to a suited payload type, such as javax.jms.TextMessage to a String etc. See section about how mapping works below for more details.";
    public static final Boolean CAMEL_SOURCE_SJMS2_ENDPOINT_MAP_JMS_MESSAGE_DEFAULT = true;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_MESSAGE_CREATED_STRATEGY_CONF = "camel.source.endpoint.messageCreatedStrategy";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_MESSAGE_CREATED_STRATEGY_DOC = "To use the given MessageCreatedStrategy which are invoked when Camel creates new instances of javax.jms.Message objects when Camel is sending a JMS message.";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_MESSAGE_CREATED_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_RECOVERY_INTERVAL_CONF = "camel.source.endpoint.recoveryInterval";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_RECOVERY_INTERVAL_DOC = "Specifies the interval between recovery attempts, i.e. when a connection is being refreshed, in milliseconds. The default is 5000 ms, that is, 5 seconds.";
    public static final Long CAMEL_SOURCE_SJMS2_ENDPOINT_RECOVERY_INTERVAL_DEFAULT = 5000L;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used";
    public static final Boolean CAMEL_SOURCE_SJMS2_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_TRANSFER_EXCEPTION_CONF = "camel.source.endpoint.transferException";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_TRANSFER_EXCEPTION_DOC = "If enabled and you are using Request Reply messaging (InOut) and an Exchange failed on the consumer side, then the caused Exception will be send back in response as a javax.jms.ObjectMessage. If the client is Camel, the returned Exception is rethrown. This allows you to use Camel JMS as a bridge in your routing - for example, using persistent queues to enable robust routing. Notice that if you also have transferExchange enabled, this option takes precedence. The caught exception is required to be serializable. The original Exception on the consumer side can be wrapped in an outer exception such as org.apache.camel.RuntimeCamelException when returned to the producer. Use this with caution as the data is using Java Object serialization and requires the received to be able to deserialize the data at Class level, which forces a strong coupling between the producers and consumer!";
    public static final Boolean CAMEL_SOURCE_SJMS2_ENDPOINT_TRANSFER_EXCEPTION_DEFAULT = false;
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_TRANSACTED_CONF = "camel.source.endpoint.transacted";
    public static final String CAMEL_SOURCE_SJMS2_ENDPOINT_TRANSACTED_DOC = "Specifies whether to use transacted mode";
    public static final Boolean CAMEL_SOURCE_SJMS2_ENDPOINT_TRANSACTED_DEFAULT = false;
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_CONNECTION_FACTORY_CONF = "camel.component.sjms2.connectionFactory";
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_CONNECTION_FACTORY_DOC = "The connection factory to be use. A connection factory must be configured either on the component or endpoint.";
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_CONNECTION_FACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.sjms2.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_SJMS2_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.sjms2.autowiredEnabled";
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_SJMS2_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_DESTINATION_CREATION_STRATEGY_CONF = "camel.component.sjms2.destinationCreationStrategy";
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_DESTINATION_CREATION_STRATEGY_DOC = "To use a custom DestinationCreationStrategy.";
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_DESTINATION_CREATION_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_JMS_KEY_FORMAT_STRATEGY_CONF = "camel.component.sjms2.jmsKeyFormatStrategy";
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_JMS_KEY_FORMAT_STRATEGY_DOC = "Pluggable strategy for encoding and decoding JMS keys so they can be compliant with the JMS specification. Camel provides one implementation out of the box: default. The default strategy will safely marshal dots and hyphens (. and -). Can be used for JMS brokers which do not care whether JMS header keys contain illegal characters. You can provide your own implementation of the org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it using the # notation.";
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_JMS_KEY_FORMAT_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_MESSAGE_CREATED_STRATEGY_CONF = "camel.component.sjms2.messageCreatedStrategy";
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_MESSAGE_CREATED_STRATEGY_DOC = "To use the given MessageCreatedStrategy which are invoked when Camel creates new instances of javax.jms.Message objects when Camel is sending a JMS message.";
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_MESSAGE_CREATED_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_RECOVERY_INTERVAL_CONF = "camel.component.sjms2.recoveryInterval";
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_RECOVERY_INTERVAL_DOC = "Specifies the interval between recovery attempts, i.e. when a connection is being refreshed, in milliseconds. The default is 5000 ms, that is, 5 seconds.";
    public static final Long CAMEL_SOURCE_SJMS2_COMPONENT_RECOVERY_INTERVAL_DEFAULT = 5000L;
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_REPLY_TO_ON_TIMEOUT_MAX_CONCURRENT_CONSUMERS_CONF = "camel.component.sjms2.replyToOnTimeoutMaxConcurrentConsumers";
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_REPLY_TO_ON_TIMEOUT_MAX_CONCURRENT_CONSUMERS_DOC = "Specifies the maximum number of concurrent consumers for continue routing when timeout occurred when using request/reply over JMS.";
    public static final Integer CAMEL_SOURCE_SJMS2_COMPONENT_REPLY_TO_ON_TIMEOUT_MAX_CONCURRENT_CONSUMERS_DEFAULT = 1;
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_CONF = "camel.component.sjms2.requestTimeoutCheckerInterval";
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DOC = "Configures how often Camel should check for timed out Exchanges when doing request/reply over JMS. By default Camel checks once per second. But if you must react faster when a timeout occurs, then you can lower this interval, to check more frequently. The timeout is determined by the option requestTimeout.";
    public static final Long CAMEL_SOURCE_SJMS2_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_HEADER_FILTER_STRATEGY_CONF = "camel.component.sjms2.headerFilterStrategy";
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_HEADER_FILTER_STRATEGY_DOC = "To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter header to and from Camel message.";
    public static final String CAMEL_SOURCE_SJMS2_COMPONENT_HEADER_FILTER_STRATEGY_DEFAULT = null;

    public CamelSjms2SourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelSjms2SourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_SJMS2_PATH_DESTINATION_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_PATH_DESTINATION_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_PATH_DESTINATION_TYPE_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_PATH_DESTINATION_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_PATH_DESTINATION_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_SJMS2_PATH_DESTINATION_NAME_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_ACKNOWLEDGEMENT_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_ENDPOINT_ACKNOWLEDGEMENT_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_ACKNOWLEDGEMENT_MODE_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_CONNECTION_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_ENDPOINT_CONNECTION_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_CONNECTION_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_DISABLE_REPLY_TO_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_ENDPOINT_DISABLE_REPLY_TO_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_DISABLE_REPLY_TO_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_TEST_CONNECTION_ON_STARTUP_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_ENDPOINT_TEST_CONNECTION_ON_STARTUP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_TEST_CONNECTION_ON_STARTUP_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_CONSUMER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_CONSUMER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_CONSUMER_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_AUTO_STARTUP_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_ENDPOINT_AUTO_STARTUP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_AUTO_STARTUP_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_CLIENT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_ENDPOINT_CLIENT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_CLIENT_ID_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_CONCURRENT_CONSUMERS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_SJMS2_ENDPOINT_CONCURRENT_CONSUMERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_CONCURRENT_CONSUMERS_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_DURABLE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_ENDPOINT_DURABLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_DURABLE_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_DURABLE_SUBSCRIPTION_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_ENDPOINT_DURABLE_SUBSCRIPTION_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_DURABLE_SUBSCRIPTION_NAME_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_DELIVERY_PERSISTENT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_DELIVERY_PERSISTENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_DELIVERY_PERSISTENT_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_SHARED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_ENDPOINT_SHARED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_SHARED_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_SUBSCRIPTION_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_ENDPOINT_SUBSCRIPTION_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_SUBSCRIPTION_ID_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_EAGER_LOADING_OF_PROPERTIES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_ENDPOINT_EAGER_LOADING_OF_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_EAGER_LOADING_OF_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_EAGER_POISON_BODY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_ENDPOINT_EAGER_POISON_BODY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_EAGER_POISON_BODY_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_MESSAGE_SELECTOR_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_ENDPOINT_MESSAGE_SELECTOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_MESSAGE_SELECTOR_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_SAME_DESTINATION_ALLOWED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_SAME_DESTINATION_ALLOWED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_REPLY_TO_SAME_DESTINATION_ALLOWED_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_START_LISTENER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_START_LISTENER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_START_LISTENER_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_STOP_LISTENER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_STOP_LISTENER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_ASYNC_STOP_LISTENER_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_DESTINATION_CREATION_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_ENDPOINT_DESTINATION_CREATION_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_DESTINATION_CREATION_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_EXCEPTION_LISTENER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_ENDPOINT_EXCEPTION_LISTENER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_EXCEPTION_LISTENER_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_HEADER_FILTER_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_ENDPOINT_HEADER_FILTER_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_HEADER_FILTER_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_INCLUDE_ALL_JMSXPROPERTIES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_ENDPOINT_INCLUDE_ALL_JMSXPROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_INCLUDE_ALL_JMSXPROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_JMS_KEY_FORMAT_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_ENDPOINT_JMS_KEY_FORMAT_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_JMS_KEY_FORMAT_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_MAP_JMS_MESSAGE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_ENDPOINT_MAP_JMS_MESSAGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_MAP_JMS_MESSAGE_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_MESSAGE_CREATED_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_ENDPOINT_MESSAGE_CREATED_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_MESSAGE_CREATED_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_RECOVERY_INTERVAL_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_SJMS2_ENDPOINT_RECOVERY_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_RECOVERY_INTERVAL_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_TRANSFER_EXCEPTION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_ENDPOINT_TRANSFER_EXCEPTION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_TRANSFER_EXCEPTION_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_ENDPOINT_TRANSACTED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_ENDPOINT_TRANSACTED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_ENDPOINT_TRANSACTED_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_COMPONENT_CONNECTION_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_COMPONENT_CONNECTION_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_COMPONENT_CONNECTION_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SJMS2_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_COMPONENT_DESTINATION_CREATION_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_COMPONENT_DESTINATION_CREATION_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_COMPONENT_DESTINATION_CREATION_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_COMPONENT_JMS_KEY_FORMAT_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_COMPONENT_JMS_KEY_FORMAT_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_COMPONENT_JMS_KEY_FORMAT_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_COMPONENT_MESSAGE_CREATED_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_COMPONENT_MESSAGE_CREATED_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_COMPONENT_MESSAGE_CREATED_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_COMPONENT_RECOVERY_INTERVAL_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_SJMS2_COMPONENT_RECOVERY_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_COMPONENT_RECOVERY_INTERVAL_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_COMPONENT_REPLY_TO_ON_TIMEOUT_MAX_CONCURRENT_CONSUMERS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_SJMS2_COMPONENT_REPLY_TO_ON_TIMEOUT_MAX_CONCURRENT_CONSUMERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_COMPONENT_REPLY_TO_ON_TIMEOUT_MAX_CONCURRENT_CONSUMERS_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_SJMS2_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DOC);
        conf.define(CAMEL_SOURCE_SJMS2_COMPONENT_HEADER_FILTER_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SJMS2_COMPONENT_HEADER_FILTER_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SJMS2_COMPONENT_HEADER_FILTER_STRATEGY_DOC);
        return conf;
    }
}