/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.azurestoragedatalake;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelAzurestoragedatalakeSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_PATH_ACCOUNT_NAME_CONF = "camel.source.path.accountName";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_PATH_ACCOUNT_NAME_DOC = "name of the azure account";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_PATH_ACCOUNT_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_PATH_FILE_SYSTEM_NAME_CONF = "camel.source.path.fileSystemName";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_PATH_FILE_SYSTEM_NAME_DOC = "name of filesystem to be used";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_PATH_FILE_SYSTEM_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_ACCOUNT_KEY_CONF = "camel.source.endpoint.accountKey";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_ACCOUNT_KEY_DOC = "account key for authentication";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_ACCOUNT_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_ID_CONF = "camel.source.endpoint.clientId";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_ID_DOC = "client id for azure account";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_SECRET_CONF = "camel.source.endpoint.clientSecret";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_SECRET_DOC = "client secret for azure account";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_SECRET_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_SECRET_CREDENTIAL_CONF = "camel.source.endpoint.clientSecretCredential";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_SECRET_CREDENTIAL_DOC = "client secret credential for authentication";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_SECRET_CREDENTIAL_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLOSE_CONF = "camel.source.endpoint.close";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLOSE_DOC = "Whether or not a file changed event raised indicates completion (true) or modification (false)";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLOSE_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLOSE_STREAM_AFTER_READ_CONF = "camel.source.endpoint.closeStreamAfterRead";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLOSE_STREAM_AFTER_READ_DOC = "check for closing stream after read";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLOSE_STREAM_AFTER_READ_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DATA_COUNT_CONF = "camel.source.endpoint.dataCount";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DATA_COUNT_DOC = "count number of bytes to download";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DATA_COUNT_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DATA_LAKE_SERVICE_CLIENT_CONF = "camel.source.endpoint.dataLakeServiceClient";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DATA_LAKE_SERVICE_CLIENT_DOC = "service client of datalake";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DATA_LAKE_SERVICE_CLIENT_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DIRECTORY_NAME_CONF = "camel.source.endpoint.directoryName";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DIRECTORY_NAME_DOC = "directory of the file to be handled in component";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DIRECTORY_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DOWNLOAD_LINK_EXPIRATION_CONF = "camel.source.endpoint.downloadLinkExpiration";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DOWNLOAD_LINK_EXPIRATION_DOC = "download link expiration time";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DOWNLOAD_LINK_EXPIRATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXPRESSION_CONF = "camel.source.endpoint.expression";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXPRESSION_DOC = "expression for queryInputStream";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXPRESSION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_DIR_CONF = "camel.source.endpoint.fileDir";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_DIR_DOC = "directory of file to do operations in the local system";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_DIR_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_NAME_CONF = "camel.source.endpoint.fileName";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_NAME_DOC = "name of file to be handled in component";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_OFFSET_CONF = "camel.source.endpoint.fileOffset";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_OFFSET_DOC = "offset position in file for different operations";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_OFFSET_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_MAX_RESULTS_CONF = "camel.source.endpoint.maxResults";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_MAX_RESULTS_DOC = "maximum number of results to show at a time";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_MAX_RESULTS_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_MAX_RETRY_REQUESTS_CONF = "camel.source.endpoint.maxRetryRequests";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_MAX_RETRY_REQUESTS_DOC = "no of retries to a given request";
    public static final Integer CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_MAX_RETRY_REQUESTS_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_OPEN_OPTIONS_CONF = "camel.source.endpoint.openOptions";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_OPEN_OPTIONS_DOC = "set open options for creating file";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_OPEN_OPTIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_PATH_CONF = "camel.source.endpoint.path";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_PATH_DOC = "path in azure datalake for operations";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_PATH_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_PERMISSION_CONF = "camel.source.endpoint.permission";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_PERMISSION_DOC = "permission string for the file";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_PERMISSION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_POSITION_CONF = "camel.source.endpoint.position";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_POSITION_DOC = "This parameter allows the caller to upload data in parallel and control the order in which it is appended to the file.";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_POSITION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_RECURSIVE_CONF = "camel.source.endpoint.recursive";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_RECURSIVE_DOC = "recursively include all paths";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_RECURSIVE_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_REGEX_CONF = "camel.source.endpoint.regex";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_REGEX_DOC = "regular expression for matching file names";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_REGEX_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_RETAIN_UNCOMMITED_DATA_CONF = "camel.source.endpoint.retainUncommitedData";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_RETAIN_UNCOMMITED_DATA_DOC = "Whether or not uncommitted data is to be retained after the operation";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_RETAIN_UNCOMMITED_DATA_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_SERVICE_CLIENT_CONF = "camel.source.endpoint.serviceClient";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_SERVICE_CLIENT_DOC = "datalake service client for azure storage datalake";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_SERVICE_CLIENT_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_SHARED_KEY_CREDENTIAL_CONF = "camel.source.endpoint.sharedKeyCredential";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_SHARED_KEY_CREDENTIAL_DOC = "shared key credential for azure datalake gen2";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_SHARED_KEY_CREDENTIAL_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_TENANT_ID_CONF = "camel.source.endpoint.tenantId";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_TENANT_ID_DOC = "tenant id for azure account";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_TENANT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_TIMEOUT_CONF = "camel.source.endpoint.timeout";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_TIMEOUT_DOC = "Timeout for operation";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_TIMEOUT_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_UMASK_CONF = "camel.source.endpoint.umask";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_UMASK_DOC = "umask permission for file";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_UMASK_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_USER_PRINCIPAL_NAME_RETURNED_CONF = "camel.source.endpoint.userPrincipalNameReturned";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_USER_PRINCIPAL_NAME_RETURNED_DOC = "whether or not to use upn";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_USER_PRINCIPAL_NAME_RETURNED_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_ACCOUNT_KEY_CONF = "camel.component.azure-storage-datalake.accountKey";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_ACCOUNT_KEY_DOC = "account key for authentication";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_ACCOUNT_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_ID_CONF = "camel.component.azure-storage-datalake.clientId";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_ID_DOC = "client id for azure account";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_SECRET_CONF = "camel.component.azure-storage-datalake.clientSecret";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_SECRET_DOC = "client secret for azure account";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_SECRET_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_SECRET_CREDENTIAL_CONF = "camel.component.azure-storage-datalake.clientSecretCredential";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_SECRET_CREDENTIAL_DOC = "client secret credential for authentication";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_SECRET_CREDENTIAL_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLOSE_CONF = "camel.component.azure-storage-datalake.close";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLOSE_DOC = "Whether or not a file changed event raised indicates completion (true) or modification (false)";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLOSE_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLOSE_STREAM_AFTER_READ_CONF = "camel.component.azure-storage-datalake.closeStreamAfterRead";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLOSE_STREAM_AFTER_READ_DOC = "check for closing stream after read";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLOSE_STREAM_AFTER_READ_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CONFIGURATION_CONF = "camel.component.azure-storage-datalake.configuration";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CONFIGURATION_DOC = "configuration object for datalake";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DATA_COUNT_CONF = "camel.component.azure-storage-datalake.dataCount";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DATA_COUNT_DOC = "count number of bytes to download";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DATA_COUNT_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DIRECTORY_NAME_CONF = "camel.component.azure-storage-datalake.directoryName";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DIRECTORY_NAME_DOC = "directory of the file to be handled in component";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DIRECTORY_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DOWNLOAD_LINK_EXPIRATION_CONF = "camel.component.azure-storage-datalake.downloadLinkExpiration";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DOWNLOAD_LINK_EXPIRATION_DOC = "download link expiration time";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DOWNLOAD_LINK_EXPIRATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_EXPRESSION_CONF = "camel.component.azure-storage-datalake.expression";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_EXPRESSION_DOC = "expression for queryInputStream";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_EXPRESSION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_DIR_CONF = "camel.component.azure-storage-datalake.fileDir";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_DIR_DOC = "directory of file to do operations in the local system";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_DIR_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_NAME_CONF = "camel.component.azure-storage-datalake.fileName";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_NAME_DOC = "name of file to be handled in component";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_OFFSET_CONF = "camel.component.azure-storage-datalake.fileOffset";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_OFFSET_DOC = "offset position in file for different operations";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_OFFSET_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_MAX_RESULTS_CONF = "camel.component.azure-storage-datalake.maxResults";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_MAX_RESULTS_DOC = "maximum number of results to show at a time";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_MAX_RESULTS_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_MAX_RETRY_REQUESTS_CONF = "camel.component.azure-storage-datalake.maxRetryRequests";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_MAX_RETRY_REQUESTS_DOC = "no of retries to a given request";
    public static final Integer CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_MAX_RETRY_REQUESTS_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_OPEN_OPTIONS_CONF = "camel.component.azure-storage-datalake.openOptions";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_OPEN_OPTIONS_DOC = "set open options for creating file";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_OPEN_OPTIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_PATH_CONF = "camel.component.azure-storage-datalake.path";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_PATH_DOC = "path in azure datalake for operations";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_PATH_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_PERMISSION_CONF = "camel.component.azure-storage-datalake.permission";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_PERMISSION_DOC = "permission string for the file";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_PERMISSION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_POSITION_CONF = "camel.component.azure-storage-datalake.position";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_POSITION_DOC = "This parameter allows the caller to upload data in parallel and control the order in which it is appended to the file.";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_POSITION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_RECURSIVE_CONF = "camel.component.azure-storage-datalake.recursive";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_RECURSIVE_DOC = "recursively include all paths";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_RECURSIVE_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_REGEX_CONF = "camel.component.azure-storage-datalake.regex";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_REGEX_DOC = "regular expression for matching file names";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_REGEX_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_RETAIN_UNCOMMITED_DATA_CONF = "camel.component.azure-storage-datalake.retainUncommitedData";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_RETAIN_UNCOMMITED_DATA_DOC = "Whether or not uncommitted data is to be retained after the operation";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_RETAIN_UNCOMMITED_DATA_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_SERVICE_CLIENT_CONF = "camel.component.azure-storage-datalake.serviceClient";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_SERVICE_CLIENT_DOC = "datalake service client for azure storage datalake";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_SERVICE_CLIENT_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_SHARED_KEY_CREDENTIAL_CONF = "camel.component.azure-storage-datalake.sharedKeyCredential";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_SHARED_KEY_CREDENTIAL_DOC = "shared key credential for azure datalake gen2";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_SHARED_KEY_CREDENTIAL_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_TENANT_ID_CONF = "camel.component.azure-storage-datalake.tenantId";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_TENANT_ID_DOC = "tenant id for azure account";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_TENANT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_TIMEOUT_CONF = "camel.component.azure-storage-datalake.timeout";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_TIMEOUT_DOC = "Timeout for operation";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_TIMEOUT_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_UMASK_CONF = "camel.component.azure-storage-datalake.umask";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_UMASK_DOC = "umask permission for file";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_UMASK_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_USER_PRINCIPAL_NAME_RETURNED_CONF = "camel.component.azure-storage-datalake.userPrincipalNameReturned";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_USER_PRINCIPAL_NAME_RETURNED_DOC = "whether or not to use upn";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_USER_PRINCIPAL_NAME_RETURNED_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.azure-storage-datalake.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.azure-storage-datalake.autowiredEnabled";
    public static final String CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;

    public CamelAzurestoragedatalakeSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelAzurestoragedatalakeSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_PATH_ACCOUNT_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_PATH_ACCOUNT_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_PATH_ACCOUNT_NAME_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_PATH_FILE_SYSTEM_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_PATH_FILE_SYSTEM_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_PATH_FILE_SYSTEM_NAME_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_ACCOUNT_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_ACCOUNT_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_ACCOUNT_KEY_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_ID_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_SECRET_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_SECRET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_SECRET_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_SECRET_CREDENTIAL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_SECRET_CREDENTIAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLIENT_SECRET_CREDENTIAL_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLOSE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLOSE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLOSE_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLOSE_STREAM_AFTER_READ_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLOSE_STREAM_AFTER_READ_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_CLOSE_STREAM_AFTER_READ_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DATA_COUNT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DATA_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DATA_COUNT_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DATA_LAKE_SERVICE_CLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DATA_LAKE_SERVICE_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DATA_LAKE_SERVICE_CLIENT_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DIRECTORY_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DIRECTORY_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DIRECTORY_NAME_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DOWNLOAD_LINK_EXPIRATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DOWNLOAD_LINK_EXPIRATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_DOWNLOAD_LINK_EXPIRATION_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXPRESSION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXPRESSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXPRESSION_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_DIR_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_DIR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_DIR_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_NAME_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_OFFSET_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_OFFSET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_FILE_OFFSET_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_MAX_RESULTS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_MAX_RESULTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_MAX_RESULTS_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_MAX_RETRY_REQUESTS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_MAX_RETRY_REQUESTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_MAX_RETRY_REQUESTS_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_OPEN_OPTIONS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_OPEN_OPTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_OPEN_OPTIONS_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_PATH_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_PATH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_PATH_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_PERMISSION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_PERMISSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_PERMISSION_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_POSITION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_POSITION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_POSITION_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_RECURSIVE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_RECURSIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_RECURSIVE_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_REGEX_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_REGEX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_REGEX_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_RETAIN_UNCOMMITED_DATA_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_RETAIN_UNCOMMITED_DATA_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_RETAIN_UNCOMMITED_DATA_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_SERVICE_CLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_SERVICE_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_SERVICE_CLIENT_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_SHARED_KEY_CREDENTIAL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_SHARED_KEY_CREDENTIAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_SHARED_KEY_CREDENTIAL_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_TENANT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_TENANT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_TENANT_ID_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_TIMEOUT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_UMASK_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_UMASK_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_UMASK_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_USER_PRINCIPAL_NAME_RETURNED_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_USER_PRINCIPAL_NAME_RETURNED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_USER_PRINCIPAL_NAME_RETURNED_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_ACCOUNT_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_ACCOUNT_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_ACCOUNT_KEY_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_ID_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_SECRET_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_SECRET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_SECRET_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_SECRET_CREDENTIAL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_SECRET_CREDENTIAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLIENT_SECRET_CREDENTIAL_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLOSE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLOSE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLOSE_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLOSE_STREAM_AFTER_READ_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLOSE_STREAM_AFTER_READ_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CLOSE_STREAM_AFTER_READ_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DATA_COUNT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DATA_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DATA_COUNT_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DIRECTORY_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DIRECTORY_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DIRECTORY_NAME_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DOWNLOAD_LINK_EXPIRATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DOWNLOAD_LINK_EXPIRATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_DOWNLOAD_LINK_EXPIRATION_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_EXPRESSION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_EXPRESSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_EXPRESSION_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_DIR_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_DIR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_DIR_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_NAME_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_OFFSET_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_OFFSET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_FILE_OFFSET_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_MAX_RESULTS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_MAX_RESULTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_MAX_RESULTS_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_MAX_RETRY_REQUESTS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_MAX_RETRY_REQUESTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_MAX_RETRY_REQUESTS_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_OPEN_OPTIONS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_OPEN_OPTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_OPEN_OPTIONS_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_PATH_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_PATH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_PATH_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_PERMISSION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_PERMISSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_PERMISSION_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_POSITION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_POSITION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_POSITION_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_RECURSIVE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_RECURSIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_RECURSIVE_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_REGEX_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_REGEX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_REGEX_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_RETAIN_UNCOMMITED_DATA_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_RETAIN_UNCOMMITED_DATA_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_RETAIN_UNCOMMITED_DATA_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_SERVICE_CLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_SERVICE_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_SERVICE_CLIENT_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_SHARED_KEY_CREDENTIAL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_SHARED_KEY_CREDENTIAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_SHARED_KEY_CREDENTIAL_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_TENANT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_TENANT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_TENANT_ID_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_TIMEOUT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_UMASK_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_UMASK_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_UMASK_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_USER_PRINCIPAL_NAME_RETURNED_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_USER_PRINCIPAL_NAME_RETURNED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_USER_PRINCIPAL_NAME_RETURNED_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZURESTORAGEDATALAKE_COMPONENT_AUTOWIRED_ENABLED_DOC);
        return conf;
    }
}