/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.soroush;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelSoroushSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_SOROUSH_PATH_ACTION_CONF = "camel.sink.path.action";
    public static final String CAMEL_SINK_SOROUSH_PATH_ACTION_DOC = "The action to do. One of: [sendMessage] [getMessage] [uploadFile] [downloadFile]";
    public static final String CAMEL_SINK_SOROUSH_PATH_ACTION_DEFAULT = null;
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_CONNECTION_TIMEOUT_CONF = "camel.sink.endpoint.connectionTimeout";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_CONNECTION_TIMEOUT_DOC = "Connection timeout in ms when connecting to soroush API";
    public static final Integer CAMEL_SINK_SOROUSH_ENDPOINT_CONNECTION_TIMEOUT_DEFAULT = 30000;
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_MAX_CONNECTION_RETRY_CONF = "camel.sink.endpoint.maxConnectionRetry";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_MAX_CONNECTION_RETRY_DOC = "Maximum connection retry when fail to connect to soroush API, if the quota is reached, MaximumConnectionRetryReachedException is thrown for that message.";
    public static final Integer CAMEL_SINK_SOROUSH_ENDPOINT_MAX_CONNECTION_RETRY_DEFAULT = 4;
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_AUTO_DOWNLOAD_CONF = "camel.sink.endpoint.autoDownload";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_AUTO_DOWNLOAD_DOC = "Automatically download SoroushMessage.fileUrl and SoroushMessage.thumbnailUrl if exists for the message and store them in SoroushMessage.file and SoroushMessage.thumbnail field";
    public static final Boolean CAMEL_SINK_SOROUSH_ENDPOINT_AUTO_DOWNLOAD_DEFAULT = false;
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_AUTO_UPLOAD_FILE_CONF = "camel.sink.endpoint.autoUploadFile";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_AUTO_UPLOAD_FILE_DOC = "Automatically upload attachments when a message goes to the sendMessage endpoint and the SoroushMessage.file (SoroushMessage.thumbnail) has been set and SoroushMessage.fileUrl(SoroushMessage.thumbnailUrl) is null";
    public static final Boolean CAMEL_SINK_SOROUSH_ENDPOINT_AUTO_UPLOAD_FILE_DEFAULT = true;
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_DOWNLOAD_THUMBNAIL_CONF = "camel.sink.endpoint.downloadThumbnail";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_DOWNLOAD_THUMBNAIL_DOC = "If true, when downloading an attached file, thumbnail will be downloaded if provided in the message. Otherwise, only the file will be downloaded";
    public static final Boolean CAMEL_SINK_SOROUSH_ENDPOINT_DOWNLOAD_THUMBNAIL_DEFAULT = true;
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_FORCE_DOWNLOAD_CONF = "camel.sink.endpoint.forceDownload";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_FORCE_DOWNLOAD_DOC = "Force to download SoroushMessage.fileUrl(SoroushMessage.thumbnailUrl) if exists, even if the SoroushMessage.file(SoroushMessage.thumbnail) was not null in that message";
    public static final Boolean CAMEL_SINK_SOROUSH_ENDPOINT_FORCE_DOWNLOAD_DEFAULT = false;
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_FORCE_UPLOAD_CONF = "camel.sink.endpoint.forceUpload";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_FORCE_UPLOAD_DOC = "Force to upload SoroushMessage.file(SoroushMessage.thumbnail) if exists, even if the SoroushMessage.fileUrl(SoroushMessage.thumbnailUrl) is not null in the message";
    public static final Boolean CAMEL_SINK_SOROUSH_ENDPOINT_FORCE_UPLOAD_DEFAULT = false;
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_SOROUSH_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_BACK_OFF_STRATEGY_CONF = "camel.sink.endpoint.backOffStrategy";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_BACK_OFF_STRATEGY_DOC = "The strategy to backoff in case of connection failure. Currently 3 strategies are supported: 1. Exponential (default): It multiply retryWaitingTime by retryExponentialCoefficient after each connection failure. 2. Linear: It increase retryWaitingTime by retryLinearIncrement after each connection failure. 3. Fixed: Always use retryWaitingTime as the time between retries.";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_BACK_OFF_STRATEGY_DEFAULT = "Exponential";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_MAX_RETRY_WAITING_TIME_CONF = "camel.sink.endpoint.maxRetryWaitingTime";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_MAX_RETRY_WAITING_TIME_DOC = "Maximum amount of time (in millisecond) a thread wait before retrying failed request.";
    public static final Long CAMEL_SINK_SOROUSH_ENDPOINT_MAX_RETRY_WAITING_TIME_DEFAULT = 3600000L;
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_RECONNECT_IDLE_CONNECTION_TIMEOUT_CONF = "camel.sink.endpoint.reconnectIdleConnectionTimeout";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_RECONNECT_IDLE_CONNECTION_TIMEOUT_DOC = "The timeout in millisecond to reconnect the existing getMessage connection to ensure that the connection is always live and does not dead without notifying the bot. this value should not be changed.";
    public static final Long CAMEL_SINK_SOROUSH_ENDPOINT_RECONNECT_IDLE_CONNECTION_TIMEOUT_DEFAULT = 300000L;
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_EXPONENTIAL_COEFFICIENT_CONF = "camel.sink.endpoint.retryExponentialCoefficient";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_EXPONENTIAL_COEFFICIENT_DOC = "Coefficient to compute back off time when using Exponential Back Off strategy";
    public static final Long CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_EXPONENTIAL_COEFFICIENT_DEFAULT = 2L;
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_LINEAR_INCREMENT_CONF = "camel.sink.endpoint.retryLinearIncrement";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_LINEAR_INCREMENT_DOC = "The amount of time (in millisecond) which adds to waiting time when using Linear back off strategy";
    public static final Long CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_LINEAR_INCREMENT_DEFAULT = 10000L;
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_WAITING_TIME_CONF = "camel.sink.endpoint.retryWaitingTime";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_WAITING_TIME_DOC = "Waiting time before retry failed request (Millisecond). If backOffStrategy is not Fixed this is the based value for computing back off waiting time. the first retry is always happen immediately after failure and retryWaitingTime do not apply to the first retry.";
    public static final Long CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_WAITING_TIME_DEFAULT = 1000L;
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_AUTHORIZATION_TOKEN_CONF = "camel.sink.endpoint.authorizationToken";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_AUTHORIZATION_TOKEN_DOC = "The authorization token for using the bot. if uri path does not contain authorization token, this token will be used.";
    public static final String CAMEL_SINK_SOROUSH_ENDPOINT_AUTHORIZATION_TOKEN_DEFAULT = null;
    public static final String CAMEL_SINK_SOROUSH_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.soroush.lazyStartProducer";
    public static final String CAMEL_SINK_SOROUSH_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_SOROUSH_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_SOROUSH_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.soroush.autowiredEnabled";
    public static final String CAMEL_SINK_SOROUSH_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_SOROUSH_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SINK_SOROUSH_COMPONENT_AUTHORIZATION_TOKEN_CONF = "camel.component.soroush.authorizationToken";
    public static final String CAMEL_SINK_SOROUSH_COMPONENT_AUTHORIZATION_TOKEN_DOC = "The default Soroush authorization token to be used when the information is not provided in the endpoints.";
    public static final String CAMEL_SINK_SOROUSH_COMPONENT_AUTHORIZATION_TOKEN_DEFAULT = null;

    public CamelSoroushSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelSoroushSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_SOROUSH_PATH_ACTION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SOROUSH_PATH_ACTION_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_SOROUSH_PATH_ACTION_DOC);
        conf.define(CAMEL_SINK_SOROUSH_ENDPOINT_CONNECTION_TIMEOUT_CONF, ConfigDef.Type.INT, CAMEL_SINK_SOROUSH_ENDPOINT_CONNECTION_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_ENDPOINT_CONNECTION_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_SOROUSH_ENDPOINT_MAX_CONNECTION_RETRY_CONF, ConfigDef.Type.INT, CAMEL_SINK_SOROUSH_ENDPOINT_MAX_CONNECTION_RETRY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_ENDPOINT_MAX_CONNECTION_RETRY_DOC);
        conf.define(CAMEL_SINK_SOROUSH_ENDPOINT_AUTO_DOWNLOAD_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SOROUSH_ENDPOINT_AUTO_DOWNLOAD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_ENDPOINT_AUTO_DOWNLOAD_DOC);
        conf.define(CAMEL_SINK_SOROUSH_ENDPOINT_AUTO_UPLOAD_FILE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SOROUSH_ENDPOINT_AUTO_UPLOAD_FILE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_ENDPOINT_AUTO_UPLOAD_FILE_DOC);
        conf.define(CAMEL_SINK_SOROUSH_ENDPOINT_DOWNLOAD_THUMBNAIL_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SOROUSH_ENDPOINT_DOWNLOAD_THUMBNAIL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_ENDPOINT_DOWNLOAD_THUMBNAIL_DOC);
        conf.define(CAMEL_SINK_SOROUSH_ENDPOINT_FORCE_DOWNLOAD_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SOROUSH_ENDPOINT_FORCE_DOWNLOAD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_ENDPOINT_FORCE_DOWNLOAD_DOC);
        conf.define(CAMEL_SINK_SOROUSH_ENDPOINT_FORCE_UPLOAD_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SOROUSH_ENDPOINT_FORCE_UPLOAD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_ENDPOINT_FORCE_UPLOAD_DOC);
        conf.define(CAMEL_SINK_SOROUSH_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SOROUSH_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_SOROUSH_ENDPOINT_BACK_OFF_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SOROUSH_ENDPOINT_BACK_OFF_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_ENDPOINT_BACK_OFF_STRATEGY_DOC);
        conf.define(CAMEL_SINK_SOROUSH_ENDPOINT_MAX_RETRY_WAITING_TIME_CONF, ConfigDef.Type.LONG, CAMEL_SINK_SOROUSH_ENDPOINT_MAX_RETRY_WAITING_TIME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_ENDPOINT_MAX_RETRY_WAITING_TIME_DOC);
        conf.define(CAMEL_SINK_SOROUSH_ENDPOINT_RECONNECT_IDLE_CONNECTION_TIMEOUT_CONF, ConfigDef.Type.LONG, CAMEL_SINK_SOROUSH_ENDPOINT_RECONNECT_IDLE_CONNECTION_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_ENDPOINT_RECONNECT_IDLE_CONNECTION_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_EXPONENTIAL_COEFFICIENT_CONF, ConfigDef.Type.LONG, CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_EXPONENTIAL_COEFFICIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_EXPONENTIAL_COEFFICIENT_DOC);
        conf.define(CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_LINEAR_INCREMENT_CONF, ConfigDef.Type.LONG, CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_LINEAR_INCREMENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_LINEAR_INCREMENT_DOC);
        conf.define(CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_WAITING_TIME_CONF, ConfigDef.Type.LONG, CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_WAITING_TIME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_ENDPOINT_RETRY_WAITING_TIME_DOC);
        conf.define(CAMEL_SINK_SOROUSH_ENDPOINT_AUTHORIZATION_TOKEN_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SOROUSH_ENDPOINT_AUTHORIZATION_TOKEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_ENDPOINT_AUTHORIZATION_TOKEN_DOC);
        conf.define(CAMEL_SINK_SOROUSH_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SOROUSH_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_SOROUSH_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SOROUSH_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SINK_SOROUSH_COMPONENT_AUTHORIZATION_TOKEN_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SOROUSH_COMPONENT_AUTHORIZATION_TOKEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SOROUSH_COMPONENT_AUTHORIZATION_TOKEN_DOC);
        return conf;
    }
}