/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.salesforce;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelSalesforceSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_SALESFORCE_PATH_TOPIC_NAME_CONF = "camel.source.path.topicName";
    public static final String CAMEL_SOURCE_SALESFORCE_PATH_TOPIC_NAME_DOC = "The name of the topic/channel to use";
    public static final String CAMEL_SOURCE_SALESFORCE_PATH_TOPIC_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_APEX_METHOD_CONF = "camel.source.endpoint.apexMethod";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_APEX_METHOD_DOC = "APEX method name";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_APEX_METHOD_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_APEX_QUERY_PARAMS_CONF = "camel.source.endpoint.apexQueryParams";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_APEX_QUERY_PARAMS_DOC = "Query params for APEX method";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_APEX_QUERY_PARAMS_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_API_VERSION_CONF = "camel.source.endpoint.apiVersion";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_API_VERSION_DOC = "Salesforce API version.";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_API_VERSION_DEFAULT = "50.0";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_BACKOFF_INCREMENT_CONF = "camel.source.endpoint.backoffIncrement";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_BACKOFF_INCREMENT_DOC = "Backoff interval increment for Streaming connection restart attempts for failures beyond CometD auto-reconnect.";
    public static final Long CAMEL_SOURCE_SALESFORCE_ENDPOINT_BACKOFF_INCREMENT_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_BATCH_ID_CONF = "camel.source.endpoint.batchId";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_BATCH_ID_DOC = "Bulk API Batch ID";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_BATCH_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_CONTENT_TYPE_CONF = "camel.source.endpoint.contentType";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_CONTENT_TYPE_DOC = "Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV One of: [XML] [CSV] [JSON] [ZIP_XML] [ZIP_CSV] [ZIP_JSON]";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_CONTENT_TYPE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_DEFAULT_REPLAY_ID_CONF = "camel.source.endpoint.defaultReplayId";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_DEFAULT_REPLAY_ID_DOC = "Default replayId setting if no value is found in initialReplayIdMap";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_DEFAULT_REPLAY_ID_DEFAULT = "-1";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_FORMAT_CONF = "camel.source.endpoint.format";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_FORMAT_DOC = "Payload format to use for Salesforce API calls, either JSON or XML, defaults to JSON One of: [JSON] [XML]";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_FORMAT_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_HTTP_CLIENT_CONF = "camel.source.endpoint.httpClient";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_HTTP_CLIENT_DOC = "Custom Jetty Http Client to use to connect to Salesforce.";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_HTTP_CLIENT_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_INCLUDE_DETAILS_CONF = "camel.source.endpoint.includeDetails";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_INCLUDE_DETAILS_DOC = "Include details in Salesforce1 Analytics report, defaults to false.";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_INCLUDE_DETAILS_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_INITIAL_REPLAY_ID_MAP_CONF = "camel.source.endpoint.initialReplayIdMap";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_INITIAL_REPLAY_ID_MAP_DOC = "Replay IDs to start from per channel name.";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_INITIAL_REPLAY_ID_MAP_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_INSTANCE_ID_CONF = "camel.source.endpoint.instanceId";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_INSTANCE_ID_DOC = "Salesforce1 Analytics report execution instance ID";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_INSTANCE_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_JOB_ID_CONF = "camel.source.endpoint.jobId";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_JOB_ID_DOC = "Bulk API Job ID";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_JOB_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_LIMIT_CONF = "camel.source.endpoint.limit";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_LIMIT_DOC = "Limit on number of returned records. Applicable to some of the API, check the Salesforce documentation.";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_LIMIT_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_MAX_BACKOFF_CONF = "camel.source.endpoint.maxBackoff";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_MAX_BACKOFF_DOC = "Maximum backoff interval for Streaming connection restart attempts for failures beyond CometD auto-reconnect.";
    public static final Long CAMEL_SOURCE_SALESFORCE_ENDPOINT_MAX_BACKOFF_DEFAULT = 30000L;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOT_FOUND_BEHAVIOUR_CONF = "camel.source.endpoint.notFoundBehaviour";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOT_FOUND_BEHAVIOUR_DOC = "Sets the behaviour of 404 not found status received from Salesforce API. Should the body be set to NULL NotFoundBehaviour#NULL or should a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION - the default. One of: [EXCEPTION] [NULL]";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOT_FOUND_BEHAVIOUR_DEFAULT = "EXCEPTION";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_FIELDS_CONF = "camel.source.endpoint.notifyForFields";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_FIELDS_DOC = "Notify for fields, options are ALL, REFERENCED, SELECT, WHERE One of: [ALL] [REFERENCED] [SELECT] [WHERE]";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_FIELDS_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_CREATE_CONF = "camel.source.endpoint.notifyForOperationCreate";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_CREATE_DOC = "Notify for create operation, defaults to false (API version = 29.0)";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_CREATE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_DELETE_CONF = "camel.source.endpoint.notifyForOperationDelete";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_DELETE_DOC = "Notify for delete operation, defaults to false (API version = 29.0)";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_DELETE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATIONS_CONF = "camel.source.endpoint.notifyForOperations";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATIONS_DOC = "Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API version 29.0) One of: [ALL] [CREATE] [EXTENDED] [UPDATE]";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_UNDELETE_CONF = "camel.source.endpoint.notifyForOperationUndelete";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_UNDELETE_DOC = "Notify for un-delete operation, defaults to false (API version = 29.0)";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_UNDELETE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_UPDATE_CONF = "camel.source.endpoint.notifyForOperationUpdate";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_UPDATE_DOC = "Notify for update operation, defaults to false (API version = 29.0)";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_UPDATE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_OBJECT_MAPPER_CONF = "camel.source.endpoint.objectMapper";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_OBJECT_MAPPER_DOC = "Custom Jackson ObjectMapper to use when serializing/deserializing Salesforce objects.";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_OBJECT_MAPPER_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_CONF = "camel.source.endpoint.pkChunking";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_DOC = "Use PK Chunking. Only for use in original Bulk API. Bulk 2.0 API performs PK chunking automatically, if necessary.";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_CHUNK_SIZE_CONF = "camel.source.endpoint.pkChunkingChunkSize";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_CHUNK_SIZE_DOC = "Chunk size for use with PK Chunking. If unspecified, salesforce default is 100,000. Maximum size is 250,000.";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_CHUNK_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_PARENT_CONF = "camel.source.endpoint.pkChunkingParent";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_PARENT_DOC = "Specifies the parent object when you're enabling PK chunking for queries on sharing objects. The chunks are based on the parent object's records rather than the sharing object's records. For example, when querying on AccountShare, specify Account as the parent object. PK chunking is supported for sharing objects as long as the parent object is supported.";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_PARENT_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_START_ROW_CONF = "camel.source.endpoint.pkChunkingStartRow";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_START_ROW_DOC = "Specifies the 15-character or 18-character record ID to be used as the lower boundary for the first chunk. Use this parameter to specify a starting ID when restarting a job that failed between batches.";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_START_ROW_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_QUERY_LOCATOR_CONF = "camel.source.endpoint.queryLocator";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_QUERY_LOCATOR_DOC = "Query Locator provided by salesforce for use when a query results in more records than can be retrieved in a single call. Use this value in a subsequent call to retrieve additional records.";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_QUERY_LOCATOR_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_RAW_PAYLOAD_CONF = "camel.source.endpoint.rawPayload";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_RAW_PAYLOAD_DOC = "Use raw payload String for request and response (either JSON or XML depending on format), instead of DTOs, false by default";
    public static final Boolean CAMEL_SOURCE_SALESFORCE_ENDPOINT_RAW_PAYLOAD_DEFAULT = false;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPORT_ID_CONF = "camel.source.endpoint.reportId";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPORT_ID_DOC = "Salesforce1 Analytics report Id";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPORT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPORT_METADATA_CONF = "camel.source.endpoint.reportMetadata";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPORT_METADATA_DOC = "Salesforce1 Analytics report metadata for filtering";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPORT_METADATA_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_RESULT_ID_CONF = "camel.source.endpoint.resultId";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_RESULT_ID_DOC = "Bulk API Result ID";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_RESULT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_BLOB_FIELD_NAME_CONF = "camel.source.endpoint.sObjectBlobFieldName";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_BLOB_FIELD_NAME_DOC = "SObject blob field name";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_BLOB_FIELD_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_CLASS_CONF = "camel.source.endpoint.sObjectClass";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_CLASS_DOC = "Fully qualified SObject class name, usually generated using camel-salesforce-maven-plugin";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_CLASS_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_FIELDS_CONF = "camel.source.endpoint.sObjectFields";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_FIELDS_DOC = "SObject fields to retrieve";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_FIELDS_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_CONF = "camel.source.endpoint.sObjectId";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_DOC = "SObject ID if required by API";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_NAME_CONF = "camel.source.endpoint.sObjectIdName";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_NAME_DOC = "SObject external ID field name";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_VALUE_CONF = "camel.source.endpoint.sObjectIdValue";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_VALUE_DOC = "SObject external ID field value";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_VALUE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_NAME_CONF = "camel.source.endpoint.sObjectName";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_NAME_DOC = "SObject name if required or supported by API";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_QUERY_CONF = "camel.source.endpoint.sObjectQuery";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_QUERY_DOC = "Salesforce SOQL query string";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_QUERY_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_SEARCH_CONF = "camel.source.endpoint.sObjectSearch";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_SEARCH_DOC = "Salesforce SOSL search string";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_SEARCH_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_UPDATE_TOPIC_CONF = "camel.source.endpoint.updateTopic";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_UPDATE_TOPIC_DOC = "Whether to update an existing Push Topic when using the Streaming API, defaults to false";
    public static final Boolean CAMEL_SOURCE_SALESFORCE_ENDPOINT_UPDATE_TOPIC_DEFAULT = false;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_SALESFORCE_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPLAY_ID_CONF = "camel.source.endpoint.replayId";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPLAY_ID_DOC = "The replayId value to use when subscribing";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPLAY_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_SALESFORCE_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_APEX_METHOD_CONF = "camel.component.salesforce.apexMethod";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_APEX_METHOD_DOC = "APEX method name";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_APEX_METHOD_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_APEX_QUERY_PARAMS_CONF = "camel.component.salesforce.apexQueryParams";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_APEX_QUERY_PARAMS_DOC = "Query params for APEX method";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_APEX_QUERY_PARAMS_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_API_VERSION_CONF = "camel.component.salesforce.apiVersion";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_API_VERSION_DOC = "Salesforce API version.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_API_VERSION_DEFAULT = "50.0";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_BACKOFF_INCREMENT_CONF = "camel.component.salesforce.backoffIncrement";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_BACKOFF_INCREMENT_DOC = "Backoff interval increment for Streaming connection restart attempts for failures beyond CometD auto-reconnect.";
    public static final Long CAMEL_SOURCE_SALESFORCE_COMPONENT_BACKOFF_INCREMENT_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_BATCH_ID_CONF = "camel.component.salesforce.batchId";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_BATCH_ID_DOC = "Bulk API Batch ID";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_BATCH_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_CONTENT_TYPE_CONF = "camel.component.salesforce.contentType";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_CONTENT_TYPE_DOC = "Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV One of: [XML] [CSV] [JSON] [ZIP_XML] [ZIP_CSV] [ZIP_JSON]";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_CONTENT_TYPE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_DEFAULT_REPLAY_ID_CONF = "camel.component.salesforce.defaultReplayId";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_DEFAULT_REPLAY_ID_DOC = "Default replayId setting if no value is found in initialReplayIdMap";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_DEFAULT_REPLAY_ID_DEFAULT = "-1";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_FORMAT_CONF = "camel.component.salesforce.format";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_FORMAT_DOC = "Payload format to use for Salesforce API calls, either JSON or XML, defaults to JSON One of: [JSON] [XML]";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_FORMAT_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_CONF = "camel.component.salesforce.httpClient";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_DOC = "Custom Jetty Http Client to use to connect to Salesforce.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_CONNECTION_TIMEOUT_CONF = "camel.component.salesforce.httpClientConnectionTimeout";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_CONNECTION_TIMEOUT_DOC = "Connection timeout used by the HttpClient when connecting to the Salesforce server.";
    public static final Long CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_CONNECTION_TIMEOUT_DEFAULT = 60000L;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_IDLE_TIMEOUT_CONF = "camel.component.salesforce.httpClientIdleTimeout";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_IDLE_TIMEOUT_DOC = "Timeout used by the HttpClient when waiting for response from the Salesforce server.";
    public static final Long CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_IDLE_TIMEOUT_DEFAULT = 10000L;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_MAX_CONTENT_LENGTH_CONF = "camel.component.salesforce.httpMaxContentLength";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_MAX_CONTENT_LENGTH_DOC = "Max content length of an HTTP response.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_MAX_CONTENT_LENGTH_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_REQUEST_BUFFER_SIZE_CONF = "camel.component.salesforce.httpRequestBufferSize";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_REQUEST_BUFFER_SIZE_DOC = "HTTP request buffer size. May need to be increased for large SOQL queries.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_REQUEST_BUFFER_SIZE_DEFAULT = "8192";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_INCLUDE_DETAILS_CONF = "camel.component.salesforce.includeDetails";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_INCLUDE_DETAILS_DOC = "Include details in Salesforce1 Analytics report, defaults to false.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_INCLUDE_DETAILS_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_INITIAL_REPLAY_ID_MAP_CONF = "camel.component.salesforce.initialReplayIdMap";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_INITIAL_REPLAY_ID_MAP_DOC = "Replay IDs to start from per channel name.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_INITIAL_REPLAY_ID_MAP_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_INSTANCE_ID_CONF = "camel.component.salesforce.instanceId";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_INSTANCE_ID_DOC = "Salesforce1 Analytics report execution instance ID";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_INSTANCE_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_JOB_ID_CONF = "camel.component.salesforce.jobId";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_JOB_ID_DOC = "Bulk API Job ID";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_JOB_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_LIMIT_CONF = "camel.component.salesforce.limit";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_LIMIT_DOC = "Limit on number of returned records. Applicable to some of the API, check the Salesforce documentation.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_LIMIT_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_MAX_BACKOFF_CONF = "camel.component.salesforce.maxBackoff";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_MAX_BACKOFF_DOC = "Maximum backoff interval for Streaming connection restart attempts for failures beyond CometD auto-reconnect.";
    public static final Long CAMEL_SOURCE_SALESFORCE_COMPONENT_MAX_BACKOFF_DEFAULT = 30000L;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOT_FOUND_BEHAVIOUR_CONF = "camel.component.salesforce.notFoundBehaviour";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOT_FOUND_BEHAVIOUR_DOC = "Sets the behaviour of 404 not found status received from Salesforce API. Should the body be set to NULL NotFoundBehaviour#NULL or should a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION - the default. One of: [EXCEPTION] [NULL]";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOT_FOUND_BEHAVIOUR_DEFAULT = "EXCEPTION";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_FIELDS_CONF = "camel.component.salesforce.notifyForFields";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_FIELDS_DOC = "Notify for fields, options are ALL, REFERENCED, SELECT, WHERE One of: [ALL] [REFERENCED] [SELECT] [WHERE]";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_FIELDS_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_CREATE_CONF = "camel.component.salesforce.notifyForOperationCreate";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_CREATE_DOC = "Notify for create operation, defaults to false (API version = 29.0)";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_CREATE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_DELETE_CONF = "camel.component.salesforce.notifyForOperationDelete";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_DELETE_DOC = "Notify for delete operation, defaults to false (API version = 29.0)";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_DELETE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATIONS_CONF = "camel.component.salesforce.notifyForOperations";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATIONS_DOC = "Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API version 29.0) One of: [ALL] [CREATE] [EXTENDED] [UPDATE]";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_UNDELETE_CONF = "camel.component.salesforce.notifyForOperationUndelete";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_UNDELETE_DOC = "Notify for un-delete operation, defaults to false (API version = 29.0)";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_UNDELETE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_UPDATE_CONF = "camel.component.salesforce.notifyForOperationUpdate";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_UPDATE_DOC = "Notify for update operation, defaults to false (API version = 29.0)";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_UPDATE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_OBJECT_MAPPER_CONF = "camel.component.salesforce.objectMapper";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_OBJECT_MAPPER_DOC = "Custom Jackson ObjectMapper to use when serializing/deserializing Salesforce objects.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_OBJECT_MAPPER_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PACKAGES_CONF = "camel.component.salesforce.packages";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PACKAGES_DOC = "In what packages are the generated DTO classes. Typically the classes would be generated using camel-salesforce-maven-plugin. This must be set if using the XML format. Also, set it if using the generated DTOs to gain the benefit of using short SObject names in parameters/header values. Multiple packages can be separated by comma.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PACKAGES_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_CONF = "camel.component.salesforce.pkChunking";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_DOC = "Use PK Chunking. Only for use in original Bulk API. Bulk 2.0 API performs PK chunking automatically, if necessary.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_CHUNK_SIZE_CONF = "camel.component.salesforce.pkChunkingChunkSize";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_CHUNK_SIZE_DOC = "Chunk size for use with PK Chunking. If unspecified, salesforce default is 100,000. Maximum size is 250,000.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_CHUNK_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_PARENT_CONF = "camel.component.salesforce.pkChunkingParent";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_PARENT_DOC = "Specifies the parent object when you're enabling PK chunking for queries on sharing objects. The chunks are based on the parent object's records rather than the sharing object's records. For example, when querying on AccountShare, specify Account as the parent object. PK chunking is supported for sharing objects as long as the parent object is supported.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_PARENT_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_START_ROW_CONF = "camel.component.salesforce.pkChunkingStartRow";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_START_ROW_DOC = "Specifies the 15-character or 18-character record ID to be used as the lower boundary for the first chunk. Use this parameter to specify a starting ID when restarting a job that failed between batches.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_START_ROW_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_QUERY_LOCATOR_CONF = "camel.component.salesforce.queryLocator";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_QUERY_LOCATOR_DOC = "Query Locator provided by salesforce for use when a query results in more records than can be retrieved in a single call. Use this value in a subsequent call to retrieve additional records.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_QUERY_LOCATOR_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_RAW_PAYLOAD_CONF = "camel.component.salesforce.rawPayload";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_RAW_PAYLOAD_DOC = "Use raw payload String for request and response (either JSON or XML depending on format), instead of DTOs, false by default";
    public static final Boolean CAMEL_SOURCE_SALESFORCE_COMPONENT_RAW_PAYLOAD_DEFAULT = false;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_REPORT_ID_CONF = "camel.component.salesforce.reportId";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_REPORT_ID_DOC = "Salesforce1 Analytics report Id";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_REPORT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_REPORT_METADATA_CONF = "camel.component.salesforce.reportMetadata";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_REPORT_METADATA_DOC = "Salesforce1 Analytics report metadata for filtering";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_REPORT_METADATA_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_RESULT_ID_CONF = "camel.component.salesforce.resultId";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_RESULT_ID_DOC = "Bulk API Result ID";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_RESULT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_BLOB_FIELD_NAME_CONF = "camel.component.salesforce.sObjectBlobFieldName";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_BLOB_FIELD_NAME_DOC = "SObject blob field name";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_BLOB_FIELD_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_CLASS_CONF = "camel.component.salesforce.sObjectClass";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_CLASS_DOC = "Fully qualified SObject class name, usually generated using camel-salesforce-maven-plugin";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_CLASS_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_FIELDS_CONF = "camel.component.salesforce.sObjectFields";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_FIELDS_DOC = "SObject fields to retrieve";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_FIELDS_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_CONF = "camel.component.salesforce.sObjectId";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_DOC = "SObject ID if required by API";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_NAME_CONF = "camel.component.salesforce.sObjectIdName";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_NAME_DOC = "SObject external ID field name";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_VALUE_CONF = "camel.component.salesforce.sObjectIdValue";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_VALUE_DOC = "SObject external ID field value";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_VALUE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_NAME_CONF = "camel.component.salesforce.sObjectName";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_NAME_DOC = "SObject name if required or supported by API";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_QUERY_CONF = "camel.component.salesforce.sObjectQuery";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_QUERY_DOC = "Salesforce SOQL query string";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_QUERY_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_SEARCH_CONF = "camel.component.salesforce.sObjectSearch";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_SEARCH_DOC = "Salesforce SOSL search string";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_SEARCH_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_UPDATE_TOPIC_CONF = "camel.component.salesforce.updateTopic";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_UPDATE_TOPIC_DOC = "Whether to update an existing Push Topic when using the Streaming API, defaults to false";
    public static final Boolean CAMEL_SOURCE_SALESFORCE_COMPONENT_UPDATE_TOPIC_DEFAULT = false;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_CONFIG_CONF = "camel.component.salesforce.config";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_CONFIG_DOC = "Global endpoint configuration - use to set values that are common to all endpoints";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_CONFIG_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_PROPERTIES_CONF = "camel.component.salesforce.httpClientProperties";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_PROPERTIES_DOC = "Used to set any properties that can be configured on the underlying HTTP client. Have a look at properties of SalesforceHttpClient and the Jetty HttpClient for all available options.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_LONG_POLLING_TRANSPORT_PROPERTIES_CONF = "camel.component.salesforce.longPollingTransportProperties";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_LONG_POLLING_TRANSPORT_PROPERTIES_DOC = "Used to set any properties that can be configured on the LongPollingTransport used by the BayeuxClient (CometD) used by the streaming api";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_LONG_POLLING_TRANSPORT_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.salesforce.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_SALESFORCE_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.salesforce.autowiredEnabled";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_SALESFORCE_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_EXCLUDED_ADDRESSES_CONF = "camel.component.salesforce.httpProxyExcludedAddresses";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_EXCLUDED_ADDRESSES_DOC = "A list of addresses for which HTTP proxy server should not be used.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_EXCLUDED_ADDRESSES_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_HOST_CONF = "camel.component.salesforce.httpProxyHost";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_HOST_DOC = "Hostname of the HTTP proxy server to use.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_HOST_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_INCLUDED_ADDRESSES_CONF = "camel.component.salesforce.httpProxyIncludedAddresses";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_INCLUDED_ADDRESSES_DOC = "A list of addresses for which HTTP proxy server should be used.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_INCLUDED_ADDRESSES_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_PORT_CONF = "camel.component.salesforce.httpProxyPort";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_PORT_DOC = "Port number of the HTTP proxy server to use.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_PORT_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_SOCKS_4CONF = "camel.component.salesforce.httpProxySocks4";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_SOCKS_4DOC = "If set to true the configures the HTTP proxy to use as a SOCKS4 proxy.";
    public static final Boolean CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_SOCKS_4DEFAULT = false;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_AUTHENTICATION_TYPE_CONF = "camel.component.salesforce.authenticationType";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_AUTHENTICATION_TYPE_DOC = "Explicit authentication method to be used, one of USERNAME_PASSWORD, REFRESH_TOKEN or JWT. Salesforce component can auto-determine the authentication method to use from the properties set, set this property to eliminate any ambiguity. One of: [USERNAME_PASSWORD] [REFRESH_TOKEN] [JWT]";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_AUTHENTICATION_TYPE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_CLIENT_ID_CONF = "camel.component.salesforce.clientId";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_CLIENT_ID_DOC = "OAuth Consumer Key of the connected app configured in the Salesforce instance setup. Typically a connected app needs to be configured but one can be provided by installing a package.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_CLIENT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_CLIENT_SECRET_CONF = "camel.component.salesforce.clientSecret";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_CLIENT_SECRET_DOC = "OAuth Consumer Secret of the connected app configured in the Salesforce instance setup.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_CLIENT_SECRET_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_AUTH_URI_CONF = "camel.component.salesforce.httpProxyAuthUri";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_AUTH_URI_DOC = "Used in authentication against the HTTP proxy server, needs to match the URI of the proxy server in order for the httpProxyUsername and httpProxyPassword to be used for authentication.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_AUTH_URI_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_PASSWORD_CONF = "camel.component.salesforce.httpProxyPassword";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_PASSWORD_DOC = "Password to use to authenticate against the HTTP proxy server.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_REALM_CONF = "camel.component.salesforce.httpProxyRealm";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_REALM_DOC = "Realm of the proxy server, used in preemptive Basic/Digest authentication methods against the HTTP proxy server.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_REALM_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_SECURE_CONF = "camel.component.salesforce.httpProxySecure";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_SECURE_DOC = "If set to false disables the use of TLS when accessing the HTTP proxy.";
    public static final Boolean CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_SECURE_DEFAULT = true;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_USE_DIGEST_AUTH_CONF = "camel.component.salesforce.httpProxyUseDigestAuth";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_USE_DIGEST_AUTH_DOC = "If set to true Digest authentication will be used when authenticating to the HTTP proxy, otherwise Basic authorization method will be used";
    public static final Boolean CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_USE_DIGEST_AUTH_DEFAULT = false;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_USERNAME_CONF = "camel.component.salesforce.httpProxyUsername";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_USERNAME_DOC = "Username to use to authenticate against the HTTP proxy server.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_USERNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_INSTANCE_URL_CONF = "camel.component.salesforce.instanceUrl";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_INSTANCE_URL_DOC = "URL of the Salesforce instance used after authentication, by default received from Salesforce on successful authentication";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_INSTANCE_URL_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_KEYSTORE_CONF = "camel.component.salesforce.keystore";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_KEYSTORE_DOC = "KeyStore parameters to use in OAuth JWT flow. The KeyStore should contain only one entry with private key and certificate. Salesforce does not verify the certificate chain, so this can easily be a selfsigned certificate. Make sure that you upload the certificate to the corresponding connected app.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_KEYSTORE_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_LAZY_LOGIN_CONF = "camel.component.salesforce.lazyLogin";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_LAZY_LOGIN_DOC = "If set to true prevents the component from authenticating to Salesforce with the start of the component. You would generally set this to the (default) false and authenticate early and be immediately aware of any authentication issues.";
    public static final Boolean CAMEL_SOURCE_SALESFORCE_COMPONENT_LAZY_LOGIN_DEFAULT = false;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_LOGIN_CONFIG_CONF = "camel.component.salesforce.loginConfig";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_LOGIN_CONFIG_DOC = "All authentication configuration in one nested bean, all properties set there can be set directly on the component as well";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_LOGIN_CONFIG_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_LOGIN_URL_CONF = "camel.component.salesforce.loginUrl";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_LOGIN_URL_DOC = "URL of the Salesforce instance used for authentication, by default set to https://login.salesforce.com";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_LOGIN_URL_DEFAULT = "https://login.salesforce.com";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PASSWORD_CONF = "camel.component.salesforce.password";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PASSWORD_DOC = "Password used in OAuth flow to gain access to access token. It's easy to get started with password OAuth flow, but in general one should avoid it as it is deemed less secure than other flows. Make sure that you append security token to the end of the password if using one.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_REFRESH_TOKEN_CONF = "camel.component.salesforce.refreshToken";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_REFRESH_TOKEN_DOC = "Refresh token already obtained in the refresh token OAuth flow. One needs to setup a web application and configure a callback URL to receive the refresh token, or configure using the builtin callback at https://login.salesforce.com/services/oauth2/success or https://test.salesforce.com/services/oauth2/success and then retrive the refresh_token from the URL at the end of the flow. Note that in development organizations Salesforce allows hosting the callback web application at localhost.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_REFRESH_TOKEN_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SSL_CONTEXT_PARAMETERS_CONF = "camel.component.salesforce.sslContextParameters";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SSL_CONTEXT_PARAMETERS_DOC = "SSL parameters to use, see SSLContextParameters class for all available options.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_SSL_CONTEXT_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF = "camel.component.salesforce.useGlobalSslContextParameters";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC = "Enable usage of global SSL context parameters";
    public static final Boolean CAMEL_SOURCE_SALESFORCE_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT = false;
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_USER_NAME_CONF = "camel.component.salesforce.userName";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_USER_NAME_DOC = "Username used in OAuth flow to gain access to access token. It's easy to get started with password OAuth flow, but in general one should avoid it as it is deemed less secure than other flows.";
    public static final String CAMEL_SOURCE_SALESFORCE_COMPONENT_USER_NAME_DEFAULT = null;

    public CamelSalesforceSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelSalesforceSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_SALESFORCE_PATH_TOPIC_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_PATH_TOPIC_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_PATH_TOPIC_NAME_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_APEX_METHOD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_APEX_METHOD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_APEX_METHOD_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_APEX_QUERY_PARAMS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_APEX_QUERY_PARAMS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_APEX_QUERY_PARAMS_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_API_VERSION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_API_VERSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_API_VERSION_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_BACKOFF_INCREMENT_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_SALESFORCE_ENDPOINT_BACKOFF_INCREMENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_BACKOFF_INCREMENT_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_BATCH_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_BATCH_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_BATCH_ID_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_CONTENT_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_CONTENT_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_CONTENT_TYPE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_DEFAULT_REPLAY_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_DEFAULT_REPLAY_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_DEFAULT_REPLAY_ID_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_FORMAT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_FORMAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_FORMAT_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_HTTP_CLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_HTTP_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_HTTP_CLIENT_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_INCLUDE_DETAILS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_INCLUDE_DETAILS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_INCLUDE_DETAILS_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_INITIAL_REPLAY_ID_MAP_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_INITIAL_REPLAY_ID_MAP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_INITIAL_REPLAY_ID_MAP_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_INSTANCE_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_INSTANCE_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_INSTANCE_ID_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_JOB_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_JOB_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_JOB_ID_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_LIMIT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_LIMIT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_LIMIT_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_MAX_BACKOFF_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_SALESFORCE_ENDPOINT_MAX_BACKOFF_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_MAX_BACKOFF_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOT_FOUND_BEHAVIOUR_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOT_FOUND_BEHAVIOUR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOT_FOUND_BEHAVIOUR_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_FIELDS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_FIELDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_FIELDS_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_CREATE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_CREATE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_CREATE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_DELETE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_DELETE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_DELETE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATIONS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATIONS_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_UNDELETE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_UNDELETE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_UNDELETE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_UPDATE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_UPDATE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_NOTIFY_FOR_OPERATION_UPDATE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_OBJECT_MAPPER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_OBJECT_MAPPER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_OBJECT_MAPPER_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_CHUNK_SIZE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_CHUNK_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_CHUNK_SIZE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_PARENT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_PARENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_PARENT_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_START_ROW_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_START_ROW_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_PK_CHUNKING_START_ROW_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_QUERY_LOCATOR_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_QUERY_LOCATOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_QUERY_LOCATOR_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_RAW_PAYLOAD_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SALESFORCE_ENDPOINT_RAW_PAYLOAD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_RAW_PAYLOAD_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPORT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPORT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPORT_ID_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPORT_METADATA_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPORT_METADATA_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPORT_METADATA_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_RESULT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_RESULT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_RESULT_ID_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_BLOB_FIELD_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_BLOB_FIELD_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_BLOB_FIELD_NAME_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_CLASS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_CLASS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_CLASS_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_FIELDS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_FIELDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_FIELDS_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_NAME_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_VALUE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_VALUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_ID_VALUE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_NAME_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_QUERY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_QUERY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_QUERY_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_SEARCH_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_SEARCH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_SOBJECT_SEARCH_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_UPDATE_TOPIC_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SALESFORCE_ENDPOINT_UPDATE_TOPIC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_UPDATE_TOPIC_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SALESFORCE_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPLAY_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPLAY_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_REPLAY_ID_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_APEX_METHOD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_APEX_METHOD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_APEX_METHOD_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_APEX_QUERY_PARAMS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_APEX_QUERY_PARAMS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_APEX_QUERY_PARAMS_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_API_VERSION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_API_VERSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_API_VERSION_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_BACKOFF_INCREMENT_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_SALESFORCE_COMPONENT_BACKOFF_INCREMENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_BACKOFF_INCREMENT_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_BATCH_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_BATCH_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_BATCH_ID_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_CONTENT_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_CONTENT_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_CONTENT_TYPE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_DEFAULT_REPLAY_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_DEFAULT_REPLAY_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_DEFAULT_REPLAY_ID_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_FORMAT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_FORMAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_FORMAT_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_CONNECTION_TIMEOUT_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_CONNECTION_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_CONNECTION_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_IDLE_TIMEOUT_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_IDLE_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_IDLE_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_MAX_CONTENT_LENGTH_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_MAX_CONTENT_LENGTH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_MAX_CONTENT_LENGTH_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_REQUEST_BUFFER_SIZE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_REQUEST_BUFFER_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_REQUEST_BUFFER_SIZE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_INCLUDE_DETAILS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_INCLUDE_DETAILS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_INCLUDE_DETAILS_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_INITIAL_REPLAY_ID_MAP_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_INITIAL_REPLAY_ID_MAP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_INITIAL_REPLAY_ID_MAP_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_INSTANCE_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_INSTANCE_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_INSTANCE_ID_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_JOB_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_JOB_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_JOB_ID_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_LIMIT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_LIMIT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_LIMIT_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_MAX_BACKOFF_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_SALESFORCE_COMPONENT_MAX_BACKOFF_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_MAX_BACKOFF_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_NOT_FOUND_BEHAVIOUR_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_NOT_FOUND_BEHAVIOUR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_NOT_FOUND_BEHAVIOUR_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_FIELDS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_FIELDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_FIELDS_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_CREATE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_CREATE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_CREATE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_DELETE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_DELETE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_DELETE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATIONS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATIONS_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_UNDELETE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_UNDELETE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_UNDELETE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_UPDATE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_UPDATE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_NOTIFY_FOR_OPERATION_UPDATE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_OBJECT_MAPPER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_OBJECT_MAPPER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_OBJECT_MAPPER_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_PACKAGES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_PACKAGES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_PACKAGES_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_CHUNK_SIZE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_CHUNK_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_CHUNK_SIZE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_PARENT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_PARENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_PARENT_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_START_ROW_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_START_ROW_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_PK_CHUNKING_START_ROW_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_QUERY_LOCATOR_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_QUERY_LOCATOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_QUERY_LOCATOR_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_RAW_PAYLOAD_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SALESFORCE_COMPONENT_RAW_PAYLOAD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_RAW_PAYLOAD_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_REPORT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_REPORT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_REPORT_ID_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_REPORT_METADATA_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_REPORT_METADATA_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_REPORT_METADATA_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_RESULT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_RESULT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_RESULT_ID_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_BLOB_FIELD_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_BLOB_FIELD_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_BLOB_FIELD_NAME_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_CLASS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_CLASS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_CLASS_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_FIELDS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_FIELDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_FIELDS_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_NAME_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_VALUE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_VALUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_ID_VALUE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_NAME_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_QUERY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_QUERY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_QUERY_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_SEARCH_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_SEARCH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_SOBJECT_SEARCH_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_UPDATE_TOPIC_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SALESFORCE_COMPONENT_UPDATE_TOPIC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_UPDATE_TOPIC_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_CONFIG_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_CONFIG_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_CONFIG_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_CLIENT_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_LONG_POLLING_TRANSPORT_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_LONG_POLLING_TRANSPORT_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_LONG_POLLING_TRANSPORT_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SALESFORCE_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SALESFORCE_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_EXCLUDED_ADDRESSES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_EXCLUDED_ADDRESSES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_EXCLUDED_ADDRESSES_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_HOST_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_INCLUDED_ADDRESSES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_INCLUDED_ADDRESSES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_INCLUDED_ADDRESSES_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_PORT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_PORT_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_SOCKS_4CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_SOCKS_4DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_SOCKS_4DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_AUTHENTICATION_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_AUTHENTICATION_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_AUTHENTICATION_TYPE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_CLIENT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_CLIENT_ID_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_SALESFORCE_COMPONENT_CLIENT_ID_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_CLIENT_SECRET_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_CLIENT_SECRET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_CLIENT_SECRET_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_AUTH_URI_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_AUTH_URI_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_AUTH_URI_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_REALM_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_REALM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_REALM_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_SECURE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_SECURE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_SECURE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_USE_DIGEST_AUTH_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_USE_DIGEST_AUTH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_USE_DIGEST_AUTH_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_HTTP_PROXY_USERNAME_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_INSTANCE_URL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_INSTANCE_URL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_INSTANCE_URL_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_KEYSTORE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_KEYSTORE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_KEYSTORE_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_LAZY_LOGIN_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SALESFORCE_COMPONENT_LAZY_LOGIN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_LAZY_LOGIN_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_LOGIN_CONFIG_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_LOGIN_CONFIG_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_LOGIN_CONFIG_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_LOGIN_URL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_LOGIN_URL_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_SALESFORCE_COMPONENT_LOGIN_URL_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_REFRESH_TOKEN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_REFRESH_TOKEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_REFRESH_TOKEN_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_SSL_CONTEXT_PARAMETERS_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SALESFORCE_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC);
        conf.define(CAMEL_SOURCE_SALESFORCE_COMPONENT_USER_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SALESFORCE_COMPONENT_USER_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SALESFORCE_COMPONENT_USER_NAME_DOC);
        return conf;
    }
}