/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.stream;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelStreamSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_STREAM_PATH_KIND_CONF = "camel.sink.path.kind";
    public static final String CAMEL_SINK_STREAM_PATH_KIND_DOC = "Kind of stream to use such as System.in or System.out. One of: [in] [out] [err] [header] [file]";
    public static final String CAMEL_SINK_STREAM_PATH_KIND_DEFAULT = null;
    public static final String CAMEL_SINK_STREAM_ENDPOINT_ENCODING_CONF = "camel.sink.endpoint.encoding";
    public static final String CAMEL_SINK_STREAM_ENDPOINT_ENCODING_DOC = "You can configure the encoding (is a charset name) to use text-based streams (for example, message body is a String object). If not provided, Camel uses the JVM default Charset.";
    public static final String CAMEL_SINK_STREAM_ENDPOINT_ENCODING_DEFAULT = null;
    public static final String CAMEL_SINK_STREAM_ENDPOINT_FILE_NAME_CONF = "camel.sink.endpoint.fileName";
    public static final String CAMEL_SINK_STREAM_ENDPOINT_FILE_NAME_DOC = "When using the stream:file URI format, this option specifies the filename to stream to/from.";
    public static final String CAMEL_SINK_STREAM_ENDPOINT_FILE_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_STREAM_ENDPOINT_AUTO_CLOSE_COUNT_CONF = "camel.sink.endpoint.autoCloseCount";
    public static final String CAMEL_SINK_STREAM_ENDPOINT_AUTO_CLOSE_COUNT_DOC = "Number of messages to process before closing stream on Producer side. Never close stream by default (only when Producer is stopped). If more messages are sent, the stream is reopened for another autoCloseCount batch.";
    public static final Integer CAMEL_SINK_STREAM_ENDPOINT_AUTO_CLOSE_COUNT_DEFAULT = null;
    public static final String CAMEL_SINK_STREAM_ENDPOINT_CLOSE_ON_DONE_CONF = "camel.sink.endpoint.closeOnDone";
    public static final String CAMEL_SINK_STREAM_ENDPOINT_CLOSE_ON_DONE_DOC = "This option is used in combination with Splitter and streaming to the same file. The idea is to keep the stream open and only close when the Splitter is done, to improve performance. Mind this requires that you only stream to the same file, and not 2 or more files.";
    public static final Boolean CAMEL_SINK_STREAM_ENDPOINT_CLOSE_ON_DONE_DEFAULT = false;
    public static final String CAMEL_SINK_STREAM_ENDPOINT_DELAY_CONF = "camel.sink.endpoint.delay";
    public static final String CAMEL_SINK_STREAM_ENDPOINT_DELAY_DOC = "Initial delay in milliseconds before producing the stream.";
    public static final Long CAMEL_SINK_STREAM_ENDPOINT_DELAY_DEFAULT = null;
    public static final String CAMEL_SINK_STREAM_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_STREAM_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_STREAM_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_STREAM_ENDPOINT_READ_TIMEOUT_CONF = "camel.sink.endpoint.readTimeout";
    public static final String CAMEL_SINK_STREAM_ENDPOINT_READ_TIMEOUT_DOC = "Sets the read timeout to a specified timeout, in milliseconds. A non-zero value specifies the timeout when reading from Input stream when a connection is established to a resource. If the timeout expires before there is data available for read, a java.net.SocketTimeoutException is raised. A timeout of zero is interpreted as an infinite timeout.";
    public static final Integer CAMEL_SINK_STREAM_ENDPOINT_READ_TIMEOUT_DEFAULT = null;
    public static final String CAMEL_SINK_STREAM_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_STREAM_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_STREAM_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_STREAM_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.stream.lazyStartProducer";
    public static final String CAMEL_SINK_STREAM_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_STREAM_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_STREAM_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.stream.autowiredEnabled";
    public static final String CAMEL_SINK_STREAM_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_STREAM_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;

    public CamelStreamSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelStreamSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_STREAM_PATH_KIND_CONF, ConfigDef.Type.STRING, CAMEL_SINK_STREAM_PATH_KIND_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_STREAM_PATH_KIND_DOC);
        conf.define(CAMEL_SINK_STREAM_ENDPOINT_ENCODING_CONF, ConfigDef.Type.STRING, CAMEL_SINK_STREAM_ENDPOINT_ENCODING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_STREAM_ENDPOINT_ENCODING_DOC);
        conf.define(CAMEL_SINK_STREAM_ENDPOINT_FILE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_STREAM_ENDPOINT_FILE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_STREAM_ENDPOINT_FILE_NAME_DOC);
        conf.define(CAMEL_SINK_STREAM_ENDPOINT_AUTO_CLOSE_COUNT_CONF, ConfigDef.Type.INT, CAMEL_SINK_STREAM_ENDPOINT_AUTO_CLOSE_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_STREAM_ENDPOINT_AUTO_CLOSE_COUNT_DOC);
        conf.define(CAMEL_SINK_STREAM_ENDPOINT_CLOSE_ON_DONE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_STREAM_ENDPOINT_CLOSE_ON_DONE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_STREAM_ENDPOINT_CLOSE_ON_DONE_DOC);
        conf.define(CAMEL_SINK_STREAM_ENDPOINT_DELAY_CONF, ConfigDef.Type.LONG, CAMEL_SINK_STREAM_ENDPOINT_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_STREAM_ENDPOINT_DELAY_DOC);
        conf.define(CAMEL_SINK_STREAM_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_STREAM_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_STREAM_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_STREAM_ENDPOINT_READ_TIMEOUT_CONF, ConfigDef.Type.INT, CAMEL_SINK_STREAM_ENDPOINT_READ_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_STREAM_ENDPOINT_READ_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_STREAM_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_STREAM_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_STREAM_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_STREAM_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_STREAM_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_STREAM_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_STREAM_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_STREAM_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_STREAM_COMPONENT_AUTOWIRED_ENABLED_DOC);
        return conf;
    }
}