/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.rabbitmq;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelRabbitmqSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_RABBITMQ_PATH_EXCHANGE_NAME_CONF = "camel.sink.path.exchangeName";
    public static final String CAMEL_SINK_RABBITMQ_PATH_EXCHANGE_NAME_DOC = "The exchange name determines the exchange to which the produced messages will be sent to. In the case of consumers, the exchange name determines the exchange the queue will be bound to.";
    public static final String CAMEL_SINK_RABBITMQ_PATH_EXCHANGE_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ADDRESSES_CONF = "camel.sink.endpoint.addresses";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ADDRESSES_DOC = "If this option is set, camel-rabbitmq will try to create connection based on the setting of option addresses. The addresses value is a string which looks like server1:12345, server2:12345";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ADDRESSES_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_AUTO_DELETE_CONF = "camel.sink.endpoint.autoDelete";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_AUTO_DELETE_DOC = "If it is true, the exchange will be deleted when it is no longer in use";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_AUTO_DELETE_DEFAULT = true;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_AUTOMATIC_RECOVERY_ENABLED_CONF = "camel.sink.endpoint.automaticRecoveryEnabled";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_AUTOMATIC_RECOVERY_ENABLED_DOC = "Enables connection automatic recovery (uses connection implementation that performs automatic recovery when existing connection has failures)";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_AUTOMATIC_RECOVERY_ENABLED_DEFAULT = "true";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_CONF = "camel.sink.endpoint.connectionFactory";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_DOC = "To use a custom RabbitMQ connection factory. When this option is set, all connection options (connectionTimeout, requestedChannelMax...) set on URI are not used";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_CONF = "camel.sink.endpoint.deadLetterExchange";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_DOC = "The name of the dead letter exchange";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_TYPE_CONF = "camel.sink.endpoint.deadLetterExchangeType";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_TYPE_DOC = "The type of the dead letter exchange One of: [direct] [fanout] [headers] [topic]";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_TYPE_DEFAULT = "direct";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_QUEUE_CONF = "camel.sink.endpoint.deadLetterQueue";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_QUEUE_DOC = "The name of the dead letter queue";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_QUEUE_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_ROUTING_KEY_CONF = "camel.sink.endpoint.deadLetterRoutingKey";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_ROUTING_KEY_DOC = "The routing key for the dead letter exchange";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_ROUTING_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_DECLARE_CONF = "camel.sink.endpoint.declare";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_DECLARE_DOC = "If the option is true, camel declare the exchange and queue name and bind them together. If the option is false, camel won't declare the exchange and queue name on the server.";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_DECLARE_DEFAULT = true;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_DURABLE_CONF = "camel.sink.endpoint.durable";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_DURABLE_DOC = "If we are declaring a durable exchange (the exchange will survive a server restart)";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_DURABLE_DEFAULT = true;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_EXCHANGE_TYPE_CONF = "camel.sink.endpoint.exchangeType";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_EXCHANGE_TYPE_DOC = "The exchange type such as direct or topic. One of: [direct] [fanout] [headers] [topic]";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_EXCHANGE_TYPE_DEFAULT = "direct";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_EXCLUSIVE_CONF = "camel.sink.endpoint.exclusive";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_EXCLUSIVE_DOC = "Exclusive queues may only be accessed by the current connection, and are deleted when that connection closes.";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_EXCLUSIVE_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_HOSTNAME_CONF = "camel.sink.endpoint.hostname";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_HOSTNAME_DOC = "The hostname of the running rabbitmq instance or cluster.";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_HOSTNAME_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_PASSIVE_CONF = "camel.sink.endpoint.passive";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_PASSIVE_DOC = "Passive queues depend on the queue already to be available at RabbitMQ.";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_PASSIVE_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_PORT_NUMBER_CONF = "camel.sink.endpoint.portNumber";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_PORT_NUMBER_DOC = "Port number for the host with the running rabbitmq instance or cluster. Default value is 5672.";
    public static final Integer CAMEL_SINK_RABBITMQ_ENDPOINT_PORT_NUMBER_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_QUEUE_CONF = "camel.sink.endpoint.queue";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_QUEUE_DOC = "The queue to receive messages from";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_QUEUE_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ROUTING_KEY_CONF = "camel.sink.endpoint.routingKey";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ROUTING_KEY_DOC = "The routing key to use when binding a consumer queue to the exchange. For producer routing keys, you set the header rabbitmq.ROUTING_KEY.";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ROUTING_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_DLQ_DECLARE_CONF = "camel.sink.endpoint.skipDlqDeclare";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_DLQ_DECLARE_DOC = "If true the producer will not declare and bind a dead letter queue. This can be used if you have also DLQ rabbitmq consumer and you want to avoid argument clashing between Producer and Consumer. This option have no effect, if DLQ configured (deadLetterExchange option is not set).";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_DLQ_DECLARE_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_EXCHANGE_DECLARE_CONF = "camel.sink.endpoint.skipExchangeDeclare";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_EXCHANGE_DECLARE_DOC = "This can be used if we need to declare the queue but not the exchange";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_EXCHANGE_DECLARE_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_QUEUE_BIND_CONF = "camel.sink.endpoint.skipQueueBind";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_QUEUE_BIND_DOC = "If true the queue will not be bound to the exchange after declaring it";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_QUEUE_BIND_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_QUEUE_DECLARE_CONF = "camel.sink.endpoint.skipQueueDeclare";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_QUEUE_DECLARE_DOC = "If true the producer will not declare and bind a queue. This can be used for directing messages via an existing routing key.";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_QUEUE_DECLARE_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_VHOST_CONF = "camel.sink.endpoint.vhost";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_VHOST_DOC = "The vhost for the channel";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_VHOST_DEFAULT = "/";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ADDITIONAL_HEADERS_CONF = "camel.sink.endpoint.additionalHeaders";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ADDITIONAL_HEADERS_DOC = "Map of additional headers. These headers will be set only when the 'allowCustomHeaders' is set to true";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ADDITIONAL_HEADERS_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ADDITIONAL_PROPERTIES_CONF = "camel.sink.endpoint.additionalProperties";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ADDITIONAL_PROPERTIES_DOC = "Map of additional properties. These are standard RabbitMQ properties as defined in com.rabbitmq.client.AMQP.BasicProperties. The map keys should be from org.apache.camel.component.rabbitmq.RabbitMQConstants. Any other keys will be ignored.";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ADDITIONAL_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_CUSTOM_HEADERS_CONF = "camel.sink.endpoint.allowCustomHeaders";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_CUSTOM_HEADERS_DOC = "Allow pass custom values to header";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_CUSTOM_HEADERS_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_NULL_HEADERS_CONF = "camel.sink.endpoint.allowNullHeaders";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_NULL_HEADERS_DOC = "Allow pass null values to header";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_NULL_HEADERS_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_BRIDGE_ENDPOINT_CONF = "camel.sink.endpoint.bridgeEndpoint";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_BRIDGE_ENDPOINT_DOC = "If the bridgeEndpoint is true, the producer will ignore the message header of rabbitmq.EXCHANGE_NAME and rabbitmq.ROUTING_KEY";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_BRIDGE_ENDPOINT_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_CHANNEL_POOL_MAX_SIZE_CONF = "camel.sink.endpoint.channelPoolMaxSize";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_CHANNEL_POOL_MAX_SIZE_DOC = "Get maximum number of opened channel in pool";
    public static final Integer CAMEL_SINK_RABBITMQ_ENDPOINT_CHANNEL_POOL_MAX_SIZE_DEFAULT = 10;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_CHANNEL_POOL_MAX_WAIT_CONF = "camel.sink.endpoint.channelPoolMaxWait";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_CHANNEL_POOL_MAX_WAIT_DOC = "Set the maximum number of milliseconds to wait for a channel from the pool";
    public static final Long CAMEL_SINK_RABBITMQ_ENDPOINT_CHANNEL_POOL_MAX_WAIT_DEFAULT = 1000L;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_GUARANTEED_DELIVERIES_CONF = "camel.sink.endpoint.guaranteedDeliveries";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_GUARANTEED_DELIVERIES_DOC = "When true, an exception will be thrown when the message cannot be delivered (basic.return) and the message is marked as mandatory. PublisherAcknowledgement will also be activated in this case. See also publisher acknowledgements - When will messages be confirmed.";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_GUARANTEED_DELIVERIES_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_IMMEDIATE_CONF = "camel.sink.endpoint.immediate";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_IMMEDIATE_DOC = "This flag tells the server how to react if the message cannot be routed to a queue consumer immediately. If this flag is set, the server will return an undeliverable message with a Return method. If this flag is zero, the server will queue the message, but with no guarantee that it will ever be consumed. If the header is present rabbitmq.IMMEDIATE it will override this option.";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_IMMEDIATE_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_MANDATORY_CONF = "camel.sink.endpoint.mandatory";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_MANDATORY_DOC = "This flag tells the server how to react if the message cannot be routed to a queue. If this flag is set, the server will return an unroutable message with a Return method. If this flag is zero, the server silently drops the message. If the header is present rabbitmq.MANDATORY it will override this option.";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_MANDATORY_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_PUBLISHER_ACKNOWLEDGEMENTS_CONF = "camel.sink.endpoint.publisherAcknowledgements";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_PUBLISHER_ACKNOWLEDGEMENTS_DOC = "When true, the message will be published with publisher acknowledgements turned on";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_PUBLISHER_ACKNOWLEDGEMENTS_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_PUBLISHER_ACKNOWLEDGEMENTS_TIMEOUT_CONF = "camel.sink.endpoint.publisherAcknowledgementsTimeout";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_PUBLISHER_ACKNOWLEDGEMENTS_TIMEOUT_DOC = "The amount of time in milliseconds to wait for a basic.ack response from RabbitMQ server";
    public static final Long CAMEL_SINK_RABBITMQ_ENDPOINT_PUBLISHER_ACKNOWLEDGEMENTS_TIMEOUT_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ARGS_CONF = "camel.sink.endpoint.args";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ARGS_DOC = "Specify arguments for configuring the different RabbitMQ concepts, a different prefix is required for each: Exchange: arg.exchange. Queue: arg.queue. Binding: arg.binding. DLQ: arg.dlq.queue. DLQ binding: arg.dlq.binding. For example to declare a queue with message ttl argument: http://localhost:5672/exchange/queueargs=arg.queue.x-message-ttl=60000";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ARGS_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_CLIENT_PROPERTIES_CONF = "camel.sink.endpoint.clientProperties";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_CLIENT_PROPERTIES_DOC = "Connection client properties (client info used in negotiating with the server)";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_CLIENT_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_EXCEPTION_HANDLER_CONF = "camel.sink.endpoint.connectionFactoryExceptionHandler";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_EXCEPTION_HANDLER_DOC = "Custom rabbitmq ExceptionHandler for ConnectionFactory";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_TIMEOUT_CONF = "camel.sink.endpoint.connectionTimeout";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_TIMEOUT_DOC = "Connection timeout";
    public static final Integer CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_TIMEOUT_DEFAULT = 60000;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_NETWORK_RECOVERY_INTERVAL_CONF = "camel.sink.endpoint.networkRecoveryInterval";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_NETWORK_RECOVERY_INTERVAL_DOC = "Network recovery interval in milliseconds (interval used when recovering from network failure)";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_NETWORK_RECOVERY_INTERVAL_DEFAULT = "5000";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_CHANNEL_MAX_CONF = "camel.sink.endpoint.requestedChannelMax";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_CHANNEL_MAX_DOC = "Connection requested channel max (max number of channels offered)";
    public static final Integer CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_CHANNEL_MAX_DEFAULT = 2047;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_FRAME_MAX_CONF = "camel.sink.endpoint.requestedFrameMax";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_FRAME_MAX_DOC = "Connection requested frame max (max size of frame offered)";
    public static final Integer CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_FRAME_MAX_DEFAULT = 0;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_HEARTBEAT_CONF = "camel.sink.endpoint.requestedHeartbeat";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_HEARTBEAT_DOC = "Connection requested heartbeat (heart-beat in seconds offered)";
    public static final Integer CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_HEARTBEAT_DEFAULT = 60;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_CONF = "camel.sink.endpoint.requestTimeout";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_DOC = "Set timeout for waiting for a reply when using the InOut Exchange Pattern (in milliseconds)";
    public static final Long CAMEL_SINK_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_DEFAULT = 20000L;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_CONF = "camel.sink.endpoint.requestTimeoutCheckerInterval";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DOC = "Set requestTimeoutCheckerInterval for inOut exchange";
    public static final Long CAMEL_SINK_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DEFAULT = 1000L;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_TOPOLOGY_RECOVERY_ENABLED_CONF = "camel.sink.endpoint.topologyRecoveryEnabled";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_TOPOLOGY_RECOVERY_ENABLED_DOC = "Enables connection topology recovery (should topology recovery be performed)";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_TOPOLOGY_RECOVERY_ENABLED_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_TRANSFER_EXCEPTION_CONF = "camel.sink.endpoint.transferException";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_TRANSFER_EXCEPTION_DOC = "When true and an inOut Exchange failed on the consumer side send the caused Exception back in the response";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_TRANSFER_EXCEPTION_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_MESSAGE_BODY_SERIALIZATION_CONF = "camel.sink.endpoint.allowMessageBodySerialization";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_MESSAGE_BODY_SERIALIZATION_DOC = "Whether to allow Java serialization of the message body or not. If this value is true, the message body will be serialized on the producer side using Java serialization, if no type converter can handle the message body. On the consumer side, it will deserialize the message body if this value is true and the message contains a CamelSerialize header. Setting this value to true may introduce a security vulnerability as it allows an attacker to attempt to deserialize to a gadget object which could result in a RCE or other security vulnerability.";
    public static final Boolean CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_MESSAGE_BODY_SERIALIZATION_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_PASSWORD_CONF = "camel.sink.endpoint.password";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_PASSWORD_DOC = "Password for authenticated access";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_PASSWORD_DEFAULT = "guest";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_SSL_PROTOCOL_CONF = "camel.sink.endpoint.sslProtocol";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_SSL_PROTOCOL_DOC = "Enables SSL on connection, accepted value are true, TLS and 'SSLv3";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_SSL_PROTOCOL_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_TRUST_MANAGER_CONF = "camel.sink.endpoint.trustManager";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_TRUST_MANAGER_DOC = "Configure SSL trust manager, SSL should be enabled for this option to be effective";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_TRUST_MANAGER_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_USERNAME_CONF = "camel.sink.endpoint.username";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_USERNAME_DOC = "Username in case of authenticated access";
    public static final String CAMEL_SINK_RABBITMQ_ENDPOINT_USERNAME_DEFAULT = "guest";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_ADDRESSES_CONF = "camel.component.rabbitmq.addresses";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_ADDRESSES_DOC = "If this option is set, camel-rabbitmq will try to create connection based on the setting of option addresses. The addresses value is a string which looks like server1:12345, server2:12345";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_ADDRESSES_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_AUTO_DELETE_CONF = "camel.component.rabbitmq.autoDelete";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_AUTO_DELETE_DOC = "If it is true, the exchange will be deleted when it is no longer in use";
    public static final Boolean CAMEL_SINK_RABBITMQ_COMPONENT_AUTO_DELETE_DEFAULT = true;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_FACTORY_CONF = "camel.component.rabbitmq.connectionFactory";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_FACTORY_DOC = "To use a custom RabbitMQ connection factory. When this option is set, all connection options (connectionTimeout, requestedChannelMax...) set on URI are not used";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_FACTORY_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_CONF = "camel.component.rabbitmq.deadLetterExchange";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_DOC = "The name of the dead letter exchange";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_TYPE_CONF = "camel.component.rabbitmq.deadLetterExchangeType";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_TYPE_DOC = "The type of the dead letter exchange One of: [direct] [fanout] [headers] [topic]";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_TYPE_DEFAULT = "direct";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_QUEUE_CONF = "camel.component.rabbitmq.deadLetterQueue";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_QUEUE_DOC = "The name of the dead letter queue";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_QUEUE_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_ROUTING_KEY_CONF = "camel.component.rabbitmq.deadLetterRoutingKey";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_ROUTING_KEY_DOC = "The routing key for the dead letter exchange";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_ROUTING_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_DECLARE_CONF = "camel.component.rabbitmq.declare";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_DECLARE_DOC = "If the option is true, camel declare the exchange and queue name and bind them together. If the option is false, camel won't declare the exchange and queue name on the server.";
    public static final Boolean CAMEL_SINK_RABBITMQ_COMPONENT_DECLARE_DEFAULT = true;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_DURABLE_CONF = "camel.component.rabbitmq.durable";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_DURABLE_DOC = "If we are declaring a durable exchange (the exchange will survive a server restart)";
    public static final Boolean CAMEL_SINK_RABBITMQ_COMPONENT_DURABLE_DEFAULT = true;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_EXCLUSIVE_CONF = "camel.component.rabbitmq.exclusive";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_EXCLUSIVE_DOC = "Exclusive queues may only be accessed by the current connection, and are deleted when that connection closes.";
    public static final Boolean CAMEL_SINK_RABBITMQ_COMPONENT_EXCLUSIVE_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_HOSTNAME_CONF = "camel.component.rabbitmq.hostname";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_HOSTNAME_DOC = "The hostname of the running RabbitMQ instance or cluster.";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_HOSTNAME_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_PASSIVE_CONF = "camel.component.rabbitmq.passive";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_PASSIVE_DOC = "Passive queues depend on the queue already to be available at RabbitMQ.";
    public static final Boolean CAMEL_SINK_RABBITMQ_COMPONENT_PASSIVE_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_PORT_NUMBER_CONF = "camel.component.rabbitmq.portNumber";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_PORT_NUMBER_DOC = "Port number for the host with the running rabbitmq instance or cluster.";
    public static final Integer CAMEL_SINK_RABBITMQ_COMPONENT_PORT_NUMBER_DEFAULT = 5672;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_EXCHANGE_DECLARE_CONF = "camel.component.rabbitmq.skipExchangeDeclare";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_EXCHANGE_DECLARE_DOC = "This can be used if we need to declare the queue but not the exchange";
    public static final Boolean CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_EXCHANGE_DECLARE_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_QUEUE_BIND_CONF = "camel.component.rabbitmq.skipQueueBind";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_QUEUE_BIND_DOC = "If true the queue will not be bound to the exchange after declaring it";
    public static final Boolean CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_QUEUE_BIND_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_QUEUE_DECLARE_CONF = "camel.component.rabbitmq.skipQueueDeclare";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_QUEUE_DECLARE_DOC = "If true the producer will not declare and bind a queue. This can be used for directing messages via an existing routing key.";
    public static final Boolean CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_QUEUE_DECLARE_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_VHOST_CONF = "camel.component.rabbitmq.vhost";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_VHOST_DOC = "The vhost for the channel";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_VHOST_DEFAULT = "/";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_ADDITIONAL_HEADERS_CONF = "camel.component.rabbitmq.additionalHeaders";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_ADDITIONAL_HEADERS_DOC = "Map of additional headers. These headers will be set only when the 'allowCustomHeaders' is set to true";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_ADDITIONAL_HEADERS_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_ADDITIONAL_PROPERTIES_CONF = "camel.component.rabbitmq.additionalProperties";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_ADDITIONAL_PROPERTIES_DOC = "Map of additional properties. These are standard RabbitMQ properties as defined in com.rabbitmq.client.AMQP.BasicProperties The map keys should be from org.apache.camel.component.rabbitmq.RabbitMQConstants. Any other keys will be ignored. When the message already contains these headers they will be given precedence over these properties.";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_ADDITIONAL_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_ALLOW_NULL_HEADERS_CONF = "camel.component.rabbitmq.allowNullHeaders";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_ALLOW_NULL_HEADERS_DOC = "Allow pass null values to header";
    public static final Boolean CAMEL_SINK_RABBITMQ_COMPONENT_ALLOW_NULL_HEADERS_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_CHANNEL_POOL_MAX_SIZE_CONF = "camel.component.rabbitmq.channelPoolMaxSize";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_CHANNEL_POOL_MAX_SIZE_DOC = "Get maximum number of opened channel in pool";
    public static final Integer CAMEL_SINK_RABBITMQ_COMPONENT_CHANNEL_POOL_MAX_SIZE_DEFAULT = 10;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_CHANNEL_POOL_MAX_WAIT_CONF = "camel.component.rabbitmq.channelPoolMaxWait";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_CHANNEL_POOL_MAX_WAIT_DOC = "Set the maximum number of milliseconds to wait for a channel from the pool";
    public static final Long CAMEL_SINK_RABBITMQ_COMPONENT_CHANNEL_POOL_MAX_WAIT_DEFAULT = 1000L;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_GUARANTEED_DELIVERIES_CONF = "camel.component.rabbitmq.guaranteedDeliveries";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_GUARANTEED_DELIVERIES_DOC = "When true, an exception will be thrown when the message cannot be delivered (basic.return) and the message is marked as mandatory. PublisherAcknowledgement will also be activated in this case. See also publisher acknowledgements - When will messages be confirmed.";
    public static final Boolean CAMEL_SINK_RABBITMQ_COMPONENT_GUARANTEED_DELIVERIES_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_IMMEDIATE_CONF = "camel.component.rabbitmq.immediate";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_IMMEDIATE_DOC = "This flag tells the server how to react if the message cannot be routed to a queue consumer immediately. If this flag is set, the server will return an undeliverable message with a Return method. If this flag is zero, the server will queue the message, but with no guarantee that it will ever be consumed. If the header is present rabbitmq.IMMEDIATE it will override this option.";
    public static final Boolean CAMEL_SINK_RABBITMQ_COMPONENT_IMMEDIATE_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.rabbitmq.lazyStartProducer";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_RABBITMQ_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_MANDATORY_CONF = "camel.component.rabbitmq.mandatory";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_MANDATORY_DOC = "This flag tells the server how to react if the message cannot be routed to a queue. If this flag is set, the server will return an unroutable message with a Return method. If this flag is zero, the server silently drops the message. If the header is present rabbitmq.MANDATORY it will override this option.";
    public static final Boolean CAMEL_SINK_RABBITMQ_COMPONENT_MANDATORY_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_PUBLISHER_ACKNOWLEDGEMENTS_CONF = "camel.component.rabbitmq.publisherAcknowledgements";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_PUBLISHER_ACKNOWLEDGEMENTS_DOC = "When true, the message will be published with publisher acknowledgements turned on";
    public static final Boolean CAMEL_SINK_RABBITMQ_COMPONENT_PUBLISHER_ACKNOWLEDGEMENTS_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_PUBLISHER_ACKNOWLEDGEMENTS_TIMEOUT_CONF = "camel.component.rabbitmq.publisherAcknowledgementsTimeout";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_PUBLISHER_ACKNOWLEDGEMENTS_TIMEOUT_DOC = "The amount of time in milliseconds to wait for a basic.ack response from RabbitMQ server";
    public static final Long CAMEL_SINK_RABBITMQ_COMPONENT_PUBLISHER_ACKNOWLEDGEMENTS_TIMEOUT_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_ARGS_CONF = "camel.component.rabbitmq.args";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_ARGS_DOC = "Specify arguments for configuring the different RabbitMQ concepts, a different prefix is required for each: Exchange: arg.exchange. Queue: arg.queue. Binding: arg.binding. DLQ: arg.dlq.queue. DLQ Binding: arg.dlq.binding. For example to declare a queue with message ttl argument: http://localhost:5672/exchange/queueargs=arg.queue.x-message-ttl=60000";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_ARGS_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_AUTO_DETECT_CONNECTION_FACTORY_CONF = "camel.component.rabbitmq.autoDetectConnectionFactory";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_AUTO_DETECT_CONNECTION_FACTORY_DOC = "Whether to auto-detect looking up RabbitMQ connection factory from the registry. When enabled and a single instance of the connection factory is found then it will be used. An explicit connection factory can be configured on the component or endpoint level which takes precedence.";
    public static final Boolean CAMEL_SINK_RABBITMQ_COMPONENT_AUTO_DETECT_CONNECTION_FACTORY_DEFAULT = true;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_AUTOMATIC_RECOVERY_ENABLED_CONF = "camel.component.rabbitmq.automaticRecoveryEnabled";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_AUTOMATIC_RECOVERY_ENABLED_DOC = "Enables connection automatic recovery (uses connection implementation that performs automatic recovery when connection shutdown is not initiated by the application)";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_AUTOMATIC_RECOVERY_ENABLED_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.rabbitmq.autowiredEnabled";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_RABBITMQ_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_CLIENT_PROPERTIES_CONF = "camel.component.rabbitmq.clientProperties";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_CLIENT_PROPERTIES_DOC = "Connection client properties (client info used in negotiating with the server)";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_CLIENT_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_FACTORY_EXCEPTION_HANDLER_CONF = "camel.component.rabbitmq.connectionFactoryExceptionHandler";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_FACTORY_EXCEPTION_HANDLER_DOC = "Custom rabbitmq ExceptionHandler for ConnectionFactory";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_FACTORY_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_TIMEOUT_CONF = "camel.component.rabbitmq.connectionTimeout";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_TIMEOUT_DOC = "Connection timeout";
    public static final Integer CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_TIMEOUT_DEFAULT = 60000;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_NETWORK_RECOVERY_INTERVAL_CONF = "camel.component.rabbitmq.networkRecoveryInterval";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_NETWORK_RECOVERY_INTERVAL_DOC = "Network recovery interval in milliseconds (interval used when recovering from network failure)";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_NETWORK_RECOVERY_INTERVAL_DEFAULT = "5000";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_CHANNEL_MAX_CONF = "camel.component.rabbitmq.requestedChannelMax";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_CHANNEL_MAX_DOC = "Connection requested channel max (max number of channels offered)";
    public static final Integer CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_CHANNEL_MAX_DEFAULT = 2047;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_FRAME_MAX_CONF = "camel.component.rabbitmq.requestedFrameMax";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_FRAME_MAX_DOC = "Connection requested frame max (max size of frame offered)";
    public static final Integer CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_FRAME_MAX_DEFAULT = 0;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_HEARTBEAT_CONF = "camel.component.rabbitmq.requestedHeartbeat";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_HEARTBEAT_DOC = "Connection requested heartbeat (heart-beat in seconds offered)";
    public static final Integer CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_HEARTBEAT_DEFAULT = 60;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_CONF = "camel.component.rabbitmq.requestTimeout";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_DOC = "Set timeout for waiting for a reply when using the InOut Exchange Pattern (in milliseconds)";
    public static final Long CAMEL_SINK_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_DEFAULT = 20000L;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_CONF = "camel.component.rabbitmq.requestTimeoutCheckerInterval";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DOC = "Set requestTimeoutCheckerInterval for inOut exchange";
    public static final Long CAMEL_SINK_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DEFAULT = 1000L;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_TOPOLOGY_RECOVERY_ENABLED_CONF = "camel.component.rabbitmq.topologyRecoveryEnabled";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_TOPOLOGY_RECOVERY_ENABLED_DOC = "Enables connection topology recovery (should topology recovery be performed)";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_TOPOLOGY_RECOVERY_ENABLED_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_TRANSFER_EXCEPTION_CONF = "camel.component.rabbitmq.transferException";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_TRANSFER_EXCEPTION_DOC = "When true and an inOut Exchange failed on the consumer side send the caused Exception back in the response";
    public static final Boolean CAMEL_SINK_RABBITMQ_COMPONENT_TRANSFER_EXCEPTION_DEFAULT = false;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_PASSWORD_CONF = "camel.component.rabbitmq.password";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_PASSWORD_DOC = "Password for authenticated access";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_PASSWORD_DEFAULT = "guest";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_SSL_PROTOCOL_CONF = "camel.component.rabbitmq.sslProtocol";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_SSL_PROTOCOL_DOC = "Enables SSL on connection, accepted value are true, TLS and 'SSLv3";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_SSL_PROTOCOL_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_TRUST_MANAGER_CONF = "camel.component.rabbitmq.trustManager";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_TRUST_MANAGER_DOC = "Configure SSL trust manager, SSL should be enabled for this option to be effective";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_TRUST_MANAGER_DEFAULT = null;
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_USERNAME_CONF = "camel.component.rabbitmq.username";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_USERNAME_DOC = "Username in case of authenticated access";
    public static final String CAMEL_SINK_RABBITMQ_COMPONENT_USERNAME_DEFAULT = "guest";

    public CamelRabbitmqSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelRabbitmqSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_RABBITMQ_PATH_EXCHANGE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_PATH_EXCHANGE_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_RABBITMQ_PATH_EXCHANGE_NAME_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_ADDRESSES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_ADDRESSES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_ADDRESSES_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_AUTO_DELETE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_AUTO_DELETE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_AUTO_DELETE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_AUTOMATIC_RECOVERY_ENABLED_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_AUTOMATIC_RECOVERY_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_AUTOMATIC_RECOVERY_ENABLED_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_TYPE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_QUEUE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_QUEUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_QUEUE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_ROUTING_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_ROUTING_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_DEAD_LETTER_ROUTING_KEY_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_DECLARE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_DECLARE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_DECLARE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_DURABLE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_DURABLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_DURABLE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_EXCHANGE_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_EXCHANGE_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_EXCHANGE_TYPE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_EXCLUSIVE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_EXCLUSIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_EXCLUSIVE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_HOSTNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_HOSTNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_HOSTNAME_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_PASSIVE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_PASSIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_PASSIVE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_PORT_NUMBER_CONF, ConfigDef.Type.INT, CAMEL_SINK_RABBITMQ_ENDPOINT_PORT_NUMBER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_PORT_NUMBER_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_QUEUE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_QUEUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_QUEUE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_ROUTING_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_ROUTING_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_ROUTING_KEY_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_DLQ_DECLARE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_DLQ_DECLARE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_DLQ_DECLARE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_EXCHANGE_DECLARE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_EXCHANGE_DECLARE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_EXCHANGE_DECLARE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_QUEUE_BIND_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_QUEUE_BIND_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_QUEUE_BIND_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_QUEUE_DECLARE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_QUEUE_DECLARE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_SKIP_QUEUE_DECLARE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_VHOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_VHOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_VHOST_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_ADDITIONAL_HEADERS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_ADDITIONAL_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_ADDITIONAL_HEADERS_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_ADDITIONAL_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_ADDITIONAL_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_ADDITIONAL_PROPERTIES_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_CUSTOM_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_CUSTOM_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_CUSTOM_HEADERS_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_NULL_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_NULL_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_NULL_HEADERS_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_BRIDGE_ENDPOINT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_BRIDGE_ENDPOINT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_BRIDGE_ENDPOINT_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_CHANNEL_POOL_MAX_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SINK_RABBITMQ_ENDPOINT_CHANNEL_POOL_MAX_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_CHANNEL_POOL_MAX_SIZE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_CHANNEL_POOL_MAX_WAIT_CONF, ConfigDef.Type.LONG, CAMEL_SINK_RABBITMQ_ENDPOINT_CHANNEL_POOL_MAX_WAIT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_CHANNEL_POOL_MAX_WAIT_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_GUARANTEED_DELIVERIES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_GUARANTEED_DELIVERIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_GUARANTEED_DELIVERIES_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_IMMEDIATE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_IMMEDIATE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_IMMEDIATE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_MANDATORY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_MANDATORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_MANDATORY_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_PUBLISHER_ACKNOWLEDGEMENTS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_PUBLISHER_ACKNOWLEDGEMENTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_PUBLISHER_ACKNOWLEDGEMENTS_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_PUBLISHER_ACKNOWLEDGEMENTS_TIMEOUT_CONF, ConfigDef.Type.LONG, CAMEL_SINK_RABBITMQ_ENDPOINT_PUBLISHER_ACKNOWLEDGEMENTS_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_PUBLISHER_ACKNOWLEDGEMENTS_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_ARGS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_ARGS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_ARGS_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_CLIENT_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_CLIENT_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_CLIENT_PROPERTIES_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_TIMEOUT_CONF, ConfigDef.Type.INT, CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_CONNECTION_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_NETWORK_RECOVERY_INTERVAL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_NETWORK_RECOVERY_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_NETWORK_RECOVERY_INTERVAL_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_CHANNEL_MAX_CONF, ConfigDef.Type.INT, CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_CHANNEL_MAX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_CHANNEL_MAX_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_FRAME_MAX_CONF, ConfigDef.Type.INT, CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_FRAME_MAX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_FRAME_MAX_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_HEARTBEAT_CONF, ConfigDef.Type.INT, CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_HEARTBEAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_REQUESTED_HEARTBEAT_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_CONF, ConfigDef.Type.LONG, CAMEL_SINK_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_CONF, ConfigDef.Type.LONG, CAMEL_SINK_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_TOPOLOGY_RECOVERY_ENABLED_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_TOPOLOGY_RECOVERY_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_TOPOLOGY_RECOVERY_ENABLED_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_TRANSFER_EXCEPTION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_TRANSFER_EXCEPTION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_TRANSFER_EXCEPTION_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_MESSAGE_BODY_SERIALIZATION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_MESSAGE_BODY_SERIALIZATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_ALLOW_MESSAGE_BODY_SERIALIZATION_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_RABBITMQ_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_SSL_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_SSL_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_SSL_PROTOCOL_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_TRUST_MANAGER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_ENDPOINT_TRUST_MANAGER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_TRUST_MANAGER_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_ENDPOINT_USERNAME_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_RABBITMQ_ENDPOINT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_ENDPOINT_USERNAME_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_ADDRESSES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_ADDRESSES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_ADDRESSES_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_AUTO_DELETE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_COMPONENT_AUTO_DELETE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_AUTO_DELETE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_FACTORY_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_TYPE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_QUEUE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_QUEUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_QUEUE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_ROUTING_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_ROUTING_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_DEAD_LETTER_ROUTING_KEY_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_DECLARE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_COMPONENT_DECLARE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_DECLARE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_DURABLE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_COMPONENT_DURABLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_DURABLE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_EXCLUSIVE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_COMPONENT_EXCLUSIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_EXCLUSIVE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_HOSTNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_HOSTNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_HOSTNAME_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_PASSIVE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_COMPONENT_PASSIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_PASSIVE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_PORT_NUMBER_CONF, ConfigDef.Type.INT, CAMEL_SINK_RABBITMQ_COMPONENT_PORT_NUMBER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_PORT_NUMBER_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_EXCHANGE_DECLARE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_EXCHANGE_DECLARE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_EXCHANGE_DECLARE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_QUEUE_BIND_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_QUEUE_BIND_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_QUEUE_BIND_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_QUEUE_DECLARE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_QUEUE_DECLARE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_SKIP_QUEUE_DECLARE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_VHOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_VHOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_VHOST_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_ADDITIONAL_HEADERS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_ADDITIONAL_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_ADDITIONAL_HEADERS_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_ADDITIONAL_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_ADDITIONAL_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_ADDITIONAL_PROPERTIES_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_ALLOW_NULL_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_COMPONENT_ALLOW_NULL_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_ALLOW_NULL_HEADERS_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_CHANNEL_POOL_MAX_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SINK_RABBITMQ_COMPONENT_CHANNEL_POOL_MAX_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_CHANNEL_POOL_MAX_SIZE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_CHANNEL_POOL_MAX_WAIT_CONF, ConfigDef.Type.LONG, CAMEL_SINK_RABBITMQ_COMPONENT_CHANNEL_POOL_MAX_WAIT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_CHANNEL_POOL_MAX_WAIT_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_GUARANTEED_DELIVERIES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_COMPONENT_GUARANTEED_DELIVERIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_GUARANTEED_DELIVERIES_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_IMMEDIATE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_COMPONENT_IMMEDIATE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_IMMEDIATE_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_MANDATORY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_COMPONENT_MANDATORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_MANDATORY_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_PUBLISHER_ACKNOWLEDGEMENTS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_COMPONENT_PUBLISHER_ACKNOWLEDGEMENTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_PUBLISHER_ACKNOWLEDGEMENTS_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_PUBLISHER_ACKNOWLEDGEMENTS_TIMEOUT_CONF, ConfigDef.Type.LONG, CAMEL_SINK_RABBITMQ_COMPONENT_PUBLISHER_ACKNOWLEDGEMENTS_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_PUBLISHER_ACKNOWLEDGEMENTS_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_ARGS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_ARGS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_ARGS_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_AUTO_DETECT_CONNECTION_FACTORY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_COMPONENT_AUTO_DETECT_CONNECTION_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_AUTO_DETECT_CONNECTION_FACTORY_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_AUTOMATIC_RECOVERY_ENABLED_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_AUTOMATIC_RECOVERY_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_AUTOMATIC_RECOVERY_ENABLED_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_CLIENT_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_CLIENT_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_CLIENT_PROPERTIES_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_FACTORY_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_FACTORY_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_FACTORY_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_TIMEOUT_CONF, ConfigDef.Type.INT, CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_CONNECTION_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_NETWORK_RECOVERY_INTERVAL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_NETWORK_RECOVERY_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_NETWORK_RECOVERY_INTERVAL_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_CHANNEL_MAX_CONF, ConfigDef.Type.INT, CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_CHANNEL_MAX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_CHANNEL_MAX_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_FRAME_MAX_CONF, ConfigDef.Type.INT, CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_FRAME_MAX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_FRAME_MAX_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_HEARTBEAT_CONF, ConfigDef.Type.INT, CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_HEARTBEAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_REQUESTED_HEARTBEAT_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_CONF, ConfigDef.Type.LONG, CAMEL_SINK_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_CONF, ConfigDef.Type.LONG, CAMEL_SINK_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_TOPOLOGY_RECOVERY_ENABLED_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_TOPOLOGY_RECOVERY_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_TOPOLOGY_RECOVERY_ENABLED_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_TRANSFER_EXCEPTION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_RABBITMQ_COMPONENT_TRANSFER_EXCEPTION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_TRANSFER_EXCEPTION_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_RABBITMQ_COMPONENT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_PASSWORD_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_SSL_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_SSL_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_SSL_PROTOCOL_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_TRUST_MANAGER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_RABBITMQ_COMPONENT_TRUST_MANAGER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_TRUST_MANAGER_DOC);
        conf.define(CAMEL_SINK_RABBITMQ_COMPONENT_USERNAME_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_RABBITMQ_COMPONENT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_RABBITMQ_COMPONENT_USERNAME_DOC);
        return conf;
    }
}