/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.infinispan;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelInfinispanSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_INFINISPAN_PATH_CACHE_NAME_CONF = "camel.sink.path.cacheName";
    public static final String CAMEL_SINK_INFINISPAN_PATH_CACHE_NAME_DOC = "The name of the cache to use. Use current to use the existing cache name from the currently configured cached manager. Or use default for the default cache manager name.";
    public static final String CAMEL_SINK_INFINISPAN_PATH_CACHE_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_HOSTS_CONF = "camel.sink.endpoint.hosts";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_HOSTS_DOC = "Specifies the host of the cache on Infinispan instance";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_HOSTS_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_QUERY_BUILDER_CONF = "camel.sink.endpoint.queryBuilder";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_QUERY_BUILDER_DOC = "Specifies the query builder.";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_QUERY_BUILDER_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_SECURE_CONF = "camel.sink.endpoint.secure";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_SECURE_DOC = "Define if we are connecting to a secured Infinispan instance";
    public static final Boolean CAMEL_SINK_INFINISPAN_ENDPOINT_SECURE_DEFAULT = false;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_DEFAULT_VALUE_CONF = "camel.sink.endpoint.defaultValue";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_DEFAULT_VALUE_DOC = "Set a specific default value for some producer operations";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_DEFAULT_VALUE_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_KEY_CONF = "camel.sink.endpoint.key";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_KEY_DOC = "Set a specific key for producer operations";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_INFINISPAN_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_OLD_VALUE_CONF = "camel.sink.endpoint.oldValue";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_OLD_VALUE_DOC = "Set a specific old value for some producer operations";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_OLD_VALUE_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_OPERATION_CONF = "camel.sink.endpoint.operation";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_OPERATION_DOC = "The operation to perform. One of: [PUT] [PUTASYNC] [PUTALL] [PUTALLASYNC] [PUTIFABSENT] [PUTIFABSENTASYNC] [GET] [GETORDEFAULT] [CONTAINSKEY] [CONTAINSVALUE] [REMOVE] [REMOVEASYNC] [REPLACE] [REPLACEASYNC] [SIZE] [CLEAR] [CLEARASYNC] [QUERY] [STATS] [COMPUTE] [COMPUTEASYNC]";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_OPERATION_DEFAULT = "PUT";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_VALUE_CONF = "camel.sink.endpoint.value";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_VALUE_DOC = "Set a specific value for producer operations";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_VALUE_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_PASSWORD_CONF = "camel.sink.endpoint.password";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_PASSWORD_DOC = "Define the password to access the infinispan instance";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_SASL_MECHANISM_CONF = "camel.sink.endpoint.saslMechanism";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_SASL_MECHANISM_DOC = "Define the SASL Mechanism to access the infinispan instance";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_SASL_MECHANISM_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_SECURITY_REALM_CONF = "camel.sink.endpoint.securityRealm";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_SECURITY_REALM_DOC = "Define the security realm to access the infinispan instance";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_SECURITY_REALM_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_SECURITY_SERVER_NAME_CONF = "camel.sink.endpoint.securityServerName";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_SECURITY_SERVER_NAME_DOC = "Define the security server name to access the infinispan instance";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_SECURITY_SERVER_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_USERNAME_CONF = "camel.sink.endpoint.username";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_USERNAME_DOC = "Define the username to access the infinispan instance";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_CACHE_CONTAINER_CONF = "camel.sink.endpoint.cacheContainer";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_CACHE_CONTAINER_DOC = "Specifies the cache Container to connect";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_CACHE_CONTAINER_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_CACHE_CONTAINER_CONFIGURATION_CONF = "camel.sink.endpoint.cacheContainerConfiguration";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_CACHE_CONTAINER_CONFIGURATION_DOC = "The CacheContainer configuration. Uses if the cacheContainer is not defined. Must be the following types: org.infinispan.client.hotrod.configuration.Configuration - for remote cache interaction configuration; org.infinispan.configuration.cache.Configuration - for embedded cache interaction configuration;";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_CACHE_CONTAINER_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_CONFIGURATION_PROPERTIES_CONF = "camel.sink.endpoint.configurationProperties";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_CONFIGURATION_PROPERTIES_DOC = "Implementation specific properties for the CacheManager";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_CONFIGURATION_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_CONFIGURATION_URI_CONF = "camel.sink.endpoint.configurationUri";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_CONFIGURATION_URI_DOC = "An implementation specific URI for the CacheManager";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_CONFIGURATION_URI_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_FLAGS_CONF = "camel.sink.endpoint.flags";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_FLAGS_DOC = "A comma separated list of Flag to be applied by default on each cache invocation, not applicable to remote caches.";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_FLAGS_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_REMAPPING_FUNCTION_CONF = "camel.sink.endpoint.remappingFunction";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_REMAPPING_FUNCTION_DOC = "Set a specific remappingFunction to use in a compute operation";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_REMAPPING_FUNCTION_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_RESULT_HEADER_CONF = "camel.sink.endpoint.resultHeader";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_RESULT_HEADER_DOC = "Store the operation result in a header instead of the message body. By default, resultHeader == null and the query result is stored in the message body, any existing content in the message body is discarded. If resultHeader is set, the value is used as the name of the header to store the query result and the original message body is preserved. This value can be overridden by an in message header named: CamelInfinispanOperationResultHeader";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_RESULT_HEADER_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_INFINISPAN_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_INFINISPAN_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_CONF = "camel.component.infinispan.configuration";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_DOC = "Component configuration";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_HOSTS_CONF = "camel.component.infinispan.hosts";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_HOSTS_DOC = "Specifies the host of the cache on Infinispan instance";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_HOSTS_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_QUERY_BUILDER_CONF = "camel.component.infinispan.queryBuilder";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_QUERY_BUILDER_DOC = "Specifies the query builder.";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_QUERY_BUILDER_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_SECURE_CONF = "camel.component.infinispan.secure";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_SECURE_DOC = "Define if we are connecting to a secured Infinispan instance";
    public static final Boolean CAMEL_SINK_INFINISPAN_COMPONENT_SECURE_DEFAULT = false;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_DEFAULT_VALUE_CONF = "camel.component.infinispan.defaultValue";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_DEFAULT_VALUE_DOC = "Set a specific default value for some producer operations";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_DEFAULT_VALUE_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_KEY_CONF = "camel.component.infinispan.key";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_KEY_DOC = "Set a specific key for producer operations";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.infinispan.lazyStartProducer";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_INFINISPAN_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_OLD_VALUE_CONF = "camel.component.infinispan.oldValue";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_OLD_VALUE_DOC = "Set a specific old value for some producer operations";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_OLD_VALUE_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_OPERATION_CONF = "camel.component.infinispan.operation";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_OPERATION_DOC = "The operation to perform. One of: [PUT] [PUTASYNC] [PUTALL] [PUTALLASYNC] [PUTIFABSENT] [PUTIFABSENTASYNC] [GET] [GETORDEFAULT] [CONTAINSKEY] [CONTAINSVALUE] [REMOVE] [REMOVEASYNC] [REPLACE] [REPLACEASYNC] [SIZE] [CLEAR] [CLEARASYNC] [QUERY] [STATS] [COMPUTE] [COMPUTEASYNC]";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_OPERATION_DEFAULT = "PUT";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_VALUE_CONF = "camel.component.infinispan.value";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_VALUE_DOC = "Set a specific value for producer operations";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_VALUE_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_PASSWORD_CONF = "camel.component.infinispan.password";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_PASSWORD_DOC = "Define the password to access the infinispan instance";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_SASL_MECHANISM_CONF = "camel.component.infinispan.saslMechanism";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_SASL_MECHANISM_DOC = "Define the SASL Mechanism to access the infinispan instance";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_SASL_MECHANISM_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_SECURITY_REALM_CONF = "camel.component.infinispan.securityRealm";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_SECURITY_REALM_DOC = "Define the security realm to access the infinispan instance";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_SECURITY_REALM_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_SECURITY_SERVER_NAME_CONF = "camel.component.infinispan.securityServerName";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_SECURITY_SERVER_NAME_DOC = "Define the security server name to access the infinispan instance";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_SECURITY_SERVER_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_USERNAME_CONF = "camel.component.infinispan.username";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_USERNAME_DOC = "Define the username to access the infinispan instance";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.infinispan.autowiredEnabled";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_INFINISPAN_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_CACHE_CONTAINER_CONF = "camel.component.infinispan.cacheContainer";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_CACHE_CONTAINER_DOC = "Specifies the cache Container to connect";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_CACHE_CONTAINER_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_CACHE_CONTAINER_CONFIGURATION_CONF = "camel.component.infinispan.cacheContainerConfiguration";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_CACHE_CONTAINER_CONFIGURATION_DOC = "The CacheContainer configuration. Uses if the cacheContainer is not defined. Must be the following types: org.infinispan.client.hotrod.configuration.Configuration - for remote cache interaction configuration; org.infinispan.configuration.cache.Configuration - for embedded cache interaction configuration;";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_CACHE_CONTAINER_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_PROPERTIES_CONF = "camel.component.infinispan.configurationProperties";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_PROPERTIES_DOC = "Implementation specific properties for the CacheManager";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_URI_CONF = "camel.component.infinispan.configurationUri";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_URI_DOC = "An implementation specific URI for the CacheManager";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_URI_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_FLAGS_CONF = "camel.component.infinispan.flags";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_FLAGS_DOC = "A comma separated list of Flag to be applied by default on each cache invocation, not applicable to remote caches.";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_FLAGS_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_REMAPPING_FUNCTION_CONF = "camel.component.infinispan.remappingFunction";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_REMAPPING_FUNCTION_DOC = "Set a specific remappingFunction to use in a compute operation";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_REMAPPING_FUNCTION_DEFAULT = null;
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_RESULT_HEADER_CONF = "camel.component.infinispan.resultHeader";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_RESULT_HEADER_DOC = "Store the operation result in a header instead of the message body. By default, resultHeader == null and the query result is stored in the message body, any existing content in the message body is discarded. If resultHeader is set, the value is used as the name of the header to store the query result and the original message body is preserved. This value can be overridden by an in message header named: CamelInfinispanOperationResultHeader";
    public static final String CAMEL_SINK_INFINISPAN_COMPONENT_RESULT_HEADER_DEFAULT = null;

    public CamelInfinispanSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelInfinispanSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_INFINISPAN_PATH_CACHE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_PATH_CACHE_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_INFINISPAN_PATH_CACHE_NAME_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_HOSTS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_HOSTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_HOSTS_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_QUERY_BUILDER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_QUERY_BUILDER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_QUERY_BUILDER_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_SECURE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_INFINISPAN_ENDPOINT_SECURE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_SECURE_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_DEFAULT_VALUE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_DEFAULT_VALUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_DEFAULT_VALUE_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_KEY_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_INFINISPAN_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_OLD_VALUE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_OLD_VALUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_OLD_VALUE_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_OPERATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_OPERATION_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_VALUE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_VALUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_VALUE_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_INFINISPAN_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_SASL_MECHANISM_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_SASL_MECHANISM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_SASL_MECHANISM_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_SECURITY_REALM_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_SECURITY_REALM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_SECURITY_REALM_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_SECURITY_SERVER_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_SECURITY_SERVER_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_SECURITY_SERVER_NAME_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_USERNAME_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_CACHE_CONTAINER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_CACHE_CONTAINER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_CACHE_CONTAINER_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_CACHE_CONTAINER_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_CACHE_CONTAINER_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_CACHE_CONTAINER_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_CONFIGURATION_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_CONFIGURATION_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_CONFIGURATION_PROPERTIES_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_CONFIGURATION_URI_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_CONFIGURATION_URI_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_CONFIGURATION_URI_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_FLAGS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_FLAGS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_FLAGS_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_REMAPPING_FUNCTION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_REMAPPING_FUNCTION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_REMAPPING_FUNCTION_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_RESULT_HEADER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_ENDPOINT_RESULT_HEADER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_RESULT_HEADER_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_INFINISPAN_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_HOSTS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_HOSTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_HOSTS_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_QUERY_BUILDER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_QUERY_BUILDER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_QUERY_BUILDER_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_SECURE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_INFINISPAN_COMPONENT_SECURE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_SECURE_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_DEFAULT_VALUE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_DEFAULT_VALUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_DEFAULT_VALUE_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_KEY_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_INFINISPAN_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_OLD_VALUE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_OLD_VALUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_OLD_VALUE_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_OPERATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_OPERATION_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_VALUE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_VALUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_VALUE_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_INFINISPAN_COMPONENT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_PASSWORD_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_SASL_MECHANISM_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_SASL_MECHANISM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_SASL_MECHANISM_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_SECURITY_REALM_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_SECURITY_REALM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_SECURITY_REALM_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_SECURITY_SERVER_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_SECURITY_SERVER_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_SECURITY_SERVER_NAME_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_USERNAME_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_INFINISPAN_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_CACHE_CONTAINER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_CACHE_CONTAINER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_CACHE_CONTAINER_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_CACHE_CONTAINER_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_CACHE_CONTAINER_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_CACHE_CONTAINER_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_PROPERTIES_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_URI_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_URI_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_CONFIGURATION_URI_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_FLAGS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_FLAGS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_FLAGS_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_REMAPPING_FUNCTION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_REMAPPING_FUNCTION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_REMAPPING_FUNCTION_DOC);
        conf.define(CAMEL_SINK_INFINISPAN_COMPONENT_RESULT_HEADER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_INFINISPAN_COMPONENT_RESULT_HEADER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_INFINISPAN_COMPONENT_RESULT_HEADER_DOC);
        return conf;
    }
}