/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.quickfix;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelQuickfixSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_QUICKFIX_PATH_CONFIGURATION_NAME_CONF = "camel.source.path.configurationName";
    public static final String CAMEL_SOURCE_QUICKFIX_PATH_CONFIGURATION_NAME_DOC = "Path to the quickfix configuration file. You can prefix with: classpath, file, http, ref, or bean. classpath, file and http loads the configuration file using these protocols (classpath is default). ref will lookup the configuration file in the registry. bean will call a method on a bean to be used as the configuration. For bean you can specify the method name after dot, eg bean:myBean.myMethod";
    public static final String CAMEL_SOURCE_QUICKFIX_PATH_CONFIGURATION_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_QUICKFIX_ENDPOINT_LAZY_CREATE_ENGINE_CONF = "camel.source.endpoint.lazyCreateEngine";
    public static final String CAMEL_SOURCE_QUICKFIX_ENDPOINT_LAZY_CREATE_ENGINE_DOC = "This option allows to create QuickFIX/J engine on demand. Value true means the engine is started when first message is send or there's consumer configured in route definition. When false value is used, the engine is started at the endpoint creation. When this parameter is missing, the value of component's property lazyCreateEngines is being used.";
    public static final Boolean CAMEL_SOURCE_QUICKFIX_ENDPOINT_LAZY_CREATE_ENGINE_DEFAULT = false;
    public static final String CAMEL_SOURCE_QUICKFIX_ENDPOINT_SESSION_IDCONF = "camel.source.endpoint.sessionID";
    public static final String CAMEL_SOURCE_QUICKFIX_ENDPOINT_SESSION_IDDOC = "The optional sessionID identifies a specific FIX session. The format of the sessionID is: (BeginString):(SenderCompID)/(SenderSubID)/(SenderLocationID)-(TargetCompID)/(TargetSubID)/(TargetLocationID)";
    public static final String CAMEL_SOURCE_QUICKFIX_ENDPOINT_SESSION_IDDEFAULT = null;
    public static final String CAMEL_SOURCE_QUICKFIX_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_QUICKFIX_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_QUICKFIX_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_QUICKFIX_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_QUICKFIX_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_QUICKFIX_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_QUICKFIX_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_QUICKFIX_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_QUICKFIX_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_QUICKFIX_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_QUICKFIX_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_QUICKFIX_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_QUICKFIX_COMPONENT_LAZY_CREATE_ENGINES_CONF = "camel.component.quickfix.lazyCreateEngines";
    public static final String CAMEL_SOURCE_QUICKFIX_COMPONENT_LAZY_CREATE_ENGINES_DOC = "If set to true, the engines will be created and started when needed (when first message is send)";
    public static final Boolean CAMEL_SOURCE_QUICKFIX_COMPONENT_LAZY_CREATE_ENGINES_DEFAULT = false;
    public static final String CAMEL_SOURCE_QUICKFIX_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.quickfix.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_QUICKFIX_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_QUICKFIX_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_QUICKFIX_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.quickfix.autowiredEnabled";
    public static final String CAMEL_SOURCE_QUICKFIX_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_QUICKFIX_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SOURCE_QUICKFIX_COMPONENT_LOG_FACTORY_CONF = "camel.component.quickfix.logFactory";
    public static final String CAMEL_SOURCE_QUICKFIX_COMPONENT_LOG_FACTORY_DOC = "To use the given LogFactory";
    public static final String CAMEL_SOURCE_QUICKFIX_COMPONENT_LOG_FACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_QUICKFIX_COMPONENT_MESSAGE_FACTORY_CONF = "camel.component.quickfix.messageFactory";
    public static final String CAMEL_SOURCE_QUICKFIX_COMPONENT_MESSAGE_FACTORY_DOC = "To use the given MessageFactory";
    public static final String CAMEL_SOURCE_QUICKFIX_COMPONENT_MESSAGE_FACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_QUICKFIX_COMPONENT_MESSAGE_STORE_FACTORY_CONF = "camel.component.quickfix.messageStoreFactory";
    public static final String CAMEL_SOURCE_QUICKFIX_COMPONENT_MESSAGE_STORE_FACTORY_DOC = "To use the given MessageStoreFactory";
    public static final String CAMEL_SOURCE_QUICKFIX_COMPONENT_MESSAGE_STORE_FACTORY_DEFAULT = null;

    public CamelQuickfixSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelQuickfixSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_QUICKFIX_PATH_CONFIGURATION_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_QUICKFIX_PATH_CONFIGURATION_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_QUICKFIX_PATH_CONFIGURATION_NAME_DOC);
        conf.define(CAMEL_SOURCE_QUICKFIX_ENDPOINT_LAZY_CREATE_ENGINE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_QUICKFIX_ENDPOINT_LAZY_CREATE_ENGINE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_QUICKFIX_ENDPOINT_LAZY_CREATE_ENGINE_DOC);
        conf.define(CAMEL_SOURCE_QUICKFIX_ENDPOINT_SESSION_IDCONF, ConfigDef.Type.STRING, CAMEL_SOURCE_QUICKFIX_ENDPOINT_SESSION_IDDEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_QUICKFIX_ENDPOINT_SESSION_IDDOC);
        conf.define(CAMEL_SOURCE_QUICKFIX_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_QUICKFIX_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_QUICKFIX_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_QUICKFIX_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_QUICKFIX_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_QUICKFIX_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_QUICKFIX_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_QUICKFIX_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_QUICKFIX_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_QUICKFIX_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_QUICKFIX_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_QUICKFIX_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_QUICKFIX_COMPONENT_LAZY_CREATE_ENGINES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_QUICKFIX_COMPONENT_LAZY_CREATE_ENGINES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_QUICKFIX_COMPONENT_LAZY_CREATE_ENGINES_DOC);
        conf.define(CAMEL_SOURCE_QUICKFIX_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_QUICKFIX_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_QUICKFIX_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_QUICKFIX_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_QUICKFIX_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_QUICKFIX_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_QUICKFIX_COMPONENT_LOG_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_QUICKFIX_COMPONENT_LOG_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_QUICKFIX_COMPONENT_LOG_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_QUICKFIX_COMPONENT_MESSAGE_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_QUICKFIX_COMPONENT_MESSAGE_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_QUICKFIX_COMPONENT_MESSAGE_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_QUICKFIX_COMPONENT_MESSAGE_STORE_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_QUICKFIX_COMPONENT_MESSAGE_STORE_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_QUICKFIX_COMPONENT_MESSAGE_STORE_FACTORY_DOC);
        return conf;
    }
}