/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.netty;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelNettySourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_NETTY_PATH_PROTOCOL_CONF = "camel.source.path.protocol";
    public static final String CAMEL_SOURCE_NETTY_PATH_PROTOCOL_DOC = "The protocol to use which can be tcp or udp. One of: [tcp] [udp]";
    public static final String CAMEL_SOURCE_NETTY_PATH_PROTOCOL_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_PATH_HOST_CONF = "camel.source.path.host";
    public static final String CAMEL_SOURCE_NETTY_PATH_HOST_DOC = "The hostname. For the consumer the hostname is localhost or 0.0.0.0. For the producer the hostname is the remote host to connect to";
    public static final String CAMEL_SOURCE_NETTY_PATH_HOST_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_PATH_PORT_CONF = "camel.source.path.port";
    public static final String CAMEL_SOURCE_NETTY_PATH_PORT_DOC = "The host port number";
    public static final Integer CAMEL_SOURCE_NETTY_PATH_PORT_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_DISCONNECT_CONF = "camel.source.endpoint.disconnect";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_DISCONNECT_DOC = "Whether or not to disconnect(close) from Netty Channel right after use. Can be used for both consumer and producer.";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_DISCONNECT_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_KEEP_ALIVE_CONF = "camel.source.endpoint.keepAlive";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_KEEP_ALIVE_DOC = "Setting to ensure socket is not closed due to inactivity";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_KEEP_ALIVE_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_REUSE_ADDRESS_CONF = "camel.source.endpoint.reuseAddress";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_REUSE_ADDRESS_DOC = "Setting to facilitate socket multiplexing";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_REUSE_ADDRESS_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_REUSE_CHANNEL_CONF = "camel.source.endpoint.reuseChannel";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_REUSE_CHANNEL_DOC = "This option allows producers and consumers (in client mode) to reuse the same Netty Channel for the lifecycle of processing the Exchange. This is useful if you need to call a server multiple times in a Camel route and want to use the same network connection. When using this, the channel is not returned to the connection pool until the Exchange is done; or disconnected if the disconnect option is set to true. The reused Channel is stored on the Exchange as an exchange property with the key NettyConstants#NETTY_CHANNEL which allows you to obtain the channel during routing and use it as well.";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_REUSE_CHANNEL_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SYNC_CONF = "camel.source.endpoint.sync";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SYNC_DOC = "Setting to set endpoint as one-way or request-response";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_SYNC_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_TCP_NO_DELAY_CONF = "camel.source.endpoint.tcpNoDelay";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_TCP_NO_DELAY_DOC = "Setting to improve TCP protocol performance";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_TCP_NO_DELAY_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_BROADCAST_CONF = "camel.source.endpoint.broadcast";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_BROADCAST_DOC = "Setting to choose Multicast over UDP";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_BROADCAST_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_CLIENT_MODE_CONF = "camel.source.endpoint.clientMode";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_CLIENT_MODE_DOC = "If the clientMode is true, netty consumer will connect the address as a TCP client.";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_CLIENT_MODE_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_RECONNECT_CONF = "camel.source.endpoint.reconnect";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_RECONNECT_DOC = "Used only in clientMode in consumer, the consumer will attempt to reconnect on disconnection if this is enabled";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_RECONNECT_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_RECONNECT_INTERVAL_CONF = "camel.source.endpoint.reconnectInterval";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_RECONNECT_INTERVAL_DOC = "Used if reconnect and clientMode is enabled. The interval in milli seconds to attempt reconnection";
    public static final Integer CAMEL_SOURCE_NETTY_ENDPOINT_RECONNECT_INTERVAL_DEFAULT = 10000;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_BACKLOG_CONF = "camel.source.endpoint.backlog";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_BACKLOG_DOC = "Allows to configure a backlog for netty consumer (server). Note the backlog is just a best effort depending on the OS. Setting this option to a value such as 200, 500 or 1000, tells the TCP stack how long the accept queue can be If this option is not configured, then the backlog depends on OS setting.";
    public static final Integer CAMEL_SOURCE_NETTY_ENDPOINT_BACKLOG_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_BOSS_COUNT_CONF = "camel.source.endpoint.bossCount";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_BOSS_COUNT_DOC = "When netty works on nio mode, it uses default bossCount parameter from Netty, which is 1. User can use this option to override the default bossCount from Netty";
    public static final Integer CAMEL_SOURCE_NETTY_ENDPOINT_BOSS_COUNT_DEFAULT = 1;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_BOSS_GROUP_CONF = "camel.source.endpoint.bossGroup";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_BOSS_GROUP_DOC = "Set the BossGroup which could be used for handling the new connection of the server side across the NettyEndpoint";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_BOSS_GROUP_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_DISCONNECT_ON_NO_REPLY_CONF = "camel.source.endpoint.disconnectOnNoReply";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_DISCONNECT_ON_NO_REPLY_DOC = "If sync is enabled then this option dictates NettyConsumer if it should disconnect where there is no reply to send back.";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_DISCONNECT_ON_NO_REPLY_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_NETTY_SERVER_BOOTSTRAP_FACTORY_CONF = "camel.source.endpoint.nettyServerBootstrapFactory";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_NETTY_SERVER_BOOTSTRAP_FACTORY_DOC = "To use a custom NettyServerBootstrapFactory";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_NETTY_SERVER_BOOTSTRAP_FACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_NETWORK_INTERFACE_CONF = "camel.source.endpoint.networkInterface";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_NETWORK_INTERFACE_DOC = "When using UDP then this option can be used to specify a network interface by its name, such as eth0 to join a multicast group.";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_NETWORK_INTERFACE_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_NO_REPLY_LOG_LEVEL_CONF = "camel.source.endpoint.noReplyLogLevel";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_NO_REPLY_LOG_LEVEL_DOC = "If sync is enabled this option dictates NettyConsumer which logging level to use when logging a there is no reply to send back. One of: [TRACE] [DEBUG] [INFO] [WARN] [ERROR] [OFF]";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_NO_REPLY_LOG_LEVEL_DEFAULT = "WARN";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_CLOSED_CHANNEL_EXCEPTION_CAUGHT_LOG_LEVEL_CONF = "camel.source.endpoint.serverClosedChannelExceptionCaughtLogLevel";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_CLOSED_CHANNEL_EXCEPTION_CAUGHT_LOG_LEVEL_DOC = "If the server (NettyConsumer) catches an java.nio.channels.ClosedChannelException then its logged using this logging level. This is used to avoid logging the closed channel exceptions, as clients can disconnect abruptly and then cause a flood of closed exceptions in the Netty server. One of: [TRACE] [DEBUG] [INFO] [WARN] [ERROR] [OFF]";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_CLOSED_CHANNEL_EXCEPTION_CAUGHT_LOG_LEVEL_DEFAULT = "DEBUG";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_EXCEPTION_CAUGHT_LOG_LEVEL_CONF = "camel.source.endpoint.serverExceptionCaughtLogLevel";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_EXCEPTION_CAUGHT_LOG_LEVEL_DOC = "If the server (NettyConsumer) catches an exception then its logged using this logging level. One of: [TRACE] [DEBUG] [INFO] [WARN] [ERROR] [OFF]";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_EXCEPTION_CAUGHT_LOG_LEVEL_DEFAULT = "WARN";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_INITIALIZER_FACTORY_CONF = "camel.source.endpoint.serverInitializerFactory";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_INITIALIZER_FACTORY_DOC = "To use a custom ServerInitializerFactory";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_INITIALIZER_FACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_USING_EXECUTOR_SERVICE_CONF = "camel.source.endpoint.usingExecutorService";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_USING_EXECUTOR_SERVICE_DOC = "Whether to use ordered thread pool, to ensure events are processed orderly on the same channel.";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_USING_EXECUTOR_SERVICE_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_ALLOW_SERIALIZED_HEADERS_CONF = "camel.source.endpoint.allowSerializedHeaders";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_ALLOW_SERIALIZED_HEADERS_DOC = "Only used for TCP when transferExchange is true. When set to true, serializable objects in headers and properties will be added to the exchange. Otherwise Camel will exclude any non-serializable objects and log it at WARN level.";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_ALLOW_SERIALIZED_HEADERS_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_CHANNEL_GROUP_CONF = "camel.source.endpoint.channelGroup";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_CHANNEL_GROUP_DOC = "To use a explicit ChannelGroup.";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_CHANNEL_GROUP_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_NATIVE_TRANSPORT_CONF = "camel.source.endpoint.nativeTransport";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_NATIVE_TRANSPORT_DOC = "Whether to use native transport instead of NIO. Native transport takes advantage of the host operating system and is only supported on some platforms. You need to add the netty JAR for the host operating system you are using. See more details at: http://netty.io/wiki/native-transports.html";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_NATIVE_TRANSPORT_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_OPTIONS_CONF = "camel.source.endpoint.options";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_OPTIONS_DOC = "Allows to configure additional netty options using option. as prefix. For example option.child.keepAlive=false to set the netty option child.keepAlive=false. See the Netty documentation for possible options that can be used.";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_OPTIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_CONF = "camel.source.endpoint.receiveBufferSize";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_DOC = "The TCP/UDP buffer sizes to be used during inbound communication. Size is bytes.";
    public static final Integer CAMEL_SOURCE_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_DEFAULT = 65536;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_PREDICTOR_CONF = "camel.source.endpoint.receiveBufferSizePredictor";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_PREDICTOR_DOC = "Configures the buffer size predictor. See details at Jetty documentation and this mail thread.";
    public static final Integer CAMEL_SOURCE_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_PREDICTOR_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SEND_BUFFER_SIZE_CONF = "camel.source.endpoint.sendBufferSize";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SEND_BUFFER_SIZE_DOC = "The TCP/UDP buffer sizes to be used during outbound communication. Size is bytes.";
    public static final Integer CAMEL_SOURCE_NETTY_ENDPOINT_SEND_BUFFER_SIZE_DEFAULT = 65536;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_TRANSFER_EXCHANGE_CONF = "camel.source.endpoint.transferExchange";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_TRANSFER_EXCHANGE_DOC = "Only used for TCP. You can transfer the exchange over the wire instead of just the body. The following fields are transferred: In body, Out body, fault body, In headers, Out headers, fault headers, exchange properties, exchange exception. This requires that the objects are serializable. Camel will exclude any non-serializable objects and log it at WARN level.";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_TRANSFER_EXCHANGE_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_UDP_BYTE_ARRAY_CODEC_CONF = "camel.source.endpoint.udpByteArrayCodec";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_UDP_BYTE_ARRAY_CODEC_DOC = "For UDP only. If enabled the using byte array codec instead of Java serialization protocol.";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_UDP_BYTE_ARRAY_CODEC_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_WORKER_COUNT_CONF = "camel.source.endpoint.workerCount";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_WORKER_COUNT_DOC = "When netty works on nio mode, it uses default workerCount parameter from Netty (which is cpu_core_threads x 2). User can use this option to override the default workerCount from Netty.";
    public static final Integer CAMEL_SOURCE_NETTY_ENDPOINT_WORKER_COUNT_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_WORKER_GROUP_CONF = "camel.source.endpoint.workerGroup";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_WORKER_GROUP_DOC = "To use a explicit EventLoopGroup as the boss thread pool. For example to share a thread pool with multiple consumers or producers. By default each consumer or producer has their own worker pool with 2 x cpu count core threads.";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_WORKER_GROUP_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_ALLOW_DEFAULT_CODEC_CONF = "camel.source.endpoint.allowDefaultCodec";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_ALLOW_DEFAULT_CODEC_DOC = "The netty component installs a default codec if both, encoder/decoder is null and textline is false. Setting allowDefaultCodec to false prevents the netty component from installing a default codec as the first element in the filter chain.";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_ALLOW_DEFAULT_CODEC_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_AUTO_APPEND_DELIMITER_CONF = "camel.source.endpoint.autoAppendDelimiter";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_AUTO_APPEND_DELIMITER_DOC = "Whether or not to auto append missing end delimiter when sending using the textline codec.";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_AUTO_APPEND_DELIMITER_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_DECODER_MAX_LINE_LENGTH_CONF = "camel.source.endpoint.decoderMaxLineLength";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_DECODER_MAX_LINE_LENGTH_DOC = "The max line length to use for the textline codec.";
    public static final Integer CAMEL_SOURCE_NETTY_ENDPOINT_DECODER_MAX_LINE_LENGTH_DEFAULT = 1024;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_DECODERS_CONF = "camel.source.endpoint.decoders";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_DECODERS_DOC = "A list of decoders to be used. You can use a String which have values separated by comma, and have the values be looked up in the Registry. Just remember to prefix the value with # so Camel knows it should lookup.";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_DECODERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_DELIMITER_CONF = "camel.source.endpoint.delimiter";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_DELIMITER_DOC = "The delimiter to use for the textline codec. Possible values are LINE and NULL. One of: [LINE] [NULL]";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_DELIMITER_DEFAULT = "LINE";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_ENCODERS_CONF = "camel.source.endpoint.encoders";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_ENCODERS_DOC = "A list of encoders to be used. You can use a String which have values separated by comma, and have the values be looked up in the Registry. Just remember to prefix the value with # so Camel knows it should lookup.";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_ENCODERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_ENCODING_CONF = "camel.source.endpoint.encoding";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_ENCODING_DOC = "The encoding (a charset name) to use for the textline codec. If not provided, Camel will use the JVM default Charset.";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_ENCODING_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_TEXTLINE_CONF = "camel.source.endpoint.textline";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_TEXTLINE_DOC = "Only used for TCP. If no codec is specified, you can use this flag to indicate a text line based codec; if not specified or the value is false, then Object Serialization is assumed over TCP - however only Strings are allowed to be serialized by default.";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_TEXTLINE_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_ENABLED_PROTOCOLS_CONF = "camel.source.endpoint.enabledProtocols";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_ENABLED_PROTOCOLS_DOC = "Which protocols to enable when using SSL";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_ENABLED_PROTOCOLS_DEFAULT = "TLSv1,TLSv1.1,TLSv1.2";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_FILE_CONF = "camel.source.endpoint.keyStoreFile";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_FILE_DOC = "Client side certificate keystore to be used for encryption";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_FILE_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_FORMAT_CONF = "camel.source.endpoint.keyStoreFormat";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_FORMAT_DOC = "Keystore format to be used for payload encryption. Defaults to JKS if not set";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_FORMAT_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_RESOURCE_CONF = "camel.source.endpoint.keyStoreResource";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_RESOURCE_DOC = "Client side certificate keystore to be used for encryption. Is loaded by default from classpath, but you can prefix with classpath:, file:, or http: to load the resource from different systems.";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_RESOURCE_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_NEED_CLIENT_AUTH_CONF = "camel.source.endpoint.needClientAuth";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_NEED_CLIENT_AUTH_DOC = "Configures whether the server needs client authentication when using SSL.";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_NEED_CLIENT_AUTH_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_PASSPHRASE_CONF = "camel.source.endpoint.passphrase";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_PASSPHRASE_DOC = "Password setting to use in order to encrypt/decrypt payloads sent using SSH";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_PASSPHRASE_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SECURITY_PROVIDER_CONF = "camel.source.endpoint.securityProvider";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SECURITY_PROVIDER_DOC = "Security provider to be used for payload encryption. Defaults to SunX509 if not set.";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SECURITY_PROVIDER_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SSL_CONF = "camel.source.endpoint.ssl";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SSL_DOC = "Setting to specify whether SSL encryption is applied to this endpoint";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_SSL_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SSL_CLIENT_CERT_HEADERS_CONF = "camel.source.endpoint.sslClientCertHeaders";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SSL_CLIENT_CERT_HEADERS_DOC = "When enabled and in SSL mode, then the Netty consumer will enrich the Camel Message with headers having information about the client certificate such as subject name, issuer name, serial number, and the valid date range.";
    public static final Boolean CAMEL_SOURCE_NETTY_ENDPOINT_SSL_CLIENT_CERT_HEADERS_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SSL_CONTEXT_PARAMETERS_CONF = "camel.source.endpoint.sslContextParameters";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SSL_CONTEXT_PARAMETERS_DOC = "To configure security using SSLContextParameters";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SSL_CONTEXT_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SSL_HANDLER_CONF = "camel.source.endpoint.sslHandler";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SSL_HANDLER_DOC = "Reference to a class that could be used to return an SSL Handler";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_SSL_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_TRUST_STORE_FILE_CONF = "camel.source.endpoint.trustStoreFile";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_TRUST_STORE_FILE_DOC = "Server side certificate keystore to be used for encryption";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_TRUST_STORE_FILE_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_TRUST_STORE_RESOURCE_CONF = "camel.source.endpoint.trustStoreResource";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_TRUST_STORE_RESOURCE_DOC = "Server side certificate keystore to be used for encryption. Is loaded by default from classpath, but you can prefix with classpath:, file:, or http: to load the resource from different systems.";
    public static final String CAMEL_SOURCE_NETTY_ENDPOINT_TRUST_STORE_RESOURCE_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_CONFIGURATION_CONF = "camel.component.netty.configuration";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_CONFIGURATION_DOC = "To use the NettyConfiguration as configuration when creating endpoints.";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_DISCONNECT_CONF = "camel.component.netty.disconnect";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_DISCONNECT_DOC = "Whether or not to disconnect(close) from Netty Channel right after use. Can be used for both consumer and producer.";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_DISCONNECT_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_KEEP_ALIVE_CONF = "camel.component.netty.keepAlive";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_KEEP_ALIVE_DOC = "Setting to ensure socket is not closed due to inactivity";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_KEEP_ALIVE_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_REUSE_ADDRESS_CONF = "camel.component.netty.reuseAddress";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_REUSE_ADDRESS_DOC = "Setting to facilitate socket multiplexing";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_REUSE_ADDRESS_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_REUSE_CHANNEL_CONF = "camel.component.netty.reuseChannel";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_REUSE_CHANNEL_DOC = "This option allows producers and consumers (in client mode) to reuse the same Netty Channel for the lifecycle of processing the Exchange. This is useful if you need to call a server multiple times in a Camel route and want to use the same network connection. When using this, the channel is not returned to the connection pool until the Exchange is done; or disconnected if the disconnect option is set to true. The reused Channel is stored on the Exchange as an exchange property with the key NettyConstants#NETTY_CHANNEL which allows you to obtain the channel during routing and use it as well.";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_REUSE_CHANNEL_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SYNC_CONF = "camel.component.netty.sync";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SYNC_DOC = "Setting to set endpoint as one-way or request-response";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_SYNC_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_TCP_NO_DELAY_CONF = "camel.component.netty.tcpNoDelay";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_TCP_NO_DELAY_DOC = "Setting to improve TCP protocol performance";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_TCP_NO_DELAY_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.netty.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_BROADCAST_CONF = "camel.component.netty.broadcast";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_BROADCAST_DOC = "Setting to choose Multicast over UDP";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_BROADCAST_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_CLIENT_MODE_CONF = "camel.component.netty.clientMode";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_CLIENT_MODE_DOC = "If the clientMode is true, netty consumer will connect the address as a TCP client.";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_CLIENT_MODE_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_RECONNECT_CONF = "camel.component.netty.reconnect";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_RECONNECT_DOC = "Used only in clientMode in consumer, the consumer will attempt to reconnect on disconnection if this is enabled";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_RECONNECT_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_RECONNECT_INTERVAL_CONF = "camel.component.netty.reconnectInterval";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_RECONNECT_INTERVAL_DOC = "Used if reconnect and clientMode is enabled. The interval in milli seconds to attempt reconnection";
    public static final Integer CAMEL_SOURCE_NETTY_COMPONENT_RECONNECT_INTERVAL_DEFAULT = 10000;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_BACKLOG_CONF = "camel.component.netty.backlog";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_BACKLOG_DOC = "Allows to configure a backlog for netty consumer (server). Note the backlog is just a best effort depending on the OS. Setting this option to a value such as 200, 500 or 1000, tells the TCP stack how long the accept queue can be If this option is not configured, then the backlog depends on OS setting.";
    public static final Integer CAMEL_SOURCE_NETTY_COMPONENT_BACKLOG_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_BOSS_COUNT_CONF = "camel.component.netty.bossCount";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_BOSS_COUNT_DOC = "When netty works on nio mode, it uses default bossCount parameter from Netty, which is 1. User can use this option to override the default bossCount from Netty";
    public static final Integer CAMEL_SOURCE_NETTY_COMPONENT_BOSS_COUNT_DEFAULT = 1;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_BOSS_GROUP_CONF = "camel.component.netty.bossGroup";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_BOSS_GROUP_DOC = "Set the BossGroup which could be used for handling the new connection of the server side across the NettyEndpoint";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_BOSS_GROUP_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_DISCONNECT_ON_NO_REPLY_CONF = "camel.component.netty.disconnectOnNoReply";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_DISCONNECT_ON_NO_REPLY_DOC = "If sync is enabled then this option dictates NettyConsumer if it should disconnect where there is no reply to send back.";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_DISCONNECT_ON_NO_REPLY_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_EXECUTOR_SERVICE_CONF = "camel.component.netty.executorService";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_EXECUTOR_SERVICE_DOC = "To use the given EventExecutorGroup.";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_EXECUTOR_SERVICE_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_MAXIMUM_POOL_SIZE_CONF = "camel.component.netty.maximumPoolSize";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_MAXIMUM_POOL_SIZE_DOC = "Sets a maximum thread pool size for the netty consumer ordered thread pool. The default size is 2 x cpu_core plus 1. Setting this value to eg 10 will then use 10 threads unless 2 x cpu_core plus 1 is a higher value, which then will override and be used. For example if there are 8 cores, then the consumer thread pool will be 17. This thread pool is used to route messages received from Netty by Camel. We use a separate thread pool to ensure ordering of messages and also in case some messages will block, then nettys worker threads (event loop) wont be affected.";
    public static final Integer CAMEL_SOURCE_NETTY_COMPONENT_MAXIMUM_POOL_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_NETTY_SERVER_BOOTSTRAP_FACTORY_CONF = "camel.component.netty.nettyServerBootstrapFactory";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_NETTY_SERVER_BOOTSTRAP_FACTORY_DOC = "To use a custom NettyServerBootstrapFactory";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_NETTY_SERVER_BOOTSTRAP_FACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_NETWORK_INTERFACE_CONF = "camel.component.netty.networkInterface";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_NETWORK_INTERFACE_DOC = "When using UDP then this option can be used to specify a network interface by its name, such as eth0 to join a multicast group.";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_NETWORK_INTERFACE_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_NO_REPLY_LOG_LEVEL_CONF = "camel.component.netty.noReplyLogLevel";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_NO_REPLY_LOG_LEVEL_DOC = "If sync is enabled this option dictates NettyConsumer which logging level to use when logging a there is no reply to send back. One of: [TRACE] [DEBUG] [INFO] [WARN] [ERROR] [OFF]";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_NO_REPLY_LOG_LEVEL_DEFAULT = "WARN";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SERVER_CLOSED_CHANNEL_EXCEPTION_CAUGHT_LOG_LEVEL_CONF = "camel.component.netty.serverClosedChannelExceptionCaughtLogLevel";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SERVER_CLOSED_CHANNEL_EXCEPTION_CAUGHT_LOG_LEVEL_DOC = "If the server (NettyConsumer) catches an java.nio.channels.ClosedChannelException then its logged using this logging level. This is used to avoid logging the closed channel exceptions, as clients can disconnect abruptly and then cause a flood of closed exceptions in the Netty server. One of: [TRACE] [DEBUG] [INFO] [WARN] [ERROR] [OFF]";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SERVER_CLOSED_CHANNEL_EXCEPTION_CAUGHT_LOG_LEVEL_DEFAULT = "DEBUG";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SERVER_EXCEPTION_CAUGHT_LOG_LEVEL_CONF = "camel.component.netty.serverExceptionCaughtLogLevel";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SERVER_EXCEPTION_CAUGHT_LOG_LEVEL_DOC = "If the server (NettyConsumer) catches an exception then its logged using this logging level. One of: [TRACE] [DEBUG] [INFO] [WARN] [ERROR] [OFF]";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SERVER_EXCEPTION_CAUGHT_LOG_LEVEL_DEFAULT = "WARN";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SERVER_INITIALIZER_FACTORY_CONF = "camel.component.netty.serverInitializerFactory";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SERVER_INITIALIZER_FACTORY_DOC = "To use a custom ServerInitializerFactory";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SERVER_INITIALIZER_FACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_USING_EXECUTOR_SERVICE_CONF = "camel.component.netty.usingExecutorService";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_USING_EXECUTOR_SERVICE_DOC = "Whether to use ordered thread pool, to ensure events are processed orderly on the same channel.";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_USING_EXECUTOR_SERVICE_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_ALLOW_SERIALIZED_HEADERS_CONF = "camel.component.netty.allowSerializedHeaders";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_ALLOW_SERIALIZED_HEADERS_DOC = "Only used for TCP when transferExchange is true. When set to true, serializable objects in headers and properties will be added to the exchange. Otherwise Camel will exclude any non-serializable objects and log it at WARN level.";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_ALLOW_SERIALIZED_HEADERS_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.netty.autowiredEnabled";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_CHANNEL_GROUP_CONF = "camel.component.netty.channelGroup";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_CHANNEL_GROUP_DOC = "To use a explicit ChannelGroup.";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_CHANNEL_GROUP_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_NATIVE_TRANSPORT_CONF = "camel.component.netty.nativeTransport";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_NATIVE_TRANSPORT_DOC = "Whether to use native transport instead of NIO. Native transport takes advantage of the host operating system and is only supported on some platforms. You need to add the netty JAR for the host operating system you are using. See more details at: http://netty.io/wiki/native-transports.html";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_NATIVE_TRANSPORT_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_OPTIONS_CONF = "camel.component.netty.options";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_OPTIONS_DOC = "Allows to configure additional netty options using option. as prefix. For example option.child.keepAlive=false to set the netty option child.keepAlive=false. See the Netty documentation for possible options that can be used.";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_OPTIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_RECEIVE_BUFFER_SIZE_CONF = "camel.component.netty.receiveBufferSize";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_RECEIVE_BUFFER_SIZE_DOC = "The TCP/UDP buffer sizes to be used during inbound communication. Size is bytes.";
    public static final Integer CAMEL_SOURCE_NETTY_COMPONENT_RECEIVE_BUFFER_SIZE_DEFAULT = 65536;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_RECEIVE_BUFFER_SIZE_PREDICTOR_CONF = "camel.component.netty.receiveBufferSizePredictor";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_RECEIVE_BUFFER_SIZE_PREDICTOR_DOC = "Configures the buffer size predictor. See details at Jetty documentation and this mail thread.";
    public static final Integer CAMEL_SOURCE_NETTY_COMPONENT_RECEIVE_BUFFER_SIZE_PREDICTOR_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SEND_BUFFER_SIZE_CONF = "camel.component.netty.sendBufferSize";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SEND_BUFFER_SIZE_DOC = "The TCP/UDP buffer sizes to be used during outbound communication. Size is bytes.";
    public static final Integer CAMEL_SOURCE_NETTY_COMPONENT_SEND_BUFFER_SIZE_DEFAULT = 65536;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_TRANSFER_EXCHANGE_CONF = "camel.component.netty.transferExchange";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_TRANSFER_EXCHANGE_DOC = "Only used for TCP. You can transfer the exchange over the wire instead of just the body. The following fields are transferred: In body, Out body, fault body, In headers, Out headers, fault headers, exchange properties, exchange exception. This requires that the objects are serializable. Camel will exclude any non-serializable objects and log it at WARN level.";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_TRANSFER_EXCHANGE_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_UDP_BYTE_ARRAY_CODEC_CONF = "camel.component.netty.udpByteArrayCodec";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_UDP_BYTE_ARRAY_CODEC_DOC = "For UDP only. If enabled the using byte array codec instead of Java serialization protocol.";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_UDP_BYTE_ARRAY_CODEC_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_WORKER_COUNT_CONF = "camel.component.netty.workerCount";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_WORKER_COUNT_DOC = "When netty works on nio mode, it uses default workerCount parameter from Netty (which is cpu_core_threads x 2). User can use this option to override the default workerCount from Netty.";
    public static final Integer CAMEL_SOURCE_NETTY_COMPONENT_WORKER_COUNT_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_WORKER_GROUP_CONF = "camel.component.netty.workerGroup";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_WORKER_GROUP_DOC = "To use a explicit EventLoopGroup as the boss thread pool. For example to share a thread pool with multiple consumers or producers. By default each consumer or producer has their own worker pool with 2 x cpu count core threads.";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_WORKER_GROUP_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_ALLOW_DEFAULT_CODEC_CONF = "camel.component.netty.allowDefaultCodec";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_ALLOW_DEFAULT_CODEC_DOC = "The netty component installs a default codec if both, encoder/decoder is null and textline is false. Setting allowDefaultCodec to false prevents the netty component from installing a default codec as the first element in the filter chain.";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_ALLOW_DEFAULT_CODEC_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_AUTO_APPEND_DELIMITER_CONF = "camel.component.netty.autoAppendDelimiter";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_AUTO_APPEND_DELIMITER_DOC = "Whether or not to auto append missing end delimiter when sending using the textline codec.";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_AUTO_APPEND_DELIMITER_DEFAULT = true;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_DECODER_MAX_LINE_LENGTH_CONF = "camel.component.netty.decoderMaxLineLength";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_DECODER_MAX_LINE_LENGTH_DOC = "The max line length to use for the textline codec.";
    public static final Integer CAMEL_SOURCE_NETTY_COMPONENT_DECODER_MAX_LINE_LENGTH_DEFAULT = 1024;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_DECODERS_CONF = "camel.component.netty.decoders";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_DECODERS_DOC = "A list of decoders to be used. You can use a String which have values separated by comma, and have the values be looked up in the Registry. Just remember to prefix the value with # so Camel knows it should lookup.";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_DECODERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_DELIMITER_CONF = "camel.component.netty.delimiter";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_DELIMITER_DOC = "The delimiter to use for the textline codec. Possible values are LINE and NULL. One of: [LINE] [NULL]";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_DELIMITER_DEFAULT = "LINE";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_ENCODERS_CONF = "camel.component.netty.encoders";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_ENCODERS_DOC = "A list of encoders to be used. You can use a String which have values separated by comma, and have the values be looked up in the Registry. Just remember to prefix the value with # so Camel knows it should lookup.";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_ENCODERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_ENCODING_CONF = "camel.component.netty.encoding";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_ENCODING_DOC = "The encoding (a charset name) to use for the textline codec. If not provided, Camel will use the JVM default Charset.";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_ENCODING_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_TEXTLINE_CONF = "camel.component.netty.textline";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_TEXTLINE_DOC = "Only used for TCP. If no codec is specified, you can use this flag to indicate a text line based codec; if not specified or the value is false, then Object Serialization is assumed over TCP - however only Strings are allowed to be serialized by default.";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_TEXTLINE_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_ENABLED_PROTOCOLS_CONF = "camel.component.netty.enabledProtocols";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_ENABLED_PROTOCOLS_DOC = "Which protocols to enable when using SSL";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_ENABLED_PROTOCOLS_DEFAULT = "TLSv1,TLSv1.1,TLSv1.2";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_FILE_CONF = "camel.component.netty.keyStoreFile";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_FILE_DOC = "Client side certificate keystore to be used for encryption";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_FILE_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_FORMAT_CONF = "camel.component.netty.keyStoreFormat";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_FORMAT_DOC = "Keystore format to be used for payload encryption. Defaults to JKS if not set";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_FORMAT_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_RESOURCE_CONF = "camel.component.netty.keyStoreResource";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_RESOURCE_DOC = "Client side certificate keystore to be used for encryption. Is loaded by default from classpath, but you can prefix with classpath:, file:, or http: to load the resource from different systems.";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_RESOURCE_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_NEED_CLIENT_AUTH_CONF = "camel.component.netty.needClientAuth";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_NEED_CLIENT_AUTH_DOC = "Configures whether the server needs client authentication when using SSL.";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_NEED_CLIENT_AUTH_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_PASSPHRASE_CONF = "camel.component.netty.passphrase";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_PASSPHRASE_DOC = "Password setting to use in order to encrypt/decrypt payloads sent using SSH";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_PASSPHRASE_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SECURITY_PROVIDER_CONF = "camel.component.netty.securityProvider";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SECURITY_PROVIDER_DOC = "Security provider to be used for payload encryption. Defaults to SunX509 if not set.";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SECURITY_PROVIDER_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SSL_CONF = "camel.component.netty.ssl";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SSL_DOC = "Setting to specify whether SSL encryption is applied to this endpoint";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_SSL_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SSL_CLIENT_CERT_HEADERS_CONF = "camel.component.netty.sslClientCertHeaders";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SSL_CLIENT_CERT_HEADERS_DOC = "When enabled and in SSL mode, then the Netty consumer will enrich the Camel Message with headers having information about the client certificate such as subject name, issuer name, serial number, and the valid date range.";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_SSL_CLIENT_CERT_HEADERS_DEFAULT = false;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SSL_CONTEXT_PARAMETERS_CONF = "camel.component.netty.sslContextParameters";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SSL_CONTEXT_PARAMETERS_DOC = "To configure security using SSLContextParameters";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SSL_CONTEXT_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SSL_HANDLER_CONF = "camel.component.netty.sslHandler";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SSL_HANDLER_DOC = "Reference to a class that could be used to return an SSL Handler";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_SSL_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_TRUST_STORE_FILE_CONF = "camel.component.netty.trustStoreFile";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_TRUST_STORE_FILE_DOC = "Server side certificate keystore to be used for encryption";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_TRUST_STORE_FILE_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_TRUST_STORE_RESOURCE_CONF = "camel.component.netty.trustStoreResource";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_TRUST_STORE_RESOURCE_DOC = "Server side certificate keystore to be used for encryption. Is loaded by default from classpath, but you can prefix with classpath:, file:, or http: to load the resource from different systems.";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_TRUST_STORE_RESOURCE_DEFAULT = null;
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF = "camel.component.netty.useGlobalSslContextParameters";
    public static final String CAMEL_SOURCE_NETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC = "Enable usage of global SSL context parameters.";
    public static final Boolean CAMEL_SOURCE_NETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT = false;

    public CamelNettySourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelNettySourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_NETTY_PATH_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_PATH_PROTOCOL_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_NETTY_PATH_PROTOCOL_DOC);
        conf.define(CAMEL_SOURCE_NETTY_PATH_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_PATH_HOST_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_NETTY_PATH_HOST_DOC);
        conf.define(CAMEL_SOURCE_NETTY_PATH_PORT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_PATH_PORT_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_NETTY_PATH_PORT_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_DISCONNECT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_DISCONNECT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_DISCONNECT_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_KEEP_ALIVE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_KEEP_ALIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_KEEP_ALIVE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_REUSE_ADDRESS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_REUSE_ADDRESS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_REUSE_ADDRESS_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_REUSE_CHANNEL_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_REUSE_CHANNEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_REUSE_CHANNEL_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_SYNC_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_SYNC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_SYNC_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_TCP_NO_DELAY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_TCP_NO_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_TCP_NO_DELAY_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_BROADCAST_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_BROADCAST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_BROADCAST_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_CLIENT_MODE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_CLIENT_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_CLIENT_MODE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_RECONNECT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_RECONNECT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_RECONNECT_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_RECONNECT_INTERVAL_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_ENDPOINT_RECONNECT_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_RECONNECT_INTERVAL_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_BACKLOG_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_ENDPOINT_BACKLOG_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_BACKLOG_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_BOSS_COUNT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_ENDPOINT_BOSS_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_BOSS_COUNT_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_BOSS_GROUP_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_BOSS_GROUP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_BOSS_GROUP_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_DISCONNECT_ON_NO_REPLY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_DISCONNECT_ON_NO_REPLY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_DISCONNECT_ON_NO_REPLY_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_NETTY_SERVER_BOOTSTRAP_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_NETTY_SERVER_BOOTSTRAP_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_NETTY_SERVER_BOOTSTRAP_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_NETWORK_INTERFACE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_NETWORK_INTERFACE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_NETWORK_INTERFACE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_NO_REPLY_LOG_LEVEL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_NO_REPLY_LOG_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_NO_REPLY_LOG_LEVEL_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_CLOSED_CHANNEL_EXCEPTION_CAUGHT_LOG_LEVEL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_CLOSED_CHANNEL_EXCEPTION_CAUGHT_LOG_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_CLOSED_CHANNEL_EXCEPTION_CAUGHT_LOG_LEVEL_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_EXCEPTION_CAUGHT_LOG_LEVEL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_EXCEPTION_CAUGHT_LOG_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_EXCEPTION_CAUGHT_LOG_LEVEL_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_INITIALIZER_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_INITIALIZER_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_SERVER_INITIALIZER_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_USING_EXECUTOR_SERVICE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_USING_EXECUTOR_SERVICE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_USING_EXECUTOR_SERVICE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_ALLOW_SERIALIZED_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_ALLOW_SERIALIZED_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_ALLOW_SERIALIZED_HEADERS_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_CHANNEL_GROUP_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_CHANNEL_GROUP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_CHANNEL_GROUP_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_NATIVE_TRANSPORT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_NATIVE_TRANSPORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_NATIVE_TRANSPORT_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_OPTIONS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_OPTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_OPTIONS_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_PREDICTOR_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_PREDICTOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_RECEIVE_BUFFER_SIZE_PREDICTOR_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_SEND_BUFFER_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_ENDPOINT_SEND_BUFFER_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_SEND_BUFFER_SIZE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_TRANSFER_EXCHANGE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_TRANSFER_EXCHANGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_TRANSFER_EXCHANGE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_UDP_BYTE_ARRAY_CODEC_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_UDP_BYTE_ARRAY_CODEC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_UDP_BYTE_ARRAY_CODEC_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_WORKER_COUNT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_ENDPOINT_WORKER_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_WORKER_COUNT_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_WORKER_GROUP_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_WORKER_GROUP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_WORKER_GROUP_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_ALLOW_DEFAULT_CODEC_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_ALLOW_DEFAULT_CODEC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_ALLOW_DEFAULT_CODEC_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_AUTO_APPEND_DELIMITER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_AUTO_APPEND_DELIMITER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_AUTO_APPEND_DELIMITER_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_DECODER_MAX_LINE_LENGTH_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_ENDPOINT_DECODER_MAX_LINE_LENGTH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_DECODER_MAX_LINE_LENGTH_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_DECODERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_DECODERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_DECODERS_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_DELIMITER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_DELIMITER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_DELIMITER_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_ENCODERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_ENCODERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_ENCODERS_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_ENCODING_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_ENCODING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_ENCODING_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_TEXTLINE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_TEXTLINE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_TEXTLINE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_ENABLED_PROTOCOLS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_ENABLED_PROTOCOLS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_ENABLED_PROTOCOLS_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_FILE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_FILE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_FILE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_FORMAT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_FORMAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_FORMAT_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_RESOURCE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_RESOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_KEY_STORE_RESOURCE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_NEED_CLIENT_AUTH_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_NEED_CLIENT_AUTH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_NEED_CLIENT_AUTH_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_PASSPHRASE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_PASSPHRASE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_PASSPHRASE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_SECURITY_PROVIDER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_SECURITY_PROVIDER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_SECURITY_PROVIDER_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_SSL_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_SSL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_SSL_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_SSL_CLIENT_CERT_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_ENDPOINT_SSL_CLIENT_CERT_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_SSL_CLIENT_CERT_HEADERS_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_SSL_CONTEXT_PARAMETERS_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_SSL_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_SSL_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_SSL_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_TRUST_STORE_FILE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_TRUST_STORE_FILE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_TRUST_STORE_FILE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_ENDPOINT_TRUST_STORE_RESOURCE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_ENDPOINT_TRUST_STORE_RESOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_ENDPOINT_TRUST_STORE_RESOURCE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_DISCONNECT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_DISCONNECT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_DISCONNECT_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_KEEP_ALIVE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_KEEP_ALIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_KEEP_ALIVE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_REUSE_ADDRESS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_REUSE_ADDRESS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_REUSE_ADDRESS_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_REUSE_CHANNEL_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_REUSE_CHANNEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_REUSE_CHANNEL_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_SYNC_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_SYNC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_SYNC_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_TCP_NO_DELAY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_TCP_NO_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_TCP_NO_DELAY_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_BROADCAST_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_BROADCAST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_BROADCAST_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_CLIENT_MODE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_CLIENT_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_CLIENT_MODE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_RECONNECT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_RECONNECT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_RECONNECT_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_RECONNECT_INTERVAL_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_COMPONENT_RECONNECT_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_RECONNECT_INTERVAL_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_BACKLOG_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_COMPONENT_BACKLOG_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_BACKLOG_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_BOSS_COUNT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_COMPONENT_BOSS_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_BOSS_COUNT_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_BOSS_GROUP_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_BOSS_GROUP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_BOSS_GROUP_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_DISCONNECT_ON_NO_REPLY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_DISCONNECT_ON_NO_REPLY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_DISCONNECT_ON_NO_REPLY_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_EXECUTOR_SERVICE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_EXECUTOR_SERVICE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_EXECUTOR_SERVICE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_MAXIMUM_POOL_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_COMPONENT_MAXIMUM_POOL_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_MAXIMUM_POOL_SIZE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_NETTY_SERVER_BOOTSTRAP_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_NETTY_SERVER_BOOTSTRAP_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_NETTY_SERVER_BOOTSTRAP_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_NETWORK_INTERFACE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_NETWORK_INTERFACE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_NETWORK_INTERFACE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_NO_REPLY_LOG_LEVEL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_NO_REPLY_LOG_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_NO_REPLY_LOG_LEVEL_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_SERVER_CLOSED_CHANNEL_EXCEPTION_CAUGHT_LOG_LEVEL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_SERVER_CLOSED_CHANNEL_EXCEPTION_CAUGHT_LOG_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_SERVER_CLOSED_CHANNEL_EXCEPTION_CAUGHT_LOG_LEVEL_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_SERVER_EXCEPTION_CAUGHT_LOG_LEVEL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_SERVER_EXCEPTION_CAUGHT_LOG_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_SERVER_EXCEPTION_CAUGHT_LOG_LEVEL_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_SERVER_INITIALIZER_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_SERVER_INITIALIZER_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_SERVER_INITIALIZER_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_USING_EXECUTOR_SERVICE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_USING_EXECUTOR_SERVICE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_USING_EXECUTOR_SERVICE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_ALLOW_SERIALIZED_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_ALLOW_SERIALIZED_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_ALLOW_SERIALIZED_HEADERS_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_CHANNEL_GROUP_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_CHANNEL_GROUP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_CHANNEL_GROUP_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_NATIVE_TRANSPORT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_NATIVE_TRANSPORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_NATIVE_TRANSPORT_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_OPTIONS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_OPTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_OPTIONS_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_RECEIVE_BUFFER_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_COMPONENT_RECEIVE_BUFFER_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_RECEIVE_BUFFER_SIZE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_RECEIVE_BUFFER_SIZE_PREDICTOR_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_COMPONENT_RECEIVE_BUFFER_SIZE_PREDICTOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_RECEIVE_BUFFER_SIZE_PREDICTOR_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_SEND_BUFFER_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_COMPONENT_SEND_BUFFER_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_SEND_BUFFER_SIZE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_TRANSFER_EXCHANGE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_TRANSFER_EXCHANGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_TRANSFER_EXCHANGE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_UDP_BYTE_ARRAY_CODEC_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_UDP_BYTE_ARRAY_CODEC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_UDP_BYTE_ARRAY_CODEC_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_WORKER_COUNT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_COMPONENT_WORKER_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_WORKER_COUNT_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_WORKER_GROUP_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_WORKER_GROUP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_WORKER_GROUP_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_ALLOW_DEFAULT_CODEC_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_ALLOW_DEFAULT_CODEC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_ALLOW_DEFAULT_CODEC_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_AUTO_APPEND_DELIMITER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_AUTO_APPEND_DELIMITER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_AUTO_APPEND_DELIMITER_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_DECODER_MAX_LINE_LENGTH_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_NETTY_COMPONENT_DECODER_MAX_LINE_LENGTH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_DECODER_MAX_LINE_LENGTH_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_DECODERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_DECODERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_DECODERS_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_DELIMITER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_DELIMITER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_DELIMITER_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_ENCODERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_ENCODERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_ENCODERS_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_ENCODING_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_ENCODING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_ENCODING_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_TEXTLINE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_TEXTLINE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_TEXTLINE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_ENABLED_PROTOCOLS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_ENABLED_PROTOCOLS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_ENABLED_PROTOCOLS_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_FILE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_FILE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_FILE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_FORMAT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_FORMAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_FORMAT_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_RESOURCE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_RESOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_KEY_STORE_RESOURCE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_NEED_CLIENT_AUTH_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_NEED_CLIENT_AUTH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_NEED_CLIENT_AUTH_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_PASSPHRASE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_PASSPHRASE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_PASSPHRASE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_SECURITY_PROVIDER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_SECURITY_PROVIDER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_SECURITY_PROVIDER_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_SSL_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_SSL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_SSL_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_SSL_CLIENT_CERT_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_SSL_CLIENT_CERT_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_SSL_CLIENT_CERT_HEADERS_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_SSL_CONTEXT_PARAMETERS_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_SSL_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_SSL_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_SSL_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_TRUST_STORE_FILE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_TRUST_STORE_FILE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_TRUST_STORE_FILE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_TRUST_STORE_RESOURCE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NETTY_COMPONENT_TRUST_STORE_RESOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_TRUST_STORE_RESOURCE_DOC);
        conf.define(CAMEL_SOURCE_NETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NETTY_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC);
        return conf;
    }
}