/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.irc;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelIrcSourceConnectorConfig extends CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_IRC_PATH_HOSTNAME_CONF = "camel.source.path.hostname";
    public static final String CAMEL_SOURCE_IRC_PATH_HOSTNAME_DOC = "Hostname for the IRC chat server";
    public static final String CAMEL_SOURCE_IRC_PATH_HOSTNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_IRC_PATH_PORT_CONF = "camel.source.path.port";
    public static final String CAMEL_SOURCE_IRC_PATH_PORT_DOC = "Port number for the IRC chat server. If no port is configured then a default port of either 6667, 6668 or 6669 is used.";
    public static final Integer CAMEL_SOURCE_IRC_PATH_PORT_DEFAULT = null;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_AUTO_REJOIN_CONF = "camel.source.endpoint.autoRejoin";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_AUTO_REJOIN_DOC = "Whether to auto re-join when being kicked";
    public static final Boolean CAMEL_SOURCE_IRC_ENDPOINT_AUTO_REJOIN_DEFAULT = true;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_CHANNELS_CONF = "camel.source.endpoint.channels";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_CHANNELS_DOC = "Comma separated list of IRC channels.";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_CHANNELS_DEFAULT = null;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_COMMAND_TIMEOUT_CONF = "camel.source.endpoint.commandTimeout";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_COMMAND_TIMEOUT_DOC = "Delay in milliseconds before sending commands after the connection is established.";
    public static final Long CAMEL_SOURCE_IRC_ENDPOINT_COMMAND_TIMEOUT_DEFAULT = 5000L;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_KEYS_CONF = "camel.source.endpoint.keys";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_KEYS_DOC = "Comma separated list of keys for channels.";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_KEYS_DEFAULT = null;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_NAMES_ON_JOIN_CONF = "camel.source.endpoint.namesOnJoin";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_NAMES_ON_JOIN_DOC = "Sends NAMES command to channel after joining it. onReply has to be true in order to process the result which will have the header value irc.num = '353'.";
    public static final Boolean CAMEL_SOURCE_IRC_ENDPOINT_NAMES_ON_JOIN_DEFAULT = false;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_NICKNAME_CONF = "camel.source.endpoint.nickname";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_NICKNAME_DOC = "The nickname used in chat.";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_NICKNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_PERSISTENT_CONF = "camel.source.endpoint.persistent";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_PERSISTENT_DOC = "Use persistent messages.";
    public static final Boolean CAMEL_SOURCE_IRC_ENDPOINT_PERSISTENT_DEFAULT = true;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_REALNAME_CONF = "camel.source.endpoint.realname";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_REALNAME_DOC = "The IRC user's actual name.";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_REALNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_IRC_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_COLORS_CONF = "camel.source.endpoint.colors";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_COLORS_DOC = "Whether or not the server supports color codes.";
    public static final Boolean CAMEL_SOURCE_IRC_ENDPOINT_COLORS_DEFAULT = true;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_IRC_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_JOIN_CONF = "camel.source.endpoint.onJoin";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_JOIN_DOC = "Handle user join events.";
    public static final Boolean CAMEL_SOURCE_IRC_ENDPOINT_ON_JOIN_DEFAULT = true;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_KICK_CONF = "camel.source.endpoint.onKick";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_KICK_DOC = "Handle kick events.";
    public static final Boolean CAMEL_SOURCE_IRC_ENDPOINT_ON_KICK_DEFAULT = true;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_MODE_CONF = "camel.source.endpoint.onMode";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_MODE_DOC = "Handle mode change events.";
    public static final Boolean CAMEL_SOURCE_IRC_ENDPOINT_ON_MODE_DEFAULT = true;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_NICK_CONF = "camel.source.endpoint.onNick";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_NICK_DOC = "Handle nickname change events.";
    public static final Boolean CAMEL_SOURCE_IRC_ENDPOINT_ON_NICK_DEFAULT = true;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_PART_CONF = "camel.source.endpoint.onPart";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_PART_DOC = "Handle user part events.";
    public static final Boolean CAMEL_SOURCE_IRC_ENDPOINT_ON_PART_DEFAULT = true;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_PRIVMSG_CONF = "camel.source.endpoint.onPrivmsg";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_PRIVMSG_DOC = "Handle private message events.";
    public static final Boolean CAMEL_SOURCE_IRC_ENDPOINT_ON_PRIVMSG_DEFAULT = true;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_QUIT_CONF = "camel.source.endpoint.onQuit";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_QUIT_DOC = "Handle user quit events.";
    public static final Boolean CAMEL_SOURCE_IRC_ENDPOINT_ON_QUIT_DEFAULT = true;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_REPLY_CONF = "camel.source.endpoint.onReply";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_REPLY_DOC = "Whether or not to handle general responses to commands or informational messages.";
    public static final Boolean CAMEL_SOURCE_IRC_ENDPOINT_ON_REPLY_DEFAULT = false;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_TOPIC_CONF = "camel.source.endpoint.onTopic";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_ON_TOPIC_DOC = "Handle topic change events.";
    public static final Boolean CAMEL_SOURCE_IRC_ENDPOINT_ON_TOPIC_DEFAULT = true;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_NICK_PASSWORD_CONF = "camel.source.endpoint.nickPassword";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_NICK_PASSWORD_DOC = "Your IRC server nickname password.";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_NICK_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_PASSWORD_CONF = "camel.source.endpoint.password";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_PASSWORD_DOC = "The IRC server password.";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_SSL_CONTEXT_PARAMETERS_CONF = "camel.source.endpoint.sslContextParameters";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_SSL_CONTEXT_PARAMETERS_DOC = "Used for configuring security using SSL. Reference to a org.apache.camel.support.jsse.SSLContextParameters in the Registry. This reference overrides any configured SSLContextParameters at the component level. Note that this setting overrides the trustManager option.";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_SSL_CONTEXT_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_TRUST_MANAGER_CONF = "camel.source.endpoint.trustManager";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_TRUST_MANAGER_DOC = "The trust manager used to verify the SSL server's certificate.";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_TRUST_MANAGER_DEFAULT = null;
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_USERNAME_CONF = "camel.source.endpoint.username";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_USERNAME_DOC = "The IRC server user name.";
    public static final String CAMEL_SOURCE_IRC_ENDPOINT_USERNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_IRC_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.irc.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_IRC_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_IRC_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_IRC_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.irc.autowiredEnabled";
    public static final String CAMEL_SOURCE_IRC_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_IRC_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SOURCE_IRC_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF = "camel.component.irc.useGlobalSslContextParameters";
    public static final String CAMEL_SOURCE_IRC_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC = "Enable usage of global SSL context parameters.";
    public static final Boolean CAMEL_SOURCE_IRC_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT = false;

    public CamelIrcSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelIrcSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_IRC_PATH_HOSTNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_IRC_PATH_HOSTNAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_IRC_PATH_HOSTNAME_DOC);
        conf.define(CAMEL_SOURCE_IRC_PATH_PORT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_IRC_PATH_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_PATH_PORT_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_AUTO_REJOIN_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_ENDPOINT_AUTO_REJOIN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_AUTO_REJOIN_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_CHANNELS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_IRC_ENDPOINT_CHANNELS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_CHANNELS_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_COMMAND_TIMEOUT_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_IRC_ENDPOINT_COMMAND_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_COMMAND_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_KEYS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_IRC_ENDPOINT_KEYS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_KEYS_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_NAMES_ON_JOIN_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_ENDPOINT_NAMES_ON_JOIN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_NAMES_ON_JOIN_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_NICKNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_IRC_ENDPOINT_NICKNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_NICKNAME_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_PERSISTENT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_ENDPOINT_PERSISTENT_DEFAULT, ConfigDef.Importance.LOW, CAMEL_SOURCE_IRC_ENDPOINT_PERSISTENT_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_REALNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_IRC_ENDPOINT_REALNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_REALNAME_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_IRC_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_IRC_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_COLORS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_ENDPOINT_COLORS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_COLORS_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_ON_JOIN_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_ENDPOINT_ON_JOIN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_ON_JOIN_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_ON_KICK_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_ENDPOINT_ON_KICK_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_ON_KICK_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_ON_MODE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_ENDPOINT_ON_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_ON_MODE_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_ON_NICK_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_ENDPOINT_ON_NICK_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_ON_NICK_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_ON_PART_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_ENDPOINT_ON_PART_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_ON_PART_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_ON_PRIVMSG_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_ENDPOINT_ON_PRIVMSG_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_ON_PRIVMSG_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_ON_QUIT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_ENDPOINT_ON_QUIT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_ON_QUIT_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_ON_REPLY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_ENDPOINT_ON_REPLY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_ON_REPLY_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_ON_TOPIC_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_ENDPOINT_ON_TOPIC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_ON_TOPIC_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_NICK_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_IRC_ENDPOINT_NICK_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_NICK_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_IRC_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_IRC_ENDPOINT_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_SSL_CONTEXT_PARAMETERS_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_TRUST_MANAGER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_IRC_ENDPOINT_TRUST_MANAGER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_TRUST_MANAGER_DOC);
        conf.define(CAMEL_SOURCE_IRC_ENDPOINT_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_IRC_ENDPOINT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_ENDPOINT_USERNAME_DOC);
        conf.define(CAMEL_SOURCE_IRC_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_IRC_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_IRC_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_IRC_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_IRC_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC);
        return conf;
    }
}