/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.websocketjsr356;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelWebsocketjsr356SourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_PATH_URI_CONF = "camel.source.path.uri";
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_PATH_URI_DOC = "If a schemeless URI path is provided, a ServerEndpoint is deployed under that path. Else if the URI is prefixed with the 'ws://' scheme, then a connection is established to the corresponding server";
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_PATH_URI_DEFAULT = null;
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_SESSION_COUNT_CONF = "camel.source.endpoint.sessionCount";
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_SESSION_COUNT_DOC = "Used when the endpoint is in client mode to populate a pool of sessions";
    public static final Integer CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_SESSION_COUNT_DEFAULT = 1;
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.source.endpoint.basicPropertyBinding";
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.websocket-jsr356.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.websocket-jsr356.basicPropertyBinding";
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_SERVER_ENDPOINT_DEPLOYMENT_STRATEGY_CONF = "camel.component.websocket-jsr356.serverEndpointDeploymentStrategy";
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_SERVER_ENDPOINT_DEPLOYMENT_STRATEGY_DOC = "To enable customization of how a WebSocket ServerEndpoint is configured and deployed. By default DefaultServerEndpointDeploymentStrategy is used.";
    public static final String CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_SERVER_ENDPOINT_DEPLOYMENT_STRATEGY_DEFAULT = null;

    public CamelWebsocketjsr356SourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelWebsocketjsr356SourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_WEBSOCKETJSR356_PATH_URI_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_WEBSOCKETJSR356_PATH_URI_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETJSR356_PATH_URI_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_SESSION_COUNT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_SESSION_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_SESSION_COUNT_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETJSR356_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.LOW, CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_SERVER_ENDPOINT_DEPLOYMENT_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_SERVER_ENDPOINT_DEPLOYMENT_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_WEBSOCKETJSR356_COMPONENT_SERVER_ENDPOINT_DEPLOYMENT_STRATEGY_DOC);
        return conf;
    }
}