/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.rabbitmq;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelRabbitmqSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_RABBITMQ_PATH_EXCHANGE_NAME_CONF = "camel.source.path.exchangeName";
    public static final String CAMEL_SOURCE_RABBITMQ_PATH_EXCHANGE_NAME_DOC = "The exchange name determines the exchange to which the produced messages will be sent to. In the case of consumers, the exchange name determines the exchange the queue will be bound to.";
    public static final String CAMEL_SOURCE_RABBITMQ_PATH_EXCHANGE_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_ADDRESSES_CONF = "camel.source.endpoint.addresses";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_ADDRESSES_DOC = "If this option is set, camel-rabbitmq will try to create connection based on the setting of option addresses. The addresses value is a string which looks like server1:12345, server2:12345";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_ADDRESSES_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTO_DELETE_CONF = "camel.source.endpoint.autoDelete";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTO_DELETE_DOC = "If it is true, the exchange will be deleted when it is no longer in use";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTO_DELETE_DEFAULT = true;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTOMATIC_RECOVERY_ENABLED_CONF = "camel.source.endpoint.automaticRecoveryEnabled";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTOMATIC_RECOVERY_ENABLED_DOC = "Enables connection automatic recovery (uses connection implementation that performs automatic recovery when existing connection has failures)";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTOMATIC_RECOVERY_ENABLED_DEFAULT = "true";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_CONF = "camel.source.endpoint.connectionFactory";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_DOC = "To use a custom RabbitMQ connection factory. When this option is set, all connection options (connectionTimeout, requestedChannelMax...) set on URI are not used";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_CONF = "camel.source.endpoint.deadLetterExchange";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_DOC = "The name of the dead letter exchange";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_TYPE_CONF = "camel.source.endpoint.deadLetterExchangeType";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_TYPE_DOC = "The type of the dead letter exchange One of: [direct] [fanout] [headers] [topic]";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_TYPE_DEFAULT = "direct";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_QUEUE_CONF = "camel.source.endpoint.deadLetterQueue";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_QUEUE_DOC = "The name of the dead letter queue";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_QUEUE_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_ROUTING_KEY_CONF = "camel.source.endpoint.deadLetterRoutingKey";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_ROUTING_KEY_DOC = "The routing key for the dead letter exchange";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_ROUTING_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_DECLARE_CONF = "camel.source.endpoint.declare";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_DECLARE_DOC = "If the option is true, camel declare the exchange and queue name and bind them together. If the option is false, camel won't declare the exchange and queue name on the server.";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_DECLARE_DEFAULT = true;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_DURABLE_CONF = "camel.source.endpoint.durable";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_DURABLE_DOC = "If we are declaring a durable exchange (the exchange will survive a server restart)";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_DURABLE_DEFAULT = true;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCHANGE_TYPE_CONF = "camel.source.endpoint.exchangeType";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCHANGE_TYPE_DOC = "The exchange type such as direct or topic. One of: [direct] [fanout] [headers] [topic]";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCHANGE_TYPE_DEFAULT = "direct";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCLUSIVE_CONF = "camel.source.endpoint.exclusive";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCLUSIVE_DOC = "Exclusive queues may only be accessed by the current connection, and are deleted when that connection closes.";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCLUSIVE_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_HOSTNAME_CONF = "camel.source.endpoint.hostname";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_HOSTNAME_DOC = "The hostname of the running rabbitmq instance or cluster.";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_HOSTNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_PASSIVE_CONF = "camel.source.endpoint.passive";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_PASSIVE_DOC = "Passive queues depend on the queue already to be available at RabbitMQ.";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_PASSIVE_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_PORT_NUMBER_CONF = "camel.source.endpoint.portNumber";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_PORT_NUMBER_DOC = "Port number for the host with the running rabbitmq instance or cluster. Default value is 5672.";
    public static final Integer CAMEL_SOURCE_RABBITMQ_ENDPOINT_PORT_NUMBER_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_QUEUE_CONF = "camel.source.endpoint.queue";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_QUEUE_DOC = "The queue to receive messages from";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_QUEUE_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_ROUTING_KEY_CONF = "camel.source.endpoint.routingKey";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_ROUTING_KEY_DOC = "The routing key to use when binding a consumer queue to the exchange. For producer routing keys, you set the header rabbitmq.ROUTING_KEY.";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_ROUTING_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_DLQ_DECLARE_CONF = "camel.source.endpoint.skipDlqDeclare";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_DLQ_DECLARE_DOC = "If true the producer will not declare and bind a dead letter queue. This can be used if you have also DLQ rabbitmq consumer and you want to avoid argument clashing between Producer and Consumer. This option have no effect, if DLQ configured (deadLetterExchange option is not set).";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_DLQ_DECLARE_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_EXCHANGE_DECLARE_CONF = "camel.source.endpoint.skipExchangeDeclare";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_EXCHANGE_DECLARE_DOC = "This can be used if we need to declare the queue but not the exchange";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_EXCHANGE_DECLARE_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_QUEUE_BIND_CONF = "camel.source.endpoint.skipQueueBind";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_QUEUE_BIND_DOC = "If true the queue will not be bound to the exchange after declaring it";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_QUEUE_BIND_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_QUEUE_DECLARE_CONF = "camel.source.endpoint.skipQueueDeclare";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_QUEUE_DECLARE_DOC = "If true the producer will not declare and bind a queue. This can be used for directing messages via an existing routing key.";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_QUEUE_DECLARE_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_VHOST_CONF = "camel.source.endpoint.vhost";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_VHOST_DOC = "The vhost for the channel";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_VHOST_DEFAULT = "/";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTO_ACK_CONF = "camel.source.endpoint.autoAck";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTO_ACK_DOC = "If messages should be auto acknowledged";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTO_ACK_DEFAULT = true;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONCURRENT_CONSUMERS_CONF = "camel.source.endpoint.concurrentConsumers";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONCURRENT_CONSUMERS_DOC = "Number of concurrent consumers when consuming from broker. (eg similar as to the same option for the JMS component).";
    public static final Integer CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONCURRENT_CONSUMERS_DEFAULT = 1;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONSUMER_TAG_CONF = "camel.source.endpoint.consumerTag";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONSUMER_TAG_DOC = "Specify a client-generated consumer tag to establish context when invoking the consume operation";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONSUMER_TAG_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCLUSIVE_CONSUMER_CONF = "camel.source.endpoint.exclusiveConsumer";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCLUSIVE_CONSUMER_DOC = "Request exclusive access to the queue (meaning only this consumer can access the queue). This is useful when you want a long-lived shared queue to be temporarily accessible by just one consumer.";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCLUSIVE_CONSUMER_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_COUNT_CONF = "camel.source.endpoint.prefetchCount";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_COUNT_DOC = "The maximum number of messages that the server will deliver, 0 if unlimited. You need to specify the option of prefetchSize, prefetchCount, prefetchGlobal at the same time";
    public static final Integer CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_COUNT_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_ENABLED_CONF = "camel.source.endpoint.prefetchEnabled";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_ENABLED_DOC = "Enables the quality of service on the RabbitMQConsumer side. You need to specify the option of prefetchSize, prefetchCount, prefetchGlobal at the same time";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_ENABLED_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_GLOBAL_CONF = "camel.source.endpoint.prefetchGlobal";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_GLOBAL_DOC = "If the settings should be applied to the entire channel rather than each consumer You need to specify the option of prefetchSize, prefetchCount, prefetchGlobal at the same time";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_GLOBAL_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_SIZE_CONF = "camel.source.endpoint.prefetchSize";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_SIZE_DOC = "The maximum amount of content (measured in octets) that the server will deliver, 0 if unlimited. You need to specify the option of prefetchSize, prefetchCount, prefetchGlobal at the same time";
    public static final Integer CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_RE_QUEUE_CONF = "camel.source.endpoint.reQueue";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_RE_QUEUE_DOC = "This is used by the consumer to control rejection of the message. When the consumer is complete processing the exchange, and if the exchange failed, then the consumer is going to reject the message from the RabbitMQ broker. If the header CamelRabbitmqRequeue is present then the value of the header will be used, otherwise this endpoint value is used as fallback. If the value is false (by default) then the message is discarded/dead-lettered. If the value is true, then the message is re-queued.";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_RE_QUEUE_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_THREAD_POOL_SIZE_CONF = "camel.source.endpoint.threadPoolSize";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_THREAD_POOL_SIZE_DOC = "The consumer uses a Thread Pool Executor with a fixed number of threads. This setting allows you to set that number of threads.";
    public static final Integer CAMEL_SOURCE_RABBITMQ_ENDPOINT_THREAD_POOL_SIZE_DEFAULT = 10;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_ARGS_CONF = "camel.source.endpoint.args";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_ARGS_DOC = "Specify arguments for configuring the different RabbitMQ concepts, a different prefix is required for each: Exchange: arg.exchange. Queue: arg.queue. Binding: arg.binding. DLQ: arg.dlq.queue. DLQ binding: arg.dlq.binding. For example to declare a queue with message ttl argument: http://localhost:5672/exchange/queueargs=arg.queue.x-message-ttl=60000";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_ARGS_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.source.endpoint.basicPropertyBinding";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_CLIENT_PROPERTIES_CONF = "camel.source.endpoint.clientProperties";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_CLIENT_PROPERTIES_DOC = "Connection client properties (client info used in negotiating with the server)";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_CLIENT_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.connectionFactoryExceptionHandler";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_EXCEPTION_HANDLER_DOC = "Custom rabbitmq ExceptionHandler for ConnectionFactory";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_TIMEOUT_CONF = "camel.source.endpoint.connectionTimeout";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_TIMEOUT_DOC = "Connection timeout";
    public static final Integer CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_TIMEOUT_DEFAULT = 60000;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_NETWORK_RECOVERY_INTERVAL_CONF = "camel.source.endpoint.networkRecoveryInterval";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_NETWORK_RECOVERY_INTERVAL_DOC = "Network recovery interval in milliseconds (interval used when recovering from network failure)";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_NETWORK_RECOVERY_INTERVAL_DEFAULT = "5000";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_CHANNEL_MAX_CONF = "camel.source.endpoint.requestedChannelMax";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_CHANNEL_MAX_DOC = "Connection requested channel max (max number of channels offered)";
    public static final Integer CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_CHANNEL_MAX_DEFAULT = 2047;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_FRAME_MAX_CONF = "camel.source.endpoint.requestedFrameMax";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_FRAME_MAX_DOC = "Connection requested frame max (max size of frame offered)";
    public static final Integer CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_FRAME_MAX_DEFAULT = 0;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_HEARTBEAT_CONF = "camel.source.endpoint.requestedHeartbeat";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_HEARTBEAT_DOC = "Connection requested heartbeat (heart-beat in seconds offered)";
    public static final Integer CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_HEARTBEAT_DEFAULT = 60;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_CONF = "camel.source.endpoint.requestTimeout";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_DOC = "Set timeout for waiting for a reply when using the InOut Exchange Pattern (in milliseconds)";
    public static final Long CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_DEFAULT = 20000L;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_CONF = "camel.source.endpoint.requestTimeoutCheckerInterval";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DOC = "Set requestTimeoutCheckerInterval for inOut exchange";
    public static final Long CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_TOPOLOGY_RECOVERY_ENABLED_CONF = "camel.source.endpoint.topologyRecoveryEnabled";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_TOPOLOGY_RECOVERY_ENABLED_DOC = "Enables connection topology recovery (should topology recovery be performed)";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_TOPOLOGY_RECOVERY_ENABLED_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_TRANSFER_EXCEPTION_CONF = "camel.source.endpoint.transferException";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_TRANSFER_EXCEPTION_DOC = "When true and an inOut Exchange failed on the consumer side send the caused Exception back in the response";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_TRANSFER_EXCEPTION_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_ALLOW_MESSAGE_BODY_SERIALIZATION_CONF = "camel.source.endpoint.allowMessageBodySerialization";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_ALLOW_MESSAGE_BODY_SERIALIZATION_DOC = "Whether to allow Java serialization of the message body or not. If this value is true, the message body will be serialized on the producer side using Java serialization, if no type converter can handle the message body. On the consumer side, it will deserialize the message body if this value is true and the message contains a CamelSerialize header. Setting this value to true may introduce a security vulnerability as it allows an attacker to attempt to deserialize to a gadget object which could result in a RCE or other security vulnerability.";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_ENDPOINT_ALLOW_MESSAGE_BODY_SERIALIZATION_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_PASSWORD_CONF = "camel.source.endpoint.password";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_PASSWORD_DOC = "Password for authenticated access";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_PASSWORD_DEFAULT = "guest";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_SSL_PROTOCOL_CONF = "camel.source.endpoint.sslProtocol";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_SSL_PROTOCOL_DOC = "Enables SSL on connection, accepted value are true, TLS and 'SSLv3";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_SSL_PROTOCOL_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_TRUST_MANAGER_CONF = "camel.source.endpoint.trustManager";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_TRUST_MANAGER_DOC = "Configure SSL trust manager, SSL should be enabled for this option to be effective";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_TRUST_MANAGER_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_USERNAME_CONF = "camel.source.endpoint.username";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_USERNAME_DOC = "Username in case of authenticated access";
    public static final String CAMEL_SOURCE_RABBITMQ_ENDPOINT_USERNAME_DEFAULT = "guest";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_ADDRESSES_CONF = "camel.component.rabbitmq.addresses";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_ADDRESSES_DOC = "If this option is set, camel-rabbitmq will try to create connection based on the setting of option addresses. The addresses value is a string which looks like server1:12345, server2:12345";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_ADDRESSES_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_DELETE_CONF = "camel.component.rabbitmq.autoDelete";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_DELETE_DOC = "If it is true, the exchange will be deleted when it is no longer in use";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_DELETE_DEFAULT = true;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_FACTORY_CONF = "camel.component.rabbitmq.connectionFactory";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_FACTORY_DOC = "To use a custom RabbitMQ connection factory. When this option is set, all connection options (connectionTimeout, requestedChannelMax...) set on URI are not used";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_FACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_CONF = "camel.component.rabbitmq.deadLetterExchange";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_DOC = "The name of the dead letter exchange";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_TYPE_CONF = "camel.component.rabbitmq.deadLetterExchangeType";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_TYPE_DOC = "The type of the dead letter exchange One of: [direct] [fanout] [headers] [topic]";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_TYPE_DEFAULT = "direct";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_QUEUE_CONF = "camel.component.rabbitmq.deadLetterQueue";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_QUEUE_DOC = "The name of the dead letter queue";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_QUEUE_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_ROUTING_KEY_CONF = "camel.component.rabbitmq.deadLetterRoutingKey";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_ROUTING_KEY_DOC = "The routing key for the dead letter exchange";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_ROUTING_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_DECLARE_CONF = "camel.component.rabbitmq.declare";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_DECLARE_DOC = "If the option is true, camel declare the exchange and queue name and bind them together. If the option is false, camel won't declare the exchange and queue name on the server.";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_COMPONENT_DECLARE_DEFAULT = true;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_DURABLE_CONF = "camel.component.rabbitmq.durable";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_DURABLE_DOC = "If we are declaring a durable exchange (the exchange will survive a server restart)";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_COMPONENT_DURABLE_DEFAULT = true;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_EXCLUSIVE_CONF = "camel.component.rabbitmq.exclusive";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_EXCLUSIVE_DOC = "Exclusive queues may only be accessed by the current connection, and are deleted when that connection closes.";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_COMPONENT_EXCLUSIVE_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_HOSTNAME_CONF = "camel.component.rabbitmq.hostname";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_HOSTNAME_DOC = "The hostname of the running RabbitMQ instance or cluster.";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_HOSTNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_PASSIVE_CONF = "camel.component.rabbitmq.passive";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_PASSIVE_DOC = "Passive queues depend on the queue already to be available at RabbitMQ.";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_COMPONENT_PASSIVE_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_PORT_NUMBER_CONF = "camel.component.rabbitmq.portNumber";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_PORT_NUMBER_DOC = "Port number for the host with the running rabbitmq instance or cluster.";
    public static final Integer CAMEL_SOURCE_RABBITMQ_COMPONENT_PORT_NUMBER_DEFAULT = 5672;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_EXCHANGE_DECLARE_CONF = "camel.component.rabbitmq.skipExchangeDeclare";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_EXCHANGE_DECLARE_DOC = "This can be used if we need to declare the queue but not the exchange";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_EXCHANGE_DECLARE_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_QUEUE_BIND_CONF = "camel.component.rabbitmq.skipQueueBind";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_QUEUE_BIND_DOC = "If true the queue will not be bound to the exchange after declaring it";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_QUEUE_BIND_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_QUEUE_DECLARE_CONF = "camel.component.rabbitmq.skipQueueDeclare";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_QUEUE_DECLARE_DOC = "If true the producer will not declare and bind a queue. This can be used for directing messages via an existing routing key.";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_QUEUE_DECLARE_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_VHOST_CONF = "camel.component.rabbitmq.vhost";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_VHOST_DOC = "The vhost for the channel";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_VHOST_DEFAULT = "/";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_ACK_CONF = "camel.component.rabbitmq.autoAck";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_ACK_DOC = "If messages should be auto acknowledged";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_ACK_DEFAULT = true;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.rabbitmq.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_EXCLUSIVE_CONSUMER_CONF = "camel.component.rabbitmq.exclusiveConsumer";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_EXCLUSIVE_CONSUMER_DOC = "Request exclusive access to the queue (meaning only this consumer can access the queue). This is useful when you want a long-lived shared queue to be temporarily accessible by just one consumer.";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_COMPONENT_EXCLUSIVE_CONSUMER_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_COUNT_CONF = "camel.component.rabbitmq.prefetchCount";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_COUNT_DOC = "The maximum number of messages that the server will deliver, 0 if unlimited. You need to specify the option of prefetchSize, prefetchCount, prefetchGlobal at the same time";
    public static final Integer CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_COUNT_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_ENABLED_CONF = "camel.component.rabbitmq.prefetchEnabled";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_ENABLED_DOC = "Enables the quality of service on the RabbitMQConsumer side. You need to specify the option of prefetchSize, prefetchCount, prefetchGlobal at the same time";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_ENABLED_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_GLOBAL_CONF = "camel.component.rabbitmq.prefetchGlobal";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_GLOBAL_DOC = "If the settings should be applied to the entire channel rather than each consumer You need to specify the option of prefetchSize, prefetchCount, prefetchGlobal at the same time";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_GLOBAL_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_SIZE_CONF = "camel.component.rabbitmq.prefetchSize";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_SIZE_DOC = "The maximum amount of content (measured in octets) that the server will deliver, 0 if unlimited. You need to specify the option of prefetchSize, prefetchCount, prefetchGlobal at the same time";
    public static final Integer CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_THREAD_POOL_SIZE_CONF = "camel.component.rabbitmq.threadPoolSize";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_THREAD_POOL_SIZE_DOC = "The consumer uses a Thread Pool Executor with a fixed number of threads. This setting allows you to set that number of threads.";
    public static final Integer CAMEL_SOURCE_RABBITMQ_COMPONENT_THREAD_POOL_SIZE_DEFAULT = 10;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_ARGS_CONF = "camel.component.rabbitmq.args";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_ARGS_DOC = "Specify arguments for configuring the different RabbitMQ concepts, a different prefix is required for each: Exchange: arg.exchange. Queue: arg.queue. Binding: arg.binding. DLQ: arg.dlq.queue. DLQ Binding: arg.dlq.binding. For example to declare a queue with message ttl argument: http://localhost:5672/exchange/queueargs=arg.queue.x-message-ttl=60000";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_ARGS_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_DETECT_CONNECTION_FACTORY_CONF = "camel.component.rabbitmq.autoDetectConnectionFactory";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_DETECT_CONNECTION_FACTORY_DOC = "Whether to auto-detect looking up RabbitMQ connection factory from the registry. When enabled and a single instance of the connection factory is found then it will be used. An explicit connection factory can be configured on the component or endpoint level which takes precedence.";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_DETECT_CONNECTION_FACTORY_DEFAULT = true;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTOMATIC_RECOVERY_ENABLED_CONF = "camel.component.rabbitmq.automaticRecoveryEnabled";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTOMATIC_RECOVERY_ENABLED_DOC = "Enables connection automatic recovery (uses connection implementation that performs automatic recovery when connection shutdown is not initiated by the application)";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTOMATIC_RECOVERY_ENABLED_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.rabbitmq.basicPropertyBinding";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_CLIENT_PROPERTIES_CONF = "camel.component.rabbitmq.clientProperties";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_CLIENT_PROPERTIES_DOC = "Connection client properties (client info used in negotiating with the server)";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_CLIENT_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_FACTORY_EXCEPTION_HANDLER_CONF = "camel.component.rabbitmq.connectionFactoryExceptionHandler";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_FACTORY_EXCEPTION_HANDLER_DOC = "Custom rabbitmq ExceptionHandler for ConnectionFactory";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_FACTORY_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_TIMEOUT_CONF = "camel.component.rabbitmq.connectionTimeout";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_TIMEOUT_DOC = "Connection timeout";
    public static final Integer CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_TIMEOUT_DEFAULT = 60000;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_NETWORK_RECOVERY_INTERVAL_CONF = "camel.component.rabbitmq.networkRecoveryInterval";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_NETWORK_RECOVERY_INTERVAL_DOC = "Network recovery interval in milliseconds (interval used when recovering from network failure)";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_NETWORK_RECOVERY_INTERVAL_DEFAULT = "5000";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_CHANNEL_MAX_CONF = "camel.component.rabbitmq.requestedChannelMax";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_CHANNEL_MAX_DOC = "Connection requested channel max (max number of channels offered)";
    public static final Integer CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_CHANNEL_MAX_DEFAULT = 2047;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_FRAME_MAX_CONF = "camel.component.rabbitmq.requestedFrameMax";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_FRAME_MAX_DOC = "Connection requested frame max (max size of frame offered)";
    public static final Integer CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_FRAME_MAX_DEFAULT = 0;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_HEARTBEAT_CONF = "camel.component.rabbitmq.requestedHeartbeat";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_HEARTBEAT_DOC = "Connection requested heartbeat (heart-beat in seconds offered)";
    public static final Integer CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_HEARTBEAT_DEFAULT = 60;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_CONF = "camel.component.rabbitmq.requestTimeout";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_DOC = "Set timeout for waiting for a reply when using the InOut Exchange Pattern (in milliseconds)";
    public static final Long CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_DEFAULT = 20000L;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_CONF = "camel.component.rabbitmq.requestTimeoutCheckerInterval";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DOC = "Set requestTimeoutCheckerInterval for inOut exchange";
    public static final Long CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_TOPOLOGY_RECOVERY_ENABLED_CONF = "camel.component.rabbitmq.topologyRecoveryEnabled";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_TOPOLOGY_RECOVERY_ENABLED_DOC = "Enables connection topology recovery (should topology recovery be performed)";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_TOPOLOGY_RECOVERY_ENABLED_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_TRANSFER_EXCEPTION_CONF = "camel.component.rabbitmq.transferException";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_TRANSFER_EXCEPTION_DOC = "When true and an inOut Exchange failed on the consumer side send the caused Exception back in the response";
    public static final Boolean CAMEL_SOURCE_RABBITMQ_COMPONENT_TRANSFER_EXCEPTION_DEFAULT = false;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_PASSWORD_CONF = "camel.component.rabbitmq.password";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_PASSWORD_DOC = "Password for authenticated access";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_PASSWORD_DEFAULT = "guest";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_SSL_PROTOCOL_CONF = "camel.component.rabbitmq.sslProtocol";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_SSL_PROTOCOL_DOC = "Enables SSL on connection, accepted value are true, TLS and 'SSLv3";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_SSL_PROTOCOL_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_TRUST_MANAGER_CONF = "camel.component.rabbitmq.trustManager";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_TRUST_MANAGER_DOC = "Configure SSL trust manager, SSL should be enabled for this option to be effective";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_TRUST_MANAGER_DEFAULT = null;
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_USERNAME_CONF = "camel.component.rabbitmq.username";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_USERNAME_DOC = "Username in case of authenticated access";
    public static final String CAMEL_SOURCE_RABBITMQ_COMPONENT_USERNAME_DEFAULT = "guest";

    public CamelRabbitmqSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelRabbitmqSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_RABBITMQ_PATH_EXCHANGE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_PATH_EXCHANGE_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_RABBITMQ_PATH_EXCHANGE_NAME_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_ADDRESSES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_ADDRESSES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_ADDRESSES_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTO_DELETE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTO_DELETE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTO_DELETE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTOMATIC_RECOVERY_ENABLED_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTOMATIC_RECOVERY_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTOMATIC_RECOVERY_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_EXCHANGE_TYPE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_QUEUE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_QUEUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_QUEUE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_ROUTING_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_ROUTING_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_DEAD_LETTER_ROUTING_KEY_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_DECLARE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_DECLARE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_DECLARE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_DURABLE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_DURABLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_DURABLE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCHANGE_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCHANGE_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCHANGE_TYPE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCLUSIVE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCLUSIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCLUSIVE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_HOSTNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_HOSTNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_HOSTNAME_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_PASSIVE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_PASSIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_PASSIVE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_PORT_NUMBER_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_RABBITMQ_ENDPOINT_PORT_NUMBER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_PORT_NUMBER_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_QUEUE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_QUEUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_QUEUE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_ROUTING_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_ROUTING_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_ROUTING_KEY_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_DLQ_DECLARE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_DLQ_DECLARE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_DLQ_DECLARE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_EXCHANGE_DECLARE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_EXCHANGE_DECLARE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_EXCHANGE_DECLARE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_QUEUE_BIND_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_QUEUE_BIND_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_QUEUE_BIND_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_QUEUE_DECLARE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_QUEUE_DECLARE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_SKIP_QUEUE_DECLARE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_VHOST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_VHOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_VHOST_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTO_ACK_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTO_ACK_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_AUTO_ACK_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONCURRENT_CONSUMERS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONCURRENT_CONSUMERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONCURRENT_CONSUMERS_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONSUMER_TAG_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONSUMER_TAG_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONSUMER_TAG_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCLUSIVE_CONSUMER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCLUSIVE_CONSUMER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCLUSIVE_CONSUMER_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_COUNT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_COUNT_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_GLOBAL_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_GLOBAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_GLOBAL_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_PREFETCH_SIZE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_RE_QUEUE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_RE_QUEUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_RE_QUEUE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_THREAD_POOL_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_RABBITMQ_ENDPOINT_THREAD_POOL_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_THREAD_POOL_SIZE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_ARGS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_ARGS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_ARGS_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_CLIENT_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_CLIENT_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_CLIENT_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_FACTORY_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_TIMEOUT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_CONNECTION_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_NETWORK_RECOVERY_INTERVAL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_NETWORK_RECOVERY_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_NETWORK_RECOVERY_INTERVAL_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_CHANNEL_MAX_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_CHANNEL_MAX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_CHANNEL_MAX_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_FRAME_MAX_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_FRAME_MAX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_FRAME_MAX_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_HEARTBEAT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_HEARTBEAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUESTED_HEARTBEAT_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_TOPOLOGY_RECOVERY_ENABLED_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_TOPOLOGY_RECOVERY_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_TOPOLOGY_RECOVERY_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_TRANSFER_EXCEPTION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_TRANSFER_EXCEPTION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_TRANSFER_EXCEPTION_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_ALLOW_MESSAGE_BODY_SERIALIZATION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_ENDPOINT_ALLOW_MESSAGE_BODY_SERIALIZATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_ALLOW_MESSAGE_BODY_SERIALIZATION_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_SSL_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_SSL_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_SSL_PROTOCOL_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_TRUST_MANAGER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_TRUST_MANAGER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_TRUST_MANAGER_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_ENDPOINT_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_ENDPOINT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_ENDPOINT_USERNAME_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_ADDRESSES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_ADDRESSES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_ADDRESSES_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_DELETE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_DELETE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_DELETE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_EXCHANGE_TYPE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_QUEUE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_QUEUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_QUEUE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_ROUTING_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_ROUTING_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_DEAD_LETTER_ROUTING_KEY_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_DECLARE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_COMPONENT_DECLARE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_DECLARE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_DURABLE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_COMPONENT_DURABLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_DURABLE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_EXCLUSIVE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_COMPONENT_EXCLUSIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_EXCLUSIVE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_HOSTNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_HOSTNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_HOSTNAME_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_PASSIVE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_COMPONENT_PASSIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_PASSIVE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_PORT_NUMBER_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_RABBITMQ_COMPONENT_PORT_NUMBER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_PORT_NUMBER_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_EXCHANGE_DECLARE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_EXCHANGE_DECLARE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_EXCHANGE_DECLARE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_QUEUE_BIND_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_QUEUE_BIND_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_QUEUE_BIND_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_QUEUE_DECLARE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_QUEUE_DECLARE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_SKIP_QUEUE_DECLARE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_VHOST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_VHOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_VHOST_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_ACK_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_ACK_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_ACK_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_EXCLUSIVE_CONSUMER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_COMPONENT_EXCLUSIVE_CONSUMER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_EXCLUSIVE_CONSUMER_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_COUNT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_COUNT_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_GLOBAL_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_GLOBAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_GLOBAL_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_PREFETCH_SIZE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_THREAD_POOL_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_RABBITMQ_COMPONENT_THREAD_POOL_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_THREAD_POOL_SIZE_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_ARGS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_ARGS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_ARGS_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_DETECT_CONNECTION_FACTORY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_DETECT_CONNECTION_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTO_DETECT_CONNECTION_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTOMATIC_RECOVERY_ENABLED_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTOMATIC_RECOVERY_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_AUTOMATIC_RECOVERY_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.LOW, CAMEL_SOURCE_RABBITMQ_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_CLIENT_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_CLIENT_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_CLIENT_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_FACTORY_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_FACTORY_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_FACTORY_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_TIMEOUT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_CONNECTION_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_NETWORK_RECOVERY_INTERVAL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_NETWORK_RECOVERY_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_NETWORK_RECOVERY_INTERVAL_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_CHANNEL_MAX_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_CHANNEL_MAX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_CHANNEL_MAX_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_FRAME_MAX_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_FRAME_MAX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_FRAME_MAX_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_HEARTBEAT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_HEARTBEAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUESTED_HEARTBEAT_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_TOPOLOGY_RECOVERY_ENABLED_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_TOPOLOGY_RECOVERY_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_TOPOLOGY_RECOVERY_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_TRANSFER_EXCEPTION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_RABBITMQ_COMPONENT_TRANSFER_EXCEPTION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_TRANSFER_EXCEPTION_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_SSL_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_SSL_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_SSL_PROTOCOL_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_TRUST_MANAGER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_TRUST_MANAGER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_TRUST_MANAGER_DOC);
        conf.define(CAMEL_SOURCE_RABBITMQ_COMPONENT_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_RABBITMQ_COMPONENT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_RABBITMQ_COMPONENT_USERNAME_DOC);
        return conf;
    }
}