/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.mybatis;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelMybatisSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_MYBATIS_PATH_STATEMENT_CONF = "camel.sink.path.statement";
    public static final String CAMEL_SINK_MYBATIS_PATH_STATEMENT_DOC = "The statement name in the MyBatis XML mapping file which maps to the query, insert, update or delete operation you wish to evaluate.";
    public static final String CAMEL_SINK_MYBATIS_PATH_STATEMENT_DEFAULT = null;
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_EXECUTOR_TYPE_CONF = "camel.sink.endpoint.executorType";
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_EXECUTOR_TYPE_DOC = "The executor type to be used while executing statements. simple - executor does nothing special. reuse - executor reuses prepared statements. batch - executor reuses statements and batches updates. One of: [SIMPLE] [REUSE] [BATCH]";
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_EXECUTOR_TYPE_DEFAULT = "SIMPLE";
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_INPUT_HEADER_CONF = "camel.sink.endpoint.inputHeader";
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_INPUT_HEADER_DOC = "User the header value for input parameters instead of the message body. By default, inputHeader == null and the input parameters are taken from the message body. If outputHeader is set, the value is used and query parameters will be taken from the header instead of the body.";
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_INPUT_HEADER_DEFAULT = null;
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_MYBATIS_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_OUTPUT_HEADER_CONF = "camel.sink.endpoint.outputHeader";
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_OUTPUT_HEADER_DOC = "Store the query result in a header instead of the message body. By default, outputHeader == null and the query result is stored in the message body, any existing content in the message body is discarded. If outputHeader is set, the value is used as the name of the header to store the query result and the original message body is preserved. Setting outputHeader will also omit populating the default CamelMyBatisResult header since it would be the same as outputHeader all the time.";
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_OUTPUT_HEADER_DEFAULT = null;
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_STATEMENT_TYPE_CONF = "camel.sink.endpoint.statementType";
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_STATEMENT_TYPE_DOC = "Mandatory to specify for the producer to control which kind of operation to invoke. One of: [SelectOne] [SelectList] [Insert] [InsertList] [Update] [UpdateList] [Delete] [DeleteList]";
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_STATEMENT_TYPE_DEFAULT = null;
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.sink.endpoint.basicPropertyBinding";
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_MYBATIS_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_MYBATIS_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_MYBATIS_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_MYBATIS_COMPONENT_CONFIGURATION_URI_CONF = "camel.component.mybatis.configurationUri";
    public static final String CAMEL_SINK_MYBATIS_COMPONENT_CONFIGURATION_URI_DOC = "Location of MyBatis xml configuration file. The default value is: SqlMapConfig.xml loaded from the classpath";
    public static final String CAMEL_SINK_MYBATIS_COMPONENT_CONFIGURATION_URI_DEFAULT = "SqlMapConfig.xml";
    public static final String CAMEL_SINK_MYBATIS_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.mybatis.lazyStartProducer";
    public static final String CAMEL_SINK_MYBATIS_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_MYBATIS_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_MYBATIS_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.mybatis.basicPropertyBinding";
    public static final String CAMEL_SINK_MYBATIS_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_MYBATIS_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_MYBATIS_COMPONENT_SQL_SESSION_FACTORY_CONF = "camel.component.mybatis.sqlSessionFactory";
    public static final String CAMEL_SINK_MYBATIS_COMPONENT_SQL_SESSION_FACTORY_DOC = "To use the SqlSessionFactory";
    public static final String CAMEL_SINK_MYBATIS_COMPONENT_SQL_SESSION_FACTORY_DEFAULT = null;

    public CamelMybatisSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelMybatisSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_MYBATIS_PATH_STATEMENT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_MYBATIS_PATH_STATEMENT_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_MYBATIS_PATH_STATEMENT_DOC);
        conf.define(CAMEL_SINK_MYBATIS_ENDPOINT_EXECUTOR_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_MYBATIS_ENDPOINT_EXECUTOR_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_MYBATIS_ENDPOINT_EXECUTOR_TYPE_DOC);
        conf.define(CAMEL_SINK_MYBATIS_ENDPOINT_INPUT_HEADER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_MYBATIS_ENDPOINT_INPUT_HEADER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_MYBATIS_ENDPOINT_INPUT_HEADER_DOC);
        conf.define(CAMEL_SINK_MYBATIS_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_MYBATIS_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_MYBATIS_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_MYBATIS_ENDPOINT_OUTPUT_HEADER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_MYBATIS_ENDPOINT_OUTPUT_HEADER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_MYBATIS_ENDPOINT_OUTPUT_HEADER_DOC);
        conf.define(CAMEL_SINK_MYBATIS_ENDPOINT_STATEMENT_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_MYBATIS_ENDPOINT_STATEMENT_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_MYBATIS_ENDPOINT_STATEMENT_TYPE_DOC);
        conf.define(CAMEL_SINK_MYBATIS_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_MYBATIS_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_MYBATIS_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_MYBATIS_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_MYBATIS_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_MYBATIS_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_MYBATIS_COMPONENT_CONFIGURATION_URI_CONF, ConfigDef.Type.STRING, CAMEL_SINK_MYBATIS_COMPONENT_CONFIGURATION_URI_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_MYBATIS_COMPONENT_CONFIGURATION_URI_DOC);
        conf.define(CAMEL_SINK_MYBATIS_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_MYBATIS_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_MYBATIS_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_MYBATIS_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_MYBATIS_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.LOW, CAMEL_SINK_MYBATIS_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_MYBATIS_COMPONENT_SQL_SESSION_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_MYBATIS_COMPONENT_SQL_SESSION_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_MYBATIS_COMPONENT_SQL_SESSION_FACTORY_DOC);
        return conf;
    }
}