/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.lucene;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelLuceneSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_LUCENE_PATH_HOST_CONF = "camel.sink.path.host";
    public static final String CAMEL_SINK_LUCENE_PATH_HOST_DOC = "The URL to the lucene server";
    public static final String CAMEL_SINK_LUCENE_PATH_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_LUCENE_PATH_OPERATION_CONF = "camel.sink.path.operation";
    public static final String CAMEL_SINK_LUCENE_PATH_OPERATION_DOC = "Operation to do such as insert or query. One of: [insert] [query]";
    public static final String CAMEL_SINK_LUCENE_PATH_OPERATION_DEFAULT = null;
    public static final String CAMEL_SINK_LUCENE_ENDPOINT_ANALYZER_CONF = "camel.sink.endpoint.analyzer";
    public static final String CAMEL_SINK_LUCENE_ENDPOINT_ANALYZER_DOC = "An Analyzer builds TokenStreams, which analyze text. It thus represents a policy for extracting index terms from text. The value for analyzer can be any class that extends the abstract class org.apache.lucene.analysis.Analyzer. Lucene also offers a rich set of analyzers out of the box";
    public static final String CAMEL_SINK_LUCENE_ENDPOINT_ANALYZER_DEFAULT = null;
    public static final String CAMEL_SINK_LUCENE_ENDPOINT_INDEX_DIR_CONF = "camel.sink.endpoint.indexDir";
    public static final String CAMEL_SINK_LUCENE_ENDPOINT_INDEX_DIR_DOC = "A file system directory in which index files are created upon analysis of the document by the specified analyzer";
    public static final String CAMEL_SINK_LUCENE_ENDPOINT_INDEX_DIR_DEFAULT = null;
    public static final String CAMEL_SINK_LUCENE_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_LUCENE_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_LUCENE_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_LUCENE_ENDPOINT_MAX_HITS_CONF = "camel.sink.endpoint.maxHits";
    public static final String CAMEL_SINK_LUCENE_ENDPOINT_MAX_HITS_DOC = "An integer value that limits the result set of the search operation";
    public static final Integer CAMEL_SINK_LUCENE_ENDPOINT_MAX_HITS_DEFAULT = null;
    public static final String CAMEL_SINK_LUCENE_ENDPOINT_SRC_DIR_CONF = "camel.sink.endpoint.srcDir";
    public static final String CAMEL_SINK_LUCENE_ENDPOINT_SRC_DIR_DOC = "An optional directory containing files to be used to be analyzed and added to the index at producer startup.";
    public static final String CAMEL_SINK_LUCENE_ENDPOINT_SRC_DIR_DEFAULT = null;
    public static final String CAMEL_SINK_LUCENE_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.sink.endpoint.basicPropertyBinding";
    public static final String CAMEL_SINK_LUCENE_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_LUCENE_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_LUCENE_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_LUCENE_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_LUCENE_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_LUCENE_COMPONENT_ANALYZER_CONF = "camel.component.lucene.analyzer";
    public static final String CAMEL_SINK_LUCENE_COMPONENT_ANALYZER_DOC = "An Analyzer builds TokenStreams, which analyze text. It thus represents a policy for extracting index terms from text. The value for analyzer can be any class that extends the abstract class org.apache.lucene.analysis.Analyzer. Lucene also offers a rich set of analyzers out of the box";
    public static final String CAMEL_SINK_LUCENE_COMPONENT_ANALYZER_DEFAULT = null;
    public static final String CAMEL_SINK_LUCENE_COMPONENT_INDEX_DIR_CONF = "camel.component.lucene.indexDir";
    public static final String CAMEL_SINK_LUCENE_COMPONENT_INDEX_DIR_DOC = "A file system directory in which index files are created upon analysis of the document by the specified analyzer";
    public static final String CAMEL_SINK_LUCENE_COMPONENT_INDEX_DIR_DEFAULT = null;
    public static final String CAMEL_SINK_LUCENE_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.lucene.lazyStartProducer";
    public static final String CAMEL_SINK_LUCENE_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_LUCENE_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_LUCENE_COMPONENT_MAX_HITS_CONF = "camel.component.lucene.maxHits";
    public static final String CAMEL_SINK_LUCENE_COMPONENT_MAX_HITS_DOC = "An integer value that limits the result set of the search operation";
    public static final Integer CAMEL_SINK_LUCENE_COMPONENT_MAX_HITS_DEFAULT = null;
    public static final String CAMEL_SINK_LUCENE_COMPONENT_SRC_DIR_CONF = "camel.component.lucene.srcDir";
    public static final String CAMEL_SINK_LUCENE_COMPONENT_SRC_DIR_DOC = "An optional directory containing files to be used to be analyzed and added to the index at producer startup.";
    public static final String CAMEL_SINK_LUCENE_COMPONENT_SRC_DIR_DEFAULT = null;
    public static final String CAMEL_SINK_LUCENE_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.lucene.basicPropertyBinding";
    public static final String CAMEL_SINK_LUCENE_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_LUCENE_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_LUCENE_COMPONENT_CONFIG_CONF = "camel.component.lucene.config";
    public static final String CAMEL_SINK_LUCENE_COMPONENT_CONFIG_DOC = "To use a shared lucene configuration";
    public static final String CAMEL_SINK_LUCENE_COMPONENT_CONFIG_DEFAULT = null;

    public CamelLuceneSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelLuceneSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_LUCENE_PATH_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_LUCENE_PATH_HOST_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_LUCENE_PATH_HOST_DOC);
        conf.define(CAMEL_SINK_LUCENE_PATH_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_LUCENE_PATH_OPERATION_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_LUCENE_PATH_OPERATION_DOC);
        conf.define(CAMEL_SINK_LUCENE_ENDPOINT_ANALYZER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_LUCENE_ENDPOINT_ANALYZER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LUCENE_ENDPOINT_ANALYZER_DOC);
        conf.define(CAMEL_SINK_LUCENE_ENDPOINT_INDEX_DIR_CONF, ConfigDef.Type.STRING, CAMEL_SINK_LUCENE_ENDPOINT_INDEX_DIR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LUCENE_ENDPOINT_INDEX_DIR_DOC);
        conf.define(CAMEL_SINK_LUCENE_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_LUCENE_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LUCENE_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_LUCENE_ENDPOINT_MAX_HITS_CONF, ConfigDef.Type.INT, CAMEL_SINK_LUCENE_ENDPOINT_MAX_HITS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LUCENE_ENDPOINT_MAX_HITS_DOC);
        conf.define(CAMEL_SINK_LUCENE_ENDPOINT_SRC_DIR_CONF, ConfigDef.Type.STRING, CAMEL_SINK_LUCENE_ENDPOINT_SRC_DIR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LUCENE_ENDPOINT_SRC_DIR_DOC);
        conf.define(CAMEL_SINK_LUCENE_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_LUCENE_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LUCENE_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_LUCENE_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_LUCENE_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LUCENE_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_LUCENE_COMPONENT_ANALYZER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_LUCENE_COMPONENT_ANALYZER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LUCENE_COMPONENT_ANALYZER_DOC);
        conf.define(CAMEL_SINK_LUCENE_COMPONENT_INDEX_DIR_CONF, ConfigDef.Type.STRING, CAMEL_SINK_LUCENE_COMPONENT_INDEX_DIR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LUCENE_COMPONENT_INDEX_DIR_DOC);
        conf.define(CAMEL_SINK_LUCENE_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_LUCENE_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LUCENE_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_LUCENE_COMPONENT_MAX_HITS_CONF, ConfigDef.Type.INT, CAMEL_SINK_LUCENE_COMPONENT_MAX_HITS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LUCENE_COMPONENT_MAX_HITS_DOC);
        conf.define(CAMEL_SINK_LUCENE_COMPONENT_SRC_DIR_CONF, ConfigDef.Type.STRING, CAMEL_SINK_LUCENE_COMPONENT_SRC_DIR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LUCENE_COMPONENT_SRC_DIR_DOC);
        conf.define(CAMEL_SINK_LUCENE_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_LUCENE_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.LOW, CAMEL_SINK_LUCENE_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_LUCENE_COMPONENT_CONFIG_CONF, ConfigDef.Type.STRING, CAMEL_SINK_LUCENE_COMPONENT_CONFIG_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_LUCENE_COMPONENT_CONFIG_DOC);
        return conf;
    }
}