/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.corda;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelCordaSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_CORDA_PATH_NODE_CONF = "camel.source.path.node";
    public static final String CAMEL_SOURCE_CORDA_PATH_NODE_DOC = "The url for the corda node";
    public static final String CAMEL_SOURCE_CORDA_PATH_NODE_DEFAULT = null;
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_CORDA_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_PAGE_SPECIFICATION_CONF = "camel.source.endpoint.pageSpecification";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_PAGE_SPECIFICATION_DOC = "PageSpecification allows specification of a page number (starting from 1) and page size (defaulting to 200 with a maximum page size of (Integer.MAX_INT) Note: we default the page number to 200 to enable queries without requiring a page specification but enabling detection of large results sets that fall out of the 200 requirement. Max page size should be used with extreme caution as results may exceed your JVM memory footprint.";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_PAGE_SPECIFICATION_DEFAULT = "200";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_PROCESS_SNAPSHOT_CONF = "camel.source.endpoint.processSnapshot";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_PROCESS_SNAPSHOT_DOC = "Whether to process snapshots or not";
    public static final Boolean CAMEL_SOURCE_CORDA_ENDPOINT_PROCESS_SNAPSHOT_DEFAULT = true;
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_SORT_CONF = "camel.source.endpoint.sort";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_SORT_DOC = "Sort allows specification of a set of entity attribute names and their associated directionality and null handling, to be applied upon processing a query specification. One of: [ASC] [DESC]";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_SORT_DEFAULT = null;
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_CONTRACT_STATE_CLASS_CONF = "camel.source.endpoint.contractStateClass";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_CONTRACT_STATE_CLASS_DOC = "A contract state (or just state) contains opaque data used by a contract program. It can be thought of as a disk file that the program can use to persist data across transactions. States are immutable: once created they are never updated, instead, any changes must generate a new successor state. States can be updated (consumed) only once: the notary is responsible for ensuring there is no double spending by only signing a transaction if the input states are all free.";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_CONTRACT_STATE_CLASS_DEFAULT = null;
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_FLOW_LOGIC_ARGUMENTS_CONF = "camel.source.endpoint.flowLogicArguments";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_FLOW_LOGIC_ARGUMENTS_DOC = "Start the given flow with the given arguments, returning an Observable with a single observation of the result of running the flow. The flowLogicClass must be annotated with net.corda.core.flows.StartableByRPC.";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_FLOW_LOGIC_ARGUMENTS_DEFAULT = null;
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_FLOW_LOGIC_CLASS_CONF = "camel.source.endpoint.flowLogicClass";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_FLOW_LOGIC_CLASS_DOC = "Start the given flow with the given arguments, returning an Observable with a single observation of the result of running the flow. The flowLogicClass must be annotated with net.corda.core.flows.StartableByRPC.";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_FLOW_LOGIC_CLASS_DEFAULT = null;
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_QUERY_CRITERIA_CONF = "camel.source.endpoint.queryCriteria";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_QUERY_CRITERIA_DOC = "QueryCriteria assumes underlying schema tables are correctly indexed for performance.";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_QUERY_CRITERIA_DEFAULT = null;
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.source.endpoint.basicPropertyBinding";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_CORDA_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_CORDA_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_PASSWORD_CONF = "camel.source.endpoint.password";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_PASSWORD_DOC = "Password for login";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_USERNAME_CONF = "camel.source.endpoint.username";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_USERNAME_DOC = "Username for login";
    public static final String CAMEL_SOURCE_CORDA_ENDPOINT_USERNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_CONFIGURATION_CONF = "camel.component.corda.configuration";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_CONFIGURATION_DOC = "To use a shared configuration.";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.corda.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_CORDA_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_PAGE_SPECIFICATION_CONF = "camel.component.corda.pageSpecification";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_PAGE_SPECIFICATION_DOC = "PageSpecification allows specification of a page number (starting from 1) and page size (defaulting to 200 with a maximum page size of (Integer.MAX_INT) Note: we default the page number to 200 to enable queries without requiring a page specification but enabling detection of large results sets that fall out of the 200 requirement. Max page size should be used with extreme caution as results may exceed your JVM memory footprint.";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_PAGE_SPECIFICATION_DEFAULT = "200";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_PROCESS_SNAPSHOT_CONF = "camel.component.corda.processSnapshot";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_PROCESS_SNAPSHOT_DOC = "Whether to process snapshots or not";
    public static final Boolean CAMEL_SOURCE_CORDA_COMPONENT_PROCESS_SNAPSHOT_DEFAULT = true;
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_SORT_CONF = "camel.component.corda.sort";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_SORT_DOC = "Sort allows specification of a set of entity attribute names and their associated directionality and null handling, to be applied upon processing a query specification. One of: [ASC] [DESC]";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_SORT_DEFAULT = null;
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_CONTRACT_STATE_CLASS_CONF = "camel.component.corda.contractStateClass";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_CONTRACT_STATE_CLASS_DOC = "A contract state (or just state) contains opaque data used by a contract program. It can be thought of as a disk file that the program can use to persist data across transactions. States are immutable: once created they are never updated, instead, any changes must generate a new successor state. States can be updated (consumed) only once: the notary is responsible for ensuring there is no double spending by only signing a transaction if the input states are all free.";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_CONTRACT_STATE_CLASS_DEFAULT = null;
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_FLOW_LOGIC_ARGUMENTS_CONF = "camel.component.corda.flowLogicArguments";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_FLOW_LOGIC_ARGUMENTS_DOC = "Start the given flow with the given arguments, returning an Observable with a single observation of the result of running the flow. The flowLogicClass must be annotated with net.corda.core.flows.StartableByRPC.";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_FLOW_LOGIC_ARGUMENTS_DEFAULT = null;
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_FLOW_LOGIC_CLASS_CONF = "camel.component.corda.flowLogicClass";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_FLOW_LOGIC_CLASS_DOC = "Start the given flow with the given arguments, returning an Observable with a single observation of the result of running the flow. The flowLogicClass must be annotated with net.corda.core.flows.StartableByRPC.";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_FLOW_LOGIC_CLASS_DEFAULT = null;
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_QUERY_CRITERIA_CONF = "camel.component.corda.queryCriteria";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_QUERY_CRITERIA_DOC = "QueryCriteria assumes underlying schema tables are correctly indexed for performance.";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_QUERY_CRITERIA_DEFAULT = null;
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.corda.basicPropertyBinding";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_CORDA_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_PASSWORD_CONF = "camel.component.corda.password";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_PASSWORD_DOC = "Password for login";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_USERNAME_CONF = "camel.component.corda.username";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_USERNAME_DOC = "Username for login";
    public static final String CAMEL_SOURCE_CORDA_COMPONENT_USERNAME_DEFAULT = null;

    public CamelCordaSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelCordaSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_CORDA_PATH_NODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_PATH_NODE_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_CORDA_PATH_NODE_DOC);
        conf.define(CAMEL_SOURCE_CORDA_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_CORDA_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_CORDA_ENDPOINT_PAGE_SPECIFICATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_ENDPOINT_PAGE_SPECIFICATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_ENDPOINT_PAGE_SPECIFICATION_DOC);
        conf.define(CAMEL_SOURCE_CORDA_ENDPOINT_PROCESS_SNAPSHOT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_CORDA_ENDPOINT_PROCESS_SNAPSHOT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_ENDPOINT_PROCESS_SNAPSHOT_DOC);
        conf.define(CAMEL_SOURCE_CORDA_ENDPOINT_SORT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_ENDPOINT_SORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_ENDPOINT_SORT_DOC);
        conf.define(CAMEL_SOURCE_CORDA_ENDPOINT_CONTRACT_STATE_CLASS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_ENDPOINT_CONTRACT_STATE_CLASS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_ENDPOINT_CONTRACT_STATE_CLASS_DOC);
        conf.define(CAMEL_SOURCE_CORDA_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_CORDA_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_CORDA_ENDPOINT_FLOW_LOGIC_ARGUMENTS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_ENDPOINT_FLOW_LOGIC_ARGUMENTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_ENDPOINT_FLOW_LOGIC_ARGUMENTS_DOC);
        conf.define(CAMEL_SOURCE_CORDA_ENDPOINT_FLOW_LOGIC_CLASS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_ENDPOINT_FLOW_LOGIC_CLASS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_ENDPOINT_FLOW_LOGIC_CLASS_DOC);
        conf.define(CAMEL_SOURCE_CORDA_ENDPOINT_QUERY_CRITERIA_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_ENDPOINT_QUERY_CRITERIA_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_ENDPOINT_QUERY_CRITERIA_DOC);
        conf.define(CAMEL_SOURCE_CORDA_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_CORDA_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_CORDA_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_CORDA_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_CORDA_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_CORDA_ENDPOINT_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_ENDPOINT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_ENDPOINT_USERNAME_DOC);
        conf.define(CAMEL_SOURCE_CORDA_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SOURCE_CORDA_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_CORDA_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_CORDA_COMPONENT_PAGE_SPECIFICATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_COMPONENT_PAGE_SPECIFICATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_COMPONENT_PAGE_SPECIFICATION_DOC);
        conf.define(CAMEL_SOURCE_CORDA_COMPONENT_PROCESS_SNAPSHOT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_CORDA_COMPONENT_PROCESS_SNAPSHOT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_COMPONENT_PROCESS_SNAPSHOT_DOC);
        conf.define(CAMEL_SOURCE_CORDA_COMPONENT_SORT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_COMPONENT_SORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_COMPONENT_SORT_DOC);
        conf.define(CAMEL_SOURCE_CORDA_COMPONENT_CONTRACT_STATE_CLASS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_COMPONENT_CONTRACT_STATE_CLASS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_COMPONENT_CONTRACT_STATE_CLASS_DOC);
        conf.define(CAMEL_SOURCE_CORDA_COMPONENT_FLOW_LOGIC_ARGUMENTS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_COMPONENT_FLOW_LOGIC_ARGUMENTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_COMPONENT_FLOW_LOGIC_ARGUMENTS_DOC);
        conf.define(CAMEL_SOURCE_CORDA_COMPONENT_FLOW_LOGIC_CLASS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_COMPONENT_FLOW_LOGIC_CLASS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_COMPONENT_FLOW_LOGIC_CLASS_DOC);
        conf.define(CAMEL_SOURCE_CORDA_COMPONENT_QUERY_CRITERIA_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_COMPONENT_QUERY_CRITERIA_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_COMPONENT_QUERY_CRITERIA_DOC);
        conf.define(CAMEL_SOURCE_CORDA_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_CORDA_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.LOW, CAMEL_SOURCE_CORDA_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_CORDA_COMPONENT_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_COMPONENT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_COMPONENT_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_CORDA_COMPONENT_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_CORDA_COMPONENT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_CORDA_COMPONENT_USERNAME_DOC);
        return conf;
    }
}