/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.azurestorageblob;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelAzurestorageblobSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_AZURESTORAGEBLOB_PATH_ACCOUNT_NAME_CONF = "camel.sink.path.accountName";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_PATH_ACCOUNT_NAME_DOC = "Azure account name to be used for authentication with azure blob services";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_PATH_ACCOUNT_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_PATH_CONTAINER_NAME_CONF = "camel.sink.path.containerName";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_PATH_CONTAINER_NAME_DOC = "The blob container name";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_PATH_CONTAINER_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_AUTO_DISCOVER_CLIENT_CONF = "camel.sink.endpoint.autoDiscoverClient";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_AUTO_DISCOVER_CLIENT_DOC = "Setting the autoDiscoverClient mechanism, if true, the component will look for a client instance in the registry automatically otherwise it will skip that checking.";
    public static final Boolean CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_AUTO_DISCOVER_CLIENT_DEFAULT = true;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_NAME_CONF = "camel.sink.endpoint.blobName";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_NAME_DOC = "The blob name, to consume specific blob from a container. However on producer, is only required for the operations on the blob level";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_OFFSET_CONF = "camel.sink.endpoint.blobOffset";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_OFFSET_DOC = "Set the blob offset for the upload or download operations, default is 0";
    public static final Long CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_OFFSET_DEFAULT = 0L;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_SERVICE_CLIENT_CONF = "camel.sink.endpoint.blobServiceClient";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_SERVICE_CLIENT_DOC = "Client to a storage account. This client does not hold any state about a particular storage account but is instead a convenient way of sending off appropriate requests to the resource on the service. It may also be used to construct URLs to blobs and containers. This client contains operations on a service account. Operations on a container are available on BlobContainerClient through getBlobContainerClient(String), and operations on a blob are available on BlobClient through getBlobContainerClient(String).getBlobClient(String).";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_SERVICE_CLIENT_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_TYPE_CONF = "camel.sink.endpoint.blobType";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_TYPE_DOC = "The blob type in order to initiate the appropriate settings for each blob type One of: [blockblob] [appendblob] [pageblob]";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_TYPE_DEFAULT = "blockblob";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CLOSE_STREAM_AFTER_READ_CONF = "camel.sink.endpoint.closeStreamAfterRead";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CLOSE_STREAM_AFTER_READ_DOC = "Close the stream after read or keep it open, default is true";
    public static final Boolean CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CLOSE_STREAM_AFTER_READ_DEFAULT = true;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREDENTIALS_CONF = "camel.sink.endpoint.credentials";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREDENTIALS_DOC = "StorageSharedKeyCredential can be injected to create the azure client, this holds the important authentication information";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREDENTIALS_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_DATA_COUNT_CONF = "camel.sink.endpoint.dataCount";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_DATA_COUNT_DOC = "How many bytes to include in the range. Must be greater than or equal to 0 if specified.";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_DATA_COUNT_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_FILE_DIR_CONF = "camel.sink.endpoint.fileDir";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_FILE_DIR_DOC = "The file directory where the downloaded blobs will be saved to, this can be used in both, producer and consumer";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_FILE_DIR_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_MAX_RESULTS_PER_PAGE_CONF = "camel.sink.endpoint.maxResultsPerPage";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_MAX_RESULTS_PER_PAGE_DOC = "Specifies the maximum number of blobs to return, including all BlobPrefix elements. If the request does not specify maxResultsPerPage or specifies a value greater than 5,000, the server will return up to 5,000 items.";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_MAX_RESULTS_PER_PAGE_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_MAX_RETRY_REQUESTS_CONF = "camel.sink.endpoint.maxRetryRequests";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_MAX_RETRY_REQUESTS_DOC = "Specifies the maximum number of additional HTTP Get requests that will be made while reading the data from a response body.";
    public static final Integer CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_MAX_RETRY_REQUESTS_DEFAULT = 0;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_PREFIX_CONF = "camel.sink.endpoint.prefix";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_PREFIX_DOC = "Filters the results to return only blobs whose names begin with the specified prefix. May be null to return all blobs.";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_PREFIX_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_SERVICE_CLIENT_CONF = "camel.sink.endpoint.serviceClient";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_SERVICE_CLIENT_DOC = "Client to a storage account. This client does not hold any state about a particular storage account but is instead a convenient way of sending off appropriate requests to the resource on the service. It may also be used to construct URLs to blobs and containers. This client contains operations on a service account. Operations on a container are available on BlobContainerClient through BlobServiceClient#getBlobContainerClient(String), and operations on a blob are available on BlobClient through BlobContainerClient#getBlobClient(String).";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_SERVICE_CLIENT_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_TIMEOUT_CONF = "camel.sink.endpoint.timeout";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_TIMEOUT_DOC = "An optional timeout value beyond which a RuntimeException will be raised.";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_TIMEOUT_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_SEQUENCE_NUMBER_CONF = "camel.sink.endpoint.blobSequenceNumber";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_SEQUENCE_NUMBER_DOC = "A user-controlled value that you can use to track requests. The value of the sequence number must be between 0 and 263 - 1.The default value is 0.";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_SEQUENCE_NUMBER_DEFAULT = "0";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOCK_LIST_TYPE_CONF = "camel.sink.endpoint.blockListType";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOCK_LIST_TYPE_DOC = "Specifies which type of blocks to return. One of: [committed] [uncommitted] [all]";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOCK_LIST_TYPE_DEFAULT = "COMMITTED";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CLOSE_STREAM_AFTER_WRITE_CONF = "camel.sink.endpoint.closeStreamAfterWrite";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CLOSE_STREAM_AFTER_WRITE_DOC = "Close the stream after write or keep it open, default is true";
    public static final Boolean CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CLOSE_STREAM_AFTER_WRITE_DEFAULT = true;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_COMMIT_BLOCK_LIST_LATER_CONF = "camel.sink.endpoint.commitBlockListLater";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_COMMIT_BLOCK_LIST_LATER_DOC = "When is set to true, the staged blocks will not be committed directly.";
    public static final Boolean CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_COMMIT_BLOCK_LIST_LATER_DEFAULT = true;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREATE_APPEND_BLOB_CONF = "camel.sink.endpoint.createAppendBlob";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREATE_APPEND_BLOB_DOC = "When is set to true, the append blocks will be created when committing append blocks.";
    public static final Boolean CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREATE_APPEND_BLOB_DEFAULT = true;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREATE_PAGE_BLOB_CONF = "camel.sink.endpoint.createPageBlob";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREATE_PAGE_BLOB_DOC = "When is set to true, the page blob will be created when uploading page blob.";
    public static final Boolean CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREATE_PAGE_BLOB_DEFAULT = true;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_DOWNLOAD_LINK_EXPIRATION_CONF = "camel.sink.endpoint.downloadLinkExpiration";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_DOWNLOAD_LINK_EXPIRATION_DOC = "Override the default expiration (millis) of URL download link.";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_DOWNLOAD_LINK_EXPIRATION_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_OPERATION_CONF = "camel.sink.endpoint.operation";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_OPERATION_DOC = "The blob operation that can be used with this component on the producer One of: [listBlobContainers] [createBlobContainer] [deleteBlobContainer] [listBlobs] [getBlob] [deleteBlob] [downloadBlobToFile] [downloadLink] [uploadBlockBlob] [stageBlockBlobList] [commitBlobBlockList] [getBlobBlockList] [createAppendBlob] [commitAppendBlob] [createPageBlob] [uploadPageBlob] [resizePageBlob] [clearPageBlob] [getPageBlobRanges]";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_OPERATION_DEFAULT = "listBlobContainers";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_PAGE_BLOB_SIZE_CONF = "camel.sink.endpoint.pageBlobSize";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_PAGE_BLOB_SIZE_DOC = "Specifies the maximum size for the page blob, up to 8 TB. The page blob size must be aligned to a 512-byte boundary.";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_PAGE_BLOB_SIZE_DEFAULT = "512";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.sink.endpoint.basicPropertyBinding";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_ACCESS_KEY_CONF = "camel.sink.endpoint.accessKey";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_ACCESS_KEY_DOC = "Access key for the associated azure account name to be used for authentication with azure blob services";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_ACCESS_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_AUTO_DISCOVER_CLIENT_CONF = "camel.component.azure-storage-blob.autoDiscoverClient";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_AUTO_DISCOVER_CLIENT_DOC = "Setting the autoDiscoverClient mechanism, if true, the component will look for a client instance in the registry automatically otherwise it will skip that checking.";
    public static final Boolean CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_AUTO_DISCOVER_CLIENT_DEFAULT = true;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_NAME_CONF = "camel.component.azure-storage-blob.blobName";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_NAME_DOC = "The blob name, to consume specific blob from a container. However on producer, is only required for the operations on the blob level";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_OFFSET_CONF = "camel.component.azure-storage-blob.blobOffset";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_OFFSET_DOC = "Set the blob offset for the upload or download operations, default is 0";
    public static final Long CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_OFFSET_DEFAULT = 0L;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_TYPE_CONF = "camel.component.azure-storage-blob.blobType";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_TYPE_DOC = "The blob type in order to initiate the appropriate settings for each blob type One of: [blockblob] [appendblob] [pageblob]";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_TYPE_DEFAULT = "blockblob";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CLOSE_STREAM_AFTER_READ_CONF = "camel.component.azure-storage-blob.closeStreamAfterRead";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CLOSE_STREAM_AFTER_READ_DOC = "Close the stream after read or keep it open, default is true";
    public static final Boolean CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CLOSE_STREAM_AFTER_READ_DEFAULT = true;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CONFIGURATION_CONF = "camel.component.azure-storage-blob.configuration";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CONFIGURATION_DOC = "The component configurations";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREDENTIALS_CONF = "camel.component.azure-storage-blob.credentials";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREDENTIALS_DOC = "StorageSharedKeyCredential can be injected to create the azure client, this holds the important authentication information";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREDENTIALS_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_DATA_COUNT_CONF = "camel.component.azure-storage-blob.dataCount";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_DATA_COUNT_DOC = "How many bytes to include in the range. Must be greater than or equal to 0 if specified.";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_DATA_COUNT_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_FILE_DIR_CONF = "camel.component.azure-storage-blob.fileDir";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_FILE_DIR_DOC = "The file directory where the downloaded blobs will be saved to, this can be used in both, producer and consumer";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_FILE_DIR_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_MAX_RESULTS_PER_PAGE_CONF = "camel.component.azure-storage-blob.maxResultsPerPage";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_MAX_RESULTS_PER_PAGE_DOC = "Specifies the maximum number of blobs to return, including all BlobPrefix elements. If the request does not specify maxResultsPerPage or specifies a value greater than 5,000, the server will return up to 5,000 items.";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_MAX_RESULTS_PER_PAGE_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_MAX_RETRY_REQUESTS_CONF = "camel.component.azure-storage-blob.maxRetryRequests";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_MAX_RETRY_REQUESTS_DOC = "Specifies the maximum number of additional HTTP Get requests that will be made while reading the data from a response body.";
    public static final Integer CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_MAX_RETRY_REQUESTS_DEFAULT = 0;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_PREFIX_CONF = "camel.component.azure-storage-blob.prefix";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_PREFIX_DOC = "Filters the results to return only blobs whose names begin with the specified prefix. May be null to return all blobs.";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_PREFIX_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_SERVICE_CLIENT_CONF = "camel.component.azure-storage-blob.serviceClient";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_SERVICE_CLIENT_DOC = "Client to a storage account. This client does not hold any state about a particular storage account but is instead a convenient way of sending off appropriate requests to the resource on the service. It may also be used to construct URLs to blobs and containers. This client contains operations on a service account. Operations on a container are available on BlobContainerClient through BlobServiceClient#getBlobContainerClient(String), and operations on a blob are available on BlobClient through BlobContainerClient#getBlobClient(String).";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_SERVICE_CLIENT_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_TIMEOUT_CONF = "camel.component.azure-storage-blob.timeout";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_TIMEOUT_DOC = "An optional timeout value beyond which a RuntimeException will be raised.";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_TIMEOUT_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_SEQUENCE_NUMBER_CONF = "camel.component.azure-storage-blob.blobSequenceNumber";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_SEQUENCE_NUMBER_DOC = "A user-controlled value that you can use to track requests. The value of the sequence number must be between 0 and 263 - 1.The default value is 0.";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_SEQUENCE_NUMBER_DEFAULT = "0";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOCK_LIST_TYPE_CONF = "camel.component.azure-storage-blob.blockListType";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOCK_LIST_TYPE_DOC = "Specifies which type of blocks to return. One of: [committed] [uncommitted] [all]";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOCK_LIST_TYPE_DEFAULT = "COMMITTED";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CLOSE_STREAM_AFTER_WRITE_CONF = "camel.component.azure-storage-blob.closeStreamAfterWrite";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CLOSE_STREAM_AFTER_WRITE_DOC = "Close the stream after write or keep it open, default is true";
    public static final Boolean CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CLOSE_STREAM_AFTER_WRITE_DEFAULT = true;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_COMMIT_BLOCK_LIST_LATER_CONF = "camel.component.azure-storage-blob.commitBlockListLater";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_COMMIT_BLOCK_LIST_LATER_DOC = "When is set to true, the staged blocks will not be committed directly.";
    public static final Boolean CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_COMMIT_BLOCK_LIST_LATER_DEFAULT = true;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREATE_APPEND_BLOB_CONF = "camel.component.azure-storage-blob.createAppendBlob";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREATE_APPEND_BLOB_DOC = "When is set to true, the append blocks will be created when committing append blocks.";
    public static final Boolean CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREATE_APPEND_BLOB_DEFAULT = true;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREATE_PAGE_BLOB_CONF = "camel.component.azure-storage-blob.createPageBlob";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREATE_PAGE_BLOB_DOC = "When is set to true, the page blob will be created when uploading page blob.";
    public static final Boolean CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREATE_PAGE_BLOB_DEFAULT = true;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_DOWNLOAD_LINK_EXPIRATION_CONF = "camel.component.azure-storage-blob.downloadLinkExpiration";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_DOWNLOAD_LINK_EXPIRATION_DOC = "Override the default expiration (millis) of URL download link.";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_DOWNLOAD_LINK_EXPIRATION_DEFAULT = null;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.azure-storage-blob.lazyStartProducer";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_OPERATION_CONF = "camel.component.azure-storage-blob.operation";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_OPERATION_DOC = "The blob operation that can be used with this component on the producer One of: [listBlobContainers] [createBlobContainer] [deleteBlobContainer] [listBlobs] [getBlob] [deleteBlob] [downloadBlobToFile] [downloadLink] [uploadBlockBlob] [stageBlockBlobList] [commitBlobBlockList] [getBlobBlockList] [createAppendBlob] [commitAppendBlob] [createPageBlob] [uploadPageBlob] [resizePageBlob] [clearPageBlob] [getPageBlobRanges]";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_OPERATION_DEFAULT = "listBlobContainers";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_PAGE_BLOB_SIZE_CONF = "camel.component.azure-storage-blob.pageBlobSize";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_PAGE_BLOB_SIZE_DOC = "Specifies the maximum size for the page blob, up to 8 TB. The page blob size must be aligned to a 512-byte boundary.";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_PAGE_BLOB_SIZE_DEFAULT = "512";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.azure-storage-blob.basicPropertyBinding";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_ACCESS_KEY_CONF = "camel.component.azure-storage-blob.accessKey";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_ACCESS_KEY_DOC = "Access key for the associated azure account name to be used for authentication with azure blob services";
    public static final String CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_ACCESS_KEY_DEFAULT = null;

    public CamelAzurestorageblobSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelAzurestorageblobSinkConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_PATH_ACCOUNT_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_PATH_ACCOUNT_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_PATH_ACCOUNT_NAME_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_PATH_CONTAINER_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_PATH_CONTAINER_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_PATH_CONTAINER_NAME_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_AUTO_DISCOVER_CLIENT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_AUTO_DISCOVER_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_AUTO_DISCOVER_CLIENT_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_NAME_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_OFFSET_CONF, ConfigDef.Type.LONG, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_OFFSET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_OFFSET_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_SERVICE_CLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_SERVICE_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_SERVICE_CLIENT_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_TYPE_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CLOSE_STREAM_AFTER_READ_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CLOSE_STREAM_AFTER_READ_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CLOSE_STREAM_AFTER_READ_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREDENTIALS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREDENTIALS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREDENTIALS_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_DATA_COUNT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_DATA_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_DATA_COUNT_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_FILE_DIR_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_FILE_DIR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_FILE_DIR_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_MAX_RESULTS_PER_PAGE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_MAX_RESULTS_PER_PAGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_MAX_RESULTS_PER_PAGE_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_MAX_RETRY_REQUESTS_CONF, ConfigDef.Type.INT, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_MAX_RETRY_REQUESTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_MAX_RETRY_REQUESTS_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_PREFIX_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_PREFIX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_PREFIX_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_SERVICE_CLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_SERVICE_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_SERVICE_CLIENT_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_TIMEOUT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_SEQUENCE_NUMBER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_SEQUENCE_NUMBER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOB_SEQUENCE_NUMBER_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOCK_LIST_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOCK_LIST_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BLOCK_LIST_TYPE_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CLOSE_STREAM_AFTER_WRITE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CLOSE_STREAM_AFTER_WRITE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CLOSE_STREAM_AFTER_WRITE_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_COMMIT_BLOCK_LIST_LATER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_COMMIT_BLOCK_LIST_LATER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_COMMIT_BLOCK_LIST_LATER_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREATE_APPEND_BLOB_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREATE_APPEND_BLOB_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREATE_APPEND_BLOB_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREATE_PAGE_BLOB_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREATE_PAGE_BLOB_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_CREATE_PAGE_BLOB_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_DOWNLOAD_LINK_EXPIRATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_DOWNLOAD_LINK_EXPIRATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_DOWNLOAD_LINK_EXPIRATION_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_OPERATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_OPERATION_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_PAGE_BLOB_SIZE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_PAGE_BLOB_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_PAGE_BLOB_SIZE_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_ACCESS_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_ACCESS_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_ENDPOINT_ACCESS_KEY_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_AUTO_DISCOVER_CLIENT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_AUTO_DISCOVER_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_AUTO_DISCOVER_CLIENT_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_NAME_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_OFFSET_CONF, ConfigDef.Type.LONG, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_OFFSET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_OFFSET_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_TYPE_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CLOSE_STREAM_AFTER_READ_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CLOSE_STREAM_AFTER_READ_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CLOSE_STREAM_AFTER_READ_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREDENTIALS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREDENTIALS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREDENTIALS_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_DATA_COUNT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_DATA_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_DATA_COUNT_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_FILE_DIR_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_FILE_DIR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_FILE_DIR_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_MAX_RESULTS_PER_PAGE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_MAX_RESULTS_PER_PAGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_MAX_RESULTS_PER_PAGE_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_MAX_RETRY_REQUESTS_CONF, ConfigDef.Type.INT, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_MAX_RETRY_REQUESTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_MAX_RETRY_REQUESTS_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_PREFIX_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_PREFIX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_PREFIX_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_SERVICE_CLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_SERVICE_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_SERVICE_CLIENT_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_TIMEOUT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_SEQUENCE_NUMBER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_SEQUENCE_NUMBER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOB_SEQUENCE_NUMBER_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOCK_LIST_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOCK_LIST_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BLOCK_LIST_TYPE_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CLOSE_STREAM_AFTER_WRITE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CLOSE_STREAM_AFTER_WRITE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CLOSE_STREAM_AFTER_WRITE_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_COMMIT_BLOCK_LIST_LATER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_COMMIT_BLOCK_LIST_LATER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_COMMIT_BLOCK_LIST_LATER_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREATE_APPEND_BLOB_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREATE_APPEND_BLOB_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREATE_APPEND_BLOB_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREATE_PAGE_BLOB_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREATE_PAGE_BLOB_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_CREATE_PAGE_BLOB_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_DOWNLOAD_LINK_EXPIRATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_DOWNLOAD_LINK_EXPIRATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_DOWNLOAD_LINK_EXPIRATION_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_OPERATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_OPERATION_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_PAGE_BLOB_SIZE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_PAGE_BLOB_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_PAGE_BLOB_SIZE_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.LOW, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_ACCESS_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_ACCESS_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURESTORAGEBLOB_COMPONENT_ACCESS_KEY_DOC);
        return conf;
    }
}