# Changelog

## [Unreleased](https://github.com/apache/camel-kafka-connector/tree/HEAD)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.4.4...HEAD)

**Implemented enhancements:**

- Better handling of property with no default values using `ConfigDef.NO\_DEFAULT\_VALUE` [\#563](https://github.com/apache/camel-kafka-connector/issues/563)
- camel-kafka-connector-generator-maven-plugin: prevent the ovewrite of exixting classes unless they are @Generated annotated [\#146](https://github.com/apache/camel-kafka-connector/issues/146)

**Closed issues:**

- Add the required field for connector options in docs and catalog [\#617](https://github.com/apache/camel-kafka-connector/issues/617)
- Move ConnectRecordValueToMapTransformer of Elastisearch IT test in the connector [\#615](https://github.com/apache/camel-kafka-connector/issues/615)
- Add a Telegram example  [\#613](https://github.com/apache/camel-kafka-connector/issues/613)
- Remove camel-hipchat from camel-master [\#603](https://github.com/apache/camel-kafka-connector/issues/603)
- Add a file watch connector example  [\#600](https://github.com/apache/camel-kafka-connector/issues/600)
- Camel Kafka connector extensible is broken with mvnd [\#598](https://github.com/apache/camel-kafka-connector/issues/598)
- Rename all transformers, converters, aggregationStrategies to reflect the maning convention we have [\#590](https://github.com/apache/camel-kafka-connector/issues/590)
- Strimzi 0.20: Lets test early with Release candidate [\#581](https://github.com/apache/camel-kafka-connector/issues/581)
- Slack Connector: Add the slack transformer from itest to the slack connector ootb [\#580](https://github.com/apache/camel-kafka-connector/issues/580)
- Provide API on Camel Kafka Connector to add/remove connectors dynamically [\#573](https://github.com/apache/camel-kafka-connector/issues/573)
- Improve README [\#569](https://github.com/apache/camel-kafka-connector/issues/569)
- Create an AWS2-Translate example [\#564](https://github.com/apache/camel-kafka-connector/issues/564)
- Add converters, transforms and aggregationStrategies to catalog [\#559](https://github.com/apache/camel-kafka-connector/issues/559)
- Add more convenience method to CamelKafkaConnectorCatalog [\#558](https://github.com/apache/camel-kafka-connector/issues/558)
- Improve Catalog and cleanup [\#537](https://github.com/apache/camel-kafka-connector/issues/537)
- Create a source distribution module [\#524](https://github.com/apache/camel-kafka-connector/issues/524)
- Create examples with dataformat in camel-kafka-connector-examples repo [\#509](https://github.com/apache/camel-kafka-connector/issues/509)
- Examples instructions for Openshift too [\#465](https://github.com/apache/camel-kafka-connector/issues/465)
- Add integration test for archetype [\#462](https://github.com/apache/camel-kafka-connector/issues/462)
- Provide a catalog of potential configuration properties specific to Camel Kafka Connector [\#430](https://github.com/apache/camel-kafka-connector/issues/430)

**Merged pull requests:**

- Early Strimzi Test: Lets test with 0.20.0 RC3 [\#631](https://github.com/apache/camel-kafka-connector/pull/631) ([oscerd](https://github.com/oscerd))
- Added integration test for Couchbase sink [\#630](https://github.com/apache/camel-kafka-connector/pull/630) ([orpiske](https://github.com/orpiske))
- Added convenience method to get option from connector name and option name [\#627](https://github.com/apache/camel-kafka-connector/pull/627) ([oscerd](https://github.com/oscerd))
- Automatic changelog: Remove deprecated github action commands [\#626](https://github.com/apache/camel-kafka-connector/pull/626) ([oscerd](https://github.com/oscerd))
- Cleanup distribution [\#625](https://github.com/apache/camel-kafka-connector/pull/625) ([oscerd](https://github.com/oscerd))
- Add the required field for connector options in docs and catalog [\#624](https://github.com/apache/camel-kafka-connector/pull/624) ([oscerd](https://github.com/oscerd))
- cleanup core deps and leftovers [\#623](https://github.com/apache/camel-kafka-connector/pull/623) ([lburgazzoli](https://github.com/lburgazzoli))
- core: use EndpointUriFactory to compute endpoint urls instead of the runtime catalog [\#622](https://github.com/apache/camel-kafka-connector/pull/622) ([lburgazzoli](https://github.com/lburgazzoli))
- Removed Camel 3.6.0 staging repository [\#620](https://github.com/apache/camel-kafka-connector/pull/620) ([oscerd](https://github.com/oscerd))
- Move ConnectRecordValueToMapTransformer of Elastisearch IT test in the connector [\#618](https://github.com/apache/camel-kafka-connector/pull/618) ([oscerd](https://github.com/oscerd))
- Swap arguments so they are in the correct order: expected value, actual [\#616](https://github.com/apache/camel-kafka-connector/pull/616) ([apupier](https://github.com/apupier))
- Added Release to 0.4.4 to Camel compatibility matrix [\#614](https://github.com/apache/camel-kafka-connector/pull/614) ([oscerd](https://github.com/oscerd))
- Staging 3.6.0 and camel master [\#612](https://github.com/apache/camel-kafka-connector/pull/612) ([oscerd](https://github.com/oscerd))
- JDK naming Jenkinsfiles [\#610](https://github.com/apache/camel-kafka-connector/pull/610) ([oscerd](https://github.com/oscerd))
- Apply the Strimzi next profile only to the connector build [\#608](https://github.com/apache/camel-kafka-connector/pull/608) ([orpiske](https://github.com/orpiske))
- Reneamed a method to better understanding, added a test and javadoc a… [\#607](https://github.com/apache/camel-kafka-connector/pull/607) ([valdar](https://github.com/valdar))
- Catalog improve [\#606](https://github.com/apache/camel-kafka-connector/pull/606) ([valdar](https://github.com/valdar))
- Improve CKC core [\#601](https://github.com/apache/camel-kafka-connector/pull/601) ([lburgazzoli](https://github.com/lburgazzoli))
- Updated the mvnd command on the readme [\#599](https://github.com/apache/camel-kafka-connector/pull/599) ([orpiske](https://github.com/orpiske))
- Camel-kafka-connector-catalog: Adding some more tests [\#596](https://github.com/apache/camel-kafka-connector/pull/596) ([oscerd](https://github.com/oscerd))
- Slack transforms [\#595](https://github.com/apache/camel-kafka-connector/pull/595) ([oscerd](https://github.com/oscerd))
- Rename all transformers, converters, aggregationStrategies to reflect the maning convention we have [\#593](https://github.com/apache/camel-kafka-connector/pull/593) ([oscerd](https://github.com/oscerd))
- Improve readme [\#591](https://github.com/apache/camel-kafka-connector/pull/591) ([orpiske](https://github.com/orpiske))
- Add converters, transforms and aggregationStrategies to catalog [\#589](https://github.com/apache/camel-kafka-connector/pull/589) ([oscerd](https://github.com/oscerd))
- Avoid usage of static for Camel Kafka Connector catalog [\#588](https://github.com/apache/camel-kafka-connector/pull/588) ([apupier](https://github.com/apupier))
- Added GH actions to run the camel-master build using the Strimzi Next profile [\#587](https://github.com/apache/camel-kafka-connector/pull/587) ([orpiske](https://github.com/orpiske))
- Changes to documents - change version from 0.3.0-SNAPSHOT, give the right location of the properties file within docs/examples [\#586](https://github.com/apache/camel-kafka-connector/pull/586) ([cunningt](https://github.com/cunningt))
- Issue/563 [\#585](https://github.com/apache/camel-kafka-connector/pull/585) ([valdar](https://github.com/valdar))
- JMS example: Added missing steps [\#584](https://github.com/apache/camel-kafka-connector/pull/584) ([oscerd](https://github.com/oscerd))
- Added new test for Azure Storage Blob sink [\#582](https://github.com/apache/camel-kafka-connector/pull/582) ([orpiske](https://github.com/orpiske))
- ISSUE-524 Create a source distribution module [\#577](https://github.com/apache/camel-kafka-connector/pull/577) ([cunningt](https://github.com/cunningt))
- ISSUE-146 Prevent the overwrite of existing classes unless they are @Generated annotated [\#576](https://github.com/apache/camel-kafka-connector/pull/576) ([cunningt](https://github.com/cunningt))
- Camel-Kafka-kafka-connector is back [\#575](https://github.com/apache/camel-kafka-connector/pull/575) ([oscerd](https://github.com/oscerd))
- 573 allow to add remove elements from catalog dynamically through api [\#574](https://github.com/apache/camel-kafka-connector/pull/574) ([apupier](https://github.com/apupier))
- Add back AWS\*-connectors [\#572](https://github.com/apache/camel-kafka-connector/pull/572) ([oscerd](https://github.com/oscerd))
- Improve Catalog and cleanup [\#571](https://github.com/apache/camel-kafka-connector/pull/571) ([oscerd](https://github.com/oscerd))
- github action: add trigger on workflow\_dispatch [\#568](https://github.com/apache/camel-kafka-connector/pull/568) ([lburgazzoli](https://github.com/lburgazzoli))
- GH actions: Fixed deploy action [\#567](https://github.com/apache/camel-kafka-connector/pull/567) ([oscerd](https://github.com/oscerd))
- Do not use the wrapper test client on the AWS v2 service classes [\#562](https://github.com/apache/camel-kafka-connector/pull/562) ([orpiske](https://github.com/orpiske))
- Have CamelKafkaConnectorCatalog working with bundled jar [\#554](https://github.com/apache/camel-kafka-connector/pull/554) ([apupier](https://github.com/apupier))
- Catalog: Removed static modifier from getConnectorsModel [\#553](https://github.com/apache/camel-kafka-connector/pull/553) ([oscerd](https://github.com/oscerd))
- build: execute ci-build for pr/push to the camel-master branch [\#552](https://github.com/apache/camel-kafka-connector/pull/552) ([lburgazzoli](https://github.com/lburgazzoli))
- Jenkinsfiles clean [\#551](https://github.com/apache/camel-kafka-connector/pull/551) ([oscerd](https://github.com/oscerd))
- Catalog: expose an API for consuming connectors catalog metadata and options [\#548](https://github.com/apache/camel-kafka-connector/pull/548) ([oscerd](https://github.com/oscerd))
- core: simplify kafka headers to camel exchange mapping [\#547](https://github.com/apache/camel-kafka-connector/pull/547) ([lburgazzoli](https://github.com/lburgazzoli))
- source: better handling of headers of type Data [\#546](https://github.com/apache/camel-kafka-connector/pull/546) ([lburgazzoli](https://github.com/lburgazzoli))
- Do not use the wrapper test client on the AWS service classes [\#545](https://github.com/apache/camel-kafka-connector/pull/545) ([orpiske](https://github.com/orpiske))
- core: cast from Byte\[\] to byte\[\] fails because of incompatible types [\#543](https://github.com/apache/camel-kafka-connector/pull/543) ([lburgazzoli](https://github.com/lburgazzoli))
- core: add support for aggreation on source sinks [\#541](https://github.com/apache/camel-kafka-connector/pull/541) ([lburgazzoli](https://github.com/lburgazzoli))
- Improve Catalog and cleanup [\#540](https://github.com/apache/camel-kafka-connector/pull/540) ([oscerd](https://github.com/oscerd))
- \[core\] use Endpoint instead of URI string to send exchnages using the producer template [\#538](https://github.com/apache/camel-kafka-connector/pull/538) ([lburgazzoli](https://github.com/lburgazzoli))
- Catalog: Rename the json file to reflect the id and connectors.properties content [\#536](https://github.com/apache/camel-kafka-connector/pull/536) ([oscerd](https://github.com/oscerd))
- Improve core [\#535](https://github.com/apache/camel-kafka-connector/pull/535) ([lburgazzoli](https://github.com/lburgazzoli))
- Clean up usages of org.junit.Assert [\#533](https://github.com/apache/camel-kafka-connector/pull/533) ([mureinik](https://github.com/mureinik))
- chore\(build\): merge GitHub workflow master-pr-build master-push-build [\#532](https://github.com/apache/camel-kafka-connector/pull/532) ([lburgazzoli](https://github.com/lburgazzoli))
- Added build details using mvnd [\#531](https://github.com/apache/camel-kafka-connector/pull/531) ([orpiske](https://github.com/orpiske))
- Add a Maven Plugin to collect the connector descriptors for catalog purpose [\#530](https://github.com/apache/camel-kafka-connector/pull/530) ([oscerd](https://github.com/oscerd))
- chore\(build\): split build in multiple steps [\#528](https://github.com/apache/camel-kafka-connector/pull/528) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(build\): use AdoptOpenJDK to set-up java [\#527](https://github.com/apache/camel-kafka-connector/pull/527) ([lburgazzoli](https://github.com/lburgazzoli))
- \[camel-main-support\] Use BaseMainSupport instead of Main [\#526](https://github.com/apache/camel-kafka-connector/pull/526) ([lburgazzoli](https://github.com/lburgazzoli))
- Create descriptors for source and sink connector for catalog purpose [\#525](https://github.com/apache/camel-kafka-connector/pull/525) ([oscerd](https://github.com/oscerd))
- camel-kafka-connector-model should have tooling pom as parent pom [\#521](https://github.com/apache/camel-kafka-connector/pull/521) ([valdar](https://github.com/valdar))
- Added encoding to maven-resources-plugin to avoid warning [\#520](https://github.com/apache/camel-kafka-connector/pull/520) ([oscerd](https://github.com/oscerd))
- Fixed GH Actions with the new camel-kafka-connector-model [\#519](https://github.com/apache/camel-kafka-connector/pull/519) ([oscerd](https://github.com/oscerd))
- Move model classes CamelKafkaConnectorModel and CamelKafkaConnectorOp… [\#518](https://github.com/apache/camel-kafka-connector/pull/518) ([oscerd](https://github.com/oscerd))
- adding docs that explain the directory requirement under the plugins folder [\#517](https://github.com/apache/camel-kafka-connector/pull/517) ([codexetreme](https://github.com/codexetreme))
- Added a camel-kafka-connector-catalog collecting all the JSON metadata [\#516](https://github.com/apache/camel-kafka-connector/pull/516) ([oscerd](https://github.com/oscerd))
- Generate a Json Metadata file for each connector [\#512](https://github.com/apache/camel-kafka-connector/pull/512) ([oscerd](https://github.com/oscerd))
- Opted the project in for HAcktoberfest 2020. [\#511](https://github.com/apache/camel-kafka-connector/pull/511) ([valdar](https://github.com/valdar))
- Add an integration test for the archetype [\#510](https://github.com/apache/camel-kafka-connector/pull/510) ([cunningt](https://github.com/cunningt))
- \[camel-main-support\] Reordering props should not be required anymore [\#507](https://github.com/apache/camel-kafka-connector/pull/507) ([oscerd](https://github.com/oscerd))
- Removed folder added for error and regen docs [\#504](https://github.com/apache/camel-kafka-connector/pull/504) ([oscerd](https://github.com/oscerd))
- Throttles strimzi startup to prevent resource reuse errors [\#503](https://github.com/apache/camel-kafka-connector/pull/503) ([orpiske](https://github.com/orpiske))
- Rabbitmq itest [\#501](https://github.com/apache/camel-kafka-connector/pull/501) ([valdar](https://github.com/valdar))
- Removed the Jenkinsfile deploy pipeline, we are now using gh action [\#496](https://github.com/apache/camel-kafka-connector/pull/496) ([oscerd](https://github.com/oscerd))
- Upgrade Maven Wrapper to 0.5.6 [\#495](https://github.com/apache/camel-kafka-connector/pull/495) ([oscerd](https://github.com/oscerd))
- Deploy on ASF Snapshot [\#493](https://github.com/apache/camel-kafka-connector/pull/493) ([oscerd](https://github.com/oscerd))
- Issue 490 [\#491](https://github.com/apache/camel-kafka-connector/pull/491) ([oscerd](https://github.com/oscerd))
- Fixes changelog to run only on master [\#488](https://github.com/apache/camel-kafka-connector/pull/488) ([oscerd](https://github.com/oscerd))
- Removed bean-validator kafka connector [\#483](https://github.com/apache/camel-kafka-connector/pull/483) ([oscerd](https://github.com/oscerd))
- Re-introduce camel-bean-kafka-connector [\#482](https://github.com/apache/camel-kafka-connector/pull/482) ([oscerd](https://github.com/oscerd))
- Bean connector removed [\#481](https://github.com/apache/camel-kafka-connector/pull/481) ([oscerd](https://github.com/oscerd))
- Added AWS S3 test using AWS v2 [\#480](https://github.com/apache/camel-kafka-connector/pull/480) ([orpiske](https://github.com/orpiske))
- Fix GH connection timeout issue [\#478](https://github.com/apache/camel-kafka-connector/pull/478) ([orpiske](https://github.com/orpiske))
- Fixes typos when an invalid instance type is provided [\#477](https://github.com/apache/camel-kafka-connector/pull/477) ([orpiske](https://github.com/orpiske))
- Implement the connection timeout work-around [\#476](https://github.com/apache/camel-kafka-connector/pull/476) ([orpiske](https://github.com/orpiske))
- Removed browse and class connector [\#475](https://github.com/apache/camel-kafka-connector/pull/475) ([oscerd](https://github.com/oscerd))
- Removed digitalocean connector [\#472](https://github.com/apache/camel-kafka-connector/pull/472) ([oscerd](https://github.com/oscerd))
- .asf.yaml: Enabled only rebase and squash button on PR [\#471](https://github.com/apache/camel-kafka-connector/pull/471) ([oscerd](https://github.com/oscerd))
- Replaced the use of kubectl with oc command. [\#468](https://github.com/apache/camel-kafka-connector/pull/468) ([valdar](https://github.com/valdar))
- Updated opesnhift documentation to strimzi 0.19.0 and compatible with… [\#467](https://github.com/apache/camel-kafka-connector/pull/467) ([valdar](https://github.com/valdar))
- Document update [\#464](https://github.com/apache/camel-kafka-connector/pull/464) ([NiteshKoushik](https://github.com/NiteshKoushik))
- Document Update [\#461](https://github.com/apache/camel-kafka-connector/pull/461) ([NiteshKoushik](https://github.com/NiteshKoushik))
- Document Update [\#460](https://github.com/apache/camel-kafka-connector/pull/460) ([NiteshKoushik](https://github.com/NiteshKoushik))
- Switch from Gitter to Zulip [\#459](https://github.com/apache/camel-kafka-connector/pull/459) ([lburgazzoli](https://github.com/lburgazzoli))
- Support for topics.regex [\#458](https://github.com/apache/camel-kafka-connector/pull/458) ([oscerd](https://github.com/oscerd))
- Added 0.5.0 to the compatibility matrix [\#453](https://github.com/apache/camel-kafka-connector/pull/453) ([oscerd](https://github.com/oscerd))
- 0.5.0 docs [\#452](https://github.com/apache/camel-kafka-connector/pull/452) ([oscerd](https://github.com/oscerd))
- Updated SQS example [\#450](https://github.com/apache/camel-kafka-connector/pull/450) ([oscerd](https://github.com/oscerd))
- Updated SQS example [\#449](https://github.com/apache/camel-kafka-connector/pull/449) ([oscerd](https://github.com/oscerd))
- Update AWS SNS example [\#448](https://github.com/apache/camel-kafka-connector/pull/448) ([oscerd](https://github.com/oscerd))
- Updated the AWS S3 example [\#447](https://github.com/apache/camel-kafka-connector/pull/447) ([oscerd](https://github.com/oscerd))
- Updated the Cassandra example [\#446](https://github.com/apache/camel-kafka-connector/pull/446) ([oscerd](https://github.com/oscerd))

## [camel-kafka-connector-0.4.4](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.4.4) (2020-10-10)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.5.0...camel-kafka-connector-0.4.4)

**Fixed bugs:**

- Azure blob sink does not put file in azure [\#270](https://github.com/apache/camel-kafka-connector/issues/270)

**Closed issues:**

- source: better handling of headers of type Data [\#544](https://github.com/apache/camel-kafka-connector/issues/544)
- Catalog: expose an API for consuming connectors catalog metadata and options [\#542](https://github.com/apache/camel-kafka-connector/issues/542)
- Catalog: Rename the json file to reflect the id and connectors.properties content [\#534](https://github.com/apache/camel-kafka-connector/issues/534)
- Add a Maven Plugin to collect the connector descriptors for catalog purpose [\#529](https://github.com/apache/camel-kafka-connector/issues/529)
- Create descriptors for source and sink connector for catalog purpose [\#523](https://github.com/apache/camel-kafka-connector/issues/523)
- Move model classes CamelKafkaConnectorModel and CamelKafkaConnectorOptionModel in their own module [\#515](https://github.com/apache/camel-kafka-connector/issues/515)
- Copy all Json connectors metadata into a camel-kafka-connector-catalog [\#514](https://github.com/apache/camel-kafka-connector/issues/514)
- Document build steps w/ mvnd [\#513](https://github.com/apache/camel-kafka-connector/issues/513)
- Generator a JSON metadata file for each connector [\#508](https://github.com/apache/camel-kafka-connector/issues/508)
- \[camel-main-support\] Use BaseMainSupport instead of Main [\#499](https://github.com/apache/camel-kafka-connector/issues/499)
- \[camel-main-support\] Reordering props should not be required anymore [\#498](https://github.com/apache/camel-kafka-connector/issues/498)
- Add an ASF deploy GH Action like other camel projects [\#492](https://github.com/apache/camel-kafka-connector/issues/492)
- MongoDB Kafka Connector: In the docs add Json as base value converter [\#490](https://github.com/apache/camel-kafka-connector/issues/490)
- Create an Infinispan example [\#486](https://github.com/apache/camel-kafka-connector/issues/486)
- Create Minio connector examples [\#456](https://github.com/apache/camel-kafka-connector/issues/456)
- Support topics.regex  [\#454](https://github.com/apache/camel-kafka-connector/issues/454)
- Define a default naming for converters, transforms and aggregation packages [\#439](https://github.com/apache/camel-kafka-connector/issues/439)
- High CPU Usage with RabbitMQ Connector \(polling interface implemented incorrectly?\) [\#414](https://github.com/apache/camel-kafka-connector/issues/414)
- How to have connector output JSON String? [\#398](https://github.com/apache/camel-kafka-connector/issues/398)
- Question: Does Camel looks for IAM roles from Env variables [\#282](https://github.com/apache/camel-kafka-connector/issues/282)

**Merged pull requests:**

- Added connector class on each connector documentation page [\#406](https://github.com/apache/camel-kafka-connector/pull/406) ([oscerd](https://github.com/oscerd))
- Removed wrong terminal output from example in archetype docs [\#395](https://github.com/apache/camel-kafka-connector/pull/395) ([oscerd](https://github.com/oscerd))
- Point to correct branch in gh workflows [\#385](https://github.com/apache/camel-kafka-connector/pull/385) ([oscerd](https://github.com/oscerd))
- Point to correct branch in github workflows [\#384](https://github.com/apache/camel-kafka-connector/pull/384) ([oscerd](https://github.com/oscerd))
- Camel 3.4.3 [\#382](https://github.com/apache/camel-kafka-connector/pull/382) ([oscerd](https://github.com/oscerd))
- Backport raw fixes [\#371](https://github.com/apache/camel-kafka-connector/pull/371) ([oscerd](https://github.com/oscerd))
- Make the camel-kafka-connector archetype use the parent POM [\#364](https://github.com/apache/camel-kafka-connector/pull/364) ([oscerd](https://github.com/oscerd))
- Fixed index adoc [\#353](https://github.com/apache/camel-kafka-connector/pull/353) ([oscerd](https://github.com/oscerd))
- Added missing connector in connectors pom [\#351](https://github.com/apache/camel-kafka-connector/pull/351) ([oscerd](https://github.com/oscerd))
- 0.4.1-SNAPSHOT [\#349](https://github.com/apache/camel-kafka-connector/pull/349) ([oscerd](https://github.com/oscerd))
- Pointing to 0.4.x on this branch for antora [\#348](https://github.com/apache/camel-kafka-connector/pull/348) ([oscerd](https://github.com/oscerd))
- Release 0.4.0 [\#347](https://github.com/apache/camel-kafka-connector/pull/347) ([oscerd](https://github.com/oscerd))

## [camel-kafka-connector-0.5.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.5.0) (2020-09-09)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.4.0...camel-kafka-connector-0.5.0)

**Implemented enhancements:**

- Add the connector class to use in the documentation of each connector [\#321](https://github.com/apache/camel-kafka-connector/issues/321)
- Support multiple topics for connector configuration [\#197](https://github.com/apache/camel-kafka-connector/issues/197)
- Generate a catalog of supported connectors [\#141](https://github.com/apache/camel-kafka-connector/issues/141)

**Fixed bugs:**

- flaky syslog integration test  [\#367](https://github.com/apache/camel-kafka-connector/issues/367)
- UnitOfWork.done\(\) needs to be called on Polled exchanges [\#202](https://github.com/apache/camel-kafka-connector/issues/202)

**Closed issues:**

- Unreleased Resource: Database [\#436](https://github.com/apache/camel-kafka-connector/issues/436)
- Create an NSQ example [\#429](https://github.com/apache/camel-kafka-connector/issues/429)
- Archetype: Add a parameter to the archetype generator to be able to specify what connector we want to extend [\#419](https://github.com/apache/camel-kafka-connector/issues/419)
- IMPROVEMENT REQUEST: Add a transformer mode to the connectors to make lightweight edits to the messages while they are being produced/consumed [\#410](https://github.com/apache/camel-kafka-connector/issues/410)
- aws2-S3-connector: \(gzip/zip\) compression with sink [\#387](https://github.com/apache/camel-kafka-connector/issues/387)
- Discussion: troubleshooting documentation? [\#381](https://github.com/apache/camel-kafka-connector/issues/381)
- Bump to Camel 3.4.3 [\#379](https://github.com/apache/camel-kafka-connector/issues/379)
- Documentation: SJMS2 connector is incompatible with activemq-all [\#378](https://github.com/apache/camel-kafka-connector/issues/378)
- Unclean startup causes an NPE on shutdown [\#376](https://github.com/apache/camel-kafka-connector/issues/376)
- Make the camel-kafka-connector archetype use the parent POM [\#362](https://github.com/apache/camel-kafka-connector/issues/362)
- Exception on endpoint being treated as a polling consumer before createPollingConsumer is called. [\#361](https://github.com/apache/camel-kafka-connector/issues/361)
- Add a Nats connector examples in camel-kafka-connector-examples repo [\#359](https://github.com/apache/camel-kafka-connector/issues/359)
- Add a compatibility matrix related to camel version in docs [\#344](https://github.com/apache/camel-kafka-connector/issues/344)
- aws2S3connector: moveAfterRead true bucket not created [\#339](https://github.com/apache/camel-kafka-connector/issues/339)
- CamelAwssqsSinkConnector does not work when specifying AWS credentials in camel.sink.endpoint [\#319](https://github.com/apache/camel-kafka-connector/issues/319)
- Create a Kinesis Firehose Connector example [\#318](https://github.com/apache/camel-kafka-connector/issues/318)
- Nullpointer exception at org.apache.camel.component.aws2.s3.AWS2S3Producer.processSingleOp [\#299](https://github.com/apache/camel-kafka-connector/issues/299)
- Add Aggregate integration test [\#291](https://github.com/apache/camel-kafka-connector/issues/291)
- Enable testRetrieveFromCassandraWithCustomStrategy on CamelSourceCassandraITCase [\#288](https://github.com/apache/camel-kafka-connector/issues/288)

**Merged pull requests:**

- Fix potentially unreleased DB resources in test code [\#437](https://github.com/apache/camel-kafka-connector/pull/437) ([orpiske](https://github.com/orpiske))
- Automatic changelog: Run it just one time during the night [\#435](https://github.com/apache/camel-kafka-connector/pull/435) ([oscerd](https://github.com/oscerd))
- Run the changelog automatic updated every hour [\#434](https://github.com/apache/camel-kafka-connector/pull/434) ([oscerd](https://github.com/oscerd))
- Update try-it-out-on-openshift-with-strimzi.adoc with latest AWS S3 connector config [\#433](https://github.com/apache/camel-kafka-connector/pull/433) ([smccarthy-ie](https://github.com/smccarthy-ie))
- Pr Build and push build needs to point to master [\#432](https://github.com/apache/camel-kafka-connector/pull/432) ([oscerd](https://github.com/oscerd))
- adding a key transformer to the AWS2-SQS connector so that the CamelH… [\#431](https://github.com/apache/camel-kafka-connector/pull/431) ([codexetreme](https://github.com/codexetreme))
- Proposed fix for issue \#414 [\#428](https://github.com/apache/camel-kafka-connector/pull/428) ([orpiske](https://github.com/orpiske))
- Camel 3.5.0 [\#427](https://github.com/apache/camel-kafka-connector/pull/427) ([oscerd](https://github.com/oscerd))
- Docs: Updated archetypes docs [\#422](https://github.com/apache/camel-kafka-connector/pull/422) ([oscerd](https://github.com/oscerd))
- Archetype: Add a parameter to the archetype generator to be able to s… [\#421](https://github.com/apache/camel-kafka-connector/pull/421) ([oscerd](https://github.com/oscerd))
- Fix a minor typo [\#420](https://github.com/apache/camel-kafka-connector/pull/420) ([oscerd](https://github.com/oscerd))
- Removed deploy phase from jenkinsfile, we already have the daily snap… [\#418](https://github.com/apache/camel-kafka-connector/pull/418) ([oscerd](https://github.com/oscerd))
- Remove deploy phase from Jenkinsfile, we have the daily snapshot depl… [\#417](https://github.com/apache/camel-kafka-connector/pull/417) ([oscerd](https://github.com/oscerd))
- \[Github Actions\] Periodic Sync Camel-kafka-connector camel-master Branch [\#416](https://github.com/apache/camel-kafka-connector/pull/416) ([github-actions[bot]](https://github.com/apps/github-actions))
- Activemq-all note for SJMS2 connector [\#415](https://github.com/apache/camel-kafka-connector/pull/415) ([oscerd](https://github.com/oscerd))
- Rework the testing documentation and adds test writing details [\#413](https://github.com/apache/camel-kafka-connector/pull/413) ([orpiske](https://github.com/orpiske))
- Added new test for Azure Storage Queue sink [\#412](https://github.com/apache/camel-kafka-connector/pull/412) ([orpiske](https://github.com/orpiske))
- Support Multiple topics on Source Connector [\#411](https://github.com/apache/camel-kafka-connector/pull/411) ([oscerd](https://github.com/oscerd))
- Added connector class on each connector documentation page [\#405](https://github.com/apache/camel-kafka-connector/pull/405) ([oscerd](https://github.com/oscerd))
- Added a pipeline for deploying on daily basis [\#404](https://github.com/apache/camel-kafka-connector/pull/404) ([oscerd](https://github.com/oscerd))
- \#389 - Fix doc- Kubernetes command [\#401](https://github.com/apache/camel-kafka-connector/pull/401) ([rogeriob2br](https://github.com/rogeriob2br))
- Fix mongodb test [\#396](https://github.com/apache/camel-kafka-connector/pull/396) ([unsortedhashsets](https://github.com/unsortedhashsets))
- Removed wrong terminal output from example in archetype docs [\#394](https://github.com/apache/camel-kafka-connector/pull/394) ([oscerd](https://github.com/oscerd))
- Kafka-clients is not a test dependency [\#393](https://github.com/apache/camel-kafka-connector/pull/393) ([oscerd](https://github.com/oscerd))
- Added automatic-sync gh action for camel-kafka-connector on camel-mas… [\#392](https://github.com/apache/camel-kafka-connector/pull/392) ([oscerd](https://github.com/oscerd))
- Adds basic aggregation test \(github issue \#291\) [\#388](https://github.com/apache/camel-kafka-connector/pull/388) ([orpiske](https://github.com/orpiske))
- Fix flaky syslog test [\#386](https://github.com/apache/camel-kafka-connector/pull/386) ([orpiske](https://github.com/orpiske))
- Added a simple troubleshooting guide [\#383](https://github.com/apache/camel-kafka-connector/pull/383) ([orpiske](https://github.com/orpiske))
- Upgrade to camel 3.4.3 [\#380](https://github.com/apache/camel-kafka-connector/pull/380) ([oscerd](https://github.com/oscerd))
- Prevent NPEs on shutdown when critical errors occur [\#377](https://github.com/apache/camel-kafka-connector/pull/377) ([orpiske](https://github.com/orpiske))
- Fixed incorrect number of log arguments in S3 exception handling [\#375](https://github.com/apache/camel-kafka-connector/pull/375) ([orpiske](https://github.com/orpiske))
- Defer topic deletion [\#374](https://github.com/apache/camel-kafka-connector/pull/374) ([orpiske](https://github.com/orpiske))
- Fixes for edge cases [\#373](https://github.com/apache/camel-kafka-connector/pull/373) ([orpiske](https://github.com/orpiske))
- Added missing fromUrl to the log message [\#372](https://github.com/apache/camel-kafka-connector/pull/372) ([orpiske](https://github.com/orpiske))
- Removes debugging message [\#370](https://github.com/apache/camel-kafka-connector/pull/370) ([orpiske](https://github.com/orpiske))
- Removing backport gh action. It doesn't work. [\#369](https://github.com/apache/camel-kafka-connector/pull/369) ([oscerd](https://github.com/oscerd))
- Minor AWS tests cleanups [\#368](https://github.com/apache/camel-kafka-connector/pull/368) ([orpiske](https://github.com/orpiske))
- Building endpoint uris should for secret options automatic use RAW\(\) … [\#366](https://github.com/apache/camel-kafka-connector/pull/366) ([davsclaus](https://github.com/davsclaus))
- Cutting down connectors [\#365](https://github.com/apache/camel-kafka-connector/pull/365) ([oscerd](https://github.com/oscerd))
- Make the camel-kafka-connector archetype use the parent POM [\#363](https://github.com/apache/camel-kafka-connector/pull/363) ([oscerd](https://github.com/oscerd))
- AWS SDK v2 integration tests: Kinesis [\#358](https://github.com/apache/camel-kafka-connector/pull/358) ([orpiske](https://github.com/orpiske))
- Use latest Strimzi's docker images [\#357](https://github.com/apache/camel-kafka-connector/pull/357) ([oscerd](https://github.com/oscerd))
- Fixed camel compatibility matrix table [\#356](https://github.com/apache/camel-kafka-connector/pull/356) ([oscerd](https://github.com/oscerd))
- Added a camel-compatibility matrix page [\#355](https://github.com/apache/camel-kafka-connector/pull/355) ([oscerd](https://github.com/oscerd))
- Upgrade Archetype docs [\#354](https://github.com/apache/camel-kafka-connector/pull/354) ([oscerd](https://github.com/oscerd))
- Fixed index adoc [\#352](https://github.com/apache/camel-kafka-connector/pull/352) ([oscerd](https://github.com/oscerd))
- Added missing connector in connectors pom [\#350](https://github.com/apache/camel-kafka-connector/pull/350) ([oscerd](https://github.com/oscerd))
- Release 0.4.0 [\#346](https://github.com/apache/camel-kafka-connector/pull/346) ([oscerd](https://github.com/oscerd))
- AWS Kinesis test fixes when in remote mode [\#345](https://github.com/apache/camel-kafka-connector/pull/345) ([orpiske](https://github.com/orpiske))

## [camel-kafka-connector-0.4.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.4.0) (2020-07-29)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.3.0...camel-kafka-connector-0.4.0)

**Implemented enhancements:**

- Being able to inject an aggregator in a sink connector [\#274](https://github.com/apache/camel-kafka-connector/issues/274)
- In case of Sink we need to use toD instead of to [\#252](https://github.com/apache/camel-kafka-connector/issues/252)
- Upgrade to Kafka 2.5.0 [\#249](https://github.com/apache/camel-kafka-connector/issues/249)
- Improve integration test support when component dependencies are present [\#211](https://github.com/apache/camel-kafka-connector/issues/211)
- Support both marshal and unmarshal in source and sinks [\#194](https://github.com/apache/camel-kafka-connector/issues/194)
- camel-kafka-connector-generator-maven-plugin: implement a component exclusion mechanism [\#148](https://github.com/apache/camel-kafka-connector/issues/148)

**Fixed bugs:**

- BigDecimal values are not handled correctly in Headers serialization and deserialization [\#325](https://github.com/apache/camel-kafka-connector/issues/325)
- Camel HDFS: does not work due to dependencies conflicts [\#263](https://github.com/apache/camel-kafka-connector/issues/263)
- NullPointerException during shutdown when using Salesforce component [\#245](https://github.com/apache/camel-kafka-connector/issues/245)

**Closed issues:**

- Camel-Elasticsearch Connector not working on OpenShift [\#342](https://github.com/apache/camel-kafka-connector/issues/342)
- aws2S3connector connected to minio ClassCastException [\#338](https://github.com/apache/camel-kafka-connector/issues/338)
- Add documentation for archetype [\#333](https://github.com/apache/camel-kafka-connector/issues/333)
- Add an archetype to be able to extend the existing connectors with converters/aggregators/transformations/pojo etc. [\#329](https://github.com/apache/camel-kafka-connector/issues/329)
- The committed block count cannot exceed the maximum limit of 50,000 blocks. [\#324](https://github.com/apache/camel-kafka-connector/issues/324)
- Upgrade to Camel 3.4.2 once released [\#322](https://github.com/apache/camel-kafka-connector/issues/322)
- CamelAwssqsSinkConnector is leaking AWS credentials into Kafka Connect log [\#320](https://github.com/apache/camel-kafka-connector/issues/320)
- How install camel-jira-kafka-connector [\#315](https://github.com/apache/camel-kafka-connector/issues/315)
- From S3 to kafka, when using Idempotent filter, Do we still fetch S3 file content ? [\#314](https://github.com/apache/camel-kafka-connector/issues/314)
- How to break messages when ingesting into kafka [\#313](https://github.com/apache/camel-kafka-connector/issues/313)
- In S3 source connector, how to fetch only new files ? [\#311](https://github.com/apache/camel-kafka-connector/issues/311)
- CAMEL-15063 work-around may be removed [\#310](https://github.com/apache/camel-kafka-connector/issues/310)
- Add an aggregation page in docs [\#303](https://github.com/apache/camel-kafka-connector/issues/303)
- Outdated camel-dependencies version? [\#297](https://github.com/apache/camel-kafka-connector/issues/297)
- Aggregator support for completionTimeout too [\#290](https://github.com/apache/camel-kafka-connector/issues/290)
- Upgrade to Camel 3.4.0 LTS version [\#283](https://github.com/apache/camel-kafka-connector/issues/283)
- Camel-MongoDB Kafka connector: example with sink connector [\#212](https://github.com/apache/camel-kafka-connector/issues/212)

**Merged pull requests:**

- Issue/194 [\#341](https://github.com/apache/camel-kafka-connector/pull/341) ([valdar](https://github.com/valdar))
- Re-enable a Cassandra test disabled due to CAMEL-15219 [\#337](https://github.com/apache/camel-kafka-connector/pull/337) ([orpiske](https://github.com/orpiske))
- Add CORE protocol support to SJMS2 connector [\#336](https://github.com/apache/camel-kafka-connector/pull/336) ([fvaleri](https://github.com/fvaleri))
- Document how to run camel-kafka-connector on Kubernetes. [\#335](https://github.com/apache/camel-kafka-connector/pull/335) ([fvaleri](https://github.com/fvaleri))
- Archetypes docs [\#334](https://github.com/apache/camel-kafka-connector/pull/334) ([oscerd](https://github.com/oscerd))
- Added Aggregation documentation [\#332](https://github.com/apache/camel-kafka-connector/pull/332) ([oscerd](https://github.com/oscerd))
- Introducing a camel-kafka-connector-extensible archetype for adding b… [\#330](https://github.com/apache/camel-kafka-connector/pull/330) ([oscerd](https://github.com/oscerd))
- Adds a new manual integration test for Slack source [\#328](https://github.com/apache/camel-kafka-connector/pull/328) ([orpiske](https://github.com/orpiske))
- Bump Camel to version 3.4.2 [\#327](https://github.com/apache/camel-kafka-connector/pull/327) ([oscerd](https://github.com/oscerd))
- Issue/325 [\#326](https://github.com/apache/camel-kafka-connector/pull/326) ([valdar](https://github.com/valdar))
- Added additional explanation about testing  [\#317](https://github.com/apache/camel-kafka-connector/pull/317) ([orpiske](https://github.com/orpiske))
- Added tests for JDBC sink [\#316](https://github.com/apache/camel-kafka-connector/pull/316) ([orpiske](https://github.com/orpiske))
- Reverts the work-around for CAMEL-15063 [\#312](https://github.com/apache/camel-kafka-connector/pull/312) ([orpiske](https://github.com/orpiske))
- Fix HDFS tests with Camel 3.4 \(related to issue \#263\) [\#309](https://github.com/apache/camel-kafka-connector/pull/309) ([orpiske](https://github.com/orpiske))
- Fixes AWS test cases when running with remote AWS services [\#308](https://github.com/apache/camel-kafka-connector/pull/308) ([orpiske](https://github.com/orpiske))
- Avoid logging the autoconfiguration summary from CamelMain [\#307](https://github.com/apache/camel-kafka-connector/pull/307) ([oscerd](https://github.com/oscerd))
- Upgrade Kafka to version 2.5.0 [\#306](https://github.com/apache/camel-kafka-connector/pull/306) ([oscerd](https://github.com/oscerd))
- Fix Typo in CamelTypeConverterTransform [\#304](https://github.com/apache/camel-kafka-connector/pull/304) ([oscerd](https://github.com/oscerd))
- Added Aggregation timeout [\#301](https://github.com/apache/camel-kafka-connector/pull/301) ([oscerd](https://github.com/oscerd))
- Fixes camel-dependencies to point to 3.4.0 [\#298](https://github.com/apache/camel-kafka-connector/pull/298) ([oscerd](https://github.com/oscerd))
- ToD support [\#296](https://github.com/apache/camel-kafka-connector/pull/296) ([oscerd](https://github.com/oscerd))
- Add tests for MongoDB [\#295](https://github.com/apache/camel-kafka-connector/pull/295) ([orpiske](https://github.com/orpiske))
- Temporarily disable HDFS tests due to issue \#263 [\#294](https://github.com/apache/camel-kafka-connector/pull/294) ([orpiske](https://github.com/orpiske))
- Bump to Camel 3.4.0 [\#293](https://github.com/apache/camel-kafka-connector/pull/293) ([oscerd](https://github.com/oscerd))
- Updated the packages docs page [\#292](https://github.com/apache/camel-kafka-connector/pull/292) ([oscerd](https://github.com/oscerd))
- Aggregate Support [\#289](https://github.com/apache/camel-kafka-connector/pull/289) ([oscerd](https://github.com/oscerd))
- Cassandra test improvements [\#286](https://github.com/apache/camel-kafka-connector/pull/286) ([orpiske](https://github.com/orpiske))
- Backport [\#285](https://github.com/apache/camel-kafka-connector/pull/285) ([oscerd](https://github.com/oscerd))
- Use release 0.3.0 as lastReleasedVersion [\#284](https://github.com/apache/camel-kafka-connector/pull/284) ([oscerd](https://github.com/oscerd))
- Fixed component exclusion in combination with filter [\#281](https://github.com/apache/camel-kafka-connector/pull/281) ([oscerd](https://github.com/oscerd))
- Component exclusion [\#278](https://github.com/apache/camel-kafka-connector/pull/278) ([oscerd](https://github.com/oscerd))
- Added tests for Camel HDFS Sink [\#277](https://github.com/apache/camel-kafka-connector/pull/277) ([orpiske](https://github.com/orpiske))

## [camel-kafka-connector-0.3.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.3.0) (2020-06-17)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/container-image-0.3.0...camel-kafka-connector-0.3.0)

**Fixed bugs:**

- Camel-elasticsearch-rest-kafka-connector throws java.lang.NoClassDefFoundError: org/apache/logging/log4j/LogManager [\#259](https://github.com/apache/camel-kafka-connector/issues/259)
- Possible problems in CamelSinkAWSSQSITCase tests [\#215](https://github.com/apache/camel-kafka-connector/issues/215)

**Closed issues:**

- Question: How to provide aws role:arn value to authenticate S3  [\#267](https://github.com/apache/camel-kafka-connector/issues/267)
- AWS S3: bucket name not resolved when using URL configuration [\#260](https://github.com/apache/camel-kafka-connector/issues/260)
- Caused by: java.lang.NoClassDefFoundError: Could not initialize class org.apache.camel.kafkaconnector.CamelSinkConnectorConfig [\#251](https://github.com/apache/camel-kafka-connector/issues/251)

**Merged pull requests:**

- Fix a javadoc issue. [\#276](https://github.com/apache/camel-kafka-connector/pull/276) ([valdar](https://github.com/valdar))
- fix \#259: Camel-elasticsearch-rest-kafka-connector throws java.lang.N… [\#275](https://github.com/apache/camel-kafka-connector/pull/275) ([valdar](https://github.com/valdar))
- Throw ConnectException due to failed exchanges [\#273](https://github.com/apache/camel-kafka-connector/pull/273) ([omarsmak](https://github.com/omarsmak))
- Issue/260 [\#272](https://github.com/apache/camel-kafka-connector/pull/272) ([valdar](https://github.com/valdar))
- Test modularization cleanups [\#271](https://github.com/apache/camel-kafka-connector/pull/271) ([orpiske](https://github.com/orpiske))
- AWS2-S3 connector: Added the same set of converters/transformers we h… [\#268](https://github.com/apache/camel-kafka-connector/pull/268) ([oscerd](https://github.com/oscerd))

## [container-image-0.3.0](https://github.com/apache/camel-kafka-connector/tree/container-image-0.3.0) (2020-06-10)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.2.0...container-image-0.3.0)

**Implemented enhancements:**

- Use camel-depencencies to import versions of common libraries like Jakson, qpid, log4j etc. [\#241](https://github.com/apache/camel-kafka-connector/issues/241)
- Autogenerate and example config file for each connector [\#220](https://github.com/apache/camel-kafka-connector/issues/220)
- S3 source connector delete files from source bucket [\#97](https://github.com/apache/camel-kafka-connector/issues/97)
-  Create example and itest for camel-syslog [\#77](https://github.com/apache/camel-kafka-connector/issues/77)

**Fixed bugs:**

- Wrong signature of autogenerated method `public static ConfigDef conf\(Map\<String, String\> parsedConfig\)` of each `Camel\*ConnectorConfig` [\#221](https://github.com/apache/camel-kafka-connector/issues/221)

**Closed issues:**

- Add CamelAMQP source and sink example properties [\#264](https://github.com/apache/camel-kafka-connector/issues/264)
- Add download links to the connectors list page [\#261](https://github.com/apache/camel-kafka-connector/issues/261)
- Camel AWS2-S3: Add the same converters and transforms we have for AWS-S3 connector [\#250](https://github.com/apache/camel-kafka-connector/issues/250)
- pls  [\#248](https://github.com/apache/camel-kafka-connector/issues/248)
- Connectors doc generation shuld be moved from `core` to `connectors` module [\#226](https://github.com/apache/camel-kafka-connector/issues/226)
- Investigate why syslog documentation result in a missing link [\#225](https://github.com/apache/camel-kafka-connector/issues/225)
- CamelSinkTask Properties need to be cleaned up before going ahead [\#224](https://github.com/apache/camel-kafka-connector/issues/224)
- CamelSinkTask headers must be cleaned before sending them ahead [\#223](https://github.com/apache/camel-kafka-connector/issues/223)
- Updater the readme of autogenerated connectors doc page [\#219](https://github.com/apache/camel-kafka-connector/issues/219)
- Bump to Camel 3.3.0 [\#217](https://github.com/apache/camel-kafka-connector/issues/217)

**Merged pull requests:**

- Docs download link [\#266](https://github.com/apache/camel-kafka-connector/pull/266) ([oscerd](https://github.com/oscerd))
- Add AMQP examples for source and sink [\#265](https://github.com/apache/camel-kafka-connector/pull/265) ([rgannu](https://github.com/rgannu))
- Split the tests in modules per service [\#262](https://github.com/apache/camel-kafka-connector/pull/262) ([orpiske](https://github.com/orpiske))
- chore\(pgp\): update pgp key for Nicola Ferraro [\#256](https://github.com/apache/camel-kafka-connector/pull/256) ([nicolaferraro](https://github.com/nicolaferraro))
- Updated try-it-out-on-openshift-with-strimzi.adoc [\#255](https://github.com/apache/camel-kafka-connector/pull/255) ([valdar](https://github.com/valdar))
- Adds integration tests for Salesforce [\#247](https://github.com/apache/camel-kafka-connector/pull/247) ([orpiske](https://github.com/orpiske))
- Fixed quickstarts docs [\#246](https://github.com/apache/camel-kafka-connector/pull/246) ([oscerd](https://github.com/oscerd))
- Sf fix [\#244](https://github.com/apache/camel-kafka-connector/pull/244) ([valdar](https://github.com/valdar))
- Use camel-depencencies to import versions of common libraries like Ja… [\#243](https://github.com/apache/camel-kafka-connector/pull/243) ([oscerd](https://github.com/oscerd))
- Fix CamelSinkAWSSQSITCase unreliability with blocking initialization [\#242](https://github.com/apache/camel-kafka-connector/pull/242) ([orpiske](https://github.com/orpiske))
- Bump Log4j to version 2.13.3 [\#240](https://github.com/apache/camel-kafka-connector/pull/240) ([oscerd](https://github.com/oscerd))
- Example prop autogen [\#239](https://github.com/apache/camel-kafka-connector/pull/239) ([valdar](https://github.com/valdar))
- Bump Jackson to version 2.10.4 [\#238](https://github.com/apache/camel-kafka-connector/pull/238) ([oscerd](https://github.com/oscerd))
- Bump Qpid JMS client to version 0.51.0 [\#237](https://github.com/apache/camel-kafka-connector/pull/237) ([oscerd](https://github.com/oscerd))
- Upgrade Strimzi images to 0.18.0-kafka-2.4.1 [\#236](https://github.com/apache/camel-kafka-connector/pull/236) ([oscerd](https://github.com/oscerd))
- CamelSinkTask Properties need to be cleaned up before going ahead [\#235](https://github.com/apache/camel-kafka-connector/pull/235) ([oscerd](https://github.com/oscerd))
- CamelSinkTask headers must be cleaned before sending them ahead [\#232](https://github.com/apache/camel-kafka-connector/pull/232) ([oscerd](https://github.com/oscerd))
- Bump to Camel 3.3.0 [\#231](https://github.com/apache/camel-kafka-connector/pull/231) ([oscerd](https://github.com/oscerd))
- Version bump to Camel 3.3.0 [\#230](https://github.com/apache/camel-kafka-connector/pull/230) ([orpiske](https://github.com/orpiske))
- Connectors doc generation shuld be moved from `core` to `connectors` … [\#229](https://github.com/apache/camel-kafka-connector/pull/229) ([oscerd](https://github.com/oscerd))
- Syslog docs [\#227](https://github.com/apache/camel-kafka-connector/pull/227) ([oscerd](https://github.com/oscerd))
- Fixed con cong autogen [\#222](https://github.com/apache/camel-kafka-connector/pull/222) ([valdar](https://github.com/valdar))
- Remove core from test plugin path [\#218](https://github.com/apache/camel-kafka-connector/pull/218) ([orpiske](https://github.com/orpiske))
- Sink test refactoring [\#216](https://github.com/apache/camel-kafka-connector/pull/216) ([fvaleri](https://github.com/fvaleri))
- Add contentLogLevel task property [\#193](https://github.com/apache/camel-kafka-connector/pull/193) ([fvaleri](https://github.com/fvaleri))

## [camel-kafka-connector-0.2.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.2.0) (2020-05-17)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.1.0...camel-kafka-connector-0.2.0)

**Implemented enhancements:**

- Avoid Thread.sleep in test, use Awaitility FTW [\#186](https://github.com/apache/camel-kafka-connector/issues/186)
- make the topics property consistent between source and sink connectors [\#175](https://github.com/apache/camel-kafka-connector/issues/175)
- Produce an assembly artifact containing all the released artifacts [\#165](https://github.com/apache/camel-kafka-connector/issues/165)
- Create and ad hoc connector for syslog [\#145](https://github.com/apache/camel-kafka-connector/issues/145)
- Take in to account endpoint path options order into connector code generation [\#144](https://github.com/apache/camel-kafka-connector/issues/144)

**Fixed bugs:**

- Ordering of endpoint path options is not taken in account [\#143](https://github.com/apache/camel-kafka-connector/issues/143)

**Closed issues:**

- Add connector dependencies in distribution package [\#203](https://github.com/apache/camel-kafka-connector/issues/203)
- Switch to Camel 3.2.0 [\#199](https://github.com/apache/camel-kafka-connector/issues/199)
- Cannot apply transforms to Telegram Source Connector [\#188](https://github.com/apache/camel-kafka-connector/issues/188)
- Connectors doc: Show up only the priority in the table column [\#182](https://github.com/apache/camel-kafka-connector/issues/182)
- Add an index for connectors in docs [\#169](https://github.com/apache/camel-kafka-connector/issues/169)
- Autogenerate documentation for sink and source connectors [\#167](https://github.com/apache/camel-kafka-connector/issues/167)
- Provided dependencies management [\#158](https://github.com/apache/camel-kafka-connector/issues/158)
- Checkstyle missing unused imports? [\#156](https://github.com/apache/camel-kafka-connector/issues/156)
- Generate a table with supported connectors [\#142](https://github.com/apache/camel-kafka-connector/issues/142)
- Test coverage: springboot autoconfigurations vs kafka-connect configuration format [\#132](https://github.com/apache/camel-kafka-connector/issues/132)
- Release 0.1.0 [\#130](https://github.com/apache/camel-kafka-connector/issues/130)

**Merged pull requests:**

- Syslog connector [\#214](https://github.com/apache/camel-kafka-connector/pull/214) ([valdar](https://github.com/valdar))
- Bump Testcontainers to version 1.14.2 [\#213](https://github.com/apache/camel-kafka-connector/pull/213) ([oscerd](https://github.com/oscerd))
- Removes usage of fixed hostnames in integration tests [\#210](https://github.com/apache/camel-kafka-connector/pull/210) ([orpiske](https://github.com/orpiske))
- Grammar fixes in basic concepts adoc [\#209](https://github.com/apache/camel-kafka-connector/pull/209) ([oscerd](https://github.com/oscerd))
- chore: rename poorly named variable in test code [\#208](https://github.com/apache/camel-kafka-connector/pull/208) ([orpiske](https://github.com/orpiske))
- Re-enable Cassandra test using properties [\#207](https://github.com/apache/camel-kafka-connector/pull/207) ([orpiske](https://github.com/orpiske))
- Bump to Camel 3.2.0 [\#206](https://github.com/apache/camel-kafka-connector/pull/206) ([oscerd](https://github.com/oscerd))
- Improved CamelSourceTaskTest [\#205](https://github.com/apache/camel-kafka-connector/pull/205) ([fvaleri](https://github.com/fvaleri))
- Removed Thread.seep\(...\) in unit tests in order to avoid possible sou… [\#204](https://github.com/apache/camel-kafka-connector/pull/204) ([valdar](https://github.com/valdar))
- Flakey tests [\#200](https://github.com/apache/camel-kafka-connector/pull/200) ([valdar](https://github.com/valdar))
- Generate a table with supported connectors [\#198](https://github.com/apache/camel-kafka-connector/pull/198) ([oscerd](https://github.com/oscerd))
- Make the topics property consistent between source and sink connectors [\#196](https://github.com/apache/camel-kafka-connector/pull/196) ([oscerd](https://github.com/oscerd))
- Produce an assembly artifact containing all the released artifacts [\#195](https://github.com/apache/camel-kafka-connector/pull/195) ([oscerd](https://github.com/oscerd))
- Switched to use RuntimeCatalog.asEndpointUri method to construct the … [\#192](https://github.com/apache/camel-kafka-connector/pull/192) ([valdar](https://github.com/valdar))
- Connectors doc: Show up only the priority in the table column [\#190](https://github.com/apache/camel-kafka-connector/pull/190) ([oscerd](https://github.com/oscerd))
- Added test on different component properties formats fix \#132 [\#187](https://github.com/apache/camel-kafka-connector/pull/187) ([valdar](https://github.com/valdar))
- Code cleanup [\#184](https://github.com/apache/camel-kafka-connector/pull/184) ([fvaleri](https://github.com/fvaleri))
- Lets try to use a shortname of 50 for connectors options [\#181](https://github.com/apache/camel-kafka-connector/pull/181) ([oscerd](https://github.com/oscerd))
- Camel-kafka-generator-maven-plugin: Use the Strings class from toolin… [\#180](https://github.com/apache/camel-kafka-connector/pull/180) ([oscerd](https://github.com/oscerd))
- Introduce the shortName method for option name [\#179](https://github.com/apache/camel-kafka-connector/pull/179) ([oscerd](https://github.com/oscerd))
- Added a little example of AWS-S3 source connector [\#177](https://github.com/apache/camel-kafka-connector/pull/177) ([oscerd](https://github.com/oscerd))
- Docs generation now contains also the number of options available per connectors [\#176](https://github.com/apache/camel-kafka-connector/pull/176) ([oscerd](https://github.com/oscerd))
- Adds a manual test for the Camel Slack sink connector [\#174](https://github.com/apache/camel-kafka-connector/pull/174) ([orpiske](https://github.com/orpiske))
- Special case for coap+tcp and coaps+tcp [\#173](https://github.com/apache/camel-kafka-connector/pull/173) ([oscerd](https://github.com/oscerd))
- Regen docs [\#172](https://github.com/apache/camel-kafka-connector/pull/172) ([oscerd](https://github.com/oscerd))
- Regen docs pages by adding title, so Antora will be happy [\#171](https://github.com/apache/camel-kafka-connector/pull/171) ([oscerd](https://github.com/oscerd))
- Add an index for docs [\#170](https://github.com/apache/camel-kafka-connector/pull/170) ([oscerd](https://github.com/oscerd))
- Docs sink source [\#168](https://github.com/apache/camel-kafka-connector/pull/168) ([oscerd](https://github.com/oscerd))
- Pom fixes [\#161](https://github.com/apache/camel-kafka-connector/pull/161) ([valdar](https://github.com/valdar))
- Added a building section in the docs [\#160](https://github.com/apache/camel-kafka-connector/pull/160) ([oscerd](https://github.com/oscerd))
- Fixes a couple of style violations and warnings on test code [\#157](https://github.com/apache/camel-kafka-connector/pull/157) ([orpiske](https://github.com/orpiske))
- Additional tests for different configuration styles [\#155](https://github.com/apache/camel-kafka-connector/pull/155) ([orpiske](https://github.com/orpiske))
- Release0.1.0 [\#154](https://github.com/apache/camel-kafka-connector/pull/154) ([valdar](https://github.com/valdar))
- Fixed github action issue with never released builts. [\#153](https://github.com/apache/camel-kafka-connector/pull/153) ([valdar](https://github.com/valdar))
- Upgrade testcontainers to version 1.14.1 [\#152](https://github.com/apache/camel-kafka-connector/pull/152) ([oscerd](https://github.com/oscerd))

## [camel-kafka-connector-0.1.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.1.0) (2020-04-25)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/ad2bd4dccdb8ac3b339cd94cd764c8ff169ca993...camel-kafka-connector-0.1.0)

**Implemented enhancements:**

- Migrating to Junit 5 [\#74](https://github.com/apache/camel-kafka-connector/issues/74)
- Replace `confluentinc/cp-kafka` image with an upstream version [\#43](https://github.com/apache/camel-kafka-connector/issues/43)
- Test code cleanups: embedded connect runtime improvements [\#24](https://github.com/apache/camel-kafka-connector/issues/24)
- Add a CI job for PR [\#19](https://github.com/apache/camel-kafka-connector/issues/19)
- Support Map and List as Headers [\#18](https://github.com/apache/camel-kafka-connector/issues/18)
- Find a way to manage dependencies [\#15](https://github.com/apache/camel-kafka-connector/issues/15)
- Unclean shutdown causing lots of warning messages in the logs [\#13](https://github.com/apache/camel-kafka-connector/issues/13)

**Fixed bugs:**

- Unable to initialize REST resources in tests [\#120](https://github.com/apache/camel-kafka-connector/issues/120)
- ERROR - Plugin class loader for connector: was not found. [\#118](https://github.com/apache/camel-kafka-connector/issues/118)
- Flaky test: CamelSinkCassandraITCase [\#67](https://github.com/apache/camel-kafka-connector/issues/67)
- Integrations tests fails if confluentinc/cp-kafka:5.2.1 has not been pulled [\#25](https://github.com/apache/camel-kafka-connector/issues/25)

**Closed issues:**

- Create a documentation index and reflect it on the website [\#136](https://github.com/apache/camel-kafka-connector/issues/136)
- Documentation: Add instructions on how to use the packaged connectors in Kafka Connect [\#134](https://github.com/apache/camel-kafka-connector/issues/134)
- Generate documentation to be integrated with Antora and camel website [\#128](https://github.com/apache/camel-kafka-connector/issues/128)
- Define how to package the connectors  [\#127](https://github.com/apache/camel-kafka-connector/issues/127)
- Upgrade to Kafka 2.4.1 [\#105](https://github.com/apache/camel-kafka-connector/issues/105)
- Not able to add resource file [\#104](https://github.com/apache/camel-kafka-connector/issues/104)
- Not able to run aws s3 source connector  [\#95](https://github.com/apache/camel-kafka-connector/issues/95)
- Bump Kafka to version 2.4.0 [\#69](https://github.com/apache/camel-kafka-connector/issues/69)
- Unstable test: CamelSourceTaskTest.testSourcePollingTimeout [\#55](https://github.com/apache/camel-kafka-connector/issues/55)
- Add a sink and sources examples with camel-cassandraql [\#35](https://github.com/apache/camel-kafka-connector/issues/35)
- Better support for value Schema in the SourceTask [\#32](https://github.com/apache/camel-kafka-connector/issues/32)
- run integration test insided github actions? [\#31](https://github.com/apache/camel-kafka-connector/issues/31)
- INFRA - Turn off mail noise to Camel @dev mailing list [\#30](https://github.com/apache/camel-kafka-connector/issues/30)
- Allow the user to set the key of the SourceRecord explicitly [\#20](https://github.com/apache/camel-kafka-connector/issues/20)
- support camel type converters [\#16](https://github.com/apache/camel-kafka-connector/issues/16)
- The camel-kafka-connector artifacts pulls number of dependencies [\#9](https://github.com/apache/camel-kafka-connector/issues/9)
- Add Release profile [\#7](https://github.com/apache/camel-kafka-connector/issues/7)

**Merged pull requests:**

- Moved from camel-core to camel-core-engine as a dependecnies. [\#140](https://github.com/apache/camel-kafka-connector/pull/140) ([valdar](https://github.com/valdar))
- Added gpg key for valdar. [\#139](https://github.com/apache/camel-kafka-connector/pull/139) ([valdar](https://github.com/valdar))
- Test code fixes for the auto-generated connectors [\#138](https://github.com/apache/camel-kafka-connector/pull/138) ([orpiske](https://github.com/orpiske))
- Misc [\#133](https://github.com/apache/camel-kafka-connector/pull/133) ([valdar](https://github.com/valdar))
- Packaging the connectors as zip and tar.gz [\#131](https://github.com/apache/camel-kafka-connector/pull/131) ([oscerd](https://github.com/oscerd))
- Auto gen [\#129](https://github.com/apache/camel-kafka-connector/pull/129) ([valdar](https://github.com/valdar))
- Upgrade Testcontainers to version 1.14.0 [\#126](https://github.com/apache/camel-kafka-connector/pull/126) ([oscerd](https://github.com/oscerd))
- Upgrade Junit Jupiter to version 5.6.2 [\#125](https://github.com/apache/camel-kafka-connector/pull/125) ([oscerd](https://github.com/oscerd))
- Replaces our own connect runtime implementation with the embedded one from Kafka [\#124](https://github.com/apache/camel-kafka-connector/pull/124) ([orpiske](https://github.com/orpiske))
- Removed unused class HTTPEchoService [\#123](https://github.com/apache/camel-kafka-connector/pull/123) ([orpiske](https://github.com/orpiske))
- Fixes a misplaced log error message flooding the logs w/ invalid errors [\#122](https://github.com/apache/camel-kafka-connector/pull/122) ([orpiske](https://github.com/orpiske))
- Sidebar menu Tidy up name -issue 14567 [\#121](https://github.com/apache/camel-kafka-connector/pull/121) ([rimshach](https://github.com/rimshach))
- Bump Qpid JMS to version 0.50.0 [\#119](https://github.com/apache/camel-kafka-connector/pull/119) ([oscerd](https://github.com/oscerd))
- Improve documentation for the about section [\#116](https://github.com/apache/camel-kafka-connector/pull/116) ([AemieJ](https://github.com/AemieJ))
- Binded itests to test phase to better accommodate github actions disk… [\#115](https://github.com/apache/camel-kafka-connector/pull/115) ([valdar](https://github.com/valdar))
- Auto gen [\#114](https://github.com/apache/camel-kafka-connector/pull/114) ([valdar](https://github.com/valdar))
- Added a Jenkinsfile for JDK11 [\#113](https://github.com/apache/camel-kafka-connector/pull/113) ([oscerd](https://github.com/oscerd))
- Added a Jenkinsfile for JDK8 and being able to deploy automatically [\#112](https://github.com/apache/camel-kafka-connector/pull/112) ([oscerd](https://github.com/oscerd))
- Pointing to ASF Snapshot and use the apache Parent [\#111](https://github.com/apache/camel-kafka-connector/pull/111) ([oscerd](https://github.com/oscerd))
- Bump Junit Jupiter to version 5.6.1 [\#110](https://github.com/apache/camel-kafka-connector/pull/110) ([oscerd](https://github.com/oscerd))
- Bump ActiveMQ to version 5.15.12 [\#109](https://github.com/apache/camel-kafka-connector/pull/109) ([oscerd](https://github.com/oscerd))
- Avoid building all the code for sourcecheck verification [\#108](https://github.com/apache/camel-kafka-connector/pull/108) ([orpiske](https://github.com/orpiske))
- Added support for remote AWS testing [\#107](https://github.com/apache/camel-kafka-connector/pull/107) ([orpiske](https://github.com/orpiske))
- Upgrade Kafka to version 2.4.1 - fixes \#105 [\#106](https://github.com/apache/camel-kafka-connector/pull/106) ([oscerd](https://github.com/oscerd))
- Upgrade Jackson to version 2.10.3 [\#103](https://github.com/apache/camel-kafka-connector/pull/103) ([oscerd](https://github.com/oscerd))
- Auto gen step 2: generated connectors structure and dependencies. [\#102](https://github.com/apache/camel-kafka-connector/pull/102) ([valdar](https://github.com/valdar))
- Ensure that local containers used during tests are properly shutdown after the test is completed [\#101](https://github.com/apache/camel-kafka-connector/pull/101) ([orpiske](https://github.com/orpiske))
- Upgrade test containers [\#100](https://github.com/apache/camel-kafka-connector/pull/100) ([orpiske](https://github.com/orpiske))
- Bump to Camel 3.1.0 [\#99](https://github.com/apache/camel-kafka-connector/pull/99) ([oscerd](https://github.com/oscerd))
- Little updates to docs [\#98](https://github.com/apache/camel-kafka-connector/pull/98) ([oscerd](https://github.com/oscerd))
- Fix missing licenses [\#94](https://github.com/apache/camel-kafka-connector/pull/94) ([orpiske](https://github.com/orpiske))
- Adds support for running tests against external ElasticSearch instances [\#93](https://github.com/apache/camel-kafka-connector/pull/93) ([orpiske](https://github.com/orpiske))
- Adds support for running tests against external Cassandra instances [\#92](https://github.com/apache/camel-kafka-connector/pull/92) ([orpiske](https://github.com/orpiske))
- Small adjustment to sourcechecks. [\#91](https://github.com/apache/camel-kafka-connector/pull/91) ([valdar](https://github.com/valdar))
- Fixed README.adoc links after Antora init. [\#90](https://github.com/apache/camel-kafka-connector/pull/90) ([valdar](https://github.com/valdar))
- fix\(docs\): replace anchor syntax for placeholder [\#89](https://github.com/apache/camel-kafka-connector/pull/89) ([zregvart](https://github.com/zregvart))
- chore\(docs\): cleanup wording and syntax [\#88](https://github.com/apache/camel-kafka-connector/pull/88) ([zregvart](https://github.com/zregvart))
- feat\(docs\): setup Antora [\#87](https://github.com/apache/camel-kafka-connector/pull/87) ([zregvart](https://github.com/zregvart))
- \[SECURITY\] Use HTTPS to resolve dependencies in Maven Build [\#86](https://github.com/apache/camel-kafka-connector/pull/86) ([JLLeitschuh](https://github.com/JLLeitschuh))
- First step for issue \#15 [\#85](https://github.com/apache/camel-kafka-connector/pull/85) ([valdar](https://github.com/valdar))
- Upgrade Qpid JMS client to version 0.48.0 [\#84](https://github.com/apache/camel-kafka-connector/pull/84) ([oscerd](https://github.com/oscerd))
- Added support for using an external JMS broker [\#83](https://github.com/apache/camel-kafka-connector/pull/83) ([orpiske](https://github.com/orpiske))
- Added support for loading test properties from a properties file [\#82](https://github.com/apache/camel-kafka-connector/pull/82) ([orpiske](https://github.com/orpiske))
- Bump TestContainers to version 1.12.5 [\#81](https://github.com/apache/camel-kafka-connector/pull/81) ([oscerd](https://github.com/oscerd))
- Bump to Camel 3.0.1 [\#80](https://github.com/apache/camel-kafka-connector/pull/80) ([oscerd](https://github.com/oscerd))
- Upgrade Junit to version 5.6.0 [\#79](https://github.com/apache/camel-kafka-connector/pull/79) ([oscerd](https://github.com/oscerd))
- Upgrade strimzi images to the latest version [\#78](https://github.com/apache/camel-kafka-connector/pull/78) ([orpiske](https://github.com/orpiske))
- Migrates all the test cases to Junit 5 [\#75](https://github.com/apache/camel-kafka-connector/pull/75) ([orpiske](https://github.com/orpiske))
- Added sourcecheck to github actions, added master push github action … [\#73](https://github.com/apache/camel-kafka-connector/pull/73) ([valdar](https://github.com/valdar))
- Updated integration test image to kafka 2.4 [\#72](https://github.com/apache/camel-kafka-connector/pull/72) ([valdar](https://github.com/valdar))
- Fix issue \#67: Flaky test: CamelSinkCassandraITCase [\#71](https://github.com/apache/camel-kafka-connector/pull/71) ([orpiske](https://github.com/orpiske))
- Bump Kafka to version 2.4.0 [\#70](https://github.com/apache/camel-kafka-connector/pull/70) ([oscerd](https://github.com/oscerd))
- Upgrade ActiveMQ to version 5.15.11 [\#68](https://github.com/apache/camel-kafka-connector/pull/68) ([oscerd](https://github.com/oscerd))
- Added support for testing the Kafka service using Strimzi [\#66](https://github.com/apache/camel-kafka-connector/pull/66) ([valdar](https://github.com/valdar))
- Auto gen [\#65](https://github.com/apache/camel-kafka-connector/pull/65) ([valdar](https://github.com/valdar))
- Add integration test for Cassandra CQL [\#64](https://github.com/apache/camel-kafka-connector/pull/64) ([orpiske](https://github.com/orpiske))
- Bump Jackson to version 2.10.2 [\#63](https://github.com/apache/camel-kafka-connector/pull/63) ([oscerd](https://github.com/oscerd))
- Use artifactId instead of project.name to build colon-less distro paths [\#62](https://github.com/apache/camel-kafka-connector/pull/62) ([ppalaga](https://github.com/ppalaga))
- Bump Junit to version 4.13 [\#61](https://github.com/apache/camel-kafka-connector/pull/61) ([oscerd](https://github.com/oscerd))
- Should use year instead of week year [\#60](https://github.com/apache/camel-kafka-connector/pull/60) ([orpiske](https://github.com/orpiske))
- Property placeholders [\#59](https://github.com/apache/camel-kafka-connector/pull/59) ([oscerd](https://github.com/oscerd))
- Relaxing condition to accomodate some timeout glitches, fix \#55 [\#58](https://github.com/apache/camel-kafka-connector/pull/58) ([valdar](https://github.com/valdar))
- Convert the embeddable Kafka Connect runner to a JUnit rule [\#57](https://github.com/apache/camel-kafka-connector/pull/57) ([orpiske](https://github.com/orpiske))
- Stop removing JMS-related containers after they are built [\#56](https://github.com/apache/camel-kafka-connector/pull/56) ([orpiske](https://github.com/orpiske))
- Upgrade test containers to the latest version [\#54](https://github.com/apache/camel-kafka-connector/pull/54) ([orpiske](https://github.com/orpiske))
- Fixes [\#52](https://github.com/apache/camel-kafka-connector/pull/52) ([valdar](https://github.com/valdar))
- Rearrange date and time [\#51](https://github.com/apache/camel-kafka-connector/pull/51) ([omarsmak](https://github.com/omarsmak))
- Fixed missing license [\#50](https://github.com/apache/camel-kafka-connector/pull/50) ([orpiske](https://github.com/orpiske))
- fix checkstyle violation [\#49](https://github.com/apache/camel-kafka-connector/pull/49) ([omarsmak](https://github.com/omarsmak))
- Add checkstyle profile  [\#48](https://github.com/apache/camel-kafka-connector/pull/48) ([omarsmak](https://github.com/omarsmak))
- CassandraQL sink connector example [\#47](https://github.com/apache/camel-kafka-connector/pull/47) ([oscerd](https://github.com/oscerd))
- Cassandraql source example [\#46](https://github.com/apache/camel-kafka-connector/pull/46) ([oscerd](https://github.com/oscerd))
- Added a gitter badge for our chat [\#45](https://github.com/apache/camel-kafka-connector/pull/45) ([oscerd](https://github.com/oscerd))
- Fix Kafka instance type should read from the property not from the system env [\#42](https://github.com/apache/camel-kafka-connector/pull/42) ([orpiske](https://github.com/orpiske))
- Adds an example configuration for ElasticSearch Index [\#41](https://github.com/apache/camel-kafka-connector/pull/41) ([orpiske](https://github.com/orpiske))
- Allow to configure a source record key from camel message header key [\#39](https://github.com/apache/camel-kafka-connector/pull/39) ([omarsmak](https://github.com/omarsmak))
- Replaces artemis with qpid-dispatch router [\#38](https://github.com/apache/camel-kafka-connector/pull/38) ([orpiske](https://github.com/orpiske))
- Infer the suitable schema in the SourceTask [\#37](https://github.com/apache/camel-kafka-connector/pull/37) ([omarsmak](https://github.com/omarsmak))
- Adds support for ElasticSearch index operation + tests [\#36](https://github.com/apache/camel-kafka-connector/pull/36) ([orpiske](https://github.com/orpiske))
- Support camel type converter [\#34](https://github.com/apache/camel-kafka-connector/pull/34) ([omarsmak](https://github.com/omarsmak))
- Send S3ObjectSerializer I/O error to the LOG instead of stdout [\#33](https://github.com/apache/camel-kafka-connector/pull/33) ([orpiske](https://github.com/orpiske))
- Support using an external Kafka for the tests [\#29](https://github.com/apache/camel-kafka-connector/pull/29) ([orpiske](https://github.com/orpiske))
- Camel-AWS S3 example: Use a Transformation instead of a converter [\#28](https://github.com/apache/camel-kafka-connector/pull/28) ([oscerd](https://github.com/oscerd))
- Map list as headers [\#26](https://github.com/apache/camel-kafka-connector/pull/26) ([oscerd](https://github.com/oscerd))
- Setting up POM as ASF standard [\#14](https://github.com/apache/camel-kafka-connector/pull/14) ([oscerd](https://github.com/oscerd))
- Reduce log default log verbosity [\#12](https://github.com/apache/camel-kafka-connector/pull/12) ([orpiske](https://github.com/orpiske))
- Cleanup the AWS SQS Sink test [\#11](https://github.com/apache/camel-kafka-connector/pull/11) ([orpiske](https://github.com/orpiske))
- Mark camel components as provided dependencies [\#10](https://github.com/apache/camel-kafka-connector/pull/10) ([jerrinot](https://github.com/jerrinot))
- Added release profile for the beginning [\#8](https://github.com/apache/camel-kafka-connector/pull/8) ([oscerd](https://github.com/oscerd))
- Fix Sink File test [\#6](https://github.com/apache/camel-kafka-connector/pull/6) ([orpiske](https://github.com/orpiske))
- chore: update maven to v3.6.3 [\#5](https://github.com/apache/camel-kafka-connector/pull/5) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(build\): set up github actions [\#4](https://github.com/apache/camel-kafka-connector/pull/4) ([lburgazzoli](https://github.com/lburgazzoli))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
