/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.zendesk;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelZendeskSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_ZENDESK_PATH_METHOD_NAME_CONF = "camel.source.path.methodName";
    public static final String CAMEL_SOURCE_ZENDESK_PATH_METHOD_NAME_DOC = "What operation to use One of: [ADD_TAG_TO_ORGANISATIONS] [ADD_TAG_TO_TICKET] [ADD_TAG_TO_TOPICS] [ASSOCIATE_ATTACHMENTS_TO_ARTICLE] [CHANGE_USER_PASSWORD] [CREATE_ARTICLE] [CREATE_ARTICLE_1] [CREATE_ARTICLE_TRANSLATION] [CREATE_AUTOMATION] [CREATE_CATEGORY] [CREATE_CATEGORY_TRANSLATION] [CREATE_COMMENT] [CREATE_DYNAMIC_CONTENT_ITEM] [CREATE_DYNAMIC_CONTENT_ITEM_VARIANT] [CREATE_FORUM] [CREATE_GROUP] [CREATE_GROUP_MEMBERSHIP] [CREATE_GROUP_MEMBERSHIP_1] [CREATE_MACRO] [CREATE_OR_UPDATE_USER] [CREATE_OR_UPDATE_USERS] [CREATE_OR_UPDATE_USERS_1] [CREATE_OR_UPDATE_USERS_ASYNC] [CREATE_ORGANIZATION] [CREATE_ORGANIZATION_MEMBERSHIP] [CREATE_ORGANIZATION_MEMBERSHIP_1] [CREATE_ORGANIZATION_MEMBERSHIPS] [CREATE_ORGANIZATION_MEMBERSHIPS_1] [CREATE_ORGANIZATION_MEMBERSHIPS_ASYNC] [CREATE_ORGANIZATIONS] [CREATE_ORGANIZATIONS_1] [CREATE_ORGANIZATIONS_ASYNC] [CREATE_PERMISSION_GROUP] [CREATE_REQUEST] [CREATE_SATISFACTION_RATING] [CREATE_SATISFACTION_RATING_1] [CREATE_SECTION] [CREATE_SECTION_TRANSLATION] [CREATE_TARGET] [CREATE_TICKET] [CREATE_TICKET_ASYNC] [CREATE_TICKET_FIELD] [CREATE_TICKET_FORM] [CREATE_TICKET_FROM_TWEET] [CREATE_TICKETS] [CREATE_TICKETS_1] [CREATE_TICKETS_ASYNC] [CREATE_TOPIC] [CREATE_TRIGGER] [CREATE_UPLOAD] [CREATE_UPLOAD_1] [CREATE_UPLOAD_2] [CREATE_UPLOAD_ARTICLE] [CREATE_UPLOAD_ARTICLE_1] [CREATE_USER] [CREATE_USER_IDENTITY] [CREATE_USER_IDENTITY_1] [CREATE_USER_SEGMENT] [CREATE_USERS] [CREATE_USERS_1] [CREATE_USERS_ASYNC] [DELETE_ARTICLE] [DELETE_ARTICLE_ATTACHMENT] [DELETE_ARTICLE_ATTACHMENT_1] [DELETE_ATTACHMENT] [DELETE_ATTACHMENT_1] [DELETE_AUTOMATION] [DELETE_CATEGORY] [DELETE_DYNAMIC_CONTENT_ITEM] [DELETE_DYNAMIC_CONTENT_ITEM_VARIANT] [DELETE_FORUM] [DELETE_GROUP] [DELETE_GROUP_1] [DELETE_GROUP_MEMBERSHIP] [DELETE_GROUP_MEMBERSHIP_1] [DELETE_GROUP_MEMBERSHIP_2] [DELETE_GROUP_MEMBERSHIP_3] [DELETE_ORGANIZATION] [DELETE_ORGANIZATION_1] [DELETE_ORGANIZATION_MEMBERSHIP] [DELETE_ORGANIZATION_MEMBERSHIP_1] [DELETE_ORGANIZATION_MEMBERSHIP_2] [DELETE_ORGANIZATION_MEMBERSHIPS] [DELETE_PERMISSION_GROUP] [DELETE_PERMISSION_GROUP_1] [DELETE_SECTION] [DELETE_SUSPENDED_TICKET] [DELETE_SUSPENDED_TICKET_1] [DELETE_TARGET] [DELETE_TICKET] [DELETE_TICKET_1] [DELETE_TICKET_FIELD] [DELETE_TICKET_FIELD_1] [DELETE_TICKETS] [DELETE_TOPIC] [DELETE_TRANSLATION] [DELETE_TRANSLATION_1] [DELETE_TRIGGER] [DELETE_UPLOAD] [DELETE_UPLOAD_1] [DELETE_USER] [DELETE_USER_1] [DELETE_USER_IDENTITY] [DELETE_USER_IDENTITY_1] [DELETE_USER_IDENTITY_2] [DELETE_USER_SEGMENT] [DELETE_USER_SEGMENT_1] [GET_ARTICLE] [GET_ARTICLE_FROM_SEARCH] [GET_ARTICLE_FROM_SEARCH_1] [GET_ARTICLE_SUBSCRIPTIONS] [GET_ARTICLE_SUBSCRIPTIONS_1] [GET_ARTICLE_TRANSLATIONS] [GET_ARTICLES] [GET_ARTICLES_1] [GET_ARTICLES_2] [GET_ARTICLES_3] [GET_ARTICLES_FROM_ALL_LABELS] [GET_ARTICLES_FROM_ANY_LABELS] [GET_ARTICLES_FROM_PAGE] [GET_ARTICLES_INCREMENTALLY] [GET_ASSIGNABLE_GROUP_MEMBERSHIPS] [GET_ASSIGNABLE_GROUP_MEMBERSHIPS_1] [GET_ASSIGNABLE_GROUPS] [GET_ATTACHMENT] [GET_ATTACHMENT_1] [GET_ATTACHMENTS_FROM_ARTICLE] [GET_AUTHENTICATED_USER] [GET_AUTO_COMPLETE_ORGANIZATIONS] [GET_AUTOMATION] [GET_AUTOMATIONS] [GET_BRANDS] [GET_CC_REQUESTS] [GET_CATEGORIES] [GET_CATEGORY] [GET_CATEGORY_TRANSLATIONS] [GET_COMPLIANCE_DELETION_STATUSES] [GET_CURRENT_USER] [GET_CUSTOM_AGENT_ROLES] [GET_DELETED_TICKETS] [GET_DELETED_TICKETS_1] [GET_DYNAMIC_CONTENT_ITEM] [GET_DYNAMIC_CONTENT_ITEM_VARIANT] [GET_DYNAMIC_CONTENT_ITEM_VARIANTS] [GET_DYNAMIC_CONTENT_ITEMS] [GET_FORUM] [GET_FORUMS] [GET_FORUMS_1] [GET_GROUP] [GET_GROUP_MEMBERSHIP] [GET_GROUP_MEMBERSHIP_1] [GET_GROUP_MEMBERSHIP_BY_USER] [GET_GROUP_MEMBERSHIPS] [GET_GROUP_MEMBERSHIPS_1] [GET_GROUP_ORGANIZATION] [GET_GROUP_USERS] [GET_GROUPS] [GET_HELP_CENTER_LOCALES] [GET_HOLIDAYS_FOR_SCHEDULE] [GET_HOLIDAYS_FOR_SCHEDULE_1] [GET_INCREMENTAL_TICKETS_RESULT] [GET_JOB_STATUS] [GET_JOB_STATUS_ASYNC] [GET_JOB_STATUSES] [GET_JOB_STATUSES_ASYNC] [GET_MACRO] [GET_MACROS] [GET_OPEN_REQUESTS] [GET_ORGANIZATION] [GET_ORGANIZATION_FIELDS] [GET_ORGANIZATION_MEMBERSHIP] [GET_ORGANIZATION_MEMBERSHIP_BY_USER] [GET_ORGANIZATION_MEMBERSHIP_FOR_USER] [GET_ORGANIZATION_MEMBERSHIPS] [GET_ORGANIZATION_MEMBERSHIPS_FOR_ORG] [GET_ORGANIZATION_MEMBERSHIPS_FOR_USER] [GET_ORGANIZATION_TICKETS] [GET_ORGANIZATION_USERS] [GET_ORGANIZATIONS] [GET_ORGANIZATIONS_INCREMENTALLY] [GET_PERMISSION_GROUP] [GET_PERMISSION_GROUPS] [GET_RECENT_TICKETS] [GET_REQUEST] [GET_REQUEST_COMMENT] [GET_REQUEST_COMMENT_1] [GET_REQUEST_COMMENT_2] [GET_REQUEST_COMMENTS] [GET_REQUEST_COMMENTS_1] [GET_REQUESTS] [GET_SATISFACTION_RATING] [GET_SATISFACTION_RATINGS] [GET_SCHEDULE] [GET_SCHEDULE_1] [GET_SCHEDULES] [GET_SEARCH_RESULTS] [GET_SEARCH_RESULTS_1] [GET_SEARCH_RESULTS_2] [GET_SEARCH_RESULTS_3] [GET_SEARCH_RESULTS_4] [GET_SECTION] [GET_SECTION_SUBSCRIPTIONS] [GET_SECTION_SUBSCRIPTIONS_1] [GET_SECTION_TRANSLATIONS] [GET_SECTIONS] [GET_SECTIONS_1] [GET_SECTIONS_2] [GET_SOLVED_REQUESTS] [GET_SUSPENDED_TICKETS] [GET_TARGET] [GET_TARGETS] [GET_TICKET] [GET_TICKET_AUDIT] [GET_TICKET_AUDIT_1] [GET_TICKET_AUDIT_2] [GET_TICKET_AUDITS] [GET_TICKET_AUDITS_1] [GET_TICKET_COLLABORATORS] [GET_TICKET_COMMENTS] [GET_TICKET_COMMENTS_1] [GET_TICKET_FIELD] [GET_TICKET_FIELDS] [GET_TICKET_FORM] [GET_TICKET_FORMS] [GET_TICKET_INCIDENTS] [GET_TICKET_METRIC] [GET_TICKET_METRIC_BY_TICKET] [GET_TICKET_METRICS] [GET_TICKETS] [GET_TICKETS_1] [GET_TICKETS_BY_EXTERNAL_ID] [GET_TICKETS_BY_EXTERNAL_ID_1] [GET_TICKETS_FROM_SEARCH] [GET_TICKETS_INCREMENTALLY] [GET_TICKETS_INCREMENTALLY_1] [GET_TOPIC] [GET_TOPICS] [GET_TOPICS_1] [GET_TOPICS_2] [GET_TOPICS_3] [GET_TOPICS_BY_USER] [GET_TRIGGER] [GET_TRIGGERS] [GET_TWITTER_MONITORS] [GET_USER] [GET_USER_CCD_TICKETS] [GET_USER_FIELDS] [GET_USER_IDENTITIES] [GET_USER_IDENTITIES_1] [GET_USER_IDENTITY] [GET_USER_IDENTITY_1] [GET_USER_IDENTITY_2] [GET_USER_RELATED_INFO] [GET_USER_REQUESTED_TICKETS] [GET_USER_REQUESTS] [GET_USER_REQUESTS_1] [GET_USER_SEGMENT] [GET_USER_SEGMENTS] [GET_USER_SEGMENTS_1] [GET_USER_SEGMENTS_APPLICABLE] [GET_USER_SUBSCRIPTIONS] [GET_USER_SUBSCRIPTIONS_1] [GET_USERS] [GET_USERS_BY_ROLE] [GET_USERS_INCREMENTALLY] [IMPORT_TICKET] [IMPORT_TOPIC] [LOOKUP_ORGANIZATIONS_BY_EXTERNAL_ID] [LOOKUP_USER_BY_EMAIL] [LOOKUP_USER_BY_EXTERNAL_ID] [MACROS_SHOW_CHANGES_TO_TICKET] [MACROS_SHOW_TICKET_AFTER_CHANGES] [MAKE_PRIVATE_TICKET_AUDIT] [MAKE_PRIVATE_TICKET_AUDIT_1] [MAKE_PRIVATE_TICKET_AUDIT_2] [MARK_TICKET_AS_SPAM] [MARK_TICKET_AS_SPAM_1] [MERGE_USERS] [NOTIFY_APP] [PERMANENTLY_DELETE_TICKET] [PERMANENTLY_DELETE_TICKET_1] [PERMANENTLY_DELETE_TICKETS] [PERMANENTLY_DELETE_USER] [PERMANENTLY_DELETE_USER_1] [QUEUE_CREATE_TICKET_ASYNC] [REMOVE_TAG_FROM_ORGANISATIONS] [REMOVE_TAG_FROM_TICKET] [REMOVE_TAG_FROM_TOPICS] [REQUEST_VERIFY_USER_IDENTITY] [REQUEST_VERIFY_USER_IDENTITY_1] [REQUEST_VERIFY_USER_IDENTITY_2] [RESET_USER_PASSWORD] [RESET_USER_PASSWORD_1] [SET_GROUP_MEMBERSHIP_AS_DEFAULT] [SET_ORGANIZATION_MEMBERSHIP_AS_DEFAULT] [SET_TAG_ON_ORGANISATIONS] [SET_TAG_ON_TICKET] [SET_TAG_ON_TOPICS] [SET_USER_PRIMARY_IDENTITY] [SET_USER_PRIMARY_IDENTITY_1] [SET_USER_PRIMARY_IDENTITY_2] [SUSPEND_USER] [TRUST_TICKET_AUDIT] [TRUST_TICKET_AUDIT_1] [TRUST_TICKET_AUDIT_2] [UNSUSPEND_USER] [UPDATE_ARTICLE] [UPDATE_ARTICLE_TRANSLATION] [UPDATE_AUTOMATION] [UPDATE_CATEGORY] [UPDATE_CATEGORY_TRANSLATION] [UPDATE_DYNAMIC_CONTENT_ITEM] [UPDATE_DYNAMIC_CONTENT_ITEM_VARIANT] [UPDATE_FORUM] [UPDATE_GROUP] [UPDATE_INSTALLATION] [UPDATE_MACRO] [UPDATE_ORGANIZATION] [UPDATE_ORGANIZATIONS] [UPDATE_ORGANIZATIONS_1] [UPDATE_ORGANIZATIONS_ASYNC] [UPDATE_PERMISSION_GROUP] [UPDATE_REQUEST] [UPDATE_SECTION] [UPDATE_SECTION_TRANSLATION] [UPDATE_TICKET] [UPDATE_TICKET_FIELD] [UPDATE_TICKETS] [UPDATE_TICKETS_1] [UPDATE_TICKETS_ASYNC] [UPDATE_TOPIC] [UPDATE_TRIGGER] [UPDATE_USER] [UPDATE_USER_IDENTITY] [UPDATE_USER_IDENTITY_1] [UPDATE_USER_SEGMENT] [UPDATE_USERS] [UPDATE_USERS_1] [UPDATE_USERS_ASYNC] [VERIFY_USER_IDENTITY] [VERIFY_USER_IDENTITY_1] [VERIFY_USER_IDENTITY_2]";
    public static final String CAMEL_SOURCE_ZENDESK_PATH_METHOD_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_IN_BODY_CONF = "camel.source.endpoint.inBody";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_IN_BODY_DOC = "Sets the name of a parameter to be passed in the exchange In Body";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_IN_BODY_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_SERVER_URL_CONF = "camel.source.endpoint.serverUrl";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_SERVER_URL_DOC = "The server URL to connect.";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_SERVER_URL_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_ZENDESK_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_CONF = "camel.source.endpoint.sendEmptyMessageWhenIdle";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_DOC = "If the polling consumer did not poll any files, you can enable this option to send an empty message (no body) instead.";
    public static final Boolean CAMEL_SOURCE_ZENDESK_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_DEFAULT = false;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_POLL_STRATEGY_CONF = "camel.source.endpoint.pollStrategy";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_POLL_STRATEGY_DOC = "A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing you to provide your custom implementation to control error handling usually occurred during the poll operation before an Exchange have been created and being routed in Camel.";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_POLL_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_ERROR_THRESHOLD_CONF = "camel.source.endpoint.backoffErrorThreshold";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_ERROR_THRESHOLD_DOC = "The number of subsequent error polls (failed due some error) that should happen before the backoffMultipler should kick-in.";
    public static final Integer CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_ERROR_THRESHOLD_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_IDLE_THRESHOLD_CONF = "camel.source.endpoint.backoffIdleThreshold";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_IDLE_THRESHOLD_DOC = "The number of subsequent idle polls that should happen before the backoffMultipler should kick-in.";
    public static final Integer CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_IDLE_THRESHOLD_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_MULTIPLIER_CONF = "camel.source.endpoint.backoffMultiplier";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_MULTIPLIER_DOC = "To let the scheduled polling consumer backoff if there has been a number of subsequent idles/errors in a row. The multiplier is then the number of polls that will be skipped before the next actual attempt is happening again. When this option is in use then backoffIdleThreshold and/or backoffErrorThreshold must also be configured.";
    public static final Integer CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_MULTIPLIER_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_DELAY_CONF = "camel.source.endpoint.delay";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_DELAY_DOC = "Milliseconds before the next poll.";
    public static final Long CAMEL_SOURCE_ZENDESK_ENDPOINT_DELAY_DEFAULT = 500L;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_GREEDY_CONF = "camel.source.endpoint.greedy";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_GREEDY_DOC = "If greedy is enabled, then the ScheduledPollConsumer will run immediately again, if the previous run polled 1 or more messages.";
    public static final Boolean CAMEL_SOURCE_ZENDESK_ENDPOINT_GREEDY_DEFAULT = false;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_INITIAL_DELAY_CONF = "camel.source.endpoint.initialDelay";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_INITIAL_DELAY_DOC = "Milliseconds before the first poll starts.";
    public static final Long CAMEL_SOURCE_ZENDESK_ENDPOINT_INITIAL_DELAY_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_REPEAT_COUNT_CONF = "camel.source.endpoint.repeatCount";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_REPEAT_COUNT_DOC = "Specifies a maximum limit of number of fires. So if you set it to 1, the scheduler will only fire once. If you set it to 5, it will only fire five times. A value of zero or negative means fire forever.";
    public static final Long CAMEL_SOURCE_ZENDESK_ENDPOINT_REPEAT_COUNT_DEFAULT = 0L;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_RUN_LOGGING_LEVEL_CONF = "camel.source.endpoint.runLoggingLevel";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_RUN_LOGGING_LEVEL_DOC = "The consumer logs a start/complete log line when it polls. This option allows you to configure the logging level for that. One of: [TRACE] [DEBUG] [INFO] [WARN] [ERROR] [OFF]";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_RUN_LOGGING_LEVEL_DEFAULT = "TRACE";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_CONF = "camel.source.endpoint.scheduledExecutorService";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_DOC = "Allows for configuring a custom/shared thread pool to use for the consumer. By default each consumer has its own single threaded thread pool.";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULER_CONF = "camel.source.endpoint.scheduler";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULER_DOC = "To use a cron scheduler from either camel-spring or camel-quartz component. Use value spring or quartz for built in scheduler";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULER_DEFAULT = "none";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULER_PROPERTIES_CONF = "camel.source.endpoint.schedulerProperties";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULER_PROPERTIES_DOC = "To configure additional properties when using a custom scheduler or any of the Quartz, Spring based scheduler.";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULER_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_START_SCHEDULER_CONF = "camel.source.endpoint.startScheduler";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_START_SCHEDULER_DOC = "Whether the scheduler should be auto started.";
    public static final Boolean CAMEL_SOURCE_ZENDESK_ENDPOINT_START_SCHEDULER_DEFAULT = true;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_TIME_UNIT_CONF = "camel.source.endpoint.timeUnit";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_TIME_UNIT_DOC = "Time unit for initialDelay and delay options. One of: [NANOSECONDS] [MICROSECONDS] [MILLISECONDS] [SECONDS] [MINUTES] [HOURS] [DAYS]";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_TIME_UNIT_DEFAULT = "MILLISECONDS";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_USE_FIXED_DELAY_CONF = "camel.source.endpoint.useFixedDelay";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_USE_FIXED_DELAY_DOC = "Controls if fixed delay or fixed rate is used. See ScheduledExecutorService in JDK for details.";
    public static final Boolean CAMEL_SOURCE_ZENDESK_ENDPOINT_USE_FIXED_DELAY_DEFAULT = true;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_OAUTH_TOKEN_CONF = "camel.source.endpoint.oauthToken";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_OAUTH_TOKEN_DOC = "The OAuth token.";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_OAUTH_TOKEN_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_PASSWORD_CONF = "camel.source.endpoint.password";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_PASSWORD_DOC = "The password.";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_TOKEN_CONF = "camel.source.endpoint.token";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_TOKEN_DOC = "The security token.";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_TOKEN_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_USERNAME_CONF = "camel.source.endpoint.username";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_USERNAME_DOC = "The user name.";
    public static final String CAMEL_SOURCE_ZENDESK_ENDPOINT_USERNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_SERVER_URL_CONF = "camel.component.zendesk.serverUrl";
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_SERVER_URL_DOC = "The server URL to connect.";
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_SERVER_URL_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.zendesk.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_ZENDESK_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.zendesk.autowiredEnabled";
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_ZENDESK_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_CONFIGURATION_CONF = "camel.component.zendesk.configuration";
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_CONFIGURATION_DOC = "Component configuration";
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_ZENDESK_CONF = "camel.component.zendesk.zendesk";
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_ZENDESK_DOC = "To use a shared Zendesk instance.";
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_ZENDESK_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_OAUTH_TOKEN_CONF = "camel.component.zendesk.oauthToken";
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_OAUTH_TOKEN_DOC = "The OAuth token.";
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_OAUTH_TOKEN_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_PASSWORD_CONF = "camel.component.zendesk.password";
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_PASSWORD_DOC = "The password.";
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_TOKEN_CONF = "camel.component.zendesk.token";
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_TOKEN_DOC = "The security token.";
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_TOKEN_DEFAULT = null;
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_USERNAME_CONF = "camel.component.zendesk.username";
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_USERNAME_DOC = "The user name.";
    public static final String CAMEL_SOURCE_ZENDESK_COMPONENT_USERNAME_DEFAULT = null;

    public CamelZendeskSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelZendeskSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_ZENDESK_PATH_METHOD_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ZENDESK_PATH_METHOD_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_ZENDESK_PATH_METHOD_NAME_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_IN_BODY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ZENDESK_ENDPOINT_IN_BODY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_IN_BODY_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_SERVER_URL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ZENDESK_ENDPOINT_SERVER_URL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_SERVER_URL_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ZENDESK_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ZENDESK_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ZENDESK_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ZENDESK_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_POLL_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ZENDESK_ENDPOINT_POLL_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_POLL_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_ERROR_THRESHOLD_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_ERROR_THRESHOLD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_ERROR_THRESHOLD_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_IDLE_THRESHOLD_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_IDLE_THRESHOLD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_IDLE_THRESHOLD_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_MULTIPLIER_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_MULTIPLIER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_BACKOFF_MULTIPLIER_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_DELAY_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_ZENDESK_ENDPOINT_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_DELAY_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_GREEDY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ZENDESK_ENDPOINT_GREEDY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_GREEDY_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_INITIAL_DELAY_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_ZENDESK_ENDPOINT_INITIAL_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_INITIAL_DELAY_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_REPEAT_COUNT_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_ZENDESK_ENDPOINT_REPEAT_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_REPEAT_COUNT_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_RUN_LOGGING_LEVEL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ZENDESK_ENDPOINT_RUN_LOGGING_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_RUN_LOGGING_LEVEL_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULER_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULER_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULER_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_SCHEDULER_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_START_SCHEDULER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ZENDESK_ENDPOINT_START_SCHEDULER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_START_SCHEDULER_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_TIME_UNIT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ZENDESK_ENDPOINT_TIME_UNIT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_TIME_UNIT_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_USE_FIXED_DELAY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ZENDESK_ENDPOINT_USE_FIXED_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_USE_FIXED_DELAY_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_OAUTH_TOKEN_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_ZENDESK_ENDPOINT_OAUTH_TOKEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_OAUTH_TOKEN_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_ZENDESK_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_TOKEN_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_ZENDESK_ENDPOINT_TOKEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_TOKEN_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_ENDPOINT_USERNAME_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_ZENDESK_ENDPOINT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_ENDPOINT_USERNAME_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_COMPONENT_SERVER_URL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ZENDESK_COMPONENT_SERVER_URL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_COMPONENT_SERVER_URL_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ZENDESK_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_ZENDESK_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ZENDESK_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_COMPONENT_ZENDESK_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_ZENDESK_COMPONENT_ZENDESK_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_COMPONENT_ZENDESK_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_COMPONENT_OAUTH_TOKEN_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_ZENDESK_COMPONENT_OAUTH_TOKEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_COMPONENT_OAUTH_TOKEN_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_COMPONENT_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_ZENDESK_COMPONENT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_COMPONENT_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_COMPONENT_TOKEN_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_ZENDESK_COMPONENT_TOKEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_COMPONENT_TOKEN_DOC);
        conf.define(CAMEL_SOURCE_ZENDESK_COMPONENT_USERNAME_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_ZENDESK_COMPONENT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_ZENDESK_COMPONENT_USERNAME_DOC);
        return conf;
    }
}