/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.weka;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelWekaSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_WEKA_PATH_COMMAND_CONF = "camel.sink.path.command";
    public static final String CAMEL_SINK_WEKA_PATH_COMMAND_DOC = "The command to use. One of: [filter] [model] [read] [write] [push] [pop] [version]";
    public static final String CAMEL_SINK_WEKA_PATH_COMMAND_DEFAULT = null;
    public static final String CAMEL_SINK_WEKA_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_WEKA_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_WEKA_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_WEKA_ENDPOINT_APPLY_CONF = "camel.sink.endpoint.apply";
    public static final String CAMEL_SINK_WEKA_ENDPOINT_APPLY_DOC = "The filter spec (i.e. Name Options)";
    public static final String CAMEL_SINK_WEKA_ENDPOINT_APPLY_DEFAULT = null;
    public static final String CAMEL_SINK_WEKA_ENDPOINT_BUILD_CONF = "camel.sink.endpoint.build";
    public static final String CAMEL_SINK_WEKA_ENDPOINT_BUILD_DOC = "The classifier spec (i.e. Name Options)";
    public static final String CAMEL_SINK_WEKA_ENDPOINT_BUILD_DEFAULT = null;
    public static final String CAMEL_SINK_WEKA_ENDPOINT_DSNAME_CONF = "camel.sink.endpoint.dsname";
    public static final String CAMEL_SINK_WEKA_ENDPOINT_DSNAME_DOC = "The named dataset to train the classifier with";
    public static final String CAMEL_SINK_WEKA_ENDPOINT_DSNAME_DEFAULT = null;
    public static final String CAMEL_SINK_WEKA_ENDPOINT_FOLDS_CONF = "camel.sink.endpoint.folds";
    public static final String CAMEL_SINK_WEKA_ENDPOINT_FOLDS_DOC = "Number of folds to use for cross-validation";
    public static final Integer CAMEL_SINK_WEKA_ENDPOINT_FOLDS_DEFAULT = 10;
    public static final String CAMEL_SINK_WEKA_ENDPOINT_LOAD_FROM_CONF = "camel.sink.endpoint.loadFrom";
    public static final String CAMEL_SINK_WEKA_ENDPOINT_LOAD_FROM_DOC = "Path to load the model from";
    public static final String CAMEL_SINK_WEKA_ENDPOINT_LOAD_FROM_DEFAULT = null;
    public static final String CAMEL_SINK_WEKA_ENDPOINT_SAVE_TO_CONF = "camel.sink.endpoint.saveTo";
    public static final String CAMEL_SINK_WEKA_ENDPOINT_SAVE_TO_DOC = "Path to save the model to";
    public static final String CAMEL_SINK_WEKA_ENDPOINT_SAVE_TO_DEFAULT = null;
    public static final String CAMEL_SINK_WEKA_ENDPOINT_SEED_CONF = "camel.sink.endpoint.seed";
    public static final String CAMEL_SINK_WEKA_ENDPOINT_SEED_DOC = "An optional seed for the randomizer";
    public static final Integer CAMEL_SINK_WEKA_ENDPOINT_SEED_DEFAULT = 1;
    public static final String CAMEL_SINK_WEKA_ENDPOINT_XVAL_CONF = "camel.sink.endpoint.xval";
    public static final String CAMEL_SINK_WEKA_ENDPOINT_XVAL_DOC = "Flag on whether to use cross-validation with the current dataset";
    public static final Boolean CAMEL_SINK_WEKA_ENDPOINT_XVAL_DEFAULT = false;
    public static final String CAMEL_SINK_WEKA_ENDPOINT_PATH_CONF = "camel.sink.endpoint.path";
    public static final String CAMEL_SINK_WEKA_ENDPOINT_PATH_DOC = "An in/out path for the read/write commands";
    public static final String CAMEL_SINK_WEKA_ENDPOINT_PATH_DEFAULT = null;
    public static final String CAMEL_SINK_WEKA_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.weka.lazyStartProducer";
    public static final String CAMEL_SINK_WEKA_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_WEKA_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_WEKA_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.weka.autowiredEnabled";
    public static final String CAMEL_SINK_WEKA_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_WEKA_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;

    public CamelWekaSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelWekaSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_WEKA_PATH_COMMAND_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEKA_PATH_COMMAND_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_WEKA_PATH_COMMAND_DOC);
        conf.define(CAMEL_SINK_WEKA_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_WEKA_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEKA_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_WEKA_ENDPOINT_APPLY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEKA_ENDPOINT_APPLY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEKA_ENDPOINT_APPLY_DOC);
        conf.define(CAMEL_SINK_WEKA_ENDPOINT_BUILD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEKA_ENDPOINT_BUILD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEKA_ENDPOINT_BUILD_DOC);
        conf.define(CAMEL_SINK_WEKA_ENDPOINT_DSNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEKA_ENDPOINT_DSNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEKA_ENDPOINT_DSNAME_DOC);
        conf.define(CAMEL_SINK_WEKA_ENDPOINT_FOLDS_CONF, ConfigDef.Type.INT, CAMEL_SINK_WEKA_ENDPOINT_FOLDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEKA_ENDPOINT_FOLDS_DOC);
        conf.define(CAMEL_SINK_WEKA_ENDPOINT_LOAD_FROM_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEKA_ENDPOINT_LOAD_FROM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEKA_ENDPOINT_LOAD_FROM_DOC);
        conf.define(CAMEL_SINK_WEKA_ENDPOINT_SAVE_TO_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEKA_ENDPOINT_SAVE_TO_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEKA_ENDPOINT_SAVE_TO_DOC);
        conf.define(CAMEL_SINK_WEKA_ENDPOINT_SEED_CONF, ConfigDef.Type.INT, CAMEL_SINK_WEKA_ENDPOINT_SEED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEKA_ENDPOINT_SEED_DOC);
        conf.define(CAMEL_SINK_WEKA_ENDPOINT_XVAL_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_WEKA_ENDPOINT_XVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEKA_ENDPOINT_XVAL_DOC);
        conf.define(CAMEL_SINK_WEKA_ENDPOINT_PATH_CONF, ConfigDef.Type.STRING, CAMEL_SINK_WEKA_ENDPOINT_PATH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEKA_ENDPOINT_PATH_DOC);
        conf.define(CAMEL_SINK_WEKA_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_WEKA_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEKA_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_WEKA_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_WEKA_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_WEKA_COMPONENT_AUTOWIRED_ENABLED_DOC);
        return conf;
    }
}