/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.optaplanner;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelOptaplannerSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_OPTAPLANNER_PATH_CONFIG_FILE_CONF = "camel.sink.path.configFile";
    public static final String CAMEL_SINK_OPTAPLANNER_PATH_CONFIG_FILE_DOC = "Specifies the location to the solver file. If useSolverManager=FALSE, Camel uses this file and create the Solver. If useSolverManager=TRUE and SolverManager is set in the header {OptaPlannerConstants.SOLVER_MANAGER} : this file is ignored by Camel usage of SolverManager. SolverManager can be injected by DI in Quarkus or Spring.";
    public static final String CAMEL_SINK_OPTAPLANNER_PATH_CONFIG_FILE_DEFAULT = null;
    public static final String CAMEL_SINK_OPTAPLANNER_ENDPOINT_PROBLEM_ID_CONF = "camel.sink.endpoint.problemId";
    public static final String CAMEL_SINK_OPTAPLANNER_ENDPOINT_PROBLEM_ID_DOC = "In case of using SolverManager : the problem id";
    public static final String CAMEL_SINK_OPTAPLANNER_ENDPOINT_PROBLEM_ID_DEFAULT = "1L";
    public static final String CAMEL_SINK_OPTAPLANNER_ENDPOINT_SOLVER_ID_CONF = "camel.sink.endpoint.solverId";
    public static final String CAMEL_SINK_OPTAPLANNER_ENDPOINT_SOLVER_ID_DOC = "Specifies the solverId to user for the solver instance key";
    public static final String CAMEL_SINK_OPTAPLANNER_ENDPOINT_SOLVER_ID_DEFAULT = "DEFAULT_SOLVER";
    public static final String CAMEL_SINK_OPTAPLANNER_ENDPOINT_USE_SOLVER_MANAGER_CONF = "camel.sink.endpoint.useSolverManager";
    public static final String CAMEL_SINK_OPTAPLANNER_ENDPOINT_USE_SOLVER_MANAGER_DOC = "use SolverManager instead of XML file config. Use this mode on Quarkus app.";
    public static final Boolean CAMEL_SINK_OPTAPLANNER_ENDPOINT_USE_SOLVER_MANAGER_DEFAULT = false;
    public static final String CAMEL_SINK_OPTAPLANNER_ENDPOINT_ASYNC_CONF = "camel.sink.endpoint.async";
    public static final String CAMEL_SINK_OPTAPLANNER_ENDPOINT_ASYNC_DOC = "Specifies to perform operations in async mode";
    public static final Boolean CAMEL_SINK_OPTAPLANNER_ENDPOINT_ASYNC_DEFAULT = false;
    public static final String CAMEL_SINK_OPTAPLANNER_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_OPTAPLANNER_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_OPTAPLANNER_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_OPTAPLANNER_ENDPOINT_THREAD_POOL_SIZE_CONF = "camel.sink.endpoint.threadPoolSize";
    public static final String CAMEL_SINK_OPTAPLANNER_ENDPOINT_THREAD_POOL_SIZE_DOC = "Specifies the thread pool size to use when async is true";
    public static final Integer CAMEL_SINK_OPTAPLANNER_ENDPOINT_THREAD_POOL_SIZE_DEFAULT = 10;
    public static final String CAMEL_SINK_OPTAPLANNER_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.optaplanner.lazyStartProducer";
    public static final String CAMEL_SINK_OPTAPLANNER_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_OPTAPLANNER_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_OPTAPLANNER_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.optaplanner.autowiredEnabled";
    public static final String CAMEL_SINK_OPTAPLANNER_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_OPTAPLANNER_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;

    public CamelOptaplannerSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelOptaplannerSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_OPTAPLANNER_PATH_CONFIG_FILE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_OPTAPLANNER_PATH_CONFIG_FILE_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_OPTAPLANNER_PATH_CONFIG_FILE_DOC);
        conf.define(CAMEL_SINK_OPTAPLANNER_ENDPOINT_PROBLEM_ID_CONF, ConfigDef.Type.STRING, CAMEL_SINK_OPTAPLANNER_ENDPOINT_PROBLEM_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_OPTAPLANNER_ENDPOINT_PROBLEM_ID_DOC);
        conf.define(CAMEL_SINK_OPTAPLANNER_ENDPOINT_SOLVER_ID_CONF, ConfigDef.Type.STRING, CAMEL_SINK_OPTAPLANNER_ENDPOINT_SOLVER_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_OPTAPLANNER_ENDPOINT_SOLVER_ID_DOC);
        conf.define(CAMEL_SINK_OPTAPLANNER_ENDPOINT_USE_SOLVER_MANAGER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_OPTAPLANNER_ENDPOINT_USE_SOLVER_MANAGER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_OPTAPLANNER_ENDPOINT_USE_SOLVER_MANAGER_DOC);
        conf.define(CAMEL_SINK_OPTAPLANNER_ENDPOINT_ASYNC_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_OPTAPLANNER_ENDPOINT_ASYNC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_OPTAPLANNER_ENDPOINT_ASYNC_DOC);
        conf.define(CAMEL_SINK_OPTAPLANNER_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_OPTAPLANNER_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_OPTAPLANNER_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_OPTAPLANNER_ENDPOINT_THREAD_POOL_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SINK_OPTAPLANNER_ENDPOINT_THREAD_POOL_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_OPTAPLANNER_ENDPOINT_THREAD_POOL_SIZE_DOC);
        conf.define(CAMEL_SINK_OPTAPLANNER_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_OPTAPLANNER_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_OPTAPLANNER_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_OPTAPLANNER_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_OPTAPLANNER_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_OPTAPLANNER_COMPONENT_AUTOWIRED_ENABLED_DOC);
        return conf;
    }
}