/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.googlestorage;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelGooglestorageSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_GOOGLESTORAGE_PATH_BUCKET_NAME_CONF = "camel.sink.path.bucketName";
    public static final String CAMEL_SINK_GOOGLESTORAGE_PATH_BUCKET_NAME_DOC = "Bucket name or ARN";
    public static final String CAMEL_SINK_GOOGLESTORAGE_PATH_BUCKET_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_AUTO_CREATE_BUCKET_CONF = "camel.sink.endpoint.autoCreateBucket";
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_AUTO_CREATE_BUCKET_DOC = "Setting the autocreation of the bucket bucketName.";
    public static final Boolean CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_AUTO_CREATE_BUCKET_DEFAULT = true;
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_SERVICE_ACCOUNT_KEY_CONF = "camel.sink.endpoint.serviceAccountKey";
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_SERVICE_ACCOUNT_KEY_DOC = "The Service account key that can be used as credentials for the Storage client. It can be loaded by default from classpath, but you can prefix with classpath:, file:, or http: to load the resource from different systems.";
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_SERVICE_ACCOUNT_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_CLASS_CONF = "camel.sink.endpoint.storageClass";
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_CLASS_DOC = "The Cloud Storage class to use when creating the new buckets";
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_CLASS_DEFAULT = "STANDARD";
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_CLIENT_CONF = "camel.sink.endpoint.storageClient";
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_CLIENT_DOC = "The storage client";
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_CLIENT_DEFAULT = null;
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_LOCATION_CONF = "camel.sink.endpoint.storageLocation";
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_LOCATION_DOC = "The Cloud Storage location to use when creating the new buckets";
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_LOCATION_DEFAULT = "US-EAST1";
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_OBJECT_NAME_CONF = "camel.sink.endpoint.objectName";
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_OBJECT_NAME_DOC = "The Object name inside the bucket";
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_OBJECT_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_OPERATION_CONF = "camel.sink.endpoint.operation";
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_OPERATION_DOC = "Set the operation for the producer One of: [copyObject] [listObjects] [deleteObject] [deleteBucket] [listBuckets] [getObject] [createDownloadLink]";
    public static final String CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_OPERATION_DEFAULT = null;
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_AUTO_CREATE_BUCKET_CONF = "camel.component.google-storage.autoCreateBucket";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_AUTO_CREATE_BUCKET_DOC = "Setting the autocreation of the bucket bucketName.";
    public static final Boolean CAMEL_SINK_GOOGLESTORAGE_COMPONENT_AUTO_CREATE_BUCKET_DEFAULT = true;
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_CONFIGURATION_CONF = "camel.component.google-storage.configuration";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_CONFIGURATION_DOC = "The component configuration";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_SERVICE_ACCOUNT_KEY_CONF = "camel.component.google-storage.serviceAccountKey";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_SERVICE_ACCOUNT_KEY_DOC = "The Service account key that can be used as credentials for the Storage client. It can be loaded by default from classpath, but you can prefix with classpath:, file:, or http: to load the resource from different systems.";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_SERVICE_ACCOUNT_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_CLASS_CONF = "camel.component.google-storage.storageClass";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_CLASS_DOC = "The Cloud Storage class to use when creating the new buckets";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_CLASS_DEFAULT = "STANDARD";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_CLIENT_CONF = "camel.component.google-storage.storageClient";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_CLIENT_DOC = "The storage client";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_CLIENT_DEFAULT = null;
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_LOCATION_CONF = "camel.component.google-storage.storageLocation";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_LOCATION_DOC = "The Cloud Storage location to use when creating the new buckets";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_LOCATION_DEFAULT = "US-EAST1";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.google-storage.lazyStartProducer";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_GOOGLESTORAGE_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_OBJECT_NAME_CONF = "camel.component.google-storage.objectName";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_OBJECT_NAME_DOC = "The Object name inside the bucket";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_OBJECT_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_OPERATION_CONF = "camel.component.google-storage.operation";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_OPERATION_DOC = "Set the operation for the producer One of: [copyObject] [listObjects] [deleteObject] [deleteBucket] [listBuckets] [getObject] [createDownloadLink]";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_OPERATION_DEFAULT = null;
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.google-storage.autowiredEnabled";
    public static final String CAMEL_SINK_GOOGLESTORAGE_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_GOOGLESTORAGE_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;

    public CamelGooglestorageSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelGooglestorageSinkConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_GOOGLESTORAGE_PATH_BUCKET_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESTORAGE_PATH_BUCKET_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_GOOGLESTORAGE_PATH_BUCKET_NAME_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_AUTO_CREATE_BUCKET_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_AUTO_CREATE_BUCKET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_AUTO_CREATE_BUCKET_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_SERVICE_ACCOUNT_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_SERVICE_ACCOUNT_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_SERVICE_ACCOUNT_KEY_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_CLASS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_CLASS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_CLASS_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_CLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_CLIENT_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_LOCATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_LOCATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_STORAGE_LOCATION_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_OBJECT_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_OBJECT_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_OBJECT_NAME_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_OPERATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_ENDPOINT_OPERATION_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_COMPONENT_AUTO_CREATE_BUCKET_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_AUTO_CREATE_BUCKET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_AUTO_CREATE_BUCKET_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_COMPONENT_SERVICE_ACCOUNT_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_SERVICE_ACCOUNT_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_SERVICE_ACCOUNT_KEY_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_CLASS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_CLASS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_CLASS_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_CLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_CLIENT_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_LOCATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_LOCATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_STORAGE_LOCATION_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_COMPONENT_OBJECT_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_OBJECT_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_OBJECT_NAME_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_COMPONENT_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_OPERATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_OPERATION_DOC);
        conf.define(CAMEL_SINK_GOOGLESTORAGE_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GOOGLESTORAGE_COMPONENT_AUTOWIRED_ENABLED_DOC);
        return conf;
    }
}