/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.dropbox;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelDropboxSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_DROPBOX_PATH_OPERATION_CONF = "camel.source.path.operation";
    public static final String CAMEL_SOURCE_DROPBOX_PATH_OPERATION_DOC = "The specific action (typically is a CRUD action) to perform on Dropbox remote folder. One of: [put] [del] [search] [get] [move]";
    public static final String CAMEL_SOURCE_DROPBOX_PATH_OPERATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_ACCESS_TOKEN_CONF = "camel.source.endpoint.accessToken";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_ACCESS_TOKEN_DOC = "The access token to make API requests for a specific Dropbox user";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_ACCESS_TOKEN_DEFAULT = null;
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_CLIENT_CONF = "camel.source.endpoint.client";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_CLIENT_DOC = "To use an existing DbxClient instance as DropBox client.";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_CLIENT_DEFAULT = null;
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_CLIENT_IDENTIFIER_CONF = "camel.source.endpoint.clientIdentifier";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_CLIENT_IDENTIFIER_DOC = "Name of the app registered to make API requests";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_CLIENT_IDENTIFIER_DEFAULT = null;
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_LOCAL_PATH_CONF = "camel.source.endpoint.localPath";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_LOCAL_PATH_DOC = "Optional folder or file to upload on Dropbox from the local filesystem. If this option has not been configured then the message body is used as the content to upload.";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_LOCAL_PATH_DEFAULT = null;
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_NEW_REMOTE_PATH_CONF = "camel.source.endpoint.newRemotePath";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_NEW_REMOTE_PATH_DOC = "Destination file or folder";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_NEW_REMOTE_PATH_DEFAULT = null;
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_QUERY_CONF = "camel.source.endpoint.query";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_QUERY_DOC = "A space-separated list of sub-strings to search for. A file matches only if it contains all the sub-strings. If this option is not set, all files will be matched.";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_QUERY_DEFAULT = null;
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_REMOTE_PATH_CONF = "camel.source.endpoint.remotePath";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_REMOTE_PATH_DOC = "Original file or folder to move";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_REMOTE_PATH_DEFAULT = null;
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_UPLOAD_MODE_CONF = "camel.source.endpoint.uploadMode";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_UPLOAD_MODE_DOC = "Which mode to upload. in case of add the new file will be renamed if a file with the same name already exists on dropbox. in case of force if a file with the same name already exists on dropbox, this will be overwritten. One of: [add] [force]";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_UPLOAD_MODE_DEFAULT = null;
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_DROPBOX_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_DROPBOX_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_DROPBOX_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.dropbox.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_DROPBOX_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_DROPBOX_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_DROPBOX_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.dropbox.autowiredEnabled";
    public static final String CAMEL_SOURCE_DROPBOX_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_DROPBOX_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;

    public CamelDropboxSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelDropboxSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_DROPBOX_PATH_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DROPBOX_PATH_OPERATION_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_DROPBOX_PATH_OPERATION_DOC);
        conf.define(CAMEL_SOURCE_DROPBOX_ENDPOINT_ACCESS_TOKEN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DROPBOX_ENDPOINT_ACCESS_TOKEN_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_DROPBOX_ENDPOINT_ACCESS_TOKEN_DOC);
        conf.define(CAMEL_SOURCE_DROPBOX_ENDPOINT_CLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DROPBOX_ENDPOINT_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DROPBOX_ENDPOINT_CLIENT_DOC);
        conf.define(CAMEL_SOURCE_DROPBOX_ENDPOINT_CLIENT_IDENTIFIER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DROPBOX_ENDPOINT_CLIENT_IDENTIFIER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DROPBOX_ENDPOINT_CLIENT_IDENTIFIER_DOC);
        conf.define(CAMEL_SOURCE_DROPBOX_ENDPOINT_LOCAL_PATH_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DROPBOX_ENDPOINT_LOCAL_PATH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DROPBOX_ENDPOINT_LOCAL_PATH_DOC);
        conf.define(CAMEL_SOURCE_DROPBOX_ENDPOINT_NEW_REMOTE_PATH_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DROPBOX_ENDPOINT_NEW_REMOTE_PATH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DROPBOX_ENDPOINT_NEW_REMOTE_PATH_DOC);
        conf.define(CAMEL_SOURCE_DROPBOX_ENDPOINT_QUERY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DROPBOX_ENDPOINT_QUERY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DROPBOX_ENDPOINT_QUERY_DOC);
        conf.define(CAMEL_SOURCE_DROPBOX_ENDPOINT_REMOTE_PATH_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DROPBOX_ENDPOINT_REMOTE_PATH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DROPBOX_ENDPOINT_REMOTE_PATH_DOC);
        conf.define(CAMEL_SOURCE_DROPBOX_ENDPOINT_UPLOAD_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DROPBOX_ENDPOINT_UPLOAD_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DROPBOX_ENDPOINT_UPLOAD_MODE_DOC);
        conf.define(CAMEL_SOURCE_DROPBOX_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DROPBOX_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DROPBOX_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DROPBOX_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DROPBOX_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DROPBOX_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DROPBOX_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DROPBOX_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DROPBOX_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_DROPBOX_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DROPBOX_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DROPBOX_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DROPBOX_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DROPBOX_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DROPBOX_COMPONENT_AUTOWIRED_ENABLED_DOC);
        return conf;
    }
}