/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.couchdb;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelCouchdbSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_COUCHDB_PATH_PROTOCOL_CONF = "camel.source.path.protocol";
    public static final String CAMEL_SOURCE_COUCHDB_PATH_PROTOCOL_DOC = "The protocol to use for communicating with the database. One of: [http] [https]";
    public static final String CAMEL_SOURCE_COUCHDB_PATH_PROTOCOL_DEFAULT = null;
    public static final String CAMEL_SOURCE_COUCHDB_PATH_HOSTNAME_CONF = "camel.source.path.hostname";
    public static final String CAMEL_SOURCE_COUCHDB_PATH_HOSTNAME_DOC = "Hostname of the running couchdb instance";
    public static final String CAMEL_SOURCE_COUCHDB_PATH_HOSTNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_COUCHDB_PATH_PORT_CONF = "camel.source.path.port";
    public static final String CAMEL_SOURCE_COUCHDB_PATH_PORT_DOC = "Port number for the running couchdb instance";
    public static final Integer CAMEL_SOURCE_COUCHDB_PATH_PORT_DEFAULT = 5984;
    public static final String CAMEL_SOURCE_COUCHDB_PATH_DATABASE_CONF = "camel.source.path.database";
    public static final String CAMEL_SOURCE_COUCHDB_PATH_DATABASE_DOC = "Name of the database to use";
    public static final String CAMEL_SOURCE_COUCHDB_PATH_DATABASE_DEFAULT = null;
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_CREATE_DATABASE_CONF = "camel.source.endpoint.createDatabase";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_CREATE_DATABASE_DOC = "Creates the database if it does not already exist";
    public static final Boolean CAMEL_SOURCE_COUCHDB_ENDPOINT_CREATE_DATABASE_DEFAULT = false;
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_COUCHDB_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_DELETES_CONF = "camel.source.endpoint.deletes";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_DELETES_DOC = "Document deletes are published as events";
    public static final Boolean CAMEL_SOURCE_COUCHDB_ENDPOINT_DELETES_DEFAULT = true;
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_HEARTBEAT_CONF = "camel.source.endpoint.heartbeat";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_HEARTBEAT_DOC = "How often to send an empty message to keep socket alive in millis";
    public static final Long CAMEL_SOURCE_COUCHDB_ENDPOINT_HEARTBEAT_DEFAULT = 30000L;
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_SINCE_CONF = "camel.source.endpoint.since";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_SINCE_DOC = "Start tracking changes immediately after the given update sequence. The default, null, will start monitoring from the latest sequence.";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_SINCE_DEFAULT = null;
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_STYLE_CONF = "camel.source.endpoint.style";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_STYLE_DOC = "Specifies how many revisions are returned in the changes array. The default, main_only, will only return the current winning revision; all_docs will return all leaf revisions (including conflicts and deleted former conflicts.) One of: [all_docs] [main_only]";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_STYLE_DEFAULT = "main_only";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_UPDATES_CONF = "camel.source.endpoint.updates";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_UPDATES_DOC = "Document inserts/updates are published as events";
    public static final Boolean CAMEL_SOURCE_COUCHDB_ENDPOINT_UPDATES_DEFAULT = true;
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_PASSWORD_CONF = "camel.source.endpoint.password";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_PASSWORD_DOC = "Password for authenticated databases";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_USERNAME_CONF = "camel.source.endpoint.username";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_USERNAME_DOC = "Username in case of authenticated databases";
    public static final String CAMEL_SOURCE_COUCHDB_ENDPOINT_USERNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_COUCHDB_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.couchdb.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_COUCHDB_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_COUCHDB_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_COUCHDB_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.couchdb.autowiredEnabled";
    public static final String CAMEL_SOURCE_COUCHDB_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_COUCHDB_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;

    public CamelCouchdbSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelCouchdbSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_COUCHDB_PATH_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_COUCHDB_PATH_PROTOCOL_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_COUCHDB_PATH_PROTOCOL_DOC);
        conf.define(CAMEL_SOURCE_COUCHDB_PATH_HOSTNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_COUCHDB_PATH_HOSTNAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_COUCHDB_PATH_HOSTNAME_DOC);
        conf.define(CAMEL_SOURCE_COUCHDB_PATH_PORT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_COUCHDB_PATH_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_COUCHDB_PATH_PORT_DOC);
        conf.define(CAMEL_SOURCE_COUCHDB_PATH_DATABASE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_COUCHDB_PATH_DATABASE_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_COUCHDB_PATH_DATABASE_DOC);
        conf.define(CAMEL_SOURCE_COUCHDB_ENDPOINT_CREATE_DATABASE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_COUCHDB_ENDPOINT_CREATE_DATABASE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_COUCHDB_ENDPOINT_CREATE_DATABASE_DOC);
        conf.define(CAMEL_SOURCE_COUCHDB_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_COUCHDB_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_COUCHDB_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_COUCHDB_ENDPOINT_DELETES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_COUCHDB_ENDPOINT_DELETES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_COUCHDB_ENDPOINT_DELETES_DOC);
        conf.define(CAMEL_SOURCE_COUCHDB_ENDPOINT_HEARTBEAT_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_COUCHDB_ENDPOINT_HEARTBEAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_COUCHDB_ENDPOINT_HEARTBEAT_DOC);
        conf.define(CAMEL_SOURCE_COUCHDB_ENDPOINT_SINCE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_COUCHDB_ENDPOINT_SINCE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_COUCHDB_ENDPOINT_SINCE_DOC);
        conf.define(CAMEL_SOURCE_COUCHDB_ENDPOINT_STYLE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_COUCHDB_ENDPOINT_STYLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_COUCHDB_ENDPOINT_STYLE_DOC);
        conf.define(CAMEL_SOURCE_COUCHDB_ENDPOINT_UPDATES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_COUCHDB_ENDPOINT_UPDATES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_COUCHDB_ENDPOINT_UPDATES_DOC);
        conf.define(CAMEL_SOURCE_COUCHDB_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_COUCHDB_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_COUCHDB_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_COUCHDB_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_COUCHDB_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_COUCHDB_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_COUCHDB_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_COUCHDB_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_COUCHDB_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_COUCHDB_ENDPOINT_USERNAME_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_COUCHDB_ENDPOINT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_COUCHDB_ENDPOINT_USERNAME_DOC);
        conf.define(CAMEL_SOURCE_COUCHDB_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_COUCHDB_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_COUCHDB_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_COUCHDB_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_COUCHDB_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_COUCHDB_COMPONENT_AUTOWIRED_ENABLED_DOC);
        return conf;
    }
}