/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.bean;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelBeanSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_BEAN_PATH_BEAN_NAME_CONF = "camel.sink.path.beanName";
    public static final String CAMEL_SINK_BEAN_PATH_BEAN_NAME_DOC = "Sets the name of the bean to invoke";
    public static final String CAMEL_SINK_BEAN_PATH_BEAN_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_BEAN_ENDPOINT_CACHE_CONF = "camel.sink.endpoint.cache";
    public static final String CAMEL_SINK_BEAN_ENDPOINT_CACHE_DOC = "Use scope option instead.";
    public static final String CAMEL_SINK_BEAN_ENDPOINT_CACHE_DEFAULT = null;
    public static final String CAMEL_SINK_BEAN_ENDPOINT_METHOD_CONF = "camel.sink.endpoint.method";
    public static final String CAMEL_SINK_BEAN_ENDPOINT_METHOD_DOC = "Sets the name of the method to invoke on the bean";
    public static final String CAMEL_SINK_BEAN_ENDPOINT_METHOD_DEFAULT = null;
    public static final String CAMEL_SINK_BEAN_ENDPOINT_SCOPE_CONF = "camel.sink.endpoint.scope";
    public static final String CAMEL_SINK_BEAN_ENDPOINT_SCOPE_DOC = "Scope of bean. When using singleton scope (default) the bean is created or looked up only once and reused for the lifetime of the endpoint. The bean should be thread-safe in case concurrent threads is calling the bean at the same time. When using request scope the bean is created or looked up once per request (exchange). This can be used if you want to store state on a bean while processing a request and you want to call the same bean instance multiple times while processing the request. The bean does not have to be thread-safe as the instance is only called from the same request. When using prototype scope, then the bean will be looked up or created per call. However in case of lookup then this is delegated to the bean registry such as Spring or CDI (if in use), which depends on their configuration can act as either singleton or prototype scope. so when using prototype then this depends on the delegated registry. One of: [Singleton] [Request] [Prototype]";
    public static final String CAMEL_SINK_BEAN_ENDPOINT_SCOPE_DEFAULT = "Singleton";
    public static final String CAMEL_SINK_BEAN_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_BEAN_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_BEAN_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_BEAN_ENDPOINT_PARAMETERS_CONF = "camel.sink.endpoint.parameters";
    public static final String CAMEL_SINK_BEAN_ENDPOINT_PARAMETERS_DOC = "Used for configuring additional properties on the bean";
    public static final String CAMEL_SINK_BEAN_ENDPOINT_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SINK_BEAN_COMPONENT_CACHE_CONF = "camel.component.bean.cache";
    public static final String CAMEL_SINK_BEAN_COMPONENT_CACHE_DOC = "Use singleton option instead.";
    public static final String CAMEL_SINK_BEAN_COMPONENT_CACHE_DEFAULT = "true";
    public static final String CAMEL_SINK_BEAN_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.bean.lazyStartProducer";
    public static final String CAMEL_SINK_BEAN_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_BEAN_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_BEAN_COMPONENT_SCOPE_CONF = "camel.component.bean.scope";
    public static final String CAMEL_SINK_BEAN_COMPONENT_SCOPE_DOC = "Scope of bean. When using singleton scope (default) the bean is created or looked up only once and reused for the lifetime of the endpoint. The bean should be thread-safe in case concurrent threads is calling the bean at the same time. When using request scope the bean is created or looked up once per request (exchange). This can be used if you want to store state on a bean while processing a request and you want to call the same bean instance multiple times while processing the request. The bean does not have to be thread-safe as the instance is only called from the same request. When using delegate scope, then the bean will be looked up or created per call. However in case of lookup then this is delegated to the bean registry such as Spring or CDI (if in use), which depends on their configuration can act as either singleton or prototype scope. so when using prototype then this depends on the delegated registry. One of: [Singleton] [Request] [Prototype]";
    public static final String CAMEL_SINK_BEAN_COMPONENT_SCOPE_DEFAULT = "Singleton";
    public static final String CAMEL_SINK_BEAN_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.bean.autowiredEnabled";
    public static final String CAMEL_SINK_BEAN_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_BEAN_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;

    public CamelBeanSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelBeanSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_BEAN_PATH_BEAN_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEAN_PATH_BEAN_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_BEAN_PATH_BEAN_NAME_DOC);
        conf.define(CAMEL_SINK_BEAN_ENDPOINT_CACHE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEAN_ENDPOINT_CACHE_DEFAULT, ConfigDef.Importance.LOW, CAMEL_SINK_BEAN_ENDPOINT_CACHE_DOC);
        conf.define(CAMEL_SINK_BEAN_ENDPOINT_METHOD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEAN_ENDPOINT_METHOD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEAN_ENDPOINT_METHOD_DOC);
        conf.define(CAMEL_SINK_BEAN_ENDPOINT_SCOPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEAN_ENDPOINT_SCOPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEAN_ENDPOINT_SCOPE_DOC);
        conf.define(CAMEL_SINK_BEAN_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_BEAN_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEAN_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_BEAN_ENDPOINT_PARAMETERS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEAN_ENDPOINT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEAN_ENDPOINT_PARAMETERS_DOC);
        conf.define(CAMEL_SINK_BEAN_COMPONENT_CACHE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEAN_COMPONENT_CACHE_DEFAULT, ConfigDef.Importance.LOW, CAMEL_SINK_BEAN_COMPONENT_CACHE_DOC);
        conf.define(CAMEL_SINK_BEAN_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_BEAN_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEAN_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_BEAN_COMPONENT_SCOPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEAN_COMPONENT_SCOPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEAN_COMPONENT_SCOPE_DOC);
        conf.define(CAMEL_SINK_BEAN_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_BEAN_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEAN_COMPONENT_AUTOWIRED_ENABLED_DOC);
        return conf;
    }
}