/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.azureeventhubs;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelAzureeventhubsSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_PATH_NAMESPACE_CONF = "camel.source.path.namespace";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_PATH_NAMESPACE_DOC = "EventHubs namespace created in Azure Portal";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_PATH_NAMESPACE_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_PATH_EVENT_HUB_NAME_CONF = "camel.source.path.eventHubName";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_PATH_EVENT_HUB_NAME_DOC = "EventHubs name under a specific namcespace";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_PATH_EVENT_HUB_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_AMQP_RETRY_OPTIONS_CONF = "camel.source.endpoint.amqpRetryOptions";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_AMQP_RETRY_OPTIONS_DOC = "Sets the retry policy for EventHubAsyncClient. If not specified, the default retry options are used.";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_AMQP_RETRY_OPTIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_AMQP_TRANSPORT_TYPE_CONF = "camel.source.endpoint.amqpTransportType";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_AMQP_TRANSPORT_TYPE_DOC = "Sets the transport type by which all the communication with Azure Event Hubs occurs. Default value is AmqpTransportType#AMQP. One of: [Amqp] [AmqpWebSockets]";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_AMQP_TRANSPORT_TYPE_DEFAULT = "AMQP";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_ACCESS_KEY_CONF = "camel.source.endpoint.blobAccessKey";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_ACCESS_KEY_DOC = "In case you chose the default BlobCheckpointStore, this sets access key for the associated azure account name to be used for authentication with azure blob services";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_ACCESS_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_ACCOUNT_NAME_CONF = "camel.source.endpoint.blobAccountName";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_ACCOUNT_NAME_DOC = "In case you chose the default BlobCheckpointStore, this sets Azure account name to be used for authentication with azure blob services.";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_ACCOUNT_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_CONTAINER_NAME_CONF = "camel.source.endpoint.blobContainerName";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_CONTAINER_NAME_DOC = "In case you chose the default BlobCheckpointStore, this sets the blob container that shall be used by the BlobCheckpointStore to store the checkpoint offsets";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_CONTAINER_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_STORAGE_SHARED_KEY_CREDENTIAL_CONF = "camel.source.endpoint.blobStorageSharedKeyCredential";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_STORAGE_SHARED_KEY_CREDENTIAL_DOC = "In case you chose the default BlobCheckpointStore, StorageSharedKeyCredential can be injected to create the azure client, this holds the important authentication information";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_STORAGE_SHARED_KEY_CREDENTIAL_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CHECKPOINT_STORE_CONF = "camel.source.endpoint.checkpointStore";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CHECKPOINT_STORE_DOC = "Sets the CheckpointStore the EventProcessorClient will use for storing partition ownership and checkpoint information. Users can, optionally, provide their own implementation of CheckpointStore which will store ownership and checkpoint information. By default it set to use com.azure.messaging.eventhubs.checkpointstore.blob.BlobCheckpointStore which stores all checkpoint offsets into Azure Blob Storage";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CHECKPOINT_STORE_DEFAULT = "BlobCheckpointStore";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CONSUMER_GROUP_NAME_CONF = "camel.source.endpoint.consumerGroupName";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CONSUMER_GROUP_NAME_DOC = "Sets the name of the consumer group this consumer is associated with. Events are read in the context of this group. The name of the consumer group that is created by default is {link #DEFAULT_CONSUMER_GROUP_NAME $Default}.";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CONSUMER_GROUP_NAME_DEFAULT = "$Default";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EVENT_POSITION_CONF = "camel.source.endpoint.eventPosition";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EVENT_POSITION_DOC = "Sets the map containing the event position to use for each partition if a checkpoint for the partition does not exist in CheckpointStore. This map is keyed off of the partition id. If there is no checkpoint in CheckpointStore and there is no entry in this map, the processing of the partition will start from {link EventPosition#latest() latest} position.";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EVENT_POSITION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_PREFETCH_COUNT_CONF = "camel.source.endpoint.prefetchCount";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_PREFETCH_COUNT_DOC = "Sets the count used by the receiver to control the number of events the Event Hub consumer will actively receive and queue locally without regard to whether a receive operation is currently active.";
    public static final Integer CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_PREFETCH_COUNT_DEFAULT = 500;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CONNECTION_STRING_CONF = "camel.source.endpoint.connectionString";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CONNECTION_STRING_DOC = "Instead of supplying namespace, sharedAccessKey, sharedAccessName ... etc, you can just supply the connection string for your eventHub. The connection string for EventHubs already include all the necessary information to connection to your EventHub. To learn on how to generate the connection string, take a look at this documentation: https://docs.microsoft.com/en-us/azure/event-hubs/event-hubs-get-connection-string";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CONNECTION_STRING_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_SHARED_ACCESS_KEY_CONF = "camel.source.endpoint.sharedAccessKey";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_SHARED_ACCESS_KEY_DOC = "The generated value for the SharedAccessName";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_SHARED_ACCESS_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_SHARED_ACCESS_NAME_CONF = "camel.source.endpoint.sharedAccessName";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_SHARED_ACCESS_NAME_DOC = "The name you chose for your EventHubs SAS keys";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_SHARED_ACCESS_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AMQP_RETRY_OPTIONS_CONF = "camel.component.azure-eventhubs.amqpRetryOptions";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AMQP_RETRY_OPTIONS_DOC = "Sets the retry policy for EventHubAsyncClient. If not specified, the default retry options are used.";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AMQP_RETRY_OPTIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AMQP_TRANSPORT_TYPE_CONF = "camel.component.azure-eventhubs.amqpTransportType";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AMQP_TRANSPORT_TYPE_DOC = "Sets the transport type by which all the communication with Azure Event Hubs occurs. Default value is AmqpTransportType#AMQP. One of: [Amqp] [AmqpWebSockets]";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AMQP_TRANSPORT_TYPE_DEFAULT = "AMQP";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONFIGURATION_CONF = "camel.component.azure-eventhubs.configuration";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONFIGURATION_DOC = "The component configurations";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_ACCESS_KEY_CONF = "camel.component.azure-eventhubs.blobAccessKey";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_ACCESS_KEY_DOC = "In case you chose the default BlobCheckpointStore, this sets access key for the associated azure account name to be used for authentication with azure blob services";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_ACCESS_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_ACCOUNT_NAME_CONF = "camel.component.azure-eventhubs.blobAccountName";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_ACCOUNT_NAME_DOC = "In case you chose the default BlobCheckpointStore, this sets Azure account name to be used for authentication with azure blob services.";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_ACCOUNT_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_CONTAINER_NAME_CONF = "camel.component.azure-eventhubs.blobContainerName";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_CONTAINER_NAME_DOC = "In case you chose the default BlobCheckpointStore, this sets the blob container that shall be used by the BlobCheckpointStore to store the checkpoint offsets";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_CONTAINER_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_STORAGE_SHARED_KEY_CREDENTIAL_CONF = "camel.component.azure-eventhubs.blobStorageSharedKeyCredential";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_STORAGE_SHARED_KEY_CREDENTIAL_DOC = "In case you chose the default BlobCheckpointStore, StorageSharedKeyCredential can be injected to create the azure client, this holds the important authentication information";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_STORAGE_SHARED_KEY_CREDENTIAL_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.azure-eventhubs.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CHECKPOINT_STORE_CONF = "camel.component.azure-eventhubs.checkpointStore";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CHECKPOINT_STORE_DOC = "Sets the CheckpointStore the EventProcessorClient will use for storing partition ownership and checkpoint information. Users can, optionally, provide their own implementation of CheckpointStore which will store ownership and checkpoint information. By default it set to use com.azure.messaging.eventhubs.checkpointstore.blob.BlobCheckpointStore which stores all checkpoint offsets into Azure Blob Storage";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CHECKPOINT_STORE_DEFAULT = "BlobCheckpointStore";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONSUMER_GROUP_NAME_CONF = "camel.component.azure-eventhubs.consumerGroupName";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONSUMER_GROUP_NAME_DOC = "Sets the name of the consumer group this consumer is associated with. Events are read in the context of this group. The name of the consumer group that is created by default is {link #DEFAULT_CONSUMER_GROUP_NAME $Default}.";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONSUMER_GROUP_NAME_DEFAULT = "$Default";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_EVENT_POSITION_CONF = "camel.component.azure-eventhubs.eventPosition";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_EVENT_POSITION_DOC = "Sets the map containing the event position to use for each partition if a checkpoint for the partition does not exist in CheckpointStore. This map is keyed off of the partition id. If there is no checkpoint in CheckpointStore and there is no entry in this map, the processing of the partition will start from {link EventPosition#latest() latest} position.";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_EVENT_POSITION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_PREFETCH_COUNT_CONF = "camel.component.azure-eventhubs.prefetchCount";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_PREFETCH_COUNT_DOC = "Sets the count used by the receiver to control the number of events the Event Hub consumer will actively receive and queue locally without regard to whether a receive operation is currently active.";
    public static final Integer CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_PREFETCH_COUNT_DEFAULT = 500;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.azure-eventhubs.autowiredEnabled";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONNECTION_STRING_CONF = "camel.component.azure-eventhubs.connectionString";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONNECTION_STRING_DOC = "Instead of supplying namespace, sharedAccessKey, sharedAccessName ... etc, you can just supply the connection string for your eventHub. The connection string for EventHubs already include all the necessary information to connection to your EventHub. To learn on how to generate the connection string, take a look at this documentation: https://docs.microsoft.com/en-us/azure/event-hubs/event-hubs-get-connection-string";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONNECTION_STRING_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_SHARED_ACCESS_KEY_CONF = "camel.component.azure-eventhubs.sharedAccessKey";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_SHARED_ACCESS_KEY_DOC = "The generated value for the SharedAccessName";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_SHARED_ACCESS_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_SHARED_ACCESS_NAME_CONF = "camel.component.azure-eventhubs.sharedAccessName";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_SHARED_ACCESS_NAME_DOC = "The name you chose for your EventHubs SAS keys";
    public static final String CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_SHARED_ACCESS_NAME_DEFAULT = null;

    public CamelAzureeventhubsSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelAzureeventhubsSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_PATH_NAMESPACE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_PATH_NAMESPACE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_PATH_NAMESPACE_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_PATH_EVENT_HUB_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_PATH_EVENT_HUB_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_PATH_EVENT_HUB_NAME_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_AMQP_RETRY_OPTIONS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_AMQP_RETRY_OPTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_AMQP_RETRY_OPTIONS_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_AMQP_TRANSPORT_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_AMQP_TRANSPORT_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_AMQP_TRANSPORT_TYPE_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_ACCESS_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_ACCESS_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_ACCESS_KEY_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_ACCOUNT_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_ACCOUNT_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_ACCOUNT_NAME_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_CONTAINER_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_CONTAINER_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_CONTAINER_NAME_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_STORAGE_SHARED_KEY_CREDENTIAL_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_STORAGE_SHARED_KEY_CREDENTIAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BLOB_STORAGE_SHARED_KEY_CREDENTIAL_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CHECKPOINT_STORE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CHECKPOINT_STORE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CHECKPOINT_STORE_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CONSUMER_GROUP_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CONSUMER_GROUP_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CONSUMER_GROUP_NAME_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EVENT_POSITION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EVENT_POSITION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EVENT_POSITION_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_PREFETCH_COUNT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_PREFETCH_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_PREFETCH_COUNT_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CONNECTION_STRING_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CONNECTION_STRING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_CONNECTION_STRING_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_SHARED_ACCESS_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_SHARED_ACCESS_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_SHARED_ACCESS_KEY_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_SHARED_ACCESS_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_SHARED_ACCESS_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_ENDPOINT_SHARED_ACCESS_NAME_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AMQP_RETRY_OPTIONS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AMQP_RETRY_OPTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AMQP_RETRY_OPTIONS_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AMQP_TRANSPORT_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AMQP_TRANSPORT_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AMQP_TRANSPORT_TYPE_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_ACCESS_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_ACCESS_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_ACCESS_KEY_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_ACCOUNT_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_ACCOUNT_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_ACCOUNT_NAME_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_CONTAINER_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_CONTAINER_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_CONTAINER_NAME_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_STORAGE_SHARED_KEY_CREDENTIAL_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_STORAGE_SHARED_KEY_CREDENTIAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BLOB_STORAGE_SHARED_KEY_CREDENTIAL_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CHECKPOINT_STORE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CHECKPOINT_STORE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CHECKPOINT_STORE_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONSUMER_GROUP_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONSUMER_GROUP_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONSUMER_GROUP_NAME_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_EVENT_POSITION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_EVENT_POSITION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_EVENT_POSITION_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_PREFETCH_COUNT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_PREFETCH_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_PREFETCH_COUNT_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONNECTION_STRING_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONNECTION_STRING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_CONNECTION_STRING_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_SHARED_ACCESS_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_SHARED_ACCESS_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_SHARED_ACCESS_KEY_DOC);
        conf.define(CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_SHARED_ACCESS_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_SHARED_ACCESS_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AZUREEVENTHUBS_COMPONENT_SHARED_ACCESS_NAME_DOC);
        return conf;
    }
}