/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.mongodbgridfs;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelMongodbgridfsSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_MONGODBGRIDFS_PATH_CONNECTION_BEAN_CONF = "camel.source.path.connectionBean";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_PATH_CONNECTION_BEAN_DOC = "Name of com.mongodb.client.MongoClient to use.";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_PATH_CONNECTION_BEAN_DEFAULT = null;
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_BUCKET_CONF = "camel.source.endpoint.bucket";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_BUCKET_DOC = "Sets the name of the GridFS bucket within the database. Default is fs.";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_BUCKET_DEFAULT = "fs";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_DATABASE_CONF = "camel.source.endpoint.database";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_DATABASE_DOC = "Sets the name of the MongoDB database to target";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_DATABASE_DEFAULT = null;
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_READ_PREFERENCE_CONF = "camel.source.endpoint.readPreference";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_READ_PREFERENCE_DOC = "Sets a MongoDB ReadPreference on the Mongo connection. Read preferences set directly on the connection will be overridden by this setting. The com.mongodb.ReadPreference#valueOf(String) utility method is used to resolve the passed readPreference value. Some examples for the possible values are nearest, primary or secondary etc.";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_READ_PREFERENCE_DEFAULT = null;
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_WRITE_CONCERN_CONF = "camel.source.endpoint.writeConcern";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_WRITE_CONCERN_DOC = "Set the WriteConcern for write operations on MongoDB using the standard ones. Resolved from the fields of the WriteConcern class by calling the WriteConcern#valueOf(String) method. One of: [ACKNOWLEDGED] [W1] [W2] [W3] [UNACKNOWLEDGED] [JOURNALED] [MAJORITY]";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_WRITE_CONCERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_DELAY_CONF = "camel.source.endpoint.delay";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_DELAY_DOC = "Sets the delay between polls within the Consumer. Default is 500ms";
    public static final Long CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_DELAY_DEFAULT = 500L;
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_FILE_ATTRIBUTE_NAME_CONF = "camel.source.endpoint.fileAttributeName";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_FILE_ATTRIBUTE_NAME_DOC = "If the QueryType uses a FileAttribute, this sets the name of the attribute that is used. Default is camel-processed.";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_FILE_ATTRIBUTE_NAME_DEFAULT = "camel-processed";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_INITIAL_DELAY_CONF = "camel.source.endpoint.initialDelay";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_INITIAL_DELAY_DOC = "Sets the initialDelay before the consumer will start polling. Default is 1000ms";
    public static final Long CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_INITIAL_DELAY_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_PERSISTENT_TSCOLLECTION_CONF = "camel.source.endpoint.persistentTSCollection";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_PERSISTENT_TSCOLLECTION_DOC = "If the QueryType uses a persistent timestamp, this sets the name of the collection within the DB to store the timestamp.";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_PERSISTENT_TSCOLLECTION_DEFAULT = "camel-timestamps";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_PERSISTENT_TSOBJECT_CONF = "camel.source.endpoint.persistentTSObject";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_PERSISTENT_TSOBJECT_DOC = "If the QueryType uses a persistent timestamp, this is the ID of the object in the collection to store the timestamp.";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_PERSISTENT_TSOBJECT_DEFAULT = "camel-timestamp";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_QUERY_CONF = "camel.source.endpoint.query";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_QUERY_DOC = "Additional query parameters (in JSON) that are used to configure the query used for finding files in the GridFsConsumer";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_QUERY_DEFAULT = null;
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_QUERY_STRATEGY_CONF = "camel.source.endpoint.queryStrategy";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_QUERY_STRATEGY_DOC = "Sets the QueryStrategy that is used for polling for new files. Default is Timestamp One of: [TimeStamp] [PersistentTimestamp] [FileAttribute] [TimeStampAndFileAttribute] [PersistentTimestampAndFileAttribute]";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_QUERY_STRATEGY_DEFAULT = "TimeStamp";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.mongodb-gridfs.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_MONGODBGRIDFS_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.mongodb-gridfs.autowiredEnabled";
    public static final String CAMEL_SOURCE_MONGODBGRIDFS_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_MONGODBGRIDFS_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;

    public CamelMongodbgridfsSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelMongodbgridfsSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_MONGODBGRIDFS_PATH_CONNECTION_BEAN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MONGODBGRIDFS_PATH_CONNECTION_BEAN_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_MONGODBGRIDFS_PATH_CONNECTION_BEAN_DOC);
        conf.define(CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_BUCKET_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_BUCKET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_BUCKET_DOC);
        conf.define(CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_DATABASE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_DATABASE_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_DATABASE_DOC);
        conf.define(CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_READ_PREFERENCE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_READ_PREFERENCE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_READ_PREFERENCE_DOC);
        conf.define(CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_WRITE_CONCERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_WRITE_CONCERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_WRITE_CONCERN_DOC);
        conf.define(CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_DELAY_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_DELAY_DOC);
        conf.define(CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_FILE_ATTRIBUTE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_FILE_ATTRIBUTE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_FILE_ATTRIBUTE_NAME_DOC);
        conf.define(CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_INITIAL_DELAY_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_INITIAL_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_INITIAL_DELAY_DOC);
        conf.define(CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_PERSISTENT_TSCOLLECTION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_PERSISTENT_TSCOLLECTION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_PERSISTENT_TSCOLLECTION_DOC);
        conf.define(CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_PERSISTENT_TSOBJECT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_PERSISTENT_TSOBJECT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_PERSISTENT_TSOBJECT_DOC);
        conf.define(CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_QUERY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_QUERY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_QUERY_DOC);
        conf.define(CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_QUERY_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_QUERY_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_QUERY_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MONGODBGRIDFS_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_MONGODBGRIDFS_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_MONGODBGRIDFS_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MONGODBGRIDFS_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_MONGODBGRIDFS_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_MONGODBGRIDFS_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MONGODBGRIDFS_COMPONENT_AUTOWIRED_ENABLED_DOC);
        return conf;
    }
}