/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.hwcloudiam;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelHwcloudiamSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_AUTHENTICATION_KEY_CONF = "camel.source.endpoint.authenticationKey";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_AUTHENTICATION_KEY_DOC = "Authentication key for the cloud user";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_AUTHENTICATION_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_ENDPOINT_CONF = "camel.source.endpoint.endpoint";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_ENDPOINT_DOC = "IAM endpoint url. Carries higher precedence than region parameter based client initialization";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_ENDPOINT_DEFAULT = null;
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_GROUP_ID_CONF = "camel.source.endpoint.groupId";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_GROUP_ID_DOC = "Group ID to perform operation with";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_GROUP_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_IGNORE_SSL_VERIFICATION_CONF = "camel.source.endpoint.ignoreSslVerification";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_IGNORE_SSL_VERIFICATION_DOC = "Ignore SSL verification";
    public static final Boolean CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_IGNORE_SSL_VERIFICATION_DEFAULT = false;
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_HOST_CONF = "camel.source.endpoint.proxyHost";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_HOST_DOC = "Proxy server ip/hostname";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_HOST_DEFAULT = null;
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_PASSWORD_CONF = "camel.source.endpoint.proxyPassword";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_PASSWORD_DOC = "Proxy authentication password";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_PORT_CONF = "camel.source.endpoint.proxyPort";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_PORT_DOC = "Proxy server port";
    public static final Integer CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_PORT_DEFAULT = null;
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_USER_CONF = "camel.source.endpoint.proxyUser";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_USER_DOC = "Proxy authentication user";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_USER_DEFAULT = null;
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_REGION_CONF = "camel.source.endpoint.region";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_REGION_DOC = "IAM service region. This is lower precedence than endpoint based configuration";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_REGION_DEFAULT = null;
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_SECRET_KEY_CONF = "camel.source.endpoint.secretKey";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_SECRET_KEY_DOC = "Secret key for the cloud user";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_SECRET_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_SERVICE_KEYS_CONF = "camel.source.endpoint.serviceKeys";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_SERVICE_KEYS_DOC = "Configuration object for cloud service authentication";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_SERVICE_KEYS_DEFAULT = null;
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_USER_ID_CONF = "camel.source.endpoint.userId";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_USER_ID_DOC = "User ID to perform operation with";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_USER_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_HWCLOUDIAM_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.hwcloud-iam.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_HWCLOUDIAM_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_HWCLOUDIAM_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.hwcloud-iam.autowiredEnabled";
    public static final String CAMEL_SOURCE_HWCLOUDIAM_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_HWCLOUDIAM_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;

    public CamelHwcloudiamSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelHwcloudiamSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_AUTHENTICATION_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_AUTHENTICATION_KEY_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_AUTHENTICATION_KEY_DOC);
        conf.define(CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_ENDPOINT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_ENDPOINT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_ENDPOINT_DOC);
        conf.define(CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_GROUP_ID_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_GROUP_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_GROUP_ID_DOC);
        conf.define(CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_IGNORE_SSL_VERIFICATION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_IGNORE_SSL_VERIFICATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_IGNORE_SSL_VERIFICATION_DOC);
        conf.define(CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_HOST_DOC);
        conf.define(CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_PORT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_PORT_DOC);
        conf.define(CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_USER_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_USER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_PROXY_USER_DOC);
        conf.define(CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_REGION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_REGION_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_REGION_DOC);
        conf.define(CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_SECRET_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_SECRET_KEY_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_SECRET_KEY_DOC);
        conf.define(CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_SERVICE_KEYS_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_SERVICE_KEYS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_SERVICE_KEYS_DOC);
        conf.define(CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_USER_ID_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_USER_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_USER_ID_DOC);
        conf.define(CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_HWCLOUDIAM_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_HWCLOUDIAM_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_HWCLOUDIAM_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_HWCLOUDIAM_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_HWCLOUDIAM_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_HWCLOUDIAM_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_HWCLOUDIAM_COMPONENT_AUTOWIRED_ENABLED_DOC);
        return conf;
    }
}